#ifndef MODULE_REGISTRY_H
#define MODULE_REGISTRY_H

#include "moduleinfo.h"

#include <map>
#include <string>
using namespace std;

class ModuleRegistry
{
public:
        void add_module(const string& name, const ModuleInfo &m) {
                storage[name] = m;
        }

        void add_module(const string& name, ModuleInfo::ModuleConstructor* c, const DataSetMap& modInf) {
                add_module(name, ModuleInfo(c, modInf));
        }

        void remove_module(const string& name) {
                assert(storage.count(name) > 0); // valid index
                storage.erase(storage.find(name));
        }                

        bool valid_module_name(const string& name) const {
                return storage.count(name) > 0;
        }               

        const ModuleInfo& module_info(const string& name) const {
                assert(valid_module_name(name));
                return storage.find(name)->second;
        }

        int module_count() const {
                return storage.size();
        }

        const string& module_name(int index) const {
                map<string, ModuleInfo>::const_iterator i = storage.begin();
                for (int j = 0; j < index; j++)
                        i++;
                return i->first;
        }                

        static ModuleRegistry* instance() {
                if (!instance_) {
                        rpdbgmsg("Creating ModuleRegistry");
                        instance_ = new ModuleRegistry();
                }
                return instance_;
        }

        static void destroy_instance() {
                if (instance_) {
                        rpdbgmsg("Destroying ModuleRegistry");
                        delete instance_;
                }
                instance_ = 0;
        }
                        
private:
        map<string, ModuleInfo> storage;
        static ModuleRegistry *instance_;
};

#endif
