#include "drawing_area_registry.h"
#include "drawing_area.h"

#include <algorithm>
using namespace std;

DrawingAreaRegistry *DrawingAreaRegistry::instancep = NULL;
        
void DrawingAreaRegistry::exposed(XExposeEvent *ex)
{
        for (vector<DrawingArea *>::iterator i = das.begin();
             i < das.end(); i++) {
                if ((*i)->intersects_with_exposed_area(ex))
                        (*i)->redraw(ex);
        }
}

void DrawingAreaRegistry::register_da(DrawingArea *da)
{
        das.push_back(da);
}

void DrawingAreaRegistry::unregister_da(DrawingArea *da)
{
        das.erase(find(das.begin(), das.end(), da));
}
