#include "../module_tree.h"
#include "tableentry.h"

static void moreClicked(GtkButton* widget, TableEntry* data)
{
        data->addRow();
}

static void lessClicked(GtkButton* widget, TableEntry* data)
{
        data->removeRow();
}

TableEntry::TableEntry(const string& varName, const Path& mod_, ModifierEntryListener& parent_, bool owner)
        : ModifierEntry(varName, mod_, parent_, owner)
{
        try {
                const DataSetMap *m = ModuleTree::instance()->module_info(mod);
                assert(m != NULL);
                const DataSetMap& mInf = *m;
        
                string t = "table_" + varName + "_col_names";
                assert(mInf.validIndex(t));
                const DataSet& colNames = mInf[t];
                numCols = colNames.count();
        
                t = "table_" + varName + "_col_types";
                assert(mInf.validIndex(t));
                colTypes = mInf[t];
                assert(colTypes.count() == numCols);

                GtkWidget* moreButton = gtk_button_new_with_label("More");
                GtkWidget* lessButton = gtk_button_new_with_label("Less");
                gtk_signal_connect(GTK_OBJECT(moreButton), "clicked", GTK_SIGNAL_FUNC(moreClicked), this);
                gtk_signal_connect(GTK_OBJECT(lessButton), "clicked", GTK_SIGNAL_FUNC(lessClicked), this);
                gtk_box_pack_start(GTK_BOX(hbox), moreButton, false, false, 3);
                gtk_box_pack_start(GTK_BOX(hbox), lessButton, false, false, 3);

                GtkWidget* headingLine = gtk_hbox_new(false, 0);
                for (int i = 0; i < numCols; i++) {
                        GtkWidget* label = gtk_label_new(colNames.getString(i).c_str());
                        gtk_box_pack_start(GTK_BOX(headingLine), label, true, true, 3);
                }

                gtk_box_pack_start(GTK_BOX(vbox), headingLine, false, false, 3);
                reload();
        } catch (ModuleError ex) {
                cerr << "Module exception: " << ex.description << endl;
        }
}

void TableEntry::addRow()
{
        GtkWidget* hb = gtk_hbox_new(false, 0);
        for (int i = 0; i < numCols; i++) {
                ModifierEntry* e = ModifierEntry::createByTypeName(colTypes.getString(i), "", mod, parent, true);
                gtk_box_pack_start(GTK_BOX(hb), e->getWidget(), true, true, 1);
                entries.push_back(e);
        }
        hboxes.push_back(hb);
        gtk_box_pack_start(GTK_BOX(vbox), hb, true, true, 1);
        gtk_widget_show_all(hb);
}

// if r == -1, remove the last row
void TableEntry::removeRow(int r)
{
        if (r == -1)
                r = hboxes.size() - 1;
        if (r >= 0) {
                gtk_container_remove(GTK_CONTAINER(vbox), hboxes[r]);

                for (int i = 0; i < numCols; i++)
                        delete entries[r * numCols + i];
                
                vector<ModifierEntry*>::iterator start = entries.begin();
                vector<ModifierEntry*>::iterator end = entries.begin();
                start += r * numCols;
                end += (r + 1) * numCols;
                entries.erase(start, end);
                
                vector<GtkWidget*>::iterator e = hboxes.begin();
                e += r;
                hboxes.erase(e);
        }
}

DataSet TableEntry::getValue()
{
        DataSet newValue;
        for (unsigned int i = 0; i < entries.size(); i++) {
                const DataSet& v = entries[i]->getValue();
                newValue.add(v[0]);
        }
        return newValue;
}

void TableEntry::setValue(const DataSet& value)
{
        for (int i = 0; i < value.count(); i++) {
                if (i >= int(entries.size()))
                        addRow();
                DataSet v;
                v.add(value[i]);
                entries[i]->setValue(v);
        }
}
