#include "fileentry.h"

static void entryChanged(GtkEditable* widget, FileEntry* data)
{
        data->changed();
}

FileEntry::FileEntry(const string& varName, const Path& mod_, ModifierEntryListener& parent_, bool owner)
        : ModifierEntry(varName, mod_, parent_, owner)
{
        GtkWidget* fileEntry = gnome_file_entry_new(0, const_cast<gchar*> ("Select a file"));
        valueWidget = gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(fileEntry));
        gtk_signal_connect(GTK_OBJECT(valueWidget), "changed", GTK_SIGNAL_FUNC(entryChanged), this);
        reload();
        gtk_box_pack_start(GTK_BOX(hbox), fileEntry, false, false, 3);
        gtk_widget_show(fileEntry);
}

DataSet FileEntry::getValue()
{
        string newValue(gtk_entry_get_text(GTK_ENTRY(valueWidget)));
        DataSet tmp;
        tmp.addString(newValue);
        return tmp;
}

void FileEntry::setValue(const DataSet& value)
{
        gtk_entry_set_text(GTK_ENTRY(valueWidget), const_cast<gchar*> (value.toString().c_str()));
}
