#include "root-portal.h"
#include "base_node.h"
#include "module_registry.h"

DataSetMap *BaseNode::moduleInfo = 0;

BaseNode::~BaseNode() {
        rpdbgmsg(getName() << " module destroyed");
}

const DataSetMap& BaseNode::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("The base node"));
                moduleInfo->set("supported_vars", DataSet());
                moduleInfo->set("supported_var_types", DataSet());
                moduleInfo->set("supported_var_defaults", DataSet());
                moduleInfo->set("overridable", DataSet());
        }
        return *moduleInfo;
}

Module* basenode_constructor()
{
        return new BaseNode();
}

int base_node_plugin_startup()
{
        ModuleRegistry::instance()->add_module("Root-Portal", &basenode_constructor, BaseNode::get_module_info_instance());
        return 0;
}

void base_node_plugin_shutdown()
{
        ModuleRegistry::instance()->remove_module("Root-Portal");
        BaseNode::destroy_module_info();
}
        
void BaseNode::updated(const string& keyName, const DataSet& data)
{
        if (slave_mode) {
                cout << "U" << keyName << "=" << data << endl;
        }
}

void BaseNode::return_message(const DataSet& msg, Path path)
{
        if (slave_mode) {
                cout << "M" << path.to_string() << msg.asString() << endl;
        }
        ModuleTree::instance()->return_message(msg, path);
}
