 /* 
 * ------------------------------------------------------------------
 * Role PlayingDB V2.0 by Deepwoods Software
 * ------------------------------------------------------------------
 * Dressings.cc - Dressings -- various things that are scattered about the
 * place.
 * Created by Robert Heller on Tue Aug  4 13:07:38 1998
 * ------------------------------------------------------------------
 * Modification History: 
 * $Log: Dressings.cc,v $
 * Revision 1.2  1998/12/30 01:04:49  heller
 * Add comments to the code.
 *
 * Revision 1.1  1998/08/21 14:58:33  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing DB -- A database package that creates and maintains
 * 		       a database of RPG characters, monsters, treasures,
 * 		       spells, and playing environments.
 * 
 *     Copyright (C) 1995,1998  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#include <Dressings.h>
#include <stdio.h>

static char rcsid[] = "$Id: Dressings.cc,v 1.2 1998/12/30 01:04:49 heller Rel1 $";

void Treasure::RecordToTreasure()
{
	register char* str = rawData.buffer;	// Data string
	register int   bytesleft = rawData.size; // Number of bytes

	name = NULL;
	descr = NULL;
	image = NULL;
	weight = 0;
	aCAdj = 0;
	toHitAdj = 0;
	damAdj = 0;
	magResAdj = 0;
	damProtAdj = 0;
	sAdj = 0;
	iAdj = 0;
	wAdj = 0;
	dAdj = 0;
	cAdj = 0;
	chAdj = 0;
	gAdj = 0;
	fAdj = 0;
	swAdj = 0;
	value = 0;
	// while bytes remain...
	while (bytesleft > 0) {
		// scan for field specifier
		while (*str != '%' && bytesleft > 0) { str++; bytesleft--; }
		// skip over specified prefix
		str++; bytesleft--;
		// while there still are bytes...
		if (bytesleft <= 0) break;
		// fan out based on field key
		switch (*str++) {
			case 'n': name = str; break;
			case 'C': descr = str; break;
			case 'I': image = str; break;
			case 'W': weight = atol(str); break;
			case 'A': aCAdj = atol(str); break;
			case 'T': toHitAdj = atol(str); break;
			case 'D': damAdj = atol(str); break;
			case 'M': magResAdj = atol(str); break;
			case 'P': damProtAdj = atol(str); break;
			case 's': sAdj = atol(str); break;
			case 'i': iAdj = atol(str); break;
			case 'w': wAdj = atol(str); break;
			case 'd': dAdj = atol(str); break;
			case 'c': cAdj = atol(str); break;
			case 'h': chAdj = atol(str); break;
			case 'm': gAdj = atol(str); break;
			case 'f': fAdj = atol(str); break;
			case 'S': swAdj = atol(str); break;
			case 'v': value = atol(str); break;
		}
		// count specifier
		bytesleft--;
		// find strlen plus nul byte
		int slen = strlen(str) + 1;
		// update counter and pointer
		bytesleft -= slen;
		str += slen;
		// EOR marker?
		if (*str == '\n') break;
	}
}

void Treasure::UpdateRecord()
{
	static char weightS[12], aCAdjS[12], toHitAdjS[12], damAdjS[12],
		    magResAdjS[12], damProtAdjS[12], sAdjS[12], iAdjS[12],
		    wAdjS[12], dAdjS[12], cAdjS[12], chAdjS[12], gAdjS[12],
		    fAdjS[12], swAdjS[12], valueS[12];
	// form numeric strings
	sprintf(weightS,"%d",weight);
	sprintf(aCAdjS,"%d",aCAdj);
	sprintf(toHitAdjS,"%d",toHitAdj);
	sprintf(damAdjS,"%d",damAdj);
	sprintf(magResAdjS,"%d",magResAdj);
	sprintf(damProtAdjS,"%d",damProtAdj);
	sprintf(sAdjS,"%d",sAdj);
	sprintf(iAdjS,"%d",iAdj);
	sprintf(wAdjS,"%d",wAdj);
	sprintf(dAdjS,"%d",dAdj);
	sprintf(cAdjS,"%d",cAdj);
	sprintf(chAdjS,"%d",chAdj);
	sprintf(gAdjS,"%d",gAdj);
	sprintf(fAdjS,"%d",fAdj);
	sprintf(swAdjS,"%d",swAdj);
	sprintf(valueS,"%d",value);
	int rsize = 10 + 		  // "*Treasure\0"
		strlen(weightS) + 3 +     // "%Wnnn\0"
		strlen(aCAdjS) + 3 +      // "%Annn\0"
		strlen(toHitAdjS) + 3 +   // "%Tnnn\0"
		strlen(damAdjS) + 3 +     // "%Dnnn\0"
		strlen(magResAdjS) + 3 +  // "%Mnnn\0"
		strlen(damProtAdjS) + 3 + // "%Pnnn\0"
		strlen(sAdjS) + 3 +       // "%snnn\0"
		strlen(iAdjS) + 3 +       // "%innn\0"
		strlen(wAdjS) + 3 +       // "%wnnn\0"
		strlen(dAdjS) + 3 +       // "%dnnn\0"
		strlen(cAdjS) + 3 +       // "%cnnn\0"
		strlen(chAdjS) + 3 +      // "%hnnn\0"
		strlen(gAdjS) + 3 +       // "%mnnn\0"
		strlen(fAdjS) + 3 +       // "%fnnn\0"
		strlen(swAdjS) + 3 +      // "%Snnn\0"
		strlen(valueS) + 3 +      // "%vnnn\0"
		((name)?(strlen(name)):(0)) + 3 +   // "%nxxx\0"
		((descr)?(strlen(descr)):(0)) + 3 + // "%Cxxx\0"
		((image)?(strlen(image)):(0)) + 3 + // "%Ixxx\0"
		strlen("\n") + 1;               // "\n\0"
	// allocate a string
	char* str = new char[rsize]; char* p = str;
	strcpy(p,"*Treasure"); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'W'; strcpy(p,weightS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'A'; strcpy(p,aCAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'T'; strcpy(p,toHitAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'D'; strcpy(p,damAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'M'; strcpy(p,magResAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'P'; strcpy(p,damProtAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 's'; strcpy(p,sAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'i'; strcpy(p,iAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'w'; strcpy(p,wAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'd'; strcpy(p,dAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'c'; strcpy(p,cAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'h'; strcpy(p,chAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'm'; strcpy(p,gAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'f'; strcpy(p,fAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'S'; strcpy(p,swAdjS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'v'; strcpy(p,valueS); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'n'; if (name) strcpy(p,name); else strcpy(p,""); name = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'C'; if (descr) strcpy(p,descr); else strcpy(p,""); descr = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'I'; if (image) strcpy(p,image); else strcpy(p,""); image = p;p += strlen(p) + 1;
	*p++ = '\n'; *p++ = 0;
	// free up old buffer
	rawData.NewBuffer(0);
	// paste in new buffer
	rawData.size = rsize;
	rawData.buffer = str;
}

void TrickTrap::RecordToTrickTrap()
{
	register char* str = rawData.buffer;	// Data string
	register int   bytesleft = rawData.size; // Number of bytes

	name = NULL;
	tttype = NULL;
	descr = NULL;
	image = NULL;
	// while bytes remain...
	while (bytesleft > 0) {
		// scan for field specifier
		while (*str != '%' && bytesleft > 0) { str++; bytesleft--; }
		// skip over specified prefix
		str++; bytesleft--;
		// while there still are bytes...
		if (bytesleft <= 0) break;
		// fan out based on field key
		switch (*str++) {
			case 'n': name = str; break;
			case 'T': tttype = str; break;
			case 'C': descr = str; break;
			case 'I': image = str; break;
		}
		// count specifier
		bytesleft--;
		// find strlen plus nul byte
		int slen = strlen(str) + 1;
		// update counter and pointer
		bytesleft -= slen;
		str += slen;
		// EOR marker?
		if (*str == '\n') break;
	}
}

void TrickTrap::UpdateRecord()
{
	int rsize = 11 + 		  // "*TrickTrap\0"
		((name)?(strlen(name)):(0)) + 3 +   // "%nxxx\0"
		((tttype)?(strlen(tttype)):(0)) + 3 + // "%Txxx\0"
		((descr)?(strlen(descr)):(0)) + 3 + // "%Cxxx\0"
		((image)?(strlen(image)):(0)) + 3 + // "%Ixxx\0"
		strlen("\n") + 1;               // "\n\0"
	// allocate a string
	char* str = new char[rsize]; char* p = str;
	strcpy(p,"*TrickTrap"); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'n'; if (name) strcpy(p,name); else strcpy(p,""); name = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'T'; if (tttype) strcpy(p,tttype); else strcpy(p,""); tttype = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'C'; if (descr) strcpy(p,descr); else strcpy(p,""); descr = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'I'; if (image) strcpy(p,image); else strcpy(p,""); image = p;p += strlen(p) + 1;
	*p++ = '\n'; *p++ = 0;
	// free up old buffer
	rawData.NewBuffer(0);
	// paste in new buffer
	rawData.size = rsize;
	rawData.buffer = str;
}

void Dressing::RecordToDressing()
{
	register char* str = rawData.buffer;	// Data string
	register int   bytesleft = rawData.size; // Number of bytes

	name = NULL;
	value = 0;
	descr = NULL;
	image = NULL;
	// while bytes remain...
	while (bytesleft > 0) {
		// scan for field specifier
		while (*str != '%' && bytesleft > 0) { str++; bytesleft--; }
		// skip over specified prefix
		str++; bytesleft--;
		// while there still are bytes...
		if (bytesleft <= 0) break;
		// fan out based on field key
		switch (*str++) {
			case 'n': name = str; break;
			case 'v': value = atol(str); break;
			case 'C': descr = str; break;
			case 'I': image = str; break;
		}
		// count specifier
		bytesleft--;
		// find strlen plus nul byte
		int slen = strlen(str) + 1;
		// update counter and pointer
		bytesleft -= slen;
		str += slen;
		// EOR marker?
		if (*str == '\n') break;
	}
}

void Dressing::UpdateRecord()
{
	static char valueS[12];
	sprintf(valueS,"%d",value);
	int rsize = 10 + 		  // "*Dressing\0"
		((name)?(strlen(name)):(0)) + 3 +   // "%nxxx\0"
		(strlen(valueS)) + 3 + // "%vxxx\0"
		((descr)?(strlen(descr)):(0)) + 3 + // "%Cxxx\0"
		((image)?(strlen(image)):(0)) + 3 + // "%Ixxx\0"
		strlen("\n") + 1;               // "\n\0"
	// allocate a string
	char* str = new char[rsize]; char* p = str;
	strcpy(p,"*Dressing"); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'n'; if (name) strcpy(p,name); else strcpy(p,""); name = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'v'; strcpy(p,valueS);p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'C'; if (descr) strcpy(p,descr); else strcpy(p,""); descr = p;p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'I'; if (image) strcpy(p,image); else strcpy(p,""); image = p;p += strlen(p) + 1;
	*p++ = '\n'; *p++ = 0;
	// free up old buffer
	rawData.NewBuffer(0);
	// paste in new buffer
	rawData.size = rsize;
	rawData.buffer = str;
}

