/* -*- Mode: C; c-file-style: "k&r"; -*-*/

/* parser.h
 *    file parser. definitions and declarations.
 *
 * $Id: parser.h,v 1.8 2000/10/29 22:41:23 antoine Exp $
 *
 * Copyright (C) 2000,
 *     Antoine Lefebvre <antoine.lefebvre@polymtl.ca>
 *     Remi Lefebvre <remi@debian.org>
 *
 * gpcp is free software; you can redistribute them and/or modify them
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 */

#ifndef __parser_h__
#define __parser_h__

#include <stdio.h>

/*
 * (struct) Options   -- properties of valid options
 * (struct) Functions -- specific structure for type 'function' -- FIXME
 *
 * (struct) Data      -- holds actual data
 *  (struct) Keywords  -- name, type and value of a keyword
 *   (enum)   Types     -- possible types of data in config file
 *   (union)  Value     -- value of a Data member
 */
 
/* forward declaration */
struct keyword;

typedef enum types
{
     STRING   = 0,
     FLOAT    = 1,
     INTEGER  = 2,
     BOOLEAN  = 3,
     PARENT   = 4,
     FUNCTION = 5
} Types;

/* struct use to register keywords */
typedef struct options
{
     char *keyword;
     Types type;
     char *parent;
} Options;

/* struct use to register functions */
typedef struct functions
{
     char *function_name;
     Types return_type;
     
} Functions;

/* structure for data */
typedef struct data
{
     int n_key;
     struct keyword *key_list;
     /* state pointers */
     struct data *prev;
     struct keyword *parent;
} Data;

/* Depending on the type of the keyword,
   different value could be stored */
typedef union value
{
     char  *string;
     float *number;
     int   *integer;
     short *boolean;
     Data  *subdata;
     void (*function) (void *);
     
} Value;

/* A keyword have a name, a type and a value */
typedef struct keyword
{
     char *name;
     Types type;
     Value val;
} Keywords;

/* state structure */
typedef struct GPCP_state
{
     int level;
     Data *data;
} GPCP_State;

/* parser state */
#define PARSER_MAIN 1
#define PARSER_KEY 2
#define PARSER_EQU 3
#define PARSER_SUB 4
#define PARSER_INSUB 5

#define MAX_BUF 256

int get_keyword(FILE *fd, char *buffer, int len);
int parse_file(FILE *fd, Data *data);
int get_equal(FILE *fd);
int check_key(char *buffer, char *parent, Types *t);
int add_keyword(Data *data, char *buf);
int add_value(Data *data, char *buf, Types keytype, Types type);

extern Options *options;
extern Functions *functions;

#endif /* __parser_h__ */

