//mainloop-threaded.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2012
 *  The code (may) include prototypes and comments (and maybe
 *  other code fragements) from libpulse*. They are mostly copyrighted by:
 *  Lennart Poettering <poettering@users.sourceforge.net> and
 *  Pierre Ossman <drzeus@drzeus.cx>
 *
 *  This file is part of libroarpulse a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this libroar
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#include <libroarpulse/libroarpulse.h>

struct pa_threaded_mainloop {
 pa_mainloop_api api;
 int started;
 size_t lockc;
 int retval;
};

static void __quit(pa_mainloop_api*a, int retval) {
 pa_threaded_mainloop * m = a->userdata;
 m->retval = retval;
 pa_threaded_mainloop_stop(m);
}

static const pa_mainloop_api __api = {
 .quit = __quit
};

pa_threaded_mainloop *pa_threaded_mainloop_new(void) {
 pa_threaded_mainloop * ret = roar_mm_malloc(sizeof(pa_threaded_mainloop));
 if ( ret == NULL ) {
  // handle errors here.
  return NULL;
 }

 memset(ret, 0, sizeof(pa_threaded_mainloop));

 ret->api = __api;
 ret->api.userdata = ret;

 return ret;
}

void pa_threaded_mainloop_free(pa_threaded_mainloop* m) {
 if ( m == NULL )
  return;

 roar_mm_free(m);
}

int pa_threaded_mainloop_start(pa_threaded_mainloop *m) {
 m->started = 1;
 return 0;
}

void pa_threaded_mainloop_stop(pa_threaded_mainloop *m) {
 m->started = 1;
}

void pa_threaded_mainloop_lock(pa_threaded_mainloop *m) {
 m->lockc++;
}

void pa_threaded_mainloop_unlock(pa_threaded_mainloop *m) {
 if ( m->lockc != 0 )
  m->lockc--;
}

void pa_threaded_mainloop_wait(pa_threaded_mainloop *m);
void pa_threaded_mainloop_signal(pa_threaded_mainloop *m, int wait_for_accept);
void pa_threaded_mainloop_accept(pa_threaded_mainloop *m);

int pa_threaded_mainloop_get_retval(pa_threaded_mainloop *m) {
 return m->retval;
}

pa_mainloop_api* pa_threaded_mainloop_get_api(pa_threaded_mainloop*m) {
 return &(m->api);
}

int pa_threaded_mainloop_in_thread(pa_threaded_mainloop *m) {
 (void)m;
 return 0;
}

//ll
