/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.net.sf.retrotranslator.runtime.impl;

import java.lang.reflect.Field;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.asm.Type;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.asm.signature.SignatureReader;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.AnnotatedElementDescriptor;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.ClassDescriptor;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.MemberDescriptor;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.impl.TypeDescriptor;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.lang.annotation.Annotation_;
import org.mozilla.javascript.net.sf.retrotranslator.runtime.java.lang.reflect.TypeVariable_;

public class FieldDescriptor
extends AnnotatedElementDescriptor
implements MemberDescriptor {
    private String name;
    private String desc;
    private ClassDescriptor classDescriptor;
    private TypeDescriptor typeDescriptor;

    public FieldDescriptor(ClassDescriptor classDescriptor, int access, String name, String desc, String signature) {
        this.classDescriptor = classDescriptor;
        this.access = access;
        this.name = name;
        this.desc = desc;
        if (signature != null) {
            this.typeDescriptor = new TypeDescriptor();
            new SignatureReader(signature).accept(this.typeDescriptor);
        }
    }

    public FieldDescriptor(ClassDescriptor classDescriptor, Field field) {
        this(classDescriptor, field.getModifiers(), field.getName(), Type.getDescriptor(field.getType()), null);
    }

    public static FieldDescriptor getInstance(Field field) {
        ClassDescriptor classDescriptor = ClassDescriptor.getInstance(field.getDeclaringClass());
        FieldDescriptor fieldDescriptor = classDescriptor.getFieldDescriptor(field.getName());
        return fieldDescriptor != null ? fieldDescriptor : new FieldDescriptor(classDescriptor, field);
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Object getGenericType() {
        return this.createType(this.typeDescriptor);
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    protected TypeVariable_ findTypeVariable(String name) {
        return this.classDescriptor.findTypeVariable(name);
    }

    protected Annotation_[] createAnnotations(Annotation_[] declaredAnnotations) {
        return declaredAnnotations;
    }
}

