/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaMethod
extends BaseFunction {
    private static final int PREFERENCE_EQUAL = 0;
    private static final int PREFERENCE_FIRST_ARG = 1;
    private static final int PREFERENCE_SECOND_ARG = 2;
    private static final int PREFERENCE_AMBIGUOUS = 3;
    private static final boolean debug = false;
    MemberBox[] methods;

    NativeJavaMethod(MemberBox[] methods) {
        this.functionName = methods[0].getName();
        this.methods = methods;
    }

    NativeJavaMethod(MemberBox method, String name) {
        this.functionName = name;
        this.methods = new MemberBox[]{method};
    }

    public NativeJavaMethod(Method method, String name) {
        this(new MemberBox(method, null), name);
    }

    private static String scriptSignature(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof Scriptable) {
            if (value instanceof Undefined) {
                return "undefined";
            }
            if (value instanceof Wrapper) {
                Object wrapped = ((Wrapper)value).unwrap();
                return wrapped.getClass().getName();
            }
            if (value instanceof Function) {
                return "function";
            }
            return "object";
        }
        return JavaMembers.javaSignature(value.getClass());
    }

    static String scriptSignature(Object[] values) {
        StringBuffer sig = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            if (i != 0) {
                sig.append(',');
            }
            sig.append(NativeJavaMethod.scriptSignature(values[i]));
            ++i;
        }
        return sig.toString();
    }

    String decompile(int indent, int flags) {
        boolean justbody;
        StringBuffer sb = new StringBuffer();
        boolean bl = justbody = 0 != (flags & 1);
        if (!justbody) {
            sb.append("function ");
            sb.append(this.getFunctionName());
            sb.append("() {");
        }
        sb.append("/*\n");
        this.toString(sb);
        sb.append(justbody ? "*/\n" : "*/}\n");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb);
        return sb.toString();
    }

    private void toString(StringBuffer sb) {
        int i = 0;
        int N = this.methods.length;
        while (i != N) {
            Method method = this.methods[i].method();
            sb.append(JavaMembers.javaSignature(method.getReturnType()));
            sb.append(' ');
            sb.append(method.getName());
            sb.append(JavaMembers.liveConnectSignature(this.methods[i].argTypes));
            sb.append('\n');
            ++i;
        }
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        Object javaObject;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        int index = NativeJavaMethod.findFunction(cx, this.methods, args);
        if (index < 0) {
            Class<?> c = this.methods[0].method().getDeclaringClass();
            String sig = c.getName() + '.' + this.functionName + '(' + NativeJavaMethod.scriptSignature(args) + ')';
            throw Context.reportRuntimeError1("msg.java.no_such_method", sig);
        }
        MemberBox meth = this.methods[index];
        Class[] argTypes = meth.argTypes;
        Object[] origArgs = args;
        int i = 0;
        while (i < args.length) {
            Object arg = args[i];
            Object coerced = NativeJavaObject.coerceType(argTypes[i], arg, true);
            if (coerced != arg) {
                if (origArgs == args) {
                    args = (Object[])args.clone();
                }
                args[i] = coerced;
            }
            ++i;
        }
        if (meth.isStatic()) {
            javaObject = null;
        } else {
            Scriptable o = thisObj;
            Class c = meth.getDeclaringClass();
            while (true) {
                if (o == null) {
                    throw Context.reportRuntimeError3("msg.nonjava.method", this.functionName, ScriptRuntime.toString(thisObj), c.getName());
                }
                if (o instanceof Wrapper && c.isInstance(javaObject = ((Wrapper)((Object)o)).unwrap())) break;
                o = o.getPrototype();
            }
        }
        Object retval = meth.invoke(javaObject, args);
        Class<?> staticType = meth.method().getReturnType();
        Object wrapped = cx.getWrapFactory().wrap(cx, scope, retval, staticType);
        if (wrapped == Undefined.instance) {
            return wrapped;
        }
        if (wrapped == null && staticType == Void.TYPE) {
            return Undefined.instance;
        }
        return wrapped;
    }

    static int findFunction(Context cx, MemberBox[] methodsOrCtors, Object[] args) {
        if (methodsOrCtors.length == 0) {
            return -1;
        }
        if (methodsOrCtors.length == 1) {
            MemberBox member = methodsOrCtors[0];
            Class[] argTypes = member.argTypes;
            int alength = argTypes.length;
            if (alength != args.length) {
                return -1;
            }
            int j = 0;
            while (j != alength) {
                if (!NativeJavaObject.canConvert(args[j], argTypes[j])) {
                    return -1;
                }
                ++j;
            }
            return 0;
        }
        int bestFit = -1;
        Class[] bestFitTypes = null;
        int[] ambiguousMethods = null;
        int ambiguousMethodCount = 0;
        int i = 0;
        while (i < methodsOrCtors.length) {
            MemberBox member = methodsOrCtors[i];
            Class[] argTypes = member.argTypes;
            if (argTypes.length == args.length) {
                if (bestFit < 0) {
                    int j = 0;
                    while (j < argTypes.length) {
                        if (!NativeJavaObject.canConvert(args[j], argTypes[j])) break;
                        ++j;
                    }
                    if (j == argTypes.length) {
                        bestFit = i;
                        bestFitTypes = argTypes;
                    }
                } else {
                    int preference = NativeJavaMethod.preferSignature(args, argTypes, bestFitTypes);
                    if (preference == 3) {
                        if (ambiguousMethods == null) {
                            ambiguousMethods = new int[methodsOrCtors.length];
                        }
                        ambiguousMethods[ambiguousMethodCount++] = i;
                    } else if (preference == 1) {
                        bestFit = i;
                        bestFitTypes = argTypes;
                    } else if (preference != 2) {
                        MemberBox best;
                        if (preference != 0) {
                            Kit.codeBug();
                        }
                        if ((best = methodsOrCtors[bestFit]).isStatic() && best.getDeclaringClass().isAssignableFrom(member.getDeclaringClass())) {
                            bestFit = i;
                            bestFitTypes = argTypes;
                        }
                    }
                }
            }
            ++i;
        }
        if (ambiguousMethodCount == 0) {
            return bestFit;
        }
        int removedCount = 0;
        int k = 0;
        while (k != ambiguousMethodCount) {
            void i2 = ambiguousMethods[k];
            MemberBox member = methodsOrCtors[i2];
            Class[] argTypes = member.argTypes;
            int preference = NativeJavaMethod.preferSignature(args, argTypes, bestFitTypes);
            if (preference == 1) {
                bestFit = i2;
                bestFitTypes = argTypes;
                ambiguousMethods[k] = -1;
                ++removedCount;
            } else if (preference == 2) {
                ambiguousMethods[k] = -1;
                ++removedCount;
            }
            ++k;
        }
        if (removedCount == ambiguousMethodCount) {
            return bestFit;
        }
        StringBuffer buf = new StringBuffer();
        ambiguousMethods[ambiguousMethodCount++] = bestFit;
        boolean first = true;
        int k2 = 0;
        while (k2 < ambiguousMethodCount) {
            int i3 = ambiguousMethods[k2];
            if (i3 >= 0) {
                if (!first) {
                    buf.append(", ");
                }
                buf.append(methodsOrCtors[i3].toJavaDeclaration());
                first = false;
            }
            ++k2;
        }
        MemberBox best = methodsOrCtors[bestFit];
        if (methodsOrCtors[0].isMethod()) {
            throw Context.reportRuntimeError3("msg.constructor.ambiguous", best.getName(), NativeJavaMethod.scriptSignature(args), buf.toString());
        }
        throw Context.reportRuntimeError4("msg.method.ambiguous", best.getDeclaringClass().getName(), best.getName(), NativeJavaMethod.scriptSignature(args), buf.toString());
    }

    private static int preferSignature(Object[] args, Class[] sig1, Class[] sig2) {
        int preference = 0;
        int j = 0;
        while (j < args.length) {
            Class type1 = sig1[j];
            Class type2 = sig2[j];
            if (type1 != type2 && (preference |= NativeJavaMethod.preferConversion(args[j], type1, type2)) == 3) break;
            ++j;
        }
        return preference;
    }

    private static int preferConversion(Object fromObj, Class toClass1, Class toClass2) {
        int rank1 = NativeJavaObject.getConversionWeight(fromObj, toClass1);
        int rank2 = NativeJavaObject.getConversionWeight(fromObj, toClass2);
        if (rank1 == 0 && rank2 == 0) {
            if (toClass1.isAssignableFrom(toClass2)) {
                return 2;
            }
            if (toClass2.isAssignableFrom(toClass1)) {
                return 1;
            }
        } else {
            if (rank1 < rank2) {
                return 1;
            }
            if (rank1 > rank2) {
                return 2;
            }
        }
        return 3;
    }

    private static void printDebug(String msg, MemberBox member, Object[] args) {
    }
}

