\name{.getAutoMethodByName}
\alias{.getAutoMethodByName}
\alias{.getAutoElementByName}
\title{Locates Gtk class methods for an object}
\description{
  These functions are used to
  access Gtk class-specific methods
  using the \code{$} operator,
  as in \code{obj$Add}.
  These look for the method \code{name}
  for each of the classes from which
  \code{obj} inherits.
}
\usage{
.getAutoMethodByName(obj, name, prefix=c("Gtk", "gtk"))
.getAutoElementByName(obj, name, prefix=c("Gtk", "gtk"), error = TRUE)
}

\arguments{
  \item{obj}{the \code{GtkObject} which defines the classes of interest.}
  \item{name}{the name of the method or accessor being sought.}
  \item{prefix}{a vector giving a pair of values mapping the
    class prefix (e.g. Gdk) to the function name
    \code{gtk} prefix. This allows us to handle
    Gtk and Gdk objects.
  }
  \item{error}{a logical value indicating whether to throw an error
    or simply return an object of class \code{try-error} if no
    element is found for the specified name.}
}
\details{

}
\value{

}
\references{

}
\author{
Duncan Temple Lang <duncan@research.bell-labs.com>
}



\seealso{
\code{\link{$.GtkObject}}
}

\examples{

}
\keyword{interface}
