\name{gtkCheckInherits}
\alias{gtkCheckInherits}
\title{Verify an object's class}
\description{
  Checks whether the given object extends the appropriate
  class, raising an error if not.
  This is used to validate an object before it is passed
  to C code which expects an object of the appropriate type.
}
\usage{
gtkCheckInherits(w, klass="GtkWidget", nullOk=FALSE, critical=TRUE)
}
\arguments{
  \item{w}{the object whose classes are to be checked to
    determine if it ``extends'' the class \code{klass}.}
  \item{klass}{the class which the object \code{w} is expected
    to extend.}
  \item{nullOk}{a logical value which controls whether
    a value of \code{NULL} for \code{w} is acceptable
    and passes the test. If this is not \code{TRUE},
    a value of \code{NULL} throws an error.}
  \item{critical}{a logical value or a string that controls whether
    an error is raised if the object \code{w} does not inherit from
    \code{klass}.
    If this is a string, it is used as the error message.
    If it is a logical value and is \code{TRUE}, an error is raised.
  }
}
\details{
 This 
}
\value{
 A logical value or an error!
}
\references{
}
\author{
Duncan Temple Lang <duncan@research.bell-labs.com>
}
\seealso{
  \code{\link[pkg:base]{inherits}}
  \code{\link[pkg:base]{stop}}
}

\examples{
}
\keyword{interface}

