\name{gtkWidgetGetAllocatedSize}
\alias{gtkWidgetGetAllocatedSize}
\title{Obtain dimensions allocated to a Gtk widget}
\description{
  Returns the width and height allocated to a Gtk widget.
}
\usage{
gtkWidgetGetAllocatedSize(w)
}
\arguments{
  \item{w}{the object of class \code{"GtkWidget"}
    whose allocated dimensions are to be queried.}
}
\value{
  An integer vector with two elements:
  \item{width}{the number of pixels the widget spans in the horizontal
    dimension}
  \item{height}{the number of pixels the widget spans in the vertical
    dimension}
}
\references{

}
\author{
  Luca Di Gaspero <l.digaspero@uniud.it>
}
\note{
}

\seealso{
}

\examples{
library(RGtk)
win = gtkWindow(show = FALSE)
box = gtkVBox(spacing = 10)
win$Add(box)
button = gtkButton("Press me to see my current size")
button$AddCallback("pressed", function(w, ev) {
    print(gtkWidgetGetAllocatedSize(w))
  })
box$PackStart(button, expand = TRUE)
win$Show()
}
\keyword{interface}

