#
# Mimicing the example from pygtk (in turn from Gtk)
#

testHandler <-
function() {

  windows <- list()
  
  buttons <- function(w) {
    if(!is.na(match("buttons", names(windows)))) {
      cat("Showing existing button\n")
      gtkWidgetShow(windows[["buttons"]])
      return
    }
    
    win <- gtkWindowNew()
    gtkWindowSetTitle(win, "Buttons test")


    box1 <- gtkVBoxNew(TRUE, 7)
    gtkContainerAdd(win, box1)
    table <- gtkTableNew(3,3,FALSE)
    gtkTableSetRowSpacings(table, 5)
    gtkTableSetColSpacings(table, 5)
##    gtkTableSetBorderWidth(table, 10)
   
    gtkBoxPackStart(box1, table)
    ctr <- 1
    for(i in 1:3) {
      for(j in 1:3) {
        b <- gtkButtonNewWithLabel(paste("button", ctr))
        gtkTableAttach(table, b, i-1, i, j-1, j)
        gtkAddCallback(b, "clicked", function(x) print("Button pressed"))
        ctr <- ctr + 1
      }
    }

    gtkBoxPackStart(box1, gtkHSeparatorNew(), expand=FALSE)

    b <- gtkButtonNewWithLabel("Close")
    gtkAddCallback(b, "clicked", function(x) closeWindow("buttons"))

    gtkBoxPackEnd(box1, b)
    windows[["buttons"]] <<- win
    gtkWidgetShow(win)
  }

  closeWindow <- function(which) {
    if(!is.na(match(which, names(windows)))) {
      win <- windows[[which]]
      gtkWidgetHide(win)
      gtkWidgetDestroy(win)
      windows[[which]] <<- NULL
      return(TRUE)
    }

    return(FALSE)
  }

  toggleButtons <- function(w) {

  }

  checkButtons <- function(w) {

  }

  radioButtons <- function(w) {
   
  }

  gammaCurve <- function(w) {
   if(is.na(match("gamma", names(windows)))) {
     win <- gtkWindowNew(show = FALSE)
     gtkContainerAdd(win, gtkGammaCurveNew())
     gtkWidgetShow(win)
     
     windows[["gamma"]] <<- win
   }
  }

  toolbar <- function(w) {
    win <- gtkWindowNew(show=FALSE)
    bar <- gtkToolbarNew()
    b <- gtkButtonNewWithLabel("foo")
    gtkToolbarAppendWidget(bar, b, "foo", "xyz")
    gtkContainerAdd(win, bar)
    gtkWidgetShow(win)

    windows[["toolbar"]] <<- win
  }

  list(buttons = buttons,
       toggleButtons = toggleButtons,
       checkButtons = checkButtons,
       radioButtons = radioButtons,
       gammaCurve = gammaCurve,
       toolbar = toolbar)
}  
  

buttonLabels  <- c("buttons" = "buttons",
                   "toggle buttons" = "toggleButtons",
                   "check buttons" = "checkButtons",
                   "radio buttons" = "radioButtons",
                   "gamma curve" = "gammaCurve",
                   toolbar = "toolbar"
                  )


h <- testHandler()

win <- gtkWindowNew(show=FALSE)

box <- gtkVBoxNew(TRUE, 10)
gtkContainerAdd(win, box)

for(i in names(buttonLabels)) {
  b <- gtkButtonNewWithLabel(i)
  gtkBoxPackStart(box, b)
  gtkAddCallback(b, "clicked", h[[ buttonLabels[i] ]])
}

gtkWidgetShow(win)
