import sys
import generate

import types

class SFilteringParser(generate.FilteringParser):
    """An interactive parser for examining the output from the real parser"""
    def __init__(self, input):
        generate.FilteringParser.__init__(self, input)
        
    def define_func(self, name, retType, args):
        print "[define_func] %s %s %d" % (name,retType,len(args))
        for i in args:
            print "Name: %s, type: %s" %(i[1], i[0])

    def define_object(self, name, parent=(), fields=()):
        print "[define_object] %s: extends %s, # fields %d" % (name, parent[0], len(fields))
        if len(parent) > 1:
            print "**********Warning: # parents not 1 but %d" %(len(parent))
        for i in fields[1:]:
            print "# %d %s %s" % (len(i), i[0], i[1])

    def define_boxed(self, name, reffunc = None, unreffunc=None, size=None):
        print "[define_boxed] %s %s %s %s" %(name, reffunc, unreffunc, size)



    def define_enum(self, name, *values):
        print "[define_enum] %s %d" %(name, len(values))
        for v in values:
            print "%s=%s" %(v[0], v[1])


    def define_flags(self, name, *values):
        print "[define_flags] %s" % (name)


class SDefsParser(generate.FilteringParser):
    """Cumulate details and make available to R"""
    def __init__(self, input):
        generate.FilteringParser.__init__(self, input)
        self.enums = {}
        self.classes = {}
        self.functions = {}
        self.boxes = {}
        self.flags = {}
        self.funCount = 0
        
    def named(self, vals):
        tmp = {}
        for i in vals:
            tmp[i[0]] = i[1]
        return(tmp)

    def define_func(self, name, retType, args):
        # have to be careful about the order of the arguments here
        # when we convert to a dictionary.
        self.functions[name] = (retType, args)
        
    def define_object(self, name, parent=(), fields=()):
        #if(len(fields) > 1):
        #   print "Ok: %s\n" %(fields[1][0])
        #   fields = fields[1][2:]
        #if(len(fields) > 0):
        #   fields = fields[2:]
        self.classes[name] = (parent,  fields) # self.named(fields))

    def define_enum(self, name, *values):
        self.enums[name] = values

    def define_flags(self, name, *values):
        self.flags[name] = values        
        
    def define_boxed(self, name, reffunc = None, unreffunc=None, size=None):
        self.boxes[name] = (reffunc, unreffunc, size)


    def getEnums(self):
        return(self.enums)

    def getFunctions(self):
        return(self.functions)    
    
    def getNumFunctions(self):
        return(self.funCount)
