INSERT INTO description
    ( id, dbname, dbtable, dbcolumn, coltype, fk_target, relation )
VALUES
-- sample
    ('1','test_samples','sample','id','id',NULL,NULL),
    ('2','test_samples','sample','uuid','uuid',NULL,NULL),
-- natural_sample
    ('3','test_samples','natural_sample','id','id',NULL,NULL),
    ('4','test_samples','natural_sample','uuid','uuid',NULL,NULL),
-- origin
    ('5','test_samples','origin','id','id',NULL,NULL),
    ('6','test_samples','origin','uuid','uuid',NULL,NULL),
-- lithology_img
    ('7','test_samples','lithology_img','id','id',NULL,NULL),
    ('8','test_samples','lithology_img','uuid','uuid',NULL,NULL),
-- synthetic_sample
    ('9','test_samples','synthetic_sample','id','id',NULL,NULL),
    ('10','test_samples','synthetic_sample','uuid','uuid',NULL,NULL),
-- phase
    ('11','test_samples','phase','id','id',NULL,NULL),
    ('12','test_samples','phase','uuid','uuid',NULL,NULL),
-- compound
    ('13','test_samples','compound','id','id',NULL,NULL),
    ('14','test_samples','compound','uuid','uuid',NULL,NULL),
-- purchase
    ('15','test_samples','purchase','id','id',NULL,NULL),
    ('16','test_samples','purchase','uuid','uuid',NULL,NULL),
-- experiment_optical
    ('17','test_samples','experiment_optical','id','id',NULL,NULL),
    ('18','test_samples','experiment_optical','uuid','uuid',NULL,NULL),
-- optical_img
    ('19','test_samples','optical_img','id','id',NULL,NULL),
    ('20','test_samples','optical_img','uuid','uuid',NULL,NULL),
-- experiment_sem
    ('21','test_samples','experiment_sem','id','id',NULL,NULL),
    ('22','test_samples','experiment_sem','uuid','uuid',NULL,NULL),
-- sem_img
    ('23','test_samples','sem_img','id','id',NULL,NULL),
    ('24','test_samples','sem_img','uuid','uuid',NULL,NULL),
-- experiment_epma
    ('25','test_samples','experiment_epma','id','id',NULL,NULL),
    ('26','test_samples','experiment_epma','uuid','uuid',NULL,NULL),
-- epma_mineral
    ('27','test_samples','epma_mineral','id','id',NULL,NULL),
    ('28','test_samples','epma_mineral','uuid','uuid',NULL,NULL),
-- epma_content
    ('29','test_samples','epma_content','id','id',NULL,NULL),
    ('30','test_samples','epma_content','uuid','uuid',NULL,NULL),
-- experiment_xrf
    ('31','test_samples','experiment_xrf','id','id',NULL,NULL),
    ('32','test_samples','experiment_xrf','uuid','uuid',NULL,NULL),
-- xrf_content
    ('33','test_samples','xrf_content','id','id',NULL,NULL),
    ('34','test_samples','xrf_content','uuid','uuid',NULL,NULL),
-- natural_sample.sample_id <-> sample.id
    ('35','test_samples','natural_sample','sample_id','fk','1','1'),
-- synthetic_sample.sample_id <-> sample.id
    ('36','test_samples','synthetic_sample','sample_id','fk','1','1'),
-- experiment_optical.sample_id <-> sample.id
    ('37','test_samples','experiment_optical','sample_id','fk','1','N'),
-- experiment_sem.sample_id <-> sample.id
    ('38','test_samples','experiment_sem','sample_id','fk','1','N'),
-- experiment_epma.sample_id <-> sample.id
    ('39','test_samples','experiment_epma','sample_id','fk','1','N'),
-- experiment_xrf.sample_id <-> sample.id
    ('40','test_samples','experiment_xrf','sample_id','fk','1','N'),
-- lithology_img.natural_sample_id <-> natural_sample.id
    ('41','test_samples','lithology_img','natural_sample_id','fk','3','N'),
-- natural_sample.origin_id <-> origin.id
    ('42','test_samples','natural_sample','origin_id','fk','5','N'),
-- phase.synthetic_sample_id <-> synthetic_sample.id
    ('43','test_samples','phase','synthetic_sample_id','fk','9','N'),
-- phase.compound_id <-> compound.id
    ('44','test_samples','phase','compound_id','fk','13','N'),
-- phase.purchase_id <-> purchase.id
    ('45','test_samples','phase','purchase_id','fk','15','N'),
-- optical_img.experiment_id <-> experiment_optical.id
    ('46','test_samples','optical_img','experiment_id','fk','17','N'),
-- sem_img.experiment_id <-> experiment_sem.id
    ('47','test_samples','sem_img','experiment_id','fk','21','N'),
-- epma_mineral.experiment_id <-> experiment_epma.id
    ('48','test_samples','epma_mineral','experiment_id','fk','25','N'),
-- epma_content.mineral_id <-> epma_mineral.id
    ('49','test_samples','epma_content','mineral_id','fk','27','N'),
-- xrf_content.experiment_id <-> experiment_xrf.id
    ('50','test_samples','xrf_content','experiment_id','fk','31','N'),

-- revision
    ('51','test_samples','revision','id','id',NULL,NULL),
    ('52','test_samples','revision','uuid','uuid',NULL,NULL),

    ('53','test_samples','sample','revision_id','dbrev','51','1'),
    ('54','test_samples','natural_sample','revision_id','dbrev','51','1'),
    ('55','test_samples','origin','revision_id','dbrev','51','1'),
    ('56','test_samples','lithology_img','revision_id','dbrev','51','1'),
    ('57','test_samples','synthetic_sample','revision_id','dbrev','51','1'),
    ('58','test_samples','phase','revision_id','dbrev','51','1'),
    ('59','test_samples','compound','revision_id','dbrev','51','1'),
    ('60','test_samples','purchase','revision_id','dbrev','51','1'),
    ('61','test_samples','experiment_optical','revision_id','dbrev','51','1'),
    ('62','test_samples','optical_img','revision_id','dbrev','51','1'),
    ('63','test_samples','experiment_sem','revision_id','dbrev','51','1'),
    ('64','test_samples','sem_img','revision_id','dbrev','51','1'),
    ('65','test_samples','experiment_epma','revision_id','dbrev','51','1'),
    ('66','test_samples','epma_mineral','revision_id','dbrev','51','1'),
    ('67','test_samples','epma_content','revision_id','dbrev','51','1'),
    ('68','test_samples','experiment_xrf','revision_id','dbrev','51','1'),
    ('69','test_samples','xrf_content','revision_id','dbrev','51','1'),

-- sample_history
    ('70','test_samples','sample_history','id','id',NULL,NULL),
    ('71','test_samples','sample_history','create_revision_id','fk','51','N'),
    ('72','test_samples','sample_history','delete_revision_id','fk','51','N'),
-- natural_sample_history
    ('73','test_samples','natural_sample_history','id','id',NULL,NULL),
    ('74','test_samples','natural_sample_history','create_revision_id','fk','51','N'),
    ('75','test_samples','natural_sample_history','delete_revision_id','fk','51','N'),
-- origin_history
    ('76','test_samples','origin_history','id','id',NULL,NULL),
    ('77','test_samples','origin_history','create_revision_id','fk','51','N'),
    ('78','test_samples','origin_history','delete_revision_id','fk','51','N'),
-- lithology_img_history
    ('79','test_samples','lithology_img_history','id','id',NULL,NULL),
    ('80','test_samples','lithology_img_history','create_revision_id','fk','51','N'),
    ('81','test_samples','lithology_img_history','delete_revision_id','fk','51','N'),
-- synthetic_sample_history
    ('82','test_samples','synthetic_sample_history','id','id',NULL,NULL),
    ('83','test_samples','synthetic_sample_history','create_revision_id','fk','51','N'),
    ('84','test_samples','synthetic_sample_history','delete_revision_id','fk','51','N'),
-- phase_history
    ('85','test_samples','phase_history','id','id',NULL,NULL),
    ('86','test_samples','phase_history','create_revision_id','fk','51','N'),
    ('87','test_samples','phase_history','delete_revision_id','fk','51','N'),
-- compound_history
    ('88','test_samples','compound_history','id','id',NULL,NULL),
    ('89','test_samples','compound_history','create_revision_id','fk','51','N'),
    ('90','test_samples','compound_history','delete_revision_id','fk','51','N'),
-- purchase_history
    ('91','test_samples','purchase_history','id','id',NULL,NULL),
    ('92','test_samples','purchase_history','create_revision_id','fk','51','N'),
    ('93','test_samples','purchase_history','delete_revision_id','fk','51','N'),
-- experiment_optical_history
    ('94','test_samples','experiment_optical_history','id','id',NULL,NULL),
    ('95','test_samples','experiment_optical_history','create_revision_id','fk','51','N'),
    ('96','test_samples','experiment_optical_history','delete_revision_id','fk','51','N'),
-- optical_img_history
    ('97','test_samples','optical_img_history','id','id',NULL,NULL),
    ('98','test_samples','optical_img_history','create_revision_id','fk','51','N'),
    ('99','test_samples','optical_img_history','delete_revision_id','fk','51','N'),
-- experiment_sem_history
    ('100','test_samples','experiment_sem_history','id','id',NULL,NULL),
    ('101','test_samples','experiment_sem_history','create_revision_id','fk','51','N'),
    ('102','test_samples','experiment_sem_history','delete_revision_id','fk','51','N'),
-- sem_img_history
    ('103','test_samples','sem_img_history','id','id',NULL,NULL),
    ('104','test_samples','sem_img_history','create_revision_id','fk','51','N'),
    ('105','test_samples','sem_img_history','delete_revision_id','fk','51','N'),
-- experiment_epma_history
    ('106','test_samples','experiment_epma_history','id','id',NULL,NULL),
    ('107','test_samples','experiment_epma_history','create_revision_id','fk','51','N'),
    ('108','test_samples','experiment_epma_history','delete_revision_id','fk','51','N'),
-- epma_mineral_history
    ('109','test_samples','epma_mineral_history','id','id',NULL,NULL),
    ('110','test_samples','epma_mineral_history','create_revision_id','fk','51','N'),
    ('111','test_samples','epma_mineral_history','delete_revision_id','fk','51','N'),
-- epma_content_history
    ('112','test_samples','epma_content_history','id','id',NULL,NULL),
    ('113','test_samples','epma_content_history','create_revision_id','fk','51','N'),
    ('114','test_samples','epma_content_history','delete_revision_id','fk','51','N'),
-- experiment_xrf_history
    ('115','test_samples','experiment_xrf_history','id','id',NULL,NULL),
    ('116','test_samples','experiment_xrf_history','create_revision_id','fk','51','N'),
    ('117','test_samples','experiment_xrf_history','delete_revision_id','fk','51','N'),
-- xrf_content_history
    ('118','test_samples','xrf_content_history','id','id',NULL,NULL),
    ('119','test_samples','xrf_content_history','create_revision_id','fk','51','N'),
    ('120','test_samples','xrf_content_history','delete_revision_id','fk','51','N'),

-- SOLSA IDs
    ('121','test_samples','sample','SolsaID','extkey',NULL,NULL),

-- lithology_img image properties
    ('122','test_samples','lithology_img','image','image',NULL,NULL),
    ('123','test_samples','lithology_img','format','format','122',NULL),
    ('124','test_samples','lithology_img','mimetype','mimetype','122',NULL),
    ('125','test_samples','lithology_img','cssclass','cssclass','122',NULL),
-- optical_img image properties
    ('126','test_samples','optical_img','image','image',NULL,NULL),
    ('127','test_samples','optical_img','format','format','126',NULL),
    ('128','test_samples','optical_img','mimetype','mimetype','126',NULL),
    ('129','test_samples','optical_img','cssclass','cssclass','126',NULL),
-- sem_img image properties
    ('130','test_samples','sem_img','image','image',NULL,NULL),
    ('131','test_samples','sem_img','format','format','130',NULL),
    ('132','test_samples','sem_img','mimetype','mimetype','130',NULL),
    ('133','test_samples','sem_img','cssclass','cssclass','130',NULL);
