#ifndef lint
static char *RCSid = "$Id: cmsfuncs.c,v 1.1 1999/08/31 20:32:32 mark Exp $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/****************************************************************************
*   This code modified for Multithread Win32 port by Les Moull April 1999.  *
****************************************************************************/

#include "rexx.h"
#ifdef VMS
# include <stat.h>
#else
# include <sys/stat.h>
# ifdef HAVE_UNISTD_H
#  include <unistd.h>
# endif
#endif
#include <stdio.h>
#include <ctype.h>
#ifdef HAVE_ASSERT_H
# include <assert.h>
#endif

#if defined(__WATCOMC__) && !defined(__QNX__)
# include <dos.h>
#endif

#if defined(WIN32)
# ifdef _MSC_VER
#  if _MSC_VER >= 1100
/* Stupid MSC can't compile own headers without warning at least in VC 5.0 */
#   pragma warning(disable: 4115 4201 4214)
#  endif
# endif
# include <windows.h>
# ifdef _MSC_VER
#  if _MSC_VER >= 1100
#   pragma warning(default: 4115 4201 4214)
#  endif
# endif
#endif

/*
 * Since development of Ultrix has ceased, and they never managed to 
 * fix a few things, we want to define a few things, just in order 
 * to kill a few warnings ...
 */
#if defined(FIX_PROTOS) && defined(FIX_ALL_PROTOS) && defined(ultrix)
   int fstat( int fd, struct stat *buf ) ;
   int stat( char *path, struct stat *buf ) ;
#endif

streng *std_wordpos( paramboxptr ) ;
streng *std_pos( paramboxptr ) ;


streng *cms_sleep( paramboxptr parms )
{
   checkparam(  parms,  1,  1, "SLEEP" ) ;
#if defined(WIN32) && (defined(_MSC_VER) || defined(__IBMC__))
   Sleep( (int)((myatof(parms->value))*1000) ) ;
#else
#if defined(HAVE_USLEEP)
   usleep( (int)((myatof(parms->value))*1000*1000) ) ;
#else
   sleep( atozpos( parms->value, "SLEEP", 1 ) ) ;
#endif
#endif
   return nullstringptr() ;
}   


streng *cms_makebuf( paramboxptr parms )
{
   checkparam(  parms,  0,  0 , "MAKEBUF" ) ;
   return int_to_streng(make_buffer()) ;
}



streng *cms_justify( paramboxptr parms ) 
{
   int inspace=0, i=0, count=0, between=0, extra=0, initial=0;
   int spaces=0, chars=0, length=0 ;
   char *cend=NULL, *cp=NULL, *cptr=NULL, *out=NULL, *oend=NULL ;
   char pad=' ' ;
   streng *result=NULL ;

   checkparam(  parms,  2,  3 , "JUSTIFY" ) ;

   cptr = parms->value->value ;
   cend = cptr + parms->value->len ;

   length = atozpos( parms->next->value, "JUSTIFY", 2 ) ;
   if (parms->next->next && parms->next->next->value)
      pad = getonechar( parms->next->next->value, "JUSTIFY", 3 ) ;
   else
      pad = ' ' ;

   inspace = 1 ;
   spaces = 0 ;
   chars = 0 ;
   for (cp=cptr; cp<cend; cp++)
   {
      if (inspace)
      {
         if (!isspace(*cp))
         {
            chars++ ;
            inspace = 0 ;
         }
      }
      else
      {
         if (!isspace(*cp))
            chars++ ;
         else
         {
            spaces++ ;
            inspace = 1 ;
         }
      }
   }

   if (inspace && spaces)
      spaces-- ;

   result = Str_make( length ) ;
   if (chars+spaces>length || spaces==0)
   {
      between = 1 ;
      extra = 0 ;
      initial = 0 ;
   }
   else
   {
      extra = (length - chars) % spaces ;
      between = (length - chars) / spaces ;
      initial = (spaces - extra) / 2 ;
   }   

   count = 0 ;
   out = result->value ;
   oend = out + length ;
   cp = cptr ;
   for (; cp<cend && isspace(*cp); cp++) ;
   for (; cp<cend && out<oend; cp++)
   {
      if (isspace(*cp))
      {
         for (;cp<cend && isspace(*cp); cp++) ;
         for (i=0; i<between && out<oend; i++)
            *(out++) = pad ;
         if (count<initial)
            count++ ;
         else if (extra && out<oend)
         {
            extra-- ;
            *(out++) = pad ;
         }  
         if (out<oend)
            *(out++) = *cp ;
      }
      else
         *(out++) = *cp ;
   }
      
   for (; out<oend; out++)
      *out = pad ;

   assert( out - result->value == length ) ;
   result->len = length ;

   return result ;
}
            


streng *cms_find( paramboxptr parms )
{
   paramboxptr ptmp=NULL ;
  
   checkparam(  parms,  2,  3 , "FIND" ) ;
   ptmp = parms->next ;
   parms->next = ptmp->next ;
   ptmp->next = parms ;

   return std_wordpos( ptmp ) ;
}

   
streng *cms_index( paramboxptr parms )
{
   paramboxptr ptmp=NULL ;

   checkparam(  parms,  2,  3 , "INDEX" ) ;
   ptmp = parms->next ;
   parms->next = ptmp->next ;
   ptmp->next = parms ;

   return std_pos( ptmp ) ;
}

streng *cms_desbuf( paramboxptr parms )
{
   checkparam(  parms,  0,  0 , "DESBUF" ) ;
   return( int_to_streng(drop_buffer(0))) ;
}


streng *cms_buftype( paramboxptr parms )
{
   checkparam(  parms,  0,  0 , "BUFTYPE" ) ;
   type_buffer() ;
   return (nullstringptr()) ;
}


streng *cms_dropbuf( paramboxptr parms )
{
   int buffer=(-1) ;

   checkparam(  parms,  0,  1 , "DROPBUF" ) ;
   if (parms->value)
      buffer = myatol(parms->value) ;

   return( int_to_streng(drop_buffer(buffer))) ;      
}
 

#ifdef HAS_SCANDIR
/* this part of the code is not used */
#if !defined(HAVE_WINMULTITHREADING)
char *filenamecms ;
#endif

int select_file( struct direct *entry )
{
#if !defined(HAVE_WINMULTITHREADING)
   extern char *filenamecms ;
#else
# include "multi.h"
#endif
   return !(strcmp(entry->d_name,filename)) ;
#include "unmulti.h"
}


char *cms_state( paramboxptr parms ) 
{
   struct direct *names=NULL ;
   int last=0, result=0 ;
   char *dir=NULL, *string=NULL, *retval=NULL ;
#if !defined(HAVE_WINMULTITHREADING)
   extern char *filenamecms ;
#else
# include "multi.h"
#endif

   checkparam(  parms,  1,  1 , "STATE" ) ;
   last = strlen(string=parms->value) ;
   for (;(string[last]!=FILE_SEPARATOR)&&(last>0);last--) ;
   if (last) {
      string[last] = '\000' ;
      filenamecms = &string[last+1] ;
      dir = string ; }
   else {
      dir = "." ;
      filenamecms = &string[last] ; }

   result = scandir(dir,&names,&select_file,NULL) ;
   if (last)
      string[last] = FILE_SEPARATOR ;
   retval = Malloc(BOOL_STR_LENGTH) ;
   sprintf(retval,"%d",(result==1)) ;

   /* Ought to open or stat the file to check if it is readable */

   return retval ;
#include "unmulti.h"
}
#else


streng *cms_state( paramboxptr parms )
{
   /* this is a bit too easy ... but STREAM() function should handle it */
   streng *retval=NULL ;
   int rcode=0 ;
   struct stat buffer ;
   
   checkparam(  parms,  1,  1 , "STATE" ) ;
   retval = Str_make( BOOL_STR_LENGTH ) ;

   /* will generate warning under Ultrix, don't care */   
   rcode = stat( Str_ify(parms->value)->value, &buffer ) ;
   return int_to_streng(rcode!=0) ;
   
}
#endif

