/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.28
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC)
#   if (__SUNPRO_CC <= 0x560)
#     define SWIGTEMPLATEDISAMBIGUATOR template
#   else
#     define SWIGTEMPLATEDISAMBIGUATOR 
#   endif
# else
#   define SWIGTEMPLATEDISAMBIGUATOR 
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else



/* compile-time include (inside a % ... % block) */
#ifdef REDLAND_PRE_I
#include <redland-pre.i>
#endif

#include <redland.h>

/* 
 * Thanks to the patch in this Debian bug for the solution
 * to the crash inside vsnprintf on some architectures.
 *
 * "reuse of args inside the while(1) loop is in violation of the
 * specs and only happens to work by accident on other systems."
 *
 * http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=104325 
 */

#ifndef va_copy
#ifdef __va_copy
#define va_copy(dest,src) __va_copy(dest,src)
#else
#define va_copy(dest,src) (dest) = (src)
#endif
#endif

/* compile-time include (inside a % ... % block) */
#ifdef REDLAND_POST_I
#include <redland-post.i>
#endif

/* Internal prototypes */
/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void librdf_internal_test_error(librdf_world *world);
void librdf_internal_test_warning(librdf_world *world);


/* prototypes for internal routines called below - NOT PART OF API */
void librdf_test_error(librdf_world* world, const char* message);
void librdf_test_warning(librdf_world* world, const char* message);

/* FOR TESTING ERRORS ONLY - NOT PART OF API */
void
librdf_internal_test_error(librdf_world *world) 
{
  librdf_test_error(world, "test error message number 1.");
}

void
librdf_internal_test_warning(librdf_world *world) 
{
  librdf_test_warning(world, "test warning message number 2.");
}



#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1digest(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) 0 ;
  librdf_digest *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (librdf_digest *)librdf_new_digest(arg1,arg2);
  
  *(librdf_digest **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1digest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_digest *arg1 = (librdf_digest *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_digest **)(void *)&jarg1; 
  librdf_free_digest(arg1);
  
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1digest_1init(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_digest *arg1 = (librdf_digest *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_digest **)(void *)&jarg1; 
  librdf_digest_init(arg1);
  
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1digest_1update(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  librdf_digest *arg1 = (librdf_digest *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_digest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (size_t)jarg3; 
  librdf_digest_update(arg1,(char const *)arg2,arg3);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1digest_1update_1string(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  librdf_digest *arg1 = (librdf_digest *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_digest **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  librdf_digest_update_string(arg1,(char const *)arg2);
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1digest_1final(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_digest *arg1 = (librdf_digest *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_digest **)(void *)&jarg1; 
  librdf_digest_final(arg1);
  
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1digest_1to_1string(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  librdf_digest *arg1 = (librdf_digest *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_digest **)(void *)&jarg1; 
  result = (char *)librdf_digest_to_string(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1hash_1from_1string(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  librdf_hash *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  result = (librdf_hash *)librdf_new_hash_from_string(arg1,(char const *)arg2,(char const *)arg3);
  
  *(librdf_hash **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1hash_1from_1array_1of_1strings(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) 0 ;
  char **arg3 = (char **) 0 ;
  librdf_hash *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(char ***)(void *)&jarg3; 
  result = (librdf_hash *)librdf_new_hash_from_array_of_strings(arg1,(char const *)arg2,(char const **)arg3);
  
  *(librdf_hash **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1hash(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_hash *arg1 = (librdf_hash *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_hash **)(void *)&jarg1; 
  librdf_free_hash(arg1);
  
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1world(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  librdf_world *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (librdf_world *)librdf_new_world();
  
  *(librdf_world **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1world(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_world *arg1 = (librdf_world *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  librdf_free_world(arg1);
  
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1world_1open(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_world *arg1 = (librdf_world *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  librdf_world_open(arg1);
  
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1world_1get_1feature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  result = (librdf_node *)librdf_world_get_feature(arg1,arg2);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1world_1set_1feature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (int)librdf_world_set_feature(arg1,arg2,arg3);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1iterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_iterator *arg1 = (librdf_iterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_iterator **)(void *)&jarg1; 
  librdf_free_iterator(arg1);
  
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1iterator_1end(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_iterator *arg1 = (librdf_iterator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_iterator **)(void *)&jarg1; 
  result = (int)librdf_iterator_end(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1iterator_1get_1object(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_iterator *arg1 = (librdf_iterator *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_iterator **)(void *)&jarg1; 
  result = (librdf_node *)librdf_iterator_get_object(arg1);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1iterator_1get_1context(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_iterator *arg1 = (librdf_iterator *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_iterator **)(void *)&jarg1; 
  result = (librdf_node *)librdf_iterator_get_context(arg1);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1iterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_iterator *arg1 = (librdf_iterator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_iterator **)(void *)&jarg1; 
  result = (int)librdf_iterator_next(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1uri(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) 0 ;
  librdf_uri *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (librdf_uri *)librdf_new_uri(arg1,arg2);
  
  *(librdf_uri **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1uri_1from_1uri(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_uri *arg1 = (librdf_uri *) 0 ;
  librdf_uri *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_uri **)(void *)&jarg1; 
  result = (librdf_uri *)librdf_new_uri_from_uri(arg1);
  
  *(librdf_uri **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1uri_1from_1filename(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) 0 ;
  librdf_uri *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (librdf_uri *)librdf_new_uri_from_filename(arg1,(char const *)arg2);
  
  *(librdf_uri **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1uri(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_uri *arg1 = (librdf_uri *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_uri **)(void *)&jarg1; 
  librdf_free_uri(arg1);
  
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1uri_1to_1string(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  librdf_uri *arg1 = (librdf_uri *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_uri **)(void *)&jarg1; 
  result = (char *)librdf_uri_to_string(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  free(result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1uri_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  librdf_uri *arg1 = (librdf_uri *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_uri **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  result = (int)librdf_uri_equals(arg1,arg2);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1node(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  result = (librdf_node *)librdf_new_node(arg1);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1node_1from_1uri_1string(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (librdf_node *)librdf_new_node_from_uri_string(arg1,(char const *)arg2);
  
  *(librdf_node **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1node_1from_1uri(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  result = (librdf_node *)librdf_new_node_from_uri(arg1,arg2);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1node_1from_1literal(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jint jarg4) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) NULL ;
  int arg4 = (int) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (int)jarg4; 
  result = (librdf_node *)librdf_new_node_from_literal(arg1,(char const *)arg2,(char const *)arg3,arg4);
  
  *(librdf_node **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1node_1from_1typed_1literal(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) NULL ;
  librdf_uri *arg4 = (librdf_uri *) NULL ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = *(librdf_uri **)(void *)&jarg4; 
  result = (librdf_node *)librdf_new_node_from_typed_literal(arg1,(char const *)arg2,(char const *)arg3,arg4);
  
  *(librdf_node **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1node_1from_1node(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (librdf_node *)librdf_new_node_from_node(arg1);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1node_1from_1blank_1identifier(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) NULL ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (librdf_node *)librdf_new_node_from_blank_identifier(arg1,(char const *)arg2);
  
  *(librdf_node **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1node(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_node *arg1 = (librdf_node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  librdf_free_node(arg1);
  
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1node_1get_1uri(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  librdf_uri *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (librdf_uri *)librdf_node_get_uri(arg1);
  
  *(librdf_uri **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1node_1get_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (int)librdf_node_get_type(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1node_1get_1literal_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (char *)librdf_node_get_literal_value(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1node_1get_1literal_1value_1as_1latin1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (char *)librdf_node_get_literal_value_as_latin1(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1node_1get_1literal_1value_1language(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (char *)librdf_node_get_literal_value_language(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1node_1get_1literal_1value_1datatype_1uri(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  librdf_uri *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (librdf_uri *)librdf_node_get_literal_value_datatype_uri(arg1);
  
  *(librdf_uri **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1node_1get_1literal_1value_1is_1wf_1xml(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (int)librdf_node_get_literal_value_is_wf_xml(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1node_1to_1string(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (char *)librdf_node_to_string(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  free(result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1node_1get_1blank_1identifier(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (char *)librdf_node_get_blank_identifier(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1node_1is_1resource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (int)librdf_node_is_resource(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1node_1is_1literal(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (int)librdf_node_is_literal(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1node_1is_1blank(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  result = (int)librdf_node_is_blank(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1node_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  librdf_node *arg1 = (librdf_node *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_node **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  result = (int)librdf_node_equals(arg1,arg2);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1statement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  librdf_statement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  result = (librdf_statement *)librdf_new_statement(arg1);
  
  *(librdf_statement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1statement_1from_1statement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_statement *arg1 = (librdf_statement *) 0 ;
  librdf_statement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_statement **)(void *)&jarg1; 
  result = (librdf_statement *)librdf_new_statement_from_statement(arg1);
  
  *(librdf_statement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1statement_1from_1nodes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  librdf_node *arg4 = (librdf_node *) 0 ;
  librdf_statement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  arg4 = *(librdf_node **)(void *)&jarg4; 
  result = (librdf_statement *)librdf_new_statement_from_nodes(arg1,arg2,arg3,arg4);
  
  *(librdf_statement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1statement(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_statement *arg1 = (librdf_statement *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_statement **)(void *)&jarg1; 
  librdf_free_statement(arg1);
  
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1statement_1get_1subject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_statement *arg1 = (librdf_statement *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_statement **)(void *)&jarg1; 
  result = (librdf_node *)librdf_statement_get_subject(arg1);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1statement_1set_1subject(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  librdf_statement *arg1 = (librdf_statement *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_statement **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  librdf_statement_set_subject(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1statement_1get_1predicate(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_statement *arg1 = (librdf_statement *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_statement **)(void *)&jarg1; 
  result = (librdf_node *)librdf_statement_get_predicate(arg1);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1statement_1set_1predicate(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  librdf_statement *arg1 = (librdf_statement *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_statement **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  librdf_statement_set_predicate(arg1,arg2);
  
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1statement_1get_1object(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_statement *arg1 = (librdf_statement *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_statement **)(void *)&jarg1; 
  result = (librdf_node *)librdf_statement_get_object(arg1);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1statement_1set_1object(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  librdf_statement *arg1 = (librdf_statement *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_statement **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  librdf_statement_set_object(arg1,arg2);
  
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1statement_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  librdf_statement *arg1 = (librdf_statement *) 0 ;
  librdf_statement *arg2 = (librdf_statement *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_statement **)(void *)&jarg1; 
  arg2 = *(librdf_statement **)(void *)&jarg2; 
  result = (int)librdf_statement_equals(arg1,arg2);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1statement_1match(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  librdf_statement *arg1 = (librdf_statement *) 0 ;
  librdf_statement *arg2 = (librdf_statement *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_statement **)(void *)&jarg1; 
  arg2 = *(librdf_statement **)(void *)&jarg2; 
  result = (int)librdf_statement_match(arg1,arg2);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1statement_1to_1string(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  librdf_statement *arg1 = (librdf_statement *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_statement **)(void *)&jarg1; 
  result = (char *)librdf_statement_to_string(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1model(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  librdf_storage *arg2 = (librdf_storage *) 0 ;
  char *arg3 = (char *) 0 ;
  librdf_model *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = *(librdf_storage **)(void *)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  result = (librdf_model *)librdf_new_model(arg1,arg2,arg3);
  
  *(librdf_model **)(void *)&jresult = result; 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1model_1with_1options(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  librdf_storage *arg2 = (librdf_storage *) 0 ;
  librdf_hash *arg3 = (librdf_hash *) 0 ;
  librdf_model *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = *(librdf_storage **)(void *)&jarg2; 
  arg3 = *(librdf_hash **)(void *)&jarg3; 
  result = (librdf_model *)librdf_new_model_with_options(arg1,arg2,arg3);
  
  *(librdf_model **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1model_1from_1model(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_model *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  result = (librdf_model *)librdf_new_model_from_model(arg1);
  
  *(librdf_model **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1model(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_model *arg1 = (librdf_model *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  librdf_free_model(arg1);
  
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1size(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  result = (int)librdf_model_size(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  librdf_node *arg4 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  arg4 = *(librdf_node **)(void *)&jarg4; 
  result = (int)librdf_model_add(arg1,arg2,arg3,arg4);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1add_1typed_1literal_1statement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jstring jarg4, jstring jarg5, jlong jarg6) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  librdf_uri *arg6 = (librdf_uri *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = *(librdf_uri **)(void *)&jarg6; 
  result = (int)librdf_model_add_typed_literal_statement(arg1,arg2,arg3,arg4,arg5,arg6);
  
  jresult = (jint)result; 
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
  if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5);
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1add_1statement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_statement *arg2 = (librdf_statement *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_statement **)(void *)&jarg2; 
  result = (int)librdf_model_add_statement(arg1,arg2);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1add_1statements(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_stream *arg2 = (librdf_stream *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_stream **)(void *)&jarg2; 
  result = (int)librdf_model_add_statements(arg1,arg2);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1remove_1statement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_statement *arg2 = (librdf_statement *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_statement **)(void *)&jarg2; 
  result = (int)librdf_model_remove_statement(arg1,arg2);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1contains_1statement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_statement *arg2 = (librdf_statement *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_statement **)(void *)&jarg2; 
  result = (int)librdf_model_contains_statement(arg1,arg2);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1as_1stream(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_stream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  result = (librdf_stream *)librdf_model_as_stream(arg1);
  
  *(librdf_stream **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1find_1statements(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_statement *arg2 = (librdf_statement *) 0 ;
  librdf_stream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_statement **)(void *)&jarg2; 
  result = (librdf_stream *)librdf_model_find_statements(arg1,arg2);
  
  *(librdf_stream **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1find_1statements_1in_1context(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_statement *arg2 = (librdf_statement *) 0 ;
  librdf_node *arg3 = (librdf_node *) NULL ;
  librdf_stream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_statement **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (librdf_stream *)librdf_model_find_statements_in_context(arg1,arg2,arg3);
  
  *(librdf_stream **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1get_1sources(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  librdf_iterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (librdf_iterator *)librdf_model_get_sources(arg1,arg2,arg3);
  
  *(librdf_iterator **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1get_1arcs(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  librdf_iterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (librdf_iterator *)librdf_model_get_arcs(arg1,arg2,arg3);
  
  *(librdf_iterator **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1get_1targets(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  librdf_iterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (librdf_iterator *)librdf_model_get_targets(arg1,arg2,arg3);
  
  *(librdf_iterator **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1get_1source(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (librdf_node *)librdf_model_get_source(arg1,arg2,arg3);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1get_1arc(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (librdf_node *)librdf_model_get_arc(arg1,arg2,arg3);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1get_1arcs_1out(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_iterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  result = (librdf_iterator *)librdf_model_get_arcs_out(arg1,arg2);
  
  *(librdf_iterator **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1get_1arcs_1in(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_iterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  result = (librdf_iterator *)librdf_model_get_arcs_in(arg1,arg2);
  
  *(librdf_iterator **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1has_1arc_1in(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (int)librdf_model_has_arc_in(arg1,arg2,arg3);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1has_1arc_1out(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (int)librdf_model_has_arc_out(arg1,arg2,arg3);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1get_1target(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (librdf_node *)librdf_model_get_target(arg1,arg2,arg3);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1context_1add_1statement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_statement *arg3 = (librdf_statement *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_statement **)(void *)&jarg3; 
  result = (int)librdf_model_context_add_statement(arg1,arg2,arg3);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1context_1add_1statements(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_stream *arg3 = (librdf_stream *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_stream **)(void *)&jarg3; 
  result = (int)librdf_model_context_add_statements(arg1,arg2,arg3);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1context_1remove_1statement(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_statement *arg3 = (librdf_statement *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  arg3 = *(librdf_statement **)(void *)&jarg3; 
  result = (int)librdf_model_context_remove_statement(arg1,arg2,arg3);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1context_1remove_1statements(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  result = (int)librdf_model_context_remove_statements(arg1,arg2);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1context_1as_1stream(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  librdf_stream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  result = (librdf_stream *)librdf_model_context_as_stream(arg1,arg2);
  
  *(librdf_stream **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1model_1sync(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_model *arg1 = (librdf_model *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  librdf_model_sync(arg1);
  
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1get_1contexts(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_iterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  result = (librdf_iterator *)librdf_model_get_contexts(arg1);
  
  *(librdf_iterator **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1contains_1context(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_node *arg2 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_node **)(void *)&jarg2; 
  result = (int)librdf_model_contains_context(arg1,arg2);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1get_1feature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  result = (librdf_node *)librdf_model_get_feature(arg1,arg2);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1set_1feature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (int)librdf_model_set_feature(arg1,arg2,arg3);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1model_1load(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jlong jarg5) {
  jint jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  char *arg3 = (char *) NULL ;
  char *arg4 = (char *) NULL ;
  librdf_uri *arg5 = (librdf_uri *) NULL ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = *(librdf_uri **)(void *)&jarg5; 
  result = (int)librdf_model_load(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5);
  
  jresult = (jint)result; 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1model_1query_1execute(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_query *arg2 = (librdf_query *) 0 ;
  librdf_query_results *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_query **)(void *)&jarg2; 
  result = (librdf_query_results *)librdf_model_query_execute(arg1,arg2);
  
  *(librdf_query_results **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1model_1to_1string(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jlong jarg5) {
  jstring jresult = 0 ;
  librdf_model *arg1 = (librdf_model *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  char *arg3 = (char *) NULL ;
  char *arg4 = (char *) NULL ;
  librdf_uri *arg5 = (librdf_uri *) NULL ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_model **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = *(librdf_uri **)(void *)&jarg5; 
  result = (char *)librdf_model_to_string(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
  free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1storage(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  librdf_storage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  result = (librdf_storage *)librdf_new_storage(arg1,arg2,arg3,arg4);
  
  *(librdf_storage **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1storage_1from_1storage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_storage *arg1 = (librdf_storage *) 0 ;
  librdf_storage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_storage **)(void *)&jarg1; 
  result = (librdf_storage *)librdf_new_storage_from_storage(arg1);
  
  *(librdf_storage **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1storage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_storage *arg1 = (librdf_storage *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_storage **)(void *)&jarg1; 
  librdf_free_storage(arg1);
  
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1parser(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  librdf_uri *arg4 = (librdf_uri *) 0 ;
  librdf_parser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = *(librdf_uri **)(void *)&jarg4; 
  result = (librdf_parser *)librdf_new_parser(arg1,(char const *)arg2,(char const *)arg3,arg4);
  
  *(librdf_parser **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1parser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_parser *arg1 = (librdf_parser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_parser **)(void *)&jarg1; 
  librdf_free_parser(arg1);
  
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1parser_1parse_1as_1stream(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  librdf_parser *arg1 = (librdf_parser *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_uri *arg3 = (librdf_uri *) NULL ;
  librdf_stream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_parser **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  arg3 = *(librdf_uri **)(void *)&jarg3; 
  result = (librdf_stream *)librdf_parser_parse_as_stream(arg1,arg2,arg3);
  
  *(librdf_stream **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1parser_1parse_1into_1model(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  librdf_parser *arg1 = (librdf_parser *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_uri *arg3 = (librdf_uri *) 0 ;
  librdf_model *arg4 = (librdf_model *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_parser **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  arg3 = *(librdf_uri **)(void *)&jarg3; 
  arg4 = *(librdf_model **)(void *)&jarg4; 
  result = (int)librdf_parser_parse_into_model(arg1,arg2,arg3,arg4);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1parser_1parse_1string_1as_1stream(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  librdf_parser *arg1 = (librdf_parser *) 0 ;
  char *arg2 = (char *) 0 ;
  librdf_uri *arg3 = (librdf_uri *) 0 ;
  librdf_stream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_parser **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(librdf_uri **)(void *)&jarg3; 
  result = (librdf_stream *)librdf_parser_parse_string_as_stream(arg1,(char const *)arg2,arg3);
  
  *(librdf_stream **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1parser_1parse_1string_1into_1model(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  librdf_parser *arg1 = (librdf_parser *) 0 ;
  char *arg2 = (char *) 0 ;
  librdf_uri *arg3 = (librdf_uri *) 0 ;
  librdf_model *arg4 = (librdf_model *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_parser **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(librdf_uri **)(void *)&jarg3; 
  arg4 = *(librdf_model **)(void *)&jarg4; 
  result = (int)librdf_parser_parse_string_into_model(arg1,(char const *)arg2,arg3,arg4);
  
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1parser_1parse_1counted_1string_1as_1stream(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  librdf_parser *arg1 = (librdf_parser *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  librdf_uri *arg4 = (librdf_uri *) 0 ;
  librdf_stream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_parser **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  arg4 = *(librdf_uri **)(void *)&jarg4; 
  result = (librdf_stream *)librdf_parser_parse_counted_string_as_stream(arg1,(char const *)arg2,arg3,arg4);
  
  *(librdf_stream **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1parser_1parse_1counted_1string_1into_1model(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jint jresult = 0 ;
  librdf_parser *arg1 = (librdf_parser *) 0 ;
  char *arg2 = (char *) 0 ;
  size_t arg3 ;
  librdf_uri *arg4 = (librdf_uri *) 0 ;
  librdf_model *arg5 = (librdf_model *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_parser **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  arg4 = *(librdf_uri **)(void *)&jarg4; 
  arg5 = *(librdf_model **)(void *)&jarg5; 
  result = (int)librdf_parser_parse_counted_string_into_model(arg1,(char const *)arg2,arg3,arg4,arg5);
  
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1parser_1get_1feature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  librdf_parser *arg1 = (librdf_parser *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_parser **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  result = (librdf_node *)librdf_parser_get_feature(arg1,arg2);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1parser_1set_1feature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  librdf_parser *arg1 = (librdf_parser *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_parser **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (int)librdf_parser_set_feature(arg1,arg2,arg3);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1query(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jstring jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) 0 ;
  librdf_uri *arg3 = (librdf_uri *) 0 ;
  char *arg4 = (char *) 0 ;
  librdf_uri *arg5 = (librdf_uri *) 0 ;
  librdf_query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(librdf_uri **)(void *)&jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = *(librdf_uri **)(void *)&jarg5; 
  result = (librdf_query *)librdf_new_query(arg1,(char const *)arg2,arg3,(char const *)arg4,arg5);
  
  *(librdf_query **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1query_1from_1query(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_query *arg1 = (librdf_query *) 0 ;
  librdf_query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query **)(void *)&jarg1; 
  result = (librdf_query *)librdf_new_query_from_query(arg1);
  
  *(librdf_query **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1query(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_query *arg1 = (librdf_query *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query **)(void *)&jarg1; 
  librdf_free_query(arg1);
  
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1query_1execute(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  librdf_query *arg1 = (librdf_query *) 0 ;
  librdf_model *arg2 = (librdf_model *) 0 ;
  librdf_query_results *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query **)(void *)&jarg1; 
  arg2 = *(librdf_model **)(void *)&jarg2; 
  result = (librdf_query_results *)librdf_query_execute(arg1,arg2);
  
  *(librdf_query_results **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1get_1limit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_query *arg1 = (librdf_query *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query **)(void *)&jarg1; 
  result = (int)librdf_query_get_limit(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1set_1limit(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  librdf_query *arg1 = (librdf_query *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)librdf_query_set_limit(arg1,arg2);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1get_1offset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_query *arg1 = (librdf_query *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query **)(void *)&jarg1; 
  result = (int)librdf_query_get_offset(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1set_1offset(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  librdf_query *arg1 = (librdf_query *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)librdf_query_set_offset(arg1,arg2);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1as_1stream(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  librdf_stream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  result = (librdf_stream *)librdf_query_results_as_stream(arg1);
  
  *(librdf_stream **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1get_1count(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  result = (int)librdf_query_results_get_count(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1next(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  result = (int)librdf_query_results_next(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1finished(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  result = (int)librdf_query_results_finished(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1get_1binding_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  int arg2 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  result = (librdf_node *)librdf_query_results_get_binding_value(arg1,arg2);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1get_1binding_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)librdf_query_results_get_binding_name(arg1,arg2);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1get_1binding_1value_1by_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  char *arg2 = (char *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  result = (librdf_node *)librdf_query_results_get_binding_value_by_name(arg1,(char const *)arg2);
  
  *(librdf_node **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1get_1bindings_1count(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  result = (int)librdf_query_results_get_bindings_count(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1to_1file(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  char *arg2 = (char *) 0 ;
  librdf_uri *arg3 = (librdf_uri *) 0 ;
  librdf_uri *arg4 = (librdf_uri *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(librdf_uri **)(void *)&jarg3; 
  arg4 = *(librdf_uri **)(void *)&jarg4; 
  result = (int)librdf_query_results_to_file(arg1,(char const *)arg2,arg3,arg4);
  
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1to_1string(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_uri *arg3 = (librdf_uri *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  arg3 = *(librdf_uri **)(void *)&jarg3; 
  result = (char *)librdf_query_results_to_string(arg1,arg2,arg3);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  free(result);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1query_1results(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  librdf_free_query_results(arg1);
  
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1is_1bindings(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  result = (int)librdf_query_results_is_bindings(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1is_1boolean(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  result = (int)librdf_query_results_is_boolean(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1is_1graph(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  result = (int)librdf_query_results_is_graph(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1query_1results_1get_1boolean(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_query_results *arg1 = (librdf_query_results *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_query_results **)(void *)&jarg1; 
  result = (int)librdf_query_results_get_boolean(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1new_1serializer(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  librdf_world *arg1 = (librdf_world *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  librdf_uri *arg4 = (librdf_uri *) 0 ;
  librdf_serializer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = *(librdf_uri **)(void *)&jarg4; 
  result = (librdf_serializer *)librdf_new_serializer(arg1,(char const *)arg2,(char const *)arg3,arg4);
  
  *(librdf_serializer **)(void *)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1serializer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_serializer *arg1 = (librdf_serializer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_serializer **)(void *)&jarg1; 
  librdf_free_serializer(arg1);
  
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1serializer_1serialize_1model_1to_1file(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  librdf_serializer *arg1 = (librdf_serializer *) 0 ;
  char *arg2 = (char *) 0 ;
  librdf_uri *arg3 = (librdf_uri *) 0 ;
  librdf_model *arg4 = (librdf_model *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_serializer **)(void *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(librdf_uri **)(void *)&jarg3; 
  arg4 = *(librdf_model **)(void *)&jarg4; 
  result = (int)librdf_serializer_serialize_model_to_file(arg1,(char const *)arg2,arg3,arg4);
  
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1serializer_1serialize_1model_1to_1string(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  librdf_serializer *arg1 = (librdf_serializer *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_model *arg3 = (librdf_model *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_serializer **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  arg3 = *(librdf_model **)(void *)&jarg3; 
  result = (char *)librdf_serializer_serialize_model_to_string(arg1,arg2,arg3);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  free(result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1serializer_1get_1feature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  librdf_serializer *arg1 = (librdf_serializer *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_serializer **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  result = (librdf_node *)librdf_serializer_get_feature(arg1,arg2);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1serializer_1set_1feature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  librdf_serializer *arg1 = (librdf_serializer *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  librdf_node *arg3 = (librdf_node *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_serializer **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  arg3 = *(librdf_node **)(void *)&jarg3; 
  result = (int)librdf_serializer_set_feature(arg1,arg2,arg3);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1serializer_1set_1namespace(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
  jint jresult = 0 ;
  librdf_serializer *arg1 = (librdf_serializer *) 0 ;
  librdf_uri *arg2 = (librdf_uri *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_serializer **)(void *)&jarg1; 
  arg2 = *(librdf_uri **)(void *)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)librdf_serializer_set_namespace(arg1,arg2,(char const *)arg3);
  
  jresult = (jint)result; 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1free_1stream(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_stream *arg1 = (librdf_stream *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_stream **)(void *)&jarg1; 
  librdf_free_stream(arg1);
  
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1stream_1end(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_stream *arg1 = (librdf_stream *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_stream **)(void *)&jarg1; 
  result = (int)librdf_stream_end(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1stream_1next(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_stream *arg1 = (librdf_stream *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_stream **)(void *)&jarg1; 
  result = (int)librdf_stream_next(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1stream_1get_1object(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_stream *arg1 = (librdf_stream *) 0 ;
  librdf_statement *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_stream **)(void *)&jarg1; 
  result = (librdf_statement *)librdf_stream_get_object(arg1);
  
  *(librdf_statement **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1stream_1get_1context(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_stream *arg1 = (librdf_stream *) 0 ;
  librdf_node *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_stream **)(void *)&jarg1; 
  result = (librdf_node *)librdf_stream_get_context(arg1);
  
  *(librdf_node **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1log_1message_1code(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_log_message *arg1 = (librdf_log_message *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_log_message **)(void *)&jarg1; 
  result = (int)librdf_log_message_code(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1log_1message_1level(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_log_message *arg1 = (librdf_log_message *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_log_message **)(void *)&jarg1; 
  result = (int)librdf_log_message_level(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_librdf_1log_1message_1facility(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  librdf_log_message *arg1 = (librdf_log_message *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_log_message **)(void *)&jarg1; 
  result = (int)librdf_log_message_facility(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1log_1message_1message(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  librdf_log_message *arg1 = (librdf_log_message *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_log_message **)(void *)&jarg1; 
  result = (char *)librdf_log_message_message(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1log_1message_1locator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  librdf_log_message *arg1 = (librdf_log_message *) 0 ;
  raptor_locator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_log_message **)(void *)&jarg1; 
  result = (raptor_locator *)librdf_log_message_locator(arg1);
  
  *(raptor_locator **)(void *)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_raptor_1locator_1line(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  raptor_locator *arg1 = (raptor_locator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(raptor_locator **)(void *)&jarg1; 
  result = (int)raptor_locator_line(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_raptor_1locator_1column(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  raptor_locator *arg1 = (raptor_locator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(raptor_locator **)(void *)&jarg1; 
  result = (int)raptor_locator_column(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_librdf_redland_core_raptor_1locator_1byte(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  raptor_locator *arg1 = (raptor_locator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(raptor_locator **)(void *)&jarg1; 
  result = (int)raptor_locator_byte(arg1);
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_raptor_1locator_1file(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  raptor_locator *arg1 = (raptor_locator *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(raptor_locator **)(void *)&jarg1; 
  result = (char *)raptor_locator_file(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_raptor_1locator_1uri(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  raptor_locator *arg1 = (raptor_locator *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(raptor_locator **)(void *)&jarg1; 
  result = (char *)raptor_locator_uri(arg1);
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1internal_1test_1error(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_world *arg1 = (librdf_world *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  librdf_internal_test_error(arg1);
  
}


JNIEXPORT void JNICALL Java_org_librdf_redland_core_librdf_1internal_1test_1warning(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  librdf_world *arg1 = (librdf_world *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(librdf_world **)(void *)&jarg1; 
  librdf_internal_test_warning(arg1);
  
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1short_1copyright_1string_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)librdf_short_copyright_string;
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1copyright_1string_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)librdf_copyright_string;
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_org_librdf_redland_core_librdf_1version_1string_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)librdf_version_string;
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1version_1major_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(unsigned int)librdf_version_major;
  
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1version_1minor_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(unsigned int)librdf_version_minor;
  
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1version_1release_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(unsigned int)librdf_version_release;
  
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_librdf_redland_core_librdf_1version_1decimal_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(unsigned int)librdf_version_decimal;
  
  jresult = (jlong)result; 
  return jresult;
}


#ifdef __cplusplus
}
#endif

/* compile-time include (inside a % ... % block) */
#ifdef REDLAND_INIT_I
#include <redland-init.i>
#endif


