/*
 * Copyright (C) 2000, 2001, 2002 Loic Dachary <loic@senga.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

/*
 * If configure.in has not defined this symbol, assume const. It
 * does not harm much: a warning will be issued during compilation.
 */
#ifndef ICONV_CONST
#define ICONV_CONST
#endif /* ICONV_CONST */

#include <stdlib.h>
#include <string.h>
#include <iconv.h>
#include <errno.h>
#ifdef HAVE_VSNPRINTF
#include <stdio.h>
#include <stdarg.h>
#endif /* HAVE_VSNPRINTF */

#include "unac.h"

/* Generated by builder. Do not modify. Start tables */
/*
 * 00A0 NO-BREAK SPACE
 * 	0020 SPACE
 * 00A8 DIAERESIS
 * 	0020 SPACE
 * 00AA FEMININE ORDINAL INDICATOR
 * 	0061 LATIN SMALL LETTER A
 * 00AF MACRON
 * 	0020 SPACE
 * 00B2 SUPERSCRIPT TWO
 * 	0032 DIGIT TWO
 * 00B3 SUPERSCRIPT THREE
 * 	0033 DIGIT THREE
 * 00B4 ACUTE ACCENT
 * 	0020 SPACE
 * 00B5 MICRO SIGN
 * 	03BC GREEK SMALL LETTER MU
 * 00B8 CEDILLA
 * 	0020 SPACE
 * 00B9 SUPERSCRIPT ONE
 * 	0031 DIGIT ONE
 * 00BA MASCULINE ORDINAL INDICATOR
 * 	006F LATIN SMALL LETTER O
 * 00BC VULGAR FRACTION ONE QUARTER
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 	0034 DIGIT FOUR
 * 00BD VULGAR FRACTION ONE HALF
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 	0032 DIGIT TWO
 * 00BE VULGAR FRACTION THREE QUARTERS
 * 	0033 DIGIT THREE
 * 	2044 FRACTION SLASH
 * 	0034 DIGIT FOUR
 * 00C0 LATIN CAPITAL LETTER A WITH GRAVE
 * 	0041 LATIN CAPITAL LETTER A
 * 00C1 LATIN CAPITAL LETTER A WITH ACUTE
 * 	0041 LATIN CAPITAL LETTER A
 * 00C2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
 * 	0041 LATIN CAPITAL LETTER A
 * 00C3 LATIN CAPITAL LETTER A WITH TILDE
 * 	0041 LATIN CAPITAL LETTER A
 * 00C4 LATIN CAPITAL LETTER A WITH DIAERESIS
 * 	0041 LATIN CAPITAL LETTER A
 * 00C5 LATIN CAPITAL LETTER A WITH RING ABOVE
 * 	0041 LATIN CAPITAL LETTER A
 * 00C6 LATIN CAPITAL LETTER AE
 * 	0041 LATIN CAPITAL LETTER A
 * 	0045 LATIN CAPITAL LETTER E
 * 00C7 LATIN CAPITAL LETTER C WITH CEDILLA
 * 	0043 LATIN CAPITAL LETTER C
 * 00C8 LATIN CAPITAL LETTER E WITH GRAVE
 * 	0045 LATIN CAPITAL LETTER E
 * 00C9 LATIN CAPITAL LETTER E WITH ACUTE
 * 	0045 LATIN CAPITAL LETTER E
 * 00CA LATIN CAPITAL LETTER E WITH CIRCUMFLEX
 * 	0045 LATIN CAPITAL LETTER E
 * 00CB LATIN CAPITAL LETTER E WITH DIAERESIS
 * 	0045 LATIN CAPITAL LETTER E
 * 00CC LATIN CAPITAL LETTER I WITH GRAVE
 * 	0049 LATIN CAPITAL LETTER I
 * 00CD LATIN CAPITAL LETTER I WITH ACUTE
 * 	0049 LATIN CAPITAL LETTER I
 * 00CE LATIN CAPITAL LETTER I WITH CIRCUMFLEX
 * 	0049 LATIN CAPITAL LETTER I
 * 00CF LATIN CAPITAL LETTER I WITH DIAERESIS
 * 	0049 LATIN CAPITAL LETTER I
 * 00D1 LATIN CAPITAL LETTER N WITH TILDE
 * 	004E LATIN CAPITAL LETTER N
 * 00D2 LATIN CAPITAL LETTER O WITH GRAVE
 * 	004F LATIN CAPITAL LETTER O
 * 00D3 LATIN CAPITAL LETTER O WITH ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 00D4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
 * 	004F LATIN CAPITAL LETTER O
 * 00D5 LATIN CAPITAL LETTER O WITH TILDE
 * 	004F LATIN CAPITAL LETTER O
 * 00D6 LATIN CAPITAL LETTER O WITH DIAERESIS
 * 	004F LATIN CAPITAL LETTER O
 * 00D8 LATIN CAPITAL LETTER O WITH STROKE
 * 	004F LATIN CAPITAL LETTER O
 * 00D9 LATIN CAPITAL LETTER U WITH GRAVE
 * 	0055 LATIN CAPITAL LETTER U
 * 00DA LATIN CAPITAL LETTER U WITH ACUTE
 * 	0055 LATIN CAPITAL LETTER U
 * 00DB LATIN CAPITAL LETTER U WITH CIRCUMFLEX
 * 	0055 LATIN CAPITAL LETTER U
 * 00DC LATIN CAPITAL LETTER U WITH DIAERESIS
 * 	0055 LATIN CAPITAL LETTER U
 * 00DD LATIN CAPITAL LETTER Y WITH ACUTE
 * 	0059 LATIN CAPITAL LETTER Y
 * 00E0 LATIN SMALL LETTER A WITH GRAVE
 * 	0061 LATIN SMALL LETTER A
 * 00E1 LATIN SMALL LETTER A WITH ACUTE
 * 	0061 LATIN SMALL LETTER A
 * 00E2 LATIN SMALL LETTER A WITH CIRCUMFLEX
 * 	0061 LATIN SMALL LETTER A
 * 00E3 LATIN SMALL LETTER A WITH TILDE
 * 	0061 LATIN SMALL LETTER A
 * 00E4 LATIN SMALL LETTER A WITH DIAERESIS
 * 	0061 LATIN SMALL LETTER A
 * 00E5 LATIN SMALL LETTER A WITH RING ABOVE
 * 	0061 LATIN SMALL LETTER A
 * 00E6 LATIN SMALL LETTER AE
 * 	0061 LATIN SMALL LETTER A
 * 	0065 LATIN SMALL LETTER E
 * 00E7 LATIN SMALL LETTER C WITH CEDILLA
 * 	0063 LATIN SMALL LETTER C
 * 00E8 LATIN SMALL LETTER E WITH GRAVE
 * 	0065 LATIN SMALL LETTER E
 * 00E9 LATIN SMALL LETTER E WITH ACUTE
 * 	0065 LATIN SMALL LETTER E
 * 00EA LATIN SMALL LETTER E WITH CIRCUMFLEX
 * 	0065 LATIN SMALL LETTER E
 * 00EB LATIN SMALL LETTER E WITH DIAERESIS
 * 	0065 LATIN SMALL LETTER E
 * 00EC LATIN SMALL LETTER I WITH GRAVE
 * 	0069 LATIN SMALL LETTER I
 * 00ED LATIN SMALL LETTER I WITH ACUTE
 * 	0069 LATIN SMALL LETTER I
 * 00EE LATIN SMALL LETTER I WITH CIRCUMFLEX
 * 	0069 LATIN SMALL LETTER I
 * 00EF LATIN SMALL LETTER I WITH DIAERESIS
 * 	0069 LATIN SMALL LETTER I
 * 00F1 LATIN SMALL LETTER N WITH TILDE
 * 	006E LATIN SMALL LETTER N
 * 00F2 LATIN SMALL LETTER O WITH GRAVE
 * 	006F LATIN SMALL LETTER O
 * 00F3 LATIN SMALL LETTER O WITH ACUTE
 * 	006F LATIN SMALL LETTER O
 * 00F4 LATIN SMALL LETTER O WITH CIRCUMFLEX
 * 	006F LATIN SMALL LETTER O
 * 00F5 LATIN SMALL LETTER O WITH TILDE
 * 	006F LATIN SMALL LETTER O
 * 00F6 LATIN SMALL LETTER O WITH DIAERESIS
 * 	006F LATIN SMALL LETTER O
 * 00F8 LATIN SMALL LETTER O WITH STROKE
 * 	006F LATIN SMALL LETTER O
 * 00F9 LATIN SMALL LETTER U WITH GRAVE
 * 	0075 LATIN SMALL LETTER U
 * 00FA LATIN SMALL LETTER U WITH ACUTE
 * 	0075 LATIN SMALL LETTER U
 * 00FB LATIN SMALL LETTER U WITH CIRCUMFLEX
 * 	0075 LATIN SMALL LETTER U
 * 00FC LATIN SMALL LETTER U WITH DIAERESIS
 * 	0075 LATIN SMALL LETTER U
 * 00FD LATIN SMALL LETTER Y WITH ACUTE
 * 	0079 LATIN SMALL LETTER Y
 * 00FF LATIN SMALL LETTER Y WITH DIAERESIS
 * 	0079 LATIN SMALL LETTER Y
 * 0100 LATIN CAPITAL LETTER A WITH MACRON
 * 	0041 LATIN CAPITAL LETTER A
 * 0101 LATIN SMALL LETTER A WITH MACRON
 * 	0061 LATIN SMALL LETTER A
 * 0102 LATIN CAPITAL LETTER A WITH BREVE
 * 	0041 LATIN CAPITAL LETTER A
 * 0103 LATIN SMALL LETTER A WITH BREVE
 * 	0061 LATIN SMALL LETTER A
 * 0104 LATIN CAPITAL LETTER A WITH OGONEK
 * 	0041 LATIN CAPITAL LETTER A
 * 0105 LATIN SMALL LETTER A WITH OGONEK
 * 	0061 LATIN SMALL LETTER A
 * 0106 LATIN CAPITAL LETTER C WITH ACUTE
 * 	0043 LATIN CAPITAL LETTER C
 * 0107 LATIN SMALL LETTER C WITH ACUTE
 * 	0063 LATIN SMALL LETTER C
 * 0108 LATIN CAPITAL LETTER C WITH CIRCUMFLEX
 * 	0043 LATIN CAPITAL LETTER C
 * 0109 LATIN SMALL LETTER C WITH CIRCUMFLEX
 * 	0063 LATIN SMALL LETTER C
 * 010A LATIN CAPITAL LETTER C WITH DOT ABOVE
 * 	0043 LATIN CAPITAL LETTER C
 * 010B LATIN SMALL LETTER C WITH DOT ABOVE
 * 	0063 LATIN SMALL LETTER C
 * 010C LATIN CAPITAL LETTER C WITH CARON
 * 	0043 LATIN CAPITAL LETTER C
 * 010D LATIN SMALL LETTER C WITH CARON
 * 	0063 LATIN SMALL LETTER C
 * 010E LATIN CAPITAL LETTER D WITH CARON
 * 	0044 LATIN CAPITAL LETTER D
 * 010F LATIN SMALL LETTER D WITH CARON
 * 	0064 LATIN SMALL LETTER D
 * 0112 LATIN CAPITAL LETTER E WITH MACRON
 * 	0045 LATIN CAPITAL LETTER E
 * 0113 LATIN SMALL LETTER E WITH MACRON
 * 	0065 LATIN SMALL LETTER E
 * 0114 LATIN CAPITAL LETTER E WITH BREVE
 * 	0045 LATIN CAPITAL LETTER E
 * 0115 LATIN SMALL LETTER E WITH BREVE
 * 	0065 LATIN SMALL LETTER E
 * 0116 LATIN CAPITAL LETTER E WITH DOT ABOVE
 * 	0045 LATIN CAPITAL LETTER E
 * 0117 LATIN SMALL LETTER E WITH DOT ABOVE
 * 	0065 LATIN SMALL LETTER E
 * 0118 LATIN CAPITAL LETTER E WITH OGONEK
 * 	0045 LATIN CAPITAL LETTER E
 * 0119 LATIN SMALL LETTER E WITH OGONEK
 * 	0065 LATIN SMALL LETTER E
 * 011A LATIN CAPITAL LETTER E WITH CARON
 * 	0045 LATIN CAPITAL LETTER E
 * 011B LATIN SMALL LETTER E WITH CARON
 * 	0065 LATIN SMALL LETTER E
 * 011C LATIN CAPITAL LETTER G WITH CIRCUMFLEX
 * 	0047 LATIN CAPITAL LETTER G
 * 011D LATIN SMALL LETTER G WITH CIRCUMFLEX
 * 	0067 LATIN SMALL LETTER G
 * 011E LATIN CAPITAL LETTER G WITH BREVE
 * 	0047 LATIN CAPITAL LETTER G
 * 011F LATIN SMALL LETTER G WITH BREVE
 * 	0067 LATIN SMALL LETTER G
 * 0120 LATIN CAPITAL LETTER G WITH DOT ABOVE
 * 	0047 LATIN CAPITAL LETTER G
 * 0121 LATIN SMALL LETTER G WITH DOT ABOVE
 * 	0067 LATIN SMALL LETTER G
 * 0122 LATIN CAPITAL LETTER G WITH CEDILLA
 * 	0047 LATIN CAPITAL LETTER G
 * 0123 LATIN SMALL LETTER G WITH CEDILLA
 * 	0067 LATIN SMALL LETTER G
 * 0124 LATIN CAPITAL LETTER H WITH CIRCUMFLEX
 * 	0048 LATIN CAPITAL LETTER H
 * 0125 LATIN SMALL LETTER H WITH CIRCUMFLEX
 * 	0068 LATIN SMALL LETTER H
 * 0128 LATIN CAPITAL LETTER I WITH TILDE
 * 	0049 LATIN CAPITAL LETTER I
 * 0129 LATIN SMALL LETTER I WITH TILDE
 * 	0069 LATIN SMALL LETTER I
 * 012A LATIN CAPITAL LETTER I WITH MACRON
 * 	0049 LATIN CAPITAL LETTER I
 * 012B LATIN SMALL LETTER I WITH MACRON
 * 	0069 LATIN SMALL LETTER I
 * 012C LATIN CAPITAL LETTER I WITH BREVE
 * 	0049 LATIN CAPITAL LETTER I
 * 012D LATIN SMALL LETTER I WITH BREVE
 * 	0069 LATIN SMALL LETTER I
 * 012E LATIN CAPITAL LETTER I WITH OGONEK
 * 	0049 LATIN CAPITAL LETTER I
 * 012F LATIN SMALL LETTER I WITH OGONEK
 * 	0069 LATIN SMALL LETTER I
 * 0130 LATIN CAPITAL LETTER I WITH DOT ABOVE
 * 	0049 LATIN CAPITAL LETTER I
 * 0132 LATIN CAPITAL LIGATURE IJ
 * 	0049 LATIN CAPITAL LETTER I
 * 	004A LATIN CAPITAL LETTER J
 * 0133 LATIN SMALL LIGATURE IJ
 * 	0069 LATIN SMALL LETTER I
 * 	006A LATIN SMALL LETTER J
 * 0134 LATIN CAPITAL LETTER J WITH CIRCUMFLEX
 * 	004A LATIN CAPITAL LETTER J
 * 0135 LATIN SMALL LETTER J WITH CIRCUMFLEX
 * 	006A LATIN SMALL LETTER J
 * 0136 LATIN CAPITAL LETTER K WITH CEDILLA
 * 	004B LATIN CAPITAL LETTER K
 * 0137 LATIN SMALL LETTER K WITH CEDILLA
 * 	006B LATIN SMALL LETTER K
 * 0139 LATIN CAPITAL LETTER L WITH ACUTE
 * 	004C LATIN CAPITAL LETTER L
 * 013A LATIN SMALL LETTER L WITH ACUTE
 * 	006C LATIN SMALL LETTER L
 * 013B LATIN CAPITAL LETTER L WITH CEDILLA
 * 	004C LATIN CAPITAL LETTER L
 * 013C LATIN SMALL LETTER L WITH CEDILLA
 * 	006C LATIN SMALL LETTER L
 * 013D LATIN CAPITAL LETTER L WITH CARON
 * 	004C LATIN CAPITAL LETTER L
 * 013E LATIN SMALL LETTER L WITH CARON
 * 	006C LATIN SMALL LETTER L
 * 013F LATIN CAPITAL LETTER L WITH MIDDLE DOT
 * 	004C LATIN CAPITAL LETTER L
 * 	00B7 MIDDLE DOT
 * 0140 LATIN SMALL LETTER L WITH MIDDLE DOT
 * 	006C LATIN SMALL LETTER L
 * 	00B7 MIDDLE DOT
 * 0143 LATIN CAPITAL LETTER N WITH ACUTE
 * 	004E LATIN CAPITAL LETTER N
 * 0144 LATIN SMALL LETTER N WITH ACUTE
 * 	006E LATIN SMALL LETTER N
 * 0145 LATIN CAPITAL LETTER N WITH CEDILLA
 * 	004E LATIN CAPITAL LETTER N
 * 0146 LATIN SMALL LETTER N WITH CEDILLA
 * 	006E LATIN SMALL LETTER N
 * 0147 LATIN CAPITAL LETTER N WITH CARON
 * 	004E LATIN CAPITAL LETTER N
 * 0148 LATIN SMALL LETTER N WITH CARON
 * 	006E LATIN SMALL LETTER N
 * 0149 LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
 * 	02BC MODIFIER LETTER APOSTROPHE
 * 	006E LATIN SMALL LETTER N
 * 014C LATIN CAPITAL LETTER O WITH MACRON
 * 	004F LATIN CAPITAL LETTER O
 * 014D LATIN SMALL LETTER O WITH MACRON
 * 	006F LATIN SMALL LETTER O
 * 014E LATIN CAPITAL LETTER O WITH BREVE
 * 	004F LATIN CAPITAL LETTER O
 * 014F LATIN SMALL LETTER O WITH BREVE
 * 	006F LATIN SMALL LETTER O
 * 0150 LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 0151 LATIN SMALL LETTER O WITH DOUBLE ACUTE
 * 	006F LATIN SMALL LETTER O
 * 0154 LATIN CAPITAL LETTER R WITH ACUTE
 * 	0052 LATIN CAPITAL LETTER R
 * 0155 LATIN SMALL LETTER R WITH ACUTE
 * 	0072 LATIN SMALL LETTER R
 * 0156 LATIN CAPITAL LETTER R WITH CEDILLA
 * 	0052 LATIN CAPITAL LETTER R
 * 0157 LATIN SMALL LETTER R WITH CEDILLA
 * 	0072 LATIN SMALL LETTER R
 * 0158 LATIN CAPITAL LETTER R WITH CARON
 * 	0052 LATIN CAPITAL LETTER R
 * 0159 LATIN SMALL LETTER R WITH CARON
 * 	0072 LATIN SMALL LETTER R
 * 015A LATIN CAPITAL LETTER S WITH ACUTE
 * 	0053 LATIN CAPITAL LETTER S
 * 015B LATIN SMALL LETTER S WITH ACUTE
 * 	0073 LATIN SMALL LETTER S
 * 015C LATIN CAPITAL LETTER S WITH CIRCUMFLEX
 * 	0053 LATIN CAPITAL LETTER S
 * 015D LATIN SMALL LETTER S WITH CIRCUMFLEX
 * 	0073 LATIN SMALL LETTER S
 * 015E LATIN CAPITAL LETTER S WITH CEDILLA
 * 	0053 LATIN CAPITAL LETTER S
 * 015F LATIN SMALL LETTER S WITH CEDILLA
 * 	0073 LATIN SMALL LETTER S
 * 0160 LATIN CAPITAL LETTER S WITH CARON
 * 	0053 LATIN CAPITAL LETTER S
 * 0161 LATIN SMALL LETTER S WITH CARON
 * 	0073 LATIN SMALL LETTER S
 * 0162 LATIN CAPITAL LETTER T WITH CEDILLA
 * 	0054 LATIN CAPITAL LETTER T
 * 0163 LATIN SMALL LETTER T WITH CEDILLA
 * 	0074 LATIN SMALL LETTER T
 * 0164 LATIN CAPITAL LETTER T WITH CARON
 * 	0054 LATIN CAPITAL LETTER T
 * 0165 LATIN SMALL LETTER T WITH CARON
 * 	0074 LATIN SMALL LETTER T
 * 0168 LATIN CAPITAL LETTER U WITH TILDE
 * 	0055 LATIN CAPITAL LETTER U
 * 0169 LATIN SMALL LETTER U WITH TILDE
 * 	0075 LATIN SMALL LETTER U
 * 016A LATIN CAPITAL LETTER U WITH MACRON
 * 	0055 LATIN CAPITAL LETTER U
 * 016B LATIN SMALL LETTER U WITH MACRON
 * 	0075 LATIN SMALL LETTER U
 * 016C LATIN CAPITAL LETTER U WITH BREVE
 * 	0055 LATIN CAPITAL LETTER U
 * 016D LATIN SMALL LETTER U WITH BREVE
 * 	0075 LATIN SMALL LETTER U
 * 016E LATIN CAPITAL LETTER U WITH RING ABOVE
 * 	0055 LATIN CAPITAL LETTER U
 * 016F LATIN SMALL LETTER U WITH RING ABOVE
 * 	0075 LATIN SMALL LETTER U
 * 0170 LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
 * 	0055 LATIN CAPITAL LETTER U
 * 0171 LATIN SMALL LETTER U WITH DOUBLE ACUTE
 * 	0075 LATIN SMALL LETTER U
 * 0172 LATIN CAPITAL LETTER U WITH OGONEK
 * 	0055 LATIN CAPITAL LETTER U
 * 0173 LATIN SMALL LETTER U WITH OGONEK
 * 	0075 LATIN SMALL LETTER U
 * 0174 LATIN CAPITAL LETTER W WITH CIRCUMFLEX
 * 	0057 LATIN CAPITAL LETTER W
 * 0175 LATIN SMALL LETTER W WITH CIRCUMFLEX
 * 	0077 LATIN SMALL LETTER W
 * 0176 LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
 * 	0059 LATIN CAPITAL LETTER Y
 * 0177 LATIN SMALL LETTER Y WITH CIRCUMFLEX
 * 	0079 LATIN SMALL LETTER Y
 * 0178 LATIN CAPITAL LETTER Y WITH DIAERESIS
 * 	0059 LATIN CAPITAL LETTER Y
 * 0179 LATIN CAPITAL LETTER Z WITH ACUTE
 * 	005A LATIN CAPITAL LETTER Z
 * 017A LATIN SMALL LETTER Z WITH ACUTE
 * 	007A LATIN SMALL LETTER Z
 * 017B LATIN CAPITAL LETTER Z WITH DOT ABOVE
 * 	005A LATIN CAPITAL LETTER Z
 * 017C LATIN SMALL LETTER Z WITH DOT ABOVE
 * 	007A LATIN SMALL LETTER Z
 * 017D LATIN CAPITAL LETTER Z WITH CARON
 * 	005A LATIN CAPITAL LETTER Z
 * 017E LATIN SMALL LETTER Z WITH CARON
 * 	007A LATIN SMALL LETTER Z
 * 017F LATIN SMALL LETTER LONG S
 * 	0073 LATIN SMALL LETTER S
 * 01A0 LATIN CAPITAL LETTER O WITH HORN
 * 	004F LATIN CAPITAL LETTER O
 * 01A1 LATIN SMALL LETTER O WITH HORN
 * 	006F LATIN SMALL LETTER O
 * 01AF LATIN CAPITAL LETTER U WITH HORN
 * 	0055 LATIN CAPITAL LETTER U
 * 01B0 LATIN SMALL LETTER U WITH HORN
 * 	0075 LATIN SMALL LETTER U
 * 01C4 LATIN CAPITAL LETTER DZ WITH CARON
 * 	0044 LATIN CAPITAL LETTER D
 * 	005A LATIN CAPITAL LETTER Z
 * 01C5 LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
 * 	0044 LATIN CAPITAL LETTER D
 * 	007A LATIN SMALL LETTER Z
 * 01C6 LATIN SMALL LETTER DZ WITH CARON
 * 	0064 LATIN SMALL LETTER D
 * 	007A LATIN SMALL LETTER Z
 * 01C7 LATIN CAPITAL LETTER LJ
 * 	004C LATIN CAPITAL LETTER L
 * 	004A LATIN CAPITAL LETTER J
 * 01C8 LATIN CAPITAL LETTER L WITH SMALL LETTER J
 * 	004C LATIN CAPITAL LETTER L
 * 	006A LATIN SMALL LETTER J
 * 01C9 LATIN SMALL LETTER LJ
 * 	006C LATIN SMALL LETTER L
 * 	006A LATIN SMALL LETTER J
 * 01CA LATIN CAPITAL LETTER NJ
 * 	004E LATIN CAPITAL LETTER N
 * 	004A LATIN CAPITAL LETTER J
 * 01CB LATIN CAPITAL LETTER N WITH SMALL LETTER J
 * 	004E LATIN CAPITAL LETTER N
 * 	006A LATIN SMALL LETTER J
 * 01CC LATIN SMALL LETTER NJ
 * 	006E LATIN SMALL LETTER N
 * 	006A LATIN SMALL LETTER J
 * 01CD LATIN CAPITAL LETTER A WITH CARON
 * 	0041 LATIN CAPITAL LETTER A
 * 01CE LATIN SMALL LETTER A WITH CARON
 * 	0061 LATIN SMALL LETTER A
 * 01CF LATIN CAPITAL LETTER I WITH CARON
 * 	0049 LATIN CAPITAL LETTER I
 * 01D0 LATIN SMALL LETTER I WITH CARON
 * 	0069 LATIN SMALL LETTER I
 * 01D1 LATIN CAPITAL LETTER O WITH CARON
 * 	004F LATIN CAPITAL LETTER O
 * 01D2 LATIN SMALL LETTER O WITH CARON
 * 	006F LATIN SMALL LETTER O
 * 01D3 LATIN CAPITAL LETTER U WITH CARON
 * 	0055 LATIN CAPITAL LETTER U
 * 01D4 LATIN SMALL LETTER U WITH CARON
 * 	0075 LATIN SMALL LETTER U
 * 01D5 LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
 * 	0055 LATIN CAPITAL LETTER U
 * 01D6 LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
 * 	0075 LATIN SMALL LETTER U
 * 01D7 LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
 * 	0055 LATIN CAPITAL LETTER U
 * 01D8 LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
 * 	0075 LATIN SMALL LETTER U
 * 01D9 LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
 * 	0055 LATIN CAPITAL LETTER U
 * 01DA LATIN SMALL LETTER U WITH DIAERESIS AND CARON
 * 	0075 LATIN SMALL LETTER U
 * 01DB LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
 * 	0055 LATIN CAPITAL LETTER U
 * 01DC LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
 * 	0075 LATIN SMALL LETTER U
 * 01DE LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
 * 	0041 LATIN CAPITAL LETTER A
 * 01DF LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
 * 	0061 LATIN SMALL LETTER A
 * 01E0 LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
 * 	0041 LATIN CAPITAL LETTER A
 * 01E1 LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
 * 	0061 LATIN SMALL LETTER A
 * 01E2 LATIN CAPITAL LETTER AE WITH MACRON
 * 	0041 LATIN CAPITAL LETTER A
 * 	0045 LATIN CAPITAL LETTER E
 * 01E3 LATIN SMALL LETTER AE WITH MACRON
 * 	0061 LATIN SMALL LETTER A
 * 	0065 LATIN SMALL LETTER E
 * 01E6 LATIN CAPITAL LETTER G WITH CARON
 * 	0047 LATIN CAPITAL LETTER G
 * 01E7 LATIN SMALL LETTER G WITH CARON
 * 	0067 LATIN SMALL LETTER G
 * 01E8 LATIN CAPITAL LETTER K WITH CARON
 * 	004B LATIN CAPITAL LETTER K
 * 01E9 LATIN SMALL LETTER K WITH CARON
 * 	006B LATIN SMALL LETTER K
 * 01EA LATIN CAPITAL LETTER O WITH OGONEK
 * 	004F LATIN CAPITAL LETTER O
 * 01EB LATIN SMALL LETTER O WITH OGONEK
 * 	006F LATIN SMALL LETTER O
 * 01EC LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
 * 	004F LATIN CAPITAL LETTER O
 * 01ED LATIN SMALL LETTER O WITH OGONEK AND MACRON
 * 	006F LATIN SMALL LETTER O
 * 01EE LATIN CAPITAL LETTER EZH WITH CARON
 * 	01B7 LATIN CAPITAL LETTER EZH
 * 01EF LATIN SMALL LETTER EZH WITH CARON
 * 	0292 LATIN SMALL LETTER EZH
 * 01F0 LATIN SMALL LETTER J WITH CARON
 * 	006A LATIN SMALL LETTER J
 * 01F1 LATIN CAPITAL LETTER DZ
 * 	0044 LATIN CAPITAL LETTER D
 * 	005A LATIN CAPITAL LETTER Z
 * 01F2 LATIN CAPITAL LETTER D WITH SMALL LETTER Z
 * 	0044 LATIN CAPITAL LETTER D
 * 	007A LATIN SMALL LETTER Z
 * 01F3 LATIN SMALL LETTER DZ
 * 	0064 LATIN SMALL LETTER D
 * 	007A LATIN SMALL LETTER Z
 * 01F4 LATIN CAPITAL LETTER G WITH ACUTE
 * 	0047 LATIN CAPITAL LETTER G
 * 01F5 LATIN SMALL LETTER G WITH ACUTE
 * 	0067 LATIN SMALL LETTER G
 * 01F8 LATIN CAPITAL LETTER N WITH GRAVE
 * 	004E LATIN CAPITAL LETTER N
 * 01F9 LATIN SMALL LETTER N WITH GRAVE
 * 	006E LATIN SMALL LETTER N
 * 01FA LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
 * 	0041 LATIN CAPITAL LETTER A
 * 01FB LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
 * 	0061 LATIN SMALL LETTER A
 * 01FC LATIN CAPITAL LETTER AE WITH ACUTE
 * 	0041 LATIN CAPITAL LETTER A
 * 	0045 LATIN CAPITAL LETTER E
 * 01FD LATIN SMALL LETTER AE WITH ACUTE
 * 	0061 LATIN SMALL LETTER A
 * 	0065 LATIN SMALL LETTER E
 * 01FE LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 01FF LATIN SMALL LETTER O WITH STROKE AND ACUTE
 * 	006F LATIN SMALL LETTER O
 * 0200 LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
 * 	0041 LATIN CAPITAL LETTER A
 * 0201 LATIN SMALL LETTER A WITH DOUBLE GRAVE
 * 	0061 LATIN SMALL LETTER A
 * 0202 LATIN CAPITAL LETTER A WITH INVERTED BREVE
 * 	0041 LATIN CAPITAL LETTER A
 * 0203 LATIN SMALL LETTER A WITH INVERTED BREVE
 * 	0061 LATIN SMALL LETTER A
 * 0204 LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
 * 	0045 LATIN CAPITAL LETTER E
 * 0205 LATIN SMALL LETTER E WITH DOUBLE GRAVE
 * 	0065 LATIN SMALL LETTER E
 * 0206 LATIN CAPITAL LETTER E WITH INVERTED BREVE
 * 	0045 LATIN CAPITAL LETTER E
 * 0207 LATIN SMALL LETTER E WITH INVERTED BREVE
 * 	0065 LATIN SMALL LETTER E
 * 0208 LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
 * 	0049 LATIN CAPITAL LETTER I
 * 0209 LATIN SMALL LETTER I WITH DOUBLE GRAVE
 * 	0069 LATIN SMALL LETTER I
 * 020A LATIN CAPITAL LETTER I WITH INVERTED BREVE
 * 	0049 LATIN CAPITAL LETTER I
 * 020B LATIN SMALL LETTER I WITH INVERTED BREVE
 * 	0069 LATIN SMALL LETTER I
 * 020C LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
 * 	004F LATIN CAPITAL LETTER O
 * 020D LATIN SMALL LETTER O WITH DOUBLE GRAVE
 * 	006F LATIN SMALL LETTER O
 * 020E LATIN CAPITAL LETTER O WITH INVERTED BREVE
 * 	004F LATIN CAPITAL LETTER O
 * 020F LATIN SMALL LETTER O WITH INVERTED BREVE
 * 	006F LATIN SMALL LETTER O
 * 0210 LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
 * 	0052 LATIN CAPITAL LETTER R
 * 0211 LATIN SMALL LETTER R WITH DOUBLE GRAVE
 * 	0072 LATIN SMALL LETTER R
 * 0212 LATIN CAPITAL LETTER R WITH INVERTED BREVE
 * 	0052 LATIN CAPITAL LETTER R
 * 0213 LATIN SMALL LETTER R WITH INVERTED BREVE
 * 	0072 LATIN SMALL LETTER R
 * 0214 LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
 * 	0055 LATIN CAPITAL LETTER U
 * 0215 LATIN SMALL LETTER U WITH DOUBLE GRAVE
 * 	0075 LATIN SMALL LETTER U
 * 0216 LATIN CAPITAL LETTER U WITH INVERTED BREVE
 * 	0055 LATIN CAPITAL LETTER U
 * 0217 LATIN SMALL LETTER U WITH INVERTED BREVE
 * 	0075 LATIN SMALL LETTER U
 * 0218 LATIN CAPITAL LETTER S WITH COMMA BELOW
 * 	0053 LATIN CAPITAL LETTER S
 * 0219 LATIN SMALL LETTER S WITH COMMA BELOW
 * 	0073 LATIN SMALL LETTER S
 * 021A LATIN CAPITAL LETTER T WITH COMMA BELOW
 * 	0054 LATIN CAPITAL LETTER T
 * 021B LATIN SMALL LETTER T WITH COMMA BELOW
 * 	0074 LATIN SMALL LETTER T
 * 021E LATIN CAPITAL LETTER H WITH CARON
 * 	0048 LATIN CAPITAL LETTER H
 * 021F LATIN SMALL LETTER H WITH CARON
 * 	0068 LATIN SMALL LETTER H
 * 0226 LATIN CAPITAL LETTER A WITH DOT ABOVE
 * 	0041 LATIN CAPITAL LETTER A
 * 0227 LATIN SMALL LETTER A WITH DOT ABOVE
 * 	0061 LATIN SMALL LETTER A
 * 0228 LATIN CAPITAL LETTER E WITH CEDILLA
 * 	0045 LATIN CAPITAL LETTER E
 * 0229 LATIN SMALL LETTER E WITH CEDILLA
 * 	0065 LATIN SMALL LETTER E
 * 022A LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
 * 	004F LATIN CAPITAL LETTER O
 * 022B LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
 * 	006F LATIN SMALL LETTER O
 * 022C LATIN CAPITAL LETTER O WITH TILDE AND MACRON
 * 	004F LATIN CAPITAL LETTER O
 * 022D LATIN SMALL LETTER O WITH TILDE AND MACRON
 * 	006F LATIN SMALL LETTER O
 * 022E LATIN CAPITAL LETTER O WITH DOT ABOVE
 * 	004F LATIN CAPITAL LETTER O
 * 022F LATIN SMALL LETTER O WITH DOT ABOVE
 * 	006F LATIN SMALL LETTER O
 * 0230 LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
 * 	004F LATIN CAPITAL LETTER O
 * 0231 LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
 * 	006F LATIN SMALL LETTER O
 * 0232 LATIN CAPITAL LETTER Y WITH MACRON
 * 	0059 LATIN CAPITAL LETTER Y
 * 0233 LATIN SMALL LETTER Y WITH MACRON
 * 	0079 LATIN SMALL LETTER Y
 * 02B0 MODIFIER LETTER SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 02B1 MODIFIER LETTER SMALL H WITH HOOK
 * 	0266 LATIN SMALL LETTER H WITH HOOK
 * 02B2 MODIFIER LETTER SMALL J
 * 	006A LATIN SMALL LETTER J
 * 02B3 MODIFIER LETTER SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 02B4 MODIFIER LETTER SMALL TURNED R
 * 	0279 LATIN SMALL LETTER TURNED R
 * 02B5 MODIFIER LETTER SMALL TURNED R WITH HOOK
 * 	027B LATIN SMALL LETTER TURNED R WITH HOOK
 * 02B6 MODIFIER LETTER SMALL CAPITAL INVERTED R
 * 	0281 LATIN LETTER SMALL CAPITAL INVERTED R
 * 02B7 MODIFIER LETTER SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 02B8 MODIFIER LETTER SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 02D8 BREVE
 * 	0020 SPACE
 * 02D9 DOT ABOVE
 * 	0020 SPACE
 * 02DA RING ABOVE
 * 	0020 SPACE
 * 02DB OGONEK
 * 	0020 SPACE
 * 02DC SMALL TILDE
 * 	0020 SPACE
 * 02DD DOUBLE ACUTE ACCENT
 * 	0020 SPACE
 * 02E0 MODIFIER LETTER SMALL GAMMA
 * 	0263 LATIN SMALL LETTER GAMMA
 * 02E1 MODIFIER LETTER SMALL L
 * 	006C LATIN SMALL LETTER L
 * 02E2 MODIFIER LETTER SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 02E3 MODIFIER LETTER SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 02E4 MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
 * 	0295 LATIN LETTER PHARYNGEAL VOICED FRICATIVE
 * 0374 GREEK NUMERAL SIGN
 * 	02B9 MODIFIER LETTER PRIME
 * 037A GREEK YPOGEGRAMMENI
 * 	0020 SPACE
 * 037E GREEK QUESTION MARK
 * 	003B SEMICOLON
 * 0384 GREEK TONOS
 * 	0020 SPACE
 * 0385 GREEK DIALYTIKA TONOS
 * 	0020 SPACE
 * 0386 GREEK CAPITAL LETTER ALPHA WITH TONOS
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 0387 GREEK ANO TELEIA
 * 	00B7 MIDDLE DOT
 * 0388 GREEK CAPITAL LETTER EPSILON WITH TONOS
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 0389 GREEK CAPITAL LETTER ETA WITH TONOS
 * 	0397 GREEK CAPITAL LETTER ETA
 * 038A GREEK CAPITAL LETTER IOTA WITH TONOS
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 038C GREEK CAPITAL LETTER OMICRON WITH TONOS
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 038E GREEK CAPITAL LETTER UPSILON WITH TONOS
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 038F GREEK CAPITAL LETTER OMEGA WITH TONOS
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 0390 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
 * 	03B9 GREEK SMALL LETTER IOTA
 * 03AA GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 03AB GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 03AC GREEK SMALL LETTER ALPHA WITH TONOS
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 03AD GREEK SMALL LETTER EPSILON WITH TONOS
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 03AE GREEK SMALL LETTER ETA WITH TONOS
 * 	03B7 GREEK SMALL LETTER ETA
 * 03AF GREEK SMALL LETTER IOTA WITH TONOS
 * 	03B9 GREEK SMALL LETTER IOTA
 * 03B0 GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 03CA GREEK SMALL LETTER IOTA WITH DIALYTIKA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 03CB GREEK SMALL LETTER UPSILON WITH DIALYTIKA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 03CC GREEK SMALL LETTER OMICRON WITH TONOS
 * 	03BF GREEK SMALL LETTER OMICRON
 * 03CD GREEK SMALL LETTER UPSILON WITH TONOS
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 03CE GREEK SMALL LETTER OMEGA WITH TONOS
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 03D0 GREEK BETA SYMBOL
 * 	03B2 GREEK SMALL LETTER BETA
 * 03D1 GREEK THETA SYMBOL
 * 	03B8 GREEK SMALL LETTER THETA
 * 03D2 GREEK UPSILON WITH HOOK SYMBOL
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 03D3 GREEK UPSILON WITH ACUTE AND HOOK SYMBOL
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 03D4 GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 03D5 GREEK PHI SYMBOL
 * 	03C6 GREEK SMALL LETTER PHI
 * 03D6 GREEK PI SYMBOL
 * 	03C0 GREEK SMALL LETTER PI
 * 03F0 GREEK KAPPA SYMBOL
 * 	03BA GREEK SMALL LETTER KAPPA
 * 03F1 GREEK RHO SYMBOL
 * 	03C1 GREEK SMALL LETTER RHO
 * 03F2 GREEK LUNATE SIGMA SYMBOL
 * 	03C2 GREEK SMALL LETTER FINAL SIGMA
 * 03F4 GREEK CAPITAL THETA SYMBOL
 * 	0398 GREEK CAPITAL LETTER THETA
 * 03F5 GREEK LUNATE EPSILON SYMBOL
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 0400 CYRILLIC CAPITAL LETTER IE WITH GRAVE
 * 	0415 CYRILLIC CAPITAL LETTER IE
 * 0401 CYRILLIC CAPITAL LETTER IO
 * 	0415 CYRILLIC CAPITAL LETTER IE
 * 0403 CYRILLIC CAPITAL LETTER GJE
 * 	0413 CYRILLIC CAPITAL LETTER GHE
 * 0407 CYRILLIC CAPITAL LETTER YI
 * 	0406 CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
 * 040C CYRILLIC CAPITAL LETTER KJE
 * 	041A CYRILLIC CAPITAL LETTER KA
 * 040D CYRILLIC CAPITAL LETTER I WITH GRAVE
 * 	0418 CYRILLIC CAPITAL LETTER I
 * 040E CYRILLIC CAPITAL LETTER SHORT U
 * 	0423 CYRILLIC CAPITAL LETTER U
 * 0419 CYRILLIC CAPITAL LETTER SHORT I
 * 	0418 CYRILLIC CAPITAL LETTER I
 * 0439 CYRILLIC SMALL LETTER SHORT I
 * 	0438 CYRILLIC SMALL LETTER I
 * 0450 CYRILLIC SMALL LETTER IE WITH GRAVE
 * 	0435 CYRILLIC SMALL LETTER IE
 * 0451 CYRILLIC SMALL LETTER IO
 * 	0435 CYRILLIC SMALL LETTER IE
 * 0453 CYRILLIC SMALL LETTER GJE
 * 	0433 CYRILLIC SMALL LETTER GHE
 * 0457 CYRILLIC SMALL LETTER YI
 * 	0456 CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
 * 045C CYRILLIC SMALL LETTER KJE
 * 	043A CYRILLIC SMALL LETTER KA
 * 045D CYRILLIC SMALL LETTER I WITH GRAVE
 * 	0438 CYRILLIC SMALL LETTER I
 * 045E CYRILLIC SMALL LETTER SHORT U
 * 	0443 CYRILLIC SMALL LETTER U
 * 0476 CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
 * 	0474 CYRILLIC CAPITAL LETTER IZHITSA
 * 0477 CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
 * 	0475 CYRILLIC SMALL LETTER IZHITSA
 * 04C1 CYRILLIC CAPITAL LETTER ZHE WITH BREVE
 * 	0416 CYRILLIC CAPITAL LETTER ZHE
 * 04C2 CYRILLIC SMALL LETTER ZHE WITH BREVE
 * 	0436 CYRILLIC SMALL LETTER ZHE
 * 04D0 CYRILLIC CAPITAL LETTER A WITH BREVE
 * 	0410 CYRILLIC CAPITAL LETTER A
 * 04D1 CYRILLIC SMALL LETTER A WITH BREVE
 * 	0430 CYRILLIC SMALL LETTER A
 * 04D2 CYRILLIC CAPITAL LETTER A WITH DIAERESIS
 * 	0410 CYRILLIC CAPITAL LETTER A
 * 04D3 CYRILLIC SMALL LETTER A WITH DIAERESIS
 * 	0430 CYRILLIC SMALL LETTER A
 * 04D6 CYRILLIC CAPITAL LETTER IE WITH BREVE
 * 	0415 CYRILLIC CAPITAL LETTER IE
 * 04D7 CYRILLIC SMALL LETTER IE WITH BREVE
 * 	0435 CYRILLIC SMALL LETTER IE
 * 04DA CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
 * 	04D8 CYRILLIC CAPITAL LETTER SCHWA
 * 04DB CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
 * 	04D9 CYRILLIC SMALL LETTER SCHWA
 * 04DC CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
 * 	0416 CYRILLIC CAPITAL LETTER ZHE
 * 04DD CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
 * 	0436 CYRILLIC SMALL LETTER ZHE
 * 04DE CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
 * 	0417 CYRILLIC CAPITAL LETTER ZE
 * 04DF CYRILLIC SMALL LETTER ZE WITH DIAERESIS
 * 	0437 CYRILLIC SMALL LETTER ZE
 * 04E2 CYRILLIC CAPITAL LETTER I WITH MACRON
 * 	0418 CYRILLIC CAPITAL LETTER I
 * 04E3 CYRILLIC SMALL LETTER I WITH MACRON
 * 	0438 CYRILLIC SMALL LETTER I
 * 04E4 CYRILLIC CAPITAL LETTER I WITH DIAERESIS
 * 	0418 CYRILLIC CAPITAL LETTER I
 * 04E5 CYRILLIC SMALL LETTER I WITH DIAERESIS
 * 	0438 CYRILLIC SMALL LETTER I
 * 04E6 CYRILLIC CAPITAL LETTER O WITH DIAERESIS
 * 	041E CYRILLIC CAPITAL LETTER O
 * 04E7 CYRILLIC SMALL LETTER O WITH DIAERESIS
 * 	043E CYRILLIC SMALL LETTER O
 * 04EA CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
 * 	04E8 CYRILLIC CAPITAL LETTER BARRED O
 * 04EB CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
 * 	04E9 CYRILLIC SMALL LETTER BARRED O
 * 04EC CYRILLIC CAPITAL LETTER E WITH DIAERESIS
 * 	042D CYRILLIC CAPITAL LETTER E
 * 04ED CYRILLIC SMALL LETTER E WITH DIAERESIS
 * 	044D CYRILLIC SMALL LETTER E
 * 04EE CYRILLIC CAPITAL LETTER U WITH MACRON
 * 	0423 CYRILLIC CAPITAL LETTER U
 * 04EF CYRILLIC SMALL LETTER U WITH MACRON
 * 	0443 CYRILLIC SMALL LETTER U
 * 04F0 CYRILLIC CAPITAL LETTER U WITH DIAERESIS
 * 	0423 CYRILLIC CAPITAL LETTER U
 * 04F1 CYRILLIC SMALL LETTER U WITH DIAERESIS
 * 	0443 CYRILLIC SMALL LETTER U
 * 04F2 CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
 * 	0423 CYRILLIC CAPITAL LETTER U
 * 04F3 CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
 * 	0443 CYRILLIC SMALL LETTER U
 * 04F4 CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
 * 	0427 CYRILLIC CAPITAL LETTER CHE
 * 04F5 CYRILLIC SMALL LETTER CHE WITH DIAERESIS
 * 	0447 CYRILLIC SMALL LETTER CHE
 * 04F8 CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
 * 	042B CYRILLIC CAPITAL LETTER YERU
 * 04F9 CYRILLIC SMALL LETTER YERU WITH DIAERESIS
 * 	044B CYRILLIC SMALL LETTER YERU
 * 0587 ARMENIAN SMALL LIGATURE ECH YIWN
 * 	0565 ARMENIAN SMALL LETTER ECH
 * 	0582 ARMENIAN SMALL LETTER YIWN
 * 0622 ARABIC LETTER ALEF WITH MADDA ABOVE
 * 	0627 ARABIC LETTER ALEF
 * 0623 ARABIC LETTER ALEF WITH HAMZA ABOVE
 * 	0627 ARABIC LETTER ALEF
 * 0624 ARABIC LETTER WAW WITH HAMZA ABOVE
 * 	0648 ARABIC LETTER WAW
 * 0625 ARABIC LETTER ALEF WITH HAMZA BELOW
 * 	0627 ARABIC LETTER ALEF
 * 0626 ARABIC LETTER YEH WITH HAMZA ABOVE
 * 	064A ARABIC LETTER YEH
 * 0675 ARABIC LETTER HIGH HAMZA ALEF
 * 	0627 ARABIC LETTER ALEF
 * 	0674 ARABIC LETTER HIGH HAMZA
 * 0676 ARABIC LETTER HIGH HAMZA WAW
 * 	0648 ARABIC LETTER WAW
 * 	0674 ARABIC LETTER HIGH HAMZA
 * 0677 ARABIC LETTER U WITH HAMZA ABOVE
 * 	06C7 ARABIC LETTER U
 * 	0674 ARABIC LETTER HIGH HAMZA
 * 0678 ARABIC LETTER HIGH HAMZA YEH
 * 	064A ARABIC LETTER YEH
 * 	0674 ARABIC LETTER HIGH HAMZA
 * 06C0 ARABIC LETTER HEH WITH YEH ABOVE
 * 	06D5 ARABIC LETTER AE
 * 06C2 ARABIC LETTER HEH GOAL WITH HAMZA ABOVE
 * 	06C1 ARABIC LETTER HEH GOAL
 * 06D3 ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
 * 	06D2 ARABIC LETTER YEH BARREE
 * 0929 DEVANAGARI LETTER NNNA
 * 	0928 DEVANAGARI LETTER NA
 * 0931 DEVANAGARI LETTER RRA
 * 	0930 DEVANAGARI LETTER RA
 * 0934 DEVANAGARI LETTER LLLA
 * 	0933 DEVANAGARI LETTER LLA
 * 0958 DEVANAGARI LETTER QA
 * 	0915 DEVANAGARI LETTER KA
 * 0959 DEVANAGARI LETTER KHHA
 * 	0916 DEVANAGARI LETTER KHA
 * 095A DEVANAGARI LETTER GHHA
 * 	0917 DEVANAGARI LETTER GA
 * 095B DEVANAGARI LETTER ZA
 * 	091C DEVANAGARI LETTER JA
 * 095C DEVANAGARI LETTER DDDHA
 * 	0921 DEVANAGARI LETTER DDA
 * 095D DEVANAGARI LETTER RHA
 * 	0922 DEVANAGARI LETTER DDHA
 * 095E DEVANAGARI LETTER FA
 * 	092B DEVANAGARI LETTER PHA
 * 095F DEVANAGARI LETTER YYA
 * 	092F DEVANAGARI LETTER YA
 * 09DC BENGALI LETTER RRA
 * 	09A1 BENGALI LETTER DDA
 * 09DD BENGALI LETTER RHA
 * 	09A2 BENGALI LETTER DDHA
 * 09DF BENGALI LETTER YYA
 * 	09AF BENGALI LETTER YA
 * 0A33 GURMUKHI LETTER LLA
 * 	0A32 GURMUKHI LETTER LA
 * 0A36 GURMUKHI LETTER SHA
 * 	0A38 GURMUKHI LETTER SA
 * 0A59 GURMUKHI LETTER KHHA
 * 	0A16 GURMUKHI LETTER KHA
 * 0A5A GURMUKHI LETTER GHHA
 * 	0A17 GURMUKHI LETTER GA
 * 0A5B GURMUKHI LETTER ZA
 * 	0A1C GURMUKHI LETTER JA
 * 0A5E GURMUKHI LETTER FA
 * 	0A2B GURMUKHI LETTER PHA
 * 0B5C ORIYA LETTER RRA
 * 	0B21 ORIYA LETTER DDA
 * 0B5D ORIYA LETTER RHA
 * 	0B22 ORIYA LETTER DDHA
 * 0B94 TAMIL LETTER AU
 * 	0B92 TAMIL LETTER O
 * 0E33 THAI CHARACTER SARA AM
 * 	0E32 THAI CHARACTER SARA AA
 * 0EB3 LAO VOWEL SIGN AM
 * 	0EB2 LAO VOWEL SIGN AA
 * 0EDC LAO HO NO
 * 	0EAB LAO LETTER HO SUNG
 * 	0E99 LAO LETTER NO
 * 0EDD LAO HO MO
 * 	0EAB LAO LETTER HO SUNG
 * 	0EA1 LAO LETTER MO
 * 0F0C TIBETAN MARK DELIMITER TSHEG BSTAR
 * 	0F0B TIBETAN MARK INTERSYLLABIC TSHEG
 * 0F43 TIBETAN LETTER GHA
 * 	0F42 TIBETAN LETTER GA
 * 0F4D TIBETAN LETTER DDHA
 * 	0F4C TIBETAN LETTER DDA
 * 0F52 TIBETAN LETTER DHA
 * 	0F51 TIBETAN LETTER DA
 * 0F57 TIBETAN LETTER BHA
 * 	0F56 TIBETAN LETTER BA
 * 0F5C TIBETAN LETTER DZHA
 * 	0F5B TIBETAN LETTER DZA
 * 0F69 TIBETAN LETTER KSSA
 * 	0F40 TIBETAN LETTER KA
 * 1026 MYANMAR LETTER UU
 * 	1025 MYANMAR LETTER U
 * 1D15E MUSICAL SYMBOL HALF NOTE
 * 	1D157 MUSICAL SYMBOL VOID NOTEHEAD
 * 1D15F MUSICAL SYMBOL QUARTER NOTE
 * 	1D158 MUSICAL SYMBOL NOTEHEAD BLACK
 * 1D160 MUSICAL SYMBOL EIGHTH NOTE
 * 	1D158 MUSICAL SYMBOL NOTEHEAD BLACK
 * 1D161 MUSICAL SYMBOL SIXTEENTH NOTE
 * 	1D158 MUSICAL SYMBOL NOTEHEAD BLACK
 * 1D162 MUSICAL SYMBOL THIRTY-SECOND NOTE
 * 	1D158 MUSICAL SYMBOL NOTEHEAD BLACK
 * 1D163 MUSICAL SYMBOL SIXTY-FOURTH NOTE
 * 	1D158 MUSICAL SYMBOL NOTEHEAD BLACK
 * 1D164 MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE
 * 	1D158 MUSICAL SYMBOL NOTEHEAD BLACK
 * 1D1BB MUSICAL SYMBOL MINIMA
 * 	1D1B9 MUSICAL SYMBOL SEMIBREVIS WHITE
 * 1D1BC MUSICAL SYMBOL MINIMA BLACK
 * 	1D1BA MUSICAL SYMBOL SEMIBREVIS BLACK
 * 1D1BD MUSICAL SYMBOL SEMIMINIMA WHITE
 * 	1D1B9 MUSICAL SYMBOL SEMIBREVIS WHITE
 * 1D1BE MUSICAL SYMBOL SEMIMINIMA BLACK
 * 	1D1BA MUSICAL SYMBOL SEMIBREVIS BLACK
 * 1D1BF MUSICAL SYMBOL FUSA WHITE
 * 	1D1B9 MUSICAL SYMBOL SEMIBREVIS WHITE
 * 1D1C0 MUSICAL SYMBOL FUSA BLACK
 * 	1D1BA MUSICAL SYMBOL SEMIBREVIS BLACK
 * 1D400 MATHEMATICAL BOLD CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D401 MATHEMATICAL BOLD CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D402 MATHEMATICAL BOLD CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 1D403 MATHEMATICAL BOLD CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D404 MATHEMATICAL BOLD CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D405 MATHEMATICAL BOLD CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 1D406 MATHEMATICAL BOLD CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D407 MATHEMATICAL BOLD CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 1D408 MATHEMATICAL BOLD CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 1D409 MATHEMATICAL BOLD CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D40A MATHEMATICAL BOLD CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D40B MATHEMATICAL BOLD CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D40C MATHEMATICAL BOLD CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D40D MATHEMATICAL BOLD CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D40E MATHEMATICAL BOLD CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D40F MATHEMATICAL BOLD CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D410 MATHEMATICAL BOLD CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 1D411 MATHEMATICAL BOLD CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 1D412 MATHEMATICAL BOLD CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D413 MATHEMATICAL BOLD CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D414 MATHEMATICAL BOLD CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D415 MATHEMATICAL BOLD CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D416 MATHEMATICAL BOLD CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D417 MATHEMATICAL BOLD CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D418 MATHEMATICAL BOLD CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D419 MATHEMATICAL BOLD CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 1D41A MATHEMATICAL BOLD SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D41B MATHEMATICAL BOLD SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D41C MATHEMATICAL BOLD SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D41D MATHEMATICAL BOLD SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D41E MATHEMATICAL BOLD SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D41F MATHEMATICAL BOLD SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D420 MATHEMATICAL BOLD SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D421 MATHEMATICAL BOLD SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 1D422 MATHEMATICAL BOLD SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D423 MATHEMATICAL BOLD SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D424 MATHEMATICAL BOLD SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D425 MATHEMATICAL BOLD SMALL L
 * 	006C LATIN SMALL LETTER L
 * 1D426 MATHEMATICAL BOLD SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D427 MATHEMATICAL BOLD SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D428 MATHEMATICAL BOLD SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D429 MATHEMATICAL BOLD SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D42A MATHEMATICAL BOLD SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D42B MATHEMATICAL BOLD SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D42C MATHEMATICAL BOLD SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D42D MATHEMATICAL BOLD SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D42E MATHEMATICAL BOLD SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D42F MATHEMATICAL BOLD SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D430 MATHEMATICAL BOLD SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D431 MATHEMATICAL BOLD SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D432 MATHEMATICAL BOLD SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D433 MATHEMATICAL BOLD SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D434 MATHEMATICAL ITALIC CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D435 MATHEMATICAL ITALIC CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D436 MATHEMATICAL ITALIC CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 1D437 MATHEMATICAL ITALIC CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D438 MATHEMATICAL ITALIC CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D439 MATHEMATICAL ITALIC CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 1D43A MATHEMATICAL ITALIC CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D43B MATHEMATICAL ITALIC CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 1D43C MATHEMATICAL ITALIC CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 1D43D MATHEMATICAL ITALIC CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D43E MATHEMATICAL ITALIC CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D43F MATHEMATICAL ITALIC CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D440 MATHEMATICAL ITALIC CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D441 MATHEMATICAL ITALIC CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D442 MATHEMATICAL ITALIC CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D443 MATHEMATICAL ITALIC CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D444 MATHEMATICAL ITALIC CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 1D445 MATHEMATICAL ITALIC CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 1D446 MATHEMATICAL ITALIC CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D447 MATHEMATICAL ITALIC CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D448 MATHEMATICAL ITALIC CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D449 MATHEMATICAL ITALIC CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D44A MATHEMATICAL ITALIC CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D44B MATHEMATICAL ITALIC CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D44C MATHEMATICAL ITALIC CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D44D MATHEMATICAL ITALIC CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 1D44E MATHEMATICAL ITALIC SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D44F MATHEMATICAL ITALIC SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D450 MATHEMATICAL ITALIC SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D451 MATHEMATICAL ITALIC SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D452 MATHEMATICAL ITALIC SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D453 MATHEMATICAL ITALIC SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D454 MATHEMATICAL ITALIC SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D456 MATHEMATICAL ITALIC SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D457 MATHEMATICAL ITALIC SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D458 MATHEMATICAL ITALIC SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D459 MATHEMATICAL ITALIC SMALL L
 * 	006C LATIN SMALL LETTER L
 * 1D45A MATHEMATICAL ITALIC SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D45B MATHEMATICAL ITALIC SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D45C MATHEMATICAL ITALIC SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D45D MATHEMATICAL ITALIC SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D45E MATHEMATICAL ITALIC SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D45F MATHEMATICAL ITALIC SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D460 MATHEMATICAL ITALIC SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D461 MATHEMATICAL ITALIC SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D462 MATHEMATICAL ITALIC SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D463 MATHEMATICAL ITALIC SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D464 MATHEMATICAL ITALIC SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D465 MATHEMATICAL ITALIC SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D466 MATHEMATICAL ITALIC SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D467 MATHEMATICAL ITALIC SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D468 MATHEMATICAL BOLD ITALIC CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D469 MATHEMATICAL BOLD ITALIC CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D46A MATHEMATICAL BOLD ITALIC CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 1D46B MATHEMATICAL BOLD ITALIC CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D46C MATHEMATICAL BOLD ITALIC CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D46D MATHEMATICAL BOLD ITALIC CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 1D46E MATHEMATICAL BOLD ITALIC CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D46F MATHEMATICAL BOLD ITALIC CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 1D470 MATHEMATICAL BOLD ITALIC CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 1D471 MATHEMATICAL BOLD ITALIC CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D472 MATHEMATICAL BOLD ITALIC CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D473 MATHEMATICAL BOLD ITALIC CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D474 MATHEMATICAL BOLD ITALIC CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D475 MATHEMATICAL BOLD ITALIC CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D476 MATHEMATICAL BOLD ITALIC CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D477 MATHEMATICAL BOLD ITALIC CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D478 MATHEMATICAL BOLD ITALIC CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 1D479 MATHEMATICAL BOLD ITALIC CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 1D47A MATHEMATICAL BOLD ITALIC CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D47B MATHEMATICAL BOLD ITALIC CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D47C MATHEMATICAL BOLD ITALIC CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D47D MATHEMATICAL BOLD ITALIC CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D47E MATHEMATICAL BOLD ITALIC CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D47F MATHEMATICAL BOLD ITALIC CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D480 MATHEMATICAL BOLD ITALIC CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D481 MATHEMATICAL BOLD ITALIC CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 1D482 MATHEMATICAL BOLD ITALIC SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D483 MATHEMATICAL BOLD ITALIC SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D484 MATHEMATICAL BOLD ITALIC SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D485 MATHEMATICAL BOLD ITALIC SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D486 MATHEMATICAL BOLD ITALIC SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D487 MATHEMATICAL BOLD ITALIC SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D488 MATHEMATICAL BOLD ITALIC SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D489 MATHEMATICAL BOLD ITALIC SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 1D48A MATHEMATICAL BOLD ITALIC SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D48B MATHEMATICAL BOLD ITALIC SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D48C MATHEMATICAL BOLD ITALIC SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D48D MATHEMATICAL BOLD ITALIC SMALL L
 * 	006C LATIN SMALL LETTER L
 * 1D48E MATHEMATICAL BOLD ITALIC SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D48F MATHEMATICAL BOLD ITALIC SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D490 MATHEMATICAL BOLD ITALIC SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D491 MATHEMATICAL BOLD ITALIC SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D492 MATHEMATICAL BOLD ITALIC SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D493 MATHEMATICAL BOLD ITALIC SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D494 MATHEMATICAL BOLD ITALIC SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D495 MATHEMATICAL BOLD ITALIC SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D496 MATHEMATICAL BOLD ITALIC SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D497 MATHEMATICAL BOLD ITALIC SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D498 MATHEMATICAL BOLD ITALIC SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D499 MATHEMATICAL BOLD ITALIC SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D49A MATHEMATICAL BOLD ITALIC SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D49B MATHEMATICAL BOLD ITALIC SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D49C MATHEMATICAL SCRIPT CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D49E MATHEMATICAL SCRIPT CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 1D49F MATHEMATICAL SCRIPT CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D4A2 MATHEMATICAL SCRIPT CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D4A5 MATHEMATICAL SCRIPT CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D4A6 MATHEMATICAL SCRIPT CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D4A9 MATHEMATICAL SCRIPT CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D4AA MATHEMATICAL SCRIPT CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D4AB MATHEMATICAL SCRIPT CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D4AC MATHEMATICAL SCRIPT CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 1D4AE MATHEMATICAL SCRIPT CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D4AF MATHEMATICAL SCRIPT CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D4B0 MATHEMATICAL SCRIPT CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D4B1 MATHEMATICAL SCRIPT CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D4B2 MATHEMATICAL SCRIPT CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D4B3 MATHEMATICAL SCRIPT CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D4B4 MATHEMATICAL SCRIPT CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D4B5 MATHEMATICAL SCRIPT CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 1D4B6 MATHEMATICAL SCRIPT SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D4B7 MATHEMATICAL SCRIPT SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D4B8 MATHEMATICAL SCRIPT SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D4B9 MATHEMATICAL SCRIPT SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D4BB MATHEMATICAL SCRIPT SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D4BD MATHEMATICAL SCRIPT SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 1D4BE MATHEMATICAL SCRIPT SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D4BF MATHEMATICAL SCRIPT SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D4C0 MATHEMATICAL SCRIPT SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D4C2 MATHEMATICAL SCRIPT SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D4C3 MATHEMATICAL SCRIPT SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D4C5 MATHEMATICAL SCRIPT SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D4C6 MATHEMATICAL SCRIPT SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D4C7 MATHEMATICAL SCRIPT SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D4C8 MATHEMATICAL SCRIPT SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D4C9 MATHEMATICAL SCRIPT SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D4CA MATHEMATICAL SCRIPT SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D4CB MATHEMATICAL SCRIPT SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D4CC MATHEMATICAL SCRIPT SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D4CD MATHEMATICAL SCRIPT SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D4CE MATHEMATICAL SCRIPT SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D4CF MATHEMATICAL SCRIPT SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D4D0 MATHEMATICAL BOLD SCRIPT CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D4D1 MATHEMATICAL BOLD SCRIPT CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D4D2 MATHEMATICAL BOLD SCRIPT CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 1D4D3 MATHEMATICAL BOLD SCRIPT CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D4D4 MATHEMATICAL BOLD SCRIPT CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D4D5 MATHEMATICAL BOLD SCRIPT CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 1D4D6 MATHEMATICAL BOLD SCRIPT CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D4D7 MATHEMATICAL BOLD SCRIPT CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 1D4D8 MATHEMATICAL BOLD SCRIPT CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 1D4D9 MATHEMATICAL BOLD SCRIPT CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D4DA MATHEMATICAL BOLD SCRIPT CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D4DB MATHEMATICAL BOLD SCRIPT CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D4DC MATHEMATICAL BOLD SCRIPT CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D4DD MATHEMATICAL BOLD SCRIPT CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D4DE MATHEMATICAL BOLD SCRIPT CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D4DF MATHEMATICAL BOLD SCRIPT CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D4E0 MATHEMATICAL BOLD SCRIPT CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 1D4E1 MATHEMATICAL BOLD SCRIPT CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 1D4E2 MATHEMATICAL BOLD SCRIPT CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D4E3 MATHEMATICAL BOLD SCRIPT CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D4E4 MATHEMATICAL BOLD SCRIPT CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D4E5 MATHEMATICAL BOLD SCRIPT CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D4E6 MATHEMATICAL BOLD SCRIPT CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D4E7 MATHEMATICAL BOLD SCRIPT CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D4E8 MATHEMATICAL BOLD SCRIPT CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D4E9 MATHEMATICAL BOLD SCRIPT CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 1D4EA MATHEMATICAL BOLD SCRIPT SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D4EB MATHEMATICAL BOLD SCRIPT SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D4EC MATHEMATICAL BOLD SCRIPT SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D4ED MATHEMATICAL BOLD SCRIPT SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D4EE MATHEMATICAL BOLD SCRIPT SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D4EF MATHEMATICAL BOLD SCRIPT SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D4F0 MATHEMATICAL BOLD SCRIPT SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D4F1 MATHEMATICAL BOLD SCRIPT SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 1D4F2 MATHEMATICAL BOLD SCRIPT SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D4F3 MATHEMATICAL BOLD SCRIPT SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D4F4 MATHEMATICAL BOLD SCRIPT SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D4F5 MATHEMATICAL BOLD SCRIPT SMALL L
 * 	006C LATIN SMALL LETTER L
 * 1D4F6 MATHEMATICAL BOLD SCRIPT SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D4F7 MATHEMATICAL BOLD SCRIPT SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D4F8 MATHEMATICAL BOLD SCRIPT SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D4F9 MATHEMATICAL BOLD SCRIPT SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D4FA MATHEMATICAL BOLD SCRIPT SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D4FB MATHEMATICAL BOLD SCRIPT SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D4FC MATHEMATICAL BOLD SCRIPT SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D4FD MATHEMATICAL BOLD SCRIPT SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D4FE MATHEMATICAL BOLD SCRIPT SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D4FF MATHEMATICAL BOLD SCRIPT SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D500 MATHEMATICAL BOLD SCRIPT SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D501 MATHEMATICAL BOLD SCRIPT SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D502 MATHEMATICAL BOLD SCRIPT SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D503 MATHEMATICAL BOLD SCRIPT SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D504 MATHEMATICAL FRAKTUR CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D505 MATHEMATICAL FRAKTUR CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D507 MATHEMATICAL FRAKTUR CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D508 MATHEMATICAL FRAKTUR CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D509 MATHEMATICAL FRAKTUR CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 1D50A MATHEMATICAL FRAKTUR CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D50D MATHEMATICAL FRAKTUR CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D50E MATHEMATICAL FRAKTUR CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D50F MATHEMATICAL FRAKTUR CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D510 MATHEMATICAL FRAKTUR CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D511 MATHEMATICAL FRAKTUR CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D512 MATHEMATICAL FRAKTUR CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D513 MATHEMATICAL FRAKTUR CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D514 MATHEMATICAL FRAKTUR CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 1D516 MATHEMATICAL FRAKTUR CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D517 MATHEMATICAL FRAKTUR CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D518 MATHEMATICAL FRAKTUR CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D519 MATHEMATICAL FRAKTUR CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D51A MATHEMATICAL FRAKTUR CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D51B MATHEMATICAL FRAKTUR CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D51C MATHEMATICAL FRAKTUR CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D51E MATHEMATICAL FRAKTUR SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D51F MATHEMATICAL FRAKTUR SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D520 MATHEMATICAL FRAKTUR SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D521 MATHEMATICAL FRAKTUR SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D522 MATHEMATICAL FRAKTUR SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D523 MATHEMATICAL FRAKTUR SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D524 MATHEMATICAL FRAKTUR SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D525 MATHEMATICAL FRAKTUR SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 1D526 MATHEMATICAL FRAKTUR SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D527 MATHEMATICAL FRAKTUR SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D528 MATHEMATICAL FRAKTUR SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D529 MATHEMATICAL FRAKTUR SMALL L
 * 	006C LATIN SMALL LETTER L
 * 1D52A MATHEMATICAL FRAKTUR SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D52B MATHEMATICAL FRAKTUR SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D52C MATHEMATICAL FRAKTUR SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D52D MATHEMATICAL FRAKTUR SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D52E MATHEMATICAL FRAKTUR SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D52F MATHEMATICAL FRAKTUR SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D530 MATHEMATICAL FRAKTUR SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D531 MATHEMATICAL FRAKTUR SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D532 MATHEMATICAL FRAKTUR SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D533 MATHEMATICAL FRAKTUR SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D534 MATHEMATICAL FRAKTUR SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D535 MATHEMATICAL FRAKTUR SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D536 MATHEMATICAL FRAKTUR SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D537 MATHEMATICAL FRAKTUR SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D538 MATHEMATICAL DOUBLE-STRUCK CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D539 MATHEMATICAL DOUBLE-STRUCK CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D53B MATHEMATICAL DOUBLE-STRUCK CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D53C MATHEMATICAL DOUBLE-STRUCK CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D53D MATHEMATICAL DOUBLE-STRUCK CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 1D53E MATHEMATICAL DOUBLE-STRUCK CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D540 MATHEMATICAL DOUBLE-STRUCK CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 1D541 MATHEMATICAL DOUBLE-STRUCK CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D542 MATHEMATICAL DOUBLE-STRUCK CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D543 MATHEMATICAL DOUBLE-STRUCK CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D544 MATHEMATICAL DOUBLE-STRUCK CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D546 MATHEMATICAL DOUBLE-STRUCK CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D54A MATHEMATICAL DOUBLE-STRUCK CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D54B MATHEMATICAL DOUBLE-STRUCK CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D54C MATHEMATICAL DOUBLE-STRUCK CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D54D MATHEMATICAL DOUBLE-STRUCK CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D54E MATHEMATICAL DOUBLE-STRUCK CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D54F MATHEMATICAL DOUBLE-STRUCK CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D550 MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D552 MATHEMATICAL DOUBLE-STRUCK SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D553 MATHEMATICAL DOUBLE-STRUCK SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D554 MATHEMATICAL DOUBLE-STRUCK SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D555 MATHEMATICAL DOUBLE-STRUCK SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D556 MATHEMATICAL DOUBLE-STRUCK SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D557 MATHEMATICAL DOUBLE-STRUCK SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D558 MATHEMATICAL DOUBLE-STRUCK SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D559 MATHEMATICAL DOUBLE-STRUCK SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 1D55A MATHEMATICAL DOUBLE-STRUCK SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D55B MATHEMATICAL DOUBLE-STRUCK SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D55C MATHEMATICAL DOUBLE-STRUCK SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D55D MATHEMATICAL DOUBLE-STRUCK SMALL L
 * 	006C LATIN SMALL LETTER L
 * 1D55E MATHEMATICAL DOUBLE-STRUCK SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D55F MATHEMATICAL DOUBLE-STRUCK SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D560 MATHEMATICAL DOUBLE-STRUCK SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D561 MATHEMATICAL DOUBLE-STRUCK SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D562 MATHEMATICAL DOUBLE-STRUCK SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D563 MATHEMATICAL DOUBLE-STRUCK SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D564 MATHEMATICAL DOUBLE-STRUCK SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D565 MATHEMATICAL DOUBLE-STRUCK SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D566 MATHEMATICAL DOUBLE-STRUCK SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D567 MATHEMATICAL DOUBLE-STRUCK SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D568 MATHEMATICAL DOUBLE-STRUCK SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D569 MATHEMATICAL DOUBLE-STRUCK SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D56A MATHEMATICAL DOUBLE-STRUCK SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D56B MATHEMATICAL DOUBLE-STRUCK SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D56C MATHEMATICAL BOLD FRAKTUR CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D56D MATHEMATICAL BOLD FRAKTUR CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D56E MATHEMATICAL BOLD FRAKTUR CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 1D56F MATHEMATICAL BOLD FRAKTUR CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D570 MATHEMATICAL BOLD FRAKTUR CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D571 MATHEMATICAL BOLD FRAKTUR CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 1D572 MATHEMATICAL BOLD FRAKTUR CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D573 MATHEMATICAL BOLD FRAKTUR CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 1D574 MATHEMATICAL BOLD FRAKTUR CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 1D575 MATHEMATICAL BOLD FRAKTUR CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D576 MATHEMATICAL BOLD FRAKTUR CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D577 MATHEMATICAL BOLD FRAKTUR CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D578 MATHEMATICAL BOLD FRAKTUR CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D579 MATHEMATICAL BOLD FRAKTUR CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D57A MATHEMATICAL BOLD FRAKTUR CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D57B MATHEMATICAL BOLD FRAKTUR CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D57C MATHEMATICAL BOLD FRAKTUR CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 1D57D MATHEMATICAL BOLD FRAKTUR CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 1D57E MATHEMATICAL BOLD FRAKTUR CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D57F MATHEMATICAL BOLD FRAKTUR CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D580 MATHEMATICAL BOLD FRAKTUR CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D581 MATHEMATICAL BOLD FRAKTUR CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D582 MATHEMATICAL BOLD FRAKTUR CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D583 MATHEMATICAL BOLD FRAKTUR CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D584 MATHEMATICAL BOLD FRAKTUR CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D585 MATHEMATICAL BOLD FRAKTUR CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 1D586 MATHEMATICAL BOLD FRAKTUR SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D587 MATHEMATICAL BOLD FRAKTUR SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D588 MATHEMATICAL BOLD FRAKTUR SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D589 MATHEMATICAL BOLD FRAKTUR SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D58A MATHEMATICAL BOLD FRAKTUR SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D58B MATHEMATICAL BOLD FRAKTUR SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D58C MATHEMATICAL BOLD FRAKTUR SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D58D MATHEMATICAL BOLD FRAKTUR SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 1D58E MATHEMATICAL BOLD FRAKTUR SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D58F MATHEMATICAL BOLD FRAKTUR SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D590 MATHEMATICAL BOLD FRAKTUR SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D591 MATHEMATICAL BOLD FRAKTUR SMALL L
 * 	006C LATIN SMALL LETTER L
 * 1D592 MATHEMATICAL BOLD FRAKTUR SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D593 MATHEMATICAL BOLD FRAKTUR SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D594 MATHEMATICAL BOLD FRAKTUR SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D595 MATHEMATICAL BOLD FRAKTUR SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D596 MATHEMATICAL BOLD FRAKTUR SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D597 MATHEMATICAL BOLD FRAKTUR SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D598 MATHEMATICAL BOLD FRAKTUR SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D599 MATHEMATICAL BOLD FRAKTUR SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D59A MATHEMATICAL BOLD FRAKTUR SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D59B MATHEMATICAL BOLD FRAKTUR SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D59C MATHEMATICAL BOLD FRAKTUR SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D59D MATHEMATICAL BOLD FRAKTUR SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D59E MATHEMATICAL BOLD FRAKTUR SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D59F MATHEMATICAL BOLD FRAKTUR SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D5A0 MATHEMATICAL SANS-SERIF CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D5A1 MATHEMATICAL SANS-SERIF CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D5A2 MATHEMATICAL SANS-SERIF CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 1D5A3 MATHEMATICAL SANS-SERIF CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D5A4 MATHEMATICAL SANS-SERIF CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D5A5 MATHEMATICAL SANS-SERIF CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 1D5A6 MATHEMATICAL SANS-SERIF CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D5A7 MATHEMATICAL SANS-SERIF CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 1D5A8 MATHEMATICAL SANS-SERIF CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 1D5A9 MATHEMATICAL SANS-SERIF CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D5AA MATHEMATICAL SANS-SERIF CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D5AB MATHEMATICAL SANS-SERIF CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D5AC MATHEMATICAL SANS-SERIF CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D5AD MATHEMATICAL SANS-SERIF CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D5AE MATHEMATICAL SANS-SERIF CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D5AF MATHEMATICAL SANS-SERIF CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D5B0 MATHEMATICAL SANS-SERIF CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 1D5B1 MATHEMATICAL SANS-SERIF CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 1D5B2 MATHEMATICAL SANS-SERIF CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D5B3 MATHEMATICAL SANS-SERIF CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D5B4 MATHEMATICAL SANS-SERIF CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D5B5 MATHEMATICAL SANS-SERIF CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D5B6 MATHEMATICAL SANS-SERIF CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D5B7 MATHEMATICAL SANS-SERIF CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D5B8 MATHEMATICAL SANS-SERIF CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D5B9 MATHEMATICAL SANS-SERIF CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 1D5BA MATHEMATICAL SANS-SERIF SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D5BB MATHEMATICAL SANS-SERIF SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D5BC MATHEMATICAL SANS-SERIF SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D5BD MATHEMATICAL SANS-SERIF SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D5BE MATHEMATICAL SANS-SERIF SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D5BF MATHEMATICAL SANS-SERIF SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D5C0 MATHEMATICAL SANS-SERIF SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D5C1 MATHEMATICAL SANS-SERIF SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 1D5C2 MATHEMATICAL SANS-SERIF SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D5C3 MATHEMATICAL SANS-SERIF SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D5C4 MATHEMATICAL SANS-SERIF SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D5C5 MATHEMATICAL SANS-SERIF SMALL L
 * 	006C LATIN SMALL LETTER L
 * 1D5C6 MATHEMATICAL SANS-SERIF SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D5C7 MATHEMATICAL SANS-SERIF SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D5C8 MATHEMATICAL SANS-SERIF SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D5C9 MATHEMATICAL SANS-SERIF SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D5CA MATHEMATICAL SANS-SERIF SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D5CB MATHEMATICAL SANS-SERIF SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D5CC MATHEMATICAL SANS-SERIF SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D5CD MATHEMATICAL SANS-SERIF SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D5CE MATHEMATICAL SANS-SERIF SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D5CF MATHEMATICAL SANS-SERIF SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D5D0 MATHEMATICAL SANS-SERIF SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D5D1 MATHEMATICAL SANS-SERIF SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D5D2 MATHEMATICAL SANS-SERIF SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D5D3 MATHEMATICAL SANS-SERIF SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D5D4 MATHEMATICAL SANS-SERIF BOLD CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D5D5 MATHEMATICAL SANS-SERIF BOLD CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D5D6 MATHEMATICAL SANS-SERIF BOLD CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 1D5D7 MATHEMATICAL SANS-SERIF BOLD CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D5D8 MATHEMATICAL SANS-SERIF BOLD CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D5D9 MATHEMATICAL SANS-SERIF BOLD CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 1D5DA MATHEMATICAL SANS-SERIF BOLD CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D5DB MATHEMATICAL SANS-SERIF BOLD CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 1D5DC MATHEMATICAL SANS-SERIF BOLD CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 1D5DD MATHEMATICAL SANS-SERIF BOLD CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D5DE MATHEMATICAL SANS-SERIF BOLD CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D5DF MATHEMATICAL SANS-SERIF BOLD CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D5E0 MATHEMATICAL SANS-SERIF BOLD CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D5E1 MATHEMATICAL SANS-SERIF BOLD CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D5E2 MATHEMATICAL SANS-SERIF BOLD CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D5E3 MATHEMATICAL SANS-SERIF BOLD CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D5E4 MATHEMATICAL SANS-SERIF BOLD CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 1D5E5 MATHEMATICAL SANS-SERIF BOLD CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 1D5E6 MATHEMATICAL SANS-SERIF BOLD CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D5E7 MATHEMATICAL SANS-SERIF BOLD CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D5E8 MATHEMATICAL SANS-SERIF BOLD CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D5E9 MATHEMATICAL SANS-SERIF BOLD CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D5EA MATHEMATICAL SANS-SERIF BOLD CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D5EB MATHEMATICAL SANS-SERIF BOLD CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D5EC MATHEMATICAL SANS-SERIF BOLD CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D5ED MATHEMATICAL SANS-SERIF BOLD CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 1D5EE MATHEMATICAL SANS-SERIF BOLD SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D5EF MATHEMATICAL SANS-SERIF BOLD SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D5F0 MATHEMATICAL SANS-SERIF BOLD SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D5F1 MATHEMATICAL SANS-SERIF BOLD SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D5F2 MATHEMATICAL SANS-SERIF BOLD SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D5F3 MATHEMATICAL SANS-SERIF BOLD SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D5F4 MATHEMATICAL SANS-SERIF BOLD SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D5F5 MATHEMATICAL SANS-SERIF BOLD SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 1D5F6 MATHEMATICAL SANS-SERIF BOLD SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D5F7 MATHEMATICAL SANS-SERIF BOLD SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D5F8 MATHEMATICAL SANS-SERIF BOLD SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D5F9 MATHEMATICAL SANS-SERIF BOLD SMALL L
 * 	006C LATIN SMALL LETTER L
 * 1D5FA MATHEMATICAL SANS-SERIF BOLD SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D5FB MATHEMATICAL SANS-SERIF BOLD SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D5FC MATHEMATICAL SANS-SERIF BOLD SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D5FD MATHEMATICAL SANS-SERIF BOLD SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D5FE MATHEMATICAL SANS-SERIF BOLD SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D5FF MATHEMATICAL SANS-SERIF BOLD SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D600 MATHEMATICAL SANS-SERIF BOLD SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D601 MATHEMATICAL SANS-SERIF BOLD SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D602 MATHEMATICAL SANS-SERIF BOLD SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D603 MATHEMATICAL SANS-SERIF BOLD SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D604 MATHEMATICAL SANS-SERIF BOLD SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D605 MATHEMATICAL SANS-SERIF BOLD SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D606 MATHEMATICAL SANS-SERIF BOLD SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D607 MATHEMATICAL SANS-SERIF BOLD SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D608 MATHEMATICAL SANS-SERIF ITALIC CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D609 MATHEMATICAL SANS-SERIF ITALIC CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D60A MATHEMATICAL SANS-SERIF ITALIC CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 1D60B MATHEMATICAL SANS-SERIF ITALIC CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D60C MATHEMATICAL SANS-SERIF ITALIC CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D60D MATHEMATICAL SANS-SERIF ITALIC CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 1D60E MATHEMATICAL SANS-SERIF ITALIC CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D60F MATHEMATICAL SANS-SERIF ITALIC CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 1D610 MATHEMATICAL SANS-SERIF ITALIC CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 1D611 MATHEMATICAL SANS-SERIF ITALIC CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D612 MATHEMATICAL SANS-SERIF ITALIC CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D613 MATHEMATICAL SANS-SERIF ITALIC CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D614 MATHEMATICAL SANS-SERIF ITALIC CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D615 MATHEMATICAL SANS-SERIF ITALIC CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D616 MATHEMATICAL SANS-SERIF ITALIC CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D617 MATHEMATICAL SANS-SERIF ITALIC CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D618 MATHEMATICAL SANS-SERIF ITALIC CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 1D619 MATHEMATICAL SANS-SERIF ITALIC CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 1D61A MATHEMATICAL SANS-SERIF ITALIC CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D61B MATHEMATICAL SANS-SERIF ITALIC CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D61C MATHEMATICAL SANS-SERIF ITALIC CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D61D MATHEMATICAL SANS-SERIF ITALIC CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D61E MATHEMATICAL SANS-SERIF ITALIC CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D61F MATHEMATICAL SANS-SERIF ITALIC CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D620 MATHEMATICAL SANS-SERIF ITALIC CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D621 MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 1D622 MATHEMATICAL SANS-SERIF ITALIC SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D623 MATHEMATICAL SANS-SERIF ITALIC SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D624 MATHEMATICAL SANS-SERIF ITALIC SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D625 MATHEMATICAL SANS-SERIF ITALIC SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D626 MATHEMATICAL SANS-SERIF ITALIC SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D627 MATHEMATICAL SANS-SERIF ITALIC SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D628 MATHEMATICAL SANS-SERIF ITALIC SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D629 MATHEMATICAL SANS-SERIF ITALIC SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 1D62A MATHEMATICAL SANS-SERIF ITALIC SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D62B MATHEMATICAL SANS-SERIF ITALIC SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D62C MATHEMATICAL SANS-SERIF ITALIC SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D62D MATHEMATICAL SANS-SERIF ITALIC SMALL L
 * 	006C LATIN SMALL LETTER L
 * 1D62E MATHEMATICAL SANS-SERIF ITALIC SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D62F MATHEMATICAL SANS-SERIF ITALIC SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D630 MATHEMATICAL SANS-SERIF ITALIC SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D631 MATHEMATICAL SANS-SERIF ITALIC SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D632 MATHEMATICAL SANS-SERIF ITALIC SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D633 MATHEMATICAL SANS-SERIF ITALIC SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D634 MATHEMATICAL SANS-SERIF ITALIC SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D635 MATHEMATICAL SANS-SERIF ITALIC SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D636 MATHEMATICAL SANS-SERIF ITALIC SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D637 MATHEMATICAL SANS-SERIF ITALIC SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D638 MATHEMATICAL SANS-SERIF ITALIC SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D639 MATHEMATICAL SANS-SERIF ITALIC SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D63A MATHEMATICAL SANS-SERIF ITALIC SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D63B MATHEMATICAL SANS-SERIF ITALIC SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D63C MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D63D MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D63E MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 1D63F MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D640 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D641 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 1D642 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D643 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 1D644 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 1D645 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D646 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D647 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D648 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D649 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D64A MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D64B MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D64C MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 1D64D MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 1D64E MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D64F MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D650 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D651 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D652 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D653 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D654 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D655 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 1D656 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D657 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D658 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D659 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D65A MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D65B MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D65C MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D65D MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 1D65E MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D65F MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D660 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D661 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L
 * 	006C LATIN SMALL LETTER L
 * 1D662 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D663 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D664 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D665 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D666 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D667 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D668 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D669 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D66A MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D66B MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D66C MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D66D MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D66E MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D66F MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D670 MATHEMATICAL MONOSPACE CAPITAL A
 * 	0041 LATIN CAPITAL LETTER A
 * 1D671 MATHEMATICAL MONOSPACE CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 1D672 MATHEMATICAL MONOSPACE CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 1D673 MATHEMATICAL MONOSPACE CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 1D674 MATHEMATICAL MONOSPACE CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 1D675 MATHEMATICAL MONOSPACE CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 1D676 MATHEMATICAL MONOSPACE CAPITAL G
 * 	0047 LATIN CAPITAL LETTER G
 * 1D677 MATHEMATICAL MONOSPACE CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 1D678 MATHEMATICAL MONOSPACE CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 1D679 MATHEMATICAL MONOSPACE CAPITAL J
 * 	004A LATIN CAPITAL LETTER J
 * 1D67A MATHEMATICAL MONOSPACE CAPITAL K
 * 	004B LATIN CAPITAL LETTER K
 * 1D67B MATHEMATICAL MONOSPACE CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 1D67C MATHEMATICAL MONOSPACE CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 1D67D MATHEMATICAL MONOSPACE CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 1D67E MATHEMATICAL MONOSPACE CAPITAL O
 * 	004F LATIN CAPITAL LETTER O
 * 1D67F MATHEMATICAL MONOSPACE CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 1D680 MATHEMATICAL MONOSPACE CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 1D681 MATHEMATICAL MONOSPACE CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 1D682 MATHEMATICAL MONOSPACE CAPITAL S
 * 	0053 LATIN CAPITAL LETTER S
 * 1D683 MATHEMATICAL MONOSPACE CAPITAL T
 * 	0054 LATIN CAPITAL LETTER T
 * 1D684 MATHEMATICAL MONOSPACE CAPITAL U
 * 	0055 LATIN CAPITAL LETTER U
 * 1D685 MATHEMATICAL MONOSPACE CAPITAL V
 * 	0056 LATIN CAPITAL LETTER V
 * 1D686 MATHEMATICAL MONOSPACE CAPITAL W
 * 	0057 LATIN CAPITAL LETTER W
 * 1D687 MATHEMATICAL MONOSPACE CAPITAL X
 * 	0058 LATIN CAPITAL LETTER X
 * 1D688 MATHEMATICAL MONOSPACE CAPITAL Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 1D689 MATHEMATICAL MONOSPACE CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 1D68A MATHEMATICAL MONOSPACE SMALL A
 * 	0061 LATIN SMALL LETTER A
 * 1D68B MATHEMATICAL MONOSPACE SMALL B
 * 	0062 LATIN SMALL LETTER B
 * 1D68C MATHEMATICAL MONOSPACE SMALL C
 * 	0063 LATIN SMALL LETTER C
 * 1D68D MATHEMATICAL MONOSPACE SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 1D68E MATHEMATICAL MONOSPACE SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 1D68F MATHEMATICAL MONOSPACE SMALL F
 * 	0066 LATIN SMALL LETTER F
 * 1D690 MATHEMATICAL MONOSPACE SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 1D691 MATHEMATICAL MONOSPACE SMALL H
 * 	0068 LATIN SMALL LETTER H
 * 1D692 MATHEMATICAL MONOSPACE SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 1D693 MATHEMATICAL MONOSPACE SMALL J
 * 	006A LATIN SMALL LETTER J
 * 1D694 MATHEMATICAL MONOSPACE SMALL K
 * 	006B LATIN SMALL LETTER K
 * 1D695 MATHEMATICAL MONOSPACE SMALL L
 * 	006C LATIN SMALL LETTER L
 * 1D696 MATHEMATICAL MONOSPACE SMALL M
 * 	006D LATIN SMALL LETTER M
 * 1D697 MATHEMATICAL MONOSPACE SMALL N
 * 	006E LATIN SMALL LETTER N
 * 1D698 MATHEMATICAL MONOSPACE SMALL O
 * 	006F LATIN SMALL LETTER O
 * 1D699 MATHEMATICAL MONOSPACE SMALL P
 * 	0070 LATIN SMALL LETTER P
 * 1D69A MATHEMATICAL MONOSPACE SMALL Q
 * 	0071 LATIN SMALL LETTER Q
 * 1D69B MATHEMATICAL MONOSPACE SMALL R
 * 	0072 LATIN SMALL LETTER R
 * 1D69C MATHEMATICAL MONOSPACE SMALL S
 * 	0073 LATIN SMALL LETTER S
 * 1D69D MATHEMATICAL MONOSPACE SMALL T
 * 	0074 LATIN SMALL LETTER T
 * 1D69E MATHEMATICAL MONOSPACE SMALL U
 * 	0075 LATIN SMALL LETTER U
 * 1D69F MATHEMATICAL MONOSPACE SMALL V
 * 	0076 LATIN SMALL LETTER V
 * 1D6A0 MATHEMATICAL MONOSPACE SMALL W
 * 	0077 LATIN SMALL LETTER W
 * 1D6A1 MATHEMATICAL MONOSPACE SMALL X
 * 	0078 LATIN SMALL LETTER X
 * 1D6A2 MATHEMATICAL MONOSPACE SMALL Y
 * 	0079 LATIN SMALL LETTER Y
 * 1D6A3 MATHEMATICAL MONOSPACE SMALL Z
 * 	007A LATIN SMALL LETTER Z
 * 1D6A8 MATHEMATICAL BOLD CAPITAL ALPHA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1D6A9 MATHEMATICAL BOLD CAPITAL BETA
 * 	0392 GREEK CAPITAL LETTER BETA
 * 1D6AA MATHEMATICAL BOLD CAPITAL GAMMA
 * 	0393 GREEK CAPITAL LETTER GAMMA
 * 1D6AB MATHEMATICAL BOLD CAPITAL DELTA
 * 	0394 GREEK CAPITAL LETTER DELTA
 * 1D6AC MATHEMATICAL BOLD CAPITAL EPSILON
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1D6AD MATHEMATICAL BOLD CAPITAL ZETA
 * 	0396 GREEK CAPITAL LETTER ZETA
 * 1D6AE MATHEMATICAL BOLD CAPITAL ETA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1D6AF MATHEMATICAL BOLD CAPITAL THETA
 * 	0398 GREEK CAPITAL LETTER THETA
 * 1D6B0 MATHEMATICAL BOLD CAPITAL IOTA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1D6B1 MATHEMATICAL BOLD CAPITAL KAPPA
 * 	039A GREEK CAPITAL LETTER KAPPA
 * 1D6B2 MATHEMATICAL BOLD CAPITAL LAMDA
 * 	039B GREEK CAPITAL LETTER LAMDA
 * 1D6B3 MATHEMATICAL BOLD CAPITAL MU
 * 	039C GREEK CAPITAL LETTER MU
 * 1D6B4 MATHEMATICAL BOLD CAPITAL NU
 * 	039D GREEK CAPITAL LETTER NU
 * 1D6B5 MATHEMATICAL BOLD CAPITAL XI
 * 	039E GREEK CAPITAL LETTER XI
 * 1D6B6 MATHEMATICAL BOLD CAPITAL OMICRON
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1D6B7 MATHEMATICAL BOLD CAPITAL PI
 * 	03A0 GREEK CAPITAL LETTER PI
 * 1D6B8 MATHEMATICAL BOLD CAPITAL RHO
 * 	03A1 GREEK CAPITAL LETTER RHO
 * 1D6B9 MATHEMATICAL BOLD CAPITAL THETA SYMBOL
 * 	0398 GREEK CAPITAL LETTER THETA
 * 1D6BA MATHEMATICAL BOLD CAPITAL SIGMA
 * 	03A3 GREEK CAPITAL LETTER SIGMA
 * 1D6BB MATHEMATICAL BOLD CAPITAL TAU
 * 	03A4 GREEK CAPITAL LETTER TAU
 * 1D6BC MATHEMATICAL BOLD CAPITAL UPSILON
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1D6BD MATHEMATICAL BOLD CAPITAL PHI
 * 	03A6 GREEK CAPITAL LETTER PHI
 * 1D6BE MATHEMATICAL BOLD CAPITAL CHI
 * 	03A7 GREEK CAPITAL LETTER CHI
 * 1D6BF MATHEMATICAL BOLD CAPITAL PSI
 * 	03A8 GREEK CAPITAL LETTER PSI
 * 1D6C0 MATHEMATICAL BOLD CAPITAL OMEGA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1D6C1 MATHEMATICAL BOLD NABLA
 * 	2207 NABLA
 * 1D6C2 MATHEMATICAL BOLD SMALL ALPHA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1D6C3 MATHEMATICAL BOLD SMALL BETA
 * 	03B2 GREEK SMALL LETTER BETA
 * 1D6C4 MATHEMATICAL BOLD SMALL GAMMA
 * 	03B3 GREEK SMALL LETTER GAMMA
 * 1D6C5 MATHEMATICAL BOLD SMALL DELTA
 * 	03B4 GREEK SMALL LETTER DELTA
 * 1D6C6 MATHEMATICAL BOLD SMALL EPSILON
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1D6C7 MATHEMATICAL BOLD SMALL ZETA
 * 	03B6 GREEK SMALL LETTER ZETA
 * 1D6C8 MATHEMATICAL BOLD SMALL ETA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1D6C9 MATHEMATICAL BOLD SMALL THETA
 * 	03B8 GREEK SMALL LETTER THETA
 * 1D6CA MATHEMATICAL BOLD SMALL IOTA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1D6CB MATHEMATICAL BOLD SMALL KAPPA
 * 	03BA GREEK SMALL LETTER KAPPA
 * 1D6CC MATHEMATICAL BOLD SMALL LAMDA
 * 	03BB GREEK SMALL LETTER LAMDA
 * 1D6CD MATHEMATICAL BOLD SMALL MU
 * 	03BC GREEK SMALL LETTER MU
 * 1D6CE MATHEMATICAL BOLD SMALL NU
 * 	03BD GREEK SMALL LETTER NU
 * 1D6CF MATHEMATICAL BOLD SMALL XI
 * 	03BE GREEK SMALL LETTER XI
 * 1D6D0 MATHEMATICAL BOLD SMALL OMICRON
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1D6D1 MATHEMATICAL BOLD SMALL PI
 * 	03C0 GREEK SMALL LETTER PI
 * 1D6D2 MATHEMATICAL BOLD SMALL RHO
 * 	03C1 GREEK SMALL LETTER RHO
 * 1D6D3 MATHEMATICAL BOLD SMALL FINAL SIGMA
 * 	03C2 GREEK SMALL LETTER FINAL SIGMA
 * 1D6D4 MATHEMATICAL BOLD SMALL SIGMA
 * 	03C3 GREEK SMALL LETTER SIGMA
 * 1D6D5 MATHEMATICAL BOLD SMALL TAU
 * 	03C4 GREEK SMALL LETTER TAU
 * 1D6D6 MATHEMATICAL BOLD SMALL UPSILON
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1D6D7 MATHEMATICAL BOLD SMALL PHI
 * 	03C6 GREEK SMALL LETTER PHI
 * 1D6D8 MATHEMATICAL BOLD SMALL CHI
 * 	03C7 GREEK SMALL LETTER CHI
 * 1D6D9 MATHEMATICAL BOLD SMALL PSI
 * 	03C8 GREEK SMALL LETTER PSI
 * 1D6DA MATHEMATICAL BOLD SMALL OMEGA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1D6DB MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
 * 	2202 PARTIAL DIFFERENTIAL
 * 1D6DC MATHEMATICAL BOLD EPSILON SYMBOL
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1D6DD MATHEMATICAL BOLD THETA SYMBOL
 * 	03B8 GREEK SMALL LETTER THETA
 * 1D6DE MATHEMATICAL BOLD KAPPA SYMBOL
 * 	03BA GREEK SMALL LETTER KAPPA
 * 1D6DF MATHEMATICAL BOLD PHI SYMBOL
 * 	03C6 GREEK SMALL LETTER PHI
 * 1D6E0 MATHEMATICAL BOLD RHO SYMBOL
 * 	03C1 GREEK SMALL LETTER RHO
 * 1D6E1 MATHEMATICAL BOLD PI SYMBOL
 * 	03C0 GREEK SMALL LETTER PI
 * 1D6E2 MATHEMATICAL ITALIC CAPITAL ALPHA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1D6E3 MATHEMATICAL ITALIC CAPITAL BETA
 * 	0392 GREEK CAPITAL LETTER BETA
 * 1D6E4 MATHEMATICAL ITALIC CAPITAL GAMMA
 * 	0393 GREEK CAPITAL LETTER GAMMA
 * 1D6E5 MATHEMATICAL ITALIC CAPITAL DELTA
 * 	0394 GREEK CAPITAL LETTER DELTA
 * 1D6E6 MATHEMATICAL ITALIC CAPITAL EPSILON
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1D6E7 MATHEMATICAL ITALIC CAPITAL ZETA
 * 	0396 GREEK CAPITAL LETTER ZETA
 * 1D6E8 MATHEMATICAL ITALIC CAPITAL ETA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1D6E9 MATHEMATICAL ITALIC CAPITAL THETA
 * 	0398 GREEK CAPITAL LETTER THETA
 * 1D6EA MATHEMATICAL ITALIC CAPITAL IOTA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1D6EB MATHEMATICAL ITALIC CAPITAL KAPPA
 * 	039A GREEK CAPITAL LETTER KAPPA
 * 1D6EC MATHEMATICAL ITALIC CAPITAL LAMDA
 * 	039B GREEK CAPITAL LETTER LAMDA
 * 1D6ED MATHEMATICAL ITALIC CAPITAL MU
 * 	039C GREEK CAPITAL LETTER MU
 * 1D6EE MATHEMATICAL ITALIC CAPITAL NU
 * 	039D GREEK CAPITAL LETTER NU
 * 1D6EF MATHEMATICAL ITALIC CAPITAL XI
 * 	039E GREEK CAPITAL LETTER XI
 * 1D6F0 MATHEMATICAL ITALIC CAPITAL OMICRON
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1D6F1 MATHEMATICAL ITALIC CAPITAL PI
 * 	03A0 GREEK CAPITAL LETTER PI
 * 1D6F2 MATHEMATICAL ITALIC CAPITAL RHO
 * 	03A1 GREEK CAPITAL LETTER RHO
 * 1D6F3 MATHEMATICAL ITALIC CAPITAL THETA SYMBOL
 * 	0398 GREEK CAPITAL LETTER THETA
 * 1D6F4 MATHEMATICAL ITALIC CAPITAL SIGMA
 * 	03A3 GREEK CAPITAL LETTER SIGMA
 * 1D6F5 MATHEMATICAL ITALIC CAPITAL TAU
 * 	03A4 GREEK CAPITAL LETTER TAU
 * 1D6F6 MATHEMATICAL ITALIC CAPITAL UPSILON
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1D6F7 MATHEMATICAL ITALIC CAPITAL PHI
 * 	03A6 GREEK CAPITAL LETTER PHI
 * 1D6F8 MATHEMATICAL ITALIC CAPITAL CHI
 * 	03A7 GREEK CAPITAL LETTER CHI
 * 1D6F9 MATHEMATICAL ITALIC CAPITAL PSI
 * 	03A8 GREEK CAPITAL LETTER PSI
 * 1D6FA MATHEMATICAL ITALIC CAPITAL OMEGA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1D6FB MATHEMATICAL ITALIC NABLA
 * 	2207 NABLA
 * 1D6FC MATHEMATICAL ITALIC SMALL ALPHA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1D6FD MATHEMATICAL ITALIC SMALL BETA
 * 	03B2 GREEK SMALL LETTER BETA
 * 1D6FE MATHEMATICAL ITALIC SMALL GAMMA
 * 	03B3 GREEK SMALL LETTER GAMMA
 * 1D6FF MATHEMATICAL ITALIC SMALL DELTA
 * 	03B4 GREEK SMALL LETTER DELTA
 * 1D700 MATHEMATICAL ITALIC SMALL EPSILON
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1D701 MATHEMATICAL ITALIC SMALL ZETA
 * 	03B6 GREEK SMALL LETTER ZETA
 * 1D702 MATHEMATICAL ITALIC SMALL ETA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1D703 MATHEMATICAL ITALIC SMALL THETA
 * 	03B8 GREEK SMALL LETTER THETA
 * 1D704 MATHEMATICAL ITALIC SMALL IOTA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1D705 MATHEMATICAL ITALIC SMALL KAPPA
 * 	03BA GREEK SMALL LETTER KAPPA
 * 1D706 MATHEMATICAL ITALIC SMALL LAMDA
 * 	03BB GREEK SMALL LETTER LAMDA
 * 1D707 MATHEMATICAL ITALIC SMALL MU
 * 	03BC GREEK SMALL LETTER MU
 * 1D708 MATHEMATICAL ITALIC SMALL NU
 * 	03BD GREEK SMALL LETTER NU
 * 1D709 MATHEMATICAL ITALIC SMALL XI
 * 	03BE GREEK SMALL LETTER XI
 * 1D70A MATHEMATICAL ITALIC SMALL OMICRON
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1D70B MATHEMATICAL ITALIC SMALL PI
 * 	03C0 GREEK SMALL LETTER PI
 * 1D70C MATHEMATICAL ITALIC SMALL RHO
 * 	03C1 GREEK SMALL LETTER RHO
 * 1D70D MATHEMATICAL ITALIC SMALL FINAL SIGMA
 * 	03C2 GREEK SMALL LETTER FINAL SIGMA
 * 1D70E MATHEMATICAL ITALIC SMALL SIGMA
 * 	03C3 GREEK SMALL LETTER SIGMA
 * 1D70F MATHEMATICAL ITALIC SMALL TAU
 * 	03C4 GREEK SMALL LETTER TAU
 * 1D710 MATHEMATICAL ITALIC SMALL UPSILON
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1D711 MATHEMATICAL ITALIC SMALL PHI
 * 	03C6 GREEK SMALL LETTER PHI
 * 1D712 MATHEMATICAL ITALIC SMALL CHI
 * 	03C7 GREEK SMALL LETTER CHI
 * 1D713 MATHEMATICAL ITALIC SMALL PSI
 * 	03C8 GREEK SMALL LETTER PSI
 * 1D714 MATHEMATICAL ITALIC SMALL OMEGA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1D715 MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
 * 	2202 PARTIAL DIFFERENTIAL
 * 1D716 MATHEMATICAL ITALIC EPSILON SYMBOL
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1D717 MATHEMATICAL ITALIC THETA SYMBOL
 * 	03B8 GREEK SMALL LETTER THETA
 * 1D718 MATHEMATICAL ITALIC KAPPA SYMBOL
 * 	03BA GREEK SMALL LETTER KAPPA
 * 1D719 MATHEMATICAL ITALIC PHI SYMBOL
 * 	03C6 GREEK SMALL LETTER PHI
 * 1D71A MATHEMATICAL ITALIC RHO SYMBOL
 * 	03C1 GREEK SMALL LETTER RHO
 * 1D71B MATHEMATICAL ITALIC PI SYMBOL
 * 	03C0 GREEK SMALL LETTER PI
 * 1D71C MATHEMATICAL BOLD ITALIC CAPITAL ALPHA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1D71D MATHEMATICAL BOLD ITALIC CAPITAL BETA
 * 	0392 GREEK CAPITAL LETTER BETA
 * 1D71E MATHEMATICAL BOLD ITALIC CAPITAL GAMMA
 * 	0393 GREEK CAPITAL LETTER GAMMA
 * 1D71F MATHEMATICAL BOLD ITALIC CAPITAL DELTA
 * 	0394 GREEK CAPITAL LETTER DELTA
 * 1D720 MATHEMATICAL BOLD ITALIC CAPITAL EPSILON
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1D721 MATHEMATICAL BOLD ITALIC CAPITAL ZETA
 * 	0396 GREEK CAPITAL LETTER ZETA
 * 1D722 MATHEMATICAL BOLD ITALIC CAPITAL ETA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1D723 MATHEMATICAL BOLD ITALIC CAPITAL THETA
 * 	0398 GREEK CAPITAL LETTER THETA
 * 1D724 MATHEMATICAL BOLD ITALIC CAPITAL IOTA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1D725 MATHEMATICAL BOLD ITALIC CAPITAL KAPPA
 * 	039A GREEK CAPITAL LETTER KAPPA
 * 1D726 MATHEMATICAL BOLD ITALIC CAPITAL LAMDA
 * 	039B GREEK CAPITAL LETTER LAMDA
 * 1D727 MATHEMATICAL BOLD ITALIC CAPITAL MU
 * 	039C GREEK CAPITAL LETTER MU
 * 1D728 MATHEMATICAL BOLD ITALIC CAPITAL NU
 * 	039D GREEK CAPITAL LETTER NU
 * 1D729 MATHEMATICAL BOLD ITALIC CAPITAL XI
 * 	039E GREEK CAPITAL LETTER XI
 * 1D72A MATHEMATICAL BOLD ITALIC CAPITAL OMICRON
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1D72B MATHEMATICAL BOLD ITALIC CAPITAL PI
 * 	03A0 GREEK CAPITAL LETTER PI
 * 1D72C MATHEMATICAL BOLD ITALIC CAPITAL RHO
 * 	03A1 GREEK CAPITAL LETTER RHO
 * 1D72D MATHEMATICAL BOLD ITALIC CAPITAL THETA SYMBOL
 * 	0398 GREEK CAPITAL LETTER THETA
 * 1D72E MATHEMATICAL BOLD ITALIC CAPITAL SIGMA
 * 	03A3 GREEK CAPITAL LETTER SIGMA
 * 1D72F MATHEMATICAL BOLD ITALIC CAPITAL TAU
 * 	03A4 GREEK CAPITAL LETTER TAU
 * 1D730 MATHEMATICAL BOLD ITALIC CAPITAL UPSILON
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1D731 MATHEMATICAL BOLD ITALIC CAPITAL PHI
 * 	03A6 GREEK CAPITAL LETTER PHI
 * 1D732 MATHEMATICAL BOLD ITALIC CAPITAL CHI
 * 	03A7 GREEK CAPITAL LETTER CHI
 * 1D733 MATHEMATICAL BOLD ITALIC CAPITAL PSI
 * 	03A8 GREEK CAPITAL LETTER PSI
 * 1D734 MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1D735 MATHEMATICAL BOLD ITALIC NABLA
 * 	2207 NABLA
 * 1D736 MATHEMATICAL BOLD ITALIC SMALL ALPHA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1D737 MATHEMATICAL BOLD ITALIC SMALL BETA
 * 	03B2 GREEK SMALL LETTER BETA
 * 1D738 MATHEMATICAL BOLD ITALIC SMALL GAMMA
 * 	03B3 GREEK SMALL LETTER GAMMA
 * 1D739 MATHEMATICAL BOLD ITALIC SMALL DELTA
 * 	03B4 GREEK SMALL LETTER DELTA
 * 1D73A MATHEMATICAL BOLD ITALIC SMALL EPSILON
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1D73B MATHEMATICAL BOLD ITALIC SMALL ZETA
 * 	03B6 GREEK SMALL LETTER ZETA
 * 1D73C MATHEMATICAL BOLD ITALIC SMALL ETA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1D73D MATHEMATICAL BOLD ITALIC SMALL THETA
 * 	03B8 GREEK SMALL LETTER THETA
 * 1D73E MATHEMATICAL BOLD ITALIC SMALL IOTA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1D73F MATHEMATICAL BOLD ITALIC SMALL KAPPA
 * 	03BA GREEK SMALL LETTER KAPPA
 * 1D740 MATHEMATICAL BOLD ITALIC SMALL LAMDA
 * 	03BB GREEK SMALL LETTER LAMDA
 * 1D741 MATHEMATICAL BOLD ITALIC SMALL MU
 * 	03BC GREEK SMALL LETTER MU
 * 1D742 MATHEMATICAL BOLD ITALIC SMALL NU
 * 	03BD GREEK SMALL LETTER NU
 * 1D743 MATHEMATICAL BOLD ITALIC SMALL XI
 * 	03BE GREEK SMALL LETTER XI
 * 1D744 MATHEMATICAL BOLD ITALIC SMALL OMICRON
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1D745 MATHEMATICAL BOLD ITALIC SMALL PI
 * 	03C0 GREEK SMALL LETTER PI
 * 1D746 MATHEMATICAL BOLD ITALIC SMALL RHO
 * 	03C1 GREEK SMALL LETTER RHO
 * 1D747 MATHEMATICAL BOLD ITALIC SMALL FINAL SIGMA
 * 	03C2 GREEK SMALL LETTER FINAL SIGMA
 * 1D748 MATHEMATICAL BOLD ITALIC SMALL SIGMA
 * 	03C3 GREEK SMALL LETTER SIGMA
 * 1D749 MATHEMATICAL BOLD ITALIC SMALL TAU
 * 	03C4 GREEK SMALL LETTER TAU
 * 1D74A MATHEMATICAL BOLD ITALIC SMALL UPSILON
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1D74B MATHEMATICAL BOLD ITALIC SMALL PHI
 * 	03C6 GREEK SMALL LETTER PHI
 * 1D74C MATHEMATICAL BOLD ITALIC SMALL CHI
 * 	03C7 GREEK SMALL LETTER CHI
 * 1D74D MATHEMATICAL BOLD ITALIC SMALL PSI
 * 	03C8 GREEK SMALL LETTER PSI
 * 1D74E MATHEMATICAL BOLD ITALIC SMALL OMEGA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1D74F MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
 * 	2202 PARTIAL DIFFERENTIAL
 * 1D750 MATHEMATICAL BOLD ITALIC EPSILON SYMBOL
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1D751 MATHEMATICAL BOLD ITALIC THETA SYMBOL
 * 	03B8 GREEK SMALL LETTER THETA
 * 1D752 MATHEMATICAL BOLD ITALIC KAPPA SYMBOL
 * 	03BA GREEK SMALL LETTER KAPPA
 * 1D753 MATHEMATICAL BOLD ITALIC PHI SYMBOL
 * 	03C6 GREEK SMALL LETTER PHI
 * 1D754 MATHEMATICAL BOLD ITALIC RHO SYMBOL
 * 	03C1 GREEK SMALL LETTER RHO
 * 1D755 MATHEMATICAL BOLD ITALIC PI SYMBOL
 * 	03C0 GREEK SMALL LETTER PI
 * 1D756 MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1D757 MATHEMATICAL SANS-SERIF BOLD CAPITAL BETA
 * 	0392 GREEK CAPITAL LETTER BETA
 * 1D758 MATHEMATICAL SANS-SERIF BOLD CAPITAL GAMMA
 * 	0393 GREEK CAPITAL LETTER GAMMA
 * 1D759 MATHEMATICAL SANS-SERIF BOLD CAPITAL DELTA
 * 	0394 GREEK CAPITAL LETTER DELTA
 * 1D75A MATHEMATICAL SANS-SERIF BOLD CAPITAL EPSILON
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1D75B MATHEMATICAL SANS-SERIF BOLD CAPITAL ZETA
 * 	0396 GREEK CAPITAL LETTER ZETA
 * 1D75C MATHEMATICAL SANS-SERIF BOLD CAPITAL ETA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1D75D MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA
 * 	0398 GREEK CAPITAL LETTER THETA
 * 1D75E MATHEMATICAL SANS-SERIF BOLD CAPITAL IOTA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1D75F MATHEMATICAL SANS-SERIF BOLD CAPITAL KAPPA
 * 	039A GREEK CAPITAL LETTER KAPPA
 * 1D760 MATHEMATICAL SANS-SERIF BOLD CAPITAL LAMDA
 * 	039B GREEK CAPITAL LETTER LAMDA
 * 1D761 MATHEMATICAL SANS-SERIF BOLD CAPITAL MU
 * 	039C GREEK CAPITAL LETTER MU
 * 1D762 MATHEMATICAL SANS-SERIF BOLD CAPITAL NU
 * 	039D GREEK CAPITAL LETTER NU
 * 1D763 MATHEMATICAL SANS-SERIF BOLD CAPITAL XI
 * 	039E GREEK CAPITAL LETTER XI
 * 1D764 MATHEMATICAL SANS-SERIF BOLD CAPITAL OMICRON
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1D765 MATHEMATICAL SANS-SERIF BOLD CAPITAL PI
 * 	03A0 GREEK CAPITAL LETTER PI
 * 1D766 MATHEMATICAL SANS-SERIF BOLD CAPITAL RHO
 * 	03A1 GREEK CAPITAL LETTER RHO
 * 1D767 MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA SYMBOL
 * 	0398 GREEK CAPITAL LETTER THETA
 * 1D768 MATHEMATICAL SANS-SERIF BOLD CAPITAL SIGMA
 * 	03A3 GREEK CAPITAL LETTER SIGMA
 * 1D769 MATHEMATICAL SANS-SERIF BOLD CAPITAL TAU
 * 	03A4 GREEK CAPITAL LETTER TAU
 * 1D76A MATHEMATICAL SANS-SERIF BOLD CAPITAL UPSILON
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1D76B MATHEMATICAL SANS-SERIF BOLD CAPITAL PHI
 * 	03A6 GREEK CAPITAL LETTER PHI
 * 1D76C MATHEMATICAL SANS-SERIF BOLD CAPITAL CHI
 * 	03A7 GREEK CAPITAL LETTER CHI
 * 1D76D MATHEMATICAL SANS-SERIF BOLD CAPITAL PSI
 * 	03A8 GREEK CAPITAL LETTER PSI
 * 1D76E MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1D76F MATHEMATICAL SANS-SERIF BOLD NABLA
 * 	2207 NABLA
 * 1D770 MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1D771 MATHEMATICAL SANS-SERIF BOLD SMALL BETA
 * 	03B2 GREEK SMALL LETTER BETA
 * 1D772 MATHEMATICAL SANS-SERIF BOLD SMALL GAMMA
 * 	03B3 GREEK SMALL LETTER GAMMA
 * 1D773 MATHEMATICAL SANS-SERIF BOLD SMALL DELTA
 * 	03B4 GREEK SMALL LETTER DELTA
 * 1D774 MATHEMATICAL SANS-SERIF BOLD SMALL EPSILON
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1D775 MATHEMATICAL SANS-SERIF BOLD SMALL ZETA
 * 	03B6 GREEK SMALL LETTER ZETA
 * 1D776 MATHEMATICAL SANS-SERIF BOLD SMALL ETA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1D777 MATHEMATICAL SANS-SERIF BOLD SMALL THETA
 * 	03B8 GREEK SMALL LETTER THETA
 * 1D778 MATHEMATICAL SANS-SERIF BOLD SMALL IOTA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1D779 MATHEMATICAL SANS-SERIF BOLD SMALL KAPPA
 * 	03BA GREEK SMALL LETTER KAPPA
 * 1D77A MATHEMATICAL SANS-SERIF BOLD SMALL LAMDA
 * 	03BB GREEK SMALL LETTER LAMDA
 * 1D77B MATHEMATICAL SANS-SERIF BOLD SMALL MU
 * 	03BC GREEK SMALL LETTER MU
 * 1D77C MATHEMATICAL SANS-SERIF BOLD SMALL NU
 * 	03BD GREEK SMALL LETTER NU
 * 1D77D MATHEMATICAL SANS-SERIF BOLD SMALL XI
 * 	03BE GREEK SMALL LETTER XI
 * 1D77E MATHEMATICAL SANS-SERIF BOLD SMALL OMICRON
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1D77F MATHEMATICAL SANS-SERIF BOLD SMALL PI
 * 	03C0 GREEK SMALL LETTER PI
 * 1D780 MATHEMATICAL SANS-SERIF BOLD SMALL RHO
 * 	03C1 GREEK SMALL LETTER RHO
 * 1D781 MATHEMATICAL SANS-SERIF BOLD SMALL FINAL SIGMA
 * 	03C2 GREEK SMALL LETTER FINAL SIGMA
 * 1D782 MATHEMATICAL SANS-SERIF BOLD SMALL SIGMA
 * 	03C3 GREEK SMALL LETTER SIGMA
 * 1D783 MATHEMATICAL SANS-SERIF BOLD SMALL TAU
 * 	03C4 GREEK SMALL LETTER TAU
 * 1D784 MATHEMATICAL SANS-SERIF BOLD SMALL UPSILON
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1D785 MATHEMATICAL SANS-SERIF BOLD SMALL PHI
 * 	03C6 GREEK SMALL LETTER PHI
 * 1D786 MATHEMATICAL SANS-SERIF BOLD SMALL CHI
 * 	03C7 GREEK SMALL LETTER CHI
 * 1D787 MATHEMATICAL SANS-SERIF BOLD SMALL PSI
 * 	03C8 GREEK SMALL LETTER PSI
 * 1D788 MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1D789 MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
 * 	2202 PARTIAL DIFFERENTIAL
 * 1D78A MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1D78B MATHEMATICAL SANS-SERIF BOLD THETA SYMBOL
 * 	03B8 GREEK SMALL LETTER THETA
 * 1D78C MATHEMATICAL SANS-SERIF BOLD KAPPA SYMBOL
 * 	03BA GREEK SMALL LETTER KAPPA
 * 1D78D MATHEMATICAL SANS-SERIF BOLD PHI SYMBOL
 * 	03C6 GREEK SMALL LETTER PHI
 * 1D78E MATHEMATICAL SANS-SERIF BOLD RHO SYMBOL
 * 	03C1 GREEK SMALL LETTER RHO
 * 1D78F MATHEMATICAL SANS-SERIF BOLD PI SYMBOL
 * 	03C0 GREEK SMALL LETTER PI
 * 1D790 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1D791 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL BETA
 * 	0392 GREEK CAPITAL LETTER BETA
 * 1D792 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL GAMMA
 * 	0393 GREEK CAPITAL LETTER GAMMA
 * 1D793 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL DELTA
 * 	0394 GREEK CAPITAL LETTER DELTA
 * 1D794 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL EPSILON
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1D795 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ZETA
 * 	0396 GREEK CAPITAL LETTER ZETA
 * 1D796 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ETA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1D797 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA
 * 	0398 GREEK CAPITAL LETTER THETA
 * 1D798 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL IOTA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1D799 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL KAPPA
 * 	039A GREEK CAPITAL LETTER KAPPA
 * 1D79A MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL LAMDA
 * 	039B GREEK CAPITAL LETTER LAMDA
 * 1D79B MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL MU
 * 	039C GREEK CAPITAL LETTER MU
 * 1D79C MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL NU
 * 	039D GREEK CAPITAL LETTER NU
 * 1D79D MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL XI
 * 	039E GREEK CAPITAL LETTER XI
 * 1D79E MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMICRON
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1D79F MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PI
 * 	03A0 GREEK CAPITAL LETTER PI
 * 1D7A0 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL RHO
 * 	03A1 GREEK CAPITAL LETTER RHO
 * 1D7A1 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA SYMBOL
 * 	0398 GREEK CAPITAL LETTER THETA
 * 1D7A2 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL SIGMA
 * 	03A3 GREEK CAPITAL LETTER SIGMA
 * 1D7A3 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL TAU
 * 	03A4 GREEK CAPITAL LETTER TAU
 * 1D7A4 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL UPSILON
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1D7A5 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PHI
 * 	03A6 GREEK CAPITAL LETTER PHI
 * 1D7A6 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL CHI
 * 	03A7 GREEK CAPITAL LETTER CHI
 * 1D7A7 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PSI
 * 	03A8 GREEK CAPITAL LETTER PSI
 * 1D7A8 MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1D7A9 MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
 * 	2207 NABLA
 * 1D7AA MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1D7AB MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL BETA
 * 	03B2 GREEK SMALL LETTER BETA
 * 1D7AC MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL GAMMA
 * 	03B3 GREEK SMALL LETTER GAMMA
 * 1D7AD MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL DELTA
 * 	03B4 GREEK SMALL LETTER DELTA
 * 1D7AE MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL EPSILON
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1D7AF MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ZETA
 * 	03B6 GREEK SMALL LETTER ZETA
 * 1D7B0 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ETA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1D7B1 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL THETA
 * 	03B8 GREEK SMALL LETTER THETA
 * 1D7B2 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL IOTA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1D7B3 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL KAPPA
 * 	03BA GREEK SMALL LETTER KAPPA
 * 1D7B4 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL LAMDA
 * 	03BB GREEK SMALL LETTER LAMDA
 * 1D7B5 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL MU
 * 	03BC GREEK SMALL LETTER MU
 * 1D7B6 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL NU
 * 	03BD GREEK SMALL LETTER NU
 * 1D7B7 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL XI
 * 	03BE GREEK SMALL LETTER XI
 * 1D7B8 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMICRON
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1D7B9 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PI
 * 	03C0 GREEK SMALL LETTER PI
 * 1D7BA MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL RHO
 * 	03C1 GREEK SMALL LETTER RHO
 * 1D7BB MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL FINAL SIGMA
 * 	03C2 GREEK SMALL LETTER FINAL SIGMA
 * 1D7BC MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL SIGMA
 * 	03C3 GREEK SMALL LETTER SIGMA
 * 1D7BD MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL TAU
 * 	03C4 GREEK SMALL LETTER TAU
 * 1D7BE MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL UPSILON
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1D7BF MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PHI
 * 	03C6 GREEK SMALL LETTER PHI
 * 1D7C0 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL CHI
 * 	03C7 GREEK SMALL LETTER CHI
 * 1D7C1 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PSI
 * 	03C8 GREEK SMALL LETTER PSI
 * 1D7C2 MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1D7C3 MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
 * 	2202 PARTIAL DIFFERENTIAL
 * 1D7C4 MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1D7C5 MATHEMATICAL SANS-SERIF BOLD ITALIC THETA SYMBOL
 * 	03B8 GREEK SMALL LETTER THETA
 * 1D7C6 MATHEMATICAL SANS-SERIF BOLD ITALIC KAPPA SYMBOL
 * 	03BA GREEK SMALL LETTER KAPPA
 * 1D7C7 MATHEMATICAL SANS-SERIF BOLD ITALIC PHI SYMBOL
 * 	03C6 GREEK SMALL LETTER PHI
 * 1D7C8 MATHEMATICAL SANS-SERIF BOLD ITALIC RHO SYMBOL
 * 	03C1 GREEK SMALL LETTER RHO
 * 1D7C9 MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL
 * 	03C0 GREEK SMALL LETTER PI
 * 1D7CE MATHEMATICAL BOLD DIGIT ZERO
 * 	0030 DIGIT ZERO
 * 1D7CF MATHEMATICAL BOLD DIGIT ONE
 * 	0031 DIGIT ONE
 * 1D7D0 MATHEMATICAL BOLD DIGIT TWO
 * 	0032 DIGIT TWO
 * 1D7D1 MATHEMATICAL BOLD DIGIT THREE
 * 	0033 DIGIT THREE
 * 1D7D2 MATHEMATICAL BOLD DIGIT FOUR
 * 	0034 DIGIT FOUR
 * 1D7D3 MATHEMATICAL BOLD DIGIT FIVE
 * 	0035 DIGIT FIVE
 * 1D7D4 MATHEMATICAL BOLD DIGIT SIX
 * 	0036 DIGIT SIX
 * 1D7D5 MATHEMATICAL BOLD DIGIT SEVEN
 * 	0037 DIGIT SEVEN
 * 1D7D6 MATHEMATICAL BOLD DIGIT EIGHT
 * 	0038 DIGIT EIGHT
 * 1D7D7 MATHEMATICAL BOLD DIGIT NINE
 * 	0039 DIGIT NINE
 * 1D7D8 MATHEMATICAL DOUBLE-STRUCK DIGIT ZERO
 * 	0030 DIGIT ZERO
 * 1D7D9 MATHEMATICAL DOUBLE-STRUCK DIGIT ONE
 * 	0031 DIGIT ONE
 * 1D7DA MATHEMATICAL DOUBLE-STRUCK DIGIT TWO
 * 	0032 DIGIT TWO
 * 1D7DB MATHEMATICAL DOUBLE-STRUCK DIGIT THREE
 * 	0033 DIGIT THREE
 * 1D7DC MATHEMATICAL DOUBLE-STRUCK DIGIT FOUR
 * 	0034 DIGIT FOUR
 * 1D7DD MATHEMATICAL DOUBLE-STRUCK DIGIT FIVE
 * 	0035 DIGIT FIVE
 * 1D7DE MATHEMATICAL DOUBLE-STRUCK DIGIT SIX
 * 	0036 DIGIT SIX
 * 1D7DF MATHEMATICAL DOUBLE-STRUCK DIGIT SEVEN
 * 	0037 DIGIT SEVEN
 * 1D7E0 MATHEMATICAL DOUBLE-STRUCK DIGIT EIGHT
 * 	0038 DIGIT EIGHT
 * 1D7E1 MATHEMATICAL DOUBLE-STRUCK DIGIT NINE
 * 	0039 DIGIT NINE
 * 1D7E2 MATHEMATICAL SANS-SERIF DIGIT ZERO
 * 	0030 DIGIT ZERO
 * 1D7E3 MATHEMATICAL SANS-SERIF DIGIT ONE
 * 	0031 DIGIT ONE
 * 1D7E4 MATHEMATICAL SANS-SERIF DIGIT TWO
 * 	0032 DIGIT TWO
 * 1D7E5 MATHEMATICAL SANS-SERIF DIGIT THREE
 * 	0033 DIGIT THREE
 * 1D7E6 MATHEMATICAL SANS-SERIF DIGIT FOUR
 * 	0034 DIGIT FOUR
 * 1D7E7 MATHEMATICAL SANS-SERIF DIGIT FIVE
 * 	0035 DIGIT FIVE
 * 1D7E8 MATHEMATICAL SANS-SERIF DIGIT SIX
 * 	0036 DIGIT SIX
 * 1D7E9 MATHEMATICAL SANS-SERIF DIGIT SEVEN
 * 	0037 DIGIT SEVEN
 * 1D7EA MATHEMATICAL SANS-SERIF DIGIT EIGHT
 * 	0038 DIGIT EIGHT
 * 1D7EB MATHEMATICAL SANS-SERIF DIGIT NINE
 * 	0039 DIGIT NINE
 * 1D7EC MATHEMATICAL SANS-SERIF BOLD DIGIT ZERO
 * 	0030 DIGIT ZERO
 * 1D7ED MATHEMATICAL SANS-SERIF BOLD DIGIT ONE
 * 	0031 DIGIT ONE
 * 1D7EE MATHEMATICAL SANS-SERIF BOLD DIGIT TWO
 * 	0032 DIGIT TWO
 * 1D7EF MATHEMATICAL SANS-SERIF BOLD DIGIT THREE
 * 	0033 DIGIT THREE
 * 1D7F0 MATHEMATICAL SANS-SERIF BOLD DIGIT FOUR
 * 	0034 DIGIT FOUR
 * 1D7F1 MATHEMATICAL SANS-SERIF BOLD DIGIT FIVE
 * 	0035 DIGIT FIVE
 * 1D7F2 MATHEMATICAL SANS-SERIF BOLD DIGIT SIX
 * 	0036 DIGIT SIX
 * 1D7F3 MATHEMATICAL SANS-SERIF BOLD DIGIT SEVEN
 * 	0037 DIGIT SEVEN
 * 1D7F4 MATHEMATICAL SANS-SERIF BOLD DIGIT EIGHT
 * 	0038 DIGIT EIGHT
 * 1D7F5 MATHEMATICAL SANS-SERIF BOLD DIGIT NINE
 * 	0039 DIGIT NINE
 * 1D7F6 MATHEMATICAL MONOSPACE DIGIT ZERO
 * 	0030 DIGIT ZERO
 * 1D7F7 MATHEMATICAL MONOSPACE DIGIT ONE
 * 	0031 DIGIT ONE
 * 1D7F8 MATHEMATICAL MONOSPACE DIGIT TWO
 * 	0032 DIGIT TWO
 * 1D7F9 MATHEMATICAL MONOSPACE DIGIT THREE
 * 	0033 DIGIT THREE
 * 1D7FA MATHEMATICAL MONOSPACE DIGIT FOUR
 * 	0034 DIGIT FOUR
 * 1D7FB MATHEMATICAL MONOSPACE DIGIT FIVE
 * 	0035 DIGIT FIVE
 * 1D7FC MATHEMATICAL MONOSPACE DIGIT SIX
 * 	0036 DIGIT SIX
 * 1D7FD MATHEMATICAL MONOSPACE DIGIT SEVEN
 * 	0037 DIGIT SEVEN
 * 1D7FE MATHEMATICAL MONOSPACE DIGIT EIGHT
 * 	0038 DIGIT EIGHT
 * 1D7FF MATHEMATICAL MONOSPACE DIGIT NINE
 * 	0039 DIGIT NINE
 * 1E00 LATIN CAPITAL LETTER A WITH RING BELOW
 * 	0041 LATIN CAPITAL LETTER A
 * 1E01 LATIN SMALL LETTER A WITH RING BELOW
 * 	0061 LATIN SMALL LETTER A
 * 1E02 LATIN CAPITAL LETTER B WITH DOT ABOVE
 * 	0042 LATIN CAPITAL LETTER B
 * 1E03 LATIN SMALL LETTER B WITH DOT ABOVE
 * 	0062 LATIN SMALL LETTER B
 * 1E04 LATIN CAPITAL LETTER B WITH DOT BELOW
 * 	0042 LATIN CAPITAL LETTER B
 * 1E05 LATIN SMALL LETTER B WITH DOT BELOW
 * 	0062 LATIN SMALL LETTER B
 * 1E06 LATIN CAPITAL LETTER B WITH LINE BELOW
 * 	0042 LATIN CAPITAL LETTER B
 * 1E07 LATIN SMALL LETTER B WITH LINE BELOW
 * 	0062 LATIN SMALL LETTER B
 * 1E08 LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
 * 	0043 LATIN CAPITAL LETTER C
 * 1E09 LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
 * 	0063 LATIN SMALL LETTER C
 * 1E0A LATIN CAPITAL LETTER D WITH DOT ABOVE
 * 	0044 LATIN CAPITAL LETTER D
 * 1E0B LATIN SMALL LETTER D WITH DOT ABOVE
 * 	0064 LATIN SMALL LETTER D
 * 1E0C LATIN CAPITAL LETTER D WITH DOT BELOW
 * 	0044 LATIN CAPITAL LETTER D
 * 1E0D LATIN SMALL LETTER D WITH DOT BELOW
 * 	0064 LATIN SMALL LETTER D
 * 1E0E LATIN CAPITAL LETTER D WITH LINE BELOW
 * 	0044 LATIN CAPITAL LETTER D
 * 1E0F LATIN SMALL LETTER D WITH LINE BELOW
 * 	0064 LATIN SMALL LETTER D
 * 1E10 LATIN CAPITAL LETTER D WITH CEDILLA
 * 	0044 LATIN CAPITAL LETTER D
 * 1E11 LATIN SMALL LETTER D WITH CEDILLA
 * 	0064 LATIN SMALL LETTER D
 * 1E12 LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
 * 	0044 LATIN CAPITAL LETTER D
 * 1E13 LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
 * 	0064 LATIN SMALL LETTER D
 * 1E14 LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
 * 	0045 LATIN CAPITAL LETTER E
 * 1E15 LATIN SMALL LETTER E WITH MACRON AND GRAVE
 * 	0065 LATIN SMALL LETTER E
 * 1E16 LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
 * 	0045 LATIN CAPITAL LETTER E
 * 1E17 LATIN SMALL LETTER E WITH MACRON AND ACUTE
 * 	0065 LATIN SMALL LETTER E
 * 1E18 LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
 * 	0045 LATIN CAPITAL LETTER E
 * 1E19 LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
 * 	0065 LATIN SMALL LETTER E
 * 1E1A LATIN CAPITAL LETTER E WITH TILDE BELOW
 * 	0045 LATIN CAPITAL LETTER E
 * 1E1B LATIN SMALL LETTER E WITH TILDE BELOW
 * 	0065 LATIN SMALL LETTER E
 * 1E1C LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
 * 	0045 LATIN CAPITAL LETTER E
 * 1E1D LATIN SMALL LETTER E WITH CEDILLA AND BREVE
 * 	0065 LATIN SMALL LETTER E
 * 1E1E LATIN CAPITAL LETTER F WITH DOT ABOVE
 * 	0046 LATIN CAPITAL LETTER F
 * 1E1F LATIN SMALL LETTER F WITH DOT ABOVE
 * 	0066 LATIN SMALL LETTER F
 * 1E20 LATIN CAPITAL LETTER G WITH MACRON
 * 	0047 LATIN CAPITAL LETTER G
 * 1E21 LATIN SMALL LETTER G WITH MACRON
 * 	0067 LATIN SMALL LETTER G
 * 1E22 LATIN CAPITAL LETTER H WITH DOT ABOVE
 * 	0048 LATIN CAPITAL LETTER H
 * 1E23 LATIN SMALL LETTER H WITH DOT ABOVE
 * 	0068 LATIN SMALL LETTER H
 * 1E24 LATIN CAPITAL LETTER H WITH DOT BELOW
 * 	0048 LATIN CAPITAL LETTER H
 * 1E25 LATIN SMALL LETTER H WITH DOT BELOW
 * 	0068 LATIN SMALL LETTER H
 * 1E26 LATIN CAPITAL LETTER H WITH DIAERESIS
 * 	0048 LATIN CAPITAL LETTER H
 * 1E27 LATIN SMALL LETTER H WITH DIAERESIS
 * 	0068 LATIN SMALL LETTER H
 * 1E28 LATIN CAPITAL LETTER H WITH CEDILLA
 * 	0048 LATIN CAPITAL LETTER H
 * 1E29 LATIN SMALL LETTER H WITH CEDILLA
 * 	0068 LATIN SMALL LETTER H
 * 1E2A LATIN CAPITAL LETTER H WITH BREVE BELOW
 * 	0048 LATIN CAPITAL LETTER H
 * 1E2B LATIN SMALL LETTER H WITH BREVE BELOW
 * 	0068 LATIN SMALL LETTER H
 * 1E2C LATIN CAPITAL LETTER I WITH TILDE BELOW
 * 	0049 LATIN CAPITAL LETTER I
 * 1E2D LATIN SMALL LETTER I WITH TILDE BELOW
 * 	0069 LATIN SMALL LETTER I
 * 1E2E LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
 * 	0049 LATIN CAPITAL LETTER I
 * 1E2F LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
 * 	0069 LATIN SMALL LETTER I
 * 1E30 LATIN CAPITAL LETTER K WITH ACUTE
 * 	004B LATIN CAPITAL LETTER K
 * 1E31 LATIN SMALL LETTER K WITH ACUTE
 * 	006B LATIN SMALL LETTER K
 * 1E32 LATIN CAPITAL LETTER K WITH DOT BELOW
 * 	004B LATIN CAPITAL LETTER K
 * 1E33 LATIN SMALL LETTER K WITH DOT BELOW
 * 	006B LATIN SMALL LETTER K
 * 1E34 LATIN CAPITAL LETTER K WITH LINE BELOW
 * 	004B LATIN CAPITAL LETTER K
 * 1E35 LATIN SMALL LETTER K WITH LINE BELOW
 * 	006B LATIN SMALL LETTER K
 * 1E36 LATIN CAPITAL LETTER L WITH DOT BELOW
 * 	004C LATIN CAPITAL LETTER L
 * 1E37 LATIN SMALL LETTER L WITH DOT BELOW
 * 	006C LATIN SMALL LETTER L
 * 1E38 LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
 * 	004C LATIN CAPITAL LETTER L
 * 1E39 LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
 * 	006C LATIN SMALL LETTER L
 * 1E3A LATIN CAPITAL LETTER L WITH LINE BELOW
 * 	004C LATIN CAPITAL LETTER L
 * 1E3B LATIN SMALL LETTER L WITH LINE BELOW
 * 	006C LATIN SMALL LETTER L
 * 1E3C LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
 * 	004C LATIN CAPITAL LETTER L
 * 1E3D LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
 * 	006C LATIN SMALL LETTER L
 * 1E3E LATIN CAPITAL LETTER M WITH ACUTE
 * 	004D LATIN CAPITAL LETTER M
 * 1E3F LATIN SMALL LETTER M WITH ACUTE
 * 	006D LATIN SMALL LETTER M
 * 1E40 LATIN CAPITAL LETTER M WITH DOT ABOVE
 * 	004D LATIN CAPITAL LETTER M
 * 1E41 LATIN SMALL LETTER M WITH DOT ABOVE
 * 	006D LATIN SMALL LETTER M
 * 1E42 LATIN CAPITAL LETTER M WITH DOT BELOW
 * 	004D LATIN CAPITAL LETTER M
 * 1E43 LATIN SMALL LETTER M WITH DOT BELOW
 * 	006D LATIN SMALL LETTER M
 * 1E44 LATIN CAPITAL LETTER N WITH DOT ABOVE
 * 	004E LATIN CAPITAL LETTER N
 * 1E45 LATIN SMALL LETTER N WITH DOT ABOVE
 * 	006E LATIN SMALL LETTER N
 * 1E46 LATIN CAPITAL LETTER N WITH DOT BELOW
 * 	004E LATIN CAPITAL LETTER N
 * 1E47 LATIN SMALL LETTER N WITH DOT BELOW
 * 	006E LATIN SMALL LETTER N
 * 1E48 LATIN CAPITAL LETTER N WITH LINE BELOW
 * 	004E LATIN CAPITAL LETTER N
 * 1E49 LATIN SMALL LETTER N WITH LINE BELOW
 * 	006E LATIN SMALL LETTER N
 * 1E4A LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
 * 	004E LATIN CAPITAL LETTER N
 * 1E4B LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
 * 	006E LATIN SMALL LETTER N
 * 1E4C LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 1E4D LATIN SMALL LETTER O WITH TILDE AND ACUTE
 * 	006F LATIN SMALL LETTER O
 * 1E4E LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
 * 	004F LATIN CAPITAL LETTER O
 * 1E4F LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
 * 	006F LATIN SMALL LETTER O
 * 1E50 LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
 * 	004F LATIN CAPITAL LETTER O
 * 1E51 LATIN SMALL LETTER O WITH MACRON AND GRAVE
 * 	006F LATIN SMALL LETTER O
 * 1E52 LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 1E53 LATIN SMALL LETTER O WITH MACRON AND ACUTE
 * 	006F LATIN SMALL LETTER O
 * 1E54 LATIN CAPITAL LETTER P WITH ACUTE
 * 	0050 LATIN CAPITAL LETTER P
 * 1E55 LATIN SMALL LETTER P WITH ACUTE
 * 	0070 LATIN SMALL LETTER P
 * 1E56 LATIN CAPITAL LETTER P WITH DOT ABOVE
 * 	0050 LATIN CAPITAL LETTER P
 * 1E57 LATIN SMALL LETTER P WITH DOT ABOVE
 * 	0070 LATIN SMALL LETTER P
 * 1E58 LATIN CAPITAL LETTER R WITH DOT ABOVE
 * 	0052 LATIN CAPITAL LETTER R
 * 1E59 LATIN SMALL LETTER R WITH DOT ABOVE
 * 	0072 LATIN SMALL LETTER R
 * 1E5A LATIN CAPITAL LETTER R WITH DOT BELOW
 * 	0052 LATIN CAPITAL LETTER R
 * 1E5B LATIN SMALL LETTER R WITH DOT BELOW
 * 	0072 LATIN SMALL LETTER R
 * 1E5C LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
 * 	0052 LATIN CAPITAL LETTER R
 * 1E5D LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
 * 	0072 LATIN SMALL LETTER R
 * 1E5E LATIN CAPITAL LETTER R WITH LINE BELOW
 * 	0052 LATIN CAPITAL LETTER R
 * 1E5F LATIN SMALL LETTER R WITH LINE BELOW
 * 	0072 LATIN SMALL LETTER R
 * 1E60 LATIN CAPITAL LETTER S WITH DOT ABOVE
 * 	0053 LATIN CAPITAL LETTER S
 * 1E61 LATIN SMALL LETTER S WITH DOT ABOVE
 * 	0073 LATIN SMALL LETTER S
 * 1E62 LATIN CAPITAL LETTER S WITH DOT BELOW
 * 	0053 LATIN CAPITAL LETTER S
 * 1E63 LATIN SMALL LETTER S WITH DOT BELOW
 * 	0073 LATIN SMALL LETTER S
 * 1E64 LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
 * 	0053 LATIN CAPITAL LETTER S
 * 1E65 LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
 * 	0073 LATIN SMALL LETTER S
 * 1E66 LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
 * 	0053 LATIN CAPITAL LETTER S
 * 1E67 LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
 * 	0073 LATIN SMALL LETTER S
 * 1E68 LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
 * 	0053 LATIN CAPITAL LETTER S
 * 1E69 LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
 * 	0073 LATIN SMALL LETTER S
 * 1E6A LATIN CAPITAL LETTER T WITH DOT ABOVE
 * 	0054 LATIN CAPITAL LETTER T
 * 1E6B LATIN SMALL LETTER T WITH DOT ABOVE
 * 	0074 LATIN SMALL LETTER T
 * 1E6C LATIN CAPITAL LETTER T WITH DOT BELOW
 * 	0054 LATIN CAPITAL LETTER T
 * 1E6D LATIN SMALL LETTER T WITH DOT BELOW
 * 	0074 LATIN SMALL LETTER T
 * 1E6E LATIN CAPITAL LETTER T WITH LINE BELOW
 * 	0054 LATIN CAPITAL LETTER T
 * 1E6F LATIN SMALL LETTER T WITH LINE BELOW
 * 	0074 LATIN SMALL LETTER T
 * 1E70 LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
 * 	0054 LATIN CAPITAL LETTER T
 * 1E71 LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
 * 	0074 LATIN SMALL LETTER T
 * 1E72 LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
 * 	0055 LATIN CAPITAL LETTER U
 * 1E73 LATIN SMALL LETTER U WITH DIAERESIS BELOW
 * 	0075 LATIN SMALL LETTER U
 * 1E74 LATIN CAPITAL LETTER U WITH TILDE BELOW
 * 	0055 LATIN CAPITAL LETTER U
 * 1E75 LATIN SMALL LETTER U WITH TILDE BELOW
 * 	0075 LATIN SMALL LETTER U
 * 1E76 LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
 * 	0055 LATIN CAPITAL LETTER U
 * 1E77 LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
 * 	0075 LATIN SMALL LETTER U
 * 1E78 LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
 * 	0055 LATIN CAPITAL LETTER U
 * 1E79 LATIN SMALL LETTER U WITH TILDE AND ACUTE
 * 	0075 LATIN SMALL LETTER U
 * 1E7A LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
 * 	0055 LATIN CAPITAL LETTER U
 * 1E7B LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
 * 	0075 LATIN SMALL LETTER U
 * 1E7C LATIN CAPITAL LETTER V WITH TILDE
 * 	0056 LATIN CAPITAL LETTER V
 * 1E7D LATIN SMALL LETTER V WITH TILDE
 * 	0076 LATIN SMALL LETTER V
 * 1E7E LATIN CAPITAL LETTER V WITH DOT BELOW
 * 	0056 LATIN CAPITAL LETTER V
 * 1E7F LATIN SMALL LETTER V WITH DOT BELOW
 * 	0076 LATIN SMALL LETTER V
 * 1E80 LATIN CAPITAL LETTER W WITH GRAVE
 * 	0057 LATIN CAPITAL LETTER W
 * 1E81 LATIN SMALL LETTER W WITH GRAVE
 * 	0077 LATIN SMALL LETTER W
 * 1E82 LATIN CAPITAL LETTER W WITH ACUTE
 * 	0057 LATIN CAPITAL LETTER W
 * 1E83 LATIN SMALL LETTER W WITH ACUTE
 * 	0077 LATIN SMALL LETTER W
 * 1E84 LATIN CAPITAL LETTER W WITH DIAERESIS
 * 	0057 LATIN CAPITAL LETTER W
 * 1E85 LATIN SMALL LETTER W WITH DIAERESIS
 * 	0077 LATIN SMALL LETTER W
 * 1E86 LATIN CAPITAL LETTER W WITH DOT ABOVE
 * 	0057 LATIN CAPITAL LETTER W
 * 1E87 LATIN SMALL LETTER W WITH DOT ABOVE
 * 	0077 LATIN SMALL LETTER W
 * 1E88 LATIN CAPITAL LETTER W WITH DOT BELOW
 * 	0057 LATIN CAPITAL LETTER W
 * 1E89 LATIN SMALL LETTER W WITH DOT BELOW
 * 	0077 LATIN SMALL LETTER W
 * 1E8A LATIN CAPITAL LETTER X WITH DOT ABOVE
 * 	0058 LATIN CAPITAL LETTER X
 * 1E8B LATIN SMALL LETTER X WITH DOT ABOVE
 * 	0078 LATIN SMALL LETTER X
 * 1E8C LATIN CAPITAL LETTER X WITH DIAERESIS
 * 	0058 LATIN CAPITAL LETTER X
 * 1E8D LATIN SMALL LETTER X WITH DIAERESIS
 * 	0078 LATIN SMALL LETTER X
 * 1E8E LATIN CAPITAL LETTER Y WITH DOT ABOVE
 * 	0059 LATIN CAPITAL LETTER Y
 * 1E8F LATIN SMALL LETTER Y WITH DOT ABOVE
 * 	0079 LATIN SMALL LETTER Y
 * 1E90 LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
 * 	005A LATIN CAPITAL LETTER Z
 * 1E91 LATIN SMALL LETTER Z WITH CIRCUMFLEX
 * 	007A LATIN SMALL LETTER Z
 * 1E92 LATIN CAPITAL LETTER Z WITH DOT BELOW
 * 	005A LATIN CAPITAL LETTER Z
 * 1E93 LATIN SMALL LETTER Z WITH DOT BELOW
 * 	007A LATIN SMALL LETTER Z
 * 1E94 LATIN CAPITAL LETTER Z WITH LINE BELOW
 * 	005A LATIN CAPITAL LETTER Z
 * 1E95 LATIN SMALL LETTER Z WITH LINE BELOW
 * 	007A LATIN SMALL LETTER Z
 * 1E96 LATIN SMALL LETTER H WITH LINE BELOW
 * 	0068 LATIN SMALL LETTER H
 * 1E97 LATIN SMALL LETTER T WITH DIAERESIS
 * 	0074 LATIN SMALL LETTER T
 * 1E98 LATIN SMALL LETTER W WITH RING ABOVE
 * 	0077 LATIN SMALL LETTER W
 * 1E99 LATIN SMALL LETTER Y WITH RING ABOVE
 * 	0079 LATIN SMALL LETTER Y
 * 1E9A LATIN SMALL LETTER A WITH RIGHT HALF RING
 * 	0061 LATIN SMALL LETTER A
 * 	02BE MODIFIER LETTER RIGHT HALF RING
 * 1E9B LATIN SMALL LETTER LONG S WITH DOT ABOVE
 * 	0073 LATIN SMALL LETTER S
 * 1EA0 LATIN CAPITAL LETTER A WITH DOT BELOW
 * 	0041 LATIN CAPITAL LETTER A
 * 1EA1 LATIN SMALL LETTER A WITH DOT BELOW
 * 	0061 LATIN SMALL LETTER A
 * 1EA2 LATIN CAPITAL LETTER A WITH HOOK ABOVE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EA3 LATIN SMALL LETTER A WITH HOOK ABOVE
 * 	0061 LATIN SMALL LETTER A
 * 1EA4 LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EA5 LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
 * 	0061 LATIN SMALL LETTER A
 * 1EA6 LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EA7 LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
 * 	0061 LATIN SMALL LETTER A
 * 1EA8 LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EA9 LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
 * 	0061 LATIN SMALL LETTER A
 * 1EAA LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EAB LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
 * 	0061 LATIN SMALL LETTER A
 * 1EAC LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
 * 	0041 LATIN CAPITAL LETTER A
 * 1EAD LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
 * 	0061 LATIN SMALL LETTER A
 * 1EAE LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EAF LATIN SMALL LETTER A WITH BREVE AND ACUTE
 * 	0061 LATIN SMALL LETTER A
 * 1EB0 LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EB1 LATIN SMALL LETTER A WITH BREVE AND GRAVE
 * 	0061 LATIN SMALL LETTER A
 * 1EB2 LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EB3 LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
 * 	0061 LATIN SMALL LETTER A
 * 1EB4 LATIN CAPITAL LETTER A WITH BREVE AND TILDE
 * 	0041 LATIN CAPITAL LETTER A
 * 1EB5 LATIN SMALL LETTER A WITH BREVE AND TILDE
 * 	0061 LATIN SMALL LETTER A
 * 1EB6 LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
 * 	0041 LATIN CAPITAL LETTER A
 * 1EB7 LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
 * 	0061 LATIN SMALL LETTER A
 * 1EB8 LATIN CAPITAL LETTER E WITH DOT BELOW
 * 	0045 LATIN CAPITAL LETTER E
 * 1EB9 LATIN SMALL LETTER E WITH DOT BELOW
 * 	0065 LATIN SMALL LETTER E
 * 1EBA LATIN CAPITAL LETTER E WITH HOOK ABOVE
 * 	0045 LATIN CAPITAL LETTER E
 * 1EBB LATIN SMALL LETTER E WITH HOOK ABOVE
 * 	0065 LATIN SMALL LETTER E
 * 1EBC LATIN CAPITAL LETTER E WITH TILDE
 * 	0045 LATIN CAPITAL LETTER E
 * 1EBD LATIN SMALL LETTER E WITH TILDE
 * 	0065 LATIN SMALL LETTER E
 * 1EBE LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
 * 	0045 LATIN CAPITAL LETTER E
 * 1EBF LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
 * 	0065 LATIN SMALL LETTER E
 * 1EC0 LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
 * 	0045 LATIN CAPITAL LETTER E
 * 1EC1 LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
 * 	0065 LATIN SMALL LETTER E
 * 1EC2 LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
 * 	0045 LATIN CAPITAL LETTER E
 * 1EC3 LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
 * 	0065 LATIN SMALL LETTER E
 * 1EC4 LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
 * 	0045 LATIN CAPITAL LETTER E
 * 1EC5 LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
 * 	0065 LATIN SMALL LETTER E
 * 1EC6 LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
 * 	0045 LATIN CAPITAL LETTER E
 * 1EC7 LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
 * 	0065 LATIN SMALL LETTER E
 * 1EC8 LATIN CAPITAL LETTER I WITH HOOK ABOVE
 * 	0049 LATIN CAPITAL LETTER I
 * 1EC9 LATIN SMALL LETTER I WITH HOOK ABOVE
 * 	0069 LATIN SMALL LETTER I
 * 1ECA LATIN CAPITAL LETTER I WITH DOT BELOW
 * 	0049 LATIN CAPITAL LETTER I
 * 1ECB LATIN SMALL LETTER I WITH DOT BELOW
 * 	0069 LATIN SMALL LETTER I
 * 1ECC LATIN CAPITAL LETTER O WITH DOT BELOW
 * 	004F LATIN CAPITAL LETTER O
 * 1ECD LATIN SMALL LETTER O WITH DOT BELOW
 * 	006F LATIN SMALL LETTER O
 * 1ECE LATIN CAPITAL LETTER O WITH HOOK ABOVE
 * 	004F LATIN CAPITAL LETTER O
 * 1ECF LATIN SMALL LETTER O WITH HOOK ABOVE
 * 	006F LATIN SMALL LETTER O
 * 1ED0 LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 1ED1 LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
 * 	006F LATIN SMALL LETTER O
 * 1ED2 LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
 * 	004F LATIN CAPITAL LETTER O
 * 1ED3 LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
 * 	006F LATIN SMALL LETTER O
 * 1ED4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
 * 	004F LATIN CAPITAL LETTER O
 * 1ED5 LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
 * 	006F LATIN SMALL LETTER O
 * 1ED6 LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
 * 	004F LATIN CAPITAL LETTER O
 * 1ED7 LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
 * 	006F LATIN SMALL LETTER O
 * 1ED8 LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
 * 	004F LATIN CAPITAL LETTER O
 * 1ED9 LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
 * 	006F LATIN SMALL LETTER O
 * 1EDA LATIN CAPITAL LETTER O WITH HORN AND ACUTE
 * 	004F LATIN CAPITAL LETTER O
 * 1EDB LATIN SMALL LETTER O WITH HORN AND ACUTE
 * 	006F LATIN SMALL LETTER O
 * 1EDC LATIN CAPITAL LETTER O WITH HORN AND GRAVE
 * 	004F LATIN CAPITAL LETTER O
 * 1EDD LATIN SMALL LETTER O WITH HORN AND GRAVE
 * 	006F LATIN SMALL LETTER O
 * 1EDE LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
 * 	004F LATIN CAPITAL LETTER O
 * 1EDF LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
 * 	006F LATIN SMALL LETTER O
 * 1EE0 LATIN CAPITAL LETTER O WITH HORN AND TILDE
 * 	004F LATIN CAPITAL LETTER O
 * 1EE1 LATIN SMALL LETTER O WITH HORN AND TILDE
 * 	006F LATIN SMALL LETTER O
 * 1EE2 LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
 * 	004F LATIN CAPITAL LETTER O
 * 1EE3 LATIN SMALL LETTER O WITH HORN AND DOT BELOW
 * 	006F LATIN SMALL LETTER O
 * 1EE4 LATIN CAPITAL LETTER U WITH DOT BELOW
 * 	0055 LATIN CAPITAL LETTER U
 * 1EE5 LATIN SMALL LETTER U WITH DOT BELOW
 * 	0075 LATIN SMALL LETTER U
 * 1EE6 LATIN CAPITAL LETTER U WITH HOOK ABOVE
 * 	0055 LATIN CAPITAL LETTER U
 * 1EE7 LATIN SMALL LETTER U WITH HOOK ABOVE
 * 	0075 LATIN SMALL LETTER U
 * 1EE8 LATIN CAPITAL LETTER U WITH HORN AND ACUTE
 * 	0055 LATIN CAPITAL LETTER U
 * 1EE9 LATIN SMALL LETTER U WITH HORN AND ACUTE
 * 	0075 LATIN SMALL LETTER U
 * 1EEA LATIN CAPITAL LETTER U WITH HORN AND GRAVE
 * 	0055 LATIN CAPITAL LETTER U
 * 1EEB LATIN SMALL LETTER U WITH HORN AND GRAVE
 * 	0075 LATIN SMALL LETTER U
 * 1EEC LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
 * 	0055 LATIN CAPITAL LETTER U
 * 1EED LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
 * 	0075 LATIN SMALL LETTER U
 * 1EEE LATIN CAPITAL LETTER U WITH HORN AND TILDE
 * 	0055 LATIN CAPITAL LETTER U
 * 1EEF LATIN SMALL LETTER U WITH HORN AND TILDE
 * 	0075 LATIN SMALL LETTER U
 * 1EF0 LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
 * 	0055 LATIN CAPITAL LETTER U
 * 1EF1 LATIN SMALL LETTER U WITH HORN AND DOT BELOW
 * 	0075 LATIN SMALL LETTER U
 * 1EF2 LATIN CAPITAL LETTER Y WITH GRAVE
 * 	0059 LATIN CAPITAL LETTER Y
 * 1EF3 LATIN SMALL LETTER Y WITH GRAVE
 * 	0079 LATIN SMALL LETTER Y
 * 1EF4 LATIN CAPITAL LETTER Y WITH DOT BELOW
 * 	0059 LATIN CAPITAL LETTER Y
 * 1EF5 LATIN SMALL LETTER Y WITH DOT BELOW
 * 	0079 LATIN SMALL LETTER Y
 * 1EF6 LATIN CAPITAL LETTER Y WITH HOOK ABOVE
 * 	0059 LATIN CAPITAL LETTER Y
 * 1EF7 LATIN SMALL LETTER Y WITH HOOK ABOVE
 * 	0079 LATIN SMALL LETTER Y
 * 1EF8 LATIN CAPITAL LETTER Y WITH TILDE
 * 	0059 LATIN CAPITAL LETTER Y
 * 1EF9 LATIN SMALL LETTER Y WITH TILDE
 * 	0079 LATIN SMALL LETTER Y
 * 1F00 GREEK SMALL LETTER ALPHA WITH PSILI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F01 GREEK SMALL LETTER ALPHA WITH DASIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F02 GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F03 GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F04 GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F05 GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F06 GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F07 GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F08 GREEK CAPITAL LETTER ALPHA WITH PSILI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F09 GREEK CAPITAL LETTER ALPHA WITH DASIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F0A GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F0B GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F0C GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F0D GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F0E GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F0F GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F10 GREEK SMALL LETTER EPSILON WITH PSILI
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F11 GREEK SMALL LETTER EPSILON WITH DASIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F12 GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F13 GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F14 GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F15 GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F18 GREEK CAPITAL LETTER EPSILON WITH PSILI
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1F19 GREEK CAPITAL LETTER EPSILON WITH DASIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1F1A GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1F1B GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1F1C GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1F1D GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1F20 GREEK SMALL LETTER ETA WITH PSILI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F21 GREEK SMALL LETTER ETA WITH DASIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F22 GREEK SMALL LETTER ETA WITH PSILI AND VARIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F23 GREEK SMALL LETTER ETA WITH DASIA AND VARIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F24 GREEK SMALL LETTER ETA WITH PSILI AND OXIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F25 GREEK SMALL LETTER ETA WITH DASIA AND OXIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F26 GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F27 GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F28 GREEK CAPITAL LETTER ETA WITH PSILI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F29 GREEK CAPITAL LETTER ETA WITH DASIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F2A GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F2B GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F2C GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F2D GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F2E GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F2F GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F30 GREEK SMALL LETTER IOTA WITH PSILI
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F31 GREEK SMALL LETTER IOTA WITH DASIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F32 GREEK SMALL LETTER IOTA WITH PSILI AND VARIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F33 GREEK SMALL LETTER IOTA WITH DASIA AND VARIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F34 GREEK SMALL LETTER IOTA WITH PSILI AND OXIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F35 GREEK SMALL LETTER IOTA WITH DASIA AND OXIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F36 GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F37 GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F38 GREEK CAPITAL LETTER IOTA WITH PSILI
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F39 GREEK CAPITAL LETTER IOTA WITH DASIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F3A GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F3B GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F3C GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F3D GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F3E GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F3F GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1F40 GREEK SMALL LETTER OMICRON WITH PSILI
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F41 GREEK SMALL LETTER OMICRON WITH DASIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F42 GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F43 GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F44 GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F45 GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F48 GREEK CAPITAL LETTER OMICRON WITH PSILI
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1F49 GREEK CAPITAL LETTER OMICRON WITH DASIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1F4A GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1F4B GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1F4C GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1F4D GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1F50 GREEK SMALL LETTER UPSILON WITH PSILI
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F51 GREEK SMALL LETTER UPSILON WITH DASIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F52 GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F53 GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F54 GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F55 GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F56 GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F57 GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F59 GREEK CAPITAL LETTER UPSILON WITH DASIA
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1F5B GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1F5D GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1F5F GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1F60 GREEK SMALL LETTER OMEGA WITH PSILI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F61 GREEK SMALL LETTER OMEGA WITH DASIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F62 GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F63 GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F64 GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F65 GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F66 GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F67 GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F68 GREEK CAPITAL LETTER OMEGA WITH PSILI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F69 GREEK CAPITAL LETTER OMEGA WITH DASIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F6A GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F6B GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F6C GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F6D GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F6E GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F6F GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1F70 GREEK SMALL LETTER ALPHA WITH VARIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F71 GREEK SMALL LETTER ALPHA WITH OXIA
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F72 GREEK SMALL LETTER EPSILON WITH VARIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F73 GREEK SMALL LETTER EPSILON WITH OXIA
 * 	03B5 GREEK SMALL LETTER EPSILON
 * 1F74 GREEK SMALL LETTER ETA WITH VARIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F75 GREEK SMALL LETTER ETA WITH OXIA
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F76 GREEK SMALL LETTER IOTA WITH VARIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F77 GREEK SMALL LETTER IOTA WITH OXIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1F78 GREEK SMALL LETTER OMICRON WITH VARIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F79 GREEK SMALL LETTER OMICRON WITH OXIA
 * 	03BF GREEK SMALL LETTER OMICRON
 * 1F7A GREEK SMALL LETTER UPSILON WITH VARIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F7B GREEK SMALL LETTER UPSILON WITH OXIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1F7C GREEK SMALL LETTER OMEGA WITH VARIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F7D GREEK SMALL LETTER OMEGA WITH OXIA
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1F80 GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F81 GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F82 GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F83 GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F84 GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F85 GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F86 GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F87 GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1F88 GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F89 GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F8A GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F8B GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F8C GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F8D GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F8E GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F8F GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1F90 GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F91 GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F92 GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F93 GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F94 GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F95 GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F96 GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F97 GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1F98 GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F99 GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F9A GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F9B GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F9C GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F9D GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F9E GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1F9F GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1FA0 GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA1 GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA2 GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA3 GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA4 GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA5 GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA6 GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA7 GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FA8 GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FA9 GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FAA GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FAB GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FAC GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FAD GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FAE GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FAF GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FB0 GREEK SMALL LETTER ALPHA WITH VRACHY
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB1 GREEK SMALL LETTER ALPHA WITH MACRON
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB2 GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB3 GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB4 GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB6 GREEK SMALL LETTER ALPHA WITH PERISPOMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB7 GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
 * 	03B1 GREEK SMALL LETTER ALPHA
 * 1FB8 GREEK CAPITAL LETTER ALPHA WITH VRACHY
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1FB9 GREEK CAPITAL LETTER ALPHA WITH MACRON
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1FBA GREEK CAPITAL LETTER ALPHA WITH VARIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1FBB GREEK CAPITAL LETTER ALPHA WITH OXIA
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1FBC GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
 * 	0391 GREEK CAPITAL LETTER ALPHA
 * 1FBD GREEK KORONIS
 * 	0020 SPACE
 * 1FBE GREEK PROSGEGRAMMENI
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FBF GREEK PSILI
 * 	0020 SPACE
 * 1FC0 GREEK PERISPOMENI
 * 	0020 SPACE
 * 1FC1 GREEK DIALYTIKA AND PERISPOMENI
 * 	0020 SPACE
 * 1FC2 GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1FC3 GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1FC4 GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1FC6 GREEK SMALL LETTER ETA WITH PERISPOMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1FC7 GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
 * 	03B7 GREEK SMALL LETTER ETA
 * 1FC8 GREEK CAPITAL LETTER EPSILON WITH VARIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1FC9 GREEK CAPITAL LETTER EPSILON WITH OXIA
 * 	0395 GREEK CAPITAL LETTER EPSILON
 * 1FCA GREEK CAPITAL LETTER ETA WITH VARIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1FCB GREEK CAPITAL LETTER ETA WITH OXIA
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1FCC GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
 * 	0397 GREEK CAPITAL LETTER ETA
 * 1FCD GREEK PSILI AND VARIA
 * 	0020 SPACE
 * 1FCE GREEK PSILI AND OXIA
 * 	0020 SPACE
 * 1FCF GREEK PSILI AND PERISPOMENI
 * 	0020 SPACE
 * 1FD0 GREEK SMALL LETTER IOTA WITH VRACHY
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FD1 GREEK SMALL LETTER IOTA WITH MACRON
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FD2 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FD3 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FD6 GREEK SMALL LETTER IOTA WITH PERISPOMENI
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FD7 GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
 * 	03B9 GREEK SMALL LETTER IOTA
 * 1FD8 GREEK CAPITAL LETTER IOTA WITH VRACHY
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1FD9 GREEK CAPITAL LETTER IOTA WITH MACRON
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1FDA GREEK CAPITAL LETTER IOTA WITH VARIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1FDB GREEK CAPITAL LETTER IOTA WITH OXIA
 * 	0399 GREEK CAPITAL LETTER IOTA
 * 1FDD GREEK DASIA AND VARIA
 * 	0020 SPACE
 * 1FDE GREEK DASIA AND OXIA
 * 	0020 SPACE
 * 1FDF GREEK DASIA AND PERISPOMENI
 * 	0020 SPACE
 * 1FE0 GREEK SMALL LETTER UPSILON WITH VRACHY
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1FE1 GREEK SMALL LETTER UPSILON WITH MACRON
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1FE2 GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1FE3 GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1FE4 GREEK SMALL LETTER RHO WITH PSILI
 * 	03C1 GREEK SMALL LETTER RHO
 * 1FE5 GREEK SMALL LETTER RHO WITH DASIA
 * 	03C1 GREEK SMALL LETTER RHO
 * 1FE6 GREEK SMALL LETTER UPSILON WITH PERISPOMENI
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1FE7 GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
 * 	03C5 GREEK SMALL LETTER UPSILON
 * 1FE8 GREEK CAPITAL LETTER UPSILON WITH VRACHY
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1FE9 GREEK CAPITAL LETTER UPSILON WITH MACRON
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1FEA GREEK CAPITAL LETTER UPSILON WITH VARIA
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1FEB GREEK CAPITAL LETTER UPSILON WITH OXIA
 * 	03A5 GREEK CAPITAL LETTER UPSILON
 * 1FEC GREEK CAPITAL LETTER RHO WITH DASIA
 * 	03A1 GREEK CAPITAL LETTER RHO
 * 1FED GREEK DIALYTIKA AND VARIA
 * 	0020 SPACE
 * 1FEE GREEK DIALYTIKA AND OXIA
 * 	0020 SPACE
 * 1FEF GREEK VARIA
 * 	0060 GRAVE ACCENT
 * 1FF2 GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FF3 GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FF4 GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FF6 GREEK SMALL LETTER OMEGA WITH PERISPOMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FF7 GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
 * 	03C9 GREEK SMALL LETTER OMEGA
 * 1FF8 GREEK CAPITAL LETTER OMICRON WITH VARIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1FF9 GREEK CAPITAL LETTER OMICRON WITH OXIA
 * 	039F GREEK CAPITAL LETTER OMICRON
 * 1FFA GREEK CAPITAL LETTER OMEGA WITH VARIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FFB GREEK CAPITAL LETTER OMEGA WITH OXIA
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FFC GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 1FFD GREEK OXIA
 * 	0020 SPACE
 * 1FFE GREEK DASIA
 * 	0020 SPACE
 * 2000 EN QUAD
 * 	0020 SPACE
 * 2001 EM QUAD
 * 	0020 SPACE
 * 2002 EN SPACE
 * 	0020 SPACE
 * 2003 EM SPACE
 * 	0020 SPACE
 * 2004 THREE-PER-EM SPACE
 * 	0020 SPACE
 * 2005 FOUR-PER-EM SPACE
 * 	0020 SPACE
 * 2006 SIX-PER-EM SPACE
 * 	0020 SPACE
 * 2007 FIGURE SPACE
 * 	0020 SPACE
 * 2008 PUNCTUATION SPACE
 * 	0020 SPACE
 * 2009 THIN SPACE
 * 	0020 SPACE
 * 200A HAIR SPACE
 * 	0020 SPACE
 * 2011 NON-BREAKING HYPHEN
 * 	2010 HYPHEN
 * 2017 DOUBLE LOW LINE
 * 	0020 SPACE
 * 2024 ONE DOT LEADER
 * 	002E FULL STOP
 * 2025 TWO DOT LEADER
 * 	002E FULL STOP
 * 	002E FULL STOP
 * 2026 HORIZONTAL ELLIPSIS
 * 	002E FULL STOP
 * 	002E FULL STOP
 * 	002E FULL STOP
 * 202F NARROW NO-BREAK SPACE
 * 	0020 SPACE
 * 2033 DOUBLE PRIME
 * 	2032 PRIME
 * 	2032 PRIME
 * 2034 TRIPLE PRIME
 * 	2032 PRIME
 * 	2032 PRIME
 * 	2032 PRIME
 * 2036 REVERSED DOUBLE PRIME
 * 	2035 REVERSED PRIME
 * 	2035 REVERSED PRIME
 * 2037 REVERSED TRIPLE PRIME
 * 	2035 REVERSED PRIME
 * 	2035 REVERSED PRIME
 * 	2035 REVERSED PRIME
 * 203C DOUBLE EXCLAMATION MARK
 * 	0021 EXCLAMATION MARK
 * 	0021 EXCLAMATION MARK
 * 203E OVERLINE
 * 	0020 SPACE
 * 2047 DOUBLE QUESTION MARK
 * 	003F QUESTION MARK
 * 	003F QUESTION MARK
 * 2048 QUESTION EXCLAMATION MARK
 * 	003F QUESTION MARK
 * 	0021 EXCLAMATION MARK
 * 2049 EXCLAMATION QUESTION MARK
 * 	0021 EXCLAMATION MARK
 * 	003F QUESTION MARK
 * 2057 QUADRUPLE PRIME
 * 	2032 PRIME
 * 	2032 PRIME
 * 	2032 PRIME
 * 	2032 PRIME
 * 205F MEDIUM MATHEMATICAL SPACE
 * 	0020 SPACE
 * 2070 SUPERSCRIPT ZERO
 * 	0030 DIGIT ZERO
 * 2071 SUPERSCRIPT LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 2074 SUPERSCRIPT FOUR
 * 	0034 DIGIT FOUR
 * 2075 SUPERSCRIPT FIVE
 * 	0035 DIGIT FIVE
 * 2076 SUPERSCRIPT SIX
 * 	0036 DIGIT SIX
 * 2077 SUPERSCRIPT SEVEN
 * 	0037 DIGIT SEVEN
 * 2078 SUPERSCRIPT EIGHT
 * 	0038 DIGIT EIGHT
 * 2079 SUPERSCRIPT NINE
 * 	0039 DIGIT NINE
 * 207A SUPERSCRIPT PLUS SIGN
 * 	002B PLUS SIGN
 * 207B SUPERSCRIPT MINUS
 * 	2212 MINUS SIGN
 * 207C SUPERSCRIPT EQUALS SIGN
 * 	003D EQUALS SIGN
 * 207D SUPERSCRIPT LEFT PARENTHESIS
 * 	0028 LEFT PARENTHESIS
 * 207E SUPERSCRIPT RIGHT PARENTHESIS
 * 	0029 RIGHT PARENTHESIS
 * 207F SUPERSCRIPT LATIN SMALL LETTER N
 * 	006E LATIN SMALL LETTER N
 * 2080 SUBSCRIPT ZERO
 * 	0030 DIGIT ZERO
 * 2081 SUBSCRIPT ONE
 * 	0031 DIGIT ONE
 * 2082 SUBSCRIPT TWO
 * 	0032 DIGIT TWO
 * 2083 SUBSCRIPT THREE
 * 	0033 DIGIT THREE
 * 2084 SUBSCRIPT FOUR
 * 	0034 DIGIT FOUR
 * 2085 SUBSCRIPT FIVE
 * 	0035 DIGIT FIVE
 * 2086 SUBSCRIPT SIX
 * 	0036 DIGIT SIX
 * 2087 SUBSCRIPT SEVEN
 * 	0037 DIGIT SEVEN
 * 2088 SUBSCRIPT EIGHT
 * 	0038 DIGIT EIGHT
 * 2089 SUBSCRIPT NINE
 * 	0039 DIGIT NINE
 * 208A SUBSCRIPT PLUS SIGN
 * 	002B PLUS SIGN
 * 208B SUBSCRIPT MINUS
 * 	2212 MINUS SIGN
 * 208C SUBSCRIPT EQUALS SIGN
 * 	003D EQUALS SIGN
 * 208D SUBSCRIPT LEFT PARENTHESIS
 * 	0028 LEFT PARENTHESIS
 * 208E SUBSCRIPT RIGHT PARENTHESIS
 * 	0029 RIGHT PARENTHESIS
 * 20A8 RUPEE SIGN
 * 	0052 LATIN CAPITAL LETTER R
 * 	0073 LATIN SMALL LETTER S
 * 2100 ACCOUNT OF
 * 	0061 LATIN SMALL LETTER A
 * 	002F SOLIDUS
 * 	0063 LATIN SMALL LETTER C
 * 2101 ADDRESSED TO THE SUBJECT
 * 	0061 LATIN SMALL LETTER A
 * 	002F SOLIDUS
 * 	0073 LATIN SMALL LETTER S
 * 2102 DOUBLE-STRUCK CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 2103 DEGREE CELSIUS
 * 	00B0 DEGREE SIGN
 * 	0043 LATIN CAPITAL LETTER C
 * 2105 CARE OF
 * 	0063 LATIN SMALL LETTER C
 * 	002F SOLIDUS
 * 	006F LATIN SMALL LETTER O
 * 2106 CADA UNA
 * 	0063 LATIN SMALL LETTER C
 * 	002F SOLIDUS
 * 	0075 LATIN SMALL LETTER U
 * 2107 EULER CONSTANT
 * 	0190 LATIN CAPITAL LETTER OPEN E
 * 2109 DEGREE FAHRENHEIT
 * 	00B0 DEGREE SIGN
 * 	0046 LATIN CAPITAL LETTER F
 * 210A SCRIPT SMALL G
 * 	0067 LATIN SMALL LETTER G
 * 210B SCRIPT CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 210C BLACK-LETTER CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 210D DOUBLE-STRUCK CAPITAL H
 * 	0048 LATIN CAPITAL LETTER H
 * 210E PLANCK CONSTANT
 * 	0068 LATIN SMALL LETTER H
 * 210F PLANCK CONSTANT OVER TWO PI
 * 	0127 LATIN SMALL LETTER H WITH STROKE
 * 2110 SCRIPT CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 2111 BLACK-LETTER CAPITAL I
 * 	0049 LATIN CAPITAL LETTER I
 * 2112 SCRIPT CAPITAL L
 * 	004C LATIN CAPITAL LETTER L
 * 2113 SCRIPT SMALL L
 * 	006C LATIN SMALL LETTER L
 * 2115 DOUBLE-STRUCK CAPITAL N
 * 	004E LATIN CAPITAL LETTER N
 * 2116 NUMERO SIGN
 * 	004E LATIN CAPITAL LETTER N
 * 	006F LATIN SMALL LETTER O
 * 2119 DOUBLE-STRUCK CAPITAL P
 * 	0050 LATIN CAPITAL LETTER P
 * 211A DOUBLE-STRUCK CAPITAL Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 211B SCRIPT CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 211C BLACK-LETTER CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 211D DOUBLE-STRUCK CAPITAL R
 * 	0052 LATIN CAPITAL LETTER R
 * 2120 SERVICE MARK
 * 	0053 LATIN CAPITAL LETTER S
 * 	004D LATIN CAPITAL LETTER M
 * 2121 TELEPHONE SIGN
 * 	0054 LATIN CAPITAL LETTER T
 * 	0045 LATIN CAPITAL LETTER E
 * 	004C LATIN CAPITAL LETTER L
 * 2122 TRADE MARK SIGN
 * 	0054 LATIN CAPITAL LETTER T
 * 	004D LATIN CAPITAL LETTER M
 * 2124 DOUBLE-STRUCK CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 2126 OHM SIGN
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 2128 BLACK-LETTER CAPITAL Z
 * 	005A LATIN CAPITAL LETTER Z
 * 212A KELVIN SIGN
 * 	004B LATIN CAPITAL LETTER K
 * 212B ANGSTROM SIGN
 * 	0041 LATIN CAPITAL LETTER A
 * 212C SCRIPT CAPITAL B
 * 	0042 LATIN CAPITAL LETTER B
 * 212D BLACK-LETTER CAPITAL C
 * 	0043 LATIN CAPITAL LETTER C
 * 212F SCRIPT SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 2130 SCRIPT CAPITAL E
 * 	0045 LATIN CAPITAL LETTER E
 * 2131 SCRIPT CAPITAL F
 * 	0046 LATIN CAPITAL LETTER F
 * 2133 SCRIPT CAPITAL M
 * 	004D LATIN CAPITAL LETTER M
 * 2134 SCRIPT SMALL O
 * 	006F LATIN SMALL LETTER O
 * 2135 ALEF SYMBOL
 * 	05D0 HEBREW LETTER ALEF
 * 2136 BET SYMBOL
 * 	05D1 HEBREW LETTER BET
 * 2137 GIMEL SYMBOL
 * 	05D2 HEBREW LETTER GIMEL
 * 2138 DALET SYMBOL
 * 	05D3 HEBREW LETTER DALET
 * 2139 INFORMATION SOURCE
 * 	0069 LATIN SMALL LETTER I
 * 213D DOUBLE-STRUCK SMALL GAMMA
 * 	03B3 GREEK SMALL LETTER GAMMA
 * 213E DOUBLE-STRUCK CAPITAL GAMMA
 * 	0393 GREEK CAPITAL LETTER GAMMA
 * 213F DOUBLE-STRUCK CAPITAL PI
 * 	03A0 GREEK CAPITAL LETTER PI
 * 2140 DOUBLE-STRUCK N-ARY SUMMATION
 * 	2211 N-ARY SUMMATION
 * 2145 DOUBLE-STRUCK ITALIC CAPITAL D
 * 	0044 LATIN CAPITAL LETTER D
 * 2146 DOUBLE-STRUCK ITALIC SMALL D
 * 	0064 LATIN SMALL LETTER D
 * 2147 DOUBLE-STRUCK ITALIC SMALL E
 * 	0065 LATIN SMALL LETTER E
 * 2148 DOUBLE-STRUCK ITALIC SMALL I
 * 	0069 LATIN SMALL LETTER I
 * 2149 DOUBLE-STRUCK ITALIC SMALL J
 * 	006A LATIN SMALL LETTER J
 * 2153 VULGAR FRACTION ONE THIRD
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 	0033 DIGIT THREE
 * 2154 VULGAR FRACTION TWO THIRDS
 * 	0032 DIGIT TWO
 * 	2044 FRACTION SLASH
 * 	0033 DIGIT THREE
 * 2155 VULGAR FRACTION ONE FIFTH
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 	0035 DIGIT FIVE
 * 2156 VULGAR FRACTION TWO FIFTHS
 * 	0032 DIGIT TWO
 * 	2044 FRACTION SLASH
 * 	0035 DIGIT FIVE
 * 2157 VULGAR FRACTION THREE FIFTHS
 * 	0033 DIGIT THREE
 * 	2044 FRACTION SLASH
 * 	0035 DIGIT FIVE
 * 2158 VULGAR FRACTION FOUR FIFTHS
 * 	0034 DIGIT FOUR
 * 	2044 FRACTION SLASH
 * 	0035 DIGIT FIVE
 * 2159 VULGAR FRACTION ONE SIXTH
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 	0036 DIGIT SIX
 * 215A VULGAR FRACTION FIVE SIXTHS
 * 	0035 DIGIT FIVE
 * 	2044 FRACTION SLASH
 * 	0036 DIGIT SIX
 * 215B VULGAR FRACTION ONE EIGHTH
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 	0038 DIGIT EIGHT
 * 215C VULGAR FRACTION THREE EIGHTHS
 * 	0033 DIGIT THREE
 * 	2044 FRACTION SLASH
 * 	0038 DIGIT EIGHT
 * 215D VULGAR FRACTION FIVE EIGHTHS
 * 	0035 DIGIT FIVE
 * 	2044 FRACTION SLASH
 * 	0038 DIGIT EIGHT
 * 215E VULGAR FRACTION SEVEN EIGHTHS
 * 	0037 DIGIT SEVEN
 * 	2044 FRACTION SLASH
 * 	0038 DIGIT EIGHT
 * 215F FRACTION NUMERATOR ONE
 * 	0031 DIGIT ONE
 * 	2044 FRACTION SLASH
 * 2160 ROMAN NUMERAL ONE
 * 	0049 LATIN CAPITAL LETTER I
 * 2161 ROMAN NUMERAL TWO
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 2162 ROMAN NUMERAL THREE
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 2163 ROMAN NUMERAL FOUR
 * 	0049 LATIN CAPITAL LETTER I
 * 	0056 LATIN CAPITAL LETTER V
 * 2164 ROMAN NUMERAL FIVE
 * 	0056 LATIN CAPITAL LETTER V
 * 2165 ROMAN NUMERAL SIX
 * 	0056 LATIN CAPITAL LETTER V
 * 	0049 LATIN CAPITAL LETTER I
 * 2166 ROMAN NUMERAL SEVEN
 * 	0056 LATIN CAPITAL LETTER V
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 2167 ROMAN NUMERAL EIGHT
 * 	0056 LATIN CAPITAL LETTER V
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 2168 ROMAN NUMERAL NINE
 * 	0049 LATIN CAPITAL LETTER I
 * 	0058 LATIN CAPITAL LETTER X
 * 2169 ROMAN NUMERAL TEN
 * 	0058 LATIN CAPITAL LETTER X
 * 216A ROMAN NUMERAL ELEVEN
 * 	0058 LATIN CAPITAL LETTER X
 * 	0049 LATIN CAPITAL LETTER I
 * 216B ROMAN NUMERAL TWELVE
 * 	0058 LATIN CAPITAL LETTER X
 * 	0049 LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 216C ROMAN NUMERAL FIFTY
 * 	004C LATIN CAPITAL LETTER L
 * 216D ROMAN NUMERAL ONE HUNDRED
 * 	0043 LATIN CAPITAL LETTER C
 * 216E ROMAN NUMERAL FIVE HUNDRED
 * 	0044 LATIN CAPITAL LETTER D
 * 216F ROMAN NUMERAL ONE THOUSAND
 * 	004D LATIN CAPITAL LETTER M
 * 2170 SMALL ROMAN NUMERAL ONE
 * 	0069 LATIN SMALL LETTER I
 * 2171 SMALL ROMAN NUMERAL TWO
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 2172 SMALL ROMAN NUMERAL THREE
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 2173 SMALL ROMAN NUMERAL FOUR
 * 	0069 LATIN SMALL LETTER I
 * 	0076 LATIN SMALL LETTER V
 * 2174 SMALL ROMAN NUMERAL FIVE
 * 	0076 LATIN SMALL LETTER V
 * 2175 SMALL ROMAN NUMERAL SIX
 * 	0076 LATIN SMALL LETTER V
 * 	0069 LATIN SMALL LETTER I
 * 2176 SMALL ROMAN NUMERAL SEVEN
 * 	0076 LATIN SMALL LETTER V
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 2177 SMALL ROMAN NUMERAL EIGHT
 * 	0076 LATIN SMALL LETTER V
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 2178 SMALL ROMAN NUMERAL NINE
 * 	0069 LATIN SMALL LETTER I
 * 	0078 LATIN SMALL LETTER X
 * 2179 SMALL ROMAN NUMERAL TEN
 * 	0078 LATIN SMALL LETTER X
 * 217A SMALL ROMAN NUMERAL ELEVEN
 * 	0078 LATIN SMALL LETTER X
 * 	0069 LATIN SMALL LETTER I
 * 217B SMALL ROMAN NUMERAL TWELVE
 * 	0078 LATIN SMALL LETTER X
 * 	0069 LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 217C SMALL ROMAN NUMERAL FIFTY
 * 	006C LATIN SMALL LETTER L
 * 217D SMALL ROMAN NUMERAL ONE HUNDRED
 * 	0063 LATIN SMALL LETTER C
 * 217E SMALL ROMAN NUMERAL FIVE HUNDRED
 * 	0064 LATIN SMALL LETTER D
 * 217F SMALL ROMAN NUMERAL ONE THOUSAND
 * 	006D LATIN SMALL LETTER M
 * 219A LEFTWARDS ARROW WITH STROKE
 * 	2190 LEFTWARDS ARROW
 * 219B RIGHTWARDS ARROW WITH STROKE
 * 	2192 RIGHTWARDS ARROW
 * 21AE LEFT RIGHT ARROW WITH STROKE
 * 	2194 LEFT RIGHT ARROW
 * 21CD LEFTWARDS DOUBLE ARROW WITH STROKE
 * 	21D0 LEFTWARDS DOUBLE ARROW
 * 21CE LEFT RIGHT DOUBLE ARROW WITH STROKE
 * 	21D4 LEFT RIGHT DOUBLE ARROW
 * 21CF RIGHTWARDS DOUBLE ARROW WITH STROKE
 * 	21D2 RIGHTWARDS DOUBLE ARROW
 * 2204 THERE DOES NOT EXIST
 * 	2203 THERE EXISTS
 * 2209 NOT AN ELEMENT OF
 * 	2208 ELEMENT OF
 * 220C DOES NOT CONTAIN AS MEMBER
 * 	220B CONTAINS AS MEMBER
 * 2224 DOES NOT DIVIDE
 * 	2223 DIVIDES
 * 2226 NOT PARALLEL TO
 * 	2225 PARALLEL TO
 * 222C DOUBLE INTEGRAL
 * 	222B INTEGRAL
 * 	222B INTEGRAL
 * 222D TRIPLE INTEGRAL
 * 	222B INTEGRAL
 * 	222B INTEGRAL
 * 	222B INTEGRAL
 * 222F SURFACE INTEGRAL
 * 	222E CONTOUR INTEGRAL
 * 	222E CONTOUR INTEGRAL
 * 2230 VOLUME INTEGRAL
 * 	222E CONTOUR INTEGRAL
 * 	222E CONTOUR INTEGRAL
 * 	222E CONTOUR INTEGRAL
 * 2241 NOT TILDE
 * 	223C TILDE OPERATOR
 * 2244 NOT ASYMPTOTICALLY EQUAL TO
 * 	2243 ASYMPTOTICALLY EQUAL TO
 * 2247 NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
 * 	2245 APPROXIMATELY EQUAL TO
 * 2249 NOT ALMOST EQUAL TO
 * 	2248 ALMOST EQUAL TO
 * 2260 NOT EQUAL TO
 * 	003D EQUALS SIGN
 * 2262 NOT IDENTICAL TO
 * 	2261 IDENTICAL TO
 * 226D NOT EQUIVALENT TO
 * 	224D EQUIVALENT TO
 * 226E NOT LESS-THAN
 * 	003C LESS-THAN SIGN
 * 226F NOT GREATER-THAN
 * 	003E GREATER-THAN SIGN
 * 2270 NEITHER LESS-THAN NOR EQUAL TO
 * 	2264 LESS-THAN OR EQUAL TO
 * 2271 NEITHER GREATER-THAN NOR EQUAL TO
 * 	2265 GREATER-THAN OR EQUAL TO
 * 2274 NEITHER LESS-THAN NOR EQUIVALENT TO
 * 	2272 LESS-THAN OR EQUIVALENT TO
 * 2275 NEITHER GREATER-THAN NOR EQUIVALENT TO
 * 	2273 GREATER-THAN OR EQUIVALENT TO
 * 2278 NEITHER LESS-THAN NOR GREATER-THAN
 * 	2276 LESS-THAN OR GREATER-THAN
 * 2279 NEITHER GREATER-THAN NOR LESS-THAN
 * 	2277 GREATER-THAN OR LESS-THAN
 * 2280 DOES NOT PRECEDE
 * 	227A PRECEDES
 * 2281 DOES NOT SUCCEED
 * 	227B SUCCEEDS
 * 2284 NOT A SUBSET OF
 * 	2282 SUBSET OF
 * 2285 NOT A SUPERSET OF
 * 	2283 SUPERSET OF
 * 2288 NEITHER A SUBSET OF NOR EQUAL TO
 * 	2286 SUBSET OF OR EQUAL TO
 * 2289 NEITHER A SUPERSET OF NOR EQUAL TO
 * 	2287 SUPERSET OF OR EQUAL TO
 * 22AC DOES NOT PROVE
 * 	22A2 RIGHT TACK
 * 22AD NOT TRUE
 * 	22A8 TRUE
 * 22AE DOES NOT FORCE
 * 	22A9 FORCES
 * 22AF NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
 * 	22AB DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
 * 22E0 DOES NOT PRECEDE OR EQUAL
 * 	227C PRECEDES OR EQUAL TO
 * 22E1 DOES NOT SUCCEED OR EQUAL
 * 	227D SUCCEEDS OR EQUAL TO
 * 22E2 NOT SQUARE IMAGE OF OR EQUAL TO
 * 	2291 SQUARE IMAGE OF OR EQUAL TO
 * 22E3 NOT SQUARE ORIGINAL OF OR EQUAL TO
 * 	2292 SQUARE ORIGINAL OF OR EQUAL TO
 * 22EA NOT NORMAL SUBGROUP OF
 * 	22B2 NORMAL SUBGROUP OF
 * 22EB DOES NOT CONTAIN AS NORMAL SUBGROUP
 * 	22B3 CONTAINS AS NORMAL SUBGROUP
 * 22EC NOT NORMAL SUBGROUP OF OR EQUAL TO
 * 	22B4 NORMAL SUBGROUP OF OR EQUAL TO
 * 22ED DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
 * 	22B5 CONTAINS AS NORMAL SUBGROUP OR EQUAL TO
 * 2329 LEFT-POINTING ANGLE BRACKET
 * 	3008 LEFT ANGLE BRACKET
 * 232A RIGHT-POINTING ANGLE BRACKET
 * 	3009 RIGHT ANGLE BRACKET
 * 2460 CIRCLED DIGIT ONE
 * 	0031 DIGIT ONE
 * 2461 CIRCLED DIGIT TWO
 * 	0032 DIGIT TWO
 * 2462 CIRCLED DIGIT THREE
 * 	0033 DIGIT THREE
 * 2463 CIRCLED DIGIT FOUR
 * 	0034 DIGIT FOUR
 * 2464 CIRCLED DIGIT FIVE
 * 	0035 DIGIT FIVE
 * 2465 CIRCLED DIGIT SIX
 * 	0036 DIGIT SIX
 * 2466 CIRCLED DIGIT SEVEN
 * 	0037 DIGIT SEVEN
 * 2467 CIRCLED DIGIT EIGHT
 * 	0038 DIGIT EIGHT
 * 2468 CIRCLED DIGIT NINE
 * 	0039 DIGIT NINE
 * 2469 CIRCLED NUMBER TEN
 * 	0031 DIGIT ONE
 * 	0030 DIGIT ZERO
 * 246A CIRCLED NUMBER ELEVEN
 * 	0031 DIGIT ONE
 * 	0031 DIGIT ONE
 * 246B CIRCLED NUMBER TWELVE
 * 	0031 DIGIT ONE
 * 	0032 DIGIT TWO
 * 246C CIRCLED NUMBER THIRTEEN
 * 	0031 DIGIT ONE
 * 	0033 DIGIT THREE
 * 246D CIRCLED NUMBER FOURTEEN
 * 	0031 DIGIT ONE
 * 	0034 DIGIT FOUR
 * 246E CIRCLED NUMBER FIFTEEN
 * 	0031 DIGIT ONE
 * 	0035 DIGIT FIVE
 * 246F CIRCLED NUMBER SIXTEEN
 * 	0031 DIGIT ONE
 * 	0036 DIGIT SIX
 * 2470 CIRCLED NUMBER SEVENTEEN
 * 	0031 DIGIT ONE
 * 	0037 DIGIT SEVEN
 * 2471 CIRCLED NUMBER EIGHTEEN
 * 	0031 DIGIT ONE
 * 	0038 DIGIT EIGHT
 * 2472 CIRCLED NUMBER NINETEEN
 * 	0031 DIGIT ONE
 * 	0039 DIGIT NINE
 * 2473 CIRCLED NUMBER TWENTY
 * 	0032 DIGIT TWO
 * 	0030 DIGIT ZERO
 * 2474 PARENTHESIZED DIGIT ONE
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0029 RIGHT PARENTHESIS
 * 2475 PARENTHESIZED DIGIT TWO
 * 	0028 LEFT PARENTHESIS
 * 	0032 DIGIT TWO
 * 	0029 RIGHT PARENTHESIS
 * 2476 PARENTHESIZED DIGIT THREE
 * 	0028 LEFT PARENTHESIS
 * 	0033 DIGIT THREE
 * 	0029 RIGHT PARENTHESIS
 * 2477 PARENTHESIZED DIGIT FOUR
 * 	0028 LEFT PARENTHESIS
 * 	0034 DIGIT FOUR
 * 	0029 RIGHT PARENTHESIS
 * 2478 PARENTHESIZED DIGIT FIVE
 * 	0028 LEFT PARENTHESIS
 * 	0035 DIGIT FIVE
 * 	0029 RIGHT PARENTHESIS
 * 2479 PARENTHESIZED DIGIT SIX
 * 	0028 LEFT PARENTHESIS
 * 	0036 DIGIT SIX
 * 	0029 RIGHT PARENTHESIS
 * 247A PARENTHESIZED DIGIT SEVEN
 * 	0028 LEFT PARENTHESIS
 * 	0037 DIGIT SEVEN
 * 	0029 RIGHT PARENTHESIS
 * 247B PARENTHESIZED DIGIT EIGHT
 * 	0028 LEFT PARENTHESIS
 * 	0038 DIGIT EIGHT
 * 	0029 RIGHT PARENTHESIS
 * 247C PARENTHESIZED DIGIT NINE
 * 	0028 LEFT PARENTHESIS
 * 	0039 DIGIT NINE
 * 	0029 RIGHT PARENTHESIS
 * 247D PARENTHESIZED NUMBER TEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0030 DIGIT ZERO
 * 	0029 RIGHT PARENTHESIS
 * 247E PARENTHESIZED NUMBER ELEVEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0031 DIGIT ONE
 * 	0029 RIGHT PARENTHESIS
 * 247F PARENTHESIZED NUMBER TWELVE
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0032 DIGIT TWO
 * 	0029 RIGHT PARENTHESIS
 * 2480 PARENTHESIZED NUMBER THIRTEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0033 DIGIT THREE
 * 	0029 RIGHT PARENTHESIS
 * 2481 PARENTHESIZED NUMBER FOURTEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0034 DIGIT FOUR
 * 	0029 RIGHT PARENTHESIS
 * 2482 PARENTHESIZED NUMBER FIFTEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0035 DIGIT FIVE
 * 	0029 RIGHT PARENTHESIS
 * 2483 PARENTHESIZED NUMBER SIXTEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0036 DIGIT SIX
 * 	0029 RIGHT PARENTHESIS
 * 2484 PARENTHESIZED NUMBER SEVENTEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0037 DIGIT SEVEN
 * 	0029 RIGHT PARENTHESIS
 * 2485 PARENTHESIZED NUMBER EIGHTEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0038 DIGIT EIGHT
 * 	0029 RIGHT PARENTHESIS
 * 2486 PARENTHESIZED NUMBER NINETEEN
 * 	0028 LEFT PARENTHESIS
 * 	0031 DIGIT ONE
 * 	0039 DIGIT NINE
 * 	0029 RIGHT PARENTHESIS
 * 2487 PARENTHESIZED NUMBER TWENTY
 * 	0028 LEFT PARENTHESIS
 * 	0032 DIGIT TWO
 * 	0030 DIGIT ZERO
 * 	0029 RIGHT PARENTHESIS
 * 2488 DIGIT ONE FULL STOP
 * 	0031 DIGIT ONE
 * 	002E FULL STOP
 * 2489 DIGIT TWO FULL STOP
 * 	0032 DIGIT TWO
 * 	002E FULL STOP
 * 248A DIGIT THREE FULL STOP
 * 	0033 DIGIT THREE
 * 	002E FULL STOP
 * 248B DIGIT FOUR FULL STOP
 * 	0034 DIGIT FOUR
 * 	002E FULL STOP
 * 248C DIGIT FIVE FULL STOP
 * 	0035 DIGIT FIVE
 * 	002E FULL STOP
 * 248D DIGIT SIX FULL STOP
 * 	0036 DIGIT SIX
 * 	002E FULL STOP
 * 248E DIGIT SEVEN FULL STOP
 * 	0037 DIGIT SEVEN
 * 	002E FULL STOP
 * 248F DIGIT EIGHT FULL STOP
 * 	0038 DIGIT EIGHT
 * 	002E FULL STOP
 * 2490 DIGIT NINE FULL STOP
 * 	0039 DIGIT NINE
 * 	002E FULL STOP
 * 2491 NUMBER TEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0030 DIGIT ZERO
 * 	002E FULL STOP
 * 2492 NUMBER ELEVEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0031 DIGIT ONE
 * 	002E FULL STOP
 * 2493 NUMBER TWELVE FULL STOP
 * 	0031 DIGIT ONE
 * 	0032 DIGIT TWO
 * 	002E FULL STOP
 * 2494 NUMBER THIRTEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0033 DIGIT THREE
 * 	002E FULL STOP
 * 2495 NUMBER FOURTEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0034 DIGIT FOUR
 * 	002E FULL STOP
 * 2496 NUMBER FIFTEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0035 DIGIT FIVE
 * 	002E FULL STOP
 * 2497 NUMBER SIXTEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0036 DIGIT SIX
 * 	002E FULL STOP
 * 2498 NUMBER SEVENTEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0037 DIGIT SEVEN
 * 	002E FULL STOP
 * 2499 NUMBER EIGHTEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0038 DIGIT EIGHT
 * 	002E FULL STOP
 * 249A NUMBER NINETEEN FULL STOP
 * 	0031 DIGIT ONE
 * 	0039 DIGIT NINE
 * 	002E FULL STOP
 * 249B NUMBER TWENTY FULL STOP
 * 	0032 DIGIT TWO
 * 	0030 DIGIT ZERO
 * 	002E FULL STOP
 * 249C PARENTHESIZED LATIN SMALL LETTER A
 * 	0028 LEFT PARENTHESIS
 * 	0061 LATIN SMALL LETTER A
 * 	0029 RIGHT PARENTHESIS
 * 249D PARENTHESIZED LATIN SMALL LETTER B
 * 	0028 LEFT PARENTHESIS
 * 	0062 LATIN SMALL LETTER B
 * 	0029 RIGHT PARENTHESIS
 * 249E PARENTHESIZED LATIN SMALL LETTER C
 * 	0028 LEFT PARENTHESIS
 * 	0063 LATIN SMALL LETTER C
 * 	0029 RIGHT PARENTHESIS
 * 249F PARENTHESIZED LATIN SMALL LETTER D
 * 	0028 LEFT PARENTHESIS
 * 	0064 LATIN SMALL LETTER D
 * 	0029 RIGHT PARENTHESIS
 * 24A0 PARENTHESIZED LATIN SMALL LETTER E
 * 	0028 LEFT PARENTHESIS
 * 	0065 LATIN SMALL LETTER E
 * 	0029 RIGHT PARENTHESIS
 * 24A1 PARENTHESIZED LATIN SMALL LETTER F
 * 	0028 LEFT PARENTHESIS
 * 	0066 LATIN SMALL LETTER F
 * 	0029 RIGHT PARENTHESIS
 * 24A2 PARENTHESIZED LATIN SMALL LETTER G
 * 	0028 LEFT PARENTHESIS
 * 	0067 LATIN SMALL LETTER G
 * 	0029 RIGHT PARENTHESIS
 * 24A3 PARENTHESIZED LATIN SMALL LETTER H
 * 	0028 LEFT PARENTHESIS
 * 	0068 LATIN SMALL LETTER H
 * 	0029 RIGHT PARENTHESIS
 * 24A4 PARENTHESIZED LATIN SMALL LETTER I
 * 	0028 LEFT PARENTHESIS
 * 	0069 LATIN SMALL LETTER I
 * 	0029 RIGHT PARENTHESIS
 * 24A5 PARENTHESIZED LATIN SMALL LETTER J
 * 	0028 LEFT PARENTHESIS
 * 	006A LATIN SMALL LETTER J
 * 	0029 RIGHT PARENTHESIS
 * 24A6 PARENTHESIZED LATIN SMALL LETTER K
 * 	0028 LEFT PARENTHESIS
 * 	006B LATIN SMALL LETTER K
 * 	0029 RIGHT PARENTHESIS
 * 24A7 PARENTHESIZED LATIN SMALL LETTER L
 * 	0028 LEFT PARENTHESIS
 * 	006C LATIN SMALL LETTER L
 * 	0029 RIGHT PARENTHESIS
 * 24A8 PARENTHESIZED LATIN SMALL LETTER M
 * 	0028 LEFT PARENTHESIS
 * 	006D LATIN SMALL LETTER M
 * 	0029 RIGHT PARENTHESIS
 * 24A9 PARENTHESIZED LATIN SMALL LETTER N
 * 	0028 LEFT PARENTHESIS
 * 	006E LATIN SMALL LETTER N
 * 	0029 RIGHT PARENTHESIS
 * 24AA PARENTHESIZED LATIN SMALL LETTER O
 * 	0028 LEFT PARENTHESIS
 * 	006F LATIN SMALL LETTER O
 * 	0029 RIGHT PARENTHESIS
 * 24AB PARENTHESIZED LATIN SMALL LETTER P
 * 	0028 LEFT PARENTHESIS
 * 	0070 LATIN SMALL LETTER P
 * 	0029 RIGHT PARENTHESIS
 * 24AC PARENTHESIZED LATIN SMALL LETTER Q
 * 	0028 LEFT PARENTHESIS
 * 	0071 LATIN SMALL LETTER Q
 * 	0029 RIGHT PARENTHESIS
 * 24AD PARENTHESIZED LATIN SMALL LETTER R
 * 	0028 LEFT PARENTHESIS
 * 	0072 LATIN SMALL LETTER R
 * 	0029 RIGHT PARENTHESIS
 * 24AE PARENTHESIZED LATIN SMALL LETTER S
 * 	0028 LEFT PARENTHESIS
 * 	0073 LATIN SMALL LETTER S
 * 	0029 RIGHT PARENTHESIS
 * 24AF PARENTHESIZED LATIN SMALL LETTER T
 * 	0028 LEFT PARENTHESIS
 * 	0074 LATIN SMALL LETTER T
 * 	0029 RIGHT PARENTHESIS
 * 24B0 PARENTHESIZED LATIN SMALL LETTER U
 * 	0028 LEFT PARENTHESIS
 * 	0075 LATIN SMALL LETTER U
 * 	0029 RIGHT PARENTHESIS
 * 24B1 PARENTHESIZED LATIN SMALL LETTER V
 * 	0028 LEFT PARENTHESIS
 * 	0076 LATIN SMALL LETTER V
 * 	0029 RIGHT PARENTHESIS
 * 24B2 PARENTHESIZED LATIN SMALL LETTER W
 * 	0028 LEFT PARENTHESIS
 * 	0077 LATIN SMALL LETTER W
 * 	0029 RIGHT PARENTHESIS
 * 24B3 PARENTHESIZED LATIN SMALL LETTER X
 * 	0028 LEFT PARENTHESIS
 * 	0078 LATIN SMALL LETTER X
 * 	0029 RIGHT PARENTHESIS
 * 24B4 PARENTHESIZED LATIN SMALL LETTER Y
 * 	0028 LEFT PARENTHESIS
 * 	0079 LATIN SMALL LETTER Y
 * 	0029 RIGHT PARENTHESIS
 * 24B5 PARENTHESIZED LATIN SMALL LETTER Z
 * 	0028 LEFT PARENTHESIS
 * 	007A LATIN SMALL LETTER Z
 * 	0029 RIGHT PARENTHESIS
 * 24B6 CIRCLED LATIN CAPITAL LETTER A
 * 	0041 LATIN CAPITAL LETTER A
 * 24B7 CIRCLED LATIN CAPITAL LETTER B
 * 	0042 LATIN CAPITAL LETTER B
 * 24B8 CIRCLED LATIN CAPITAL LETTER C
 * 	0043 LATIN CAPITAL LETTER C
 * 24B9 CIRCLED LATIN CAPITAL LETTER D
 * 	0044 LATIN CAPITAL LETTER D
 * 24BA CIRCLED LATIN CAPITAL LETTER E
 * 	0045 LATIN CAPITAL LETTER E
 * 24BB CIRCLED LATIN CAPITAL LETTER F
 * 	0046 LATIN CAPITAL LETTER F
 * 24BC CIRCLED LATIN CAPITAL LETTER G
 * 	0047 LATIN CAPITAL LETTER G
 * 24BD CIRCLED LATIN CAPITAL LETTER H
 * 	0048 LATIN CAPITAL LETTER H
 * 24BE CIRCLED LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * 24BF CIRCLED LATIN CAPITAL LETTER J
 * 	004A LATIN CAPITAL LETTER J
 * 24C0 CIRCLED LATIN CAPITAL LETTER K
 * 	004B LATIN CAPITAL LETTER K
 * 24C1 CIRCLED LATIN CAPITAL LETTER L
 * 	004C LATIN CAPITAL LETTER L
 * 24C2 CIRCLED LATIN CAPITAL LETTER M
 * 	004D LATIN CAPITAL LETTER M
 * 24C3 CIRCLED LATIN CAPITAL LETTER N
 * 	004E LATIN CAPITAL LETTER N
 * 24C4 CIRCLED LATIN CAPITAL LETTER O
 * 	004F LATIN CAPITAL LETTER O
 * 24C5 CIRCLED LATIN CAPITAL LETTER P
 * 	0050 LATIN CAPITAL LETTER P
 * 24C6 CIRCLED LATIN CAPITAL LETTER Q
 * 	0051 LATIN CAPITAL LETTER Q
 * 24C7 CIRCLED LATIN CAPITAL LETTER R
 * 	0052 LATIN CAPITAL LETTER R
 * 24C8 CIRCLED LATIN CAPITAL LETTER S
 * 	0053 LATIN CAPITAL LETTER S
 * 24C9 CIRCLED LATIN CAPITAL LETTER T
 * 	0054 LATIN CAPITAL LETTER T
 * 24CA CIRCLED LATIN CAPITAL LETTER U
 * 	0055 LATIN CAPITAL LETTER U
 * 24CB CIRCLED LATIN CAPITAL LETTER V
 * 	0056 LATIN CAPITAL LETTER V
 * 24CC CIRCLED LATIN CAPITAL LETTER W
 * 	0057 LATIN CAPITAL LETTER W
 * 24CD CIRCLED LATIN CAPITAL LETTER X
 * 	0058 LATIN CAPITAL LETTER X
 * 24CE CIRCLED LATIN CAPITAL LETTER Y
 * 	0059 LATIN CAPITAL LETTER Y
 * 24CF CIRCLED LATIN CAPITAL LETTER Z
 * 	005A LATIN CAPITAL LETTER Z
 * 24D0 CIRCLED LATIN SMALL LETTER A
 * 	0061 LATIN SMALL LETTER A
 * 24D1 CIRCLED LATIN SMALL LETTER B
 * 	0062 LATIN SMALL LETTER B
 * 24D2 CIRCLED LATIN SMALL LETTER C
 * 	0063 LATIN SMALL LETTER C
 * 24D3 CIRCLED LATIN SMALL LETTER D
 * 	0064 LATIN SMALL LETTER D
 * 24D4 CIRCLED LATIN SMALL LETTER E
 * 	0065 LATIN SMALL LETTER E
 * 24D5 CIRCLED LATIN SMALL LETTER F
 * 	0066 LATIN SMALL LETTER F
 * 24D6 CIRCLED LATIN SMALL LETTER G
 * 	0067 LATIN SMALL LETTER G
 * 24D7 CIRCLED LATIN SMALL LETTER H
 * 	0068 LATIN SMALL LETTER H
 * 24D8 CIRCLED LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * 24D9 CIRCLED LATIN SMALL LETTER J
 * 	006A LATIN SMALL LETTER J
 * 24DA CIRCLED LATIN SMALL LETTER K
 * 	006B LATIN SMALL LETTER K
 * 24DB CIRCLED LATIN SMALL LETTER L
 * 	006C LATIN SMALL LETTER L
 * 24DC CIRCLED LATIN SMALL LETTER M
 * 	006D LATIN SMALL LETTER M
 * 24DD CIRCLED LATIN SMALL LETTER N
 * 	006E LATIN SMALL LETTER N
 * 24DE CIRCLED LATIN SMALL LETTER O
 * 	006F LATIN SMALL LETTER O
 * 24DF CIRCLED LATIN SMALL LETTER P
 * 	0070 LATIN SMALL LETTER P
 * 24E0 CIRCLED LATIN SMALL LETTER Q
 * 	0071 LATIN SMALL LETTER Q
 * 24E1 CIRCLED LATIN SMALL LETTER R
 * 	0072 LATIN SMALL LETTER R
 * 24E2 CIRCLED LATIN SMALL LETTER S
 * 	0073 LATIN SMALL LETTER S
 * 24E3 CIRCLED LATIN SMALL LETTER T
 * 	0074 LATIN SMALL LETTER T
 * 24E4 CIRCLED LATIN SMALL LETTER U
 * 	0075 LATIN SMALL LETTER U
 * 24E5 CIRCLED LATIN SMALL LETTER V
 * 	0076 LATIN SMALL LETTER V
 * 24E6 CIRCLED LATIN SMALL LETTER W
 * 	0077 LATIN SMALL LETTER W
 * 24E7 CIRCLED LATIN SMALL LETTER X
 * 	0078 LATIN SMALL LETTER X
 * 24E8 CIRCLED LATIN SMALL LETTER Y
 * 	0079 LATIN SMALL LETTER Y
 * 24E9 CIRCLED LATIN SMALL LETTER Z
 * 	007A LATIN SMALL LETTER Z
 * 24EA CIRCLED DIGIT ZERO
 * 	0030 DIGIT ZERO
 * 2A0C QUADRUPLE INTEGRAL OPERATOR
 * 	222B INTEGRAL
 * 	222B INTEGRAL
 * 	222B INTEGRAL
 * 	222B INTEGRAL
 * 2A74 DOUBLE COLON EQUAL
 * 	003A COLON
 * 	003A COLON
 * 	003D EQUALS SIGN
 * 2A75 TWO CONSECUTIVE EQUALS SIGNS
 * 	003D EQUALS SIGN
 * 	003D EQUALS SIGN
 * 2A76 THREE CONSECUTIVE EQUALS SIGNS
 * 	003D EQUALS SIGN
 * 	003D EQUALS SIGN
 * 	003D EQUALS SIGN
 * 2ADC FORKING
 * 	2ADD NONFORKING
 * 2E9F CJK RADICAL MOTHER
 * 	6BCD ??
 * 2EF3 CJK RADICAL C-SIMPLIFIED TURTLE
 * 	9F9F ??
 * 2F00 KANGXI RADICAL ONE
 * 	4E00 <CJK Ideograph, First>
 * 2F01 KANGXI RADICAL LINE
 * 	4E28 ??
 * 2F02 KANGXI RADICAL DOT
 * 	4E36 ??
 * 2F03 KANGXI RADICAL SLASH
 * 	4E3F ??
 * 2F04 KANGXI RADICAL SECOND
 * 	4E59 ??
 * 2F05 KANGXI RADICAL HOOK
 * 	4E85 ??
 * 2F06 KANGXI RADICAL TWO
 * 	4E8C ??
 * 2F07 KANGXI RADICAL LID
 * 	4EA0 ??
 * 2F08 KANGXI RADICAL MAN
 * 	4EBA ??
 * 2F09 KANGXI RADICAL LEGS
 * 	513F ??
 * 2F0A KANGXI RADICAL ENTER
 * 	5165 ??
 * 2F0B KANGXI RADICAL EIGHT
 * 	516B ??
 * 2F0C KANGXI RADICAL DOWN BOX
 * 	5182 ??
 * 2F0D KANGXI RADICAL COVER
 * 	5196 ??
 * 2F0E KANGXI RADICAL ICE
 * 	51AB ??
 * 2F0F KANGXI RADICAL TABLE
 * 	51E0 ??
 * 2F10 KANGXI RADICAL OPEN BOX
 * 	51F5 ??
 * 2F11 KANGXI RADICAL KNIFE
 * 	5200 ??
 * 2F12 KANGXI RADICAL POWER
 * 	529B ??
 * 2F13 KANGXI RADICAL WRAP
 * 	52F9 ??
 * 2F14 KANGXI RADICAL SPOON
 * 	5315 ??
 * 2F15 KANGXI RADICAL RIGHT OPEN BOX
 * 	531A ??
 * 2F16 KANGXI RADICAL HIDING ENCLOSURE
 * 	5338 ??
 * 2F17 KANGXI RADICAL TEN
 * 	5341 ??
 * 2F18 KANGXI RADICAL DIVINATION
 * 	535C ??
 * 2F19 KANGXI RADICAL SEAL
 * 	5369 ??
 * 2F1A KANGXI RADICAL CLIFF
 * 	5382 ??
 * 2F1B KANGXI RADICAL PRIVATE
 * 	53B6 ??
 * 2F1C KANGXI RADICAL AGAIN
 * 	53C8 ??
 * 2F1D KANGXI RADICAL MOUTH
 * 	53E3 ??
 * 2F1E KANGXI RADICAL ENCLOSURE
 * 	56D7 ??
 * 2F1F KANGXI RADICAL EARTH
 * 	571F ??
 * 2F20 KANGXI RADICAL SCHOLAR
 * 	58EB ??
 * 2F21 KANGXI RADICAL GO
 * 	5902 ??
 * 2F22 KANGXI RADICAL GO SLOWLY
 * 	590A ??
 * 2F23 KANGXI RADICAL EVENING
 * 	5915 ??
 * 2F24 KANGXI RADICAL BIG
 * 	5927 ??
 * 2F25 KANGXI RADICAL WOMAN
 * 	5973 ??
 * 2F26 KANGXI RADICAL CHILD
 * 	5B50 ??
 * 2F27 KANGXI RADICAL ROOF
 * 	5B80 ??
 * 2F28 KANGXI RADICAL INCH
 * 	5BF8 ??
 * 2F29 KANGXI RADICAL SMALL
 * 	5C0F ??
 * 2F2A KANGXI RADICAL LAME
 * 	5C22 ??
 * 2F2B KANGXI RADICAL CORPSE
 * 	5C38 ??
 * 2F2C KANGXI RADICAL SPROUT
 * 	5C6E ??
 * 2F2D KANGXI RADICAL MOUNTAIN
 * 	5C71 ??
 * 2F2E KANGXI RADICAL RIVER
 * 	5DDB ??
 * 2F2F KANGXI RADICAL WORK
 * 	5DE5 ??
 * 2F30 KANGXI RADICAL ONESELF
 * 	5DF1 ??
 * 2F31 KANGXI RADICAL TURBAN
 * 	5DFE ??
 * 2F32 KANGXI RADICAL DRY
 * 	5E72 ??
 * 2F33 KANGXI RADICAL SHORT THREAD
 * 	5E7A ??
 * 2F34 KANGXI RADICAL DOTTED CLIFF
 * 	5E7F ??
 * 2F35 KANGXI RADICAL LONG STRIDE
 * 	5EF4 ??
 * 2F36 KANGXI RADICAL TWO HANDS
 * 	5EFE ??
 * 2F37 KANGXI RADICAL SHOOT
 * 	5F0B ??
 * 2F38 KANGXI RADICAL BOW
 * 	5F13 ??
 * 2F39 KANGXI RADICAL SNOUT
 * 	5F50 ??
 * 2F3A KANGXI RADICAL BRISTLE
 * 	5F61 ??
 * 2F3B KANGXI RADICAL STEP
 * 	5F73 ??
 * 2F3C KANGXI RADICAL HEART
 * 	5FC3 ??
 * 2F3D KANGXI RADICAL HALBERD
 * 	6208 ??
 * 2F3E KANGXI RADICAL DOOR
 * 	6236 ??
 * 2F3F KANGXI RADICAL HAND
 * 	624B ??
 * 2F40 KANGXI RADICAL BRANCH
 * 	652F ??
 * 2F41 KANGXI RADICAL RAP
 * 	6534 ??
 * 2F42 KANGXI RADICAL SCRIPT
 * 	6587 ??
 * 2F43 KANGXI RADICAL DIPPER
 * 	6597 ??
 * 2F44 KANGXI RADICAL AXE
 * 	65A4 ??
 * 2F45 KANGXI RADICAL SQUARE
 * 	65B9 ??
 * 2F46 KANGXI RADICAL NOT
 * 	65E0 ??
 * 2F47 KANGXI RADICAL SUN
 * 	65E5 ??
 * 2F48 KANGXI RADICAL SAY
 * 	66F0 ??
 * 2F49 KANGXI RADICAL MOON
 * 	6708 ??
 * 2F4A KANGXI RADICAL TREE
 * 	6728 ??
 * 2F4B KANGXI RADICAL LACK
 * 	6B20 ??
 * 2F4C KANGXI RADICAL STOP
 * 	6B62 ??
 * 2F4D KANGXI RADICAL DEATH
 * 	6B79 ??
 * 2F4E KANGXI RADICAL WEAPON
 * 	6BB3 ??
 * 2F4F KANGXI RADICAL DO NOT
 * 	6BCB ??
 * 2F50 KANGXI RADICAL COMPARE
 * 	6BD4 ??
 * 2F51 KANGXI RADICAL FUR
 * 	6BDB ??
 * 2F52 KANGXI RADICAL CLAN
 * 	6C0F ??
 * 2F53 KANGXI RADICAL STEAM
 * 	6C14 ??
 * 2F54 KANGXI RADICAL WATER
 * 	6C34 ??
 * 2F55 KANGXI RADICAL FIRE
 * 	706B ??
 * 2F56 KANGXI RADICAL CLAW
 * 	722A ??
 * 2F57 KANGXI RADICAL FATHER
 * 	7236 ??
 * 2F58 KANGXI RADICAL DOUBLE X
 * 	723B ??
 * 2F59 KANGXI RADICAL HALF TREE TRUNK
 * 	723F ??
 * 2F5A KANGXI RADICAL SLICE
 * 	7247 ??
 * 2F5B KANGXI RADICAL FANG
 * 	7259 ??
 * 2F5C KANGXI RADICAL COW
 * 	725B ??
 * 2F5D KANGXI RADICAL DOG
 * 	72AC ??
 * 2F5E KANGXI RADICAL PROFOUND
 * 	7384 ??
 * 2F5F KANGXI RADICAL JADE
 * 	7389 ??
 * 2F60 KANGXI RADICAL MELON
 * 	74DC ??
 * 2F61 KANGXI RADICAL TILE
 * 	74E6 ??
 * 2F62 KANGXI RADICAL SWEET
 * 	7518 ??
 * 2F63 KANGXI RADICAL LIFE
 * 	751F ??
 * 2F64 KANGXI RADICAL USE
 * 	7528 ??
 * 2F65 KANGXI RADICAL FIELD
 * 	7530 ??
 * 2F66 KANGXI RADICAL BOLT OF CLOTH
 * 	758B ??
 * 2F67 KANGXI RADICAL SICKNESS
 * 	7592 ??
 * 2F68 KANGXI RADICAL DOTTED TENT
 * 	7676 ??
 * 2F69 KANGXI RADICAL WHITE
 * 	767D ??
 * 2F6A KANGXI RADICAL SKIN
 * 	76AE ??
 * 2F6B KANGXI RADICAL DISH
 * 	76BF ??
 * 2F6C KANGXI RADICAL EYE
 * 	76EE ??
 * 2F6D KANGXI RADICAL SPEAR
 * 	77DB ??
 * 2F6E KANGXI RADICAL ARROW
 * 	77E2 ??
 * 2F6F KANGXI RADICAL STONE
 * 	77F3 ??
 * 2F70 KANGXI RADICAL SPIRIT
 * 	793A ??
 * 2F71 KANGXI RADICAL TRACK
 * 	79B8 ??
 * 2F72 KANGXI RADICAL GRAIN
 * 	79BE ??
 * 2F73 KANGXI RADICAL CAVE
 * 	7A74 ??
 * 2F74 KANGXI RADICAL STAND
 * 	7ACB ??
 * 2F75 KANGXI RADICAL BAMBOO
 * 	7AF9 ??
 * 2F76 KANGXI RADICAL RICE
 * 	7C73 ??
 * 2F77 KANGXI RADICAL SILK
 * 	7CF8 ??
 * 2F78 KANGXI RADICAL JAR
 * 	7F36 ??
 * 2F79 KANGXI RADICAL NET
 * 	7F51 ??
 * 2F7A KANGXI RADICAL SHEEP
 * 	7F8A ??
 * 2F7B KANGXI RADICAL FEATHER
 * 	7FBD ??
 * 2F7C KANGXI RADICAL OLD
 * 	8001 ??
 * 2F7D KANGXI RADICAL AND
 * 	800C ??
 * 2F7E KANGXI RADICAL PLOW
 * 	8012 ??
 * 2F7F KANGXI RADICAL EAR
 * 	8033 ??
 * 2F80 KANGXI RADICAL BRUSH
 * 	807F ??
 * 2F800 CJK COMPATIBILITY IDEOGRAPH-2F800
 * 	4E3D ??
 * 2F801 CJK COMPATIBILITY IDEOGRAPH-2F801
 * 	4E38 ??
 * 2F802 CJK COMPATIBILITY IDEOGRAPH-2F802
 * 	4E41 ??
 * 2F803 CJK COMPATIBILITY IDEOGRAPH-2F803
 * 	20122 ??
 * 2F804 CJK COMPATIBILITY IDEOGRAPH-2F804
 * 	4F60 ??
 * 2F805 CJK COMPATIBILITY IDEOGRAPH-2F805
 * 	4FAE ??
 * 2F806 CJK COMPATIBILITY IDEOGRAPH-2F806
 * 	4FBB ??
 * 2F807 CJK COMPATIBILITY IDEOGRAPH-2F807
 * 	5002 ??
 * 2F808 CJK COMPATIBILITY IDEOGRAPH-2F808
 * 	507A ??
 * 2F809 CJK COMPATIBILITY IDEOGRAPH-2F809
 * 	5099 ??
 * 2F80A CJK COMPATIBILITY IDEOGRAPH-2F80A
 * 	50E7 ??
 * 2F80B CJK COMPATIBILITY IDEOGRAPH-2F80B
 * 	50CF ??
 * 2F80C CJK COMPATIBILITY IDEOGRAPH-2F80C
 * 	349E ??
 * 2F80D CJK COMPATIBILITY IDEOGRAPH-2F80D
 * 	2063A ??
 * 2F80E CJK COMPATIBILITY IDEOGRAPH-2F80E
 * 	514D ??
 * 2F80F CJK COMPATIBILITY IDEOGRAPH-2F80F
 * 	5154 ??
 * 2F81 KANGXI RADICAL MEAT
 * 	8089 ??
 * 2F810 CJK COMPATIBILITY IDEOGRAPH-2F810
 * 	5164 ??
 * 2F811 CJK COMPATIBILITY IDEOGRAPH-2F811
 * 	5177 ??
 * 2F812 CJK COMPATIBILITY IDEOGRAPH-2F812
 * 	2051C ??
 * 2F813 CJK COMPATIBILITY IDEOGRAPH-2F813
 * 	34B9 ??
 * 2F814 CJK COMPATIBILITY IDEOGRAPH-2F814
 * 	5167 ??
 * 2F815 CJK COMPATIBILITY IDEOGRAPH-2F815
 * 	518D ??
 * 2F816 CJK COMPATIBILITY IDEOGRAPH-2F816
 * 	2054B ??
 * 2F817 CJK COMPATIBILITY IDEOGRAPH-2F817
 * 	5197 ??
 * 2F818 CJK COMPATIBILITY IDEOGRAPH-2F818
 * 	51A4 ??
 * 2F819 CJK COMPATIBILITY IDEOGRAPH-2F819
 * 	4ECC ??
 * 2F81A CJK COMPATIBILITY IDEOGRAPH-2F81A
 * 	51AC ??
 * 2F81B CJK COMPATIBILITY IDEOGRAPH-2F81B
 * 	51B5 ??
 * 2F81C CJK COMPATIBILITY IDEOGRAPH-2F81C
 * 	291DF ??
 * 2F81D CJK COMPATIBILITY IDEOGRAPH-2F81D
 * 	51F5 ??
 * 2F81E CJK COMPATIBILITY IDEOGRAPH-2F81E
 * 	5203 ??
 * 2F81F CJK COMPATIBILITY IDEOGRAPH-2F81F
 * 	34DF ??
 * 2F82 KANGXI RADICAL MINISTER
 * 	81E3 ??
 * 2F820 CJK COMPATIBILITY IDEOGRAPH-2F820
 * 	523B ??
 * 2F821 CJK COMPATIBILITY IDEOGRAPH-2F821
 * 	5246 ??
 * 2F822 CJK COMPATIBILITY IDEOGRAPH-2F822
 * 	5272 ??
 * 2F823 CJK COMPATIBILITY IDEOGRAPH-2F823
 * 	5277 ??
 * 2F824 CJK COMPATIBILITY IDEOGRAPH-2F824
 * 	3515 ??
 * 2F825 CJK COMPATIBILITY IDEOGRAPH-2F825
 * 	52C7 ??
 * 2F826 CJK COMPATIBILITY IDEOGRAPH-2F826
 * 	52C9 ??
 * 2F827 CJK COMPATIBILITY IDEOGRAPH-2F827
 * 	52E4 ??
 * 2F828 CJK COMPATIBILITY IDEOGRAPH-2F828
 * 	52FA ??
 * 2F829 CJK COMPATIBILITY IDEOGRAPH-2F829
 * 	5305 ??
 * 2F82A CJK COMPATIBILITY IDEOGRAPH-2F82A
 * 	5306 ??
 * 2F82B CJK COMPATIBILITY IDEOGRAPH-2F82B
 * 	5317 ??
 * 2F82C CJK COMPATIBILITY IDEOGRAPH-2F82C
 * 	5349 ??
 * 2F82D CJK COMPATIBILITY IDEOGRAPH-2F82D
 * 	5351 ??
 * 2F82E CJK COMPATIBILITY IDEOGRAPH-2F82E
 * 	535A ??
 * 2F82F CJK COMPATIBILITY IDEOGRAPH-2F82F
 * 	5373 ??
 * 2F83 KANGXI RADICAL SELF
 * 	81EA ??
 * 2F830 CJK COMPATIBILITY IDEOGRAPH-2F830
 * 	537D ??
 * 2F831 CJK COMPATIBILITY IDEOGRAPH-2F831
 * 	537F ??
 * 2F832 CJK COMPATIBILITY IDEOGRAPH-2F832
 * 	537F ??
 * 2F833 CJK COMPATIBILITY IDEOGRAPH-2F833
 * 	537F ??
 * 2F834 CJK COMPATIBILITY IDEOGRAPH-2F834
 * 	20A2C ??
 * 2F835 CJK COMPATIBILITY IDEOGRAPH-2F835
 * 	7070 ??
 * 2F836 CJK COMPATIBILITY IDEOGRAPH-2F836
 * 	53CA ??
 * 2F837 CJK COMPATIBILITY IDEOGRAPH-2F837
 * 	53DF ??
 * 2F838 CJK COMPATIBILITY IDEOGRAPH-2F838
 * 	20B63 ??
 * 2F839 CJK COMPATIBILITY IDEOGRAPH-2F839
 * 	53EB ??
 * 2F83A CJK COMPATIBILITY IDEOGRAPH-2F83A
 * 	53F1 ??
 * 2F83B CJK COMPATIBILITY IDEOGRAPH-2F83B
 * 	5406 ??
 * 2F83C CJK COMPATIBILITY IDEOGRAPH-2F83C
 * 	549E ??
 * 2F83D CJK COMPATIBILITY IDEOGRAPH-2F83D
 * 	5438 ??
 * 2F83E CJK COMPATIBILITY IDEOGRAPH-2F83E
 * 	5448 ??
 * 2F83F CJK COMPATIBILITY IDEOGRAPH-2F83F
 * 	5468 ??
 * 2F84 KANGXI RADICAL ARRIVE
 * 	81F3 ??
 * 2F840 CJK COMPATIBILITY IDEOGRAPH-2F840
 * 	54A2 ??
 * 2F841 CJK COMPATIBILITY IDEOGRAPH-2F841
 * 	54F6 ??
 * 2F842 CJK COMPATIBILITY IDEOGRAPH-2F842
 * 	5510 ??
 * 2F843 CJK COMPATIBILITY IDEOGRAPH-2F843
 * 	5553 ??
 * 2F844 CJK COMPATIBILITY IDEOGRAPH-2F844
 * 	5563 ??
 * 2F845 CJK COMPATIBILITY IDEOGRAPH-2F845
 * 	5584 ??
 * 2F846 CJK COMPATIBILITY IDEOGRAPH-2F846
 * 	5584 ??
 * 2F847 CJK COMPATIBILITY IDEOGRAPH-2F847
 * 	5599 ??
 * 2F848 CJK COMPATIBILITY IDEOGRAPH-2F848
 * 	55AB ??
 * 2F849 CJK COMPATIBILITY IDEOGRAPH-2F849
 * 	55B3 ??
 * 2F84A CJK COMPATIBILITY IDEOGRAPH-2F84A
 * 	55C2 ??
 * 2F84B CJK COMPATIBILITY IDEOGRAPH-2F84B
 * 	5716 ??
 * 2F84C CJK COMPATIBILITY IDEOGRAPH-2F84C
 * 	5606 ??
 * 2F84D CJK COMPATIBILITY IDEOGRAPH-2F84D
 * 	5717 ??
 * 2F84E CJK COMPATIBILITY IDEOGRAPH-2F84E
 * 	5651 ??
 * 2F84F CJK COMPATIBILITY IDEOGRAPH-2F84F
 * 	5674 ??
 * 2F85 KANGXI RADICAL MORTAR
 * 	81FC ??
 * 2F850 CJK COMPATIBILITY IDEOGRAPH-2F850
 * 	5207 ??
 * 2F851 CJK COMPATIBILITY IDEOGRAPH-2F851
 * 	58EE ??
 * 2F852 CJK COMPATIBILITY IDEOGRAPH-2F852
 * 	57CE ??
 * 2F853 CJK COMPATIBILITY IDEOGRAPH-2F853
 * 	57F4 ??
 * 2F854 CJK COMPATIBILITY IDEOGRAPH-2F854
 * 	580D ??
 * 2F855 CJK COMPATIBILITY IDEOGRAPH-2F855
 * 	578B ??
 * 2F856 CJK COMPATIBILITY IDEOGRAPH-2F856
 * 	5832 ??
 * 2F857 CJK COMPATIBILITY IDEOGRAPH-2F857
 * 	5831 ??
 * 2F858 CJK COMPATIBILITY IDEOGRAPH-2F858
 * 	58AC ??
 * 2F859 CJK COMPATIBILITY IDEOGRAPH-2F859
 * 	214E4 ??
 * 2F85A CJK COMPATIBILITY IDEOGRAPH-2F85A
 * 	58F2 ??
 * 2F85B CJK COMPATIBILITY IDEOGRAPH-2F85B
 * 	58F7 ??
 * 2F85C CJK COMPATIBILITY IDEOGRAPH-2F85C
 * 	5906 ??
 * 2F85D CJK COMPATIBILITY IDEOGRAPH-2F85D
 * 	591A ??
 * 2F85E CJK COMPATIBILITY IDEOGRAPH-2F85E
 * 	5922 ??
 * 2F85F CJK COMPATIBILITY IDEOGRAPH-2F85F
 * 	5962 ??
 * 2F86 KANGXI RADICAL TONGUE
 * 	820C ??
 * 2F860 CJK COMPATIBILITY IDEOGRAPH-2F860
 * 	216A8 ??
 * 2F861 CJK COMPATIBILITY IDEOGRAPH-2F861
 * 	216EA ??
 * 2F862 CJK COMPATIBILITY IDEOGRAPH-2F862
 * 	59EC ??
 * 2F863 CJK COMPATIBILITY IDEOGRAPH-2F863
 * 	5A1B ??
 * 2F864 CJK COMPATIBILITY IDEOGRAPH-2F864
 * 	5A27 ??
 * 2F865 CJK COMPATIBILITY IDEOGRAPH-2F865
 * 	59D8 ??
 * 2F866 CJK COMPATIBILITY IDEOGRAPH-2F866
 * 	5A66 ??
 * 2F867 CJK COMPATIBILITY IDEOGRAPH-2F867
 * 	36EE ??
 * 2F868 CJK COMPATIBILITY IDEOGRAPH-2F868
 * 	2136A ??
 * 2F869 CJK COMPATIBILITY IDEOGRAPH-2F869
 * 	5B08 ??
 * 2F86A CJK COMPATIBILITY IDEOGRAPH-2F86A
 * 	5B3E ??
 * 2F86B CJK COMPATIBILITY IDEOGRAPH-2F86B
 * 	5B3E ??
 * 2F86C CJK COMPATIBILITY IDEOGRAPH-2F86C
 * 	219C8 ??
 * 2F86D CJK COMPATIBILITY IDEOGRAPH-2F86D
 * 	5BC3 ??
 * 2F86E CJK COMPATIBILITY IDEOGRAPH-2F86E
 * 	5BD8 ??
 * 2F86F CJK COMPATIBILITY IDEOGRAPH-2F86F
 * 	5BE7 ??
 * 2F87 KANGXI RADICAL OPPOSE
 * 	821B ??
 * 2F870 CJK COMPATIBILITY IDEOGRAPH-2F870
 * 	5BF3 ??
 * 2F871 CJK COMPATIBILITY IDEOGRAPH-2F871
 * 	21B18 ??
 * 2F872 CJK COMPATIBILITY IDEOGRAPH-2F872
 * 	5BFF ??
 * 2F873 CJK COMPATIBILITY IDEOGRAPH-2F873
 * 	5C06 ??
 * 2F874 CJK COMPATIBILITY IDEOGRAPH-2F874
 * 	5F33 ??
 * 2F875 CJK COMPATIBILITY IDEOGRAPH-2F875
 * 	5C22 ??
 * 2F876 CJK COMPATIBILITY IDEOGRAPH-2F876
 * 	3781 ??
 * 2F877 CJK COMPATIBILITY IDEOGRAPH-2F877
 * 	5C60 ??
 * 2F878 CJK COMPATIBILITY IDEOGRAPH-2F878
 * 	5C6E ??
 * 2F879 CJK COMPATIBILITY IDEOGRAPH-2F879
 * 	5CC0 ??
 * 2F87A CJK COMPATIBILITY IDEOGRAPH-2F87A
 * 	5C8D ??
 * 2F87B CJK COMPATIBILITY IDEOGRAPH-2F87B
 * 	21DE4 ??
 * 2F87C CJK COMPATIBILITY IDEOGRAPH-2F87C
 * 	5D43 ??
 * 2F87D CJK COMPATIBILITY IDEOGRAPH-2F87D
 * 	21DE6 ??
 * 2F87E CJK COMPATIBILITY IDEOGRAPH-2F87E
 * 	5D6E ??
 * 2F87F CJK COMPATIBILITY IDEOGRAPH-2F87F
 * 	5D6B ??
 * 2F88 KANGXI RADICAL BOAT
 * 	821F ??
 * 2F880 CJK COMPATIBILITY IDEOGRAPH-2F880
 * 	5D7C ??
 * 2F881 CJK COMPATIBILITY IDEOGRAPH-2F881
 * 	5DE1 ??
 * 2F882 CJK COMPATIBILITY IDEOGRAPH-2F882
 * 	5DE2 ??
 * 2F883 CJK COMPATIBILITY IDEOGRAPH-2F883
 * 	382F ??
 * 2F884 CJK COMPATIBILITY IDEOGRAPH-2F884
 * 	5DFD ??
 * 2F885 CJK COMPATIBILITY IDEOGRAPH-2F885
 * 	5E28 ??
 * 2F886 CJK COMPATIBILITY IDEOGRAPH-2F886
 * 	5E3D ??
 * 2F887 CJK COMPATIBILITY IDEOGRAPH-2F887
 * 	5E69 ??
 * 2F888 CJK COMPATIBILITY IDEOGRAPH-2F888
 * 	3862 ??
 * 2F889 CJK COMPATIBILITY IDEOGRAPH-2F889
 * 	22183 ??
 * 2F88A CJK COMPATIBILITY IDEOGRAPH-2F88A
 * 	387C ??
 * 2F88B CJK COMPATIBILITY IDEOGRAPH-2F88B
 * 	5EB0 ??
 * 2F88C CJK COMPATIBILITY IDEOGRAPH-2F88C
 * 	5EB3 ??
 * 2F88D CJK COMPATIBILITY IDEOGRAPH-2F88D
 * 	5EB6 ??
 * 2F88E CJK COMPATIBILITY IDEOGRAPH-2F88E
 * 	5ECA ??
 * 2F88F CJK COMPATIBILITY IDEOGRAPH-2F88F
 * 	2A392 ??
 * 2F89 KANGXI RADICAL STOPPING
 * 	826E ??
 * 2F890 CJK COMPATIBILITY IDEOGRAPH-2F890
 * 	5EFE ??
 * 2F891 CJK COMPATIBILITY IDEOGRAPH-2F891
 * 	22331 ??
 * 2F892 CJK COMPATIBILITY IDEOGRAPH-2F892
 * 	22331 ??
 * 2F893 CJK COMPATIBILITY IDEOGRAPH-2F893
 * 	8201 ??
 * 2F894 CJK COMPATIBILITY IDEOGRAPH-2F894
 * 	5F22 ??
 * 2F895 CJK COMPATIBILITY IDEOGRAPH-2F895
 * 	5F22 ??
 * 2F896 CJK COMPATIBILITY IDEOGRAPH-2F896
 * 	38C7 ??
 * 2F897 CJK COMPATIBILITY IDEOGRAPH-2F897
 * 	232B8 ??
 * 2F898 CJK COMPATIBILITY IDEOGRAPH-2F898
 * 	261DA ??
 * 2F899 CJK COMPATIBILITY IDEOGRAPH-2F899
 * 	5F62 ??
 * 2F89A CJK COMPATIBILITY IDEOGRAPH-2F89A
 * 	5F6B ??
 * 2F89B CJK COMPATIBILITY IDEOGRAPH-2F89B
 * 	38E3 ??
 * 2F89C CJK COMPATIBILITY IDEOGRAPH-2F89C
 * 	5F9A ??
 * 2F89D CJK COMPATIBILITY IDEOGRAPH-2F89D
 * 	5FCD ??
 * 2F89E CJK COMPATIBILITY IDEOGRAPH-2F89E
 * 	5FD7 ??
 * 2F89F CJK COMPATIBILITY IDEOGRAPH-2F89F
 * 	5FF9 ??
 * 2F8A KANGXI RADICAL COLOR
 * 	8272 ??
 * 2F8A0 CJK COMPATIBILITY IDEOGRAPH-2F8A0
 * 	6081 ??
 * 2F8A1 CJK COMPATIBILITY IDEOGRAPH-2F8A1
 * 	393A ??
 * 2F8A2 CJK COMPATIBILITY IDEOGRAPH-2F8A2
 * 	391C ??
 * 2F8A3 CJK COMPATIBILITY IDEOGRAPH-2F8A3
 * 	6094 ??
 * 2F8A4 CJK COMPATIBILITY IDEOGRAPH-2F8A4
 * 	226D4 ??
 * 2F8A5 CJK COMPATIBILITY IDEOGRAPH-2F8A5
 * 	60C7 ??
 * 2F8A6 CJK COMPATIBILITY IDEOGRAPH-2F8A6
 * 	6148 ??
 * 2F8A7 CJK COMPATIBILITY IDEOGRAPH-2F8A7
 * 	614C ??
 * 2F8A8 CJK COMPATIBILITY IDEOGRAPH-2F8A8
 * 	614E ??
 * 2F8A9 CJK COMPATIBILITY IDEOGRAPH-2F8A9
 * 	614C ??
 * 2F8AA CJK COMPATIBILITY IDEOGRAPH-2F8AA
 * 	617A ??
 * 2F8AB CJK COMPATIBILITY IDEOGRAPH-2F8AB
 * 	618E ??
 * 2F8AC CJK COMPATIBILITY IDEOGRAPH-2F8AC
 * 	61B2 ??
 * 2F8AD CJK COMPATIBILITY IDEOGRAPH-2F8AD
 * 	61A4 ??
 * 2F8AE CJK COMPATIBILITY IDEOGRAPH-2F8AE
 * 	61AF ??
 * 2F8AF CJK COMPATIBILITY IDEOGRAPH-2F8AF
 * 	61DE ??
 * 2F8B KANGXI RADICAL GRASS
 * 	8278 ??
 * 2F8B0 CJK COMPATIBILITY IDEOGRAPH-2F8B0
 * 	61F2 ??
 * 2F8B1 CJK COMPATIBILITY IDEOGRAPH-2F8B1
 * 	61F6 ??
 * 2F8B2 CJK COMPATIBILITY IDEOGRAPH-2F8B2
 * 	6210 ??
 * 2F8B3 CJK COMPATIBILITY IDEOGRAPH-2F8B3
 * 	621B ??
 * 2F8B4 CJK COMPATIBILITY IDEOGRAPH-2F8B4
 * 	625D ??
 * 2F8B5 CJK COMPATIBILITY IDEOGRAPH-2F8B5
 * 	62B1 ??
 * 2F8B6 CJK COMPATIBILITY IDEOGRAPH-2F8B6
 * 	62D4 ??
 * 2F8B7 CJK COMPATIBILITY IDEOGRAPH-2F8B7
 * 	6350 ??
 * 2F8B8 CJK COMPATIBILITY IDEOGRAPH-2F8B8
 * 	22B0C ??
 * 2F8B9 CJK COMPATIBILITY IDEOGRAPH-2F8B9
 * 	633D ??
 * 2F8BA CJK COMPATIBILITY IDEOGRAPH-2F8BA
 * 	62FC ??
 * 2F8BB CJK COMPATIBILITY IDEOGRAPH-2F8BB
 * 	6368 ??
 * 2F8BC CJK COMPATIBILITY IDEOGRAPH-2F8BC
 * 	6383 ??
 * 2F8BD CJK COMPATIBILITY IDEOGRAPH-2F8BD
 * 	63E4 ??
 * 2F8BE CJK COMPATIBILITY IDEOGRAPH-2F8BE
 * 	22BF1 ??
 * 2F8BF CJK COMPATIBILITY IDEOGRAPH-2F8BF
 * 	6422 ??
 * 2F8C KANGXI RADICAL TIGER
 * 	864D ??
 * 2F8C0 CJK COMPATIBILITY IDEOGRAPH-2F8C0
 * 	63C5 ??
 * 2F8C1 CJK COMPATIBILITY IDEOGRAPH-2F8C1
 * 	63A9 ??
 * 2F8C2 CJK COMPATIBILITY IDEOGRAPH-2F8C2
 * 	3A2E ??
 * 2F8C3 CJK COMPATIBILITY IDEOGRAPH-2F8C3
 * 	6469 ??
 * 2F8C4 CJK COMPATIBILITY IDEOGRAPH-2F8C4
 * 	647E ??
 * 2F8C5 CJK COMPATIBILITY IDEOGRAPH-2F8C5
 * 	649D ??
 * 2F8C6 CJK COMPATIBILITY IDEOGRAPH-2F8C6
 * 	6477 ??
 * 2F8C7 CJK COMPATIBILITY IDEOGRAPH-2F8C7
 * 	3A6C ??
 * 2F8C8 CJK COMPATIBILITY IDEOGRAPH-2F8C8
 * 	654F ??
 * 2F8C9 CJK COMPATIBILITY IDEOGRAPH-2F8C9
 * 	656C ??
 * 2F8CA CJK COMPATIBILITY IDEOGRAPH-2F8CA
 * 	2300A ??
 * 2F8CB CJK COMPATIBILITY IDEOGRAPH-2F8CB
 * 	65E3 ??
 * 2F8CC CJK COMPATIBILITY IDEOGRAPH-2F8CC
 * 	66F8 ??
 * 2F8CD CJK COMPATIBILITY IDEOGRAPH-2F8CD
 * 	6649 ??
 * 2F8CE CJK COMPATIBILITY IDEOGRAPH-2F8CE
 * 	3B19 ??
 * 2F8CF CJK COMPATIBILITY IDEOGRAPH-2F8CF
 * 	6691 ??
 * 2F8D KANGXI RADICAL INSECT
 * 	866B ??
 * 2F8D0 CJK COMPATIBILITY IDEOGRAPH-2F8D0
 * 	3B08 ??
 * 2F8D1 CJK COMPATIBILITY IDEOGRAPH-2F8D1
 * 	3AE4 ??
 * 2F8D2 CJK COMPATIBILITY IDEOGRAPH-2F8D2
 * 	5192 ??
 * 2F8D3 CJK COMPATIBILITY IDEOGRAPH-2F8D3
 * 	5195 ??
 * 2F8D4 CJK COMPATIBILITY IDEOGRAPH-2F8D4
 * 	6700 ??
 * 2F8D5 CJK COMPATIBILITY IDEOGRAPH-2F8D5
 * 	669C ??
 * 2F8D6 CJK COMPATIBILITY IDEOGRAPH-2F8D6
 * 	80AD ??
 * 2F8D7 CJK COMPATIBILITY IDEOGRAPH-2F8D7
 * 	43D9 ??
 * 2F8D8 CJK COMPATIBILITY IDEOGRAPH-2F8D8
 * 	6717 ??
 * 2F8D9 CJK COMPATIBILITY IDEOGRAPH-2F8D9
 * 	671B ??
 * 2F8DA CJK COMPATIBILITY IDEOGRAPH-2F8DA
 * 	6721 ??
 * 2F8DB CJK COMPATIBILITY IDEOGRAPH-2F8DB
 * 	675E ??
 * 2F8DC CJK COMPATIBILITY IDEOGRAPH-2F8DC
 * 	6753 ??
 * 2F8DD CJK COMPATIBILITY IDEOGRAPH-2F8DD
 * 	233C3 ??
 * 2F8DE CJK COMPATIBILITY IDEOGRAPH-2F8DE
 * 	3B49 ??
 * 2F8DF CJK COMPATIBILITY IDEOGRAPH-2F8DF
 * 	67FA ??
 * 2F8E KANGXI RADICAL BLOOD
 * 	8840 ??
 * 2F8E0 CJK COMPATIBILITY IDEOGRAPH-2F8E0
 * 	6785 ??
 * 2F8E1 CJK COMPATIBILITY IDEOGRAPH-2F8E1
 * 	6852 ??
 * 2F8E2 CJK COMPATIBILITY IDEOGRAPH-2F8E2
 * 	6885 ??
 * 2F8E3 CJK COMPATIBILITY IDEOGRAPH-2F8E3
 * 	2346D ??
 * 2F8E4 CJK COMPATIBILITY IDEOGRAPH-2F8E4
 * 	688E ??
 * 2F8E5 CJK COMPATIBILITY IDEOGRAPH-2F8E5
 * 	681F ??
 * 2F8E6 CJK COMPATIBILITY IDEOGRAPH-2F8E6
 * 	6914 ??
 * 2F8E7 CJK COMPATIBILITY IDEOGRAPH-2F8E7
 * 	3B9D ??
 * 2F8E8 CJK COMPATIBILITY IDEOGRAPH-2F8E8
 * 	6942 ??
 * 2F8E9 CJK COMPATIBILITY IDEOGRAPH-2F8E9
 * 	69A3 ??
 * 2F8EA CJK COMPATIBILITY IDEOGRAPH-2F8EA
 * 	69EA ??
 * 2F8EB CJK COMPATIBILITY IDEOGRAPH-2F8EB
 * 	6AA8 ??
 * 2F8EC CJK COMPATIBILITY IDEOGRAPH-2F8EC
 * 	236A3 ??
 * 2F8ED CJK COMPATIBILITY IDEOGRAPH-2F8ED
 * 	6ADB ??
 * 2F8EE CJK COMPATIBILITY IDEOGRAPH-2F8EE
 * 	3C18 ??
 * 2F8EF CJK COMPATIBILITY IDEOGRAPH-2F8EF
 * 	6B21 ??
 * 2F8F KANGXI RADICAL WALK ENCLOSURE
 * 	884C ??
 * 2F8F0 CJK COMPATIBILITY IDEOGRAPH-2F8F0
 * 	238A7 ??
 * 2F8F1 CJK COMPATIBILITY IDEOGRAPH-2F8F1
 * 	6B54 ??
 * 2F8F2 CJK COMPATIBILITY IDEOGRAPH-2F8F2
 * 	3C4E ??
 * 2F8F3 CJK COMPATIBILITY IDEOGRAPH-2F8F3
 * 	6B72 ??
 * 2F8F4 CJK COMPATIBILITY IDEOGRAPH-2F8F4
 * 	6B9F ??
 * 2F8F5 CJK COMPATIBILITY IDEOGRAPH-2F8F5
 * 	6BBA ??
 * 2F8F6 CJK COMPATIBILITY IDEOGRAPH-2F8F6
 * 	6BBB ??
 * 2F8F7 CJK COMPATIBILITY IDEOGRAPH-2F8F7
 * 	23A8D ??
 * 2F8F8 CJK COMPATIBILITY IDEOGRAPH-2F8F8
 * 	21D0B ??
 * 2F8F9 CJK COMPATIBILITY IDEOGRAPH-2F8F9
 * 	23AFA ??
 * 2F8FA CJK COMPATIBILITY IDEOGRAPH-2F8FA
 * 	6C4E ??
 * 2F8FB CJK COMPATIBILITY IDEOGRAPH-2F8FB
 * 	23CBC ??
 * 2F8FC CJK COMPATIBILITY IDEOGRAPH-2F8FC
 * 	6CBF ??
 * 2F8FD CJK COMPATIBILITY IDEOGRAPH-2F8FD
 * 	6CCD ??
 * 2F8FE CJK COMPATIBILITY IDEOGRAPH-2F8FE
 * 	6C67 ??
 * 2F8FF CJK COMPATIBILITY IDEOGRAPH-2F8FF
 * 	6D16 ??
 * 2F90 KANGXI RADICAL CLOTHES
 * 	8863 ??
 * 2F900 CJK COMPATIBILITY IDEOGRAPH-2F900
 * 	6D3E ??
 * 2F901 CJK COMPATIBILITY IDEOGRAPH-2F901
 * 	6D77 ??
 * 2F902 CJK COMPATIBILITY IDEOGRAPH-2F902
 * 	6D41 ??
 * 2F903 CJK COMPATIBILITY IDEOGRAPH-2F903
 * 	6D69 ??
 * 2F904 CJK COMPATIBILITY IDEOGRAPH-2F904
 * 	6D78 ??
 * 2F905 CJK COMPATIBILITY IDEOGRAPH-2F905
 * 	6D85 ??
 * 2F906 CJK COMPATIBILITY IDEOGRAPH-2F906
 * 	23D1E ??
 * 2F907 CJK COMPATIBILITY IDEOGRAPH-2F907
 * 	6D34 ??
 * 2F908 CJK COMPATIBILITY IDEOGRAPH-2F908
 * 	6E2F ??
 * 2F909 CJK COMPATIBILITY IDEOGRAPH-2F909
 * 	6E6E ??
 * 2F90A CJK COMPATIBILITY IDEOGRAPH-2F90A
 * 	3D33 ??
 * 2F90B CJK COMPATIBILITY IDEOGRAPH-2F90B
 * 	6ECB ??
 * 2F90C CJK COMPATIBILITY IDEOGRAPH-2F90C
 * 	6EC7 ??
 * 2F90D CJK COMPATIBILITY IDEOGRAPH-2F90D
 * 	23ED1 ??
 * 2F90E CJK COMPATIBILITY IDEOGRAPH-2F90E
 * 	6DF9 ??
 * 2F90F CJK COMPATIBILITY IDEOGRAPH-2F90F
 * 	6F6E ??
 * 2F91 KANGXI RADICAL WEST
 * 	897E ??
 * 2F910 CJK COMPATIBILITY IDEOGRAPH-2F910
 * 	23F5E ??
 * 2F911 CJK COMPATIBILITY IDEOGRAPH-2F911
 * 	23F8E ??
 * 2F912 CJK COMPATIBILITY IDEOGRAPH-2F912
 * 	6FC6 ??
 * 2F913 CJK COMPATIBILITY IDEOGRAPH-2F913
 * 	7039 ??
 * 2F914 CJK COMPATIBILITY IDEOGRAPH-2F914
 * 	701E ??
 * 2F915 CJK COMPATIBILITY IDEOGRAPH-2F915
 * 	701B ??
 * 2F916 CJK COMPATIBILITY IDEOGRAPH-2F916
 * 	3D96 ??
 * 2F917 CJK COMPATIBILITY IDEOGRAPH-2F917
 * 	704A ??
 * 2F918 CJK COMPATIBILITY IDEOGRAPH-2F918
 * 	707D ??
 * 2F919 CJK COMPATIBILITY IDEOGRAPH-2F919
 * 	7077 ??
 * 2F91A CJK COMPATIBILITY IDEOGRAPH-2F91A
 * 	70AD ??
 * 2F91B CJK COMPATIBILITY IDEOGRAPH-2F91B
 * 	20525 ??
 * 2F91C CJK COMPATIBILITY IDEOGRAPH-2F91C
 * 	7145 ??
 * 2F91D CJK COMPATIBILITY IDEOGRAPH-2F91D
 * 	24263 ??
 * 2F91E CJK COMPATIBILITY IDEOGRAPH-2F91E
 * 	719C ??
 * 2F91F CJK COMPATIBILITY IDEOGRAPH-2F91F
 * 	43AB ??
 * 2F92 KANGXI RADICAL SEE
 * 	898B ??
 * 2F920 CJK COMPATIBILITY IDEOGRAPH-2F920
 * 	7228 ??
 * 2F921 CJK COMPATIBILITY IDEOGRAPH-2F921
 * 	7235 ??
 * 2F922 CJK COMPATIBILITY IDEOGRAPH-2F922
 * 	7250 ??
 * 2F923 CJK COMPATIBILITY IDEOGRAPH-2F923
 * 	24608 ??
 * 2F924 CJK COMPATIBILITY IDEOGRAPH-2F924
 * 	7280 ??
 * 2F925 CJK COMPATIBILITY IDEOGRAPH-2F925
 * 	7295 ??
 * 2F926 CJK COMPATIBILITY IDEOGRAPH-2F926
 * 	24735 ??
 * 2F927 CJK COMPATIBILITY IDEOGRAPH-2F927
 * 	24814 ??
 * 2F928 CJK COMPATIBILITY IDEOGRAPH-2F928
 * 	737A ??
 * 2F929 CJK COMPATIBILITY IDEOGRAPH-2F929
 * 	738B ??
 * 2F92A CJK COMPATIBILITY IDEOGRAPH-2F92A
 * 	3EAC ??
 * 2F92B CJK COMPATIBILITY IDEOGRAPH-2F92B
 * 	73A5 ??
 * 2F92C CJK COMPATIBILITY IDEOGRAPH-2F92C
 * 	3EB8 ??
 * 2F92D CJK COMPATIBILITY IDEOGRAPH-2F92D
 * 	3EB8 ??
 * 2F92E CJK COMPATIBILITY IDEOGRAPH-2F92E
 * 	7447 ??
 * 2F92F CJK COMPATIBILITY IDEOGRAPH-2F92F
 * 	745C ??
 * 2F93 KANGXI RADICAL HORN
 * 	89D2 ??
 * 2F930 CJK COMPATIBILITY IDEOGRAPH-2F930
 * 	7471 ??
 * 2F931 CJK COMPATIBILITY IDEOGRAPH-2F931
 * 	7485 ??
 * 2F932 CJK COMPATIBILITY IDEOGRAPH-2F932
 * 	74CA ??
 * 2F933 CJK COMPATIBILITY IDEOGRAPH-2F933
 * 	3F1B ??
 * 2F934 CJK COMPATIBILITY IDEOGRAPH-2F934
 * 	7524 ??
 * 2F935 CJK COMPATIBILITY IDEOGRAPH-2F935
 * 	24C36 ??
 * 2F936 CJK COMPATIBILITY IDEOGRAPH-2F936
 * 	753E ??
 * 2F937 CJK COMPATIBILITY IDEOGRAPH-2F937
 * 	24C92 ??
 * 2F938 CJK COMPATIBILITY IDEOGRAPH-2F938
 * 	7570 ??
 * 2F939 CJK COMPATIBILITY IDEOGRAPH-2F939
 * 	2219F ??
 * 2F93A CJK COMPATIBILITY IDEOGRAPH-2F93A
 * 	7610 ??
 * 2F93B CJK COMPATIBILITY IDEOGRAPH-2F93B
 * 	24FA1 ??
 * 2F93C CJK COMPATIBILITY IDEOGRAPH-2F93C
 * 	24FB8 ??
 * 2F93D CJK COMPATIBILITY IDEOGRAPH-2F93D
 * 	25044 ??
 * 2F93E CJK COMPATIBILITY IDEOGRAPH-2F93E
 * 	3FFC ??
 * 2F93F CJK COMPATIBILITY IDEOGRAPH-2F93F
 * 	4008 ??
 * 2F94 KANGXI RADICAL SPEECH
 * 	8A00 ??
 * 2F940 CJK COMPATIBILITY IDEOGRAPH-2F940
 * 	76F4 ??
 * 2F941 CJK COMPATIBILITY IDEOGRAPH-2F941
 * 	250F3 ??
 * 2F942 CJK COMPATIBILITY IDEOGRAPH-2F942
 * 	250F2 ??
 * 2F943 CJK COMPATIBILITY IDEOGRAPH-2F943
 * 	25119 ??
 * 2F944 CJK COMPATIBILITY IDEOGRAPH-2F944
 * 	25133 ??
 * 2F945 CJK COMPATIBILITY IDEOGRAPH-2F945
 * 	771E ??
 * 2F946 CJK COMPATIBILITY IDEOGRAPH-2F946
 * 	771F ??
 * 2F947 CJK COMPATIBILITY IDEOGRAPH-2F947
 * 	771F ??
 * 2F948 CJK COMPATIBILITY IDEOGRAPH-2F948
 * 	774A ??
 * 2F949 CJK COMPATIBILITY IDEOGRAPH-2F949
 * 	4039 ??
 * 2F94A CJK COMPATIBILITY IDEOGRAPH-2F94A
 * 	778B ??
 * 2F94B CJK COMPATIBILITY IDEOGRAPH-2F94B
 * 	4046 ??
 * 2F94C CJK COMPATIBILITY IDEOGRAPH-2F94C
 * 	4096 ??
 * 2F94D CJK COMPATIBILITY IDEOGRAPH-2F94D
 * 	2541D ??
 * 2F94E CJK COMPATIBILITY IDEOGRAPH-2F94E
 * 	784E ??
 * 2F94F CJK COMPATIBILITY IDEOGRAPH-2F94F
 * 	788C ??
 * 2F95 KANGXI RADICAL VALLEY
 * 	8C37 ??
 * 2F950 CJK COMPATIBILITY IDEOGRAPH-2F950
 * 	78CC ??
 * 2F951 CJK COMPATIBILITY IDEOGRAPH-2F951
 * 	40E3 ??
 * 2F952 CJK COMPATIBILITY IDEOGRAPH-2F952
 * 	25626 ??
 * 2F953 CJK COMPATIBILITY IDEOGRAPH-2F953
 * 	7956 ??
 * 2F954 CJK COMPATIBILITY IDEOGRAPH-2F954
 * 	2569A ??
 * 2F955 CJK COMPATIBILITY IDEOGRAPH-2F955
 * 	256C5 ??
 * 2F956 CJK COMPATIBILITY IDEOGRAPH-2F956
 * 	798F ??
 * 2F957 CJK COMPATIBILITY IDEOGRAPH-2F957
 * 	79EB ??
 * 2F958 CJK COMPATIBILITY IDEOGRAPH-2F958
 * 	412F ??
 * 2F959 CJK COMPATIBILITY IDEOGRAPH-2F959
 * 	7A40 ??
 * 2F95A CJK COMPATIBILITY IDEOGRAPH-2F95A
 * 	7A4A ??
 * 2F95B CJK COMPATIBILITY IDEOGRAPH-2F95B
 * 	7A4F ??
 * 2F95C CJK COMPATIBILITY IDEOGRAPH-2F95C
 * 	2597C ??
 * 2F95D CJK COMPATIBILITY IDEOGRAPH-2F95D
 * 	25AA7 ??
 * 2F95E CJK COMPATIBILITY IDEOGRAPH-2F95E
 * 	25AA7 ??
 * 2F95F CJK COMPATIBILITY IDEOGRAPH-2F95F
 * 	7AAE ??
 * 2F96 KANGXI RADICAL BEAN
 * 	8C46 ??
 * 2F960 CJK COMPATIBILITY IDEOGRAPH-2F960
 * 	4202 ??
 * 2F961 CJK COMPATIBILITY IDEOGRAPH-2F961
 * 	25BAB ??
 * 2F962 CJK COMPATIBILITY IDEOGRAPH-2F962
 * 	7BC6 ??
 * 2F963 CJK COMPATIBILITY IDEOGRAPH-2F963
 * 	7BC9 ??
 * 2F964 CJK COMPATIBILITY IDEOGRAPH-2F964
 * 	4227 ??
 * 2F965 CJK COMPATIBILITY IDEOGRAPH-2F965
 * 	25C80 ??
 * 2F966 CJK COMPATIBILITY IDEOGRAPH-2F966
 * 	7CD2 ??
 * 2F967 CJK COMPATIBILITY IDEOGRAPH-2F967
 * 	42A0 ??
 * 2F968 CJK COMPATIBILITY IDEOGRAPH-2F968
 * 	7CE8 ??
 * 2F969 CJK COMPATIBILITY IDEOGRAPH-2F969
 * 	7CE3 ??
 * 2F96A CJK COMPATIBILITY IDEOGRAPH-2F96A
 * 	7D00 ??
 * 2F96B CJK COMPATIBILITY IDEOGRAPH-2F96B
 * 	25F86 ??
 * 2F96C CJK COMPATIBILITY IDEOGRAPH-2F96C
 * 	7D63 ??
 * 2F96D CJK COMPATIBILITY IDEOGRAPH-2F96D
 * 	4301 ??
 * 2F96E CJK COMPATIBILITY IDEOGRAPH-2F96E
 * 	7DC7 ??
 * 2F96F CJK COMPATIBILITY IDEOGRAPH-2F96F
 * 	7E02 ??
 * 2F97 KANGXI RADICAL PIG
 * 	8C55 ??
 * 2F970 CJK COMPATIBILITY IDEOGRAPH-2F970
 * 	7E45 ??
 * 2F971 CJK COMPATIBILITY IDEOGRAPH-2F971
 * 	4334 ??
 * 2F972 CJK COMPATIBILITY IDEOGRAPH-2F972
 * 	26228 ??
 * 2F973 CJK COMPATIBILITY IDEOGRAPH-2F973
 * 	26247 ??
 * 2F974 CJK COMPATIBILITY IDEOGRAPH-2F974
 * 	4359 ??
 * 2F975 CJK COMPATIBILITY IDEOGRAPH-2F975
 * 	262D9 ??
 * 2F976 CJK COMPATIBILITY IDEOGRAPH-2F976
 * 	7F7A ??
 * 2F977 CJK COMPATIBILITY IDEOGRAPH-2F977
 * 	2633E ??
 * 2F978 CJK COMPATIBILITY IDEOGRAPH-2F978
 * 	7F95 ??
 * 2F979 CJK COMPATIBILITY IDEOGRAPH-2F979
 * 	7FFA ??
 * 2F97A CJK COMPATIBILITY IDEOGRAPH-2F97A
 * 	8005 ??
 * 2F97B CJK COMPATIBILITY IDEOGRAPH-2F97B
 * 	264DA ??
 * 2F97C CJK COMPATIBILITY IDEOGRAPH-2F97C
 * 	26523 ??
 * 2F97D CJK COMPATIBILITY IDEOGRAPH-2F97D
 * 	8060 ??
 * 2F97E CJK COMPATIBILITY IDEOGRAPH-2F97E
 * 	265A8 ??
 * 2F97F CJK COMPATIBILITY IDEOGRAPH-2F97F
 * 	8070 ??
 * 2F98 KANGXI RADICAL BADGER
 * 	8C78 ??
 * 2F980 CJK COMPATIBILITY IDEOGRAPH-2F980
 * 	2335F ??
 * 2F981 CJK COMPATIBILITY IDEOGRAPH-2F981
 * 	43D5 ??
 * 2F982 CJK COMPATIBILITY IDEOGRAPH-2F982
 * 	80B2 ??
 * 2F983 CJK COMPATIBILITY IDEOGRAPH-2F983
 * 	8103 ??
 * 2F984 CJK COMPATIBILITY IDEOGRAPH-2F984
 * 	440B ??
 * 2F985 CJK COMPATIBILITY IDEOGRAPH-2F985
 * 	813E ??
 * 2F986 CJK COMPATIBILITY IDEOGRAPH-2F986
 * 	5AB5 ??
 * 2F987 CJK COMPATIBILITY IDEOGRAPH-2F987
 * 	267A7 ??
 * 2F988 CJK COMPATIBILITY IDEOGRAPH-2F988
 * 	267B5 ??
 * 2F989 CJK COMPATIBILITY IDEOGRAPH-2F989
 * 	23393 ??
 * 2F98A CJK COMPATIBILITY IDEOGRAPH-2F98A
 * 	2339C ??
 * 2F98B CJK COMPATIBILITY IDEOGRAPH-2F98B
 * 	8201 ??
 * 2F98C CJK COMPATIBILITY IDEOGRAPH-2F98C
 * 	8204 ??
 * 2F98D CJK COMPATIBILITY IDEOGRAPH-2F98D
 * 	8F9E ??
 * 2F98E CJK COMPATIBILITY IDEOGRAPH-2F98E
 * 	446B ??
 * 2F98F CJK COMPATIBILITY IDEOGRAPH-2F98F
 * 	8291 ??
 * 2F99 KANGXI RADICAL SHELL
 * 	8C9D ??
 * 2F990 CJK COMPATIBILITY IDEOGRAPH-2F990
 * 	828B ??
 * 2F991 CJK COMPATIBILITY IDEOGRAPH-2F991
 * 	829D ??
 * 2F992 CJK COMPATIBILITY IDEOGRAPH-2F992
 * 	52B3 ??
 * 2F993 CJK COMPATIBILITY IDEOGRAPH-2F993
 * 	82B1 ??
 * 2F994 CJK COMPATIBILITY IDEOGRAPH-2F994
 * 	82B3 ??
 * 2F995 CJK COMPATIBILITY IDEOGRAPH-2F995
 * 	82BD ??
 * 2F996 CJK COMPATIBILITY IDEOGRAPH-2F996
 * 	82E6 ??
 * 2F997 CJK COMPATIBILITY IDEOGRAPH-2F997
 * 	26B3C ??
 * 2F998 CJK COMPATIBILITY IDEOGRAPH-2F998
 * 	82E5 ??
 * 2F999 CJK COMPATIBILITY IDEOGRAPH-2F999
 * 	831D ??
 * 2F99A CJK COMPATIBILITY IDEOGRAPH-2F99A
 * 	8363 ??
 * 2F99B CJK COMPATIBILITY IDEOGRAPH-2F99B
 * 	83AD ??
 * 2F99C CJK COMPATIBILITY IDEOGRAPH-2F99C
 * 	8323 ??
 * 2F99D CJK COMPATIBILITY IDEOGRAPH-2F99D
 * 	83BD ??
 * 2F99E CJK COMPATIBILITY IDEOGRAPH-2F99E
 * 	83E7 ??
 * 2F99F CJK COMPATIBILITY IDEOGRAPH-2F99F
 * 	8457 ??
 * 2F9A KANGXI RADICAL RED
 * 	8D64 ??
 * 2F9A0 CJK COMPATIBILITY IDEOGRAPH-2F9A0
 * 	8353 ??
 * 2F9A1 CJK COMPATIBILITY IDEOGRAPH-2F9A1
 * 	83CA ??
 * 2F9A2 CJK COMPATIBILITY IDEOGRAPH-2F9A2
 * 	83CC ??
 * 2F9A3 CJK COMPATIBILITY IDEOGRAPH-2F9A3
 * 	83DC ??
 * 2F9A4 CJK COMPATIBILITY IDEOGRAPH-2F9A4
 * 	26C36 ??
 * 2F9A5 CJK COMPATIBILITY IDEOGRAPH-2F9A5
 * 	26D6B ??
 * 2F9A6 CJK COMPATIBILITY IDEOGRAPH-2F9A6
 * 	26CD5 ??
 * 2F9A7 CJK COMPATIBILITY IDEOGRAPH-2F9A7
 * 	452B ??
 * 2F9A8 CJK COMPATIBILITY IDEOGRAPH-2F9A8
 * 	84F1 ??
 * 2F9A9 CJK COMPATIBILITY IDEOGRAPH-2F9A9
 * 	84F3 ??
 * 2F9AA CJK COMPATIBILITY IDEOGRAPH-2F9AA
 * 	8516 ??
 * 2F9AB CJK COMPATIBILITY IDEOGRAPH-2F9AB
 * 	273CA ??
 * 2F9AC CJK COMPATIBILITY IDEOGRAPH-2F9AC
 * 	8564 ??
 * 2F9AD CJK COMPATIBILITY IDEOGRAPH-2F9AD
 * 	26F2C ??
 * 2F9AE CJK COMPATIBILITY IDEOGRAPH-2F9AE
 * 	455D ??
 * 2F9AF CJK COMPATIBILITY IDEOGRAPH-2F9AF
 * 	4561 ??
 * 2F9B KANGXI RADICAL RUN
 * 	8D70 ??
 * 2F9B0 CJK COMPATIBILITY IDEOGRAPH-2F9B0
 * 	26FB1 ??
 * 2F9B1 CJK COMPATIBILITY IDEOGRAPH-2F9B1
 * 	270D2 ??
 * 2F9B2 CJK COMPATIBILITY IDEOGRAPH-2F9B2
 * 	456B ??
 * 2F9B3 CJK COMPATIBILITY IDEOGRAPH-2F9B3
 * 	8650 ??
 * 2F9B4 CJK COMPATIBILITY IDEOGRAPH-2F9B4
 * 	865C ??
 * 2F9B5 CJK COMPATIBILITY IDEOGRAPH-2F9B5
 * 	8667 ??
 * 2F9B6 CJK COMPATIBILITY IDEOGRAPH-2F9B6
 * 	8669 ??
 * 2F9B7 CJK COMPATIBILITY IDEOGRAPH-2F9B7
 * 	86A9 ??
 * 2F9B8 CJK COMPATIBILITY IDEOGRAPH-2F9B8
 * 	8688 ??
 * 2F9B9 CJK COMPATIBILITY IDEOGRAPH-2F9B9
 * 	870E ??
 * 2F9BA CJK COMPATIBILITY IDEOGRAPH-2F9BA
 * 	86E2 ??
 * 2F9BB CJK COMPATIBILITY IDEOGRAPH-2F9BB
 * 	8779 ??
 * 2F9BC CJK COMPATIBILITY IDEOGRAPH-2F9BC
 * 	8728 ??
 * 2F9BD CJK COMPATIBILITY IDEOGRAPH-2F9BD
 * 	876B ??
 * 2F9BE CJK COMPATIBILITY IDEOGRAPH-2F9BE
 * 	8786 ??
 * 2F9BF CJK COMPATIBILITY IDEOGRAPH-2F9BF
 * 	4D57 ??
 * 2F9C KANGXI RADICAL FOOT
 * 	8DB3 ??
 * 2F9C0 CJK COMPATIBILITY IDEOGRAPH-2F9C0
 * 	87E1 ??
 * 2F9C1 CJK COMPATIBILITY IDEOGRAPH-2F9C1
 * 	8801 ??
 * 2F9C2 CJK COMPATIBILITY IDEOGRAPH-2F9C2
 * 	45F9 ??
 * 2F9C3 CJK COMPATIBILITY IDEOGRAPH-2F9C3
 * 	8860 ??
 * 2F9C4 CJK COMPATIBILITY IDEOGRAPH-2F9C4
 * 	8863 ??
 * 2F9C5 CJK COMPATIBILITY IDEOGRAPH-2F9C5
 * 	27667 ??
 * 2F9C6 CJK COMPATIBILITY IDEOGRAPH-2F9C6
 * 	88D7 ??
 * 2F9C7 CJK COMPATIBILITY IDEOGRAPH-2F9C7
 * 	88DE ??
 * 2F9C8 CJK COMPATIBILITY IDEOGRAPH-2F9C8
 * 	4635 ??
 * 2F9C9 CJK COMPATIBILITY IDEOGRAPH-2F9C9
 * 	88FA ??
 * 2F9CA CJK COMPATIBILITY IDEOGRAPH-2F9CA
 * 	34BB ??
 * 2F9CB CJK COMPATIBILITY IDEOGRAPH-2F9CB
 * 	278AE ??
 * 2F9CC CJK COMPATIBILITY IDEOGRAPH-2F9CC
 * 	27966 ??
 * 2F9CD CJK COMPATIBILITY IDEOGRAPH-2F9CD
 * 	46BE ??
 * 2F9CE CJK COMPATIBILITY IDEOGRAPH-2F9CE
 * 	46C7 ??
 * 2F9CF CJK COMPATIBILITY IDEOGRAPH-2F9CF
 * 	8AA0 ??
 * 2F9D KANGXI RADICAL BODY
 * 	8EAB ??
 * 2F9D0 CJK COMPATIBILITY IDEOGRAPH-2F9D0
 * 	8AED ??
 * 2F9D1 CJK COMPATIBILITY IDEOGRAPH-2F9D1
 * 	8B8A ??
 * 2F9D2 CJK COMPATIBILITY IDEOGRAPH-2F9D2
 * 	8C55 ??
 * 2F9D3 CJK COMPATIBILITY IDEOGRAPH-2F9D3
 * 	27CA8 ??
 * 2F9D4 CJK COMPATIBILITY IDEOGRAPH-2F9D4
 * 	8CAB ??
 * 2F9D5 CJK COMPATIBILITY IDEOGRAPH-2F9D5
 * 	8CC1 ??
 * 2F9D6 CJK COMPATIBILITY IDEOGRAPH-2F9D6
 * 	8D1B ??
 * 2F9D7 CJK COMPATIBILITY IDEOGRAPH-2F9D7
 * 	8D77 ??
 * 2F9D8 CJK COMPATIBILITY IDEOGRAPH-2F9D8
 * 	27F2F ??
 * 2F9D9 CJK COMPATIBILITY IDEOGRAPH-2F9D9
 * 	20804 ??
 * 2F9DA CJK COMPATIBILITY IDEOGRAPH-2F9DA
 * 	8DCB ??
 * 2F9DB CJK COMPATIBILITY IDEOGRAPH-2F9DB
 * 	8DBC ??
 * 2F9DC CJK COMPATIBILITY IDEOGRAPH-2F9DC
 * 	8DF0 ??
 * 2F9DD CJK COMPATIBILITY IDEOGRAPH-2F9DD
 * 	208DE ??
 * 2F9DE CJK COMPATIBILITY IDEOGRAPH-2F9DE
 * 	8ED4 ??
 * 2F9DF CJK COMPATIBILITY IDEOGRAPH-2F9DF
 * 	8F38 ??
 * 2F9E KANGXI RADICAL CART
 * 	8ECA ??
 * 2F9E0 CJK COMPATIBILITY IDEOGRAPH-2F9E0
 * 	285D2 ??
 * 2F9E1 CJK COMPATIBILITY IDEOGRAPH-2F9E1
 * 	285ED ??
 * 2F9E2 CJK COMPATIBILITY IDEOGRAPH-2F9E2
 * 	9094 ??
 * 2F9E3 CJK COMPATIBILITY IDEOGRAPH-2F9E3
 * 	90F1 ??
 * 2F9E4 CJK COMPATIBILITY IDEOGRAPH-2F9E4
 * 	9111 ??
 * 2F9E5 CJK COMPATIBILITY IDEOGRAPH-2F9E5
 * 	2872E ??
 * 2F9E6 CJK COMPATIBILITY IDEOGRAPH-2F9E6
 * 	911B ??
 * 2F9E7 CJK COMPATIBILITY IDEOGRAPH-2F9E7
 * 	9238 ??
 * 2F9E8 CJK COMPATIBILITY IDEOGRAPH-2F9E8
 * 	92D7 ??
 * 2F9E9 CJK COMPATIBILITY IDEOGRAPH-2F9E9
 * 	92D8 ??
 * 2F9EA CJK COMPATIBILITY IDEOGRAPH-2F9EA
 * 	927C ??
 * 2F9EB CJK COMPATIBILITY IDEOGRAPH-2F9EB
 * 	93F9 ??
 * 2F9EC CJK COMPATIBILITY IDEOGRAPH-2F9EC
 * 	9415 ??
 * 2F9ED CJK COMPATIBILITY IDEOGRAPH-2F9ED
 * 	28BFA ??
 * 2F9EE CJK COMPATIBILITY IDEOGRAPH-2F9EE
 * 	958B ??
 * 2F9EF CJK COMPATIBILITY IDEOGRAPH-2F9EF
 * 	4995 ??
 * 2F9F KANGXI RADICAL BITTER
 * 	8F9B ??
 * 2F9F0 CJK COMPATIBILITY IDEOGRAPH-2F9F0
 * 	95B7 ??
 * 2F9F1 CJK COMPATIBILITY IDEOGRAPH-2F9F1
 * 	28D77 ??
 * 2F9F2 CJK COMPATIBILITY IDEOGRAPH-2F9F2
 * 	49E6 ??
 * 2F9F3 CJK COMPATIBILITY IDEOGRAPH-2F9F3
 * 	96C3 ??
 * 2F9F4 CJK COMPATIBILITY IDEOGRAPH-2F9F4
 * 	5DB2 ??
 * 2F9F5 CJK COMPATIBILITY IDEOGRAPH-2F9F5
 * 	9723 ??
 * 2F9F6 CJK COMPATIBILITY IDEOGRAPH-2F9F6
 * 	29145 ??
 * 2F9F7 CJK COMPATIBILITY IDEOGRAPH-2F9F7
 * 	2921A ??
 * 2F9F8 CJK COMPATIBILITY IDEOGRAPH-2F9F8
 * 	4A6E ??
 * 2F9F9 CJK COMPATIBILITY IDEOGRAPH-2F9F9
 * 	4A76 ??
 * 2F9FA CJK COMPATIBILITY IDEOGRAPH-2F9FA
 * 	97E0 ??
 * 2F9FB CJK COMPATIBILITY IDEOGRAPH-2F9FB
 * 	2940A ??
 * 2F9FC CJK COMPATIBILITY IDEOGRAPH-2F9FC
 * 	4AB2 ??
 * 2F9FD CJK COMPATIBILITY IDEOGRAPH-2F9FD
 * 	29496 ??
 * 2F9FE CJK COMPATIBILITY IDEOGRAPH-2F9FE
 * 	980B ??
 * 2F9FF CJK COMPATIBILITY IDEOGRAPH-2F9FF
 * 	980B ??
 * 2FA0 KANGXI RADICAL MORNING
 * 	8FB0 ??
 * 2FA00 CJK COMPATIBILITY IDEOGRAPH-2FA00
 * 	9829 ??
 * 2FA01 CJK COMPATIBILITY IDEOGRAPH-2FA01
 * 	295B6 ??
 * 2FA02 CJK COMPATIBILITY IDEOGRAPH-2FA02
 * 	98E2 ??
 * 2FA03 CJK COMPATIBILITY IDEOGRAPH-2FA03
 * 	4B33 ??
 * 2FA04 CJK COMPATIBILITY IDEOGRAPH-2FA04
 * 	9929 ??
 * 2FA05 CJK COMPATIBILITY IDEOGRAPH-2FA05
 * 	99A7 ??
 * 2FA06 CJK COMPATIBILITY IDEOGRAPH-2FA06
 * 	99C2 ??
 * 2FA07 CJK COMPATIBILITY IDEOGRAPH-2FA07
 * 	99FE ??
 * 2FA08 CJK COMPATIBILITY IDEOGRAPH-2FA08
 * 	4BCE ??
 * 2FA09 CJK COMPATIBILITY IDEOGRAPH-2FA09
 * 	29B30 ??
 * 2FA0A CJK COMPATIBILITY IDEOGRAPH-2FA0A
 * 	9B12 ??
 * 2FA0B CJK COMPATIBILITY IDEOGRAPH-2FA0B
 * 	9C40 ??
 * 2FA0C CJK COMPATIBILITY IDEOGRAPH-2FA0C
 * 	9CFD ??
 * 2FA0D CJK COMPATIBILITY IDEOGRAPH-2FA0D
 * 	4CCE ??
 * 2FA0E CJK COMPATIBILITY IDEOGRAPH-2FA0E
 * 	4CED ??
 * 2FA0F CJK COMPATIBILITY IDEOGRAPH-2FA0F
 * 	9D67 ??
 * 2FA1 KANGXI RADICAL WALK
 * 	8FB5 ??
 * 2FA10 CJK COMPATIBILITY IDEOGRAPH-2FA10
 * 	2A0CE ??
 * 2FA11 CJK COMPATIBILITY IDEOGRAPH-2FA11
 * 	4CF8 ??
 * 2FA12 CJK COMPATIBILITY IDEOGRAPH-2FA12
 * 	2A105 ??
 * 2FA13 CJK COMPATIBILITY IDEOGRAPH-2FA13
 * 	2A20E ??
 * 2FA14 CJK COMPATIBILITY IDEOGRAPH-2FA14
 * 	2A291 ??
 * 2FA15 CJK COMPATIBILITY IDEOGRAPH-2FA15
 * 	9EBB ??
 * 2FA16 CJK COMPATIBILITY IDEOGRAPH-2FA16
 * 	4D56 ??
 * 2FA17 CJK COMPATIBILITY IDEOGRAPH-2FA17
 * 	9EF9 ??
 * 2FA18 CJK COMPATIBILITY IDEOGRAPH-2FA18
 * 	9EFE ??
 * 2FA19 CJK COMPATIBILITY IDEOGRAPH-2FA19
 * 	9F05 ??
 * 2FA1A CJK COMPATIBILITY IDEOGRAPH-2FA1A
 * 	9F0F ??
 * 2FA1B CJK COMPATIBILITY IDEOGRAPH-2FA1B
 * 	9F16 ??
 * 2FA1C CJK COMPATIBILITY IDEOGRAPH-2FA1C
 * 	9F3B ??
 * 2FA1D CJK COMPATIBILITY IDEOGRAPH-2FA1D
 * 	2A600 ??
 * 2FA2 KANGXI RADICAL CITY
 * 	9091 ??
 * 2FA3 KANGXI RADICAL WINE
 * 	9149 ??
 * 2FA4 KANGXI RADICAL DISTINGUISH
 * 	91C6 ??
 * 2FA5 KANGXI RADICAL VILLAGE
 * 	91CC ??
 * 2FA6 KANGXI RADICAL GOLD
 * 	91D1 ??
 * 2FA7 KANGXI RADICAL LONG
 * 	9577 ??
 * 2FA8 KANGXI RADICAL GATE
 * 	9580 ??
 * 2FA9 KANGXI RADICAL MOUND
 * 	961C ??
 * 2FAA KANGXI RADICAL SLAVE
 * 	96B6 ??
 * 2FAB KANGXI RADICAL SHORT TAILED BIRD
 * 	96B9 ??
 * 2FAC KANGXI RADICAL RAIN
 * 	96E8 ??
 * 2FAD KANGXI RADICAL BLUE
 * 	9751 ??
 * 2FAE KANGXI RADICAL WRONG
 * 	975E ??
 * 2FAF KANGXI RADICAL FACE
 * 	9762 ??
 * 2FB0 KANGXI RADICAL LEATHER
 * 	9769 ??
 * 2FB1 KANGXI RADICAL TANNED LEATHER
 * 	97CB ??
 * 2FB2 KANGXI RADICAL LEEK
 * 	97ED ??
 * 2FB3 KANGXI RADICAL SOUND
 * 	97F3 ??
 * 2FB4 KANGXI RADICAL LEAF
 * 	9801 ??
 * 2FB5 KANGXI RADICAL WIND
 * 	98A8 ??
 * 2FB6 KANGXI RADICAL FLY
 * 	98DB ??
 * 2FB7 KANGXI RADICAL EAT
 * 	98DF ??
 * 2FB8 KANGXI RADICAL HEAD
 * 	9996 ??
 * 2FB9 KANGXI RADICAL FRAGRANT
 * 	9999 ??
 * 2FBA KANGXI RADICAL HORSE
 * 	99AC ??
 * 2FBB KANGXI RADICAL BONE
 * 	9AA8 ??
 * 2FBC KANGXI RADICAL TALL
 * 	9AD8 ??
 * 2FBD KANGXI RADICAL HAIR
 * 	9ADF ??
 * 2FBE KANGXI RADICAL FIGHT
 * 	9B25 ??
 * 2FBF KANGXI RADICAL SACRIFICIAL WINE
 * 	9B2F ??
 * 2FC0 KANGXI RADICAL CAULDRON
 * 	9B32 ??
 * 2FC1 KANGXI RADICAL GHOST
 * 	9B3C ??
 * 2FC2 KANGXI RADICAL FISH
 * 	9B5A ??
 * 2FC3 KANGXI RADICAL BIRD
 * 	9CE5 ??
 * 2FC4 KANGXI RADICAL SALT
 * 	9E75 ??
 * 2FC5 KANGXI RADICAL DEER
 * 	9E7F ??
 * 2FC6 KANGXI RADICAL WHEAT
 * 	9EA5 ??
 * 2FC7 KANGXI RADICAL HEMP
 * 	9EBB ??
 * 2FC8 KANGXI RADICAL YELLOW
 * 	9EC3 ??
 * 2FC9 KANGXI RADICAL MILLET
 * 	9ECD ??
 * 2FCA KANGXI RADICAL BLACK
 * 	9ED1 ??
 * 2FCB KANGXI RADICAL EMBROIDERY
 * 	9EF9 ??
 * 2FCC KANGXI RADICAL FROG
 * 	9EFD ??
 * 2FCD KANGXI RADICAL TRIPOD
 * 	9F0E ??
 * 2FCE KANGXI RADICAL DRUM
 * 	9F13 ??
 * 2FCF KANGXI RADICAL RAT
 * 	9F20 ??
 * 2FD0 KANGXI RADICAL NOSE
 * 	9F3B ??
 * 2FD1 KANGXI RADICAL EVEN
 * 	9F4A ??
 * 2FD2 KANGXI RADICAL TOOTH
 * 	9F52 ??
 * 2FD3 KANGXI RADICAL DRAGON
 * 	9F8D ??
 * 2FD4 KANGXI RADICAL TURTLE
 * 	9F9C ??
 * 2FD5 KANGXI RADICAL FLUTE
 * 	9FA0 ??
 * 3000 IDEOGRAPHIC SPACE
 * 	0020 SPACE
 * 3036 CIRCLED POSTAL MARK
 * 	3012 POSTAL MARK
 * 3038 HANGZHOU NUMERAL TEN
 * 	5341 ??
 * 3039 HANGZHOU NUMERAL TWENTY
 * 	5344 ??
 * 303A HANGZHOU NUMERAL THIRTY
 * 	5345 ??
 * 304C HIRAGANA LETTER GA
 * 	304B HIRAGANA LETTER KA
 * 304E HIRAGANA LETTER GI
 * 	304D HIRAGANA LETTER KI
 * 3050 HIRAGANA LETTER GU
 * 	304F HIRAGANA LETTER KU
 * 3052 HIRAGANA LETTER GE
 * 	3051 HIRAGANA LETTER KE
 * 3054 HIRAGANA LETTER GO
 * 	3053 HIRAGANA LETTER KO
 * 3056 HIRAGANA LETTER ZA
 * 	3055 HIRAGANA LETTER SA
 * 3058 HIRAGANA LETTER ZI
 * 	3057 HIRAGANA LETTER SI
 * 305A HIRAGANA LETTER ZU
 * 	3059 HIRAGANA LETTER SU
 * 305C HIRAGANA LETTER ZE
 * 	305B HIRAGANA LETTER SE
 * 305E HIRAGANA LETTER ZO
 * 	305D HIRAGANA LETTER SO
 * 3060 HIRAGANA LETTER DA
 * 	305F HIRAGANA LETTER TA
 * 3062 HIRAGANA LETTER DI
 * 	3061 HIRAGANA LETTER TI
 * 3065 HIRAGANA LETTER DU
 * 	3064 HIRAGANA LETTER TU
 * 3067 HIRAGANA LETTER DE
 * 	3066 HIRAGANA LETTER TE
 * 3069 HIRAGANA LETTER DO
 * 	3068 HIRAGANA LETTER TO
 * 3070 HIRAGANA LETTER BA
 * 	306F HIRAGANA LETTER HA
 * 3071 HIRAGANA LETTER PA
 * 	306F HIRAGANA LETTER HA
 * 3073 HIRAGANA LETTER BI
 * 	3072 HIRAGANA LETTER HI
 * 3074 HIRAGANA LETTER PI
 * 	3072 HIRAGANA LETTER HI
 * 3076 HIRAGANA LETTER BU
 * 	3075 HIRAGANA LETTER HU
 * 3077 HIRAGANA LETTER PU
 * 	3075 HIRAGANA LETTER HU
 * 3079 HIRAGANA LETTER BE
 * 	3078 HIRAGANA LETTER HE
 * 307A HIRAGANA LETTER PE
 * 	3078 HIRAGANA LETTER HE
 * 307C HIRAGANA LETTER BO
 * 	307B HIRAGANA LETTER HO
 * 307D HIRAGANA LETTER PO
 * 	307B HIRAGANA LETTER HO
 * 3094 HIRAGANA LETTER VU
 * 	3046 HIRAGANA LETTER U
 * 309B KATAKANA-HIRAGANA VOICED SOUND MARK
 * 	0020 SPACE
 * 309C KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
 * 	0020 SPACE
 * 309E HIRAGANA VOICED ITERATION MARK
 * 	309D HIRAGANA ITERATION MARK
 * 309F HIRAGANA DIGRAPH YORI
 * 	3088 HIRAGANA LETTER YO
 * 	308A HIRAGANA LETTER RI
 * 30AC KATAKANA LETTER GA
 * 	30AB KATAKANA LETTER KA
 * 30AE KATAKANA LETTER GI
 * 	30AD KATAKANA LETTER KI
 * 30B0 KATAKANA LETTER GU
 * 	30AF KATAKANA LETTER KU
 * 30B2 KATAKANA LETTER GE
 * 	30B1 KATAKANA LETTER KE
 * 30B4 KATAKANA LETTER GO
 * 	30B3 KATAKANA LETTER KO
 * 30B6 KATAKANA LETTER ZA
 * 	30B5 KATAKANA LETTER SA
 * 30B8 KATAKANA LETTER ZI
 * 	30B7 KATAKANA LETTER SI
 * 30BA KATAKANA LETTER ZU
 * 	30B9 KATAKANA LETTER SU
 * 30BC KATAKANA LETTER ZE
 * 	30BB KATAKANA LETTER SE
 * 30BE KATAKANA LETTER ZO
 * 	30BD KATAKANA LETTER SO
 * 30C0 KATAKANA LETTER DA
 * 	30BF KATAKANA LETTER TA
 * 30C2 KATAKANA LETTER DI
 * 	30C1 KATAKANA LETTER TI
 * 30C5 KATAKANA LETTER DU
 * 	30C4 KATAKANA LETTER TU
 * 30C7 KATAKANA LETTER DE
 * 	30C6 KATAKANA LETTER TE
 * 30C9 KATAKANA LETTER DO
 * 	30C8 KATAKANA LETTER TO
 * 30D0 KATAKANA LETTER BA
 * 	30CF KATAKANA LETTER HA
 * 30D1 KATAKANA LETTER PA
 * 	30CF KATAKANA LETTER HA
 * 30D3 KATAKANA LETTER BI
 * 	30D2 KATAKANA LETTER HI
 * 30D4 KATAKANA LETTER PI
 * 	30D2 KATAKANA LETTER HI
 * 30D6 KATAKANA LETTER BU
 * 	30D5 KATAKANA LETTER HU
 * 30D7 KATAKANA LETTER PU
 * 	30D5 KATAKANA LETTER HU
 * 30D9 KATAKANA LETTER BE
 * 	30D8 KATAKANA LETTER HE
 * 30DA KATAKANA LETTER PE
 * 	30D8 KATAKANA LETTER HE
 * 30DC KATAKANA LETTER BO
 * 	30DB KATAKANA LETTER HO
 * 30DD KATAKANA LETTER PO
 * 	30DB KATAKANA LETTER HO
 * 30F4 KATAKANA LETTER VU
 * 	30A6 KATAKANA LETTER U
 * 30F7 KATAKANA LETTER VA
 * 	30EF KATAKANA LETTER WA
 * 30F8 KATAKANA LETTER VI
 * 	30F0 KATAKANA LETTER WI
 * 30F9 KATAKANA LETTER VE
 * 	30F1 KATAKANA LETTER WE
 * 30FA KATAKANA LETTER VO
 * 	30F2 KATAKANA LETTER WO
 * 30FE KATAKANA VOICED ITERATION MARK
 * 	30FD KATAKANA ITERATION MARK
 * 30FF KATAKANA DIGRAPH KOTO
 * 	30B3 KATAKANA LETTER KO
 * 	30C8 KATAKANA LETTER TO
 * 3131 HANGUL LETTER KIYEOK
 * 	1100 HANGUL CHOSEONG KIYEOK
 * 3132 HANGUL LETTER SSANGKIYEOK
 * 	1101 HANGUL CHOSEONG SSANGKIYEOK
 * 3133 HANGUL LETTER KIYEOK-SIOS
 * 	11AA HANGUL JONGSEONG KIYEOK-SIOS
 * 3134 HANGUL LETTER NIEUN
 * 	1102 HANGUL CHOSEONG NIEUN
 * 3135 HANGUL LETTER NIEUN-CIEUC
 * 	11AC HANGUL JONGSEONG NIEUN-CIEUC
 * 3136 HANGUL LETTER NIEUN-HIEUH
 * 	11AD HANGUL JONGSEONG NIEUN-HIEUH
 * 3137 HANGUL LETTER TIKEUT
 * 	1103 HANGUL CHOSEONG TIKEUT
 * 3138 HANGUL LETTER SSANGTIKEUT
 * 	1104 HANGUL CHOSEONG SSANGTIKEUT
 * 3139 HANGUL LETTER RIEUL
 * 	1105 HANGUL CHOSEONG RIEUL
 * 313A HANGUL LETTER RIEUL-KIYEOK
 * 	11B0 HANGUL JONGSEONG RIEUL-KIYEOK
 * 313B HANGUL LETTER RIEUL-MIEUM
 * 	11B1 HANGUL JONGSEONG RIEUL-MIEUM
 * 313C HANGUL LETTER RIEUL-PIEUP
 * 	11B2 HANGUL JONGSEONG RIEUL-PIEUP
 * 313D HANGUL LETTER RIEUL-SIOS
 * 	11B3 HANGUL JONGSEONG RIEUL-SIOS
 * 313E HANGUL LETTER RIEUL-THIEUTH
 * 	11B4 HANGUL JONGSEONG RIEUL-THIEUTH
 * 313F HANGUL LETTER RIEUL-PHIEUPH
 * 	11B5 HANGUL JONGSEONG RIEUL-PHIEUPH
 * 3140 HANGUL LETTER RIEUL-HIEUH
 * 	111A HANGUL CHOSEONG RIEUL-HIEUH
 * 3141 HANGUL LETTER MIEUM
 * 	1106 HANGUL CHOSEONG MIEUM
 * 3142 HANGUL LETTER PIEUP
 * 	1107 HANGUL CHOSEONG PIEUP
 * 3143 HANGUL LETTER SSANGPIEUP
 * 	1108 HANGUL CHOSEONG SSANGPIEUP
 * 3144 HANGUL LETTER PIEUP-SIOS
 * 	1121 HANGUL CHOSEONG PIEUP-SIOS
 * 3145 HANGUL LETTER SIOS
 * 	1109 HANGUL CHOSEONG SIOS
 * 3146 HANGUL LETTER SSANGSIOS
 * 	110A HANGUL CHOSEONG SSANGSIOS
 * 3147 HANGUL LETTER IEUNG
 * 	110B HANGUL CHOSEONG IEUNG
 * 3148 HANGUL LETTER CIEUC
 * 	110C HANGUL CHOSEONG CIEUC
 * 3149 HANGUL LETTER SSANGCIEUC
 * 	110D HANGUL CHOSEONG SSANGCIEUC
 * 314A HANGUL LETTER CHIEUCH
 * 	110E HANGUL CHOSEONG CHIEUCH
 * 314B HANGUL LETTER KHIEUKH
 * 	110F HANGUL CHOSEONG KHIEUKH
 * 314C HANGUL LETTER THIEUTH
 * 	1110 HANGUL CHOSEONG THIEUTH
 * 314D HANGUL LETTER PHIEUPH
 * 	1111 HANGUL CHOSEONG PHIEUPH
 * 314E HANGUL LETTER HIEUH
 * 	1112 HANGUL CHOSEONG HIEUH
 * 314F HANGUL LETTER A
 * 	1161 HANGUL JUNGSEONG A
 * 3150 HANGUL LETTER AE
 * 	1162 HANGUL JUNGSEONG AE
 * 3151 HANGUL LETTER YA
 * 	1163 HANGUL JUNGSEONG YA
 * 3152 HANGUL LETTER YAE
 * 	1164 HANGUL JUNGSEONG YAE
 * 3153 HANGUL LETTER EO
 * 	1165 HANGUL JUNGSEONG EO
 * 3154 HANGUL LETTER E
 * 	1166 HANGUL JUNGSEONG E
 * 3155 HANGUL LETTER YEO
 * 	1167 HANGUL JUNGSEONG YEO
 * 3156 HANGUL LETTER YE
 * 	1168 HANGUL JUNGSEONG YE
 * 3157 HANGUL LETTER O
 * 	1169 HANGUL JUNGSEONG O
 * 3158 HANGUL LETTER WA
 * 	116A HANGUL JUNGSEONG WA
 * 3159 HANGUL LETTER WAE
 * 	116B HANGUL JUNGSEONG WAE
 * 315A HANGUL LETTER OE
 * 	116C HANGUL JUNGSEONG OE
 * 315B HANGUL LETTER YO
 * 	116D HANGUL JUNGSEONG YO
 * 315C HANGUL LETTER U
 * 	116E HANGUL JUNGSEONG U
 * 315D HANGUL LETTER WEO
 * 	116F HANGUL JUNGSEONG WEO
 * 315E HANGUL LETTER WE
 * 	1170 HANGUL JUNGSEONG WE
 * 315F HANGUL LETTER WI
 * 	1171 HANGUL JUNGSEONG WI
 * 3160 HANGUL LETTER YU
 * 	1172 HANGUL JUNGSEONG YU
 * 3161 HANGUL LETTER EU
 * 	1173 HANGUL JUNGSEONG EU
 * 3162 HANGUL LETTER YI
 * 	1174 HANGUL JUNGSEONG YI
 * 3163 HANGUL LETTER I
 * 	1175 HANGUL JUNGSEONG I
 * 3164 HANGUL FILLER
 * 	1160 HANGUL JUNGSEONG FILLER
 * 3165 HANGUL LETTER SSANGNIEUN
 * 	1114 HANGUL CHOSEONG SSANGNIEUN
 * 3166 HANGUL LETTER NIEUN-TIKEUT
 * 	1115 HANGUL CHOSEONG NIEUN-TIKEUT
 * 3167 HANGUL LETTER NIEUN-SIOS
 * 	11C7 HANGUL JONGSEONG NIEUN-SIOS
 * 3168 HANGUL LETTER NIEUN-PANSIOS
 * 	11C8 HANGUL JONGSEONG NIEUN-PANSIOS
 * 3169 HANGUL LETTER RIEUL-KIYEOK-SIOS
 * 	11CC HANGUL JONGSEONG RIEUL-KIYEOK-SIOS
 * 316A HANGUL LETTER RIEUL-TIKEUT
 * 	11CE HANGUL JONGSEONG RIEUL-TIKEUT
 * 316B HANGUL LETTER RIEUL-PIEUP-SIOS
 * 	11D3 HANGUL JONGSEONG RIEUL-PIEUP-SIOS
 * 316C HANGUL LETTER RIEUL-PANSIOS
 * 	11D7 HANGUL JONGSEONG RIEUL-PANSIOS
 * 316D HANGUL LETTER RIEUL-YEORINHIEUH
 * 	11D9 HANGUL JONGSEONG RIEUL-YEORINHIEUH
 * 316E HANGUL LETTER MIEUM-PIEUP
 * 	111C HANGUL CHOSEONG MIEUM-PIEUP
 * 316F HANGUL LETTER MIEUM-SIOS
 * 	11DD HANGUL JONGSEONG MIEUM-SIOS
 * 3170 HANGUL LETTER MIEUM-PANSIOS
 * 	11DF HANGUL JONGSEONG MIEUM-PANSIOS
 * 3171 HANGUL LETTER KAPYEOUNMIEUM
 * 	111D HANGUL CHOSEONG KAPYEOUNMIEUM
 * 3172 HANGUL LETTER PIEUP-KIYEOK
 * 	111E HANGUL CHOSEONG PIEUP-KIYEOK
 * 3173 HANGUL LETTER PIEUP-TIKEUT
 * 	1120 HANGUL CHOSEONG PIEUP-TIKEUT
 * 3174 HANGUL LETTER PIEUP-SIOS-KIYEOK
 * 	1122 HANGUL CHOSEONG PIEUP-SIOS-KIYEOK
 * 3175 HANGUL LETTER PIEUP-SIOS-TIKEUT
 * 	1123 HANGUL CHOSEONG PIEUP-SIOS-TIKEUT
 * 3176 HANGUL LETTER PIEUP-CIEUC
 * 	1127 HANGUL CHOSEONG PIEUP-CIEUC
 * 3177 HANGUL LETTER PIEUP-THIEUTH
 * 	1129 HANGUL CHOSEONG PIEUP-THIEUTH
 * 3178 HANGUL LETTER KAPYEOUNPIEUP
 * 	112B HANGUL CHOSEONG KAPYEOUNPIEUP
 * 3179 HANGUL LETTER KAPYEOUNSSANGPIEUP
 * 	112C HANGUL CHOSEONG KAPYEOUNSSANGPIEUP
 * 317A HANGUL LETTER SIOS-KIYEOK
 * 	112D HANGUL CHOSEONG SIOS-KIYEOK
 * 317B HANGUL LETTER SIOS-NIEUN
 * 	112E HANGUL CHOSEONG SIOS-NIEUN
 * 317C HANGUL LETTER SIOS-TIKEUT
 * 	112F HANGUL CHOSEONG SIOS-TIKEUT
 * 317D HANGUL LETTER SIOS-PIEUP
 * 	1132 HANGUL CHOSEONG SIOS-PIEUP
 * 317E HANGUL LETTER SIOS-CIEUC
 * 	1136 HANGUL CHOSEONG SIOS-CIEUC
 * 317F HANGUL LETTER PANSIOS
 * 	1140 HANGUL CHOSEONG PANSIOS
 * 3180 HANGUL LETTER SSANGIEUNG
 * 	1147 HANGUL CHOSEONG SSANGIEUNG
 * 3181 HANGUL LETTER YESIEUNG
 * 	114C HANGUL CHOSEONG YESIEUNG
 * 3182 HANGUL LETTER YESIEUNG-SIOS
 * 	11F1 HANGUL JONGSEONG YESIEUNG-SIOS
 * 3183 HANGUL LETTER YESIEUNG-PANSIOS
 * 	11F2 HANGUL JONGSEONG YESIEUNG-PANSIOS
 * 3184 HANGUL LETTER KAPYEOUNPHIEUPH
 * 	1157 HANGUL CHOSEONG KAPYEOUNPHIEUPH
 * 3185 HANGUL LETTER SSANGHIEUH
 * 	1158 HANGUL CHOSEONG SSANGHIEUH
 * 3186 HANGUL LETTER YEORINHIEUH
 * 	1159 HANGUL CHOSEONG YEORINHIEUH
 * 3187 HANGUL LETTER YO-YA
 * 	1184 HANGUL JUNGSEONG YO-YA
 * 3188 HANGUL LETTER YO-YAE
 * 	1185 HANGUL JUNGSEONG YO-YAE
 * 3189 HANGUL LETTER YO-I
 * 	1188 HANGUL JUNGSEONG YO-I
 * 318A HANGUL LETTER YU-YEO
 * 	1191 HANGUL JUNGSEONG YU-YEO
 * 318B HANGUL LETTER YU-YE
 * 	1192 HANGUL JUNGSEONG YU-YE
 * 318C HANGUL LETTER YU-I
 * 	1194 HANGUL JUNGSEONG YU-I
 * 318D HANGUL LETTER ARAEA
 * 	119E HANGUL JUNGSEONG ARAEA
 * 318E HANGUL LETTER ARAEAE
 * 	11A1 HANGUL JUNGSEONG ARAEA-I
 * 3192 IDEOGRAPHIC ANNOTATION ONE MARK
 * 	4E00 <CJK Ideograph, First>
 * 3193 IDEOGRAPHIC ANNOTATION TWO MARK
 * 	4E8C ??
 * 3194 IDEOGRAPHIC ANNOTATION THREE MARK
 * 	4E09 ??
 * 3195 IDEOGRAPHIC ANNOTATION FOUR MARK
 * 	56DB ??
 * 3196 IDEOGRAPHIC ANNOTATION TOP MARK
 * 	4E0A ??
 * 3197 IDEOGRAPHIC ANNOTATION MIDDLE MARK
 * 	4E2D ??
 * 3198 IDEOGRAPHIC ANNOTATION BOTTOM MARK
 * 	4E0B ??
 * 3199 IDEOGRAPHIC ANNOTATION FIRST MARK
 * 	7532 ??
 * 319A IDEOGRAPHIC ANNOTATION SECOND MARK
 * 	4E59 ??
 * 319B IDEOGRAPHIC ANNOTATION THIRD MARK
 * 	4E19 ??
 * 319C IDEOGRAPHIC ANNOTATION FOURTH MARK
 * 	4E01 ??
 * 319D IDEOGRAPHIC ANNOTATION HEAVEN MARK
 * 	5929 ??
 * 319E IDEOGRAPHIC ANNOTATION EARTH MARK
 * 	5730 ??
 * 319F IDEOGRAPHIC ANNOTATION MAN MARK
 * 	4EBA ??
 * 3200 PARENTHESIZED HANGUL KIYEOK
 * 	0028 LEFT PARENTHESIS
 * 	1100 HANGUL CHOSEONG KIYEOK
 * 	0029 RIGHT PARENTHESIS
 * 3201 PARENTHESIZED HANGUL NIEUN
 * 	0028 LEFT PARENTHESIS
 * 	1102 HANGUL CHOSEONG NIEUN
 * 	0029 RIGHT PARENTHESIS
 * 3202 PARENTHESIZED HANGUL TIKEUT
 * 	0028 LEFT PARENTHESIS
 * 	1103 HANGUL CHOSEONG TIKEUT
 * 	0029 RIGHT PARENTHESIS
 * 3203 PARENTHESIZED HANGUL RIEUL
 * 	0028 LEFT PARENTHESIS
 * 	1105 HANGUL CHOSEONG RIEUL
 * 	0029 RIGHT PARENTHESIS
 * 3204 PARENTHESIZED HANGUL MIEUM
 * 	0028 LEFT PARENTHESIS
 * 	1106 HANGUL CHOSEONG MIEUM
 * 	0029 RIGHT PARENTHESIS
 * 3205 PARENTHESIZED HANGUL PIEUP
 * 	0028 LEFT PARENTHESIS
 * 	1107 HANGUL CHOSEONG PIEUP
 * 	0029 RIGHT PARENTHESIS
 * 3206 PARENTHESIZED HANGUL SIOS
 * 	0028 LEFT PARENTHESIS
 * 	1109 HANGUL CHOSEONG SIOS
 * 	0029 RIGHT PARENTHESIS
 * 3207 PARENTHESIZED HANGUL IEUNG
 * 	0028 LEFT PARENTHESIS
 * 	110B HANGUL CHOSEONG IEUNG
 * 	0029 RIGHT PARENTHESIS
 * 3208 PARENTHESIZED HANGUL CIEUC
 * 	0028 LEFT PARENTHESIS
 * 	110C HANGUL CHOSEONG CIEUC
 * 	0029 RIGHT PARENTHESIS
 * 3209 PARENTHESIZED HANGUL CHIEUCH
 * 	0028 LEFT PARENTHESIS
 * 	110E HANGUL CHOSEONG CHIEUCH
 * 	0029 RIGHT PARENTHESIS
 * 320A PARENTHESIZED HANGUL KHIEUKH
 * 	0028 LEFT PARENTHESIS
 * 	110F HANGUL CHOSEONG KHIEUKH
 * 	0029 RIGHT PARENTHESIS
 * 320B PARENTHESIZED HANGUL THIEUTH
 * 	0028 LEFT PARENTHESIS
 * 	1110 HANGUL CHOSEONG THIEUTH
 * 	0029 RIGHT PARENTHESIS
 * 320C PARENTHESIZED HANGUL PHIEUPH
 * 	0028 LEFT PARENTHESIS
 * 	1111 HANGUL CHOSEONG PHIEUPH
 * 	0029 RIGHT PARENTHESIS
 * 320D PARENTHESIZED HANGUL HIEUH
 * 	0028 LEFT PARENTHESIS
 * 	1112 HANGUL CHOSEONG HIEUH
 * 	0029 RIGHT PARENTHESIS
 * 320E PARENTHESIZED HANGUL KIYEOK A
 * 	0028 LEFT PARENTHESIS
 * 	1100 HANGUL CHOSEONG KIYEOK
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 320F PARENTHESIZED HANGUL NIEUN A
 * 	0028 LEFT PARENTHESIS
 * 	1102 HANGUL CHOSEONG NIEUN
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3210 PARENTHESIZED HANGUL TIKEUT A
 * 	0028 LEFT PARENTHESIS
 * 	1103 HANGUL CHOSEONG TIKEUT
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3211 PARENTHESIZED HANGUL RIEUL A
 * 	0028 LEFT PARENTHESIS
 * 	1105 HANGUL CHOSEONG RIEUL
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3212 PARENTHESIZED HANGUL MIEUM A
 * 	0028 LEFT PARENTHESIS
 * 	1106 HANGUL CHOSEONG MIEUM
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3213 PARENTHESIZED HANGUL PIEUP A
 * 	0028 LEFT PARENTHESIS
 * 	1107 HANGUL CHOSEONG PIEUP
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3214 PARENTHESIZED HANGUL SIOS A
 * 	0028 LEFT PARENTHESIS
 * 	1109 HANGUL CHOSEONG SIOS
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3215 PARENTHESIZED HANGUL IEUNG A
 * 	0028 LEFT PARENTHESIS
 * 	110B HANGUL CHOSEONG IEUNG
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3216 PARENTHESIZED HANGUL CIEUC A
 * 	0028 LEFT PARENTHESIS
 * 	110C HANGUL CHOSEONG CIEUC
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3217 PARENTHESIZED HANGUL CHIEUCH A
 * 	0028 LEFT PARENTHESIS
 * 	110E HANGUL CHOSEONG CHIEUCH
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3218 PARENTHESIZED HANGUL KHIEUKH A
 * 	0028 LEFT PARENTHESIS
 * 	110F HANGUL CHOSEONG KHIEUKH
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 3219 PARENTHESIZED HANGUL THIEUTH A
 * 	0028 LEFT PARENTHESIS
 * 	1110 HANGUL CHOSEONG THIEUTH
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 321A PARENTHESIZED HANGUL PHIEUPH A
 * 	0028 LEFT PARENTHESIS
 * 	1111 HANGUL CHOSEONG PHIEUPH
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 321B PARENTHESIZED HANGUL HIEUH A
 * 	0028 LEFT PARENTHESIS
 * 	1112 HANGUL CHOSEONG HIEUH
 * 	1161 HANGUL JUNGSEONG A
 * 	0029 RIGHT PARENTHESIS
 * 321C PARENTHESIZED HANGUL CIEUC U
 * 	0028 LEFT PARENTHESIS
 * 	110C HANGUL CHOSEONG CIEUC
 * 	116E HANGUL JUNGSEONG U
 * 	0029 RIGHT PARENTHESIS
 * 3220 PARENTHESIZED IDEOGRAPH ONE
 * 	0028 LEFT PARENTHESIS
 * 	4E00 <CJK Ideograph, First>
 * 	0029 RIGHT PARENTHESIS
 * 3221 PARENTHESIZED IDEOGRAPH TWO
 * 	0028 LEFT PARENTHESIS
 * 	4E8C ??
 * 	0029 RIGHT PARENTHESIS
 * 3222 PARENTHESIZED IDEOGRAPH THREE
 * 	0028 LEFT PARENTHESIS
 * 	4E09 ??
 * 	0029 RIGHT PARENTHESIS
 * 3223 PARENTHESIZED IDEOGRAPH FOUR
 * 	0028 LEFT PARENTHESIS
 * 	56DB ??
 * 	0029 RIGHT PARENTHESIS
 * 3224 PARENTHESIZED IDEOGRAPH FIVE
 * 	0028 LEFT PARENTHESIS
 * 	4E94 ??
 * 	0029 RIGHT PARENTHESIS
 * 3225 PARENTHESIZED IDEOGRAPH SIX
 * 	0028 LEFT PARENTHESIS
 * 	516D ??
 * 	0029 RIGHT PARENTHESIS
 * 3226 PARENTHESIZED IDEOGRAPH SEVEN
 * 	0028 LEFT PARENTHESIS
 * 	4E03 ??
 * 	0029 RIGHT PARENTHESIS
 * 3227 PARENTHESIZED IDEOGRAPH EIGHT
 * 	0028 LEFT PARENTHESIS
 * 	516B ??
 * 	0029 RIGHT PARENTHESIS
 * 3228 PARENTHESIZED IDEOGRAPH NINE
 * 	0028 LEFT PARENTHESIS
 * 	4E5D ??
 * 	0029 RIGHT PARENTHESIS
 * 3229 PARENTHESIZED IDEOGRAPH TEN
 * 	0028 LEFT PARENTHESIS
 * 	5341 ??
 * 	0029 RIGHT PARENTHESIS
 * 322A PARENTHESIZED IDEOGRAPH MOON
 * 	0028 LEFT PARENTHESIS
 * 	6708 ??
 * 	0029 RIGHT PARENTHESIS
 * 322B PARENTHESIZED IDEOGRAPH FIRE
 * 	0028 LEFT PARENTHESIS
 * 	706B ??
 * 	0029 RIGHT PARENTHESIS
 * 322C PARENTHESIZED IDEOGRAPH WATER
 * 	0028 LEFT PARENTHESIS
 * 	6C34 ??
 * 	0029 RIGHT PARENTHESIS
 * 322D PARENTHESIZED IDEOGRAPH WOOD
 * 	0028 LEFT PARENTHESIS
 * 	6728 ??
 * 	0029 RIGHT PARENTHESIS
 * 322E PARENTHESIZED IDEOGRAPH METAL
 * 	0028 LEFT PARENTHESIS
 * 	91D1 ??
 * 	0029 RIGHT PARENTHESIS
 * 322F PARENTHESIZED IDEOGRAPH EARTH
 * 	0028 LEFT PARENTHESIS
 * 	571F ??
 * 	0029 RIGHT PARENTHESIS
 * 3230 PARENTHESIZED IDEOGRAPH SUN
 * 	0028 LEFT PARENTHESIS
 * 	65E5 ??
 * 	0029 RIGHT PARENTHESIS
 * 3231 PARENTHESIZED IDEOGRAPH STOCK
 * 	0028 LEFT PARENTHESIS
 * 	682A ??
 * 	0029 RIGHT PARENTHESIS
 * 3232 PARENTHESIZED IDEOGRAPH HAVE
 * 	0028 LEFT PARENTHESIS
 * 	6709 ??
 * 	0029 RIGHT PARENTHESIS
 * 3233 PARENTHESIZED IDEOGRAPH SOCIETY
 * 	0028 LEFT PARENTHESIS
 * 	793E ??
 * 	0029 RIGHT PARENTHESIS
 * 3234 PARENTHESIZED IDEOGRAPH NAME
 * 	0028 LEFT PARENTHESIS
 * 	540D ??
 * 	0029 RIGHT PARENTHESIS
 * 3235 PARENTHESIZED IDEOGRAPH SPECIAL
 * 	0028 LEFT PARENTHESIS
 * 	7279 ??
 * 	0029 RIGHT PARENTHESIS
 * 3236 PARENTHESIZED IDEOGRAPH FINANCIAL
 * 	0028 LEFT PARENTHESIS
 * 	8CA1 ??
 * 	0029 RIGHT PARENTHESIS
 * 3237 PARENTHESIZED IDEOGRAPH CONGRATULATION
 * 	0028 LEFT PARENTHESIS
 * 	795D ??
 * 	0029 RIGHT PARENTHESIS
 * 3238 PARENTHESIZED IDEOGRAPH LABOR
 * 	0028 LEFT PARENTHESIS
 * 	52B4 ??
 * 	0029 RIGHT PARENTHESIS
 * 3239 PARENTHESIZED IDEOGRAPH REPRESENT
 * 	0028 LEFT PARENTHESIS
 * 	4EE3 ??
 * 	0029 RIGHT PARENTHESIS
 * 323A PARENTHESIZED IDEOGRAPH CALL
 * 	0028 LEFT PARENTHESIS
 * 	547C ??
 * 	0029 RIGHT PARENTHESIS
 * 323B PARENTHESIZED IDEOGRAPH STUDY
 * 	0028 LEFT PARENTHESIS
 * 	5B66 ??
 * 	0029 RIGHT PARENTHESIS
 * 323C PARENTHESIZED IDEOGRAPH SUPERVISE
 * 	0028 LEFT PARENTHESIS
 * 	76E3 ??
 * 	0029 RIGHT PARENTHESIS
 * 323D PARENTHESIZED IDEOGRAPH ENTERPRISE
 * 	0028 LEFT PARENTHESIS
 * 	4F01 ??
 * 	0029 RIGHT PARENTHESIS
 * 323E PARENTHESIZED IDEOGRAPH RESOURCE
 * 	0028 LEFT PARENTHESIS
 * 	8CC7 ??
 * 	0029 RIGHT PARENTHESIS
 * 323F PARENTHESIZED IDEOGRAPH ALLIANCE
 * 	0028 LEFT PARENTHESIS
 * 	5354 ??
 * 	0029 RIGHT PARENTHESIS
 * 3240 PARENTHESIZED IDEOGRAPH FESTIVAL
 * 	0028 LEFT PARENTHESIS
 * 	796D ??
 * 	0029 RIGHT PARENTHESIS
 * 3241 PARENTHESIZED IDEOGRAPH REST
 * 	0028 LEFT PARENTHESIS
 * 	4F11 ??
 * 	0029 RIGHT PARENTHESIS
 * 3242 PARENTHESIZED IDEOGRAPH SELF
 * 	0028 LEFT PARENTHESIS
 * 	81EA ??
 * 	0029 RIGHT PARENTHESIS
 * 3243 PARENTHESIZED IDEOGRAPH REACH
 * 	0028 LEFT PARENTHESIS
 * 	81F3 ??
 * 	0029 RIGHT PARENTHESIS
 * 3251 CIRCLED NUMBER TWENTY ONE
 * 	0032 DIGIT TWO
 * 	0031 DIGIT ONE
 * 3252 CIRCLED NUMBER TWENTY TWO
 * 	0032 DIGIT TWO
 * 	0032 DIGIT TWO
 * 3253 CIRCLED NUMBER TWENTY THREE
 * 	0032 DIGIT TWO
 * 	0033 DIGIT THREE
 * 3254 CIRCLED NUMBER TWENTY FOUR
 * 	0032 DIGIT TWO
 * 	0034 DIGIT FOUR
 * 3255 CIRCLED NUMBER TWENTY FIVE
 * 	0032 DIGIT TWO
 * 	0035 DIGIT FIVE
 * 3256 CIRCLED NUMBER TWENTY SIX
 * 	0032 DIGIT TWO
 * 	0036 DIGIT SIX
 * 3257 CIRCLED NUMBER TWENTY SEVEN
 * 	0032 DIGIT TWO
 * 	0037 DIGIT SEVEN
 * 3258 CIRCLED NUMBER TWENTY EIGHT
 * 	0032 DIGIT TWO
 * 	0038 DIGIT EIGHT
 * 3259 CIRCLED NUMBER TWENTY NINE
 * 	0032 DIGIT TWO
 * 	0039 DIGIT NINE
 * 325A CIRCLED NUMBER THIRTY
 * 	0033 DIGIT THREE
 * 	0030 DIGIT ZERO
 * 325B CIRCLED NUMBER THIRTY ONE
 * 	0033 DIGIT THREE
 * 	0031 DIGIT ONE
 * 325C CIRCLED NUMBER THIRTY TWO
 * 	0033 DIGIT THREE
 * 	0032 DIGIT TWO
 * 325D CIRCLED NUMBER THIRTY THREE
 * 	0033 DIGIT THREE
 * 	0033 DIGIT THREE
 * 325E CIRCLED NUMBER THIRTY FOUR
 * 	0033 DIGIT THREE
 * 	0034 DIGIT FOUR
 * 325F CIRCLED NUMBER THIRTY FIVE
 * 	0033 DIGIT THREE
 * 	0035 DIGIT FIVE
 * 3260 CIRCLED HANGUL KIYEOK
 * 	1100 HANGUL CHOSEONG KIYEOK
 * 3261 CIRCLED HANGUL NIEUN
 * 	1102 HANGUL CHOSEONG NIEUN
 * 3262 CIRCLED HANGUL TIKEUT
 * 	1103 HANGUL CHOSEONG TIKEUT
 * 3263 CIRCLED HANGUL RIEUL
 * 	1105 HANGUL CHOSEONG RIEUL
 * 3264 CIRCLED HANGUL MIEUM
 * 	1106 HANGUL CHOSEONG MIEUM
 * 3265 CIRCLED HANGUL PIEUP
 * 	1107 HANGUL CHOSEONG PIEUP
 * 3266 CIRCLED HANGUL SIOS
 * 	1109 HANGUL CHOSEONG SIOS
 * 3267 CIRCLED HANGUL IEUNG
 * 	110B HANGUL CHOSEONG IEUNG
 * 3268 CIRCLED HANGUL CIEUC
 * 	110C HANGUL CHOSEONG CIEUC
 * 3269 CIRCLED HANGUL CHIEUCH
 * 	110E HANGUL CHOSEONG CHIEUCH
 * 326A CIRCLED HANGUL KHIEUKH
 * 	110F HANGUL CHOSEONG KHIEUKH
 * 326B CIRCLED HANGUL THIEUTH
 * 	1110 HANGUL CHOSEONG THIEUTH
 * 326C CIRCLED HANGUL PHIEUPH
 * 	1111 HANGUL CHOSEONG PHIEUPH
 * 326D CIRCLED HANGUL HIEUH
 * 	1112 HANGUL CHOSEONG HIEUH
 * 326E CIRCLED HANGUL KIYEOK A
 * 	1100 HANGUL CHOSEONG KIYEOK
 * 	1161 HANGUL JUNGSEONG A
 * 326F CIRCLED HANGUL NIEUN A
 * 	1102 HANGUL CHOSEONG NIEUN
 * 	1161 HANGUL JUNGSEONG A
 * 3270 CIRCLED HANGUL TIKEUT A
 * 	1103 HANGUL CHOSEONG TIKEUT
 * 	1161 HANGUL JUNGSEONG A
 * 3271 CIRCLED HANGUL RIEUL A
 * 	1105 HANGUL CHOSEONG RIEUL
 * 	1161 HANGUL JUNGSEONG A
 * 3272 CIRCLED HANGUL MIEUM A
 * 	1106 HANGUL CHOSEONG MIEUM
 * 	1161 HANGUL JUNGSEONG A
 * 3273 CIRCLED HANGUL PIEUP A
 * 	1107 HANGUL CHOSEONG PIEUP
 * 	1161 HANGUL JUNGSEONG A
 * 3274 CIRCLED HANGUL SIOS A
 * 	1109 HANGUL CHOSEONG SIOS
 * 	1161 HANGUL JUNGSEONG A
 * 3275 CIRCLED HANGUL IEUNG A
 * 	110B HANGUL CHOSEONG IEUNG
 * 	1161 HANGUL JUNGSEONG A
 * 3276 CIRCLED HANGUL CIEUC A
 * 	110C HANGUL CHOSEONG CIEUC
 * 	1161 HANGUL JUNGSEONG A
 * 3277 CIRCLED HANGUL CHIEUCH A
 * 	110E HANGUL CHOSEONG CHIEUCH
 * 	1161 HANGUL JUNGSEONG A
 * 3278 CIRCLED HANGUL KHIEUKH A
 * 	110F HANGUL CHOSEONG KHIEUKH
 * 	1161 HANGUL JUNGSEONG A
 * 3279 CIRCLED HANGUL THIEUTH A
 * 	1110 HANGUL CHOSEONG THIEUTH
 * 	1161 HANGUL JUNGSEONG A
 * 327A CIRCLED HANGUL PHIEUPH A
 * 	1111 HANGUL CHOSEONG PHIEUPH
 * 	1161 HANGUL JUNGSEONG A
 * 327B CIRCLED HANGUL HIEUH A
 * 	1112 HANGUL CHOSEONG HIEUH
 * 	1161 HANGUL JUNGSEONG A
 * 3280 CIRCLED IDEOGRAPH ONE
 * 	4E00 <CJK Ideograph, First>
 * 3281 CIRCLED IDEOGRAPH TWO
 * 	4E8C ??
 * 3282 CIRCLED IDEOGRAPH THREE
 * 	4E09 ??
 * 3283 CIRCLED IDEOGRAPH FOUR
 * 	56DB ??
 * 3284 CIRCLED IDEOGRAPH FIVE
 * 	4E94 ??
 * 3285 CIRCLED IDEOGRAPH SIX
 * 	516D ??
 * 3286 CIRCLED IDEOGRAPH SEVEN
 * 	4E03 ??
 * 3287 CIRCLED IDEOGRAPH EIGHT
 * 	516B ??
 * 3288 CIRCLED IDEOGRAPH NINE
 * 	4E5D ??
 * 3289 CIRCLED IDEOGRAPH TEN
 * 	5341 ??
 * 328A CIRCLED IDEOGRAPH MOON
 * 	6708 ??
 * 328B CIRCLED IDEOGRAPH FIRE
 * 	706B ??
 * 328C CIRCLED IDEOGRAPH WATER
 * 	6C34 ??
 * 328D CIRCLED IDEOGRAPH WOOD
 * 	6728 ??
 * 328E CIRCLED IDEOGRAPH METAL
 * 	91D1 ??
 * 328F CIRCLED IDEOGRAPH EARTH
 * 	571F ??
 * 3290 CIRCLED IDEOGRAPH SUN
 * 	65E5 ??
 * 3291 CIRCLED IDEOGRAPH STOCK
 * 	682A ??
 * 3292 CIRCLED IDEOGRAPH HAVE
 * 	6709 ??
 * 3293 CIRCLED IDEOGRAPH SOCIETY
 * 	793E ??
 * 3294 CIRCLED IDEOGRAPH NAME
 * 	540D ??
 * 3295 CIRCLED IDEOGRAPH SPECIAL
 * 	7279 ??
 * 3296 CIRCLED IDEOGRAPH FINANCIAL
 * 	8CA1 ??
 * 3297 CIRCLED IDEOGRAPH CONGRATULATION
 * 	795D ??
 * 3298 CIRCLED IDEOGRAPH LABOR
 * 	52B4 ??
 * 3299 CIRCLED IDEOGRAPH SECRET
 * 	79D8 ??
 * 329A CIRCLED IDEOGRAPH MALE
 * 	7537 ??
 * 329B CIRCLED IDEOGRAPH FEMALE
 * 	5973 ??
 * 329C CIRCLED IDEOGRAPH SUITABLE
 * 	9069 ??
 * 329D CIRCLED IDEOGRAPH EXCELLENT
 * 	512A ??
 * 329E CIRCLED IDEOGRAPH PRINT
 * 	5370 ??
 * 329F CIRCLED IDEOGRAPH ATTENTION
 * 	6CE8 ??
 * 32A0 CIRCLED IDEOGRAPH ITEM
 * 	9805 ??
 * 32A1 CIRCLED IDEOGRAPH REST
 * 	4F11 ??
 * 32A2 CIRCLED IDEOGRAPH COPY
 * 	5199 ??
 * 32A3 CIRCLED IDEOGRAPH CORRECT
 * 	6B63 ??
 * 32A4 CIRCLED IDEOGRAPH HIGH
 * 	4E0A ??
 * 32A5 CIRCLED IDEOGRAPH CENTRE
 * 	4E2D ??
 * 32A6 CIRCLED IDEOGRAPH LOW
 * 	4E0B ??
 * 32A7 CIRCLED IDEOGRAPH LEFT
 * 	5DE6 ??
 * 32A8 CIRCLED IDEOGRAPH RIGHT
 * 	53F3 ??
 * 32A9 CIRCLED IDEOGRAPH MEDICINE
 * 	533B ??
 * 32AA CIRCLED IDEOGRAPH RELIGION
 * 	5B97 ??
 * 32AB CIRCLED IDEOGRAPH STUDY
 * 	5B66 ??
 * 32AC CIRCLED IDEOGRAPH SUPERVISE
 * 	76E3 ??
 * 32AD CIRCLED IDEOGRAPH ENTERPRISE
 * 	4F01 ??
 * 32AE CIRCLED IDEOGRAPH RESOURCE
 * 	8CC7 ??
 * 32AF CIRCLED IDEOGRAPH ALLIANCE
 * 	5354 ??
 * 32B0 CIRCLED IDEOGRAPH NIGHT
 * 	591C ??
 * 32B1 CIRCLED NUMBER THIRTY SIX
 * 	0033 DIGIT THREE
 * 	0036 DIGIT SIX
 * 32B2 CIRCLED NUMBER THIRTY SEVEN
 * 	0033 DIGIT THREE
 * 	0037 DIGIT SEVEN
 * 32B3 CIRCLED NUMBER THIRTY EIGHT
 * 	0033 DIGIT THREE
 * 	0038 DIGIT EIGHT
 * 32B4 CIRCLED NUMBER THIRTY NINE
 * 	0033 DIGIT THREE
 * 	0039 DIGIT NINE
 * 32B5 CIRCLED NUMBER FORTY
 * 	0034 DIGIT FOUR
 * 	0030 DIGIT ZERO
 * 32B6 CIRCLED NUMBER FORTY ONE
 * 	0034 DIGIT FOUR
 * 	0031 DIGIT ONE
 * 32B7 CIRCLED NUMBER FORTY TWO
 * 	0034 DIGIT FOUR
 * 	0032 DIGIT TWO
 * 32B8 CIRCLED NUMBER FORTY THREE
 * 	0034 DIGIT FOUR
 * 	0033 DIGIT THREE
 * 32B9 CIRCLED NUMBER FORTY FOUR
 * 	0034 DIGIT FOUR
 * 	0034 DIGIT FOUR
 * 32BA CIRCLED NUMBER FORTY FIVE
 * 	0034 DIGIT FOUR
 * 	0035 DIGIT FIVE
 * 32BB CIRCLED NUMBER FORTY SIX
 * 	0034 DIGIT FOUR
 * 	0036 DIGIT SIX
 * 32BC CIRCLED NUMBER FORTY SEVEN
 * 	0034 DIGIT FOUR
 * 	0037 DIGIT SEVEN
 * 32BD CIRCLED NUMBER FORTY EIGHT
 * 	0034 DIGIT FOUR
 * 	0038 DIGIT EIGHT
 * 32BE CIRCLED NUMBER FORTY NINE
 * 	0034 DIGIT FOUR
 * 	0039 DIGIT NINE
 * 32BF CIRCLED NUMBER FIFTY
 * 	0035 DIGIT FIVE
 * 	0030 DIGIT ZERO
 * 32C0 IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY
 * 	0031 DIGIT ONE
 * 	6708 ??
 * 32C1 IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY
 * 	0032 DIGIT TWO
 * 	6708 ??
 * 32C2 IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH
 * 	0033 DIGIT THREE
 * 	6708 ??
 * 32C3 IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL
 * 	0034 DIGIT FOUR
 * 	6708 ??
 * 32C4 IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY
 * 	0035 DIGIT FIVE
 * 	6708 ??
 * 32C5 IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE
 * 	0036 DIGIT SIX
 * 	6708 ??
 * 32C6 IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY
 * 	0037 DIGIT SEVEN
 * 	6708 ??
 * 32C7 IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST
 * 	0038 DIGIT EIGHT
 * 	6708 ??
 * 32C8 IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER
 * 	0039 DIGIT NINE
 * 	6708 ??
 * 32C9 IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER
 * 	0031 DIGIT ONE
 * 	0030 DIGIT ZERO
 * 	6708 ??
 * 32CA IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER
 * 	0031 DIGIT ONE
 * 	0031 DIGIT ONE
 * 	6708 ??
 * 32CB IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER
 * 	0031 DIGIT ONE
 * 	0032 DIGIT TWO
 * 	6708 ??
 * 32D0 CIRCLED KATAKANA A
 * 	30A2 KATAKANA LETTER A
 * 32D1 CIRCLED KATAKANA I
 * 	30A4 KATAKANA LETTER I
 * 32D2 CIRCLED KATAKANA U
 * 	30A6 KATAKANA LETTER U
 * 32D3 CIRCLED KATAKANA E
 * 	30A8 KATAKANA LETTER E
 * 32D4 CIRCLED KATAKANA O
 * 	30AA KATAKANA LETTER O
 * 32D5 CIRCLED KATAKANA KA
 * 	30AB KATAKANA LETTER KA
 * 32D6 CIRCLED KATAKANA KI
 * 	30AD KATAKANA LETTER KI
 * 32D7 CIRCLED KATAKANA KU
 * 	30AF KATAKANA LETTER KU
 * 32D8 CIRCLED KATAKANA KE
 * 	30B1 KATAKANA LETTER KE
 * 32D9 CIRCLED KATAKANA KO
 * 	30B3 KATAKANA LETTER KO
 * 32DA CIRCLED KATAKANA SA
 * 	30B5 KATAKANA LETTER SA
 * 32DB CIRCLED KATAKANA SI
 * 	30B7 KATAKANA LETTER SI
 * 32DC CIRCLED KATAKANA SU
 * 	30B9 KATAKANA LETTER SU
 * 32DD CIRCLED KATAKANA SE
 * 	30BB KATAKANA LETTER SE
 * 32DE CIRCLED KATAKANA SO
 * 	30BD KATAKANA LETTER SO
 * 32DF CIRCLED KATAKANA TA
 * 	30BF KATAKANA LETTER TA
 * 32E0 CIRCLED KATAKANA TI
 * 	30C1 KATAKANA LETTER TI
 * 32E1 CIRCLED KATAKANA TU
 * 	30C4 KATAKANA LETTER TU
 * 32E2 CIRCLED KATAKANA TE
 * 	30C6 KATAKANA LETTER TE
 * 32E3 CIRCLED KATAKANA TO
 * 	30C8 KATAKANA LETTER TO
 * 32E4 CIRCLED KATAKANA NA
 * 	30CA KATAKANA LETTER NA
 * 32E5 CIRCLED KATAKANA NI
 * 	30CB KATAKANA LETTER NI
 * 32E6 CIRCLED KATAKANA NU
 * 	30CC KATAKANA LETTER NU
 * 32E7 CIRCLED KATAKANA NE
 * 	30CD KATAKANA LETTER NE
 * 32E8 CIRCLED KATAKANA NO
 * 	30CE KATAKANA LETTER NO
 * 32E9 CIRCLED KATAKANA HA
 * 	30CF KATAKANA LETTER HA
 * 32EA CIRCLED KATAKANA HI
 * 	30D2 KATAKANA LETTER HI
 * 32EB CIRCLED KATAKANA HU
 * 	30D5 KATAKANA LETTER HU
 * 32EC CIRCLED KATAKANA HE
 * 	30D8 KATAKANA LETTER HE
 * 32ED CIRCLED KATAKANA HO
 * 	30DB KATAKANA LETTER HO
 * 32EE CIRCLED KATAKANA MA
 * 	30DE KATAKANA LETTER MA
 * 32EF CIRCLED KATAKANA MI
 * 	30DF KATAKANA LETTER MI
 * 32F0 CIRCLED KATAKANA MU
 * 	30E0 KATAKANA LETTER MU
 * 32F1 CIRCLED KATAKANA ME
 * 	30E1 KATAKANA LETTER ME
 * 32F2 CIRCLED KATAKANA MO
 * 	30E2 KATAKANA LETTER MO
 * 32F3 CIRCLED KATAKANA YA
 * 	30E4 KATAKANA LETTER YA
 * 32F4 CIRCLED KATAKANA YU
 * 	30E6 KATAKANA LETTER YU
 * 32F5 CIRCLED KATAKANA YO
 * 	30E8 KATAKANA LETTER YO
 * 32F6 CIRCLED KATAKANA RA
 * 	30E9 KATAKANA LETTER RA
 * 32F7 CIRCLED KATAKANA RI
 * 	30EA KATAKANA LETTER RI
 * 32F8 CIRCLED KATAKANA RU
 * 	30EB KATAKANA LETTER RU
 * 32F9 CIRCLED KATAKANA RE
 * 	30EC KATAKANA LETTER RE
 * 32FA CIRCLED KATAKANA RO
 * 	30ED KATAKANA LETTER RO
 * 32FB CIRCLED KATAKANA WA
 * 	30EF KATAKANA LETTER WA
 * 32FC CIRCLED KATAKANA WI
 * 	30F0 KATAKANA LETTER WI
 * 32FD CIRCLED KATAKANA WE
 * 	30F1 KATAKANA LETTER WE
 * 32FE CIRCLED KATAKANA WO
 * 	30F2 KATAKANA LETTER WO
 * 3300 SQUARE APAATO
 * 	30A2 KATAKANA LETTER A
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C8 KATAKANA LETTER TO
 * 	30CF KATAKANA LETTER HA
 * 3301 SQUARE ARUHUA
 * 	30A2 KATAKANA LETTER A
 * 	30EB KATAKANA LETTER RU
 * 	30D5 KATAKANA LETTER HU
 * 	30A1 KATAKANA LETTER SMALL A
 * 3302 SQUARE ANPEA
 * 	30A2 KATAKANA LETTER A
 * 	30F3 KATAKANA LETTER N
 * 	30A2 KATAKANA LETTER A
 * 	30D8 KATAKANA LETTER HE
 * 3303 SQUARE AARU
 * 	30A2 KATAKANA LETTER A
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EB KATAKANA LETTER RU
 * 3304 SQUARE ININGU
 * 	30A4 KATAKANA LETTER I
 * 	30CB KATAKANA LETTER NI
 * 	30F3 KATAKANA LETTER N
 * 	30AF KATAKANA LETTER KU
 * 3305 SQUARE INTI
 * 	30A4 KATAKANA LETTER I
 * 	30F3 KATAKANA LETTER N
 * 	30C1 KATAKANA LETTER TI
 * 3306 SQUARE UON
 * 	30A6 KATAKANA LETTER U
 * 	30A9 KATAKANA LETTER SMALL O
 * 	30F3 KATAKANA LETTER N
 * 3307 SQUARE ESUKUUDO
 * 	30A8 KATAKANA LETTER E
 * 	30B9 KATAKANA LETTER SU
 * 	30AF KATAKANA LETTER KU
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C8 KATAKANA LETTER TO
 * 3308 SQUARE EEKAA
 * 	30A8 KATAKANA LETTER E
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30AB KATAKANA LETTER KA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 3309 SQUARE ONSU
 * 	30AA KATAKANA LETTER O
 * 	30F3 KATAKANA LETTER N
 * 	30B9 KATAKANA LETTER SU
 * 330A SQUARE OOMU
 * 	30AA KATAKANA LETTER O
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30E0 KATAKANA LETTER MU
 * 330B SQUARE KAIRI
 * 	30AB KATAKANA LETTER KA
 * 	30A4 KATAKANA LETTER I
 * 	30EA KATAKANA LETTER RI
 * 330C SQUARE KARATTO
 * 	30AB KATAKANA LETTER KA
 * 	30E9 KATAKANA LETTER RA
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30C8 KATAKANA LETTER TO
 * 330D SQUARE KARORII
 * 	30AB KATAKANA LETTER KA
 * 	30ED KATAKANA LETTER RO
 * 	30EA KATAKANA LETTER RI
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 330E SQUARE GARON
 * 	30ED KATAKANA LETTER RO
 * 	30F3 KATAKANA LETTER N
 * 	30AB KATAKANA LETTER KA
 * 330F SQUARE GANMA
 * 	30F3 KATAKANA LETTER N
 * 	30DE KATAKANA LETTER MA
 * 	30AB KATAKANA LETTER KA
 * 3310 SQUARE GIGA
 * 	30AD KATAKANA LETTER KI
 * 	30AB KATAKANA LETTER KA
 * 3311 SQUARE GINII
 * 	30CB KATAKANA LETTER NI
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30AD KATAKANA LETTER KI
 * 3312 SQUARE KYURII
 * 	30AD KATAKANA LETTER KI
 * 	30E5 KATAKANA LETTER SMALL YU
 * 	30EA KATAKANA LETTER RI
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 3313 SQUARE GIRUDAA
 * 	30EB KATAKANA LETTER RU
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30AD KATAKANA LETTER KI
 * 	30BF KATAKANA LETTER TA
 * 3314 SQUARE KIRO
 * 	30AD KATAKANA LETTER KI
 * 	30ED KATAKANA LETTER RO
 * 3315 SQUARE KIROGURAMU
 * 	30AD KATAKANA LETTER KI
 * 	30ED KATAKANA LETTER RO
 * 	30E9 KATAKANA LETTER RA
 * 	30E0 KATAKANA LETTER MU
 * 	30AF KATAKANA LETTER KU
 * 3316 SQUARE KIROMEETORU
 * 	30AD KATAKANA LETTER KI
 * 	30ED KATAKANA LETTER RO
 * 	30E1 KATAKANA LETTER ME
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C8 KATAKANA LETTER TO
 * 	30EB KATAKANA LETTER RU
 * 3317 SQUARE KIROWATTO
 * 	30AD KATAKANA LETTER KI
 * 	30ED KATAKANA LETTER RO
 * 	30EF KATAKANA LETTER WA
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30C8 KATAKANA LETTER TO
 * 3318 SQUARE GURAMU
 * 	30E9 KATAKANA LETTER RA
 * 	30E0 KATAKANA LETTER MU
 * 	30AF KATAKANA LETTER KU
 * 3319 SQUARE GURAMUTON
 * 	30E9 KATAKANA LETTER RA
 * 	30E0 KATAKANA LETTER MU
 * 	30C8 KATAKANA LETTER TO
 * 	30F3 KATAKANA LETTER N
 * 	30AF KATAKANA LETTER KU
 * 331A SQUARE KURUZEIRO
 * 	30AF KATAKANA LETTER KU
 * 	30EB KATAKANA LETTER RU
 * 	30A4 KATAKANA LETTER I
 * 	30ED KATAKANA LETTER RO
 * 	30BB KATAKANA LETTER SE
 * 331B SQUARE KUROONE
 * 	30AF KATAKANA LETTER KU
 * 	30ED KATAKANA LETTER RO
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30CD KATAKANA LETTER NE
 * 331C SQUARE KEESU
 * 	30B1 KATAKANA LETTER KE
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30B9 KATAKANA LETTER SU
 * 331D SQUARE KORUNA
 * 	30B3 KATAKANA LETTER KO
 * 	30EB KATAKANA LETTER RU
 * 	30CA KATAKANA LETTER NA
 * 331E SQUARE KOOPO
 * 	30B3 KATAKANA LETTER KO
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30DB KATAKANA LETTER HO
 * 331F SQUARE SAIKURU
 * 	30B5 KATAKANA LETTER SA
 * 	30A4 KATAKANA LETTER I
 * 	30AF KATAKANA LETTER KU
 * 	30EB KATAKANA LETTER RU
 * 3320 SQUARE SANTIIMU
 * 	30B5 KATAKANA LETTER SA
 * 	30F3 KATAKANA LETTER N
 * 	30C1 KATAKANA LETTER TI
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30E0 KATAKANA LETTER MU
 * 3321 SQUARE SIRINGU
 * 	30B7 KATAKANA LETTER SI
 * 	30EA KATAKANA LETTER RI
 * 	30F3 KATAKANA LETTER N
 * 	30AF KATAKANA LETTER KU
 * 3322 SQUARE SENTI
 * 	30BB KATAKANA LETTER SE
 * 	30F3 KATAKANA LETTER N
 * 	30C1 KATAKANA LETTER TI
 * 3323 SQUARE SENTO
 * 	30BB KATAKANA LETTER SE
 * 	30F3 KATAKANA LETTER N
 * 	30C8 KATAKANA LETTER TO
 * 3324 SQUARE DAASU
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30B9 KATAKANA LETTER SU
 * 	30BF KATAKANA LETTER TA
 * 3325 SQUARE DESI
 * 	30B7 KATAKANA LETTER SI
 * 	30C6 KATAKANA LETTER TE
 * 3326 SQUARE DORU
 * 	30EB KATAKANA LETTER RU
 * 	30C8 KATAKANA LETTER TO
 * 3327 SQUARE TON
 * 	30C8 KATAKANA LETTER TO
 * 	30F3 KATAKANA LETTER N
 * 3328 SQUARE NANO
 * 	30CA KATAKANA LETTER NA
 * 	30CE KATAKANA LETTER NO
 * 3329 SQUARE NOTTO
 * 	30CE KATAKANA LETTER NO
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30C8 KATAKANA LETTER TO
 * 332A SQUARE HAITU
 * 	30CF KATAKANA LETTER HA
 * 	30A4 KATAKANA LETTER I
 * 	30C4 KATAKANA LETTER TU
 * 332B SQUARE PAASENTO
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30BB KATAKANA LETTER SE
 * 	30F3 KATAKANA LETTER N
 * 	30C8 KATAKANA LETTER TO
 * 	30CF KATAKANA LETTER HA
 * 332C SQUARE PAATU
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C4 KATAKANA LETTER TU
 * 	30CF KATAKANA LETTER HA
 * 332D SQUARE BAARERU
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EC KATAKANA LETTER RE
 * 	30EB KATAKANA LETTER RU
 * 	30CF KATAKANA LETTER HA
 * 332E SQUARE PIASUTORU
 * 	30A2 KATAKANA LETTER A
 * 	30B9 KATAKANA LETTER SU
 * 	30C8 KATAKANA LETTER TO
 * 	30EB KATAKANA LETTER RU
 * 	30D2 KATAKANA LETTER HI
 * 332F SQUARE PIKURU
 * 	30AF KATAKANA LETTER KU
 * 	30EB KATAKANA LETTER RU
 * 	30D2 KATAKANA LETTER HI
 * 3330 SQUARE PIKO
 * 	30B3 KATAKANA LETTER KO
 * 	30D2 KATAKANA LETTER HI
 * 3331 SQUARE BIRU
 * 	30EB KATAKANA LETTER RU
 * 	30D2 KATAKANA LETTER HI
 * 3332 SQUARE HUARADDO
 * 	30D5 KATAKANA LETTER HU
 * 	30A1 KATAKANA LETTER SMALL A
 * 	30E9 KATAKANA LETTER RA
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30C8 KATAKANA LETTER TO
 * 3333 SQUARE HUIITO
 * 	30D5 KATAKANA LETTER HU
 * 	30A3 KATAKANA LETTER SMALL I
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C8 KATAKANA LETTER TO
 * 3334 SQUARE BUSSYERU
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30B7 KATAKANA LETTER SI
 * 	30A7 KATAKANA LETTER SMALL E
 * 	30EB KATAKANA LETTER RU
 * 	30D5 KATAKANA LETTER HU
 * 3335 SQUARE HURAN
 * 	30D5 KATAKANA LETTER HU
 * 	30E9 KATAKANA LETTER RA
 * 	30F3 KATAKANA LETTER N
 * 3336 SQUARE HEKUTAARU
 * 	30D8 KATAKANA LETTER HE
 * 	30AF KATAKANA LETTER KU
 * 	30BF KATAKANA LETTER TA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EB KATAKANA LETTER RU
 * 3337 SQUARE PESO
 * 	30BD KATAKANA LETTER SO
 * 	30D8 KATAKANA LETTER HE
 * 3338 SQUARE PENIHI
 * 	30CB KATAKANA LETTER NI
 * 	30D2 KATAKANA LETTER HI
 * 	30D8 KATAKANA LETTER HE
 * 3339 SQUARE HERUTU
 * 	30D8 KATAKANA LETTER HE
 * 	30EB KATAKANA LETTER RU
 * 	30C4 KATAKANA LETTER TU
 * 333A SQUARE PENSU
 * 	30F3 KATAKANA LETTER N
 * 	30B9 KATAKANA LETTER SU
 * 	30D8 KATAKANA LETTER HE
 * 333B SQUARE PEEZI
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30D8 KATAKANA LETTER HE
 * 	30B7 KATAKANA LETTER SI
 * 333C SQUARE BEETA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30BF KATAKANA LETTER TA
 * 	30D8 KATAKANA LETTER HE
 * 333D SQUARE POINTO
 * 	30A4 KATAKANA LETTER I
 * 	30F3 KATAKANA LETTER N
 * 	30C8 KATAKANA LETTER TO
 * 	30DB KATAKANA LETTER HO
 * 333E SQUARE BORUTO
 * 	30EB KATAKANA LETTER RU
 * 	30C8 KATAKANA LETTER TO
 * 	30DB KATAKANA LETTER HO
 * 333F SQUARE HON
 * 	30DB KATAKANA LETTER HO
 * 	30F3 KATAKANA LETTER N
 * 3340 SQUARE PONDO
 * 	30F3 KATAKANA LETTER N
 * 	30DB KATAKANA LETTER HO
 * 	30C8 KATAKANA LETTER TO
 * 3341 SQUARE HOORU
 * 	30DB KATAKANA LETTER HO
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EB KATAKANA LETTER RU
 * 3342 SQUARE HOON
 * 	30DB KATAKANA LETTER HO
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30F3 KATAKANA LETTER N
 * 3343 SQUARE MAIKURO
 * 	30DE KATAKANA LETTER MA
 * 	30A4 KATAKANA LETTER I
 * 	30AF KATAKANA LETTER KU
 * 	30ED KATAKANA LETTER RO
 * 3344 SQUARE MAIRU
 * 	30DE KATAKANA LETTER MA
 * 	30A4 KATAKANA LETTER I
 * 	30EB KATAKANA LETTER RU
 * 3345 SQUARE MAHHA
 * 	30DE KATAKANA LETTER MA
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30CF KATAKANA LETTER HA
 * 3346 SQUARE MARUKU
 * 	30DE KATAKANA LETTER MA
 * 	30EB KATAKANA LETTER RU
 * 	30AF KATAKANA LETTER KU
 * 3347 SQUARE MANSYON
 * 	30DE KATAKANA LETTER MA
 * 	30F3 KATAKANA LETTER N
 * 	30B7 KATAKANA LETTER SI
 * 	30E7 KATAKANA LETTER SMALL YO
 * 	30F3 KATAKANA LETTER N
 * 3348 SQUARE MIKURON
 * 	30DF KATAKANA LETTER MI
 * 	30AF KATAKANA LETTER KU
 * 	30ED KATAKANA LETTER RO
 * 	30F3 KATAKANA LETTER N
 * 3349 SQUARE MIRI
 * 	30DF KATAKANA LETTER MI
 * 	30EA KATAKANA LETTER RI
 * 334A SQUARE MIRIBAARU
 * 	30DF KATAKANA LETTER MI
 * 	30EA KATAKANA LETTER RI
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EB KATAKANA LETTER RU
 * 	30CF KATAKANA LETTER HA
 * 334B SQUARE MEGA
 * 	30E1 KATAKANA LETTER ME
 * 	30AB KATAKANA LETTER KA
 * 334C SQUARE MEGATON
 * 	30E1 KATAKANA LETTER ME
 * 	30C8 KATAKANA LETTER TO
 * 	30F3 KATAKANA LETTER N
 * 	30AB KATAKANA LETTER KA
 * 334D SQUARE MEETORU
 * 	30E1 KATAKANA LETTER ME
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C8 KATAKANA LETTER TO
 * 	30EB KATAKANA LETTER RU
 * 334E SQUARE YAADO
 * 	30E4 KATAKANA LETTER YA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30C8 KATAKANA LETTER TO
 * 334F SQUARE YAARU
 * 	30E4 KATAKANA LETTER YA
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EB KATAKANA LETTER RU
 * 3350 SQUARE YUAN
 * 	30E6 KATAKANA LETTER YU
 * 	30A2 KATAKANA LETTER A
 * 	30F3 KATAKANA LETTER N
 * 3351 SQUARE RITTORU
 * 	30EA KATAKANA LETTER RI
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30C8 KATAKANA LETTER TO
 * 	30EB KATAKANA LETTER RU
 * 3352 SQUARE RIRA
 * 	30EA KATAKANA LETTER RI
 * 	30E9 KATAKANA LETTER RA
 * 3353 SQUARE RUPII
 * 	30EB KATAKANA LETTER RU
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30D2 KATAKANA LETTER HI
 * 3354 SQUARE RUUBURU
 * 	30EB KATAKANA LETTER RU
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30EB KATAKANA LETTER RU
 * 	30D5 KATAKANA LETTER HU
 * 3355 SQUARE REMU
 * 	30EC KATAKANA LETTER RE
 * 	30E0 KATAKANA LETTER MU
 * 3356 SQUARE RENTOGEN
 * 	30EC KATAKANA LETTER RE
 * 	30F3 KATAKANA LETTER N
 * 	30C8 KATAKANA LETTER TO
 * 	30F3 KATAKANA LETTER N
 * 	30B1 KATAKANA LETTER KE
 * 3357 SQUARE WATTO
 * 	30EF KATAKANA LETTER WA
 * 	30C3 KATAKANA LETTER SMALL TU
 * 	30C8 KATAKANA LETTER TO
 * 3358 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO
 * 	0030 DIGIT ZERO
 * 	70B9 ??
 * 3359 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE
 * 	0031 DIGIT ONE
 * 	70B9 ??
 * 335A IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO
 * 	0032 DIGIT TWO
 * 	70B9 ??
 * 335B IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE
 * 	0033 DIGIT THREE
 * 	70B9 ??
 * 335C IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR
 * 	0034 DIGIT FOUR
 * 	70B9 ??
 * 335D IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE
 * 	0035 DIGIT FIVE
 * 	70B9 ??
 * 335E IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX
 * 	0036 DIGIT SIX
 * 	70B9 ??
 * 335F IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN
 * 	0037 DIGIT SEVEN
 * 	70B9 ??
 * 3360 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT
 * 	0038 DIGIT EIGHT
 * 	70B9 ??
 * 3361 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE
 * 	0039 DIGIT NINE
 * 	70B9 ??
 * 3362 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN
 * 	0031 DIGIT ONE
 * 	0030 DIGIT ZERO
 * 	70B9 ??
 * 3363 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN
 * 	0031 DIGIT ONE
 * 	0031 DIGIT ONE
 * 	70B9 ??
 * 3364 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE
 * 	0031 DIGIT ONE
 * 	0032 DIGIT TWO
 * 	70B9 ??
 * 3365 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN
 * 	0031 DIGIT ONE
 * 	0033 DIGIT THREE
 * 	70B9 ??
 * 3366 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN
 * 	0031 DIGIT ONE
 * 	0034 DIGIT FOUR
 * 	70B9 ??
 * 3367 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN
 * 	0031 DIGIT ONE
 * 	0035 DIGIT FIVE
 * 	70B9 ??
 * 3368 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN
 * 	0031 DIGIT ONE
 * 	0036 DIGIT SIX
 * 	70B9 ??
 * 3369 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN
 * 	0031 DIGIT ONE
 * 	0037 DIGIT SEVEN
 * 	70B9 ??
 * 336A IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN
 * 	0031 DIGIT ONE
 * 	0038 DIGIT EIGHT
 * 	70B9 ??
 * 336B IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN
 * 	0031 DIGIT ONE
 * 	0039 DIGIT NINE
 * 	70B9 ??
 * 336C IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY
 * 	0032 DIGIT TWO
 * 	0030 DIGIT ZERO
 * 	70B9 ??
 * 336D IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE
 * 	0032 DIGIT TWO
 * 	0031 DIGIT ONE
 * 	70B9 ??
 * 336E IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO
 * 	0032 DIGIT TWO
 * 	0032 DIGIT TWO
 * 	70B9 ??
 * 336F IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE
 * 	0032 DIGIT TWO
 * 	0033 DIGIT THREE
 * 	70B9 ??
 * 3370 IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR
 * 	0032 DIGIT TWO
 * 	0034 DIGIT FOUR
 * 	70B9 ??
 * 3371 SQUARE HPA
 * 	0068 LATIN SMALL LETTER H
 * 	0050 LATIN CAPITAL LETTER P
 * 	0061 LATIN SMALL LETTER A
 * 3372 SQUARE DA
 * 	0064 LATIN SMALL LETTER D
 * 	0061 LATIN SMALL LETTER A
 * 3373 SQUARE AU
 * 	0041 LATIN CAPITAL LETTER A
 * 	0055 LATIN CAPITAL LETTER U
 * 3374 SQUARE BAR
 * 	0062 LATIN SMALL LETTER B
 * 	0061 LATIN SMALL LETTER A
 * 	0072 LATIN SMALL LETTER R
 * 3375 SQUARE OV
 * 	006F LATIN SMALL LETTER O
 * 	0056 LATIN CAPITAL LETTER V
 * 3376 SQUARE PC
 * 	0070 LATIN SMALL LETTER P
 * 	0063 LATIN SMALL LETTER C
 * 337B SQUARE ERA NAME HEISEI
 * 	5E73 ??
 * 	6210 ??
 * 337C SQUARE ERA NAME SYOUWA
 * 	662D ??
 * 	548C ??
 * 337D SQUARE ERA NAME TAISYOU
 * 	5927 ??
 * 	6B63 ??
 * 337E SQUARE ERA NAME MEIZI
 * 	660E ??
 * 	6CBB ??
 * 337F SQUARE CORPORATION
 * 	682A ??
 * 	5F0F ??
 * 	4F1A ??
 * 	793E ??
 * 3380 SQUARE PA AMPS
 * 	0070 LATIN SMALL LETTER P
 * 	0041 LATIN CAPITAL LETTER A
 * 3381 SQUARE NA
 * 	006E LATIN SMALL LETTER N
 * 	0041 LATIN CAPITAL LETTER A
 * 3382 SQUARE MU A
 * 	03BC GREEK SMALL LETTER MU
 * 	0041 LATIN CAPITAL LETTER A
 * 3383 SQUARE MA
 * 	006D LATIN SMALL LETTER M
 * 	0041 LATIN CAPITAL LETTER A
 * 3384 SQUARE KA
 * 	006B LATIN SMALL LETTER K
 * 	0041 LATIN CAPITAL LETTER A
 * 3385 SQUARE KB
 * 	004B LATIN CAPITAL LETTER K
 * 	0042 LATIN CAPITAL LETTER B
 * 3386 SQUARE MB
 * 	004D LATIN CAPITAL LETTER M
 * 	0042 LATIN CAPITAL LETTER B
 * 3387 SQUARE GB
 * 	0047 LATIN CAPITAL LETTER G
 * 	0042 LATIN CAPITAL LETTER B
 * 3388 SQUARE CAL
 * 	0063 LATIN SMALL LETTER C
 * 	0061 LATIN SMALL LETTER A
 * 	006C LATIN SMALL LETTER L
 * 3389 SQUARE KCAL
 * 	006B LATIN SMALL LETTER K
 * 	0063 LATIN SMALL LETTER C
 * 	0061 LATIN SMALL LETTER A
 * 	006C LATIN SMALL LETTER L
 * 338A SQUARE PF
 * 	0070 LATIN SMALL LETTER P
 * 	0046 LATIN CAPITAL LETTER F
 * 338B SQUARE NF
 * 	006E LATIN SMALL LETTER N
 * 	0046 LATIN CAPITAL LETTER F
 * 338C SQUARE MU F
 * 	03BC GREEK SMALL LETTER MU
 * 	0046 LATIN CAPITAL LETTER F
 * 338D SQUARE MU G
 * 	03BC GREEK SMALL LETTER MU
 * 	0067 LATIN SMALL LETTER G
 * 338E SQUARE MG
 * 	006D LATIN SMALL LETTER M
 * 	0067 LATIN SMALL LETTER G
 * 338F SQUARE KG
 * 	006B LATIN SMALL LETTER K
 * 	0067 LATIN SMALL LETTER G
 * 3390 SQUARE HZ
 * 	0048 LATIN CAPITAL LETTER H
 * 	007A LATIN SMALL LETTER Z
 * 3391 SQUARE KHZ
 * 	006B LATIN SMALL LETTER K
 * 	0048 LATIN CAPITAL LETTER H
 * 	007A LATIN SMALL LETTER Z
 * 3392 SQUARE MHZ
 * 	004D LATIN CAPITAL LETTER M
 * 	0048 LATIN CAPITAL LETTER H
 * 	007A LATIN SMALL LETTER Z
 * 3393 SQUARE GHZ
 * 	0047 LATIN CAPITAL LETTER G
 * 	0048 LATIN CAPITAL LETTER H
 * 	007A LATIN SMALL LETTER Z
 * 3394 SQUARE THZ
 * 	0054 LATIN CAPITAL LETTER T
 * 	0048 LATIN CAPITAL LETTER H
 * 	007A LATIN SMALL LETTER Z
 * 3395 SQUARE MU L
 * 	03BC GREEK SMALL LETTER MU
 * 	006C LATIN SMALL LETTER L
 * 3396 SQUARE ML
 * 	006D LATIN SMALL LETTER M
 * 	006C LATIN SMALL LETTER L
 * 3397 SQUARE DL
 * 	0064 LATIN SMALL LETTER D
 * 	006C LATIN SMALL LETTER L
 * 3398 SQUARE KL
 * 	006B LATIN SMALL LETTER K
 * 	006C LATIN SMALL LETTER L
 * 3399 SQUARE FM
 * 	0066 LATIN SMALL LETTER F
 * 	006D LATIN SMALL LETTER M
 * 339A SQUARE NM
 * 	006E LATIN SMALL LETTER N
 * 	006D LATIN SMALL LETTER M
 * 339B SQUARE MU M
 * 	03BC GREEK SMALL LETTER MU
 * 	006D LATIN SMALL LETTER M
 * 339C SQUARE MM
 * 	006D LATIN SMALL LETTER M
 * 	006D LATIN SMALL LETTER M
 * 339D SQUARE CM
 * 	0063 LATIN SMALL LETTER C
 * 	006D LATIN SMALL LETTER M
 * 339E SQUARE KM
 * 	006B LATIN SMALL LETTER K
 * 	006D LATIN SMALL LETTER M
 * 339F SQUARE MM SQUARED
 * 	006D LATIN SMALL LETTER M
 * 	006D LATIN SMALL LETTER M
 * 	0032 DIGIT TWO
 * 33A0 SQUARE CM SQUARED
 * 	0063 LATIN SMALL LETTER C
 * 	006D LATIN SMALL LETTER M
 * 	0032 DIGIT TWO
 * 33A1 SQUARE M SQUARED
 * 	006D LATIN SMALL LETTER M
 * 	0032 DIGIT TWO
 * 33A2 SQUARE KM SQUARED
 * 	006B LATIN SMALL LETTER K
 * 	006D LATIN SMALL LETTER M
 * 	0032 DIGIT TWO
 * 33A3 SQUARE MM CUBED
 * 	006D LATIN SMALL LETTER M
 * 	006D LATIN SMALL LETTER M
 * 	0033 DIGIT THREE
 * 33A4 SQUARE CM CUBED
 * 	0063 LATIN SMALL LETTER C
 * 	006D LATIN SMALL LETTER M
 * 	0033 DIGIT THREE
 * 33A5 SQUARE M CUBED
 * 	006D LATIN SMALL LETTER M
 * 	0033 DIGIT THREE
 * 33A6 SQUARE KM CUBED
 * 	006B LATIN SMALL LETTER K
 * 	006D LATIN SMALL LETTER M
 * 	0033 DIGIT THREE
 * 33A7 SQUARE M OVER S
 * 	006D LATIN SMALL LETTER M
 * 	2215 DIVISION SLASH
 * 	0073 LATIN SMALL LETTER S
 * 33A8 SQUARE M OVER S SQUARED
 * 	006D LATIN SMALL LETTER M
 * 	2215 DIVISION SLASH
 * 	0073 LATIN SMALL LETTER S
 * 	0032 DIGIT TWO
 * 33A9 SQUARE PA
 * 	0050 LATIN CAPITAL LETTER P
 * 	0061 LATIN SMALL LETTER A
 * 33AA SQUARE KPA
 * 	006B LATIN SMALL LETTER K
 * 	0050 LATIN CAPITAL LETTER P
 * 	0061 LATIN SMALL LETTER A
 * 33AB SQUARE MPA
 * 	004D LATIN CAPITAL LETTER M
 * 	0050 LATIN CAPITAL LETTER P
 * 	0061 LATIN SMALL LETTER A
 * 33AC SQUARE GPA
 * 	0047 LATIN CAPITAL LETTER G
 * 	0050 LATIN CAPITAL LETTER P
 * 	0061 LATIN SMALL LETTER A
 * 33AD SQUARE RAD
 * 	0072 LATIN SMALL LETTER R
 * 	0061 LATIN SMALL LETTER A
 * 	0064 LATIN SMALL LETTER D
 * 33AE SQUARE RAD OVER S
 * 	0072 LATIN SMALL LETTER R
 * 	0061 LATIN SMALL LETTER A
 * 	0064 LATIN SMALL LETTER D
 * 	2215 DIVISION SLASH
 * 	0073 LATIN SMALL LETTER S
 * 33AF SQUARE RAD OVER S SQUARED
 * 	0072 LATIN SMALL LETTER R
 * 	0061 LATIN SMALL LETTER A
 * 	0064 LATIN SMALL LETTER D
 * 	2215 DIVISION SLASH
 * 	0073 LATIN SMALL LETTER S
 * 	0032 DIGIT TWO
 * 33B0 SQUARE PS
 * 	0070 LATIN SMALL LETTER P
 * 	0073 LATIN SMALL LETTER S
 * 33B1 SQUARE NS
 * 	006E LATIN SMALL LETTER N
 * 	0073 LATIN SMALL LETTER S
 * 33B2 SQUARE MU S
 * 	03BC GREEK SMALL LETTER MU
 * 	0073 LATIN SMALL LETTER S
 * 33B3 SQUARE MS
 * 	006D LATIN SMALL LETTER M
 * 	0073 LATIN SMALL LETTER S
 * 33B4 SQUARE PV
 * 	0070 LATIN SMALL LETTER P
 * 	0056 LATIN CAPITAL LETTER V
 * 33B5 SQUARE NV
 * 	006E LATIN SMALL LETTER N
 * 	0056 LATIN CAPITAL LETTER V
 * 33B6 SQUARE MU V
 * 	03BC GREEK SMALL LETTER MU
 * 	0056 LATIN CAPITAL LETTER V
 * 33B7 SQUARE MV
 * 	006D LATIN SMALL LETTER M
 * 	0056 LATIN CAPITAL LETTER V
 * 33B8 SQUARE KV
 * 	006B LATIN SMALL LETTER K
 * 	0056 LATIN CAPITAL LETTER V
 * 33B9 SQUARE MV MEGA
 * 	004D LATIN CAPITAL LETTER M
 * 	0056 LATIN CAPITAL LETTER V
 * 33BA SQUARE PW
 * 	0070 LATIN SMALL LETTER P
 * 	0057 LATIN CAPITAL LETTER W
 * 33BB SQUARE NW
 * 	006E LATIN SMALL LETTER N
 * 	0057 LATIN CAPITAL LETTER W
 * 33BC SQUARE MU W
 * 	03BC GREEK SMALL LETTER MU
 * 	0057 LATIN CAPITAL LETTER W
 * 33BD SQUARE MW
 * 	006D LATIN SMALL LETTER M
 * 	0057 LATIN CAPITAL LETTER W
 * 33BE SQUARE KW
 * 	006B LATIN SMALL LETTER K
 * 	0057 LATIN CAPITAL LETTER W
 * 33BF SQUARE MW MEGA
 * 	004D LATIN CAPITAL LETTER M
 * 	0057 LATIN CAPITAL LETTER W
 * 33C0 SQUARE K OHM
 * 	006B LATIN SMALL LETTER K
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 33C1 SQUARE M OHM
 * 	004D LATIN CAPITAL LETTER M
 * 	03A9 GREEK CAPITAL LETTER OMEGA
 * 33C2 SQUARE AM
 * 	0061 LATIN SMALL LETTER A
 * 	002E FULL STOP
 * 	006D LATIN SMALL LETTER M
 * 	002E FULL STOP
 * 33C3 SQUARE BQ
 * 	0042 LATIN CAPITAL LETTER B
 * 	0071 LATIN SMALL LETTER Q
 * 33C4 SQUARE CC
 * 	0063 LATIN SMALL LETTER C
 * 	0063 LATIN SMALL LETTER C
 * 33C5 SQUARE CD
 * 	0063 LATIN SMALL LETTER C
 * 	0064 LATIN SMALL LETTER D
 * 33C6 SQUARE C OVER KG
 * 	0043 LATIN CAPITAL LETTER C
 * 	2215 DIVISION SLASH
 * 	006B LATIN SMALL LETTER K
 * 	0067 LATIN SMALL LETTER G
 * 33C7 SQUARE CO
 * 	0043 LATIN CAPITAL LETTER C
 * 	006F LATIN SMALL LETTER O
 * 	002E FULL STOP
 * 33C8 SQUARE DB
 * 	0064 LATIN SMALL LETTER D
 * 	0042 LATIN CAPITAL LETTER B
 * 33C9 SQUARE GY
 * 	0047 LATIN CAPITAL LETTER G
 * 	0079 LATIN SMALL LETTER Y
 * 33CA SQUARE HA
 * 	0068 LATIN SMALL LETTER H
 * 	0061 LATIN SMALL LETTER A
 * 33CB SQUARE HP
 * 	0048 LATIN CAPITAL LETTER H
 * 	0050 LATIN CAPITAL LETTER P
 * 33CC SQUARE IN
 * 	0069 LATIN SMALL LETTER I
 * 	006E LATIN SMALL LETTER N
 * 33CD SQUARE KK
 * 	004B LATIN CAPITAL LETTER K
 * 	004B LATIN CAPITAL LETTER K
 * 33CE SQUARE KM CAPITAL
 * 	004B LATIN CAPITAL LETTER K
 * 	004D LATIN CAPITAL LETTER M
 * 33CF SQUARE KT
 * 	006B LATIN SMALL LETTER K
 * 	0074 LATIN SMALL LETTER T
 * 33D0 SQUARE LM
 * 	006C LATIN SMALL LETTER L
 * 	006D LATIN SMALL LETTER M
 * 33D1 SQUARE LN
 * 	006C LATIN SMALL LETTER L
 * 	006E LATIN SMALL LETTER N
 * 33D2 SQUARE LOG
 * 	006C LATIN SMALL LETTER L
 * 	006F LATIN SMALL LETTER O
 * 	0067 LATIN SMALL LETTER G
 * 33D3 SQUARE LX
 * 	006C LATIN SMALL LETTER L
 * 	0078 LATIN SMALL LETTER X
 * 33D4 SQUARE MB SMALL
 * 	006D LATIN SMALL LETTER M
 * 	0062 LATIN SMALL LETTER B
 * 33D5 SQUARE MIL
 * 	006D LATIN SMALL LETTER M
 * 	0069 LATIN SMALL LETTER I
 * 	006C LATIN SMALL LETTER L
 * 33D6 SQUARE MOL
 * 	006D LATIN SMALL LETTER M
 * 	006F LATIN SMALL LETTER O
 * 	006C LATIN SMALL LETTER L
 * 33D7 SQUARE PH
 * 	0050 LATIN CAPITAL LETTER P
 * 	0048 LATIN CAPITAL LETTER H
 * 33D8 SQUARE PM
 * 	0070 LATIN SMALL LETTER P
 * 	002E FULL STOP
 * 	006D LATIN SMALL LETTER M
 * 	002E FULL STOP
 * 33D9 SQUARE PPM
 * 	0050 LATIN CAPITAL LETTER P
 * 	0050 LATIN CAPITAL LETTER P
 * 	004D LATIN CAPITAL LETTER M
 * 33DA SQUARE PR
 * 	0050 LATIN CAPITAL LETTER P
 * 	0052 LATIN CAPITAL LETTER R
 * 33DB SQUARE SR
 * 	0073 LATIN SMALL LETTER S
 * 	0072 LATIN SMALL LETTER R
 * 33DC SQUARE SV
 * 	0053 LATIN CAPITAL LETTER S
 * 	0076 LATIN SMALL LETTER V
 * 33DD SQUARE WB
 * 	0057 LATIN CAPITAL LETTER W
 * 	0062 LATIN SMALL LETTER B
 * 33E0 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE
 * 	0031 DIGIT ONE
 * 	65E5 ??
 * 33E1 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO
 * 	0032 DIGIT TWO
 * 	65E5 ??
 * 33E2 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE
 * 	0033 DIGIT THREE
 * 	65E5 ??
 * 33E3 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR
 * 	0034 DIGIT FOUR
 * 	65E5 ??
 * 33E4 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE
 * 	0035 DIGIT FIVE
 * 	65E5 ??
 * 33E5 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX
 * 	0036 DIGIT SIX
 * 	65E5 ??
 * 33E6 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN
 * 	0037 DIGIT SEVEN
 * 	65E5 ??
 * 33E7 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT
 * 	0038 DIGIT EIGHT
 * 	65E5 ??
 * 33E8 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE
 * 	0039 DIGIT NINE
 * 	65E5 ??
 * 33E9 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN
 * 	0031 DIGIT ONE
 * 	0030 DIGIT ZERO
 * 	65E5 ??
 * 33EA IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN
 * 	0031 DIGIT ONE
 * 	0031 DIGIT ONE
 * 	65E5 ??
 * 33EB IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE
 * 	0031 DIGIT ONE
 * 	0032 DIGIT TWO
 * 	65E5 ??
 * 33EC IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN
 * 	0031 DIGIT ONE
 * 	0033 DIGIT THREE
 * 	65E5 ??
 * 33ED IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN
 * 	0031 DIGIT ONE
 * 	0034 DIGIT FOUR
 * 	65E5 ??
 * 33EE IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN
 * 	0031 DIGIT ONE
 * 	0035 DIGIT FIVE
 * 	65E5 ??
 * 33EF IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN
 * 	0031 DIGIT ONE
 * 	0036 DIGIT SIX
 * 	65E5 ??
 * 33F0 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN
 * 	0031 DIGIT ONE
 * 	0037 DIGIT SEVEN
 * 	65E5 ??
 * 33F1 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN
 * 	0031 DIGIT ONE
 * 	0038 DIGIT EIGHT
 * 	65E5 ??
 * 33F2 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN
 * 	0031 DIGIT ONE
 * 	0039 DIGIT NINE
 * 	65E5 ??
 * 33F3 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY
 * 	0032 DIGIT TWO
 * 	0030 DIGIT ZERO
 * 	65E5 ??
 * 33F4 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE
 * 	0032 DIGIT TWO
 * 	0031 DIGIT ONE
 * 	65E5 ??
 * 33F5 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO
 * 	0032 DIGIT TWO
 * 	0032 DIGIT TWO
 * 	65E5 ??
 * 33F6 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE
 * 	0032 DIGIT TWO
 * 	0033 DIGIT THREE
 * 	65E5 ??
 * 33F7 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR
 * 	0032 DIGIT TWO
 * 	0034 DIGIT FOUR
 * 	65E5 ??
 * 33F8 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE
 * 	0032 DIGIT TWO
 * 	0035 DIGIT FIVE
 * 	65E5 ??
 * 33F9 IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX
 * 	0032 DIGIT TWO
 * 	0036 DIGIT SIX
 * 	65E5 ??
 * 33FA IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN
 * 	0032 DIGIT TWO
 * 	0037 DIGIT SEVEN
 * 	65E5 ??
 * 33FB IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT
 * 	0032 DIGIT TWO
 * 	0038 DIGIT EIGHT
 * 	65E5 ??
 * 33FC IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE
 * 	0032 DIGIT TWO
 * 	0039 DIGIT NINE
 * 	65E5 ??
 * 33FD IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY
 * 	0033 DIGIT THREE
 * 	0030 DIGIT ZERO
 * 	65E5 ??
 * 33FE IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE
 * 	0033 DIGIT THREE
 * 	0031 DIGIT ONE
 * 	65E5 ??
 * F900 CJK COMPATIBILITY IDEOGRAPH-F900
 * 	8C48 ??
 * F901 CJK COMPATIBILITY IDEOGRAPH-F901
 * 	66F4 ??
 * F902 CJK COMPATIBILITY IDEOGRAPH-F902
 * 	8ECA ??
 * F903 CJK COMPATIBILITY IDEOGRAPH-F903
 * 	8CC8 ??
 * F904 CJK COMPATIBILITY IDEOGRAPH-F904
 * 	6ED1 ??
 * F905 CJK COMPATIBILITY IDEOGRAPH-F905
 * 	4E32 ??
 * F906 CJK COMPATIBILITY IDEOGRAPH-F906
 * 	53E5 ??
 * F907 CJK COMPATIBILITY IDEOGRAPH-F907
 * 	9F9C ??
 * F908 CJK COMPATIBILITY IDEOGRAPH-F908
 * 	9F9C ??
 * F909 CJK COMPATIBILITY IDEOGRAPH-F909
 * 	5951 ??
 * F90A CJK COMPATIBILITY IDEOGRAPH-F90A
 * 	91D1 ??
 * F90B CJK COMPATIBILITY IDEOGRAPH-F90B
 * 	5587 ??
 * F90C CJK COMPATIBILITY IDEOGRAPH-F90C
 * 	5948 ??
 * F90D CJK COMPATIBILITY IDEOGRAPH-F90D
 * 	61F6 ??
 * F90E CJK COMPATIBILITY IDEOGRAPH-F90E
 * 	7669 ??
 * F90F CJK COMPATIBILITY IDEOGRAPH-F90F
 * 	7F85 ??
 * F910 CJK COMPATIBILITY IDEOGRAPH-F910
 * 	863F ??
 * F911 CJK COMPATIBILITY IDEOGRAPH-F911
 * 	87BA ??
 * F912 CJK COMPATIBILITY IDEOGRAPH-F912
 * 	88F8 ??
 * F913 CJK COMPATIBILITY IDEOGRAPH-F913
 * 	908F ??
 * F914 CJK COMPATIBILITY IDEOGRAPH-F914
 * 	6A02 ??
 * F915 CJK COMPATIBILITY IDEOGRAPH-F915
 * 	6D1B ??
 * F916 CJK COMPATIBILITY IDEOGRAPH-F916
 * 	70D9 ??
 * F917 CJK COMPATIBILITY IDEOGRAPH-F917
 * 	73DE ??
 * F918 CJK COMPATIBILITY IDEOGRAPH-F918
 * 	843D ??
 * F919 CJK COMPATIBILITY IDEOGRAPH-F919
 * 	916A ??
 * F91A CJK COMPATIBILITY IDEOGRAPH-F91A
 * 	99F1 ??
 * F91B CJK COMPATIBILITY IDEOGRAPH-F91B
 * 	4E82 ??
 * F91C CJK COMPATIBILITY IDEOGRAPH-F91C
 * 	5375 ??
 * F91D CJK COMPATIBILITY IDEOGRAPH-F91D
 * 	6B04 ??
 * F91E CJK COMPATIBILITY IDEOGRAPH-F91E
 * 	721B ??
 * F91F CJK COMPATIBILITY IDEOGRAPH-F91F
 * 	862D ??
 * F920 CJK COMPATIBILITY IDEOGRAPH-F920
 * 	9E1E ??
 * F921 CJK COMPATIBILITY IDEOGRAPH-F921
 * 	5D50 ??
 * F922 CJK COMPATIBILITY IDEOGRAPH-F922
 * 	6FEB ??
 * F923 CJK COMPATIBILITY IDEOGRAPH-F923
 * 	85CD ??
 * F924 CJK COMPATIBILITY IDEOGRAPH-F924
 * 	8964 ??
 * F925 CJK COMPATIBILITY IDEOGRAPH-F925
 * 	62C9 ??
 * F926 CJK COMPATIBILITY IDEOGRAPH-F926
 * 	81D8 ??
 * F927 CJK COMPATIBILITY IDEOGRAPH-F927
 * 	881F ??
 * F928 CJK COMPATIBILITY IDEOGRAPH-F928
 * 	5ECA ??
 * F929 CJK COMPATIBILITY IDEOGRAPH-F929
 * 	6717 ??
 * F92A CJK COMPATIBILITY IDEOGRAPH-F92A
 * 	6D6A ??
 * F92B CJK COMPATIBILITY IDEOGRAPH-F92B
 * 	72FC ??
 * F92C CJK COMPATIBILITY IDEOGRAPH-F92C
 * 	90CE ??
 * F92D CJK COMPATIBILITY IDEOGRAPH-F92D
 * 	4F86 ??
 * F92E CJK COMPATIBILITY IDEOGRAPH-F92E
 * 	51B7 ??
 * F92F CJK COMPATIBILITY IDEOGRAPH-F92F
 * 	52DE ??
 * F930 CJK COMPATIBILITY IDEOGRAPH-F930
 * 	64C4 ??
 * F931 CJK COMPATIBILITY IDEOGRAPH-F931
 * 	6AD3 ??
 * F932 CJK COMPATIBILITY IDEOGRAPH-F932
 * 	7210 ??
 * F933 CJK COMPATIBILITY IDEOGRAPH-F933
 * 	76E7 ??
 * F934 CJK COMPATIBILITY IDEOGRAPH-F934
 * 	8001 ??
 * F935 CJK COMPATIBILITY IDEOGRAPH-F935
 * 	8606 ??
 * F936 CJK COMPATIBILITY IDEOGRAPH-F936
 * 	865C ??
 * F937 CJK COMPATIBILITY IDEOGRAPH-F937
 * 	8DEF ??
 * F938 CJK COMPATIBILITY IDEOGRAPH-F938
 * 	9732 ??
 * F939 CJK COMPATIBILITY IDEOGRAPH-F939
 * 	9B6F ??
 * F93A CJK COMPATIBILITY IDEOGRAPH-F93A
 * 	9DFA ??
 * F93B CJK COMPATIBILITY IDEOGRAPH-F93B
 * 	788C ??
 * F93C CJK COMPATIBILITY IDEOGRAPH-F93C
 * 	797F ??
 * F93D CJK COMPATIBILITY IDEOGRAPH-F93D
 * 	7DA0 ??
 * F93E CJK COMPATIBILITY IDEOGRAPH-F93E
 * 	83C9 ??
 * F93F CJK COMPATIBILITY IDEOGRAPH-F93F
 * 	9304 ??
 * F940 CJK COMPATIBILITY IDEOGRAPH-F940
 * 	9E7F ??
 * F941 CJK COMPATIBILITY IDEOGRAPH-F941
 * 	8AD6 ??
 * F942 CJK COMPATIBILITY IDEOGRAPH-F942
 * 	58DF ??
 * F943 CJK COMPATIBILITY IDEOGRAPH-F943
 * 	5F04 ??
 * F944 CJK COMPATIBILITY IDEOGRAPH-F944
 * 	7C60 ??
 * F945 CJK COMPATIBILITY IDEOGRAPH-F945
 * 	807E ??
 * F946 CJK COMPATIBILITY IDEOGRAPH-F946
 * 	7262 ??
 * F947 CJK COMPATIBILITY IDEOGRAPH-F947
 * 	78CA ??
 * F948 CJK COMPATIBILITY IDEOGRAPH-F948
 * 	8CC2 ??
 * F949 CJK COMPATIBILITY IDEOGRAPH-F949
 * 	96F7 ??
 * F94A CJK COMPATIBILITY IDEOGRAPH-F94A
 * 	58D8 ??
 * F94B CJK COMPATIBILITY IDEOGRAPH-F94B
 * 	5C62 ??
 * F94C CJK COMPATIBILITY IDEOGRAPH-F94C
 * 	6A13 ??
 * F94D CJK COMPATIBILITY IDEOGRAPH-F94D
 * 	6DDA ??
 * F94E CJK COMPATIBILITY IDEOGRAPH-F94E
 * 	6F0F ??
 * F94F CJK COMPATIBILITY IDEOGRAPH-F94F
 * 	7D2F ??
 * F950 CJK COMPATIBILITY IDEOGRAPH-F950
 * 	7E37 ??
 * F951 CJK COMPATIBILITY IDEOGRAPH-F951
 * 	964B ??
 * F952 CJK COMPATIBILITY IDEOGRAPH-F952
 * 	52D2 ??
 * F953 CJK COMPATIBILITY IDEOGRAPH-F953
 * 	808B ??
 * F954 CJK COMPATIBILITY IDEOGRAPH-F954
 * 	51DC ??
 * F955 CJK COMPATIBILITY IDEOGRAPH-F955
 * 	51CC ??
 * F956 CJK COMPATIBILITY IDEOGRAPH-F956
 * 	7A1C ??
 * F957 CJK COMPATIBILITY IDEOGRAPH-F957
 * 	7DBE ??
 * F958 CJK COMPATIBILITY IDEOGRAPH-F958
 * 	83F1 ??
 * F959 CJK COMPATIBILITY IDEOGRAPH-F959
 * 	9675 ??
 * F95A CJK COMPATIBILITY IDEOGRAPH-F95A
 * 	8B80 ??
 * F95B CJK COMPATIBILITY IDEOGRAPH-F95B
 * 	62CF ??
 * F95C CJK COMPATIBILITY IDEOGRAPH-F95C
 * 	6A02 ??
 * F95D CJK COMPATIBILITY IDEOGRAPH-F95D
 * 	8AFE ??
 * F95E CJK COMPATIBILITY IDEOGRAPH-F95E
 * 	4E39 ??
 * F95F CJK COMPATIBILITY IDEOGRAPH-F95F
 * 	5BE7 ??
 * F960 CJK COMPATIBILITY IDEOGRAPH-F960
 * 	6012 ??
 * F961 CJK COMPATIBILITY IDEOGRAPH-F961
 * 	7387 ??
 * F962 CJK COMPATIBILITY IDEOGRAPH-F962
 * 	7570 ??
 * F963 CJK COMPATIBILITY IDEOGRAPH-F963
 * 	5317 ??
 * F964 CJK COMPATIBILITY IDEOGRAPH-F964
 * 	78FB ??
 * F965 CJK COMPATIBILITY IDEOGRAPH-F965
 * 	4FBF ??
 * F966 CJK COMPATIBILITY IDEOGRAPH-F966
 * 	5FA9 ??
 * F967 CJK COMPATIBILITY IDEOGRAPH-F967
 * 	4E0D ??
 * F968 CJK COMPATIBILITY IDEOGRAPH-F968
 * 	6CCC ??
 * F969 CJK COMPATIBILITY IDEOGRAPH-F969
 * 	6578 ??
 * F96A CJK COMPATIBILITY IDEOGRAPH-F96A
 * 	7D22 ??
 * F96B CJK COMPATIBILITY IDEOGRAPH-F96B
 * 	53C3 ??
 * F96C CJK COMPATIBILITY IDEOGRAPH-F96C
 * 	585E ??
 * F96D CJK COMPATIBILITY IDEOGRAPH-F96D
 * 	7701 ??
 * F96E CJK COMPATIBILITY IDEOGRAPH-F96E
 * 	8449 ??
 * F96F CJK COMPATIBILITY IDEOGRAPH-F96F
 * 	8AAA ??
 * F970 CJK COMPATIBILITY IDEOGRAPH-F970
 * 	6BBA ??
 * F971 CJK COMPATIBILITY IDEOGRAPH-F971
 * 	8FB0 ??
 * F972 CJK COMPATIBILITY IDEOGRAPH-F972
 * 	6C88 ??
 * F973 CJK COMPATIBILITY IDEOGRAPH-F973
 * 	62FE ??
 * F974 CJK COMPATIBILITY IDEOGRAPH-F974
 * 	82E5 ??
 * F975 CJK COMPATIBILITY IDEOGRAPH-F975
 * 	63A0 ??
 * F976 CJK COMPATIBILITY IDEOGRAPH-F976
 * 	7565 ??
 * F977 CJK COMPATIBILITY IDEOGRAPH-F977
 * 	4EAE ??
 * F978 CJK COMPATIBILITY IDEOGRAPH-F978
 * 	5169 ??
 * F979 CJK COMPATIBILITY IDEOGRAPH-F979
 * 	51C9 ??
 * F97A CJK COMPATIBILITY IDEOGRAPH-F97A
 * 	6881 ??
 * F97B CJK COMPATIBILITY IDEOGRAPH-F97B
 * 	7CE7 ??
 * F97C CJK COMPATIBILITY IDEOGRAPH-F97C
 * 	826F ??
 * F97D CJK COMPATIBILITY IDEOGRAPH-F97D
 * 	8AD2 ??
 * F97E CJK COMPATIBILITY IDEOGRAPH-F97E
 * 	91CF ??
 * F97F CJK COMPATIBILITY IDEOGRAPH-F97F
 * 	52F5 ??
 * F980 CJK COMPATIBILITY IDEOGRAPH-F980
 * 	5442 ??
 * F981 CJK COMPATIBILITY IDEOGRAPH-F981
 * 	5973 ??
 * F982 CJK COMPATIBILITY IDEOGRAPH-F982
 * 	5EEC ??
 * F983 CJK COMPATIBILITY IDEOGRAPH-F983
 * 	65C5 ??
 * F984 CJK COMPATIBILITY IDEOGRAPH-F984
 * 	6FFE ??
 * F985 CJK COMPATIBILITY IDEOGRAPH-F985
 * 	792A ??
 * F986 CJK COMPATIBILITY IDEOGRAPH-F986
 * 	95AD ??
 * F987 CJK COMPATIBILITY IDEOGRAPH-F987
 * 	9A6A ??
 * F988 CJK COMPATIBILITY IDEOGRAPH-F988
 * 	9E97 ??
 * F989 CJK COMPATIBILITY IDEOGRAPH-F989
 * 	9ECE ??
 * F98A CJK COMPATIBILITY IDEOGRAPH-F98A
 * 	529B ??
 * F98B CJK COMPATIBILITY IDEOGRAPH-F98B
 * 	66C6 ??
 * F98C CJK COMPATIBILITY IDEOGRAPH-F98C
 * 	6B77 ??
 * F98D CJK COMPATIBILITY IDEOGRAPH-F98D
 * 	8F62 ??
 * F98E CJK COMPATIBILITY IDEOGRAPH-F98E
 * 	5E74 ??
 * F98F CJK COMPATIBILITY IDEOGRAPH-F98F
 * 	6190 ??
 * F990 CJK COMPATIBILITY IDEOGRAPH-F990
 * 	6200 ??
 * F991 CJK COMPATIBILITY IDEOGRAPH-F991
 * 	649A ??
 * F992 CJK COMPATIBILITY IDEOGRAPH-F992
 * 	6F23 ??
 * F993 CJK COMPATIBILITY IDEOGRAPH-F993
 * 	7149 ??
 * F994 CJK COMPATIBILITY IDEOGRAPH-F994
 * 	7489 ??
 * F995 CJK COMPATIBILITY IDEOGRAPH-F995
 * 	79CA ??
 * F996 CJK COMPATIBILITY IDEOGRAPH-F996
 * 	7DF4 ??
 * F997 CJK COMPATIBILITY IDEOGRAPH-F997
 * 	806F ??
 * F998 CJK COMPATIBILITY IDEOGRAPH-F998
 * 	8F26 ??
 * F999 CJK COMPATIBILITY IDEOGRAPH-F999
 * 	84EE ??
 * F99A CJK COMPATIBILITY IDEOGRAPH-F99A
 * 	9023 ??
 * F99B CJK COMPATIBILITY IDEOGRAPH-F99B
 * 	934A ??
 * F99C CJK COMPATIBILITY IDEOGRAPH-F99C
 * 	5217 ??
 * F99D CJK COMPATIBILITY IDEOGRAPH-F99D
 * 	52A3 ??
 * F99E CJK COMPATIBILITY IDEOGRAPH-F99E
 * 	54BD ??
 * F99F CJK COMPATIBILITY IDEOGRAPH-F99F
 * 	70C8 ??
 * F9A0 CJK COMPATIBILITY IDEOGRAPH-F9A0
 * 	88C2 ??
 * F9A1 CJK COMPATIBILITY IDEOGRAPH-F9A1
 * 	8AAA ??
 * F9A2 CJK COMPATIBILITY IDEOGRAPH-F9A2
 * 	5EC9 ??
 * F9A3 CJK COMPATIBILITY IDEOGRAPH-F9A3
 * 	5FF5 ??
 * F9A4 CJK COMPATIBILITY IDEOGRAPH-F9A4
 * 	637B ??
 * F9A5 CJK COMPATIBILITY IDEOGRAPH-F9A5
 * 	6BAE ??
 * F9A6 CJK COMPATIBILITY IDEOGRAPH-F9A6
 * 	7C3E ??
 * F9A7 CJK COMPATIBILITY IDEOGRAPH-F9A7
 * 	7375 ??
 * F9A8 CJK COMPATIBILITY IDEOGRAPH-F9A8
 * 	4EE4 ??
 * F9A9 CJK COMPATIBILITY IDEOGRAPH-F9A9
 * 	56F9 ??
 * F9AA CJK COMPATIBILITY IDEOGRAPH-F9AA
 * 	5BE7 ??
 * F9AB CJK COMPATIBILITY IDEOGRAPH-F9AB
 * 	5DBA ??
 * F9AC CJK COMPATIBILITY IDEOGRAPH-F9AC
 * 	601C ??
 * F9AD CJK COMPATIBILITY IDEOGRAPH-F9AD
 * 	73B2 ??
 * F9AE CJK COMPATIBILITY IDEOGRAPH-F9AE
 * 	7469 ??
 * F9AF CJK COMPATIBILITY IDEOGRAPH-F9AF
 * 	7F9A ??
 * F9B0 CJK COMPATIBILITY IDEOGRAPH-F9B0
 * 	8046 ??
 * F9B1 CJK COMPATIBILITY IDEOGRAPH-F9B1
 * 	9234 ??
 * F9B2 CJK COMPATIBILITY IDEOGRAPH-F9B2
 * 	96F6 ??
 * F9B3 CJK COMPATIBILITY IDEOGRAPH-F9B3
 * 	9748 ??
 * F9B4 CJK COMPATIBILITY IDEOGRAPH-F9B4
 * 	9818 ??
 * F9B5 CJK COMPATIBILITY IDEOGRAPH-F9B5
 * 	4F8B ??
 * F9B6 CJK COMPATIBILITY IDEOGRAPH-F9B6
 * 	79AE ??
 * F9B7 CJK COMPATIBILITY IDEOGRAPH-F9B7
 * 	91B4 ??
 * F9B8 CJK COMPATIBILITY IDEOGRAPH-F9B8
 * 	96B8 ??
 * F9B9 CJK COMPATIBILITY IDEOGRAPH-F9B9
 * 	60E1 ??
 * F9BA CJK COMPATIBILITY IDEOGRAPH-F9BA
 * 	4E86 ??
 * F9BB CJK COMPATIBILITY IDEOGRAPH-F9BB
 * 	50DA ??
 * F9BC CJK COMPATIBILITY IDEOGRAPH-F9BC
 * 	5BEE ??
 * F9BD CJK COMPATIBILITY IDEOGRAPH-F9BD
 * 	5C3F ??
 * F9BE CJK COMPATIBILITY IDEOGRAPH-F9BE
 * 	6599 ??
 * F9BF CJK COMPATIBILITY IDEOGRAPH-F9BF
 * 	6A02 ??
 * F9C0 CJK COMPATIBILITY IDEOGRAPH-F9C0
 * 	71CE ??
 * F9C1 CJK COMPATIBILITY IDEOGRAPH-F9C1
 * 	7642 ??
 * F9C2 CJK COMPATIBILITY IDEOGRAPH-F9C2
 * 	84FC ??
 * F9C3 CJK COMPATIBILITY IDEOGRAPH-F9C3
 * 	907C ??
 * F9C4 CJK COMPATIBILITY IDEOGRAPH-F9C4
 * 	9F8D ??
 * F9C5 CJK COMPATIBILITY IDEOGRAPH-F9C5
 * 	6688 ??
 * F9C6 CJK COMPATIBILITY IDEOGRAPH-F9C6
 * 	962E ??
 * F9C7 CJK COMPATIBILITY IDEOGRAPH-F9C7
 * 	5289 ??
 * F9C8 CJK COMPATIBILITY IDEOGRAPH-F9C8
 * 	677B ??
 * F9C9 CJK COMPATIBILITY IDEOGRAPH-F9C9
 * 	67F3 ??
 * F9CA CJK COMPATIBILITY IDEOGRAPH-F9CA
 * 	6D41 ??
 * F9CB CJK COMPATIBILITY IDEOGRAPH-F9CB
 * 	6E9C ??
 * F9CC CJK COMPATIBILITY IDEOGRAPH-F9CC
 * 	7409 ??
 * F9CD CJK COMPATIBILITY IDEOGRAPH-F9CD
 * 	7559 ??
 * F9CE CJK COMPATIBILITY IDEOGRAPH-F9CE
 * 	786B ??
 * F9CF CJK COMPATIBILITY IDEOGRAPH-F9CF
 * 	7D10 ??
 * F9D0 CJK COMPATIBILITY IDEOGRAPH-F9D0
 * 	985E ??
 * F9D1 CJK COMPATIBILITY IDEOGRAPH-F9D1
 * 	516D ??
 * F9D2 CJK COMPATIBILITY IDEOGRAPH-F9D2
 * 	622E ??
 * F9D3 CJK COMPATIBILITY IDEOGRAPH-F9D3
 * 	9678 ??
 * F9D4 CJK COMPATIBILITY IDEOGRAPH-F9D4
 * 	502B ??
 * F9D5 CJK COMPATIBILITY IDEOGRAPH-F9D5
 * 	5D19 ??
 * F9D6 CJK COMPATIBILITY IDEOGRAPH-F9D6
 * 	6DEA ??
 * F9D7 CJK COMPATIBILITY IDEOGRAPH-F9D7
 * 	8F2A ??
 * F9D8 CJK COMPATIBILITY IDEOGRAPH-F9D8
 * 	5F8B ??
 * F9D9 CJK COMPATIBILITY IDEOGRAPH-F9D9
 * 	6144 ??
 * F9DA CJK COMPATIBILITY IDEOGRAPH-F9DA
 * 	6817 ??
 * F9DB CJK COMPATIBILITY IDEOGRAPH-F9DB
 * 	7387 ??
 * F9DC CJK COMPATIBILITY IDEOGRAPH-F9DC
 * 	9686 ??
 * F9DD CJK COMPATIBILITY IDEOGRAPH-F9DD
 * 	5229 ??
 * F9DE CJK COMPATIBILITY IDEOGRAPH-F9DE
 * 	540F ??
 * F9DF CJK COMPATIBILITY IDEOGRAPH-F9DF
 * 	5C65 ??
 * F9E0 CJK COMPATIBILITY IDEOGRAPH-F9E0
 * 	6613 ??
 * F9E1 CJK COMPATIBILITY IDEOGRAPH-F9E1
 * 	674E ??
 * F9E2 CJK COMPATIBILITY IDEOGRAPH-F9E2
 * 	68A8 ??
 * F9E3 CJK COMPATIBILITY IDEOGRAPH-F9E3
 * 	6CE5 ??
 * F9E4 CJK COMPATIBILITY IDEOGRAPH-F9E4
 * 	7406 ??
 * F9E5 CJK COMPATIBILITY IDEOGRAPH-F9E5
 * 	75E2 ??
 * F9E6 CJK COMPATIBILITY IDEOGRAPH-F9E6
 * 	7F79 ??
 * F9E7 CJK COMPATIBILITY IDEOGRAPH-F9E7
 * 	88CF ??
 * F9E8 CJK COMPATIBILITY IDEOGRAPH-F9E8
 * 	88E1 ??
 * F9E9 CJK COMPATIBILITY IDEOGRAPH-F9E9
 * 	91CC ??
 * F9EA CJK COMPATIBILITY IDEOGRAPH-F9EA
 * 	96E2 ??
 * F9EB CJK COMPATIBILITY IDEOGRAPH-F9EB
 * 	533F ??
 * F9EC CJK COMPATIBILITY IDEOGRAPH-F9EC
 * 	6EBA ??
 * F9ED CJK COMPATIBILITY IDEOGRAPH-F9ED
 * 	541D ??
 * F9EE CJK COMPATIBILITY IDEOGRAPH-F9EE
 * 	71D0 ??
 * F9EF CJK COMPATIBILITY IDEOGRAPH-F9EF
 * 	7498 ??
 * F9F0 CJK COMPATIBILITY IDEOGRAPH-F9F0
 * 	85FA ??
 * F9F1 CJK COMPATIBILITY IDEOGRAPH-F9F1
 * 	96A3 ??
 * F9F2 CJK COMPATIBILITY IDEOGRAPH-F9F2
 * 	9C57 ??
 * F9F3 CJK COMPATIBILITY IDEOGRAPH-F9F3
 * 	9E9F ??
 * F9F4 CJK COMPATIBILITY IDEOGRAPH-F9F4
 * 	6797 ??
 * F9F5 CJK COMPATIBILITY IDEOGRAPH-F9F5
 * 	6DCB ??
 * F9F6 CJK COMPATIBILITY IDEOGRAPH-F9F6
 * 	81E8 ??
 * F9F7 CJK COMPATIBILITY IDEOGRAPH-F9F7
 * 	7ACB ??
 * F9F8 CJK COMPATIBILITY IDEOGRAPH-F9F8
 * 	7B20 ??
 * F9F9 CJK COMPATIBILITY IDEOGRAPH-F9F9
 * 	7C92 ??
 * F9FA CJK COMPATIBILITY IDEOGRAPH-F9FA
 * 	72C0 ??
 * F9FB CJK COMPATIBILITY IDEOGRAPH-F9FB
 * 	7099 ??
 * F9FC CJK COMPATIBILITY IDEOGRAPH-F9FC
 * 	8B58 ??
 * F9FD CJK COMPATIBILITY IDEOGRAPH-F9FD
 * 	4EC0 ??
 * F9FE CJK COMPATIBILITY IDEOGRAPH-F9FE
 * 	8336 ??
 * F9FF CJK COMPATIBILITY IDEOGRAPH-F9FF
 * 	523A ??
 * FA00 CJK COMPATIBILITY IDEOGRAPH-FA00
 * 	5207 ??
 * FA01 CJK COMPATIBILITY IDEOGRAPH-FA01
 * 	5EA6 ??
 * FA02 CJK COMPATIBILITY IDEOGRAPH-FA02
 * 	62D3 ??
 * FA03 CJK COMPATIBILITY IDEOGRAPH-FA03
 * 	7CD6 ??
 * FA04 CJK COMPATIBILITY IDEOGRAPH-FA04
 * 	5B85 ??
 * FA05 CJK COMPATIBILITY IDEOGRAPH-FA05
 * 	6D1E ??
 * FA06 CJK COMPATIBILITY IDEOGRAPH-FA06
 * 	66B4 ??
 * FA07 CJK COMPATIBILITY IDEOGRAPH-FA07
 * 	8F3B ??
 * FA08 CJK COMPATIBILITY IDEOGRAPH-FA08
 * 	884C ??
 * FA09 CJK COMPATIBILITY IDEOGRAPH-FA09
 * 	964D ??
 * FA0A CJK COMPATIBILITY IDEOGRAPH-FA0A
 * 	898B ??
 * FA0B CJK COMPATIBILITY IDEOGRAPH-FA0B
 * 	5ED3 ??
 * FA0C CJK COMPATIBILITY IDEOGRAPH-FA0C
 * 	5140 ??
 * FA0D CJK COMPATIBILITY IDEOGRAPH-FA0D
 * 	55C0 ??
 * FA10 CJK COMPATIBILITY IDEOGRAPH-FA10
 * 	585A ??
 * FA12 CJK COMPATIBILITY IDEOGRAPH-FA12
 * 	6674 ??
 * FA15 CJK COMPATIBILITY IDEOGRAPH-FA15
 * 	51DE ??
 * FA16 CJK COMPATIBILITY IDEOGRAPH-FA16
 * 	732A ??
 * FA17 CJK COMPATIBILITY IDEOGRAPH-FA17
 * 	76CA ??
 * FA18 CJK COMPATIBILITY IDEOGRAPH-FA18
 * 	793C ??
 * FA19 CJK COMPATIBILITY IDEOGRAPH-FA19
 * 	795E ??
 * FA1A CJK COMPATIBILITY IDEOGRAPH-FA1A
 * 	7965 ??
 * FA1B CJK COMPATIBILITY IDEOGRAPH-FA1B
 * 	798F ??
 * FA1C CJK COMPATIBILITY IDEOGRAPH-FA1C
 * 	9756 ??
 * FA1D CJK COMPATIBILITY IDEOGRAPH-FA1D
 * 	7CBE ??
 * FA1E CJK COMPATIBILITY IDEOGRAPH-FA1E
 * 	7FBD ??
 * FA20 CJK COMPATIBILITY IDEOGRAPH-FA20
 * 	8612 ??
 * FA22 CJK COMPATIBILITY IDEOGRAPH-FA22
 * 	8AF8 ??
 * FA25 CJK COMPATIBILITY IDEOGRAPH-FA25
 * 	9038 ??
 * FA26 CJK COMPATIBILITY IDEOGRAPH-FA26
 * 	90FD ??
 * FA2A CJK COMPATIBILITY IDEOGRAPH-FA2A
 * 	98EF ??
 * FA2B CJK COMPATIBILITY IDEOGRAPH-FA2B
 * 	98FC ??
 * FA2C CJK COMPATIBILITY IDEOGRAPH-FA2C
 * 	9928 ??
 * FA2D CJK COMPATIBILITY IDEOGRAPH-FA2D
 * 	9DB4 ??
 * FA30 CJK COMPATIBILITY IDEOGRAPH-FA30
 * 	4FAE ??
 * FA31 CJK COMPATIBILITY IDEOGRAPH-FA31
 * 	50E7 ??
 * FA32 CJK COMPATIBILITY IDEOGRAPH-FA32
 * 	514D ??
 * FA33 CJK COMPATIBILITY IDEOGRAPH-FA33
 * 	52C9 ??
 * FA34 CJK COMPATIBILITY IDEOGRAPH-FA34
 * 	52E4 ??
 * FA35 CJK COMPATIBILITY IDEOGRAPH-FA35
 * 	5351 ??
 * FA36 CJK COMPATIBILITY IDEOGRAPH-FA36
 * 	559D ??
 * FA37 CJK COMPATIBILITY IDEOGRAPH-FA37
 * 	5606 ??
 * FA38 CJK COMPATIBILITY IDEOGRAPH-FA38
 * 	5668 ??
 * FA39 CJK COMPATIBILITY IDEOGRAPH-FA39
 * 	5840 ??
 * FA3A CJK COMPATIBILITY IDEOGRAPH-FA3A
 * 	58A8 ??
 * FA3B CJK COMPATIBILITY IDEOGRAPH-FA3B
 * 	5C64 ??
 * FA3C CJK COMPATIBILITY IDEOGRAPH-FA3C
 * 	5C6E ??
 * FA3D CJK COMPATIBILITY IDEOGRAPH-FA3D
 * 	6094 ??
 * FA3E CJK COMPATIBILITY IDEOGRAPH-FA3E
 * 	6168 ??
 * FA3F CJK COMPATIBILITY IDEOGRAPH-FA3F
 * 	618E ??
 * FA40 CJK COMPATIBILITY IDEOGRAPH-FA40
 * 	61F2 ??
 * FA41 CJK COMPATIBILITY IDEOGRAPH-FA41
 * 	654F ??
 * FA42 CJK COMPATIBILITY IDEOGRAPH-FA42
 * 	65E2 ??
 * FA43 CJK COMPATIBILITY IDEOGRAPH-FA43
 * 	6691 ??
 * FA44 CJK COMPATIBILITY IDEOGRAPH-FA44
 * 	6885 ??
 * FA45 CJK COMPATIBILITY IDEOGRAPH-FA45
 * 	6D77 ??
 * FA46 CJK COMPATIBILITY IDEOGRAPH-FA46
 * 	6E1A ??
 * FA47 CJK COMPATIBILITY IDEOGRAPH-FA47
 * 	6F22 ??
 * FA48 CJK COMPATIBILITY IDEOGRAPH-FA48
 * 	716E ??
 * FA49 CJK COMPATIBILITY IDEOGRAPH-FA49
 * 	722B ??
 * FA4A CJK COMPATIBILITY IDEOGRAPH-FA4A
 * 	7422 ??
 * FA4B CJK COMPATIBILITY IDEOGRAPH-FA4B
 * 	7891 ??
 * FA4C CJK COMPATIBILITY IDEOGRAPH-FA4C
 * 	793E ??
 * FA4D CJK COMPATIBILITY IDEOGRAPH-FA4D
 * 	7949 ??
 * FA4E CJK COMPATIBILITY IDEOGRAPH-FA4E
 * 	7948 ??
 * FA4F CJK COMPATIBILITY IDEOGRAPH-FA4F
 * 	7950 ??
 * FA50 CJK COMPATIBILITY IDEOGRAPH-FA50
 * 	7956 ??
 * FA51 CJK COMPATIBILITY IDEOGRAPH-FA51
 * 	795D ??
 * FA52 CJK COMPATIBILITY IDEOGRAPH-FA52
 * 	798D ??
 * FA53 CJK COMPATIBILITY IDEOGRAPH-FA53
 * 	798E ??
 * FA54 CJK COMPATIBILITY IDEOGRAPH-FA54
 * 	7A40 ??
 * FA55 CJK COMPATIBILITY IDEOGRAPH-FA55
 * 	7A81 ??
 * FA56 CJK COMPATIBILITY IDEOGRAPH-FA56
 * 	7BC0 ??
 * FA57 CJK COMPATIBILITY IDEOGRAPH-FA57
 * 	7DF4 ??
 * FA58 CJK COMPATIBILITY IDEOGRAPH-FA58
 * 	7E09 ??
 * FA59 CJK COMPATIBILITY IDEOGRAPH-FA59
 * 	7E41 ??
 * FA5A CJK COMPATIBILITY IDEOGRAPH-FA5A
 * 	7F72 ??
 * FA5B CJK COMPATIBILITY IDEOGRAPH-FA5B
 * 	8005 ??
 * FA5C CJK COMPATIBILITY IDEOGRAPH-FA5C
 * 	81ED ??
 * FA5D CJK COMPATIBILITY IDEOGRAPH-FA5D
 * 	8279 ??
 * FA5E CJK COMPATIBILITY IDEOGRAPH-FA5E
 * 	8279 ??
 * FA5F CJK COMPATIBILITY IDEOGRAPH-FA5F
 * 	8457 ??
 * FA60 CJK COMPATIBILITY IDEOGRAPH-FA60
 * 	8910 ??
 * FA61 CJK COMPATIBILITY IDEOGRAPH-FA61
 * 	8996 ??
 * FA62 CJK COMPATIBILITY IDEOGRAPH-FA62
 * 	8B01 ??
 * FA63 CJK COMPATIBILITY IDEOGRAPH-FA63
 * 	8B39 ??
 * FA64 CJK COMPATIBILITY IDEOGRAPH-FA64
 * 	8CD3 ??
 * FA65 CJK COMPATIBILITY IDEOGRAPH-FA65
 * 	8D08 ??
 * FA66 CJK COMPATIBILITY IDEOGRAPH-FA66
 * 	8FB6 ??
 * FA67 CJK COMPATIBILITY IDEOGRAPH-FA67
 * 	9038 ??
 * FA68 CJK COMPATIBILITY IDEOGRAPH-FA68
 * 	96E3 ??
 * FA69 CJK COMPATIBILITY IDEOGRAPH-FA69
 * 	97FF ??
 * FA6A CJK COMPATIBILITY IDEOGRAPH-FA6A
 * 	983B ??
 * FB00 LATIN SMALL LIGATURE FF
 * 	0066 LATIN SMALL LETTER F
 * 	0066 LATIN SMALL LETTER F
 * FB01 LATIN SMALL LIGATURE FI
 * 	0066 LATIN SMALL LETTER F
 * 	0069 LATIN SMALL LETTER I
 * FB02 LATIN SMALL LIGATURE FL
 * 	0066 LATIN SMALL LETTER F
 * 	006C LATIN SMALL LETTER L
 * FB03 LATIN SMALL LIGATURE FFI
 * 	0066 LATIN SMALL LETTER F
 * 	0066 LATIN SMALL LETTER F
 * 	0069 LATIN SMALL LETTER I
 * FB04 LATIN SMALL LIGATURE FFL
 * 	0066 LATIN SMALL LETTER F
 * 	0066 LATIN SMALL LETTER F
 * 	006C LATIN SMALL LETTER L
 * FB05 LATIN SMALL LIGATURE LONG S T
 * 	0074 LATIN SMALL LETTER T
 * 	0073 LATIN SMALL LETTER S
 * FB06 LATIN SMALL LIGATURE ST
 * 	0073 LATIN SMALL LETTER S
 * 	0074 LATIN SMALL LETTER T
 * FB13 ARMENIAN SMALL LIGATURE MEN NOW
 * 	0574 ARMENIAN SMALL LETTER MEN
 * 	0576 ARMENIAN SMALL LETTER NOW
 * FB14 ARMENIAN SMALL LIGATURE MEN ECH
 * 	0574 ARMENIAN SMALL LETTER MEN
 * 	0565 ARMENIAN SMALL LETTER ECH
 * FB15 ARMENIAN SMALL LIGATURE MEN INI
 * 	0574 ARMENIAN SMALL LETTER MEN
 * 	056B ARMENIAN SMALL LETTER INI
 * FB16 ARMENIAN SMALL LIGATURE VEW NOW
 * 	057E ARMENIAN SMALL LETTER VEW
 * 	0576 ARMENIAN SMALL LETTER NOW
 * FB17 ARMENIAN SMALL LIGATURE MEN XEH
 * 	0574 ARMENIAN SMALL LETTER MEN
 * 	056D ARMENIAN SMALL LETTER XEH
 * FB1D HEBREW LETTER YOD WITH HIRIQ
 * 	05D9 HEBREW LETTER YOD
 * FB1F HEBREW LIGATURE YIDDISH YOD YOD PATAH
 * 	05F2 HEBREW LIGATURE YIDDISH DOUBLE YOD
 * FB20 HEBREW LETTER ALTERNATIVE AYIN
 * 	05E2 HEBREW LETTER AYIN
 * FB21 HEBREW LETTER WIDE ALEF
 * 	05D0 HEBREW LETTER ALEF
 * FB22 HEBREW LETTER WIDE DALET
 * 	05D3 HEBREW LETTER DALET
 * FB23 HEBREW LETTER WIDE HE
 * 	05D4 HEBREW LETTER HE
 * FB24 HEBREW LETTER WIDE KAF
 * 	05DB HEBREW LETTER KAF
 * FB25 HEBREW LETTER WIDE LAMED
 * 	05DC HEBREW LETTER LAMED
 * FB26 HEBREW LETTER WIDE FINAL MEM
 * 	05DD HEBREW LETTER FINAL MEM
 * FB27 HEBREW LETTER WIDE RESH
 * 	05E8 HEBREW LETTER RESH
 * FB28 HEBREW LETTER WIDE TAV
 * 	05EA HEBREW LETTER TAV
 * FB29 HEBREW LETTER ALTERNATIVE PLUS SIGN
 * 	002B PLUS SIGN
 * FB2A HEBREW LETTER SHIN WITH SHIN DOT
 * 	05E9 HEBREW LETTER SHIN
 * FB2B HEBREW LETTER SHIN WITH SIN DOT
 * 	05E9 HEBREW LETTER SHIN
 * FB2C HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT
 * 	05E9 HEBREW LETTER SHIN
 * FB2D HEBREW LETTER SHIN WITH DAGESH AND SIN DOT
 * 	05E9 HEBREW LETTER SHIN
 * FB2E HEBREW LETTER ALEF WITH PATAH
 * 	05D0 HEBREW LETTER ALEF
 * FB2F HEBREW LETTER ALEF WITH QAMATS
 * 	05D0 HEBREW LETTER ALEF
 * FB30 HEBREW LETTER ALEF WITH MAPIQ
 * 	05D0 HEBREW LETTER ALEF
 * FB31 HEBREW LETTER BET WITH DAGESH
 * 	05D1 HEBREW LETTER BET
 * FB32 HEBREW LETTER GIMEL WITH DAGESH
 * 	05D2 HEBREW LETTER GIMEL
 * FB33 HEBREW LETTER DALET WITH DAGESH
 * 	05D3 HEBREW LETTER DALET
 * FB34 HEBREW LETTER HE WITH MAPIQ
 * 	05D4 HEBREW LETTER HE
 * FB35 HEBREW LETTER VAV WITH DAGESH
 * 	05D5 HEBREW LETTER VAV
 * FB36 HEBREW LETTER ZAYIN WITH DAGESH
 * 	05D6 HEBREW LETTER ZAYIN
 * FB38 HEBREW LETTER TET WITH DAGESH
 * 	05D8 HEBREW LETTER TET
 * FB39 HEBREW LETTER YOD WITH DAGESH
 * 	05D9 HEBREW LETTER YOD
 * FB3A HEBREW LETTER FINAL KAF WITH DAGESH
 * 	05DA HEBREW LETTER FINAL KAF
 * FB3B HEBREW LETTER KAF WITH DAGESH
 * 	05DB HEBREW LETTER KAF
 * FB3C HEBREW LETTER LAMED WITH DAGESH
 * 	05DC HEBREW LETTER LAMED
 * FB3E HEBREW LETTER MEM WITH DAGESH
 * 	05DE HEBREW LETTER MEM
 * FB40 HEBREW LETTER NUN WITH DAGESH
 * 	05E0 HEBREW LETTER NUN
 * FB41 HEBREW LETTER SAMEKH WITH DAGESH
 * 	05E1 HEBREW LETTER SAMEKH
 * FB43 HEBREW LETTER FINAL PE WITH DAGESH
 * 	05E3 HEBREW LETTER FINAL PE
 * FB44 HEBREW LETTER PE WITH DAGESH
 * 	05E4 HEBREW LETTER PE
 * FB46 HEBREW LETTER TSADI WITH DAGESH
 * 	05E6 HEBREW LETTER TSADI
 * FB47 HEBREW LETTER QOF WITH DAGESH
 * 	05E7 HEBREW LETTER QOF
 * FB48 HEBREW LETTER RESH WITH DAGESH
 * 	05E8 HEBREW LETTER RESH
 * FB49 HEBREW LETTER SHIN WITH DAGESH
 * 	05E9 HEBREW LETTER SHIN
 * FB4A HEBREW LETTER TAV WITH DAGESH
 * 	05EA HEBREW LETTER TAV
 * FB4B HEBREW LETTER VAV WITH HOLAM
 * 	05D5 HEBREW LETTER VAV
 * FB4C HEBREW LETTER BET WITH RAFE
 * 	05D1 HEBREW LETTER BET
 * FB4D HEBREW LETTER KAF WITH RAFE
 * 	05DB HEBREW LETTER KAF
 * FB4E HEBREW LETTER PE WITH RAFE
 * 	05E4 HEBREW LETTER PE
 * FB4F HEBREW LIGATURE ALEF LAMED
 * 	05D0 HEBREW LETTER ALEF
 * 	05DC HEBREW LETTER LAMED
 * FB50 ARABIC LETTER ALEF WASLA ISOLATED FORM
 * 	0671 ARABIC LETTER ALEF WASLA
 * FB51 ARABIC LETTER ALEF WASLA FINAL FORM
 * 	0671 ARABIC LETTER ALEF WASLA
 * FB52 ARABIC LETTER BEEH ISOLATED FORM
 * 	067B ARABIC LETTER BEEH
 * FB53 ARABIC LETTER BEEH FINAL FORM
 * 	067B ARABIC LETTER BEEH
 * FB54 ARABIC LETTER BEEH INITIAL FORM
 * 	067B ARABIC LETTER BEEH
 * FB55 ARABIC LETTER BEEH MEDIAL FORM
 * 	067B ARABIC LETTER BEEH
 * FB56 ARABIC LETTER PEH ISOLATED FORM
 * 	067E ARABIC LETTER PEH
 * FB57 ARABIC LETTER PEH FINAL FORM
 * 	067E ARABIC LETTER PEH
 * FB58 ARABIC LETTER PEH INITIAL FORM
 * 	067E ARABIC LETTER PEH
 * FB59 ARABIC LETTER PEH MEDIAL FORM
 * 	067E ARABIC LETTER PEH
 * FB5A ARABIC LETTER BEHEH ISOLATED FORM
 * 	0680 ARABIC LETTER BEHEH
 * FB5B ARABIC LETTER BEHEH FINAL FORM
 * 	0680 ARABIC LETTER BEHEH
 * FB5C ARABIC LETTER BEHEH INITIAL FORM
 * 	0680 ARABIC LETTER BEHEH
 * FB5D ARABIC LETTER BEHEH MEDIAL FORM
 * 	0680 ARABIC LETTER BEHEH
 * FB5E ARABIC LETTER TTEHEH ISOLATED FORM
 * 	067A ARABIC LETTER TTEHEH
 * FB5F ARABIC LETTER TTEHEH FINAL FORM
 * 	067A ARABIC LETTER TTEHEH
 * FB60 ARABIC LETTER TTEHEH INITIAL FORM
 * 	067A ARABIC LETTER TTEHEH
 * FB61 ARABIC LETTER TTEHEH MEDIAL FORM
 * 	067A ARABIC LETTER TTEHEH
 * FB62 ARABIC LETTER TEHEH ISOLATED FORM
 * 	067F ARABIC LETTER TEHEH
 * FB63 ARABIC LETTER TEHEH FINAL FORM
 * 	067F ARABIC LETTER TEHEH
 * FB64 ARABIC LETTER TEHEH INITIAL FORM
 * 	067F ARABIC LETTER TEHEH
 * FB65 ARABIC LETTER TEHEH MEDIAL FORM
 * 	067F ARABIC LETTER TEHEH
 * FB66 ARABIC LETTER TTEH ISOLATED FORM
 * 	0679 ARABIC LETTER TTEH
 * FB67 ARABIC LETTER TTEH FINAL FORM
 * 	0679 ARABIC LETTER TTEH
 * FB68 ARABIC LETTER TTEH INITIAL FORM
 * 	0679 ARABIC LETTER TTEH
 * FB69 ARABIC LETTER TTEH MEDIAL FORM
 * 	0679 ARABIC LETTER TTEH
 * FB6A ARABIC LETTER VEH ISOLATED FORM
 * 	06A4 ARABIC LETTER VEH
 * FB6B ARABIC LETTER VEH FINAL FORM
 * 	06A4 ARABIC LETTER VEH
 * FB6C ARABIC LETTER VEH INITIAL FORM
 * 	06A4 ARABIC LETTER VEH
 * FB6D ARABIC LETTER VEH MEDIAL FORM
 * 	06A4 ARABIC LETTER VEH
 * FB6E ARABIC LETTER PEHEH ISOLATED FORM
 * 	06A6 ARABIC LETTER PEHEH
 * FB6F ARABIC LETTER PEHEH FINAL FORM
 * 	06A6 ARABIC LETTER PEHEH
 * FB70 ARABIC LETTER PEHEH INITIAL FORM
 * 	06A6 ARABIC LETTER PEHEH
 * FB71 ARABIC LETTER PEHEH MEDIAL FORM
 * 	06A6 ARABIC LETTER PEHEH
 * FB72 ARABIC LETTER DYEH ISOLATED FORM
 * 	0684 ARABIC LETTER DYEH
 * FB73 ARABIC LETTER DYEH FINAL FORM
 * 	0684 ARABIC LETTER DYEH
 * FB74 ARABIC LETTER DYEH INITIAL FORM
 * 	0684 ARABIC LETTER DYEH
 * FB75 ARABIC LETTER DYEH MEDIAL FORM
 * 	0684 ARABIC LETTER DYEH
 * FB76 ARABIC LETTER NYEH ISOLATED FORM
 * 	0683 ARABIC LETTER NYEH
 * FB77 ARABIC LETTER NYEH FINAL FORM
 * 	0683 ARABIC LETTER NYEH
 * FB78 ARABIC LETTER NYEH INITIAL FORM
 * 	0683 ARABIC LETTER NYEH
 * FB79 ARABIC LETTER NYEH MEDIAL FORM
 * 	0683 ARABIC LETTER NYEH
 * FB7A ARABIC LETTER TCHEH ISOLATED FORM
 * 	0686 ARABIC LETTER TCHEH
 * FB7B ARABIC LETTER TCHEH FINAL FORM
 * 	0686 ARABIC LETTER TCHEH
 * FB7C ARABIC LETTER TCHEH INITIAL FORM
 * 	0686 ARABIC LETTER TCHEH
 * FB7D ARABIC LETTER TCHEH MEDIAL FORM
 * 	0686 ARABIC LETTER TCHEH
 * FB7E ARABIC LETTER TCHEHEH ISOLATED FORM
 * 	0687 ARABIC LETTER TCHEHEH
 * FB7F ARABIC LETTER TCHEHEH FINAL FORM
 * 	0687 ARABIC LETTER TCHEHEH
 * FB80 ARABIC LETTER TCHEHEH INITIAL FORM
 * 	0687 ARABIC LETTER TCHEHEH
 * FB81 ARABIC LETTER TCHEHEH MEDIAL FORM
 * 	0687 ARABIC LETTER TCHEHEH
 * FB82 ARABIC LETTER DDAHAL ISOLATED FORM
 * 	068D ARABIC LETTER DDAHAL
 * FB83 ARABIC LETTER DDAHAL FINAL FORM
 * 	068D ARABIC LETTER DDAHAL
 * FB84 ARABIC LETTER DAHAL ISOLATED FORM
 * 	068C ARABIC LETTER DAHAL
 * FB85 ARABIC LETTER DAHAL FINAL FORM
 * 	068C ARABIC LETTER DAHAL
 * FB86 ARABIC LETTER DUL ISOLATED FORM
 * 	068E ARABIC LETTER DUL
 * FB87 ARABIC LETTER DUL FINAL FORM
 * 	068E ARABIC LETTER DUL
 * FB88 ARABIC LETTER DDAL ISOLATED FORM
 * 	0688 ARABIC LETTER DDAL
 * FB89 ARABIC LETTER DDAL FINAL FORM
 * 	0688 ARABIC LETTER DDAL
 * FB8A ARABIC LETTER JEH ISOLATED FORM
 * 	0698 ARABIC LETTER JEH
 * FB8B ARABIC LETTER JEH FINAL FORM
 * 	0698 ARABIC LETTER JEH
 * FB8C ARABIC LETTER RREH ISOLATED FORM
 * 	0691 ARABIC LETTER RREH
 * FB8D ARABIC LETTER RREH FINAL FORM
 * 	0691 ARABIC LETTER RREH
 * FB8E ARABIC LETTER KEHEH ISOLATED FORM
 * 	06A9 ARABIC LETTER KEHEH
 * FB8F ARABIC LETTER KEHEH FINAL FORM
 * 	06A9 ARABIC LETTER KEHEH
 * FB90 ARABIC LETTER KEHEH INITIAL FORM
 * 	06A9 ARABIC LETTER KEHEH
 * FB91 ARABIC LETTER KEHEH MEDIAL FORM
 * 	06A9 ARABIC LETTER KEHEH
 * FB92 ARABIC LETTER GAF ISOLATED FORM
 * 	06AF ARABIC LETTER GAF
 * FB93 ARABIC LETTER GAF FINAL FORM
 * 	06AF ARABIC LETTER GAF
 * FB94 ARABIC LETTER GAF INITIAL FORM
 * 	06AF ARABIC LETTER GAF
 * FB95 ARABIC LETTER GAF MEDIAL FORM
 * 	06AF ARABIC LETTER GAF
 * FB96 ARABIC LETTER GUEH ISOLATED FORM
 * 	06B3 ARABIC LETTER GUEH
 * FB97 ARABIC LETTER GUEH FINAL FORM
 * 	06B3 ARABIC LETTER GUEH
 * FB98 ARABIC LETTER GUEH INITIAL FORM
 * 	06B3 ARABIC LETTER GUEH
 * FB99 ARABIC LETTER GUEH MEDIAL FORM
 * 	06B3 ARABIC LETTER GUEH
 * FB9A ARABIC LETTER NGOEH ISOLATED FORM
 * 	06B1 ARABIC LETTER NGOEH
 * FB9B ARABIC LETTER NGOEH FINAL FORM
 * 	06B1 ARABIC LETTER NGOEH
 * FB9C ARABIC LETTER NGOEH INITIAL FORM
 * 	06B1 ARABIC LETTER NGOEH
 * FB9D ARABIC LETTER NGOEH MEDIAL FORM
 * 	06B1 ARABIC LETTER NGOEH
 * FB9E ARABIC LETTER NOON GHUNNA ISOLATED FORM
 * 	06BA ARABIC LETTER NOON GHUNNA
 * FB9F ARABIC LETTER NOON GHUNNA FINAL FORM
 * 	06BA ARABIC LETTER NOON GHUNNA
 * FBA0 ARABIC LETTER RNOON ISOLATED FORM
 * 	06BB ARABIC LETTER RNOON
 * FBA1 ARABIC LETTER RNOON FINAL FORM
 * 	06BB ARABIC LETTER RNOON
 * FBA2 ARABIC LETTER RNOON INITIAL FORM
 * 	06BB ARABIC LETTER RNOON
 * FBA3 ARABIC LETTER RNOON MEDIAL FORM
 * 	06BB ARABIC LETTER RNOON
 * FBA4 ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM
 * 	06D5 ARABIC LETTER AE
 * FBA5 ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM
 * 	06D5 ARABIC LETTER AE
 * FBA6 ARABIC LETTER HEH GOAL ISOLATED FORM
 * 	06C1 ARABIC LETTER HEH GOAL
 * FBA7 ARABIC LETTER HEH GOAL FINAL FORM
 * 	06C1 ARABIC LETTER HEH GOAL
 * FBA8 ARABIC LETTER HEH GOAL INITIAL FORM
 * 	06C1 ARABIC LETTER HEH GOAL
 * FBA9 ARABIC LETTER HEH GOAL MEDIAL FORM
 * 	06C1 ARABIC LETTER HEH GOAL
 * FBAA ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM
 * 	06BE ARABIC LETTER HEH DOACHASHMEE
 * FBAB ARABIC LETTER HEH DOACHASHMEE FINAL FORM
 * 	06BE ARABIC LETTER HEH DOACHASHMEE
 * FBAC ARABIC LETTER HEH DOACHASHMEE INITIAL FORM
 * 	06BE ARABIC LETTER HEH DOACHASHMEE
 * FBAD ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM
 * 	06BE ARABIC LETTER HEH DOACHASHMEE
 * FBAE ARABIC LETTER YEH BARREE ISOLATED FORM
 * 	06D2 ARABIC LETTER YEH BARREE
 * FBAF ARABIC LETTER YEH BARREE FINAL FORM
 * 	06D2 ARABIC LETTER YEH BARREE
 * FBB0 ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM
 * 	06D2 ARABIC LETTER YEH BARREE
 * FBB1 ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
 * 	06D2 ARABIC LETTER YEH BARREE
 * FBD3 ARABIC LETTER NG ISOLATED FORM
 * 	06AD ARABIC LETTER NG
 * FBD4 ARABIC LETTER NG FINAL FORM
 * 	06AD ARABIC LETTER NG
 * FBD5 ARABIC LETTER NG INITIAL FORM
 * 	06AD ARABIC LETTER NG
 * FBD6 ARABIC LETTER NG MEDIAL FORM
 * 	06AD ARABIC LETTER NG
 * FBD7 ARABIC LETTER U ISOLATED FORM
 * 	06C7 ARABIC LETTER U
 * FBD8 ARABIC LETTER U FINAL FORM
 * 	06C7 ARABIC LETTER U
 * FBD9 ARABIC LETTER OE ISOLATED FORM
 * 	06C6 ARABIC LETTER OE
 * FBDA ARABIC LETTER OE FINAL FORM
 * 	06C6 ARABIC LETTER OE
 * FBDB ARABIC LETTER YU ISOLATED FORM
 * 	06C8 ARABIC LETTER YU
 * FBDC ARABIC LETTER YU FINAL FORM
 * 	06C8 ARABIC LETTER YU
 * FBDD ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM
 * 	06C7 ARABIC LETTER U
 * 	0674 ARABIC LETTER HIGH HAMZA
 * FBDE ARABIC LETTER VE ISOLATED FORM
 * 	06CB ARABIC LETTER VE
 * FBDF ARABIC LETTER VE FINAL FORM
 * 	06CB ARABIC LETTER VE
 * FBE0 ARABIC LETTER KIRGHIZ OE ISOLATED FORM
 * 	06C5 ARABIC LETTER KIRGHIZ OE
 * FBE1 ARABIC LETTER KIRGHIZ OE FINAL FORM
 * 	06C5 ARABIC LETTER KIRGHIZ OE
 * FBE2 ARABIC LETTER KIRGHIZ YU ISOLATED FORM
 * 	06C9 ARABIC LETTER KIRGHIZ YU
 * FBE3 ARABIC LETTER KIRGHIZ YU FINAL FORM
 * 	06C9 ARABIC LETTER KIRGHIZ YU
 * FBE4 ARABIC LETTER E ISOLATED FORM
 * 	06D0 ARABIC LETTER E
 * FBE5 ARABIC LETTER E FINAL FORM
 * 	06D0 ARABIC LETTER E
 * FBE6 ARABIC LETTER E INITIAL FORM
 * 	06D0 ARABIC LETTER E
 * FBE7 ARABIC LETTER E MEDIAL FORM
 * 	06D0 ARABIC LETTER E
 * FBE8 ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FBE9 ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FBEA ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * 	064A ARABIC LETTER YEH
 * FBEB ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM
 * 	0627 ARABIC LETTER ALEF
 * 	064A ARABIC LETTER YEH
 * FBEC ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM
 * 	06D5 ARABIC LETTER AE
 * 	064A ARABIC LETTER YEH
 * FBED ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM
 * 	06D5 ARABIC LETTER AE
 * 	064A ARABIC LETTER YEH
 * FBEE ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM
 * 	0648 ARABIC LETTER WAW
 * 	064A ARABIC LETTER YEH
 * FBEF ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM
 * 	0648 ARABIC LETTER WAW
 * 	064A ARABIC LETTER YEH
 * FBF0 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM
 * 	06C7 ARABIC LETTER U
 * 	064A ARABIC LETTER YEH
 * FBF1 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM
 * 	06C7 ARABIC LETTER U
 * 	064A ARABIC LETTER YEH
 * FBF2 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM
 * 	06C6 ARABIC LETTER OE
 * 	064A ARABIC LETTER YEH
 * FBF3 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM
 * 	06C6 ARABIC LETTER OE
 * 	064A ARABIC LETTER YEH
 * FBF4 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM
 * 	06C8 ARABIC LETTER YU
 * 	064A ARABIC LETTER YEH
 * FBF5 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM
 * 	06C8 ARABIC LETTER YU
 * 	064A ARABIC LETTER YEH
 * FBF6 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM
 * 	06D0 ARABIC LETTER E
 * 	064A ARABIC LETTER YEH
 * FBF7 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM
 * 	06D0 ARABIC LETTER E
 * 	064A ARABIC LETTER YEH
 * FBF8 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM
 * 	06D0 ARABIC LETTER E
 * 	064A ARABIC LETTER YEH
 * FBF9 ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * 	064A ARABIC LETTER YEH
 * FBFA ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * 	064A ARABIC LETTER YEH
 * FBFB ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * 	064A ARABIC LETTER YEH
 * FBFC ARABIC LETTER FARSI YEH ISOLATED FORM
 * 	06CC ARABIC LETTER FARSI YEH
 * FBFD ARABIC LETTER FARSI YEH FINAL FORM
 * 	06CC ARABIC LETTER FARSI YEH
 * FBFE ARABIC LETTER FARSI YEH INITIAL FORM
 * 	06CC ARABIC LETTER FARSI YEH
 * FBFF ARABIC LETTER FARSI YEH MEDIAL FORM
 * 	06CC ARABIC LETTER FARSI YEH
 * FC00 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORM
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FC01 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FC02 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FC03 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * 	064A ARABIC LETTER YEH
 * FC04 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	064A ARABIC LETTER YEH
 * FC05 ARABIC LIGATURE BEH WITH JEEM ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * 	062C ARABIC LETTER JEEM
 * FC06 ARABIC LIGATURE BEH WITH HAH ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * 	062D ARABIC LETTER HAH
 * FC07 ARABIC LIGATURE BEH WITH KHAH ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * 	062E ARABIC LETTER KHAH
 * FC08 ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * 	0645 ARABIC LETTER MEEM
 * FC09 ARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC0A ARABIC LIGATURE BEH WITH YEH ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * 	064A ARABIC LETTER YEH
 * FC0B ARABIC LIGATURE TEH WITH JEEM ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * 	062C ARABIC LETTER JEEM
 * FC0C ARABIC LIGATURE TEH WITH HAH ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * 	062D ARABIC LETTER HAH
 * FC0D ARABIC LIGATURE TEH WITH KHAH ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * 	062E ARABIC LETTER KHAH
 * FC0E ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * FC0F ARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC10 ARABIC LIGATURE TEH WITH YEH ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * 	064A ARABIC LETTER YEH
 * FC11 ARABIC LIGATURE THEH WITH JEEM ISOLATED FORM
 * 	062B ARABIC LETTER THEH
 * 	062C ARABIC LETTER JEEM
 * FC12 ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM
 * 	062B ARABIC LETTER THEH
 * 	0645 ARABIC LETTER MEEM
 * FC13 ARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORM
 * 	062B ARABIC LETTER THEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC14 ARABIC LIGATURE THEH WITH YEH ISOLATED FORM
 * 	062B ARABIC LETTER THEH
 * 	064A ARABIC LETTER YEH
 * FC15 ARABIC LIGATURE JEEM WITH HAH ISOLATED FORM
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * FC16 ARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FC17 ARABIC LIGATURE HAH WITH JEEM ISOLATED FORM
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * FC18 ARABIC LIGATURE HAH WITH MEEM ISOLATED FORM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FC19 ARABIC LIGATURE KHAH WITH JEEM ISOLATED FORM
 * 	062E ARABIC LETTER KHAH
 * 	062C ARABIC LETTER JEEM
 * FC1A ARABIC LIGATURE KHAH WITH HAH ISOLATED FORM
 * 	062E ARABIC LETTER KHAH
 * 	062D ARABIC LETTER HAH
 * FC1B ARABIC LIGATURE KHAH WITH MEEM ISOLATED FORM
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FC1C ARABIC LIGATURE SEEN WITH JEEM ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062C ARABIC LETTER JEEM
 * FC1D ARABIC LIGATURE SEEN WITH HAH ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062D ARABIC LETTER HAH
 * FC1E ARABIC LIGATURE SEEN WITH KHAH ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062E ARABIC LETTER KHAH
 * FC1F ARABIC LIGATURE SEEN WITH MEEM ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * FC20 ARABIC LIGATURE SAD WITH HAH ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	062D ARABIC LETTER HAH
 * FC21 ARABIC LIGATURE SAD WITH MEEM ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	0645 ARABIC LETTER MEEM
 * FC22 ARABIC LIGATURE DAD WITH JEEM ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	062C ARABIC LETTER JEEM
 * FC23 ARABIC LIGATURE DAD WITH HAH ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	062D ARABIC LETTER HAH
 * FC24 ARABIC LIGATURE DAD WITH KHAH ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	062E ARABIC LETTER KHAH
 * FC25 ARABIC LIGATURE DAD WITH MEEM ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	0645 ARABIC LETTER MEEM
 * FC26 ARABIC LIGATURE TAH WITH HAH ISOLATED FORM
 * 	0637 ARABIC LETTER TAH
 * 	062D ARABIC LETTER HAH
 * FC27 ARABIC LIGATURE TAH WITH MEEM ISOLATED FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * FC28 ARABIC LIGATURE ZAH WITH MEEM ISOLATED FORM
 * 	0638 ARABIC LETTER ZAH
 * 	0645 ARABIC LETTER MEEM
 * FC29 ARABIC LIGATURE AIN WITH JEEM ISOLATED FORM
 * 	0639 ARABIC LETTER AIN
 * 	062C ARABIC LETTER JEEM
 * FC2A ARABIC LIGATURE AIN WITH MEEM ISOLATED FORM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * FC2B ARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORM
 * 	063A ARABIC LETTER GHAIN
 * 	062C ARABIC LETTER JEEM
 * FC2C ARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0645 ARABIC LETTER MEEM
 * FC2D ARABIC LIGATURE FEH WITH JEEM ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * 	062C ARABIC LETTER JEEM
 * FC2E ARABIC LIGATURE FEH WITH HAH ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * 	062D ARABIC LETTER HAH
 * FC2F ARABIC LIGATURE FEH WITH KHAH ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * 	062E ARABIC LETTER KHAH
 * FC30 ARABIC LIGATURE FEH WITH MEEM ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * 	0645 ARABIC LETTER MEEM
 * FC31 ARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC32 ARABIC LIGATURE FEH WITH YEH ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * 	064A ARABIC LETTER YEH
 * FC33 ARABIC LIGATURE QAF WITH HAH ISOLATED FORM
 * 	0642 ARABIC LETTER QAF
 * 	062D ARABIC LETTER HAH
 * FC34 ARABIC LIGATURE QAF WITH MEEM ISOLATED FORM
 * 	0642 ARABIC LETTER QAF
 * 	0645 ARABIC LETTER MEEM
 * FC35 ARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORM
 * 	0642 ARABIC LETTER QAF
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC36 ARABIC LIGATURE QAF WITH YEH ISOLATED FORM
 * 	0642 ARABIC LETTER QAF
 * 	064A ARABIC LETTER YEH
 * FC37 ARABIC LIGATURE KAF WITH ALEF ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	0627 ARABIC LETTER ALEF
 * FC38 ARABIC LIGATURE KAF WITH JEEM ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	062C ARABIC LETTER JEEM
 * FC39 ARABIC LIGATURE KAF WITH HAH ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	062D ARABIC LETTER HAH
 * FC3A ARABIC LIGATURE KAF WITH KHAH ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	062E ARABIC LETTER KHAH
 * FC3B ARABIC LIGATURE KAF WITH LAM ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	0644 ARABIC LETTER LAM
 * FC3C ARABIC LIGATURE KAF WITH MEEM ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * FC3D ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC3E ARABIC LIGATURE KAF WITH YEH ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * 	064A ARABIC LETTER YEH
 * FC3F ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * FC40 ARABIC LIGATURE LAM WITH HAH ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	062D ARABIC LETTER HAH
 * FC41 ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	062E ARABIC LETTER KHAH
 * FC42 ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * FC43 ARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC44 ARABIC LIGATURE LAM WITH YEH ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	064A ARABIC LETTER YEH
 * FC45 ARABIC LIGATURE MEEM WITH JEEM ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * FC46 ARABIC LIGATURE MEEM WITH HAH ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FC47 ARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * FC48 ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FC49 ARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC4A ARABIC LIGATURE MEEM WITH YEH ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FC4B ARABIC LIGATURE NOON WITH JEEM ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * FC4C ARABIC LIGATURE NOON WITH HAH ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * 	062D ARABIC LETTER HAH
 * FC4D ARABIC LIGATURE NOON WITH KHAH ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * 	062E ARABIC LETTER KHAH
 * FC4E ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * 	0645 ARABIC LETTER MEEM
 * FC4F ARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC50 ARABIC LIGATURE NOON WITH YEH ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * 	064A ARABIC LETTER YEH
 * FC51 ARABIC LIGATURE HEH WITH JEEM ISOLATED FORM
 * 	0647 ARABIC LETTER HEH
 * 	062C ARABIC LETTER JEEM
 * FC52 ARABIC LIGATURE HEH WITH MEEM ISOLATED FORM
 * 	0647 ARABIC LETTER HEH
 * 	0645 ARABIC LETTER MEEM
 * FC53 ARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FORM
 * 	0647 ARABIC LETTER HEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC54 ARABIC LIGATURE HEH WITH YEH ISOLATED FORM
 * 	0647 ARABIC LETTER HEH
 * 	064A ARABIC LETTER YEH
 * FC55 ARABIC LIGATURE YEH WITH JEEM ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	062C ARABIC LETTER JEEM
 * FC56 ARABIC LIGATURE YEH WITH HAH ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	062D ARABIC LETTER HAH
 * FC57 ARABIC LIGATURE YEH WITH KHAH ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	062E ARABIC LETTER KHAH
 * FC58 ARABIC LIGATURE YEH WITH MEEM ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * FC59 ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC5A ARABIC LIGATURE YEH WITH YEH ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * 	064A ARABIC LETTER YEH
 * FC5B ARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED FORM
 * 	0630 ARABIC LETTER THAL
 * FC5C ARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORM
 * 	0631 ARABIC LETTER REH
 * FC5D ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC5E ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM
 * 	0020 SPACE
 * FC5F ARABIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORM
 * 	0020 SPACE
 * FC60 ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM
 * 	0020 SPACE
 * FC61 ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM
 * 	0020 SPACE
 * FC62 ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM
 * 	0020 SPACE
 * FC63 ARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM
 * 	0020 SPACE
 * FC64 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM
 * 	0631 ARABIC LETTER REH
 * 	064A ARABIC LETTER YEH
 * FC65 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORM
 * 	0632 ARABIC LETTER ZAIN
 * 	064A ARABIC LETTER YEH
 * FC66 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FC67 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	064A ARABIC LETTER YEH
 * FC68 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * 	064A ARABIC LETTER YEH
 * FC69 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	064A ARABIC LETTER YEH
 * FC6A ARABIC LIGATURE BEH WITH REH FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0631 ARABIC LETTER REH
 * FC6B ARABIC LIGATURE BEH WITH ZAIN FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0632 ARABIC LETTER ZAIN
 * FC6C ARABIC LIGATURE BEH WITH MEEM FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0645 ARABIC LETTER MEEM
 * FC6D ARABIC LIGATURE BEH WITH NOON FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0646 ARABIC LETTER NOON
 * FC6E ARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC6F ARABIC LIGATURE BEH WITH YEH FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	064A ARABIC LETTER YEH
 * FC70 ARABIC LIGATURE TEH WITH REH FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0631 ARABIC LETTER REH
 * FC71 ARABIC LIGATURE TEH WITH ZAIN FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0632 ARABIC LETTER ZAIN
 * FC72 ARABIC LIGATURE TEH WITH MEEM FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * FC73 ARABIC LIGATURE TEH WITH NOON FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0646 ARABIC LETTER NOON
 * FC74 ARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC75 ARABIC LIGATURE TEH WITH YEH FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	064A ARABIC LETTER YEH
 * FC76 ARABIC LIGATURE THEH WITH REH FINAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0631 ARABIC LETTER REH
 * FC77 ARABIC LIGATURE THEH WITH ZAIN FINAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0632 ARABIC LETTER ZAIN
 * FC78 ARABIC LIGATURE THEH WITH MEEM FINAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0645 ARABIC LETTER MEEM
 * FC79 ARABIC LIGATURE THEH WITH NOON FINAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0646 ARABIC LETTER NOON
 * FC7A ARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC7B ARABIC LIGATURE THEH WITH YEH FINAL FORM
 * 	062B ARABIC LETTER THEH
 * 	064A ARABIC LETTER YEH
 * FC7C ARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC7D ARABIC LIGATURE FEH WITH YEH FINAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	064A ARABIC LETTER YEH
 * FC7E ARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC7F ARABIC LIGATURE QAF WITH YEH FINAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	064A ARABIC LETTER YEH
 * FC80 ARABIC LIGATURE KAF WITH ALEF FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0627 ARABIC LETTER ALEF
 * FC81 ARABIC LIGATURE KAF WITH LAM FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0644 ARABIC LETTER LAM
 * FC82 ARABIC LIGATURE KAF WITH MEEM FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * FC83 ARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC84 ARABIC LIGATURE KAF WITH YEH FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	064A ARABIC LETTER YEH
 * FC85 ARABIC LIGATURE LAM WITH MEEM FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * FC86 ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC87 ARABIC LIGATURE LAM WITH YEH FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	064A ARABIC LETTER YEH
 * FC88 ARABIC LIGATURE MEEM WITH ALEF FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	0627 ARABIC LETTER ALEF
 * FC89 ARABIC LIGATURE MEEM WITH MEEM FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FC8A ARABIC LIGATURE NOON WITH REH FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0631 ARABIC LETTER REH
 * FC8B ARABIC LIGATURE NOON WITH ZAIN FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0632 ARABIC LETTER ZAIN
 * FC8C ARABIC LIGATURE NOON WITH MEEM FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0645 ARABIC LETTER MEEM
 * FC8D ARABIC LIGATURE NOON WITH NOON FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0646 ARABIC LETTER NOON
 * FC8E ARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC8F ARABIC LIGATURE NOON WITH YEH FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	064A ARABIC LETTER YEH
 * FC90 ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC91 ARABIC LIGATURE YEH WITH REH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0631 ARABIC LETTER REH
 * FC92 ARABIC LIGATURE YEH WITH ZAIN FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0632 ARABIC LETTER ZAIN
 * FC93 ARABIC LIGATURE YEH WITH MEEM FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * FC94 ARABIC LIGATURE YEH WITH NOON FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0646 ARABIC LETTER NOON
 * FC95 ARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FC96 ARABIC LIGATURE YEH WITH YEH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	064A ARABIC LETTER YEH
 * FC97 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FC98 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FC99 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORM
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FC9A ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FC9B ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * 	064A ARABIC LETTER YEH
 * FC9C ARABIC LIGATURE BEH WITH JEEM INITIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	062C ARABIC LETTER JEEM
 * FC9D ARABIC LIGATURE BEH WITH HAH INITIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	062D ARABIC LETTER HAH
 * FC9E ARABIC LIGATURE BEH WITH KHAH INITIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	062E ARABIC LETTER KHAH
 * FC9F ARABIC LIGATURE BEH WITH MEEM INITIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0645 ARABIC LETTER MEEM
 * FCA0 ARABIC LIGATURE BEH WITH HEH INITIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0647 ARABIC LETTER HEH
 * FCA1 ARABIC LIGATURE TEH WITH JEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062C ARABIC LETTER JEEM
 * FCA2 ARABIC LIGATURE TEH WITH HAH INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062D ARABIC LETTER HAH
 * FCA3 ARABIC LIGATURE TEH WITH KHAH INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062E ARABIC LETTER KHAH
 * FCA4 ARABIC LIGATURE TEH WITH MEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * FCA5 ARABIC LIGATURE TEH WITH HEH INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0647 ARABIC LETTER HEH
 * FCA6 ARABIC LIGATURE THEH WITH MEEM INITIAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0645 ARABIC LETTER MEEM
 * FCA7 ARABIC LIGATURE JEEM WITH HAH INITIAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * FCA8 ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FCA9 ARABIC LIGATURE HAH WITH JEEM INITIAL FORM
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * FCAA ARABIC LIGATURE HAH WITH MEEM INITIAL FORM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FCAB ARABIC LIGATURE KHAH WITH JEEM INITIAL FORM
 * 	062E ARABIC LETTER KHAH
 * 	062C ARABIC LETTER JEEM
 * FCAC ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FCAD ARABIC LIGATURE SEEN WITH JEEM INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062C ARABIC LETTER JEEM
 * FCAE ARABIC LIGATURE SEEN WITH HAH INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062D ARABIC LETTER HAH
 * FCAF ARABIC LIGATURE SEEN WITH KHAH INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062E ARABIC LETTER KHAH
 * FCB0 ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * FCB1 ARABIC LIGATURE SAD WITH HAH INITIAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	062D ARABIC LETTER HAH
 * FCB2 ARABIC LIGATURE SAD WITH KHAH INITIAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	062E ARABIC LETTER KHAH
 * FCB3 ARABIC LIGATURE SAD WITH MEEM INITIAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	0645 ARABIC LETTER MEEM
 * FCB4 ARABIC LIGATURE DAD WITH JEEM INITIAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062C ARABIC LETTER JEEM
 * FCB5 ARABIC LIGATURE DAD WITH HAH INITIAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062D ARABIC LETTER HAH
 * FCB6 ARABIC LIGATURE DAD WITH KHAH INITIAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062E ARABIC LETTER KHAH
 * FCB7 ARABIC LIGATURE DAD WITH MEEM INITIAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	0645 ARABIC LETTER MEEM
 * FCB8 ARABIC LIGATURE TAH WITH HAH INITIAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	062D ARABIC LETTER HAH
 * FCB9 ARABIC LIGATURE ZAH WITH MEEM INITIAL FORM
 * 	0638 ARABIC LETTER ZAH
 * 	0645 ARABIC LETTER MEEM
 * FCBA ARABIC LIGATURE AIN WITH JEEM INITIAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	062C ARABIC LETTER JEEM
 * FCBB ARABIC LIGATURE AIN WITH MEEM INITIAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * FCBC ARABIC LIGATURE GHAIN WITH JEEM INITIAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	062C ARABIC LETTER JEEM
 * FCBD ARABIC LIGATURE GHAIN WITH MEEM INITIAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0645 ARABIC LETTER MEEM
 * FCBE ARABIC LIGATURE FEH WITH JEEM INITIAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	062C ARABIC LETTER JEEM
 * FCBF ARABIC LIGATURE FEH WITH HAH INITIAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	062D ARABIC LETTER HAH
 * FCC0 ARABIC LIGATURE FEH WITH KHAH INITIAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	062E ARABIC LETTER KHAH
 * FCC1 ARABIC LIGATURE FEH WITH MEEM INITIAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	0645 ARABIC LETTER MEEM
 * FCC2 ARABIC LIGATURE QAF WITH HAH INITIAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	062D ARABIC LETTER HAH
 * FCC3 ARABIC LIGATURE QAF WITH MEEM INITIAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	0645 ARABIC LETTER MEEM
 * FCC4 ARABIC LIGATURE KAF WITH JEEM INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	062C ARABIC LETTER JEEM
 * FCC5 ARABIC LIGATURE KAF WITH HAH INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	062D ARABIC LETTER HAH
 * FCC6 ARABIC LIGATURE KAF WITH KHAH INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	062E ARABIC LETTER KHAH
 * FCC7 ARABIC LIGATURE KAF WITH LAM INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0644 ARABIC LETTER LAM
 * FCC8 ARABIC LIGATURE KAF WITH MEEM INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * FCC9 ARABIC LIGATURE LAM WITH JEEM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * FCCA ARABIC LIGATURE LAM WITH HAH INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062D ARABIC LETTER HAH
 * FCCB ARABIC LIGATURE LAM WITH KHAH INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062E ARABIC LETTER KHAH
 * FCCC ARABIC LIGATURE LAM WITH MEEM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * FCCD ARABIC LIGATURE LAM WITH HEH INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0647 ARABIC LETTER HEH
 * FCCE ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * FCCF ARABIC LIGATURE MEEM WITH HAH INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FCD0 ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * FCD1 ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FCD2 ARABIC LIGATURE NOON WITH JEEM INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * FCD3 ARABIC LIGATURE NOON WITH HAH INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062D ARABIC LETTER HAH
 * FCD4 ARABIC LIGATURE NOON WITH KHAH INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062E ARABIC LETTER KHAH
 * FCD5 ARABIC LIGATURE NOON WITH MEEM INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0645 ARABIC LETTER MEEM
 * FCD6 ARABIC LIGATURE NOON WITH HEH INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0647 ARABIC LETTER HEH
 * FCD7 ARABIC LIGATURE HEH WITH JEEM INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * 	062C ARABIC LETTER JEEM
 * FCD8 ARABIC LIGATURE HEH WITH MEEM INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * 	0645 ARABIC LETTER MEEM
 * FCD9 ARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * FCDA ARABIC LIGATURE YEH WITH JEEM INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	062C ARABIC LETTER JEEM
 * FCDB ARABIC LIGATURE YEH WITH HAH INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	062D ARABIC LETTER HAH
 * FCDC ARABIC LIGATURE YEH WITH KHAH INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	062E ARABIC LETTER KHAH
 * FCDD ARABIC LIGATURE YEH WITH MEEM INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * FCDE ARABIC LIGATURE YEH WITH HEH INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0647 ARABIC LETTER HEH
 * FCDF ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FCE0 ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORM
 * 	0647 ARABIC LETTER HEH
 * 	064A ARABIC LETTER YEH
 * FCE1 ARABIC LIGATURE BEH WITH MEEM MEDIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0645 ARABIC LETTER MEEM
 * FCE2 ARABIC LIGATURE BEH WITH HEH MEDIAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	0647 ARABIC LETTER HEH
 * FCE3 ARABIC LIGATURE TEH WITH MEEM MEDIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * FCE4 ARABIC LIGATURE TEH WITH HEH MEDIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0647 ARABIC LETTER HEH
 * FCE5 ARABIC LIGATURE THEH WITH MEEM MEDIAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0645 ARABIC LETTER MEEM
 * FCE6 ARABIC LIGATURE THEH WITH HEH MEDIAL FORM
 * 	062B ARABIC LETTER THEH
 * 	0647 ARABIC LETTER HEH
 * FCE7 ARABIC LIGATURE SEEN WITH MEEM MEDIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * FCE8 ARABIC LIGATURE SEEN WITH HEH MEDIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0647 ARABIC LETTER HEH
 * FCE9 ARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * FCEA ARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0647 ARABIC LETTER HEH
 * FCEB ARABIC LIGATURE KAF WITH LAM MEDIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0644 ARABIC LETTER LAM
 * FCEC ARABIC LIGATURE KAF WITH MEEM MEDIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * FCED ARABIC LIGATURE LAM WITH MEEM MEDIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * FCEE ARABIC LIGATURE NOON WITH MEEM MEDIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0645 ARABIC LETTER MEEM
 * FCEF ARABIC LIGATURE NOON WITH HEH MEDIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0647 ARABIC LETTER HEH
 * FCF0 ARABIC LIGATURE YEH WITH MEEM MEDIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * FCF1 ARABIC LIGATURE YEH WITH HEH MEDIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0647 ARABIC LETTER HEH
 * FCF2 ARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FCF3 ARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FCF4 ARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FCF5 ARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORM
 * 	0637 ARABIC LETTER TAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FCF6 ARABIC LIGATURE TAH WITH YEH ISOLATED FORM
 * 	0637 ARABIC LETTER TAH
 * 	064A ARABIC LETTER YEH
 * FCF7 ARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORM
 * 	0639 ARABIC LETTER AIN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FCF8 ARABIC LIGATURE AIN WITH YEH ISOLATED FORM
 * 	0639 ARABIC LETTER AIN
 * 	064A ARABIC LETTER YEH
 * FCF9 ARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FCFA ARABIC LIGATURE GHAIN WITH YEH ISOLATED FORM
 * 	063A ARABIC LETTER GHAIN
 * 	064A ARABIC LETTER YEH
 * FCFB ARABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FCFC ARABIC LIGATURE SEEN WITH YEH ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	064A ARABIC LETTER YEH
 * FCFD ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FCFE ARABIC LIGATURE SHEEN WITH YEH ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	064A ARABIC LETTER YEH
 * FCFF ARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORM
 * 	062D ARABIC LETTER HAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD00 ARABIC LIGATURE HAH WITH YEH ISOLATED FORM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FD01 ARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORM
 * 	062C ARABIC LETTER JEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD02 ARABIC LIGATURE JEEM WITH YEH ISOLATED FORM
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FD03 ARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORM
 * 	062E ARABIC LETTER KHAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD04 ARABIC LIGATURE KHAH WITH YEH ISOLATED FORM
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FD05 ARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD06 ARABIC LIGATURE SAD WITH YEH ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	064A ARABIC LETTER YEH
 * FD07 ARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD08 ARABIC LIGATURE DAD WITH YEH ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	064A ARABIC LETTER YEH
 * FD09 ARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062C ARABIC LETTER JEEM
 * FD0A ARABIC LIGATURE SHEEN WITH HAH ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * FD0B ARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062E ARABIC LETTER KHAH
 * FD0C ARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * FD0D ARABIC LIGATURE SHEEN WITH REH ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0631 ARABIC LETTER REH
 * FD0E ARABIC LIGATURE SEEN WITH REH ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0631 ARABIC LETTER REH
 * FD0F ARABIC LIGATURE SAD WITH REH ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	0631 ARABIC LETTER REH
 * FD10 ARABIC LIGATURE DAD WITH REH ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * 	0631 ARABIC LETTER REH
 * FD11 ARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD12 ARABIC LIGATURE TAH WITH YEH FINAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	064A ARABIC LETTER YEH
 * FD13 ARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD14 ARABIC LIGATURE AIN WITH YEH FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	064A ARABIC LETTER YEH
 * FD15 ARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD16 ARABIC LIGATURE GHAIN WITH YEH FINAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	064A ARABIC LETTER YEH
 * FD17 ARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD18 ARABIC LIGATURE SEEN WITH YEH FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	064A ARABIC LETTER YEH
 * FD19 ARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD1A ARABIC LIGATURE SHEEN WITH YEH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	064A ARABIC LETTER YEH
 * FD1B ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORM
 * 	062D ARABIC LETTER HAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD1C ARABIC LIGATURE HAH WITH YEH FINAL FORM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FD1D ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD1E ARABIC LIGATURE JEEM WITH YEH FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FD1F ARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORM
 * 	062E ARABIC LETTER KHAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD20 ARABIC LIGATURE KHAH WITH YEH FINAL FORM
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FD21 ARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD22 ARABIC LIGATURE SAD WITH YEH FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	064A ARABIC LETTER YEH
 * FD23 ARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD24 ARABIC LIGATURE DAD WITH YEH FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	064A ARABIC LETTER YEH
 * FD25 ARABIC LIGATURE SHEEN WITH JEEM FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062C ARABIC LETTER JEEM
 * FD26 ARABIC LIGATURE SHEEN WITH HAH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * FD27 ARABIC LIGATURE SHEEN WITH KHAH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062E ARABIC LETTER KHAH
 * FD28 ARABIC LIGATURE SHEEN WITH MEEM FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * FD29 ARABIC LIGATURE SHEEN WITH REH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0631 ARABIC LETTER REH
 * FD2A ARABIC LIGATURE SEEN WITH REH FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0631 ARABIC LETTER REH
 * FD2B ARABIC LIGATURE SAD WITH REH FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	0631 ARABIC LETTER REH
 * FD2C ARABIC LIGATURE DAD WITH REH FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	0631 ARABIC LETTER REH
 * FD2D ARABIC LIGATURE SHEEN WITH JEEM INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062C ARABIC LETTER JEEM
 * FD2E ARABIC LIGATURE SHEEN WITH HAH INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * FD2F ARABIC LIGATURE SHEEN WITH KHAH INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062E ARABIC LETTER KHAH
 * FD30 ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * FD31 ARABIC LIGATURE SEEN WITH HEH INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0647 ARABIC LETTER HEH
 * FD32 ARABIC LIGATURE SHEEN WITH HEH INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0647 ARABIC LETTER HEH
 * FD33 ARABIC LIGATURE TAH WITH MEEM INITIAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * FD34 ARABIC LIGATURE SEEN WITH JEEM MEDIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062C ARABIC LETTER JEEM
 * FD35 ARABIC LIGATURE SEEN WITH HAH MEDIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062D ARABIC LETTER HAH
 * FD36 ARABIC LIGATURE SEEN WITH KHAH MEDIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062E ARABIC LETTER KHAH
 * FD37 ARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062C ARABIC LETTER JEEM
 * FD38 ARABIC LIGATURE SHEEN WITH HAH MEDIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * FD39 ARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062E ARABIC LETTER KHAH
 * FD3A ARABIC LIGATURE TAH WITH MEEM MEDIAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * FD3B ARABIC LIGATURE ZAH WITH MEEM MEDIAL FORM
 * 	0638 ARABIC LETTER ZAH
 * 	0645 ARABIC LETTER MEEM
 * FD3C ARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM
 * 	0627 ARABIC LETTER ALEF
 * FD3D ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * FD50 ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FD51 ARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * FD52 ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * FD53 ARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FD54 ARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD55 ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * FD56 ARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD57 ARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * FD58 ARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD59 ARABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD5A ARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FD5B ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD5C ARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * FD5D ARABIC LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * FD5E ARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062C ARABIC LETTER JEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD5F ARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD60 ARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD61 ARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * FD62 ARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD63 ARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD64 ARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	062D ARABIC LETTER HAH
 * 	062D ARABIC LETTER HAH
 * FD65 ARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	062D ARABIC LETTER HAH
 * 	062D ARABIC LETTER HAH
 * FD66 ARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD67 ARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FD68 ARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FD69 ARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FD6A ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * FD6B ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * FD6C ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD6D ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD6E ARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062D ARABIC LETTER HAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD6F ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD70 ARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD71 ARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD72 ARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD73 ARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD74 ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORM
 * 	0637 ARABIC LETTER TAH
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FD75 ARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FD76 ARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD77 ARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD78 ARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD79 ARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD7A ARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FD7B ARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM
 * 	063A ARABIC LETTER GHAIN
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD7C ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD7D ARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD7E ARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD7F ARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD80 ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FD81 ARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FD82 ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062D ARABIC LETTER HAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD83 ARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * 	062C ARABIC LETTER JEEM
 * FD84 ARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * 	062C ARABIC LETTER JEEM
 * FD85 ARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD86 ARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD87 ARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD88 ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FD89 ARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * FD8A ARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FD8B ARABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FD8C ARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * FD8D ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FD8E ARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * 	062C ARABIC LETTER JEEM
 * FD8F ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * 	0645 ARABIC LETTER MEEM
 * FD92 ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * 	062E ARABIC LETTER KHAH
 * FD93 ARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * FD94 ARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD95 ARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FD96 ARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062D ARABIC LETTER HAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD97 ARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FD98 ARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FD99 ARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD9A ARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FD9B ARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FD9C ARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD9D ARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FD9E ARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FD9F ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FDA0 ARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062C ARABIC LETTER JEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDA1 ARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FDA2 ARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	062E ARABIC LETTER KHAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDA3 ARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDA4 ARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORM
 * 	062A ARABIC LETTER TEH
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDA5 ARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDA6 ARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDA7 ARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDA8 ARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062E ARABIC LETTER KHAH
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDA9 ARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDAA ARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDAB ARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDAC ARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FDAD ARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDAE ARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDAF ARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FDB0 ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDB1 ARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDB2 ARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDB3 ARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDB4 ARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORM
 * 	0642 ARABIC LETTER QAF
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * FDB5 ARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * FDB6 ARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDB7 ARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDB8 ARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * FDB9 ARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FDBA ARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FDBB ARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FDBC ARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FDBD ARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * FDBE ARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDBF ARABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORM
 * 	062D ARABIC LETTER HAH
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FDC0 ARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FDC1 ARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORM
 * 	0641 ARABIC LETTER FEH
 * 	0645 ARABIC LETTER MEEM
 * 	064A ARABIC LETTER YEH
 * FDC2 ARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * 	062D ARABIC LETTER HAH
 * 	064A ARABIC LETTER YEH
 * FDC3 ARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FDC4 ARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORM
 * 	0639 ARABIC LETTER AIN
 * 	062C ARABIC LETTER JEEM
 * 	0645 ARABIC LETTER MEEM
 * FDC5 ARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORM
 * 	0635 ARABIC LETTER SAD
 * 	0645 ARABIC LETTER MEEM
 * 	0645 ARABIC LETTER MEEM
 * FDC6 ARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * 	062E ARABIC LETTER KHAH
 * 	064A ARABIC LETTER YEH
 * FDC7 ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * 	062C ARABIC LETTER JEEM
 * 	064A ARABIC LETTER YEH
 * FDF0 ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	0644 ARABIC LETTER LAM
 * 	06D2 ARABIC LETTER YEH BARREE
 * FDF1 ARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORM
 * 	0642 ARABIC LETTER QAF
 * 	0644 ARABIC LETTER LAM
 * 	06D2 ARABIC LETTER YEH BARREE
 * FDF2 ARABIC LIGATURE ALLAH ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * 	0644 ARABIC LETTER LAM
 * 	0644 ARABIC LETTER LAM
 * 	0647 ARABIC LETTER HEH
 * FDF3 ARABIC LIGATURE AKBAR ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * 	0643 ARABIC LETTER KAF
 * 	0628 ARABIC LETTER BEH
 * 	0631 ARABIC LETTER REH
 * FDF4 ARABIC LIGATURE MOHAMMAD ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * 	062D ARABIC LETTER HAH
 * 	0645 ARABIC LETTER MEEM
 * 	062F ARABIC LETTER DAL
 * FDF5 ARABIC LIGATURE SALAM ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	0644 ARABIC LETTER LAM
 * 	0639 ARABIC LETTER AIN
 * 	0645 ARABIC LETTER MEEM
 * FDF6 ARABIC LIGATURE RASOUL ISOLATED FORM
 * 	0631 ARABIC LETTER REH
 * 	0633 ARABIC LETTER SEEN
 * 	0648 ARABIC LETTER WAW
 * 	0644 ARABIC LETTER LAM
 * FDF7 ARABIC LIGATURE ALAYHE ISOLATED FORM
 * 	0639 ARABIC LETTER AIN
 * 	0644 ARABIC LETTER LAM
 * 	064A ARABIC LETTER YEH
 * 	0647 ARABIC LETTER HEH
 * FDF8 ARABIC LIGATURE WASALLAM ISOLATED FORM
 * 	0648 ARABIC LETTER WAW
 * 	0633 ARABIC LETTER SEEN
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * FDF9 ARABIC LIGATURE SALLA ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * 	0644 ARABIC LETTER LAM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FDFA ARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAM
 * 	0635 ARABIC LETTER SAD
 * 	0644 ARABIC LETTER LAM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * 	0020 SPACE
 * 	0627 ARABIC LETTER ALEF
 * 	0644 ARABIC LETTER LAM
 * 	0644 ARABIC LETTER LAM
 * 	0647 ARABIC LETTER HEH
 * 	0020 SPACE
 * 	0639 ARABIC LETTER AIN
 * 	0644 ARABIC LETTER LAM
 * 	064A ARABIC LETTER YEH
 * 	0647 ARABIC LETTER HEH
 * 	0020 SPACE
 * 	0648 ARABIC LETTER WAW
 * 	0633 ARABIC LETTER SEEN
 * 	0644 ARABIC LETTER LAM
 * 	0645 ARABIC LETTER MEEM
 * FDFB ARABIC LIGATURE JALLAJALALOUHOU
 * 	062C ARABIC LETTER JEEM
 * 	0644 ARABIC LETTER LAM
 * 	0020 SPACE
 * 	062C ARABIC LETTER JEEM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * 	0644 ARABIC LETTER LAM
 * 	0647 ARABIC LETTER HEH
 * FDFC RIAL SIGN
 * 	0631 ARABIC LETTER REH
 * 	06CC ARABIC LETTER FARSI YEH
 * 	0627 ARABIC LETTER ALEF
 * 	0644 ARABIC LETTER LAM
 * FE30 PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
 * 	002E FULL STOP
 * 	002E FULL STOP
 * FE31 PRESENTATION FORM FOR VERTICAL EM DASH
 * 	2014 EM DASH
 * FE32 PRESENTATION FORM FOR VERTICAL EN DASH
 * 	2013 EN DASH
 * FE33 PRESENTATION FORM FOR VERTICAL LOW LINE
 * 	005F LOW LINE
 * FE34 PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
 * 	005F LOW LINE
 * FE35 PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
 * 	0028 LEFT PARENTHESIS
 * FE36 PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
 * 	0029 RIGHT PARENTHESIS
 * FE37 PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
 * 	007B LEFT CURLY BRACKET
 * FE38 PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
 * 	007D RIGHT CURLY BRACKET
 * FE39 PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
 * 	3014 LEFT TORTOISE SHELL BRACKET
 * FE3A PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
 * 	3015 RIGHT TORTOISE SHELL BRACKET
 * FE3B PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
 * 	3010 LEFT BLACK LENTICULAR BRACKET
 * FE3C PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
 * 	3011 RIGHT BLACK LENTICULAR BRACKET
 * FE3D PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
 * 	300A LEFT DOUBLE ANGLE BRACKET
 * FE3E PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
 * 	300B RIGHT DOUBLE ANGLE BRACKET
 * FE3F PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
 * 	3008 LEFT ANGLE BRACKET
 * FE40 PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
 * 	3009 RIGHT ANGLE BRACKET
 * FE41 PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
 * 	300C LEFT CORNER BRACKET
 * FE42 PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
 * 	300D RIGHT CORNER BRACKET
 * FE43 PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
 * 	300E LEFT WHITE CORNER BRACKET
 * FE44 PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
 * 	300F RIGHT WHITE CORNER BRACKET
 * FE49 DASHED OVERLINE
 * 	0020 SPACE
 * FE4A CENTRELINE OVERLINE
 * 	0020 SPACE
 * FE4B WAVY OVERLINE
 * 	0020 SPACE
 * FE4C DOUBLE WAVY OVERLINE
 * 	0020 SPACE
 * FE4D DASHED LOW LINE
 * 	005F LOW LINE
 * FE4E CENTRELINE LOW LINE
 * 	005F LOW LINE
 * FE4F WAVY LOW LINE
 * 	005F LOW LINE
 * FE50 SMALL COMMA
 * 	002C COMMA
 * FE51 SMALL IDEOGRAPHIC COMMA
 * 	3001 IDEOGRAPHIC COMMA
 * FE52 SMALL FULL STOP
 * 	002E FULL STOP
 * FE54 SMALL SEMICOLON
 * 	003B SEMICOLON
 * FE55 SMALL COLON
 * 	003A COLON
 * FE56 SMALL QUESTION MARK
 * 	003F QUESTION MARK
 * FE57 SMALL EXCLAMATION MARK
 * 	0021 EXCLAMATION MARK
 * FE58 SMALL EM DASH
 * 	2014 EM DASH
 * FE59 SMALL LEFT PARENTHESIS
 * 	0028 LEFT PARENTHESIS
 * FE5A SMALL RIGHT PARENTHESIS
 * 	0029 RIGHT PARENTHESIS
 * FE5B SMALL LEFT CURLY BRACKET
 * 	007B LEFT CURLY BRACKET
 * FE5C SMALL RIGHT CURLY BRACKET
 * 	007D RIGHT CURLY BRACKET
 * FE5D SMALL LEFT TORTOISE SHELL BRACKET
 * 	3014 LEFT TORTOISE SHELL BRACKET
 * FE5E SMALL RIGHT TORTOISE SHELL BRACKET
 * 	3015 RIGHT TORTOISE SHELL BRACKET
 * FE5F SMALL NUMBER SIGN
 * 	0023 NUMBER SIGN
 * FE60 SMALL AMPERSAND
 * 	0026 AMPERSAND
 * FE61 SMALL ASTERISK
 * 	002A ASTERISK
 * FE62 SMALL PLUS SIGN
 * 	002B PLUS SIGN
 * FE63 SMALL HYPHEN-MINUS
 * 	002D HYPHEN-MINUS
 * FE64 SMALL LESS-THAN SIGN
 * 	003C LESS-THAN SIGN
 * FE65 SMALL GREATER-THAN SIGN
 * 	003E GREATER-THAN SIGN
 * FE66 SMALL EQUALS SIGN
 * 	003D EQUALS SIGN
 * FE68 SMALL REVERSE SOLIDUS
 * 	005C REVERSE SOLIDUS
 * FE69 SMALL DOLLAR SIGN
 * 	0024 DOLLAR SIGN
 * FE6A SMALL PERCENT SIGN
 * 	0025 PERCENT SIGN
 * FE6B SMALL COMMERCIAL AT
 * 	0040 COMMERCIAL AT
 * FE70 ARABIC FATHATAN ISOLATED FORM
 * 	0020 SPACE
 * FE71 ARABIC TATWEEL WITH FATHATAN ABOVE
 * 	0640 ARABIC TATWEEL
 * FE72 ARABIC DAMMATAN ISOLATED FORM
 * 	0020 SPACE
 * FE74 ARABIC KASRATAN ISOLATED FORM
 * 	0020 SPACE
 * FE76 ARABIC FATHA ISOLATED FORM
 * 	0020 SPACE
 * FE77 ARABIC FATHA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FE78 ARABIC DAMMA ISOLATED FORM
 * 	0020 SPACE
 * FE79 ARABIC DAMMA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FE7A ARABIC KASRA ISOLATED FORM
 * 	0020 SPACE
 * FE7B ARABIC KASRA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FE7C ARABIC SHADDA ISOLATED FORM
 * 	0020 SPACE
 * FE7D ARABIC SHADDA MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FE7E ARABIC SUKUN ISOLATED FORM
 * 	0020 SPACE
 * FE7F ARABIC SUKUN MEDIAL FORM
 * 	0640 ARABIC TATWEEL
 * FE80 ARABIC LETTER HAMZA ISOLATED FORM
 * 	0621 ARABIC LETTER HAMZA
 * FE81 ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * FE82 ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM
 * 	0627 ARABIC LETTER ALEF
 * FE83 ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * FE84 ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM
 * 	0627 ARABIC LETTER ALEF
 * FE85 ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM
 * 	0648 ARABIC LETTER WAW
 * FE86 ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM
 * 	0648 ARABIC LETTER WAW
 * FE87 ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * FE88 ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM
 * 	0627 ARABIC LETTER ALEF
 * FE89 ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * FE8A ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM
 * 	064A ARABIC LETTER YEH
 * FE8B ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * FE8C ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM
 * 	064A ARABIC LETTER YEH
 * FE8D ARABIC LETTER ALEF ISOLATED FORM
 * 	0627 ARABIC LETTER ALEF
 * FE8E ARABIC LETTER ALEF FINAL FORM
 * 	0627 ARABIC LETTER ALEF
 * FE8F ARABIC LETTER BEH ISOLATED FORM
 * 	0628 ARABIC LETTER BEH
 * FE90 ARABIC LETTER BEH FINAL FORM
 * 	0628 ARABIC LETTER BEH
 * FE91 ARABIC LETTER BEH INITIAL FORM
 * 	0628 ARABIC LETTER BEH
 * FE92 ARABIC LETTER BEH MEDIAL FORM
 * 	0628 ARABIC LETTER BEH
 * FE93 ARABIC LETTER TEH MARBUTA ISOLATED FORM
 * 	0629 ARABIC LETTER TEH MARBUTA
 * FE94 ARABIC LETTER TEH MARBUTA FINAL FORM
 * 	0629 ARABIC LETTER TEH MARBUTA
 * FE95 ARABIC LETTER TEH ISOLATED FORM
 * 	062A ARABIC LETTER TEH
 * FE96 ARABIC LETTER TEH FINAL FORM
 * 	062A ARABIC LETTER TEH
 * FE97 ARABIC LETTER TEH INITIAL FORM
 * 	062A ARABIC LETTER TEH
 * FE98 ARABIC LETTER TEH MEDIAL FORM
 * 	062A ARABIC LETTER TEH
 * FE99 ARABIC LETTER THEH ISOLATED FORM
 * 	062B ARABIC LETTER THEH
 * FE9A ARABIC LETTER THEH FINAL FORM
 * 	062B ARABIC LETTER THEH
 * FE9B ARABIC LETTER THEH INITIAL FORM
 * 	062B ARABIC LETTER THEH
 * FE9C ARABIC LETTER THEH MEDIAL FORM
 * 	062B ARABIC LETTER THEH
 * FE9D ARABIC LETTER JEEM ISOLATED FORM
 * 	062C ARABIC LETTER JEEM
 * FE9E ARABIC LETTER JEEM FINAL FORM
 * 	062C ARABIC LETTER JEEM
 * FE9F ARABIC LETTER JEEM INITIAL FORM
 * 	062C ARABIC LETTER JEEM
 * FEA0 ARABIC LETTER JEEM MEDIAL FORM
 * 	062C ARABIC LETTER JEEM
 * FEA1 ARABIC LETTER HAH ISOLATED FORM
 * 	062D ARABIC LETTER HAH
 * FEA2 ARABIC LETTER HAH FINAL FORM
 * 	062D ARABIC LETTER HAH
 * FEA3 ARABIC LETTER HAH INITIAL FORM
 * 	062D ARABIC LETTER HAH
 * FEA4 ARABIC LETTER HAH MEDIAL FORM
 * 	062D ARABIC LETTER HAH
 * FEA5 ARABIC LETTER KHAH ISOLATED FORM
 * 	062E ARABIC LETTER KHAH
 * FEA6 ARABIC LETTER KHAH FINAL FORM
 * 	062E ARABIC LETTER KHAH
 * FEA7 ARABIC LETTER KHAH INITIAL FORM
 * 	062E ARABIC LETTER KHAH
 * FEA8 ARABIC LETTER KHAH MEDIAL FORM
 * 	062E ARABIC LETTER KHAH
 * FEA9 ARABIC LETTER DAL ISOLATED FORM
 * 	062F ARABIC LETTER DAL
 * FEAA ARABIC LETTER DAL FINAL FORM
 * 	062F ARABIC LETTER DAL
 * FEAB ARABIC LETTER THAL ISOLATED FORM
 * 	0630 ARABIC LETTER THAL
 * FEAC ARABIC LETTER THAL FINAL FORM
 * 	0630 ARABIC LETTER THAL
 * FEAD ARABIC LETTER REH ISOLATED FORM
 * 	0631 ARABIC LETTER REH
 * FEAE ARABIC LETTER REH FINAL FORM
 * 	0631 ARABIC LETTER REH
 * FEAF ARABIC LETTER ZAIN ISOLATED FORM
 * 	0632 ARABIC LETTER ZAIN
 * FEB0 ARABIC LETTER ZAIN FINAL FORM
 * 	0632 ARABIC LETTER ZAIN
 * FEB1 ARABIC LETTER SEEN ISOLATED FORM
 * 	0633 ARABIC LETTER SEEN
 * FEB2 ARABIC LETTER SEEN FINAL FORM
 * 	0633 ARABIC LETTER SEEN
 * FEB3 ARABIC LETTER SEEN INITIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * FEB4 ARABIC LETTER SEEN MEDIAL FORM
 * 	0633 ARABIC LETTER SEEN
 * FEB5 ARABIC LETTER SHEEN ISOLATED FORM
 * 	0634 ARABIC LETTER SHEEN
 * FEB6 ARABIC LETTER SHEEN FINAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * FEB7 ARABIC LETTER SHEEN INITIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * FEB8 ARABIC LETTER SHEEN MEDIAL FORM
 * 	0634 ARABIC LETTER SHEEN
 * FEB9 ARABIC LETTER SAD ISOLATED FORM
 * 	0635 ARABIC LETTER SAD
 * FEBA ARABIC LETTER SAD FINAL FORM
 * 	0635 ARABIC LETTER SAD
 * FEBB ARABIC LETTER SAD INITIAL FORM
 * 	0635 ARABIC LETTER SAD
 * FEBC ARABIC LETTER SAD MEDIAL FORM
 * 	0635 ARABIC LETTER SAD
 * FEBD ARABIC LETTER DAD ISOLATED FORM
 * 	0636 ARABIC LETTER DAD
 * FEBE ARABIC LETTER DAD FINAL FORM
 * 	0636 ARABIC LETTER DAD
 * FEBF ARABIC LETTER DAD INITIAL FORM
 * 	0636 ARABIC LETTER DAD
 * FEC0 ARABIC LETTER DAD MEDIAL FORM
 * 	0636 ARABIC LETTER DAD
 * FEC1 ARABIC LETTER TAH ISOLATED FORM
 * 	0637 ARABIC LETTER TAH
 * FEC2 ARABIC LETTER TAH FINAL FORM
 * 	0637 ARABIC LETTER TAH
 * FEC3 ARABIC LETTER TAH INITIAL FORM
 * 	0637 ARABIC LETTER TAH
 * FEC4 ARABIC LETTER TAH MEDIAL FORM
 * 	0637 ARABIC LETTER TAH
 * FEC5 ARABIC LETTER ZAH ISOLATED FORM
 * 	0638 ARABIC LETTER ZAH
 * FEC6 ARABIC LETTER ZAH FINAL FORM
 * 	0638 ARABIC LETTER ZAH
 * FEC7 ARABIC LETTER ZAH INITIAL FORM
 * 	0638 ARABIC LETTER ZAH
 * FEC8 ARABIC LETTER ZAH MEDIAL FORM
 * 	0638 ARABIC LETTER ZAH
 * FEC9 ARABIC LETTER AIN ISOLATED FORM
 * 	0639 ARABIC LETTER AIN
 * FECA ARABIC LETTER AIN FINAL FORM
 * 	0639 ARABIC LETTER AIN
 * FECB ARABIC LETTER AIN INITIAL FORM
 * 	0639 ARABIC LETTER AIN
 * FECC ARABIC LETTER AIN MEDIAL FORM
 * 	0639 ARABIC LETTER AIN
 * FECD ARABIC LETTER GHAIN ISOLATED FORM
 * 	063A ARABIC LETTER GHAIN
 * FECE ARABIC LETTER GHAIN FINAL FORM
 * 	063A ARABIC LETTER GHAIN
 * FECF ARABIC LETTER GHAIN INITIAL FORM
 * 	063A ARABIC LETTER GHAIN
 * FED0 ARABIC LETTER GHAIN MEDIAL FORM
 * 	063A ARABIC LETTER GHAIN
 * FED1 ARABIC LETTER FEH ISOLATED FORM
 * 	0641 ARABIC LETTER FEH
 * FED2 ARABIC LETTER FEH FINAL FORM
 * 	0641 ARABIC LETTER FEH
 * FED3 ARABIC LETTER FEH INITIAL FORM
 * 	0641 ARABIC LETTER FEH
 * FED4 ARABIC LETTER FEH MEDIAL FORM
 * 	0641 ARABIC LETTER FEH
 * FED5 ARABIC LETTER QAF ISOLATED FORM
 * 	0642 ARABIC LETTER QAF
 * FED6 ARABIC LETTER QAF FINAL FORM
 * 	0642 ARABIC LETTER QAF
 * FED7 ARABIC LETTER QAF INITIAL FORM
 * 	0642 ARABIC LETTER QAF
 * FED8 ARABIC LETTER QAF MEDIAL FORM
 * 	0642 ARABIC LETTER QAF
 * FED9 ARABIC LETTER KAF ISOLATED FORM
 * 	0643 ARABIC LETTER KAF
 * FEDA ARABIC LETTER KAF FINAL FORM
 * 	0643 ARABIC LETTER KAF
 * FEDB ARABIC LETTER KAF INITIAL FORM
 * 	0643 ARABIC LETTER KAF
 * FEDC ARABIC LETTER KAF MEDIAL FORM
 * 	0643 ARABIC LETTER KAF
 * FEDD ARABIC LETTER LAM ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * FEDE ARABIC LETTER LAM FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * FEDF ARABIC LETTER LAM INITIAL FORM
 * 	0644 ARABIC LETTER LAM
 * FEE0 ARABIC LETTER LAM MEDIAL FORM
 * 	0644 ARABIC LETTER LAM
 * FEE1 ARABIC LETTER MEEM ISOLATED FORM
 * 	0645 ARABIC LETTER MEEM
 * FEE2 ARABIC LETTER MEEM FINAL FORM
 * 	0645 ARABIC LETTER MEEM
 * FEE3 ARABIC LETTER MEEM INITIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * FEE4 ARABIC LETTER MEEM MEDIAL FORM
 * 	0645 ARABIC LETTER MEEM
 * FEE5 ARABIC LETTER NOON ISOLATED FORM
 * 	0646 ARABIC LETTER NOON
 * FEE6 ARABIC LETTER NOON FINAL FORM
 * 	0646 ARABIC LETTER NOON
 * FEE7 ARABIC LETTER NOON INITIAL FORM
 * 	0646 ARABIC LETTER NOON
 * FEE8 ARABIC LETTER NOON MEDIAL FORM
 * 	0646 ARABIC LETTER NOON
 * FEE9 ARABIC LETTER HEH ISOLATED FORM
 * 	0647 ARABIC LETTER HEH
 * FEEA ARABIC LETTER HEH FINAL FORM
 * 	0647 ARABIC LETTER HEH
 * FEEB ARABIC LETTER HEH INITIAL FORM
 * 	0647 ARABIC LETTER HEH
 * FEEC ARABIC LETTER HEH MEDIAL FORM
 * 	0647 ARABIC LETTER HEH
 * FEED ARABIC LETTER WAW ISOLATED FORM
 * 	0648 ARABIC LETTER WAW
 * FEEE ARABIC LETTER WAW FINAL FORM
 * 	0648 ARABIC LETTER WAW
 * FEEF ARABIC LETTER ALEF MAKSURA ISOLATED FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FEF0 ARABIC LETTER ALEF MAKSURA FINAL FORM
 * 	0649 ARABIC LETTER ALEF MAKSURA
 * FEF1 ARABIC LETTER YEH ISOLATED FORM
 * 	064A ARABIC LETTER YEH
 * FEF2 ARABIC LETTER YEH FINAL FORM
 * 	064A ARABIC LETTER YEH
 * FEF3 ARABIC LETTER YEH INITIAL FORM
 * 	064A ARABIC LETTER YEH
 * FEF4 ARABIC LETTER YEH MEDIAL FORM
 * 	064A ARABIC LETTER YEH
 * FEF5 ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEF6 ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEF7 ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEF8 ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEF9 ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEFA ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEFB ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FEFC ARABIC LIGATURE LAM WITH ALEF FINAL FORM
 * 	0644 ARABIC LETTER LAM
 * 	0627 ARABIC LETTER ALEF
 * FF01 FULLWIDTH EXCLAMATION MARK
 * 	0021 EXCLAMATION MARK
 * FF02 FULLWIDTH QUOTATION MARK
 * 	0022 QUOTATION MARK
 * FF03 FULLWIDTH NUMBER SIGN
 * 	0023 NUMBER SIGN
 * FF04 FULLWIDTH DOLLAR SIGN
 * 	0024 DOLLAR SIGN
 * FF05 FULLWIDTH PERCENT SIGN
 * 	0025 PERCENT SIGN
 * FF06 FULLWIDTH AMPERSAND
 * 	0026 AMPERSAND
 * FF07 FULLWIDTH APOSTROPHE
 * 	0027 APOSTROPHE
 * FF08 FULLWIDTH LEFT PARENTHESIS
 * 	0028 LEFT PARENTHESIS
 * FF09 FULLWIDTH RIGHT PARENTHESIS
 * 	0029 RIGHT PARENTHESIS
 * FF0A FULLWIDTH ASTERISK
 * 	002A ASTERISK
 * FF0B FULLWIDTH PLUS SIGN
 * 	002B PLUS SIGN
 * FF0C FULLWIDTH COMMA
 * 	002C COMMA
 * FF0D FULLWIDTH HYPHEN-MINUS
 * 	002D HYPHEN-MINUS
 * FF0E FULLWIDTH FULL STOP
 * 	002E FULL STOP
 * FF0F FULLWIDTH SOLIDUS
 * 	002F SOLIDUS
 * FF10 FULLWIDTH DIGIT ZERO
 * 	0030 DIGIT ZERO
 * FF11 FULLWIDTH DIGIT ONE
 * 	0031 DIGIT ONE
 * FF12 FULLWIDTH DIGIT TWO
 * 	0032 DIGIT TWO
 * FF13 FULLWIDTH DIGIT THREE
 * 	0033 DIGIT THREE
 * FF14 FULLWIDTH DIGIT FOUR
 * 	0034 DIGIT FOUR
 * FF15 FULLWIDTH DIGIT FIVE
 * 	0035 DIGIT FIVE
 * FF16 FULLWIDTH DIGIT SIX
 * 	0036 DIGIT SIX
 * FF17 FULLWIDTH DIGIT SEVEN
 * 	0037 DIGIT SEVEN
 * FF18 FULLWIDTH DIGIT EIGHT
 * 	0038 DIGIT EIGHT
 * FF19 FULLWIDTH DIGIT NINE
 * 	0039 DIGIT NINE
 * FF1A FULLWIDTH COLON
 * 	003A COLON
 * FF1B FULLWIDTH SEMICOLON
 * 	003B SEMICOLON
 * FF1C FULLWIDTH LESS-THAN SIGN
 * 	003C LESS-THAN SIGN
 * FF1D FULLWIDTH EQUALS SIGN
 * 	003D EQUALS SIGN
 * FF1E FULLWIDTH GREATER-THAN SIGN
 * 	003E GREATER-THAN SIGN
 * FF1F FULLWIDTH QUESTION MARK
 * 	003F QUESTION MARK
 * FF20 FULLWIDTH COMMERCIAL AT
 * 	0040 COMMERCIAL AT
 * FF21 FULLWIDTH LATIN CAPITAL LETTER A
 * 	0041 LATIN CAPITAL LETTER A
 * FF22 FULLWIDTH LATIN CAPITAL LETTER B
 * 	0042 LATIN CAPITAL LETTER B
 * FF23 FULLWIDTH LATIN CAPITAL LETTER C
 * 	0043 LATIN CAPITAL LETTER C
 * FF24 FULLWIDTH LATIN CAPITAL LETTER D
 * 	0044 LATIN CAPITAL LETTER D
 * FF25 FULLWIDTH LATIN CAPITAL LETTER E
 * 	0045 LATIN CAPITAL LETTER E
 * FF26 FULLWIDTH LATIN CAPITAL LETTER F
 * 	0046 LATIN CAPITAL LETTER F
 * FF27 FULLWIDTH LATIN CAPITAL LETTER G
 * 	0047 LATIN CAPITAL LETTER G
 * FF28 FULLWIDTH LATIN CAPITAL LETTER H
 * 	0048 LATIN CAPITAL LETTER H
 * FF29 FULLWIDTH LATIN CAPITAL LETTER I
 * 	0049 LATIN CAPITAL LETTER I
 * FF2A FULLWIDTH LATIN CAPITAL LETTER J
 * 	004A LATIN CAPITAL LETTER J
 * FF2B FULLWIDTH LATIN CAPITAL LETTER K
 * 	004B LATIN CAPITAL LETTER K
 * FF2C FULLWIDTH LATIN CAPITAL LETTER L
 * 	004C LATIN CAPITAL LETTER L
 * FF2D FULLWIDTH LATIN CAPITAL LETTER M
 * 	004D LATIN CAPITAL LETTER M
 * FF2E FULLWIDTH LATIN CAPITAL LETTER N
 * 	004E LATIN CAPITAL LETTER N
 * FF2F FULLWIDTH LATIN CAPITAL LETTER O
 * 	004F LATIN CAPITAL LETTER O
 * FF30 FULLWIDTH LATIN CAPITAL LETTER P
 * 	0050 LATIN CAPITAL LETTER P
 * FF31 FULLWIDTH LATIN CAPITAL LETTER Q
 * 	0051 LATIN CAPITAL LETTER Q
 * FF32 FULLWIDTH LATIN CAPITAL LETTER R
 * 	0052 LATIN CAPITAL LETTER R
 * FF33 FULLWIDTH LATIN CAPITAL LETTER S
 * 	0053 LATIN CAPITAL LETTER S
 * FF34 FULLWIDTH LATIN CAPITAL LETTER T
 * 	0054 LATIN CAPITAL LETTER T
 * FF35 FULLWIDTH LATIN CAPITAL LETTER U
 * 	0055 LATIN CAPITAL LETTER U
 * FF36 FULLWIDTH LATIN CAPITAL LETTER V
 * 	0056 LATIN CAPITAL LETTER V
 * FF37 FULLWIDTH LATIN CAPITAL LETTER W
 * 	0057 LATIN CAPITAL LETTER W
 * FF38 FULLWIDTH LATIN CAPITAL LETTER X
 * 	0058 LATIN CAPITAL LETTER X
 * FF39 FULLWIDTH LATIN CAPITAL LETTER Y
 * 	0059 LATIN CAPITAL LETTER Y
 * FF3A FULLWIDTH LATIN CAPITAL LETTER Z
 * 	005A LATIN CAPITAL LETTER Z
 * FF3B FULLWIDTH LEFT SQUARE BRACKET
 * 	005B LEFT SQUARE BRACKET
 * FF3C FULLWIDTH REVERSE SOLIDUS
 * 	005C REVERSE SOLIDUS
 * FF3D FULLWIDTH RIGHT SQUARE BRACKET
 * 	005D RIGHT SQUARE BRACKET
 * FF3E FULLWIDTH CIRCUMFLEX ACCENT
 * 	005E CIRCUMFLEX ACCENT
 * FF3F FULLWIDTH LOW LINE
 * 	005F LOW LINE
 * FF40 FULLWIDTH GRAVE ACCENT
 * 	0060 GRAVE ACCENT
 * FF41 FULLWIDTH LATIN SMALL LETTER A
 * 	0061 LATIN SMALL LETTER A
 * FF42 FULLWIDTH LATIN SMALL LETTER B
 * 	0062 LATIN SMALL LETTER B
 * FF43 FULLWIDTH LATIN SMALL LETTER C
 * 	0063 LATIN SMALL LETTER C
 * FF44 FULLWIDTH LATIN SMALL LETTER D
 * 	0064 LATIN SMALL LETTER D
 * FF45 FULLWIDTH LATIN SMALL LETTER E
 * 	0065 LATIN SMALL LETTER E
 * FF46 FULLWIDTH LATIN SMALL LETTER F
 * 	0066 LATIN SMALL LETTER F
 * FF47 FULLWIDTH LATIN SMALL LETTER G
 * 	0067 LATIN SMALL LETTER G
 * FF48 FULLWIDTH LATIN SMALL LETTER H
 * 	0068 LATIN SMALL LETTER H
 * FF49 FULLWIDTH LATIN SMALL LETTER I
 * 	0069 LATIN SMALL LETTER I
 * FF4A FULLWIDTH LATIN SMALL LETTER J
 * 	006A LATIN SMALL LETTER J
 * FF4B FULLWIDTH LATIN SMALL LETTER K
 * 	006B LATIN SMALL LETTER K
 * FF4C FULLWIDTH LATIN SMALL LETTER L
 * 	006C LATIN SMALL LETTER L
 * FF4D FULLWIDTH LATIN SMALL LETTER M
 * 	006D LATIN SMALL LETTER M
 * FF4E FULLWIDTH LATIN SMALL LETTER N
 * 	006E LATIN SMALL LETTER N
 * FF4F FULLWIDTH LATIN SMALL LETTER O
 * 	006F LATIN SMALL LETTER O
 * FF50 FULLWIDTH LATIN SMALL LETTER P
 * 	0070 LATIN SMALL LETTER P
 * FF51 FULLWIDTH LATIN SMALL LETTER Q
 * 	0071 LATIN SMALL LETTER Q
 * FF52 FULLWIDTH LATIN SMALL LETTER R
 * 	0072 LATIN SMALL LETTER R
 * FF53 FULLWIDTH LATIN SMALL LETTER S
 * 	0073 LATIN SMALL LETTER S
 * FF54 FULLWIDTH LATIN SMALL LETTER T
 * 	0074 LATIN SMALL LETTER T
 * FF55 FULLWIDTH LATIN SMALL LETTER U
 * 	0075 LATIN SMALL LETTER U
 * FF56 FULLWIDTH LATIN SMALL LETTER V
 * 	0076 LATIN SMALL LETTER V
 * FF57 FULLWIDTH LATIN SMALL LETTER W
 * 	0077 LATIN SMALL LETTER W
 * FF58 FULLWIDTH LATIN SMALL LETTER X
 * 	0078 LATIN SMALL LETTER X
 * FF59 FULLWIDTH LATIN SMALL LETTER Y
 * 	0079 LATIN SMALL LETTER Y
 * FF5A FULLWIDTH LATIN SMALL LETTER Z
 * 	007A LATIN SMALL LETTER Z
 * FF5B FULLWIDTH LEFT CURLY BRACKET
 * 	007B LEFT CURLY BRACKET
 * FF5C FULLWIDTH VERTICAL LINE
 * 	007C VERTICAL LINE
 * FF5D FULLWIDTH RIGHT CURLY BRACKET
 * 	007D RIGHT CURLY BRACKET
 * FF5E FULLWIDTH TILDE
 * 	007E TILDE
 * FF5F FULLWIDTH LEFT WHITE PARENTHESIS
 * 	2985 LEFT WHITE PARENTHESIS
 * FF60 FULLWIDTH RIGHT WHITE PARENTHESIS
 * 	2986 RIGHT WHITE PARENTHESIS
 * FF61 HALFWIDTH IDEOGRAPHIC FULL STOP
 * 	3002 IDEOGRAPHIC FULL STOP
 * FF62 HALFWIDTH LEFT CORNER BRACKET
 * 	300C LEFT CORNER BRACKET
 * FF63 HALFWIDTH RIGHT CORNER BRACKET
 * 	300D RIGHT CORNER BRACKET
 * FF64 HALFWIDTH IDEOGRAPHIC COMMA
 * 	3001 IDEOGRAPHIC COMMA
 * FF65 HALFWIDTH KATAKANA MIDDLE DOT
 * 	30FB KATAKANA MIDDLE DOT
 * FF66 HALFWIDTH KATAKANA LETTER WO
 * 	30F2 KATAKANA LETTER WO
 * FF67 HALFWIDTH KATAKANA LETTER SMALL A
 * 	30A1 KATAKANA LETTER SMALL A
 * FF68 HALFWIDTH KATAKANA LETTER SMALL I
 * 	30A3 KATAKANA LETTER SMALL I
 * FF69 HALFWIDTH KATAKANA LETTER SMALL U
 * 	30A5 KATAKANA LETTER SMALL U
 * FF6A HALFWIDTH KATAKANA LETTER SMALL E
 * 	30A7 KATAKANA LETTER SMALL E
 * FF6B HALFWIDTH KATAKANA LETTER SMALL O
 * 	30A9 KATAKANA LETTER SMALL O
 * FF6C HALFWIDTH KATAKANA LETTER SMALL YA
 * 	30E3 KATAKANA LETTER SMALL YA
 * FF6D HALFWIDTH KATAKANA LETTER SMALL YU
 * 	30E5 KATAKANA LETTER SMALL YU
 * FF6E HALFWIDTH KATAKANA LETTER SMALL YO
 * 	30E7 KATAKANA LETTER SMALL YO
 * FF6F HALFWIDTH KATAKANA LETTER SMALL TU
 * 	30C3 KATAKANA LETTER SMALL TU
 * FF70 HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * 	30FC KATAKANA-HIRAGANA PROLONGED SOUND MARK
 * FF71 HALFWIDTH KATAKANA LETTER A
 * 	30A2 KATAKANA LETTER A
 * FF72 HALFWIDTH KATAKANA LETTER I
 * 	30A4 KATAKANA LETTER I
 * FF73 HALFWIDTH KATAKANA LETTER U
 * 	30A6 KATAKANA LETTER U
 * FF74 HALFWIDTH KATAKANA LETTER E
 * 	30A8 KATAKANA LETTER E
 * FF75 HALFWIDTH KATAKANA LETTER O
 * 	30AA KATAKANA LETTER O
 * FF76 HALFWIDTH KATAKANA LETTER KA
 * 	30AB KATAKANA LETTER KA
 * FF77 HALFWIDTH KATAKANA LETTER KI
 * 	30AD KATAKANA LETTER KI
 * FF78 HALFWIDTH KATAKANA LETTER KU
 * 	30AF KATAKANA LETTER KU
 * FF79 HALFWIDTH KATAKANA LETTER KE
 * 	30B1 KATAKANA LETTER KE
 * FF7A HALFWIDTH KATAKANA LETTER KO
 * 	30B3 KATAKANA LETTER KO
 * FF7B HALFWIDTH KATAKANA LETTER SA
 * 	30B5 KATAKANA LETTER SA
 * FF7C HALFWIDTH KATAKANA LETTER SI
 * 	30B7 KATAKANA LETTER SI
 * FF7D HALFWIDTH KATAKANA LETTER SU
 * 	30B9 KATAKANA LETTER SU
 * FF7E HALFWIDTH KATAKANA LETTER SE
 * 	30BB KATAKANA LETTER SE
 * FF7F HALFWIDTH KATAKANA LETTER SO
 * 	30BD KATAKANA LETTER SO
 * FF80 HALFWIDTH KATAKANA LETTER TA
 * 	30BF KATAKANA LETTER TA
 * FF81 HALFWIDTH KATAKANA LETTER TI
 * 	30C1 KATAKANA LETTER TI
 * FF82 HALFWIDTH KATAKANA LETTER TU
 * 	30C4 KATAKANA LETTER TU
 * FF83 HALFWIDTH KATAKANA LETTER TE
 * 	30C6 KATAKANA LETTER TE
 * FF84 HALFWIDTH KATAKANA LETTER TO
 * 	30C8 KATAKANA LETTER TO
 * FF85 HALFWIDTH KATAKANA LETTER NA
 * 	30CA KATAKANA LETTER NA
 * FF86 HALFWIDTH KATAKANA LETTER NI
 * 	30CB KATAKANA LETTER NI
 * FF87 HALFWIDTH KATAKANA LETTER NU
 * 	30CC KATAKANA LETTER NU
 * FF88 HALFWIDTH KATAKANA LETTER NE
 * 	30CD KATAKANA LETTER NE
 * FF89 HALFWIDTH KATAKANA LETTER NO
 * 	30CE KATAKANA LETTER NO
 * FF8A HALFWIDTH KATAKANA LETTER HA
 * 	30CF KATAKANA LETTER HA
 * FF8B HALFWIDTH KATAKANA LETTER HI
 * 	30D2 KATAKANA LETTER HI
 * FF8C HALFWIDTH KATAKANA LETTER HU
 * 	30D5 KATAKANA LETTER HU
 * FF8D HALFWIDTH KATAKANA LETTER HE
 * 	30D8 KATAKANA LETTER HE
 * FF8E HALFWIDTH KATAKANA LETTER HO
 * 	30DB KATAKANA LETTER HO
 * FF8F HALFWIDTH KATAKANA LETTER MA
 * 	30DE KATAKANA LETTER MA
 * FF90 HALFWIDTH KATAKANA LETTER MI
 * 	30DF KATAKANA LETTER MI
 * FF91 HALFWIDTH KATAKANA LETTER MU
 * 	30E0 KATAKANA LETTER MU
 * FF92 HALFWIDTH KATAKANA LETTER ME
 * 	30E1 KATAKANA LETTER ME
 * FF93 HALFWIDTH KATAKANA LETTER MO
 * 	30E2 KATAKANA LETTER MO
 * FF94 HALFWIDTH KATAKANA LETTER YA
 * 	30E4 KATAKANA LETTER YA
 * FF95 HALFWIDTH KATAKANA LETTER YU
 * 	30E6 KATAKANA LETTER YU
 * FF96 HALFWIDTH KATAKANA LETTER YO
 * 	30E8 KATAKANA LETTER YO
 * FF97 HALFWIDTH KATAKANA LETTER RA
 * 	30E9 KATAKANA LETTER RA
 * FF98 HALFWIDTH KATAKANA LETTER RI
 * 	30EA KATAKANA LETTER RI
 * FF99 HALFWIDTH KATAKANA LETTER RU
 * 	30EB KATAKANA LETTER RU
 * FF9A HALFWIDTH KATAKANA LETTER RE
 * 	30EC KATAKANA LETTER RE
 * FF9B HALFWIDTH KATAKANA LETTER RO
 * 	30ED KATAKANA LETTER RO
 * FF9C HALFWIDTH KATAKANA LETTER WA
 * 	30EF KATAKANA LETTER WA
 * FF9D HALFWIDTH KATAKANA LETTER N
 * 	30F3 KATAKANA LETTER N
 * FFA0 HALFWIDTH HANGUL FILLER
 * 	1160 HANGUL JUNGSEONG FILLER
 * FFA1 HALFWIDTH HANGUL LETTER KIYEOK
 * 	1100 HANGUL CHOSEONG KIYEOK
 * FFA2 HALFWIDTH HANGUL LETTER SSANGKIYEOK
 * 	1101 HANGUL CHOSEONG SSANGKIYEOK
 * FFA3 HALFWIDTH HANGUL LETTER KIYEOK-SIOS
 * 	11AA HANGUL JONGSEONG KIYEOK-SIOS
 * FFA4 HALFWIDTH HANGUL LETTER NIEUN
 * 	1102 HANGUL CHOSEONG NIEUN
 * FFA5 HALFWIDTH HANGUL LETTER NIEUN-CIEUC
 * 	11AC HANGUL JONGSEONG NIEUN-CIEUC
 * FFA6 HALFWIDTH HANGUL LETTER NIEUN-HIEUH
 * 	11AD HANGUL JONGSEONG NIEUN-HIEUH
 * FFA7 HALFWIDTH HANGUL LETTER TIKEUT
 * 	1103 HANGUL CHOSEONG TIKEUT
 * FFA8 HALFWIDTH HANGUL LETTER SSANGTIKEUT
 * 	1104 HANGUL CHOSEONG SSANGTIKEUT
 * FFA9 HALFWIDTH HANGUL LETTER RIEUL
 * 	1105 HANGUL CHOSEONG RIEUL
 * FFAA HALFWIDTH HANGUL LETTER RIEUL-KIYEOK
 * 	11B0 HANGUL JONGSEONG RIEUL-KIYEOK
 * FFAB HALFWIDTH HANGUL LETTER RIEUL-MIEUM
 * 	11B1 HANGUL JONGSEONG RIEUL-MIEUM
 * FFAC HALFWIDTH HANGUL LETTER RIEUL-PIEUP
 * 	11B2 HANGUL JONGSEONG RIEUL-PIEUP
 * FFAD HALFWIDTH HANGUL LETTER RIEUL-SIOS
 * 	11B3 HANGUL JONGSEONG RIEUL-SIOS
 * FFAE HALFWIDTH HANGUL LETTER RIEUL-THIEUTH
 * 	11B4 HANGUL JONGSEONG RIEUL-THIEUTH
 * FFAF HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH
 * 	11B5 HANGUL JONGSEONG RIEUL-PHIEUPH
 * FFB0 HALFWIDTH HANGUL LETTER RIEUL-HIEUH
 * 	111A HANGUL CHOSEONG RIEUL-HIEUH
 * FFB1 HALFWIDTH HANGUL LETTER MIEUM
 * 	1106 HANGUL CHOSEONG MIEUM
 * FFB2 HALFWIDTH HANGUL LETTER PIEUP
 * 	1107 HANGUL CHOSEONG PIEUP
 * FFB3 HALFWIDTH HANGUL LETTER SSANGPIEUP
 * 	1108 HANGUL CHOSEONG SSANGPIEUP
 * FFB4 HALFWIDTH HANGUL LETTER PIEUP-SIOS
 * 	1121 HANGUL CHOSEONG PIEUP-SIOS
 * FFB5 HALFWIDTH HANGUL LETTER SIOS
 * 	1109 HANGUL CHOSEONG SIOS
 * FFB6 HALFWIDTH HANGUL LETTER SSANGSIOS
 * 	110A HANGUL CHOSEONG SSANGSIOS
 * FFB7 HALFWIDTH HANGUL LETTER IEUNG
 * 	110B HANGUL CHOSEONG IEUNG
 * FFB8 HALFWIDTH HANGUL LETTER CIEUC
 * 	110C HANGUL CHOSEONG CIEUC
 * FFB9 HALFWIDTH HANGUL LETTER SSANGCIEUC
 * 	110D HANGUL CHOSEONG SSANGCIEUC
 * FFBA HALFWIDTH HANGUL LETTER CHIEUCH
 * 	110E HANGUL CHOSEONG CHIEUCH
 * FFBB HALFWIDTH HANGUL LETTER KHIEUKH
 * 	110F HANGUL CHOSEONG KHIEUKH
 * FFBC HALFWIDTH HANGUL LETTER THIEUTH
 * 	1110 HANGUL CHOSEONG THIEUTH
 * FFBD HALFWIDTH HANGUL LETTER PHIEUPH
 * 	1111 HANGUL CHOSEONG PHIEUPH
 * FFBE HALFWIDTH HANGUL LETTER HIEUH
 * 	1112 HANGUL CHOSEONG HIEUH
 * FFC2 HALFWIDTH HANGUL LETTER A
 * 	1161 HANGUL JUNGSEONG A
 * FFC3 HALFWIDTH HANGUL LETTER AE
 * 	1162 HANGUL JUNGSEONG AE
 * FFC4 HALFWIDTH HANGUL LETTER YA
 * 	1163 HANGUL JUNGSEONG YA
 * FFC5 HALFWIDTH HANGUL LETTER YAE
 * 	1164 HANGUL JUNGSEONG YAE
 * FFC6 HALFWIDTH HANGUL LETTER EO
 * 	1165 HANGUL JUNGSEONG EO
 * FFC7 HALFWIDTH HANGUL LETTER E
 * 	1166 HANGUL JUNGSEONG E
 * FFCA HALFWIDTH HANGUL LETTER YEO
 * 	1167 HANGUL JUNGSEONG YEO
 * FFCB HALFWIDTH HANGUL LETTER YE
 * 	1168 HANGUL JUNGSEONG YE
 * FFCC HALFWIDTH HANGUL LETTER O
 * 	1169 HANGUL JUNGSEONG O
 * FFCD HALFWIDTH HANGUL LETTER WA
 * 	116A HANGUL JUNGSEONG WA
 * FFCE HALFWIDTH HANGUL LETTER WAE
 * 	116B HANGUL JUNGSEONG WAE
 * FFCF HALFWIDTH HANGUL LETTER OE
 * 	116C HANGUL JUNGSEONG OE
 * FFD2 HALFWIDTH HANGUL LETTER YO
 * 	116D HANGUL JUNGSEONG YO
 * FFD3 HALFWIDTH HANGUL LETTER U
 * 	116E HANGUL JUNGSEONG U
 * FFD4 HALFWIDTH HANGUL LETTER WEO
 * 	116F HANGUL JUNGSEONG WEO
 * FFD5 HALFWIDTH HANGUL LETTER WE
 * 	1170 HANGUL JUNGSEONG WE
 * FFD6 HALFWIDTH HANGUL LETTER WI
 * 	1171 HANGUL JUNGSEONG WI
 * FFD7 HALFWIDTH HANGUL LETTER YU
 * 	1172 HANGUL JUNGSEONG YU
 * FFDA HALFWIDTH HANGUL LETTER EU
 * 	1173 HANGUL JUNGSEONG EU
 * FFDB HALFWIDTH HANGUL LETTER YI
 * 	1174 HANGUL JUNGSEONG YI
 * FFDC HALFWIDTH HANGUL LETTER I
 * 	1175 HANGUL JUNGSEONG I
 * FFE0 FULLWIDTH CENT SIGN
 * 	00A2 CENT SIGN
 * FFE1 FULLWIDTH POUND SIGN
 * 	00A3 POUND SIGN
 * FFE2 FULLWIDTH NOT SIGN
 * 	00AC NOT SIGN
 * FFE3 FULLWIDTH MACRON
 * 	0020 SPACE
 * FFE4 FULLWIDTH BROKEN BAR
 * 	00A6 BROKEN BAR
 * FFE5 FULLWIDTH YEN SIGN
 * 	00A5 YEN SIGN
 * FFE6 FULLWIDTH WON SIGN
 * 	20A9 WON SIGN
 * FFE8 HALFWIDTH FORMS LIGHT VERTICAL
 * 	2502 BOX DRAWINGS LIGHT VERTICAL
 * FFE9 HALFWIDTH LEFTWARDS ARROW
 * 	2190 LEFTWARDS ARROW
 * FFEA HALFWIDTH UPWARDS ARROW
 * 	2191 UPWARDS ARROW
 * FFEB HALFWIDTH RIGHTWARDS ARROW
 * 	2192 RIGHTWARDS ARROW
 * FFEC HALFWIDTH DOWNWARDS ARROW
 * 	2193 DOWNWARDS ARROW
 * FFED HALFWIDTH BLACK SQUARE
 * 	25A0 BLACK SQUARE
 * FFEE HALFWIDTH WHITE CIRCLE
 * 	25CB WHITE CIRCLE
*/

unsigned short unac_indexes[UNAC_INDEXES_SIZE] = {
   0,   0,   0,   0,   1,   2,   0,   0,   0,   0,   3,   4,   5,   6,   7,
   8,   9,  10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  20,  21,  22,
  23,  24,  25,  26,  27,  28,   0,   0,   0,   0,   0,   0,   0,  29,   0,
  30,  31,   0,   0,   0,   0,   0,  32,   0,   0,  33,  34,  35,  36,  37,
  38,  39,  40,  41,  42,  43,  44,  45,   0,  46,  47,  48,  49,  50,  51,
  52,  53,  54,  55,  56,  57,   0,   0,  58,  59,  60,   0,   0,  61,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  62,   0,   0,   0,   0,  63,   0,
   0,   0,   0,  64,  65,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  66,  67,   0,  68,
   0,   0,   0,   0,   0,   0,   0,  69,   0,   0,   0,   0,   0,  70,   0,
  71,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  72,   0,   0,   0,  73,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  74,   0,   0,   0,   0,   0,   0,   0,  75,   0,  76,   0,   0,
  77,   0,   0,   0,  78,  79,  80,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  81,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,  96,
  97,  98,  99, 100, 101, 102, 103, 104, 105,  98, 100, 104, 106, 107, 108,
 109, 110, 111, 112, 113, 114, 115, 116,   0, 117, 118,   0, 119,   0,   0,
   0,   0,   0, 120, 121, 122, 123, 124, 125, 126, 127,   0, 128, 129,   0,
 130,   0,   0,   0, 131,   0, 132, 133, 134,   0, 135, 136, 137,   0, 138,
   0,   0,   0, 139,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 141, 142, 143,
 144, 145, 146, 147, 148, 149,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,
   0,   0,   0,   0, 151,   0,   0,   0,   0,   0, 152,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 153,   0,   0,   0,   0,
   0, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167,
 168,   0,   0, 169,   0,   0, 170, 171, 172, 173, 174,   0, 175, 176, 177,
 178, 179,   0, 180,   0,   0,   0, 181, 182, 183, 184, 185, 186, 187,   0,
   0,   0,   0,   0,   0, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197,
 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
 213, 214, 215, 216, 217, 218, 219,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 220, 221, 222, 223, 224, 225,
 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240,
 241, 242,   0,   0,   0,   0,   0,   0,   0,   0,   0, 243, 244, 245, 246,
 247, 248, 249, 250, 251, 252, 253, 254,   0, 255, 256, 257, 258, 259, 260,
 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275,
 276, 277,   0, 278, 279, 280, 281, 282, 283, 284, 285,   0,   0, 286,   0,
   0,   0, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
   0
};

unsigned char unac_positions[UNAC_BLOCK_COUNT][2*UNAC_BLOCK_SIZE + 1] = {
/* 0 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 1 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 2 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 3 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 4 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 27, 30, 33, 36, 39, 42, 43, 44 },
/* 5 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 },
/* 6 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33 },
/* 7 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 },
/* 8 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 9 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 10 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 11 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 12 */ { 0, 1, 2, 3, 4, 6, 8, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 38 },
/* 13 */ { 0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36 },
/* 14 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 15 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 16 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 17 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 18 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 19 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 20 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 21 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 45, 46, 47, 48, 49, 50 },
/* 22 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 23 */ { 0, 1, 2, 3, 4, 6, 8, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36 },
/* 24 */ { 0, 1, 2, 4, 6, 8, 10, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 34, 36, 38, 39, 40, 41, 42 },
/* 25 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 26 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 27 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 28 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 29 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 30 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 31 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 32 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 33 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 34 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 35 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 36 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 37 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 38 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 39 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 40 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 41 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 42 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 43 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 44 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 45 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 46 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 47 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 48 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 49 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 50 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 51 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 52 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 53 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 54 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 55 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 56 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 57 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 58 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 59 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 60 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 61 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 },
/* 62 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 63 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 16, 18, 20, 22, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40 },
/* 64 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 65 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 66 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 67 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 68 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 69 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 70 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 71 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 72 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 73 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 74 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 75 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 76 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 28, 30, 32, 33, 34, 35, 36 },
/* 77 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 78 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 79 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 80 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 81 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 82 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 83 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 84 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 85 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 86 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 87 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 88 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 89 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 90 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 91 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 },
/* 92 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 93 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 94 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 95 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 96 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 97 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 98 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 99 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 100 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 101 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 102 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 103 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 104 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 105 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 106 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 107 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 108 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 109 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 110 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 111 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 112 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 113 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 17, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38 },
/* 114 */ { 0, 1, 2, 3, 4, 5, 6, 8, 10, 13, 16, 17, 18, 20, 22, 25, 28, 29, 30, 31, 32, 33, 34, 35, 36, 38, 40, 41, 42, 43, 44, 45, 46 },
/* 115 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38 },
/* 116 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 18, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38 },
/* 117 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 118 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 119 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 },
/* 120 */ { 0, 3, 6, 9, 12, 13, 14, 16, 18, 19, 20, 23, 26, 29, 32, 33, 34, 35, 36, 38, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52 },
/* 121 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 },
/* 122 */ { 0, 2, 4, 7, 10, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40 },
/* 123 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 124 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 125 */ { 0, 1, 2, 3, 4, 5, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 80, 82 },
/* 126 */ { 0, 1, 2, 4, 6, 9, 12, 14, 16, 17, 18, 20, 22, 25, 28, 32, 36, 38, 40, 41, 42, 44, 46, 49, 52, 53, 54, 55, 56, 57, 58, 59, 60 },
/* 127 */ { 0, 1, 2, 4, 6, 9, 12, 14, 16, 17, 18, 20, 22, 25, 28, 32, 36, 38, 40, 41, 42, 44, 46, 49, 52, 53, 54, 55, 56, 57, 58, 59, 60 },
/* 128 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 129 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 130 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 131 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 132 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 28, 31, 34, 35, 36, 38, 40 },
/* 133 */ { 0, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36 },
/* 134 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 135 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 136 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 137 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 138 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 139 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 140 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 141 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46 },
/* 142 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 61, 64, 67, 70, 74, 78, 82, 86, 90, 94 },
/* 143 */ { 0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 66, 68, 70, 72, 74, 76, 78, 80, 82, 84, 86, 88, 90, 92, 94, 96 },
/* 144 */ { 0, 2, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 61, 64, 67, 70, 73, 76, 79, 82, 85, 88, 91, 94 },
/* 145 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 146 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56 },
/* 147 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 148 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 149 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 150 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 28, 32, 33, 34, 35, 36, 37, 38 },
/* 151 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 11, 14, 16, 18, 21, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 },
/* 152 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 153 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 154 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 155 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 156 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 157 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 158 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 159 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 160 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 161 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 162 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 163 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 164 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 165 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 166 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 167 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 168 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 169 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 170 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 171 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 172 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 173 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 174 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 175 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 34 },
/* 176 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 177 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 178 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 179 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 180 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 34 },
/* 181 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 182 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 183 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 184 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 185 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 186 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 187 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 188 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 88, 92, 96, 100 },
/* 189 */ { 0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92, 96, 100, 104, 105, 106, 107, 108, 109, 110 },
/* 190 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 191 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 192 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48 },
/* 193 */ { 0, 1, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62 },
/* 194 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 32, 34, 36 },
/* 195 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56 },
/* 196 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 197 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 198 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 199 */ { 0, 1, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62 },
/* 200 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 39, 42, 45, 48, 51, 54, 55, 56, 57, 58, 59, 60, 61, 62 },
/* 201 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 202 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 203 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 204 */ { 0, 4, 8, 12, 16, 20, 24, 27, 30, 34, 38, 41, 44, 47, 50, 55, 60, 64, 68, 71, 74, 77, 80, 83, 86, 90, 94, 98, 102, 105, 108, 111, 114 },
/* 205 */ { 0, 2, 4, 7, 10, 14, 18, 22, 26, 28, 30, 35, 40, 46, 52, 57, 62, 65, 68, 73, 78, 83, 88, 92, 96, 99, 102, 105, 108, 111, 114, 118, 122 },
/* 206 */ { 0, 5, 10, 14, 18, 21, 24, 27, 30, 33, 36, 38, 40, 42, 44, 46, 48, 50, 52, 55, 58, 61, 64, 69, 74, 77, 80, 84, 88, 93, 98, 101, 104 },
/* 207 */ { 0, 2, 4, 6, 8, 13, 18, 22, 26, 31, 36, 39, 42, 47, 52, 54, 56, 59, 62, 65, 68, 71, 74, 77, 80, 83, 86, 90, 94, 97, 100, 102, 104 },
/* 208 */ { 0, 3, 6, 9, 12, 15, 18, 22, 26, 29, 32, 35, 38, 41, 44, 49, 54, 58, 62, 64, 66, 71, 76, 78, 80, 84, 88, 92, 96, 99, 102, 105, 108 },
/* 209 */ { 0, 3, 6, 10, 14, 16, 18, 21, 24, 28, 32, 34, 36, 41, 46, 49, 52, 54, 56, 58, 60, 62, 64, 66, 68, 70, 72, 74, 76, 78, 80, 82, 84 },
/* 210 */ { 0, 2, 4, 6, 8, 11, 14, 17, 20, 23, 26, 29, 32, 35, 38, 41, 44, 47, 50, 53, 56, 59, 62, 65, 68, 71, 74, 77, 80, 83, 86, 89, 92 },
/* 211 */ { 0, 3, 6, 9, 12, 14, 16, 18, 20, 23, 26, 28, 30, 32, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 46, 48, 50, 52, 54, 56, 58, 62, 66 },
/* 212 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 35, 38, 42, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64, 66, 68, 70 },
/* 213 */ { 0, 2, 4, 7, 10, 13, 16, 19, 22, 25, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64, 66, 68, 71, 74 },
/* 214 */ { 0, 3, 6, 8, 10, 13, 16, 19, 22, 25, 28, 30, 32, 35, 38, 41, 44, 48, 52, 54, 56, 59, 62, 65, 68, 71, 74, 77, 80, 85, 90, 96, 102 },
/* 215 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 216 */ { 0, 2, 4, 6, 8, 12, 16, 18, 20, 22, 24, 26, 28, 32, 36, 39, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64, 66, 68, 70, 72, 74 },
/* 217 */ { 0, 2, 4, 6, 8, 11, 14, 16, 18, 20, 22, 25, 28, 31, 34, 36, 38, 42, 46, 49, 52, 54, 56, 58, 60, 62, 64, 66, 68, 69, 70, 71, 72 },
/* 218 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78 },
/* 219 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 91, 92 },
/* 220 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 221 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 222 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 223 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 224 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 225 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 226 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 227 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 228 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 229 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 230 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 231 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 232 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 233 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 234 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 235 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 236 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 237 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 238 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 239 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 240 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 241 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 242 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 243 */ { 0, 2, 4, 6, 8, 10, 12, 15, 18, 21, 24, 26, 28, 30, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50 },
/* 244 */ { 0, 1, 2, 3, 4, 5, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 },
/* 245 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 246 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 247 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 34 },
/* 248 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 249 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 250 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 251 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 252 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 253 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 254 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 255 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 30, 31, 32, 33, 34 },
/* 256 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44 },
/* 257 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56 },
/* 258 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 259 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 260 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 261 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 262 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 263 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54 },
/* 264 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56 },
/* 265 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 266 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 267 */ { 0, 1, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62 },
/* 268 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 269 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 270 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 271 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 37, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62 },
/* 272 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 273 */ { 0, 2, 4, 6, 8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58 },
/* 274 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 275 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 276 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64 },
/* 277 */ { 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56 },
/* 278 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 279 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 280 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 281 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 282 */ { 0, 1, 2, 3, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 61, 64, 67, 70, 73, 76, 79, 82, 85, 88 },
/* 283 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 284 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93, 96 },
/* 285 */ { 0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64 },
/* 286 */ { 0, 3, 6, 9, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 71, 74, 92, 110, 118, 126, 130, 134, 135, 136, 137, 138, 139, 140 },
/* 287 */ { 0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 },
/* 288 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 289 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 290 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 291 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 292 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 293 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 294 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 295 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 296 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 297 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 298 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 299 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 43, 44, 45, 46, 47, 48 },
/* 300 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 301 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 302 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 303 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 304 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 305 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 306 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 307 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 308 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 309 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 310 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 311 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 312 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 313 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 },
/* 314 */ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32 }
};

unsigned short unac_data0[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data1[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0x0061, 0xFFFF, 0x0062, 0xFFFF, 0x0063, 0xFFFF, 0x0064, 0xFFFF, 0x0065, 0xFFFF, 0x0066, 0xFFFF, 0x0067, 0xFFFF, 0x0068, 0xFFFF, 0x0069, 0xFFFF, 0x006A, 0xFFFF, 0x006B, 0xFFFF, 0x006C, 0xFFFF, 0x006D, 0xFFFF, 0x006E, 0xFFFF, 0x006F };
unsigned short unac_data2[] = { 0xFFFF, 0x0070, 0xFFFF, 0x0071, 0xFFFF, 0x0072, 0xFFFF, 0x0073, 0xFFFF, 0x0074, 0xFFFF, 0x0075, 0xFFFF, 0x0076, 0xFFFF, 0x0077, 0xFFFF, 0x0078, 0xFFFF, 0x0079, 0xFFFF, 0x007A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data3[] = { 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0x0061, 0x0061, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020 };
unsigned short unac_data4[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0032, 0x0032, 0x0033, 0x0033, 0x0020, 0x0020, 0x03BC, 0x03BC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0031, 0x0031, 0x006F, 0x006F, 0xFFFF, 0xFFFF, 0x0031, 0x2044, 0x0034, 0x0031, 0x2044, 0x0034, 0x0031, 0x2044, 0x0032, 0x0031, 0x2044, 0x0032, 0x0033, 0x2044, 0x0034, 0x0033, 0x2044, 0x0034, 0xFFFF, 0xFFFF };
unsigned short unac_data5[] = { 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0061, 0x0041, 0x0045, 0x0061, 0x0065, 0x0043, 0x0063, 0x0045, 0x0065, 0x0045, 0x0065, 0x0045, 0x0065, 0x0045, 0x0065, 0x0049, 0x0069, 0x0049, 0x0069, 0x0049, 0x0069, 0x0049, 0x0069 };
unsigned short unac_data6[] = { 0xFFFF, 0x00F0, 0x004E, 0x006E, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0x004F, 0x006F, 0xFFFF, 0xFFFF, 0x004F, 0x006F, 0x0055, 0x0075, 0x0055, 0x0075, 0x0055, 0x0075, 0x0055, 0x0075, 0x0059, 0x0079, 0xFFFF, 0x00FE, 0xFFFF, 0x0073, 0x0073 };
unsigned short unac_data7[] = { 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0065, 0x0061, 0x0065, 0x0063, 0x0063, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069 };
unsigned short unac_data8[] = { 0xFFFF, 0xFFFF, 0x006E, 0x006E, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0xFFFF, 0xFFFF, 0x006F, 0x006F, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0079, 0x0079, 0xFFFF, 0xFFFF, 0x0079, 0x0079 };
unsigned short unac_data9[] = { 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0063, 0x0063, 0x0063, 0x0043, 0x0063, 0x0063, 0x0063, 0x0044, 0x0064, 0x0064, 0x0064 };
unsigned short unac_data10[] = { 0xFFFF, 0x0111, 0xFFFF, 0xFFFF, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0047, 0x0067, 0x0067, 0x0067, 0x0047, 0x0067, 0x0067, 0x0067 };
unsigned short unac_data11[] = { 0x0047, 0x0067, 0x0067, 0x0067, 0x0047, 0x0067, 0x0067, 0x0067, 0x0048, 0x0068, 0x0068, 0x0068, 0xFFFF, 0x0127, 0xFFFF, 0xFFFF, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0069, 0x0069, 0x0069 };
unsigned short unac_data12[] = { 0x0049, 0x0069, 0xFFFF, 0xFFFF, 0x0049, 0x004A, 0x0069, 0x006A, 0x0069, 0x006A, 0x0069, 0x006A, 0x004A, 0x006A, 0x006A, 0x006A, 0x004B, 0x006B, 0x006B, 0x006B, 0xFFFF, 0xFFFF, 0x004C, 0x006C, 0x006C, 0x006C, 0x004C, 0x006C, 0x006C, 0x006C, 0x004C, 0x006C, 0x006C, 0x006C, 0x004C, 0x00B7, 0x006C, 0x00B7 };
unsigned short unac_data13[] = { 0x006C, 0x00B7, 0x006C, 0x00B7, 0xFFFF, 0x0142, 0xFFFF, 0xFFFF, 0x004E, 0x006E, 0x006E, 0x006E, 0x004E, 0x006E, 0x006E, 0x006E, 0x004E, 0x006E, 0x006E, 0x006E, 0x02BC, 0x006E, 0x02BC, 0x006E, 0xFFFF, 0x014B, 0xFFFF, 0xFFFF, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data14[] = { 0x004F, 0x006F, 0x006F, 0x006F, 0xFFFF, 0x0153, 0xFFFF, 0xFFFF, 0x0052, 0x0072, 0x0072, 0x0072, 0x0052, 0x0072, 0x0072, 0x0072, 0x0052, 0x0072, 0x0072, 0x0072, 0x0053, 0x0073, 0x0073, 0x0073, 0x0053, 0x0073, 0x0073, 0x0073, 0x0053, 0x0073, 0x0073, 0x0073 };
unsigned short unac_data15[] = { 0x0053, 0x0073, 0x0073, 0x0073, 0x0054, 0x0074, 0x0074, 0x0074, 0x0054, 0x0074, 0x0074, 0x0074, 0xFFFF, 0x0167, 0xFFFF, 0xFFFF, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075 };
unsigned short unac_data16[] = { 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0057, 0x0077, 0x0077, 0x0077, 0x0059, 0x0079, 0x0079, 0x0079, 0x0059, 0x0079, 0x005A, 0x007A, 0x007A, 0x007A, 0x005A, 0x007A, 0x007A, 0x007A, 0x005A, 0x007A, 0x007A, 0x007A, 0x0073, 0x0073 };
unsigned short unac_data17[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0x0253, 0xFFFF, 0x0183, 0xFFFF, 0xFFFF, 0xFFFF, 0x0185, 0xFFFF, 0xFFFF, 0xFFFF, 0x0254, 0xFFFF, 0x0188, 0xFFFF, 0xFFFF, 0xFFFF, 0x0256, 0xFFFF, 0x0257, 0xFFFF, 0x018C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01DD, 0xFFFF, 0x0259 };
unsigned short unac_data18[] = { 0xFFFF, 0x025B, 0xFFFF, 0x0192, 0xFFFF, 0xFFFF, 0xFFFF, 0x0260, 0xFFFF, 0x0263, 0xFFFF, 0xFFFF, 0xFFFF, 0x0269, 0xFFFF, 0x0268, 0xFFFF, 0x0199, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x026F, 0xFFFF, 0x0272, 0xFFFF, 0xFFFF, 0xFFFF, 0x0275 };
unsigned short unac_data19[] = { 0x004F, 0x006F, 0x006F, 0x006F, 0xFFFF, 0x01A3, 0xFFFF, 0xFFFF, 0xFFFF, 0x01A5, 0xFFFF, 0xFFFF, 0xFFFF, 0x0280, 0xFFFF, 0x01A8, 0xFFFF, 0xFFFF, 0xFFFF, 0x0283, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01AD, 0xFFFF, 0xFFFF, 0xFFFF, 0x0288, 0x0055, 0x0075 };
unsigned short unac_data20[] = { 0x0075, 0x0075, 0xFFFF, 0x028A, 0xFFFF, 0x028B, 0xFFFF, 0x01B4, 0xFFFF, 0xFFFF, 0xFFFF, 0x01B6, 0xFFFF, 0xFFFF, 0xFFFF, 0x0292, 0xFFFF, 0x01B9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x01BD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data21[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0044, 0x005A, 0x0064, 0x007A, 0x0044, 0x007A, 0x0064, 0x007A, 0x0064, 0x007A, 0x0064, 0x007A, 0x004C, 0x004A, 0x006C, 0x006A, 0x004C, 0x006A, 0x006C, 0x006A, 0x006C, 0x006A, 0x006C, 0x006A, 0x004E, 0x004A, 0x006E, 0x006A, 0x004E, 0x006A, 0x006E, 0x006A, 0x006E, 0x006A, 0x006E, 0x006A, 0x0041, 0x0061, 0x0061, 0x0061, 0x0049, 0x0069 };
unsigned short unac_data22[] = { 0x0069, 0x0069, 0x004F, 0x006F, 0x006F, 0x006F, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0xFFFF, 0xFFFF, 0x0041, 0x0061, 0x0061, 0x0061 };
unsigned short unac_data23[] = { 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0045, 0x0061, 0x0065, 0x0061, 0x0065, 0x0061, 0x0065, 0xFFFF, 0x01E5, 0xFFFF, 0xFFFF, 0x0047, 0x0067, 0x0067, 0x0067, 0x004B, 0x006B, 0x006B, 0x006B, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x01B7, 0x0292, 0x0292, 0x0292 };
unsigned short unac_data24[] = { 0x006A, 0x006A, 0x0044, 0x005A, 0x0064, 0x007A, 0x0044, 0x007A, 0x0064, 0x007A, 0x0064, 0x007A, 0x0064, 0x007A, 0x0047, 0x0067, 0x0067, 0x0067, 0xFFFF, 0x0195, 0xFFFF, 0x01BF, 0x004E, 0x006E, 0x006E, 0x006E, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0045, 0x0061, 0x0065, 0x0061, 0x0065, 0x0061, 0x0065, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data25[] = { 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0069, 0x0069, 0x0069, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data26[] = { 0x0052, 0x0072, 0x0072, 0x0072, 0x0052, 0x0072, 0x0072, 0x0072, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0053, 0x0073, 0x0073, 0x0073, 0x0054, 0x0074, 0x0074, 0x0074, 0xFFFF, 0x021D, 0xFFFF, 0xFFFF, 0x0048, 0x0068, 0x0068, 0x0068 };
unsigned short unac_data27[] = { 0xFFFF, 0x019E, 0xFFFF, 0xFFFF, 0xFFFF, 0x0223, 0xFFFF, 0xFFFF, 0xFFFF, 0x0225, 0xFFFF, 0xFFFF, 0x0041, 0x0061, 0x0061, 0x0061, 0x0045, 0x0065, 0x0065, 0x0065, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data28[] = { 0x004F, 0x006F, 0x006F, 0x006F, 0x0059, 0x0079, 0x0079, 0x0079, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data29[] = { 0x0068, 0x0068, 0x0266, 0x0266, 0x006A, 0x006A, 0x0072, 0x0072, 0x0279, 0x0279, 0x027B, 0x027B, 0x0281, 0x0281, 0x0077, 0x0077, 0x0079, 0x0079, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data30[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data31[] = { 0x0263, 0x0263, 0x006C, 0x006C, 0x0073, 0x0073, 0x0078, 0x0078, 0x0295, 0x0295, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data32[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03B9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data33[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x02B9, 0x02B9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x003B, 0x003B, 0xFFFF, 0xFFFF };
unsigned short unac_data34[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0020, 0x0020, 0x0391, 0x03B1, 0x00B7, 0x00B7, 0x0395, 0x03B5, 0x0397, 0x03B7, 0x0399, 0x03B9, 0xFFFF, 0xFFFF, 0x039F, 0x03BF, 0xFFFF, 0xFFFF, 0x03A5, 0x03C5, 0x03A9, 0x03C9 };
unsigned short unac_data35[] = { 0x03B9, 0x03B9, 0xFFFF, 0x03B1, 0xFFFF, 0x03B2, 0xFFFF, 0x03B3, 0xFFFF, 0x03B4, 0xFFFF, 0x03B5, 0xFFFF, 0x03B6, 0xFFFF, 0x03B7, 0xFFFF, 0x03B8, 0xFFFF, 0x03B9, 0xFFFF, 0x03BA, 0xFFFF, 0x03BB, 0xFFFF, 0x03BC, 0xFFFF, 0x03BD, 0xFFFF, 0x03BE, 0xFFFF, 0x03BF };
unsigned short unac_data36[] = { 0xFFFF, 0x03C0, 0xFFFF, 0x03C1, 0xFFFF, 0xFFFF, 0xFFFF, 0x03C3, 0xFFFF, 0x03C4, 0xFFFF, 0x03C5, 0xFFFF, 0x03C6, 0xFFFF, 0x03C7, 0xFFFF, 0x03C8, 0xFFFF, 0x03C9, 0x0399, 0x03B9, 0x03A5, 0x03C5, 0x03B1, 0x03B1, 0x03B5, 0x03B5, 0x03B7, 0x03B7, 0x03B9, 0x03B9 };
unsigned short unac_data37[] = { 0x03C5, 0x03C5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data38[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03C3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03B9, 0x03B9, 0x03C5, 0x03C5, 0x03BF, 0x03BF, 0x03C5, 0x03C5, 0x03C9, 0x03C9, 0xFFFF, 0xFFFF };
unsigned short unac_data39[] = { 0x03B2, 0x03B2, 0x03B8, 0x03B8, 0x03A5, 0x03C5, 0x03A5, 0x03C5, 0x03A5, 0x03C5, 0x03C6, 0x03C6, 0x03C0, 0x03C0, 0xFFFF, 0xFFFF, 0xFFFF, 0x03D9, 0xFFFF, 0xFFFF, 0xFFFF, 0x03DB, 0xFFFF, 0xFFFF, 0xFFFF, 0x03DD, 0xFFFF, 0xFFFF, 0xFFFF, 0x03DF, 0xFFFF, 0xFFFF };
unsigned short unac_data40[] = { 0xFFFF, 0x03E1, 0xFFFF, 0xFFFF, 0xFFFF, 0x03E3, 0xFFFF, 0xFFFF, 0xFFFF, 0x03E5, 0xFFFF, 0xFFFF, 0xFFFF, 0x03E7, 0xFFFF, 0xFFFF, 0xFFFF, 0x03E9, 0xFFFF, 0xFFFF, 0xFFFF, 0x03EB, 0xFFFF, 0xFFFF, 0xFFFF, 0x03ED, 0xFFFF, 0xFFFF, 0xFFFF, 0x03EF, 0xFFFF, 0xFFFF };
unsigned short unac_data41[] = { 0x03BA, 0x03BA, 0x03C1, 0x03C1, 0x03C2, 0x03C3, 0xFFFF, 0xFFFF, 0x0398, 0x03B8, 0x03B5, 0x03B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data42[] = { 0x0415, 0x0435, 0x0415, 0x0435, 0xFFFF, 0x0452, 0x0413, 0x0433, 0xFFFF, 0x0454, 0xFFFF, 0x0455, 0xFFFF, 0x0456, 0x0406, 0x0456, 0xFFFF, 0x0458, 0xFFFF, 0x0459, 0xFFFF, 0x045A, 0xFFFF, 0x045B, 0x041A, 0x043A, 0x0418, 0x0438, 0x0423, 0x0443, 0xFFFF, 0x045F };
unsigned short unac_data43[] = { 0xFFFF, 0x0430, 0xFFFF, 0x0431, 0xFFFF, 0x0432, 0xFFFF, 0x0433, 0xFFFF, 0x0434, 0xFFFF, 0x0435, 0xFFFF, 0x0436, 0xFFFF, 0x0437, 0xFFFF, 0x0438, 0x0418, 0x0438, 0xFFFF, 0x043A, 0xFFFF, 0x043B, 0xFFFF, 0x043C, 0xFFFF, 0x043D, 0xFFFF, 0x043E, 0xFFFF, 0x043F };
unsigned short unac_data44[] = { 0xFFFF, 0x0440, 0xFFFF, 0x0441, 0xFFFF, 0x0442, 0xFFFF, 0x0443, 0xFFFF, 0x0444, 0xFFFF, 0x0445, 0xFFFF, 0x0446, 0xFFFF, 0x0447, 0xFFFF, 0x0448, 0xFFFF, 0x0449, 0xFFFF, 0x044A, 0xFFFF, 0x044B, 0xFFFF, 0x044C, 0xFFFF, 0x044D, 0xFFFF, 0x044E, 0xFFFF, 0x044F };
unsigned short unac_data45[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0438, 0x0438, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data46[] = { 0x0435, 0x0435, 0x0435, 0x0435, 0xFFFF, 0xFFFF, 0x0433, 0x0433, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0456, 0x0456, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x043A, 0x043A, 0x0438, 0x0438, 0x0443, 0x0443, 0xFFFF, 0xFFFF };
unsigned short unac_data47[] = { 0xFFFF, 0x0461, 0xFFFF, 0xFFFF, 0xFFFF, 0x0463, 0xFFFF, 0xFFFF, 0xFFFF, 0x0465, 0xFFFF, 0xFFFF, 0xFFFF, 0x0467, 0xFFFF, 0xFFFF, 0xFFFF, 0x0469, 0xFFFF, 0xFFFF, 0xFFFF, 0x046B, 0xFFFF, 0xFFFF, 0xFFFF, 0x046D, 0xFFFF, 0xFFFF, 0xFFFF, 0x046F, 0xFFFF, 0xFFFF };
unsigned short unac_data48[] = { 0xFFFF, 0x0471, 0xFFFF, 0xFFFF, 0xFFFF, 0x0473, 0xFFFF, 0xFFFF, 0xFFFF, 0x0475, 0xFFFF, 0xFFFF, 0x0474, 0x0475, 0x0475, 0x0475, 0xFFFF, 0x0479, 0xFFFF, 0xFFFF, 0xFFFF, 0x047B, 0xFFFF, 0xFFFF, 0xFFFF, 0x047D, 0xFFFF, 0xFFFF, 0xFFFF, 0x047F, 0xFFFF, 0xFFFF };
unsigned short unac_data49[] = { 0xFFFF, 0x0481, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x048B, 0xFFFF, 0xFFFF, 0xFFFF, 0x048D, 0xFFFF, 0xFFFF, 0xFFFF, 0x048F, 0xFFFF, 0xFFFF };
unsigned short unac_data50[] = { 0xFFFF, 0x0491, 0xFFFF, 0xFFFF, 0xFFFF, 0x0493, 0xFFFF, 0xFFFF, 0xFFFF, 0x0495, 0xFFFF, 0xFFFF, 0xFFFF, 0x0497, 0xFFFF, 0xFFFF, 0xFFFF, 0x0499, 0xFFFF, 0xFFFF, 0xFFFF, 0x049B, 0xFFFF, 0xFFFF, 0xFFFF, 0x049D, 0xFFFF, 0xFFFF, 0xFFFF, 0x049F, 0xFFFF, 0xFFFF };
unsigned short unac_data51[] = { 0xFFFF, 0x04A1, 0xFFFF, 0xFFFF, 0xFFFF, 0x04A3, 0xFFFF, 0xFFFF, 0xFFFF, 0x04A5, 0xFFFF, 0xFFFF, 0xFFFF, 0x04A7, 0xFFFF, 0xFFFF, 0xFFFF, 0x04A9, 0xFFFF, 0xFFFF, 0xFFFF, 0x04AB, 0xFFFF, 0xFFFF, 0xFFFF, 0x04AD, 0xFFFF, 0xFFFF, 0xFFFF, 0x04AF, 0xFFFF, 0xFFFF };
unsigned short unac_data52[] = { 0xFFFF, 0x04B1, 0xFFFF, 0xFFFF, 0xFFFF, 0x04B3, 0xFFFF, 0xFFFF, 0xFFFF, 0x04B5, 0xFFFF, 0xFFFF, 0xFFFF, 0x04B7, 0xFFFF, 0xFFFF, 0xFFFF, 0x04B9, 0xFFFF, 0xFFFF, 0xFFFF, 0x04BB, 0xFFFF, 0xFFFF, 0xFFFF, 0x04BD, 0xFFFF, 0xFFFF, 0xFFFF, 0x04BF, 0xFFFF, 0xFFFF };
unsigned short unac_data53[] = { 0xFFFF, 0xFFFF, 0x0416, 0x0436, 0x0436, 0x0436, 0xFFFF, 0x04C4, 0xFFFF, 0xFFFF, 0xFFFF, 0x04C6, 0xFFFF, 0xFFFF, 0xFFFF, 0x04C8, 0xFFFF, 0xFFFF, 0xFFFF, 0x04CA, 0xFFFF, 0xFFFF, 0xFFFF, 0x04CC, 0xFFFF, 0xFFFF, 0xFFFF, 0x04CE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data54[] = { 0x0410, 0x0430, 0x0430, 0x0430, 0x0410, 0x0430, 0x0430, 0x0430, 0xFFFF, 0x04D5, 0xFFFF, 0xFFFF, 0x0415, 0x0435, 0x0435, 0x0435, 0xFFFF, 0x04D9, 0xFFFF, 0xFFFF, 0x04D8, 0x04D9, 0x04D9, 0x04D9, 0x0416, 0x0436, 0x0436, 0x0436, 0x0417, 0x0437, 0x0437, 0x0437 };
unsigned short unac_data55[] = { 0xFFFF, 0x04E1, 0xFFFF, 0xFFFF, 0x0418, 0x0438, 0x0438, 0x0438, 0x0418, 0x0438, 0x0438, 0x0438, 0x041E, 0x043E, 0x043E, 0x043E, 0xFFFF, 0x04E9, 0xFFFF, 0xFFFF, 0x04E8, 0x04E9, 0x04E9, 0x04E9, 0x042D, 0x044D, 0x044D, 0x044D, 0x0423, 0x0443, 0x0443, 0x0443 };
unsigned short unac_data56[] = { 0x0423, 0x0443, 0x0443, 0x0443, 0x0423, 0x0443, 0x0443, 0x0443, 0x0427, 0x0447, 0x0447, 0x0447, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x042B, 0x044B, 0x044B, 0x044B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data57[] = { 0xFFFF, 0x0501, 0xFFFF, 0xFFFF, 0xFFFF, 0x0503, 0xFFFF, 0xFFFF, 0xFFFF, 0x0505, 0xFFFF, 0xFFFF, 0xFFFF, 0x0507, 0xFFFF, 0xFFFF, 0xFFFF, 0x0509, 0xFFFF, 0xFFFF, 0xFFFF, 0x050B, 0xFFFF, 0xFFFF, 0xFFFF, 0x050D, 0xFFFF, 0xFFFF, 0xFFFF, 0x050F, 0xFFFF, 0xFFFF };
unsigned short unac_data58[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0x0561, 0xFFFF, 0x0562, 0xFFFF, 0x0563, 0xFFFF, 0x0564, 0xFFFF, 0x0565, 0xFFFF, 0x0566, 0xFFFF, 0x0567, 0xFFFF, 0x0568, 0xFFFF, 0x0569, 0xFFFF, 0x056A, 0xFFFF, 0x056B, 0xFFFF, 0x056C, 0xFFFF, 0x056D, 0xFFFF, 0x056E, 0xFFFF, 0x056F };
unsigned short unac_data59[] = { 0xFFFF, 0x0570, 0xFFFF, 0x0571, 0xFFFF, 0x0572, 0xFFFF, 0x0573, 0xFFFF, 0x0574, 0xFFFF, 0x0575, 0xFFFF, 0x0576, 0xFFFF, 0x0577, 0xFFFF, 0x0578, 0xFFFF, 0x0579, 0xFFFF, 0x057A, 0xFFFF, 0x057B, 0xFFFF, 0x057C, 0xFFFF, 0x057D, 0xFFFF, 0x057E, 0xFFFF, 0x057F };
unsigned short unac_data60[] = { 0xFFFF, 0x0580, 0xFFFF, 0x0581, 0xFFFF, 0x0582, 0xFFFF, 0x0583, 0xFFFF, 0x0584, 0xFFFF, 0x0585, 0xFFFF, 0x0586, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data61[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0565, 0x0582, 0x0565, 0x0582, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data62[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0627, 0x0627, 0x0627, 0x0627, 0x0648, 0x0648, 0x0627, 0x0627, 0x064A, 0x064A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data63[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0627, 0x0674, 0x0627, 0x0674, 0x0648, 0x0674, 0x0648, 0x0674, 0x06C7, 0x0674, 0x06C7, 0x0674, 0x064A, 0x0674, 0x064A, 0x0674, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data64[] = { 0x06D5, 0x06D5, 0xFFFF, 0xFFFF, 0x06C1, 0x06C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data65[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x06D2, 0x06D2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data66[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0928, 0x0928, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data67[] = { 0xFFFF, 0xFFFF, 0x0930, 0x0930, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0933, 0x0933, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data68[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0915, 0x0915, 0x0916, 0x0916, 0x0917, 0x0917, 0x091C, 0x091C, 0x0921, 0x0921, 0x0922, 0x0922, 0x092B, 0x092B, 0x092F, 0x092F };
unsigned short unac_data69[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x09A1, 0x09A1, 0x09A2, 0x09A2, 0xFFFF, 0xFFFF, 0x09AF, 0x09AF };
unsigned short unac_data70[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0A32, 0x0A32, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0A38, 0x0A38, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data71[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0A16, 0x0A16, 0x0A17, 0x0A17, 0x0A1C, 0x0A1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0A2B, 0x0A2B, 0xFFFF, 0xFFFF };
unsigned short unac_data72[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0B21, 0x0B21, 0x0B22, 0x0B22, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data73[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0B92, 0x0B92, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data74[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0E32, 0x0E32, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data75[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0EB2, 0x0EB2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data76[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0EAB, 0x0E99, 0x0EAB, 0x0E99, 0x0EAB, 0x0EA1, 0x0EAB, 0x0EA1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data77[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F0B, 0x0F0B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data78[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F42, 0x0F42, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F4C, 0x0F4C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data79[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F51, 0x0F51, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F56, 0x0F56, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F5B, 0x0F5B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data80[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0F40, 0x0F40, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data81[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1025, 0x1025, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data82[] = { 0x0041, 0x0061, 0x0061, 0x0061, 0x0042, 0x0062, 0x0062, 0x0062, 0x0042, 0x0062, 0x0062, 0x0062, 0x0042, 0x0062, 0x0062, 0x0062, 0x0043, 0x0063, 0x0063, 0x0063, 0x0044, 0x0064, 0x0064, 0x0064, 0x0044, 0x0064, 0x0064, 0x0064, 0x0044, 0x0064, 0x0064, 0x0064 };
unsigned short unac_data83[] = { 0x0044, 0x0064, 0x0064, 0x0064, 0x0044, 0x0064, 0x0064, 0x0064, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0046, 0x0066, 0x0066, 0x0066 };
unsigned short unac_data84[] = { 0x0047, 0x0067, 0x0067, 0x0067, 0x0048, 0x0068, 0x0068, 0x0068, 0x0048, 0x0068, 0x0068, 0x0068, 0x0048, 0x0068, 0x0068, 0x0068, 0x0048, 0x0068, 0x0068, 0x0068, 0x0048, 0x0068, 0x0068, 0x0068, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0069, 0x0069, 0x0069 };
unsigned short unac_data85[] = { 0x004B, 0x006B, 0x006B, 0x006B, 0x004B, 0x006B, 0x006B, 0x006B, 0x004B, 0x006B, 0x006B, 0x006B, 0x004C, 0x006C, 0x006C, 0x006C, 0x004C, 0x006C, 0x006C, 0x006C, 0x004C, 0x006C, 0x006C, 0x006C, 0x004C, 0x006C, 0x006C, 0x006C, 0x004D, 0x006D, 0x006D, 0x006D };
unsigned short unac_data86[] = { 0x004D, 0x006D, 0x006D, 0x006D, 0x004D, 0x006D, 0x006D, 0x006D, 0x004E, 0x006E, 0x006E, 0x006E, 0x004E, 0x006E, 0x006E, 0x006E, 0x004E, 0x006E, 0x006E, 0x006E, 0x004E, 0x006E, 0x006E, 0x006E, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data87[] = { 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x0050, 0x0070, 0x0070, 0x0070, 0x0050, 0x0070, 0x0070, 0x0070, 0x0052, 0x0072, 0x0072, 0x0072, 0x0052, 0x0072, 0x0072, 0x0072, 0x0052, 0x0072, 0x0072, 0x0072, 0x0052, 0x0072, 0x0072, 0x0072 };
unsigned short unac_data88[] = { 0x0053, 0x0073, 0x0073, 0x0073, 0x0053, 0x0073, 0x0073, 0x0073, 0x0053, 0x0073, 0x0073, 0x0073, 0x0053, 0x0073, 0x0073, 0x0073, 0x0053, 0x0073, 0x0073, 0x0073, 0x0054, 0x0074, 0x0074, 0x0074, 0x0054, 0x0074, 0x0074, 0x0074, 0x0054, 0x0074, 0x0074, 0x0074 };
unsigned short unac_data89[] = { 0x0054, 0x0074, 0x0074, 0x0074, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0056, 0x0076, 0x0076, 0x0076, 0x0056, 0x0076, 0x0076, 0x0076 };
unsigned short unac_data90[] = { 0x0057, 0x0077, 0x0077, 0x0077, 0x0057, 0x0077, 0x0077, 0x0077, 0x0057, 0x0077, 0x0077, 0x0077, 0x0057, 0x0077, 0x0077, 0x0077, 0x0057, 0x0077, 0x0077, 0x0077, 0x0058, 0x0078, 0x0078, 0x0078, 0x0058, 0x0078, 0x0078, 0x0078, 0x0059, 0x0079, 0x0079, 0x0079 };
unsigned short unac_data91[] = { 0x005A, 0x007A, 0x007A, 0x007A, 0x005A, 0x007A, 0x007A, 0x007A, 0x005A, 0x007A, 0x007A, 0x007A, 0x0068, 0x0068, 0x0074, 0x0074, 0x0077, 0x0077, 0x0079, 0x0079, 0x0061, 0x02BE, 0x0061, 0x02BE, 0x0073, 0x0073, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data92[] = { 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061 };
unsigned short unac_data93[] = { 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0041, 0x0061, 0x0061, 0x0061, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065 };
unsigned short unac_data94[] = { 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0045, 0x0065, 0x0065, 0x0065, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0069, 0x0069, 0x0069, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data95[] = { 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F };
unsigned short unac_data96[] = { 0x004F, 0x006F, 0x006F, 0x006F, 0x004F, 0x006F, 0x006F, 0x006F, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075, 0x0055, 0x0075, 0x0075, 0x0075 };
unsigned short unac_data97[] = { 0x0055, 0x0075, 0x0075, 0x0075, 0x0059, 0x0079, 0x0079, 0x0079, 0x0059, 0x0079, 0x0079, 0x0079, 0x0059, 0x0079, 0x0079, 0x0079, 0x0059, 0x0079, 0x0079, 0x0079, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data98[] = { 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1 };
unsigned short unac_data99[] = { 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0395, 0x03B5, 0x0395, 0x03B5, 0x0395, 0x03B5, 0x0395, 0x03B5, 0x0395, 0x03B5, 0x0395, 0x03B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data100[] = { 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7 };
unsigned short unac_data101[] = { 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9 };
unsigned short unac_data102[] = { 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x039F, 0x03BF, 0x039F, 0x03BF, 0x039F, 0x03BF, 0x039F, 0x03BF, 0x039F, 0x03BF, 0x039F, 0x03BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data103[] = { 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0xFFFF, 0xFFFF, 0x03A5, 0x03C5, 0xFFFF, 0xFFFF, 0x03A5, 0x03C5, 0xFFFF, 0xFFFF, 0x03A5, 0x03C5, 0xFFFF, 0xFFFF, 0x03A5, 0x03C5 };
unsigned short unac_data104[] = { 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9 };
unsigned short unac_data105[] = { 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B5, 0x03B5, 0x03B5, 0x03B5, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03BF, 0x03BF, 0x03BF, 0x03BF, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data106[] = { 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0xFFFF, 0xFFFF, 0x03B1, 0x03B1, 0x03B1, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0391, 0x03B1, 0x0020, 0x0020, 0x03B9, 0x03B9, 0x0020, 0x0020 };
unsigned short unac_data107[] = { 0x0020, 0x0020, 0x0020, 0x0020, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0xFFFF, 0xFFFF, 0x03B7, 0x03B7, 0x03B7, 0x03B7, 0x0395, 0x03B5, 0x0395, 0x03B5, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0397, 0x03B7, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020 };
unsigned short unac_data108[] = { 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03B9, 0x03B9, 0x03B9, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0x0399, 0x03B9, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020 };
unsigned short unac_data109[] = { 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03C1, 0x03C1, 0x03C1, 0x03C1, 0x03C5, 0x03C5, 0x03C5, 0x03C5, 0x03A5, 0x03C5, 0x03A5, 0x03C5, 0x03A5, 0x03C5, 0x03A5, 0x03C5, 0x03A1, 0x03C1, 0x0020, 0x0020, 0x0020, 0x0020, 0x0060, 0x0060 };
unsigned short unac_data110[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0xFFFF, 0xFFFF, 0x03C9, 0x03C9, 0x03C9, 0x03C9, 0x039F, 0x03BF, 0x039F, 0x03BF, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x03A9, 0x03C9, 0x0020, 0x0020, 0x0020, 0x0020, 0xFFFF, 0xFFFF };
unsigned short unac_data111[] = { 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data112[] = { 0xFFFF, 0xFFFF, 0x2010, 0x2010, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data113[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0x002E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020 };
unsigned short unac_data114[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0xFFFF, 0xFFFF, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0021, 0x0021, 0x0021, 0x0021, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0xFFFF, 0xFFFF };
unsigned short unac_data115[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x0021, 0x003F, 0x0021, 0x0021, 0x003F, 0x0021, 0x003F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data116[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0x2032, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020 };
unsigned short unac_data117[] = { 0x0030, 0x0030, 0x0069, 0x0069, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0034, 0x0034, 0x0035, 0x0035, 0x0036, 0x0036, 0x0037, 0x0037, 0x0038, 0x0038, 0x0039, 0x0039, 0x002B, 0x002B, 0x2212, 0x2212, 0x003D, 0x003D, 0x0028, 0x0028, 0x0029, 0x0029, 0x006E, 0x006E };
unsigned short unac_data118[] = { 0x0030, 0x0030, 0x0031, 0x0031, 0x0032, 0x0032, 0x0033, 0x0033, 0x0034, 0x0034, 0x0035, 0x0035, 0x0036, 0x0036, 0x0037, 0x0037, 0x0038, 0x0038, 0x0039, 0x0039, 0x002B, 0x002B, 0x2212, 0x2212, 0x003D, 0x003D, 0x0028, 0x0028, 0x0029, 0x0029, 0xFFFF, 0xFFFF };
unsigned short unac_data119[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0052, 0x0073, 0x0072, 0x0073, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data120[] = { 0x0061, 0x002F, 0x0063, 0x0061, 0x002F, 0x0063, 0x0061, 0x002F, 0x0073, 0x0061, 0x002F, 0x0073, 0x0043, 0x0063, 0x00B0, 0x0043, 0x00B0, 0x0063, 0xFFFF, 0xFFFF, 0x0063, 0x002F, 0x006F, 0x0063, 0x002F, 0x006F, 0x0063, 0x002F, 0x0075, 0x0063, 0x002F, 0x0075, 0x0190, 0x025B, 0xFFFF, 0xFFFF, 0x00B0, 0x0046, 0x00B0, 0x0066, 0x0067, 0x0067, 0x0048, 0x0068, 0x0048, 0x0068, 0x0048, 0x0068, 0x0068, 0x0068, 0x0127, 0x0127 };
unsigned short unac_data121[] = { 0x0049, 0x0069, 0x0049, 0x0069, 0x004C, 0x006C, 0x006C, 0x006C, 0xFFFF, 0xFFFF, 0x004E, 0x006E, 0x004E, 0x006F, 0x006E, 0x006F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0050, 0x0070, 0x0051, 0x0071, 0x0052, 0x0072, 0x0052, 0x0072, 0x0052, 0x0072, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data122[] = { 0x0053, 0x004D, 0x0073, 0x006D, 0x0054, 0x0045, 0x004C, 0x0074, 0x0065, 0x006C, 0x0054, 0x004D, 0x0074, 0x006D, 0xFFFF, 0xFFFF, 0x005A, 0x007A, 0xFFFF, 0xFFFF, 0x03A9, 0x03C9, 0xFFFF, 0xFFFF, 0x005A, 0x007A, 0xFFFF, 0xFFFF, 0x004B, 0x006B, 0x0041, 0x0061, 0x0042, 0x0062, 0x0043, 0x0063, 0xFFFF, 0xFFFF, 0x0065, 0x0065 };
unsigned short unac_data123[] = { 0x0045, 0x0065, 0x0046, 0x0066, 0xFFFF, 0xFFFF, 0x004D, 0x006D, 0x006F, 0x006F, 0x05D0, 0x05D0, 0x05D1, 0x05D1, 0x05D2, 0x05D2, 0x05D3, 0x05D3, 0x0069, 0x0069, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03B3, 0x03B3, 0x0393, 0x03B3, 0x03A0, 0x03C0 };
unsigned short unac_data124[] = { 0x2211, 0x2211, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0044, 0x0064, 0x0064, 0x0064, 0x0065, 0x0065, 0x0069, 0x0069, 0x006A, 0x006A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data125[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0031, 0x2044, 0x0033, 0x0031, 0x2044, 0x0033, 0x0032, 0x2044, 0x0033, 0x0032, 0x2044, 0x0033, 0x0031, 0x2044, 0x0035, 0x0031, 0x2044, 0x0035, 0x0032, 0x2044, 0x0035, 0x0032, 0x2044, 0x0035, 0x0033, 0x2044, 0x0035, 0x0033, 0x2044, 0x0035, 0x0034, 0x2044, 0x0035, 0x0034, 0x2044, 0x0035, 0x0031, 0x2044, 0x0036, 0x0031, 0x2044, 0x0036, 0x0035, 0x2044, 0x0036, 0x0035, 0x2044, 0x0036, 0x0031, 0x2044, 0x0038, 0x0031, 0x2044, 0x0038, 0x0033, 0x2044, 0x0038, 0x0033, 0x2044, 0x0038, 0x0035, 0x2044, 0x0038, 0x0035, 0x2044, 0x0038, 0x0037, 0x2044, 0x0038, 0x0037, 0x2044, 0x0038, 0x0031, 0x2044, 0x0031, 0x2044 };
unsigned short unac_data126[] = { 0x0049, 0x0069, 0x0049, 0x0049, 0x0069, 0x0069, 0x0049, 0x0049, 0x0049, 0x0069, 0x0069, 0x0069, 0x0049, 0x0056, 0x0069, 0x0076, 0x0056, 0x0076, 0x0056, 0x0049, 0x0076, 0x0069, 0x0056, 0x0049, 0x0049, 0x0076, 0x0069, 0x0069, 0x0056, 0x0049, 0x0049, 0x0049, 0x0076, 0x0069, 0x0069, 0x0069, 0x0049, 0x0058, 0x0069, 0x0078, 0x0058, 0x0078, 0x0058, 0x0049, 0x0078, 0x0069, 0x0058, 0x0049, 0x0049, 0x0078, 0x0069, 0x0069, 0x004C, 0x006C, 0x0043, 0x0063, 0x0044, 0x0064, 0x004D, 0x006D };
unsigned short unac_data127[] = { 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0076, 0x0069, 0x0076, 0x0076, 0x0076, 0x0076, 0x0069, 0x0076, 0x0069, 0x0076, 0x0069, 0x0069, 0x0076, 0x0069, 0x0069, 0x0076, 0x0069, 0x0069, 0x0069, 0x0076, 0x0069, 0x0069, 0x0069, 0x0069, 0x0078, 0x0069, 0x0078, 0x0078, 0x0078, 0x0078, 0x0069, 0x0078, 0x0069, 0x0078, 0x0069, 0x0069, 0x0078, 0x0069, 0x0069, 0x006C, 0x006C, 0x0063, 0x0063, 0x0064, 0x0064, 0x006D, 0x006D };
unsigned short unac_data128[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2190, 0x2190, 0x2192, 0x2192, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data129[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2194, 0x2194, 0xFFFF, 0xFFFF };
unsigned short unac_data130[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x21D0, 0x21D0, 0x21D4, 0x21D4, 0x21D2, 0x21D2 };
unsigned short unac_data131[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2203, 0x2203, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2208, 0x2208, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x220B, 0x220B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data132[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2223, 0x2223, 0xFFFF, 0xFFFF, 0x2225, 0x2225, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0xFFFF, 0xFFFF, 0x222E, 0x222E, 0x222E, 0x222E };
unsigned short unac_data133[] = { 0x222E, 0x222E, 0x222E, 0x222E, 0x222E, 0x222E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data134[] = { 0xFFFF, 0xFFFF, 0x223C, 0x223C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2243, 0x2243, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2245, 0x2245, 0xFFFF, 0xFFFF, 0x2248, 0x2248, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data135[] = { 0x003D, 0x003D, 0xFFFF, 0xFFFF, 0x2261, 0x2261, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x224D, 0x224D, 0x003C, 0x003C, 0x003E, 0x003E };
unsigned short unac_data136[] = { 0x2264, 0x2264, 0x2265, 0x2265, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2272, 0x2272, 0x2273, 0x2273, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2276, 0x2276, 0x2277, 0x2277, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data137[] = { 0x227A, 0x227A, 0x227B, 0x227B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2282, 0x2282, 0x2283, 0x2283, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2286, 0x2286, 0x2287, 0x2287, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data138[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x22A2, 0x22A2, 0x22A8, 0x22A8, 0x22A9, 0x22A9, 0x22AB, 0x22AB };
unsigned short unac_data139[] = { 0x227C, 0x227C, 0x227D, 0x227D, 0x2291, 0x2291, 0x2292, 0x2292, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x22B2, 0x22B2, 0x22B3, 0x22B3, 0x22B4, 0x22B4, 0x22B5, 0x22B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data140[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x3008, 0x3008, 0x3009, 0x3009, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data141[] = { 0x0031, 0x0031, 0x0032, 0x0032, 0x0033, 0x0033, 0x0034, 0x0034, 0x0035, 0x0035, 0x0036, 0x0036, 0x0037, 0x0037, 0x0038, 0x0038, 0x0039, 0x0039, 0x0031, 0x0030, 0x0031, 0x0030, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0032, 0x0031, 0x0032, 0x0031, 0x0033, 0x0031, 0x0033, 0x0031, 0x0034, 0x0031, 0x0034, 0x0031, 0x0035, 0x0031, 0x0035, 0x0031, 0x0036, 0x0031, 0x0036 };
unsigned short unac_data142[] = { 0x0031, 0x0037, 0x0031, 0x0037, 0x0031, 0x0038, 0x0031, 0x0038, 0x0031, 0x0039, 0x0031, 0x0039, 0x0032, 0x0030, 0x0032, 0x0030, 0x0028, 0x0031, 0x0029, 0x0028, 0x0031, 0x0029, 0x0028, 0x0032, 0x0029, 0x0028, 0x0032, 0x0029, 0x0028, 0x0033, 0x0029, 0x0028, 0x0033, 0x0029, 0x0028, 0x0034, 0x0029, 0x0028, 0x0034, 0x0029, 0x0028, 0x0035, 0x0029, 0x0028, 0x0035, 0x0029, 0x0028, 0x0036, 0x0029, 0x0028, 0x0036, 0x0029, 0x0028, 0x0037, 0x0029, 0x0028, 0x0037, 0x0029, 0x0028, 0x0038, 0x0029, 0x0028, 0x0038, 0x0029, 0x0028, 0x0039, 0x0029, 0x0028, 0x0039, 0x0029, 0x0028, 0x0031, 0x0030, 0x0029, 0x0028, 0x0031, 0x0030, 0x0029, 0x0028, 0x0031, 0x0031, 0x0029, 0x0028, 0x0031, 0x0031, 0x0029, 0x0028, 0x0031, 0x0032, 0x0029, 0x0028, 0x0031, 0x0032, 0x0029 };
unsigned short unac_data143[] = { 0x0028, 0x0031, 0x0033, 0x0029, 0x0028, 0x0031, 0x0033, 0x0029, 0x0028, 0x0031, 0x0034, 0x0029, 0x0028, 0x0031, 0x0034, 0x0029, 0x0028, 0x0031, 0x0035, 0x0029, 0x0028, 0x0031, 0x0035, 0x0029, 0x0028, 0x0031, 0x0036, 0x0029, 0x0028, 0x0031, 0x0036, 0x0029, 0x0028, 0x0031, 0x0037, 0x0029, 0x0028, 0x0031, 0x0037, 0x0029, 0x0028, 0x0031, 0x0038, 0x0029, 0x0028, 0x0031, 0x0038, 0x0029, 0x0028, 0x0031, 0x0039, 0x0029, 0x0028, 0x0031, 0x0039, 0x0029, 0x0028, 0x0032, 0x0030, 0x0029, 0x0028, 0x0032, 0x0030, 0x0029, 0x0031, 0x002E, 0x0031, 0x002E, 0x0032, 0x002E, 0x0032, 0x002E, 0x0033, 0x002E, 0x0033, 0x002E, 0x0034, 0x002E, 0x0034, 0x002E, 0x0035, 0x002E, 0x0035, 0x002E, 0x0036, 0x002E, 0x0036, 0x002E, 0x0037, 0x002E, 0x0037, 0x002E, 0x0038, 0x002E, 0x0038, 0x002E };
unsigned short unac_data144[] = { 0x0039, 0x002E, 0x0039, 0x002E, 0x0031, 0x0030, 0x002E, 0x0031, 0x0030, 0x002E, 0x0031, 0x0031, 0x002E, 0x0031, 0x0031, 0x002E, 0x0031, 0x0032, 0x002E, 0x0031, 0x0032, 0x002E, 0x0031, 0x0033, 0x002E, 0x0031, 0x0033, 0x002E, 0x0031, 0x0034, 0x002E, 0x0031, 0x0034, 0x002E, 0x0031, 0x0035, 0x002E, 0x0031, 0x0035, 0x002E, 0x0031, 0x0036, 0x002E, 0x0031, 0x0036, 0x002E, 0x0031, 0x0037, 0x002E, 0x0031, 0x0037, 0x002E, 0x0031, 0x0038, 0x002E, 0x0031, 0x0038, 0x002E, 0x0031, 0x0039, 0x002E, 0x0031, 0x0039, 0x002E, 0x0032, 0x0030, 0x002E, 0x0032, 0x0030, 0x002E, 0x0028, 0x0061, 0x0029, 0x0028, 0x0061, 0x0029, 0x0028, 0x0062, 0x0029, 0x0028, 0x0062, 0x0029, 0x0028, 0x0063, 0x0029, 0x0028, 0x0063, 0x0029, 0x0028, 0x0064, 0x0029, 0x0028, 0x0064, 0x0029 };
unsigned short unac_data145[] = { 0x0028, 0x0065, 0x0029, 0x0028, 0x0065, 0x0029, 0x0028, 0x0066, 0x0029, 0x0028, 0x0066, 0x0029, 0x0028, 0x0067, 0x0029, 0x0028, 0x0067, 0x0029, 0x0028, 0x0068, 0x0029, 0x0028, 0x0068, 0x0029, 0x0028, 0x0069, 0x0029, 0x0028, 0x0069, 0x0029, 0x0028, 0x006A, 0x0029, 0x0028, 0x006A, 0x0029, 0x0028, 0x006B, 0x0029, 0x0028, 0x006B, 0x0029, 0x0028, 0x006C, 0x0029, 0x0028, 0x006C, 0x0029, 0x0028, 0x006D, 0x0029, 0x0028, 0x006D, 0x0029, 0x0028, 0x006E, 0x0029, 0x0028, 0x006E, 0x0029, 0x0028, 0x006F, 0x0029, 0x0028, 0x006F, 0x0029, 0x0028, 0x0070, 0x0029, 0x0028, 0x0070, 0x0029, 0x0028, 0x0071, 0x0029, 0x0028, 0x0071, 0x0029, 0x0028, 0x0072, 0x0029, 0x0028, 0x0072, 0x0029, 0x0028, 0x0073, 0x0029, 0x0028, 0x0073, 0x0029, 0x0028, 0x0074, 0x0029, 0x0028, 0x0074, 0x0029 };
unsigned short unac_data146[] = { 0x0028, 0x0075, 0x0029, 0x0028, 0x0075, 0x0029, 0x0028, 0x0076, 0x0029, 0x0028, 0x0076, 0x0029, 0x0028, 0x0077, 0x0029, 0x0028, 0x0077, 0x0029, 0x0028, 0x0078, 0x0029, 0x0028, 0x0078, 0x0029, 0x0028, 0x0079, 0x0029, 0x0028, 0x0079, 0x0029, 0x0028, 0x007A, 0x0029, 0x0028, 0x007A, 0x0029, 0x0041, 0x0061, 0x0042, 0x0062, 0x0043, 0x0063, 0x0044, 0x0064, 0x0045, 0x0065, 0x0046, 0x0066, 0x0047, 0x0067, 0x0048, 0x0068, 0x0049, 0x0069, 0x004A, 0x006A };
unsigned short unac_data147[] = { 0x004B, 0x006B, 0x004C, 0x006C, 0x004D, 0x006D, 0x004E, 0x006E, 0x004F, 0x006F, 0x0050, 0x0070, 0x0051, 0x0071, 0x0052, 0x0072, 0x0053, 0x0073, 0x0054, 0x0074, 0x0055, 0x0075, 0x0056, 0x0076, 0x0057, 0x0077, 0x0058, 0x0078, 0x0059, 0x0079, 0x005A, 0x007A };
unsigned short unac_data148[] = { 0x0061, 0x0061, 0x0062, 0x0062, 0x0063, 0x0063, 0x0064, 0x0064, 0x0065, 0x0065, 0x0066, 0x0066, 0x0067, 0x0067, 0x0068, 0x0068, 0x0069, 0x0069, 0x006A, 0x006A, 0x006B, 0x006B, 0x006C, 0x006C, 0x006D, 0x006D, 0x006E, 0x006E, 0x006F, 0x006F, 0x0070, 0x0070 };
unsigned short unac_data149[] = { 0x0071, 0x0071, 0x0072, 0x0072, 0x0073, 0x0073, 0x0074, 0x0074, 0x0075, 0x0075, 0x0076, 0x0076, 0x0077, 0x0077, 0x0078, 0x0078, 0x0079, 0x0079, 0x007A, 0x007A, 0x0030, 0x0030, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data150[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data151[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x003A, 0x003A, 0x003D, 0x003A, 0x003A, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data152[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x2ADD, 0x2ADD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data153[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x6BCD, 0x6BCD };
unsigned short unac_data154[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x9F9F, 0x9F9F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data155[] = { 0x4E00, 0x4E00, 0x4E28, 0x4E28, 0x4E36, 0x4E36, 0x4E3F, 0x4E3F, 0x4E59, 0x4E59, 0x4E85, 0x4E85, 0x4E8C, 0x4E8C, 0x4EA0, 0x4EA0, 0x4EBA, 0x4EBA, 0x513F, 0x513F, 0x5165, 0x5165, 0x516B, 0x516B, 0x5182, 0x5182, 0x5196, 0x5196, 0x51AB, 0x51AB, 0x51E0, 0x51E0 };
unsigned short unac_data156[] = { 0x51F5, 0x51F5, 0x5200, 0x5200, 0x529B, 0x529B, 0x52F9, 0x52F9, 0x5315, 0x5315, 0x531A, 0x531A, 0x5338, 0x5338, 0x5341, 0x5341, 0x535C, 0x535C, 0x5369, 0x5369, 0x5382, 0x5382, 0x53B6, 0x53B6, 0x53C8, 0x53C8, 0x53E3, 0x53E3, 0x56D7, 0x56D7, 0x571F, 0x571F };
unsigned short unac_data157[] = { 0x58EB, 0x58EB, 0x5902, 0x5902, 0x590A, 0x590A, 0x5915, 0x5915, 0x5927, 0x5927, 0x5973, 0x5973, 0x5B50, 0x5B50, 0x5B80, 0x5B80, 0x5BF8, 0x5BF8, 0x5C0F, 0x5C0F, 0x5C22, 0x5C22, 0x5C38, 0x5C38, 0x5C6E, 0x5C6E, 0x5C71, 0x5C71, 0x5DDB, 0x5DDB, 0x5DE5, 0x5DE5 };
unsigned short unac_data158[] = { 0x5DF1, 0x5DF1, 0x5DFE, 0x5DFE, 0x5E72, 0x5E72, 0x5E7A, 0x5E7A, 0x5E7F, 0x5E7F, 0x5EF4, 0x5EF4, 0x5EFE, 0x5EFE, 0x5F0B, 0x5F0B, 0x5F13, 0x5F13, 0x5F50, 0x5F50, 0x5F61, 0x5F61, 0x5F73, 0x5F73, 0x5FC3, 0x5FC3, 0x6208, 0x6208, 0x6236, 0x6236, 0x624B, 0x624B };
unsigned short unac_data159[] = { 0x652F, 0x652F, 0x6534, 0x6534, 0x6587, 0x6587, 0x6597, 0x6597, 0x65A4, 0x65A4, 0x65B9, 0x65B9, 0x65E0, 0x65E0, 0x65E5, 0x65E5, 0x66F0, 0x66F0, 0x6708, 0x6708, 0x6728, 0x6728, 0x6B20, 0x6B20, 0x6B62, 0x6B62, 0x6B79, 0x6B79, 0x6BB3, 0x6BB3, 0x6BCB, 0x6BCB };
unsigned short unac_data160[] = { 0x6BD4, 0x6BD4, 0x6BDB, 0x6BDB, 0x6C0F, 0x6C0F, 0x6C14, 0x6C14, 0x6C34, 0x6C34, 0x706B, 0x706B, 0x722A, 0x722A, 0x7236, 0x7236, 0x723B, 0x723B, 0x723F, 0x723F, 0x7247, 0x7247, 0x7259, 0x7259, 0x725B, 0x725B, 0x72AC, 0x72AC, 0x7384, 0x7384, 0x7389, 0x7389 };
unsigned short unac_data161[] = { 0x74DC, 0x74DC, 0x74E6, 0x74E6, 0x7518, 0x7518, 0x751F, 0x751F, 0x7528, 0x7528, 0x7530, 0x7530, 0x758B, 0x758B, 0x7592, 0x7592, 0x7676, 0x7676, 0x767D, 0x767D, 0x76AE, 0x76AE, 0x76BF, 0x76BF, 0x76EE, 0x76EE, 0x77DB, 0x77DB, 0x77E2, 0x77E2, 0x77F3, 0x77F3 };
unsigned short unac_data162[] = { 0x793A, 0x793A, 0x79B8, 0x79B8, 0x79BE, 0x79BE, 0x7A74, 0x7A74, 0x7ACB, 0x7ACB, 0x7AF9, 0x7AF9, 0x7C73, 0x7C73, 0x7CF8, 0x7CF8, 0x7F36, 0x7F36, 0x7F51, 0x7F51, 0x7F8A, 0x7F8A, 0x7FBD, 0x7FBD, 0x8001, 0x8001, 0x800C, 0x800C, 0x8012, 0x8012, 0x8033, 0x8033 };
unsigned short unac_data163[] = { 0x807F, 0x807F, 0x8089, 0x8089, 0x81E3, 0x81E3, 0x81EA, 0x81EA, 0x81F3, 0x81F3, 0x81FC, 0x81FC, 0x820C, 0x820C, 0x821B, 0x821B, 0x821F, 0x821F, 0x826E, 0x826E, 0x8272, 0x8272, 0x8278, 0x8278, 0x864D, 0x864D, 0x866B, 0x866B, 0x8840, 0x8840, 0x884C, 0x884C };
unsigned short unac_data164[] = { 0x8863, 0x8863, 0x897E, 0x897E, 0x898B, 0x898B, 0x89D2, 0x89D2, 0x8A00, 0x8A00, 0x8C37, 0x8C37, 0x8C46, 0x8C46, 0x8C55, 0x8C55, 0x8C78, 0x8C78, 0x8C9D, 0x8C9D, 0x8D64, 0x8D64, 0x8D70, 0x8D70, 0x8DB3, 0x8DB3, 0x8EAB, 0x8EAB, 0x8ECA, 0x8ECA, 0x8F9B, 0x8F9B };
unsigned short unac_data165[] = { 0x8FB0, 0x8FB0, 0x8FB5, 0x8FB5, 0x9091, 0x9091, 0x9149, 0x9149, 0x91C6, 0x91C6, 0x91CC, 0x91CC, 0x91D1, 0x91D1, 0x9577, 0x9577, 0x9580, 0x9580, 0x961C, 0x961C, 0x96B6, 0x96B6, 0x96B9, 0x96B9, 0x96E8, 0x96E8, 0x9751, 0x9751, 0x975E, 0x975E, 0x9762, 0x9762 };
unsigned short unac_data166[] = { 0x9769, 0x9769, 0x97CB, 0x97CB, 0x97ED, 0x97ED, 0x97F3, 0x97F3, 0x9801, 0x9801, 0x98A8, 0x98A8, 0x98DB, 0x98DB, 0x98DF, 0x98DF, 0x9996, 0x9996, 0x9999, 0x9999, 0x99AC, 0x99AC, 0x9AA8, 0x9AA8, 0x9AD8, 0x9AD8, 0x9ADF, 0x9ADF, 0x9B25, 0x9B25, 0x9B2F, 0x9B2F };
unsigned short unac_data167[] = { 0x9B32, 0x9B32, 0x9B3C, 0x9B3C, 0x9B5A, 0x9B5A, 0x9CE5, 0x9CE5, 0x9E75, 0x9E75, 0x9E7F, 0x9E7F, 0x9EA5, 0x9EA5, 0x9EBB, 0x9EBB, 0x9EC3, 0x9EC3, 0x9ECD, 0x9ECD, 0x9ED1, 0x9ED1, 0x9EF9, 0x9EF9, 0x9EFD, 0x9EFD, 0x9F0E, 0x9F0E, 0x9F13, 0x9F13, 0x9F20, 0x9F20 };
unsigned short unac_data168[] = { 0x9F3B, 0x9F3B, 0x9F4A, 0x9F4A, 0x9F52, 0x9F52, 0x9F8D, 0x9F8D, 0x9F9C, 0x9F9C, 0x9FA0, 0x9FA0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data169[] = { 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data170[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x3012, 0x3012, 0xFFFF, 0xFFFF, 0x5341, 0x5341, 0x5344, 0x5344, 0x5345, 0x5345, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data171[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x304B, 0x304B, 0xFFFF, 0xFFFF, 0x304D, 0x304D, 0xFFFF, 0xFFFF };
unsigned short unac_data172[] = { 0x304F, 0x304F, 0xFFFF, 0xFFFF, 0x3051, 0x3051, 0xFFFF, 0xFFFF, 0x3053, 0x3053, 0xFFFF, 0xFFFF, 0x3055, 0x3055, 0xFFFF, 0xFFFF, 0x3057, 0x3057, 0xFFFF, 0xFFFF, 0x3059, 0x3059, 0xFFFF, 0xFFFF, 0x305B, 0x305B, 0xFFFF, 0xFFFF, 0x305D, 0x305D, 0xFFFF, 0xFFFF };
unsigned short unac_data173[] = { 0x305F, 0x305F, 0xFFFF, 0xFFFF, 0x3061, 0x3061, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x3064, 0x3064, 0xFFFF, 0xFFFF, 0x3066, 0x3066, 0xFFFF, 0xFFFF, 0x3068, 0x3068, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data174[] = { 0x306F, 0x306F, 0x306F, 0x306F, 0xFFFF, 0xFFFF, 0x3072, 0x3072, 0x3072, 0x3072, 0xFFFF, 0xFFFF, 0x3075, 0x3075, 0x3075, 0x3075, 0xFFFF, 0xFFFF, 0x3078, 0x3078, 0x3078, 0x3078, 0xFFFF, 0xFFFF, 0x307B, 0x307B, 0x307B, 0x307B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data175[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x3046, 0x3046, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0x309D, 0x309D, 0x3088, 0x308A, 0x3088, 0x308A };
unsigned short unac_data176[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x30AB, 0x30AB, 0xFFFF, 0xFFFF, 0x30AD, 0x30AD, 0xFFFF, 0xFFFF };
unsigned short unac_data177[] = { 0x30AF, 0x30AF, 0xFFFF, 0xFFFF, 0x30B1, 0x30B1, 0xFFFF, 0xFFFF, 0x30B3, 0x30B3, 0xFFFF, 0xFFFF, 0x30B5, 0x30B5, 0xFFFF, 0xFFFF, 0x30B7, 0x30B7, 0xFFFF, 0xFFFF, 0x30B9, 0x30B9, 0xFFFF, 0xFFFF, 0x30BB, 0x30BB, 0xFFFF, 0xFFFF, 0x30BD, 0x30BD, 0xFFFF, 0xFFFF };
unsigned short unac_data178[] = { 0x30BF, 0x30BF, 0xFFFF, 0xFFFF, 0x30C1, 0x30C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x30C4, 0x30C4, 0xFFFF, 0xFFFF, 0x30C6, 0x30C6, 0xFFFF, 0xFFFF, 0x30C8, 0x30C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data179[] = { 0x30CF, 0x30CF, 0x30CF, 0x30CF, 0xFFFF, 0xFFFF, 0x30D2, 0x30D2, 0x30D2, 0x30D2, 0xFFFF, 0xFFFF, 0x30D5, 0x30D5, 0x30D5, 0x30D5, 0xFFFF, 0xFFFF, 0x30D8, 0x30D8, 0x30D8, 0x30D8, 0xFFFF, 0xFFFF, 0x30DB, 0x30DB, 0x30DB, 0x30DB, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data180[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x30A6, 0x30A6, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x30EF, 0x30EF, 0x30F0, 0x30F0, 0x30F1, 0x30F1, 0x30F2, 0x30F2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x30FD, 0x30FD, 0x30B3, 0x30C8, 0x30B3, 0x30C8 };
unsigned short unac_data181[] = { 0xFFFF, 0xFFFF, 0x1100, 0x1100, 0x1101, 0x1101, 0x11AA, 0x11AA, 0x1102, 0x1102, 0x11AC, 0x11AC, 0x11AD, 0x11AD, 0x1103, 0x1103, 0x1104, 0x1104, 0x1105, 0x1105, 0x11B0, 0x11B0, 0x11B1, 0x11B1, 0x11B2, 0x11B2, 0x11B3, 0x11B3, 0x11B4, 0x11B4, 0x11B5, 0x11B5 };
unsigned short unac_data182[] = { 0x111A, 0x111A, 0x1106, 0x1106, 0x1107, 0x1107, 0x1108, 0x1108, 0x1121, 0x1121, 0x1109, 0x1109, 0x110A, 0x110A, 0x110B, 0x110B, 0x110C, 0x110C, 0x110D, 0x110D, 0x110E, 0x110E, 0x110F, 0x110F, 0x1110, 0x1110, 0x1111, 0x1111, 0x1112, 0x1112, 0x1161, 0x1161 };
unsigned short unac_data183[] = { 0x1162, 0x1162, 0x1163, 0x1163, 0x1164, 0x1164, 0x1165, 0x1165, 0x1166, 0x1166, 0x1167, 0x1167, 0x1168, 0x1168, 0x1169, 0x1169, 0x116A, 0x116A, 0x116B, 0x116B, 0x116C, 0x116C, 0x116D, 0x116D, 0x116E, 0x116E, 0x116F, 0x116F, 0x1170, 0x1170, 0x1171, 0x1171 };
unsigned short unac_data184[] = { 0x1172, 0x1172, 0x1173, 0x1173, 0x1174, 0x1174, 0x1175, 0x1175, 0x1160, 0x1160, 0x1114, 0x1114, 0x1115, 0x1115, 0x11C7, 0x11C7, 0x11C8, 0x11C8, 0x11CC, 0x11CC, 0x11CE, 0x11CE, 0x11D3, 0x11D3, 0x11D7, 0x11D7, 0x11D9, 0x11D9, 0x111C, 0x111C, 0x11DD, 0x11DD };
unsigned short unac_data185[] = { 0x11DF, 0x11DF, 0x111D, 0x111D, 0x111E, 0x111E, 0x1120, 0x1120, 0x1122, 0x1122, 0x1123, 0x1123, 0x1127, 0x1127, 0x1129, 0x1129, 0x112B, 0x112B, 0x112C, 0x112C, 0x112D, 0x112D, 0x112E, 0x112E, 0x112F, 0x112F, 0x1132, 0x1132, 0x1136, 0x1136, 0x1140, 0x1140 };
unsigned short unac_data186[] = { 0x1147, 0x1147, 0x114C, 0x114C, 0x11F1, 0x11F1, 0x11F2, 0x11F2, 0x1157, 0x1157, 0x1158, 0x1158, 0x1159, 0x1159, 0x1184, 0x1184, 0x1185, 0x1185, 0x1188, 0x1188, 0x1191, 0x1191, 0x1192, 0x1192, 0x1194, 0x1194, 0x119E, 0x119E, 0x11A1, 0x11A1, 0xFFFF, 0xFFFF };
unsigned short unac_data187[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x4E00, 0x4E00, 0x4E8C, 0x4E8C, 0x4E09, 0x4E09, 0x56DB, 0x56DB, 0x4E0A, 0x4E0A, 0x4E2D, 0x4E2D, 0x4E0B, 0x4E0B, 0x7532, 0x7532, 0x4E59, 0x4E59, 0x4E19, 0x4E19, 0x4E01, 0x4E01, 0x5929, 0x5929, 0x5730, 0x5730, 0x4EBA, 0x4EBA };
unsigned short unac_data188[] = { 0x0028, 0x1100, 0x0029, 0x0028, 0x1100, 0x0029, 0x0028, 0x1102, 0x0029, 0x0028, 0x1102, 0x0029, 0x0028, 0x1103, 0x0029, 0x0028, 0x1103, 0x0029, 0x0028, 0x1105, 0x0029, 0x0028, 0x1105, 0x0029, 0x0028, 0x1106, 0x0029, 0x0028, 0x1106, 0x0029, 0x0028, 0x1107, 0x0029, 0x0028, 0x1107, 0x0029, 0x0028, 0x1109, 0x0029, 0x0028, 0x1109, 0x0029, 0x0028, 0x110B, 0x0029, 0x0028, 0x110B, 0x0029, 0x0028, 0x110C, 0x0029, 0x0028, 0x110C, 0x0029, 0x0028, 0x110E, 0x0029, 0x0028, 0x110E, 0x0029, 0x0028, 0x110F, 0x0029, 0x0028, 0x110F, 0x0029, 0x0028, 0x1110, 0x0029, 0x0028, 0x1110, 0x0029, 0x0028, 0x1111, 0x0029, 0x0028, 0x1111, 0x0029, 0x0028, 0x1112, 0x0029, 0x0028, 0x1112, 0x0029, 0x0028, 0x1100, 0x1161, 0x0029, 0x0028, 0x1100, 0x1161, 0x0029, 0x0028, 0x1102, 0x1161, 0x0029, 0x0028, 0x1102, 0x1161, 0x0029 };
unsigned short unac_data189[] = { 0x0028, 0x1103, 0x1161, 0x0029, 0x0028, 0x1103, 0x1161, 0x0029, 0x0028, 0x1105, 0x1161, 0x0029, 0x0028, 0x1105, 0x1161, 0x0029, 0x0028, 0x1106, 0x1161, 0x0029, 0x0028, 0x1106, 0x1161, 0x0029, 0x0028, 0x1107, 0x1161, 0x0029, 0x0028, 0x1107, 0x1161, 0x0029, 0x0028, 0x1109, 0x1161, 0x0029, 0x0028, 0x1109, 0x1161, 0x0029, 0x0028, 0x110B, 0x1161, 0x0029, 0x0028, 0x110B, 0x1161, 0x0029, 0x0028, 0x110C, 0x1161, 0x0029, 0x0028, 0x110C, 0x1161, 0x0029, 0x0028, 0x110E, 0x1161, 0x0029, 0x0028, 0x110E, 0x1161, 0x0029, 0x0028, 0x110F, 0x1161, 0x0029, 0x0028, 0x110F, 0x1161, 0x0029, 0x0028, 0x1110, 0x1161, 0x0029, 0x0028, 0x1110, 0x1161, 0x0029, 0x0028, 0x1111, 0x1161, 0x0029, 0x0028, 0x1111, 0x1161, 0x0029, 0x0028, 0x1112, 0x1161, 0x0029, 0x0028, 0x1112, 0x1161, 0x0029, 0x0028, 0x110C, 0x116E, 0x0029, 0x0028, 0x110C, 0x116E, 0x0029, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data190[] = { 0x0028, 0x4E00, 0x0029, 0x0028, 0x4E00, 0x0029, 0x0028, 0x4E8C, 0x0029, 0x0028, 0x4E8C, 0x0029, 0x0028, 0x4E09, 0x0029, 0x0028, 0x4E09, 0x0029, 0x0028, 0x56DB, 0x0029, 0x0028, 0x56DB, 0x0029, 0x0028, 0x4E94, 0x0029, 0x0028, 0x4E94, 0x0029, 0x0028, 0x516D, 0x0029, 0x0028, 0x516D, 0x0029, 0x0028, 0x4E03, 0x0029, 0x0028, 0x4E03, 0x0029, 0x0028, 0x516B, 0x0029, 0x0028, 0x516B, 0x0029, 0x0028, 0x4E5D, 0x0029, 0x0028, 0x4E5D, 0x0029, 0x0028, 0x5341, 0x0029, 0x0028, 0x5341, 0x0029, 0x0028, 0x6708, 0x0029, 0x0028, 0x6708, 0x0029, 0x0028, 0x706B, 0x0029, 0x0028, 0x706B, 0x0029, 0x0028, 0x6C34, 0x0029, 0x0028, 0x6C34, 0x0029, 0x0028, 0x6728, 0x0029, 0x0028, 0x6728, 0x0029, 0x0028, 0x91D1, 0x0029, 0x0028, 0x91D1, 0x0029, 0x0028, 0x571F, 0x0029, 0x0028, 0x571F, 0x0029 };
unsigned short unac_data191[] = { 0x0028, 0x65E5, 0x0029, 0x0028, 0x65E5, 0x0029, 0x0028, 0x682A, 0x0029, 0x0028, 0x682A, 0x0029, 0x0028, 0x6709, 0x0029, 0x0028, 0x6709, 0x0029, 0x0028, 0x793E, 0x0029, 0x0028, 0x793E, 0x0029, 0x0028, 0x540D, 0x0029, 0x0028, 0x540D, 0x0029, 0x0028, 0x7279, 0x0029, 0x0028, 0x7279, 0x0029, 0x0028, 0x8CA1, 0x0029, 0x0028, 0x8CA1, 0x0029, 0x0028, 0x795D, 0x0029, 0x0028, 0x795D, 0x0029, 0x0028, 0x52B4, 0x0029, 0x0028, 0x52B4, 0x0029, 0x0028, 0x4EE3, 0x0029, 0x0028, 0x4EE3, 0x0029, 0x0028, 0x547C, 0x0029, 0x0028, 0x547C, 0x0029, 0x0028, 0x5B66, 0x0029, 0x0028, 0x5B66, 0x0029, 0x0028, 0x76E3, 0x0029, 0x0028, 0x76E3, 0x0029, 0x0028, 0x4F01, 0x0029, 0x0028, 0x4F01, 0x0029, 0x0028, 0x8CC7, 0x0029, 0x0028, 0x8CC7, 0x0029, 0x0028, 0x5354, 0x0029, 0x0028, 0x5354, 0x0029 };
unsigned short unac_data192[] = { 0x0028, 0x796D, 0x0029, 0x0028, 0x796D, 0x0029, 0x0028, 0x4F11, 0x0029, 0x0028, 0x4F11, 0x0029, 0x0028, 0x81EA, 0x0029, 0x0028, 0x81EA, 0x0029, 0x0028, 0x81F3, 0x0029, 0x0028, 0x81F3, 0x0029, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data193[] = { 0xFFFF, 0xFFFF, 0x0032, 0x0031, 0x0032, 0x0031, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0033, 0x0032, 0x0033, 0x0032, 0x0034, 0x0032, 0x0034, 0x0032, 0x0035, 0x0032, 0x0035, 0x0032, 0x0036, 0x0032, 0x0036, 0x0032, 0x0037, 0x0032, 0x0037, 0x0032, 0x0038, 0x0032, 0x0038, 0x0032, 0x0039, 0x0032, 0x0039, 0x0033, 0x0030, 0x0033, 0x0030, 0x0033, 0x0031, 0x0033, 0x0031, 0x0033, 0x0032, 0x0033, 0x0032, 0x0033, 0x0033, 0x0033, 0x0033, 0x0033, 0x0034, 0x0033, 0x0034, 0x0033, 0x0035, 0x0033, 0x0035 };
unsigned short unac_data194[] = { 0x1100, 0x1100, 0x1102, 0x1102, 0x1103, 0x1103, 0x1105, 0x1105, 0x1106, 0x1106, 0x1107, 0x1107, 0x1109, 0x1109, 0x110B, 0x110B, 0x110C, 0x110C, 0x110E, 0x110E, 0x110F, 0x110F, 0x1110, 0x1110, 0x1111, 0x1111, 0x1112, 0x1112, 0x1100, 0x1161, 0x1100, 0x1161, 0x1102, 0x1161, 0x1102, 0x1161 };
unsigned short unac_data195[] = { 0x1103, 0x1161, 0x1103, 0x1161, 0x1105, 0x1161, 0x1105, 0x1161, 0x1106, 0x1161, 0x1106, 0x1161, 0x1107, 0x1161, 0x1107, 0x1161, 0x1109, 0x1161, 0x1109, 0x1161, 0x110B, 0x1161, 0x110B, 0x1161, 0x110C, 0x1161, 0x110C, 0x1161, 0x110E, 0x1161, 0x110E, 0x1161, 0x110F, 0x1161, 0x110F, 0x1161, 0x1110, 0x1161, 0x1110, 0x1161, 0x1111, 0x1161, 0x1111, 0x1161, 0x1112, 0x1161, 0x1112, 0x1161, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data196[] = { 0x4E00, 0x4E00, 0x4E8C, 0x4E8C, 0x4E09, 0x4E09, 0x56DB, 0x56DB, 0x4E94, 0x4E94, 0x516D, 0x516D, 0x4E03, 0x4E03, 0x516B, 0x516B, 0x4E5D, 0x4E5D, 0x5341, 0x5341, 0x6708, 0x6708, 0x706B, 0x706B, 0x6C34, 0x6C34, 0x6728, 0x6728, 0x91D1, 0x91D1, 0x571F, 0x571F };
unsigned short unac_data197[] = { 0x65E5, 0x65E5, 0x682A, 0x682A, 0x6709, 0x6709, 0x793E, 0x793E, 0x540D, 0x540D, 0x7279, 0x7279, 0x8CA1, 0x8CA1, 0x795D, 0x795D, 0x52B4, 0x52B4, 0x79D8, 0x79D8, 0x7537, 0x7537, 0x5973, 0x5973, 0x9069, 0x9069, 0x512A, 0x512A, 0x5370, 0x5370, 0x6CE8, 0x6CE8 };
unsigned short unac_data198[] = { 0x9805, 0x9805, 0x4F11, 0x4F11, 0x5199, 0x5199, 0x6B63, 0x6B63, 0x4E0A, 0x4E0A, 0x4E2D, 0x4E2D, 0x4E0B, 0x4E0B, 0x5DE6, 0x5DE6, 0x53F3, 0x53F3, 0x533B, 0x533B, 0x5B97, 0x5B97, 0x5B66, 0x5B66, 0x76E3, 0x76E3, 0x4F01, 0x4F01, 0x8CC7, 0x8CC7, 0x5354, 0x5354 };
unsigned short unac_data199[] = { 0x591C, 0x591C, 0x0033, 0x0036, 0x0033, 0x0036, 0x0033, 0x0037, 0x0033, 0x0037, 0x0033, 0x0038, 0x0033, 0x0038, 0x0033, 0x0039, 0x0033, 0x0039, 0x0034, 0x0030, 0x0034, 0x0030, 0x0034, 0x0031, 0x0034, 0x0031, 0x0034, 0x0032, 0x0034, 0x0032, 0x0034, 0x0033, 0x0034, 0x0033, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0035, 0x0034, 0x0035, 0x0034, 0x0036, 0x0034, 0x0036, 0x0034, 0x0037, 0x0034, 0x0037, 0x0034, 0x0038, 0x0034, 0x0038, 0x0034, 0x0039, 0x0034, 0x0039, 0x0035, 0x0030, 0x0035, 0x0030 };
unsigned short unac_data200[] = { 0x0031, 0x6708, 0x0031, 0x6708, 0x0032, 0x6708, 0x0032, 0x6708, 0x0033, 0x6708, 0x0033, 0x6708, 0x0034, 0x6708, 0x0034, 0x6708, 0x0035, 0x6708, 0x0035, 0x6708, 0x0036, 0x6708, 0x0036, 0x6708, 0x0037, 0x6708, 0x0037, 0x6708, 0x0038, 0x6708, 0x0038, 0x6708, 0x0039, 0x6708, 0x0039, 0x6708, 0x0031, 0x0030, 0x6708, 0x0031, 0x0030, 0x6708, 0x0031, 0x0031, 0x6708, 0x0031, 0x0031, 0x6708, 0x0031, 0x0032, 0x6708, 0x0031, 0x0032, 0x6708, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data201[] = { 0x30A2, 0x30A2, 0x30A4, 0x30A4, 0x30A6, 0x30A6, 0x30A8, 0x30A8, 0x30AA, 0x30AA, 0x30AB, 0x30AB, 0x30AD, 0x30AD, 0x30AF, 0x30AF, 0x30B1, 0x30B1, 0x30B3, 0x30B3, 0x30B5, 0x30B5, 0x30B7, 0x30B7, 0x30B9, 0x30B9, 0x30BB, 0x30BB, 0x30BD, 0x30BD, 0x30BF, 0x30BF };
unsigned short unac_data202[] = { 0x30C1, 0x30C1, 0x30C4, 0x30C4, 0x30C6, 0x30C6, 0x30C8, 0x30C8, 0x30CA, 0x30CA, 0x30CB, 0x30CB, 0x30CC, 0x30CC, 0x30CD, 0x30CD, 0x30CE, 0x30CE, 0x30CF, 0x30CF, 0x30D2, 0x30D2, 0x30D5, 0x30D5, 0x30D8, 0x30D8, 0x30DB, 0x30DB, 0x30DE, 0x30DE, 0x30DF, 0x30DF };
unsigned short unac_data203[] = { 0x30E0, 0x30E0, 0x30E1, 0x30E1, 0x30E2, 0x30E2, 0x30E4, 0x30E4, 0x30E6, 0x30E6, 0x30E8, 0x30E8, 0x30E9, 0x30E9, 0x30EA, 0x30EA, 0x30EB, 0x30EB, 0x30EC, 0x30EC, 0x30ED, 0x30ED, 0x30EF, 0x30EF, 0x30F0, 0x30F0, 0x30F1, 0x30F1, 0x30F2, 0x30F2, 0xFFFF, 0xFFFF };
unsigned short unac_data204[] = { 0x30A2, 0x30FC, 0x30C8, 0x30CF, 0x30A2, 0x30FC, 0x30C8, 0x30CF, 0x30A2, 0x30EB, 0x30D5, 0x30A1, 0x30A2, 0x30EB, 0x30D5, 0x30A1, 0x30A2, 0x30F3, 0x30A2, 0x30D8, 0x30A2, 0x30F3, 0x30A2, 0x30D8, 0x30A2, 0x30FC, 0x30EB, 0x30A2, 0x30FC, 0x30EB, 0x30A4, 0x30CB, 0x30F3, 0x30AF, 0x30A4, 0x30CB, 0x30F3, 0x30AF, 0x30A4, 0x30F3, 0x30C1, 0x30A4, 0x30F3, 0x30C1, 0x30A6, 0x30A9, 0x30F3, 0x30A6, 0x30A9, 0x30F3, 0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C8, 0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C8, 0x30A8, 0x30FC, 0x30AB, 0x30FC, 0x30A8, 0x30FC, 0x30AB, 0x30FC, 0x30AA, 0x30F3, 0x30B9, 0x30AA, 0x30F3, 0x30B9, 0x30AA, 0x30FC, 0x30E0, 0x30AA, 0x30FC, 0x30E0, 0x30AB, 0x30A4, 0x30EA, 0x30AB, 0x30A4, 0x30EA, 0x30AB, 0x30E9, 0x30C3, 0x30C8, 0x30AB, 0x30E9, 0x30C3, 0x30C8, 0x30AB, 0x30ED, 0x30EA, 0x30FC, 0x30AB, 0x30ED, 0x30EA, 0x30FC, 0x30ED, 0x30F3, 0x30AB, 0x30ED, 0x30F3, 0x30AB, 0x30F3, 0x30DE, 0x30AB, 0x30F3, 0x30DE, 0x30AB };
unsigned short unac_data205[] = { 0x30AD, 0x30AB, 0x30AD, 0x30AB, 0x30CB, 0x30FC, 0x30AD, 0x30CB, 0x30FC, 0x30AD, 0x30AD, 0x30E5, 0x30EA, 0x30FC, 0x30AD, 0x30E5, 0x30EA, 0x30FC, 0x30EB, 0x30FC, 0x30AD, 0x30BF, 0x30EB, 0x30FC, 0x30AD, 0x30BF, 0x30AD, 0x30ED, 0x30AD, 0x30ED, 0x30AD, 0x30ED, 0x30E9, 0x30E0, 0x30AF, 0x30AD, 0x30ED, 0x30E9, 0x30E0, 0x30AF, 0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8, 0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8, 0x30E9, 0x30E0, 0x30AF, 0x30E9, 0x30E0, 0x30AF, 0x30E9, 0x30E0, 0x30C8, 0x30F3, 0x30AF, 0x30E9, 0x30E0, 0x30C8, 0x30F3, 0x30AF, 0x30AF, 0x30EB, 0x30A4, 0x30ED, 0x30BB, 0x30AF, 0x30EB, 0x30A4, 0x30ED, 0x30BB, 0x30AF, 0x30ED, 0x30FC, 0x30CD, 0x30AF, 0x30ED, 0x30FC, 0x30CD, 0x30B1, 0x30FC, 0x30B9, 0x30B1, 0x30FC, 0x30B9, 0x30B3, 0x30EB, 0x30CA, 0x30B3, 0x30EB, 0x30CA, 0x30B3, 0x30FC, 0x30DB, 0x30B3, 0x30FC, 0x30DB, 0x30B5, 0x30A4, 0x30AF, 0x30EB, 0x30B5, 0x30A4, 0x30AF, 0x30EB };
unsigned short unac_data206[] = { 0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0, 0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0, 0x30B7, 0x30EA, 0x30F3, 0x30AF, 0x30B7, 0x30EA, 0x30F3, 0x30AF, 0x30BB, 0x30F3, 0x30C1, 0x30BB, 0x30F3, 0x30C1, 0x30BB, 0x30F3, 0x30C8, 0x30BB, 0x30F3, 0x30C8, 0x30FC, 0x30B9, 0x30BF, 0x30FC, 0x30B9, 0x30BF, 0x30B7, 0x30C6, 0x30B7, 0x30C6, 0x30EB, 0x30C8, 0x30EB, 0x30C8, 0x30C8, 0x30F3, 0x30C8, 0x30F3, 0x30CA, 0x30CE, 0x30CA, 0x30CE, 0x30CE, 0x30C3, 0x30C8, 0x30CE, 0x30C3, 0x30C8, 0x30CF, 0x30A4, 0x30C4, 0x30CF, 0x30A4, 0x30C4, 0x30FC, 0x30BB, 0x30F3, 0x30C8, 0x30CF, 0x30FC, 0x30BB, 0x30F3, 0x30C8, 0x30CF, 0x30FC, 0x30C4, 0x30CF, 0x30FC, 0x30C4, 0x30CF, 0x30FC, 0x30EC, 0x30EB, 0x30CF, 0x30FC, 0x30EC, 0x30EB, 0x30CF, 0x30A2, 0x30B9, 0x30C8, 0x30EB, 0x30D2, 0x30A2, 0x30B9, 0x30C8, 0x30EB, 0x30D2, 0x30AF, 0x30EB, 0x30D2, 0x30AF, 0x30EB, 0x30D2 };
unsigned short unac_data207[] = { 0x30B3, 0x30D2, 0x30B3, 0x30D2, 0x30EB, 0x30D2, 0x30EB, 0x30D2, 0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C8, 0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C8, 0x30D5, 0x30A3, 0x30FC, 0x30C8, 0x30D5, 0x30A3, 0x30FC, 0x30C8, 0x30C3, 0x30B7, 0x30A7, 0x30EB, 0x30D5, 0x30C3, 0x30B7, 0x30A7, 0x30EB, 0x30D5, 0x30D5, 0x30E9, 0x30F3, 0x30D5, 0x30E9, 0x30F3, 0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB, 0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB, 0x30BD, 0x30D8, 0x30BD, 0x30D8, 0x30CB, 0x30D2, 0x30D8, 0x30CB, 0x30D2, 0x30D8, 0x30D8, 0x30EB, 0x30C4, 0x30D8, 0x30EB, 0x30C4, 0x30F3, 0x30B9, 0x30D8, 0x30F3, 0x30B9, 0x30D8, 0x30FC, 0x30D8, 0x30B7, 0x30FC, 0x30D8, 0x30B7, 0x30FC, 0x30BF, 0x30D8, 0x30FC, 0x30BF, 0x30D8, 0x30A4, 0x30F3, 0x30C8, 0x30DB, 0x30A4, 0x30F3, 0x30C8, 0x30DB, 0x30EB, 0x30C8, 0x30DB, 0x30EB, 0x30C8, 0x30DB, 0x30DB, 0x30F3, 0x30DB, 0x30F3 };
unsigned short unac_data208[] = { 0x30F3, 0x30DB, 0x30C8, 0x30F3, 0x30DB, 0x30C8, 0x30DB, 0x30FC, 0x30EB, 0x30DB, 0x30FC, 0x30EB, 0x30DB, 0x30FC, 0x30F3, 0x30DB, 0x30FC, 0x30F3, 0x30DE, 0x30A4, 0x30AF, 0x30ED, 0x30DE, 0x30A4, 0x30AF, 0x30ED, 0x30DE, 0x30A4, 0x30EB, 0x30DE, 0x30A4, 0x30EB, 0x30DE, 0x30C3, 0x30CF, 0x30DE, 0x30C3, 0x30CF, 0x30DE, 0x30EB, 0x30AF, 0x30DE, 0x30EB, 0x30AF, 0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3, 0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3, 0x30DF, 0x30AF, 0x30ED, 0x30F3, 0x30DF, 0x30AF, 0x30ED, 0x30F3, 0x30DF, 0x30EA, 0x30DF, 0x30EA, 0x30DF, 0x30EA, 0x30FC, 0x30EB, 0x30CF, 0x30DF, 0x30EA, 0x30FC, 0x30EB, 0x30CF, 0x30E1, 0x30AB, 0x30E1, 0x30AB, 0x30E1, 0x30C8, 0x30F3, 0x30AB, 0x30E1, 0x30C8, 0x30F3, 0x30AB, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0x30E4, 0x30FC, 0x30C8, 0x30E4, 0x30FC, 0x30C8, 0x30E4, 0x30FC, 0x30EB, 0x30E4, 0x30FC, 0x30EB };
unsigned short unac_data209[] = { 0x30E6, 0x30A2, 0x30F3, 0x30E6, 0x30A2, 0x30F3, 0x30EA, 0x30C3, 0x30C8, 0x30EB, 0x30EA, 0x30C3, 0x30C8, 0x30EB, 0x30EA, 0x30E9, 0x30EA, 0x30E9, 0x30EB, 0x30FC, 0x30D2, 0x30EB, 0x30FC, 0x30D2, 0x30EB, 0x30FC, 0x30EB, 0x30D5, 0x30EB, 0x30FC, 0x30EB, 0x30D5, 0x30EC, 0x30E0, 0x30EC, 0x30E0, 0x30EC, 0x30F3, 0x30C8, 0x30F3, 0x30B1, 0x30EC, 0x30F3, 0x30C8, 0x30F3, 0x30B1, 0x30EF, 0x30C3, 0x30C8, 0x30EF, 0x30C3, 0x30C8, 0x0030, 0x70B9, 0x0030, 0x70B9, 0x0031, 0x70B9, 0x0031, 0x70B9, 0x0032, 0x70B9, 0x0032, 0x70B9, 0x0033, 0x70B9, 0x0033, 0x70B9, 0x0034, 0x70B9, 0x0034, 0x70B9, 0x0035, 0x70B9, 0x0035, 0x70B9, 0x0036, 0x70B9, 0x0036, 0x70B9, 0x0037, 0x70B9, 0x0037, 0x70B9 };
unsigned short unac_data210[] = { 0x0038, 0x70B9, 0x0038, 0x70B9, 0x0039, 0x70B9, 0x0039, 0x70B9, 0x0031, 0x0030, 0x70B9, 0x0031, 0x0030, 0x70B9, 0x0031, 0x0031, 0x70B9, 0x0031, 0x0031, 0x70B9, 0x0031, 0x0032, 0x70B9, 0x0031, 0x0032, 0x70B9, 0x0031, 0x0033, 0x70B9, 0x0031, 0x0033, 0x70B9, 0x0031, 0x0034, 0x70B9, 0x0031, 0x0034, 0x70B9, 0x0031, 0x0035, 0x70B9, 0x0031, 0x0035, 0x70B9, 0x0031, 0x0036, 0x70B9, 0x0031, 0x0036, 0x70B9, 0x0031, 0x0037, 0x70B9, 0x0031, 0x0037, 0x70B9, 0x0031, 0x0038, 0x70B9, 0x0031, 0x0038, 0x70B9, 0x0031, 0x0039, 0x70B9, 0x0031, 0x0039, 0x70B9, 0x0032, 0x0030, 0x70B9, 0x0032, 0x0030, 0x70B9, 0x0032, 0x0031, 0x70B9, 0x0032, 0x0031, 0x70B9, 0x0032, 0x0032, 0x70B9, 0x0032, 0x0032, 0x70B9, 0x0032, 0x0033, 0x70B9, 0x0032, 0x0033, 0x70B9 };
unsigned short unac_data211[] = { 0x0032, 0x0034, 0x70B9, 0x0032, 0x0034, 0x70B9, 0x0068, 0x0050, 0x0061, 0x0068, 0x0070, 0x0061, 0x0064, 0x0061, 0x0064, 0x0061, 0x0041, 0x0055, 0x0061, 0x0075, 0x0062, 0x0061, 0x0072, 0x0062, 0x0061, 0x0072, 0x006F, 0x0056, 0x006F, 0x0076, 0x0070, 0x0063, 0x0070, 0x0063, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x5E73, 0x6210, 0x5E73, 0x6210, 0x662D, 0x548C, 0x662D, 0x548C, 0x5927, 0x6B63, 0x5927, 0x6B63, 0x660E, 0x6CBB, 0x660E, 0x6CBB, 0x682A, 0x5F0F, 0x4F1A, 0x793E, 0x682A, 0x5F0F, 0x4F1A, 0x793E };
unsigned short unac_data212[] = { 0x0070, 0x0041, 0x0070, 0x0061, 0x006E, 0x0041, 0x006E, 0x0061, 0x03BC, 0x0041, 0x03BC, 0x0061, 0x006D, 0x0041, 0x006D, 0x0061, 0x006B, 0x0041, 0x006B, 0x0061, 0x004B, 0x0042, 0x006B, 0x0062, 0x004D, 0x0042, 0x006D, 0x0062, 0x0047, 0x0042, 0x0067, 0x0062, 0x0063, 0x0061, 0x006C, 0x0063, 0x0061, 0x006C, 0x006B, 0x0063, 0x0061, 0x006C, 0x006B, 0x0063, 0x0061, 0x006C, 0x0070, 0x0046, 0x0070, 0x0066, 0x006E, 0x0046, 0x006E, 0x0066, 0x03BC, 0x0046, 0x03BC, 0x0066, 0x03BC, 0x0067, 0x03BC, 0x0067, 0x006D, 0x0067, 0x006D, 0x0067, 0x006B, 0x0067, 0x006B, 0x0067 };
unsigned short unac_data213[] = { 0x0048, 0x007A, 0x0068, 0x007A, 0x006B, 0x0048, 0x007A, 0x006B, 0x0068, 0x007A, 0x004D, 0x0048, 0x007A, 0x006D, 0x0068, 0x007A, 0x0047, 0x0048, 0x007A, 0x0067, 0x0068, 0x007A, 0x0054, 0x0048, 0x007A, 0x0074, 0x0068, 0x007A, 0x03BC, 0x006C, 0x03BC, 0x006C, 0x006D, 0x006C, 0x006D, 0x006C, 0x0064, 0x006C, 0x0064, 0x006C, 0x006B, 0x006C, 0x006B, 0x006C, 0x0066, 0x006D, 0x0066, 0x006D, 0x006E, 0x006D, 0x006E, 0x006D, 0x03BC, 0x006D, 0x03BC, 0x006D, 0x006D, 0x006D, 0x006D, 0x006D, 0x0063, 0x006D, 0x0063, 0x006D, 0x006B, 0x006D, 0x006B, 0x006D, 0x006D, 0x006D, 0x0032, 0x006D, 0x006D, 0x0032 };
unsigned short unac_data214[] = { 0x0063, 0x006D, 0x0032, 0x0063, 0x006D, 0x0032, 0x006D, 0x0032, 0x006D, 0x0032, 0x006B, 0x006D, 0x0032, 0x006B, 0x006D, 0x0032, 0x006D, 0x006D, 0x0033, 0x006D, 0x006D, 0x0033, 0x0063, 0x006D, 0x0033, 0x0063, 0x006D, 0x0033, 0x006D, 0x0033, 0x006D, 0x0033, 0x006B, 0x006D, 0x0033, 0x006B, 0x006D, 0x0033, 0x006D, 0x2215, 0x0073, 0x006D, 0x2215, 0x0073, 0x006D, 0x2215, 0x0073, 0x0032, 0x006D, 0x2215, 0x0073, 0x0032, 0x0050, 0x0061, 0x0070, 0x0061, 0x006B, 0x0050, 0x0061, 0x006B, 0x0070, 0x0061, 0x004D, 0x0050, 0x0061, 0x006D, 0x0070, 0x0061, 0x0047, 0x0050, 0x0061, 0x0067, 0x0070, 0x0061, 0x0072, 0x0061, 0x0064, 0x0072, 0x0061, 0x0064, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0032, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0032 };
unsigned short unac_data215[] = { 0x0070, 0x0073, 0x0070, 0x0073, 0x006E, 0x0073, 0x006E, 0x0073, 0x03BC, 0x0073, 0x03BC, 0x0073, 0x006D, 0x0073, 0x006D, 0x0073, 0x0070, 0x0056, 0x0070, 0x0076, 0x006E, 0x0056, 0x006E, 0x0076, 0x03BC, 0x0056, 0x03BC, 0x0076, 0x006D, 0x0056, 0x006D, 0x0076, 0x006B, 0x0056, 0x006B, 0x0076, 0x004D, 0x0056, 0x006D, 0x0076, 0x0070, 0x0057, 0x0070, 0x0077, 0x006E, 0x0057, 0x006E, 0x0077, 0x03BC, 0x0057, 0x03BC, 0x0077, 0x006D, 0x0057, 0x006D, 0x0077, 0x006B, 0x0057, 0x006B, 0x0077, 0x004D, 0x0057, 0x006D, 0x0077 };
unsigned short unac_data216[] = { 0x006B, 0x03A9, 0x006B, 0x03C9, 0x004D, 0x03A9, 0x006D, 0x03C9, 0x0061, 0x002E, 0x006D, 0x002E, 0x0061, 0x002E, 0x006D, 0x002E, 0x0042, 0x0071, 0x0062, 0x0071, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0064, 0x0063, 0x0064, 0x0043, 0x2215, 0x006B, 0x0067, 0x0063, 0x2215, 0x006B, 0x0067, 0x0043, 0x006F, 0x002E, 0x0063, 0x006F, 0x002E, 0x0064, 0x0042, 0x0064, 0x0062, 0x0047, 0x0079, 0x0067, 0x0079, 0x0068, 0x0061, 0x0068, 0x0061, 0x0048, 0x0050, 0x0068, 0x0070, 0x0069, 0x006E, 0x0069, 0x006E, 0x004B, 0x004B, 0x006B, 0x006B, 0x004B, 0x004D, 0x006B, 0x006D, 0x006B, 0x0074, 0x006B, 0x0074 };
unsigned short unac_data217[] = { 0x006C, 0x006D, 0x006C, 0x006D, 0x006C, 0x006E, 0x006C, 0x006E, 0x006C, 0x006F, 0x0067, 0x006C, 0x006F, 0x0067, 0x006C, 0x0078, 0x006C, 0x0078, 0x006D, 0x0062, 0x006D, 0x0062, 0x006D, 0x0069, 0x006C, 0x006D, 0x0069, 0x006C, 0x006D, 0x006F, 0x006C, 0x006D, 0x006F, 0x006C, 0x0050, 0x0048, 0x0070, 0x0068, 0x0070, 0x002E, 0x006D, 0x002E, 0x0070, 0x002E, 0x006D, 0x002E, 0x0050, 0x0050, 0x004D, 0x0070, 0x0070, 0x006D, 0x0050, 0x0052, 0x0070, 0x0072, 0x0073, 0x0072, 0x0073, 0x0072, 0x0053, 0x0076, 0x0073, 0x0076, 0x0057, 0x0062, 0x0077, 0x0062, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data218[] = { 0x0031, 0x65E5, 0x0031, 0x65E5, 0x0032, 0x65E5, 0x0032, 0x65E5, 0x0033, 0x65E5, 0x0033, 0x65E5, 0x0034, 0x65E5, 0x0034, 0x65E5, 0x0035, 0x65E5, 0x0035, 0x65E5, 0x0036, 0x65E5, 0x0036, 0x65E5, 0x0037, 0x65E5, 0x0037, 0x65E5, 0x0038, 0x65E5, 0x0038, 0x65E5, 0x0039, 0x65E5, 0x0039, 0x65E5, 0x0031, 0x0030, 0x65E5, 0x0031, 0x0030, 0x65E5, 0x0031, 0x0031, 0x65E5, 0x0031, 0x0031, 0x65E5, 0x0031, 0x0032, 0x65E5, 0x0031, 0x0032, 0x65E5, 0x0031, 0x0033, 0x65E5, 0x0031, 0x0033, 0x65E5, 0x0031, 0x0034, 0x65E5, 0x0031, 0x0034, 0x65E5, 0x0031, 0x0035, 0x65E5, 0x0031, 0x0035, 0x65E5, 0x0031, 0x0036, 0x65E5, 0x0031, 0x0036, 0x65E5 };
unsigned short unac_data219[] = { 0x0031, 0x0037, 0x65E5, 0x0031, 0x0037, 0x65E5, 0x0031, 0x0038, 0x65E5, 0x0031, 0x0038, 0x65E5, 0x0031, 0x0039, 0x65E5, 0x0031, 0x0039, 0x65E5, 0x0032, 0x0030, 0x65E5, 0x0032, 0x0030, 0x65E5, 0x0032, 0x0031, 0x65E5, 0x0032, 0x0031, 0x65E5, 0x0032, 0x0032, 0x65E5, 0x0032, 0x0032, 0x65E5, 0x0032, 0x0033, 0x65E5, 0x0032, 0x0033, 0x65E5, 0x0032, 0x0034, 0x65E5, 0x0032, 0x0034, 0x65E5, 0x0032, 0x0035, 0x65E5, 0x0032, 0x0035, 0x65E5, 0x0032, 0x0036, 0x65E5, 0x0032, 0x0036, 0x65E5, 0x0032, 0x0037, 0x65E5, 0x0032, 0x0037, 0x65E5, 0x0032, 0x0038, 0x65E5, 0x0032, 0x0038, 0x65E5, 0x0032, 0x0039, 0x65E5, 0x0032, 0x0039, 0x65E5, 0x0033, 0x0030, 0x65E5, 0x0033, 0x0030, 0x65E5, 0x0033, 0x0031, 0x65E5, 0x0033, 0x0031, 0x65E5, 0xFFFF, 0xFFFF };
unsigned short unac_data220[] = { 0x8C48, 0x8C48, 0x66F4, 0x66F4, 0x8ECA, 0x8ECA, 0x8CC8, 0x8CC8, 0x6ED1, 0x6ED1, 0x4E32, 0x4E32, 0x53E5, 0x53E5, 0x9F9C, 0x9F9C, 0x9F9C, 0x9F9C, 0x5951, 0x5951, 0x91D1, 0x91D1, 0x5587, 0x5587, 0x5948, 0x5948, 0x61F6, 0x61F6, 0x7669, 0x7669, 0x7F85, 0x7F85 };
unsigned short unac_data221[] = { 0x863F, 0x863F, 0x87BA, 0x87BA, 0x88F8, 0x88F8, 0x908F, 0x908F, 0x6A02, 0x6A02, 0x6D1B, 0x6D1B, 0x70D9, 0x70D9, 0x73DE, 0x73DE, 0x843D, 0x843D, 0x916A, 0x916A, 0x99F1, 0x99F1, 0x4E82, 0x4E82, 0x5375, 0x5375, 0x6B04, 0x6B04, 0x721B, 0x721B, 0x862D, 0x862D };
unsigned short unac_data222[] = { 0x9E1E, 0x9E1E, 0x5D50, 0x5D50, 0x6FEB, 0x6FEB, 0x85CD, 0x85CD, 0x8964, 0x8964, 0x62C9, 0x62C9, 0x81D8, 0x81D8, 0x881F, 0x881F, 0x5ECA, 0x5ECA, 0x6717, 0x6717, 0x6D6A, 0x6D6A, 0x72FC, 0x72FC, 0x90CE, 0x90CE, 0x4F86, 0x4F86, 0x51B7, 0x51B7, 0x52DE, 0x52DE };
unsigned short unac_data223[] = { 0x64C4, 0x64C4, 0x6AD3, 0x6AD3, 0x7210, 0x7210, 0x76E7, 0x76E7, 0x8001, 0x8001, 0x8606, 0x8606, 0x865C, 0x865C, 0x8DEF, 0x8DEF, 0x9732, 0x9732, 0x9B6F, 0x9B6F, 0x9DFA, 0x9DFA, 0x788C, 0x788C, 0x797F, 0x797F, 0x7DA0, 0x7DA0, 0x83C9, 0x83C9, 0x9304, 0x9304 };
unsigned short unac_data224[] = { 0x9E7F, 0x9E7F, 0x8AD6, 0x8AD6, 0x58DF, 0x58DF, 0x5F04, 0x5F04, 0x7C60, 0x7C60, 0x807E, 0x807E, 0x7262, 0x7262, 0x78CA, 0x78CA, 0x8CC2, 0x8CC2, 0x96F7, 0x96F7, 0x58D8, 0x58D8, 0x5C62, 0x5C62, 0x6A13, 0x6A13, 0x6DDA, 0x6DDA, 0x6F0F, 0x6F0F, 0x7D2F, 0x7D2F };
unsigned short unac_data225[] = { 0x7E37, 0x7E37, 0x964B, 0x964B, 0x52D2, 0x52D2, 0x808B, 0x808B, 0x51DC, 0x51DC, 0x51CC, 0x51CC, 0x7A1C, 0x7A1C, 0x7DBE, 0x7DBE, 0x83F1, 0x83F1, 0x9675, 0x9675, 0x8B80, 0x8B80, 0x62CF, 0x62CF, 0x6A02, 0x6A02, 0x8AFE, 0x8AFE, 0x4E39, 0x4E39, 0x5BE7, 0x5BE7 };
unsigned short unac_data226[] = { 0x6012, 0x6012, 0x7387, 0x7387, 0x7570, 0x7570, 0x5317, 0x5317, 0x78FB, 0x78FB, 0x4FBF, 0x4FBF, 0x5FA9, 0x5FA9, 0x4E0D, 0x4E0D, 0x6CCC, 0x6CCC, 0x6578, 0x6578, 0x7D22, 0x7D22, 0x53C3, 0x53C3, 0x585E, 0x585E, 0x7701, 0x7701, 0x8449, 0x8449, 0x8AAA, 0x8AAA };
unsigned short unac_data227[] = { 0x6BBA, 0x6BBA, 0x8FB0, 0x8FB0, 0x6C88, 0x6C88, 0x62FE, 0x62FE, 0x82E5, 0x82E5, 0x63A0, 0x63A0, 0x7565, 0x7565, 0x4EAE, 0x4EAE, 0x5169, 0x5169, 0x51C9, 0x51C9, 0x6881, 0x6881, 0x7CE7, 0x7CE7, 0x826F, 0x826F, 0x8AD2, 0x8AD2, 0x91CF, 0x91CF, 0x52F5, 0x52F5 };
unsigned short unac_data228[] = { 0x5442, 0x5442, 0x5973, 0x5973, 0x5EEC, 0x5EEC, 0x65C5, 0x65C5, 0x6FFE, 0x6FFE, 0x792A, 0x792A, 0x95AD, 0x95AD, 0x9A6A, 0x9A6A, 0x9E97, 0x9E97, 0x9ECE, 0x9ECE, 0x529B, 0x529B, 0x66C6, 0x66C6, 0x6B77, 0x6B77, 0x8F62, 0x8F62, 0x5E74, 0x5E74, 0x6190, 0x6190 };
unsigned short unac_data229[] = { 0x6200, 0x6200, 0x649A, 0x649A, 0x6F23, 0x6F23, 0x7149, 0x7149, 0x7489, 0x7489, 0x79CA, 0x79CA, 0x7DF4, 0x7DF4, 0x806F, 0x806F, 0x8F26, 0x8F26, 0x84EE, 0x84EE, 0x9023, 0x9023, 0x934A, 0x934A, 0x5217, 0x5217, 0x52A3, 0x52A3, 0x54BD, 0x54BD, 0x70C8, 0x70C8 };
unsigned short unac_data230[] = { 0x88C2, 0x88C2, 0x8AAA, 0x8AAA, 0x5EC9, 0x5EC9, 0x5FF5, 0x5FF5, 0x637B, 0x637B, 0x6BAE, 0x6BAE, 0x7C3E, 0x7C3E, 0x7375, 0x7375, 0x4EE4, 0x4EE4, 0x56F9, 0x56F9, 0x5BE7, 0x5BE7, 0x5DBA, 0x5DBA, 0x601C, 0x601C, 0x73B2, 0x73B2, 0x7469, 0x7469, 0x7F9A, 0x7F9A };
unsigned short unac_data231[] = { 0x8046, 0x8046, 0x9234, 0x9234, 0x96F6, 0x96F6, 0x9748, 0x9748, 0x9818, 0x9818, 0x4F8B, 0x4F8B, 0x79AE, 0x79AE, 0x91B4, 0x91B4, 0x96B8, 0x96B8, 0x60E1, 0x60E1, 0x4E86, 0x4E86, 0x50DA, 0x50DA, 0x5BEE, 0x5BEE, 0x5C3F, 0x5C3F, 0x6599, 0x6599, 0x6A02, 0x6A02 };
unsigned short unac_data232[] = { 0x71CE, 0x71CE, 0x7642, 0x7642, 0x84FC, 0x84FC, 0x907C, 0x907C, 0x9F8D, 0x9F8D, 0x6688, 0x6688, 0x962E, 0x962E, 0x5289, 0x5289, 0x677B, 0x677B, 0x67F3, 0x67F3, 0x6D41, 0x6D41, 0x6E9C, 0x6E9C, 0x7409, 0x7409, 0x7559, 0x7559, 0x786B, 0x786B, 0x7D10, 0x7D10 };
unsigned short unac_data233[] = { 0x985E, 0x985E, 0x516D, 0x516D, 0x622E, 0x622E, 0x9678, 0x9678, 0x502B, 0x502B, 0x5D19, 0x5D19, 0x6DEA, 0x6DEA, 0x8F2A, 0x8F2A, 0x5F8B, 0x5F8B, 0x6144, 0x6144, 0x6817, 0x6817, 0x7387, 0x7387, 0x9686, 0x9686, 0x5229, 0x5229, 0x540F, 0x540F, 0x5C65, 0x5C65 };
unsigned short unac_data234[] = { 0x6613, 0x6613, 0x674E, 0x674E, 0x68A8, 0x68A8, 0x6CE5, 0x6CE5, 0x7406, 0x7406, 0x75E2, 0x75E2, 0x7F79, 0x7F79, 0x88CF, 0x88CF, 0x88E1, 0x88E1, 0x91CC, 0x91CC, 0x96E2, 0x96E2, 0x533F, 0x533F, 0x6EBA, 0x6EBA, 0x541D, 0x541D, 0x71D0, 0x71D0, 0x7498, 0x7498 };
unsigned short unac_data235[] = { 0x85FA, 0x85FA, 0x96A3, 0x96A3, 0x9C57, 0x9C57, 0x9E9F, 0x9E9F, 0x6797, 0x6797, 0x6DCB, 0x6DCB, 0x81E8, 0x81E8, 0x7ACB, 0x7ACB, 0x7B20, 0x7B20, 0x7C92, 0x7C92, 0x72C0, 0x72C0, 0x7099, 0x7099, 0x8B58, 0x8B58, 0x4EC0, 0x4EC0, 0x8336, 0x8336, 0x523A, 0x523A };
unsigned short unac_data236[] = { 0x5207, 0x5207, 0x5EA6, 0x5EA6, 0x62D3, 0x62D3, 0x7CD6, 0x7CD6, 0x5B85, 0x5B85, 0x6D1E, 0x6D1E, 0x66B4, 0x66B4, 0x8F3B, 0x8F3B, 0x884C, 0x884C, 0x964D, 0x964D, 0x898B, 0x898B, 0x5ED3, 0x5ED3, 0x5140, 0x5140, 0x55C0, 0x55C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data237[] = { 0x585A, 0x585A, 0xFFFF, 0xFFFF, 0x6674, 0x6674, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x51DE, 0x51DE, 0x732A, 0x732A, 0x76CA, 0x76CA, 0x793C, 0x793C, 0x795E, 0x795E, 0x7965, 0x7965, 0x798F, 0x798F, 0x9756, 0x9756, 0x7CBE, 0x7CBE, 0x7FBD, 0x7FBD, 0xFFFF, 0xFFFF };
unsigned short unac_data238[] = { 0x8612, 0x8612, 0xFFFF, 0xFFFF, 0x8AF8, 0x8AF8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x9038, 0x9038, 0x90FD, 0x90FD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x98EF, 0x98EF, 0x98FC, 0x98FC, 0x9928, 0x9928, 0x9DB4, 0x9DB4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data239[] = { 0x4FAE, 0x4FAE, 0x50E7, 0x50E7, 0x514D, 0x514D, 0x52C9, 0x52C9, 0x52E4, 0x52E4, 0x5351, 0x5351, 0x559D, 0x559D, 0x5606, 0x5606, 0x5668, 0x5668, 0x5840, 0x5840, 0x58A8, 0x58A8, 0x5C64, 0x5C64, 0x5C6E, 0x5C6E, 0x6094, 0x6094, 0x6168, 0x6168, 0x618E, 0x618E };
unsigned short unac_data240[] = { 0x61F2, 0x61F2, 0x654F, 0x654F, 0x65E2, 0x65E2, 0x6691, 0x6691, 0x6885, 0x6885, 0x6D77, 0x6D77, 0x6E1A, 0x6E1A, 0x6F22, 0x6F22, 0x716E, 0x716E, 0x722B, 0x722B, 0x7422, 0x7422, 0x7891, 0x7891, 0x793E, 0x793E, 0x7949, 0x7949, 0x7948, 0x7948, 0x7950, 0x7950 };
unsigned short unac_data241[] = { 0x7956, 0x7956, 0x795D, 0x795D, 0x798D, 0x798D, 0x798E, 0x798E, 0x7A40, 0x7A40, 0x7A81, 0x7A81, 0x7BC0, 0x7BC0, 0x7DF4, 0x7DF4, 0x7E09, 0x7E09, 0x7E41, 0x7E41, 0x7F72, 0x7F72, 0x8005, 0x8005, 0x81ED, 0x81ED, 0x8279, 0x8279, 0x8279, 0x8279, 0x8457, 0x8457 };
unsigned short unac_data242[] = { 0x8910, 0x8910, 0x8996, 0x8996, 0x8B01, 0x8B01, 0x8B39, 0x8B39, 0x8CD3, 0x8CD3, 0x8D08, 0x8D08, 0x8FB6, 0x8FB6, 0x9038, 0x9038, 0x96E3, 0x96E3, 0x97FF, 0x97FF, 0x983B, 0x983B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data243[] = { 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0069, 0x0066, 0x0069, 0x0066, 0x006C, 0x0066, 0x006C, 0x0066, 0x0066, 0x0069, 0x0066, 0x0066, 0x0069, 0x0066, 0x0066, 0x006C, 0x0066, 0x0066, 0x006C, 0x0074, 0x0073, 0x0074, 0x0073, 0x0073, 0x0074, 0x0073, 0x0074, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data244[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0574, 0x0576, 0x0574, 0x0576, 0x0574, 0x0565, 0x0574, 0x0565, 0x0574, 0x056B, 0x0574, 0x056B, 0x057E, 0x0576, 0x057E, 0x0576, 0x0574, 0x056D, 0x0574, 0x056D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x05D9, 0x05D9, 0xFFFF, 0xFFFF, 0x05F2, 0x05F2 };
unsigned short unac_data245[] = { 0x05E2, 0x05E2, 0x05D0, 0x05D0, 0x05D3, 0x05D3, 0x05D4, 0x05D4, 0x05DB, 0x05DB, 0x05DC, 0x05DC, 0x05DD, 0x05DD, 0x05E8, 0x05E8, 0x05EA, 0x05EA, 0x002B, 0x002B, 0x05E9, 0x05E9, 0x05E9, 0x05E9, 0x05E9, 0x05E9, 0x05E9, 0x05E9, 0x05D0, 0x05D0, 0x05D0, 0x05D0 };
unsigned short unac_data246[] = { 0x05D0, 0x05D0, 0x05D1, 0x05D1, 0x05D2, 0x05D2, 0x05D3, 0x05D3, 0x05D4, 0x05D4, 0x05D5, 0x05D5, 0x05D6, 0x05D6, 0xFFFF, 0xFFFF, 0x05D8, 0x05D8, 0x05D9, 0x05D9, 0x05DA, 0x05DA, 0x05DB, 0x05DB, 0x05DC, 0x05DC, 0xFFFF, 0xFFFF, 0x05DE, 0x05DE, 0xFFFF, 0xFFFF };
unsigned short unac_data247[] = { 0x05E0, 0x05E0, 0x05E1, 0x05E1, 0xFFFF, 0xFFFF, 0x05E3, 0x05E3, 0x05E4, 0x05E4, 0xFFFF, 0xFFFF, 0x05E6, 0x05E6, 0x05E7, 0x05E7, 0x05E8, 0x05E8, 0x05E9, 0x05E9, 0x05EA, 0x05EA, 0x05D5, 0x05D5, 0x05D1, 0x05D1, 0x05DB, 0x05DB, 0x05E4, 0x05E4, 0x05D0, 0x05DC, 0x05D0, 0x05DC };
unsigned short unac_data248[] = { 0x0671, 0x0671, 0x0671, 0x0671, 0x067B, 0x067B, 0x067B, 0x067B, 0x067B, 0x067B, 0x067B, 0x067B, 0x067E, 0x067E, 0x067E, 0x067E, 0x067E, 0x067E, 0x067E, 0x067E, 0x0680, 0x0680, 0x0680, 0x0680, 0x0680, 0x0680, 0x0680, 0x0680, 0x067A, 0x067A, 0x067A, 0x067A };
unsigned short unac_data249[] = { 0x067A, 0x067A, 0x067A, 0x067A, 0x067F, 0x067F, 0x067F, 0x067F, 0x067F, 0x067F, 0x067F, 0x067F, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 0x06A4, 0x06A4, 0x06A4, 0x06A4, 0x06A4, 0x06A4, 0x06A4, 0x06A4, 0x06A6, 0x06A6, 0x06A6, 0x06A6 };
unsigned short unac_data250[] = { 0x06A6, 0x06A6, 0x06A6, 0x06A6, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0684, 0x0683, 0x0683, 0x0683, 0x0683, 0x0683, 0x0683, 0x0683, 0x0683, 0x0686, 0x0686, 0x0686, 0x0686, 0x0686, 0x0686, 0x0686, 0x0686, 0x0687, 0x0687, 0x0687, 0x0687 };
unsigned short unac_data251[] = { 0x0687, 0x0687, 0x0687, 0x0687, 0x068D, 0x068D, 0x068D, 0x068D, 0x068C, 0x068C, 0x068C, 0x068C, 0x068E, 0x068E, 0x068E, 0x068E, 0x0688, 0x0688, 0x0688, 0x0688, 0x0698, 0x0698, 0x0698, 0x0698, 0x0691, 0x0691, 0x0691, 0x0691, 0x06A9, 0x06A9, 0x06A9, 0x06A9 };
unsigned short unac_data252[] = { 0x06A9, 0x06A9, 0x06A9, 0x06A9, 0x06AF, 0x06AF, 0x06AF, 0x06AF, 0x06AF, 0x06AF, 0x06AF, 0x06AF, 0x06B3, 0x06B3, 0x06B3, 0x06B3, 0x06B3, 0x06B3, 0x06B3, 0x06B3, 0x06B1, 0x06B1, 0x06B1, 0x06B1, 0x06B1, 0x06B1, 0x06B1, 0x06B1, 0x06BA, 0x06BA, 0x06BA, 0x06BA };
unsigned short unac_data253[] = { 0x06BB, 0x06BB, 0x06BB, 0x06BB, 0x06BB, 0x06BB, 0x06BB, 0x06BB, 0x06D5, 0x06D5, 0x06D5, 0x06D5, 0x06C1, 0x06C1, 0x06C1, 0x06C1, 0x06C1, 0x06C1, 0x06C1, 0x06C1, 0x06BE, 0x06BE, 0x06BE, 0x06BE, 0x06BE, 0x06BE, 0x06BE, 0x06BE, 0x06D2, 0x06D2, 0x06D2, 0x06D2 };
unsigned short unac_data254[] = { 0x06D2, 0x06D2, 0x06D2, 0x06D2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data255[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x06AD, 0x06AD, 0x06AD, 0x06AD, 0x06AD, 0x06AD, 0x06AD, 0x06AD, 0x06C7, 0x06C7, 0x06C7, 0x06C7, 0x06C6, 0x06C6, 0x06C6, 0x06C6, 0x06C8, 0x06C8, 0x06C8, 0x06C8, 0x06C7, 0x0674, 0x06C7, 0x0674, 0x06CB, 0x06CB, 0x06CB, 0x06CB };
unsigned short unac_data256[] = { 0x06C5, 0x06C5, 0x06C5, 0x06C5, 0x06C9, 0x06C9, 0x06C9, 0x06C9, 0x06D0, 0x06D0, 0x06D0, 0x06D0, 0x06D0, 0x06D0, 0x06D0, 0x06D0, 0x0649, 0x0649, 0x0649, 0x0649, 0x0627, 0x064A, 0x0627, 0x064A, 0x0627, 0x064A, 0x0627, 0x064A, 0x06D5, 0x064A, 0x06D5, 0x064A, 0x06D5, 0x064A, 0x06D5, 0x064A, 0x0648, 0x064A, 0x0648, 0x064A, 0x0648, 0x064A, 0x0648, 0x064A };
unsigned short unac_data257[] = { 0x06C7, 0x064A, 0x06C7, 0x064A, 0x06C7, 0x064A, 0x06C7, 0x064A, 0x06C6, 0x064A, 0x06C6, 0x064A, 0x06C6, 0x064A, 0x06C6, 0x064A, 0x06C8, 0x064A, 0x06C8, 0x064A, 0x06C8, 0x064A, 0x06C8, 0x064A, 0x06D0, 0x064A, 0x06D0, 0x064A, 0x06D0, 0x064A, 0x06D0, 0x064A, 0x06D0, 0x064A, 0x06D0, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x06CC, 0x06CC, 0x06CC, 0x06CC, 0x06CC, 0x06CC, 0x06CC, 0x06CC };
unsigned short unac_data258[] = { 0x062C, 0x064A, 0x062C, 0x064A, 0x062D, 0x064A, 0x062D, 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x0628, 0x062C, 0x0628, 0x062C, 0x0628, 0x062D, 0x0628, 0x062D, 0x0628, 0x062E, 0x0628, 0x062E, 0x0628, 0x0645, 0x0628, 0x0645, 0x0628, 0x0649, 0x0628, 0x0649, 0x0628, 0x064A, 0x0628, 0x064A, 0x062A, 0x062C, 0x062A, 0x062C, 0x062A, 0x062D, 0x062A, 0x062D, 0x062A, 0x062E, 0x062A, 0x062E, 0x062A, 0x0645, 0x062A, 0x0645, 0x062A, 0x0649, 0x062A, 0x0649 };
unsigned short unac_data259[] = { 0x062A, 0x064A, 0x062A, 0x064A, 0x062B, 0x062C, 0x062B, 0x062C, 0x062B, 0x0645, 0x062B, 0x0645, 0x062B, 0x0649, 0x062B, 0x0649, 0x062B, 0x064A, 0x062B, 0x064A, 0x062C, 0x062D, 0x062C, 0x062D, 0x062C, 0x0645, 0x062C, 0x0645, 0x062D, 0x062C, 0x062D, 0x062C, 0x062D, 0x0645, 0x062D, 0x0645, 0x062E, 0x062C, 0x062E, 0x062C, 0x062E, 0x062D, 0x062E, 0x062D, 0x062E, 0x0645, 0x062E, 0x0645, 0x0633, 0x062C, 0x0633, 0x062C, 0x0633, 0x062D, 0x0633, 0x062D, 0x0633, 0x062E, 0x0633, 0x062E, 0x0633, 0x0645, 0x0633, 0x0645 };
unsigned short unac_data260[] = { 0x0635, 0x062D, 0x0635, 0x062D, 0x0635, 0x0645, 0x0635, 0x0645, 0x0636, 0x062C, 0x0636, 0x062C, 0x0636, 0x062D, 0x0636, 0x062D, 0x0636, 0x062E, 0x0636, 0x062E, 0x0636, 0x0645, 0x0636, 0x0645, 0x0637, 0x062D, 0x0637, 0x062D, 0x0637, 0x0645, 0x0637, 0x0645, 0x0638, 0x0645, 0x0638, 0x0645, 0x0639, 0x062C, 0x0639, 0x062C, 0x0639, 0x0645, 0x0639, 0x0645, 0x063A, 0x062C, 0x063A, 0x062C, 0x063A, 0x0645, 0x063A, 0x0645, 0x0641, 0x062C, 0x0641, 0x062C, 0x0641, 0x062D, 0x0641, 0x062D, 0x0641, 0x062E, 0x0641, 0x062E };
unsigned short unac_data261[] = { 0x0641, 0x0645, 0x0641, 0x0645, 0x0641, 0x0649, 0x0641, 0x0649, 0x0641, 0x064A, 0x0641, 0x064A, 0x0642, 0x062D, 0x0642, 0x062D, 0x0642, 0x0645, 0x0642, 0x0645, 0x0642, 0x0649, 0x0642, 0x0649, 0x0642, 0x064A, 0x0642, 0x064A, 0x0643, 0x0627, 0x0643, 0x0627, 0x0643, 0x062C, 0x0643, 0x062C, 0x0643, 0x062D, 0x0643, 0x062D, 0x0643, 0x062E, 0x0643, 0x062E, 0x0643, 0x0644, 0x0643, 0x0644, 0x0643, 0x0645, 0x0643, 0x0645, 0x0643, 0x0649, 0x0643, 0x0649, 0x0643, 0x064A, 0x0643, 0x064A, 0x0644, 0x062C, 0x0644, 0x062C };
unsigned short unac_data262[] = { 0x0644, 0x062D, 0x0644, 0x062D, 0x0644, 0x062E, 0x0644, 0x062E, 0x0644, 0x0645, 0x0644, 0x0645, 0x0644, 0x0649, 0x0644, 0x0649, 0x0644, 0x064A, 0x0644, 0x064A, 0x0645, 0x062C, 0x0645, 0x062C, 0x0645, 0x062D, 0x0645, 0x062D, 0x0645, 0x062E, 0x0645, 0x062E, 0x0645, 0x0645, 0x0645, 0x0645, 0x0645, 0x0649, 0x0645, 0x0649, 0x0645, 0x064A, 0x0645, 0x064A, 0x0646, 0x062C, 0x0646, 0x062C, 0x0646, 0x062D, 0x0646, 0x062D, 0x0646, 0x062E, 0x0646, 0x062E, 0x0646, 0x0645, 0x0646, 0x0645, 0x0646, 0x0649, 0x0646, 0x0649 };
unsigned short unac_data263[] = { 0x0646, 0x064A, 0x0646, 0x064A, 0x0647, 0x062C, 0x0647, 0x062C, 0x0647, 0x0645, 0x0647, 0x0645, 0x0647, 0x0649, 0x0647, 0x0649, 0x0647, 0x064A, 0x0647, 0x064A, 0x064A, 0x062C, 0x064A, 0x062C, 0x064A, 0x062D, 0x064A, 0x062D, 0x064A, 0x062E, 0x064A, 0x062E, 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x064A, 0x064A, 0x064A, 0x0630, 0x0630, 0x0631, 0x0631, 0x0649, 0x0649, 0x0020, 0x0020, 0x0020, 0x0020 };
unsigned short unac_data264[] = { 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0631, 0x064A, 0x0631, 0x064A, 0x0632, 0x064A, 0x0632, 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0646, 0x064A, 0x0646, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x0628, 0x0631, 0x0628, 0x0631, 0x0628, 0x0632, 0x0628, 0x0632, 0x0628, 0x0645, 0x0628, 0x0645, 0x0628, 0x0646, 0x0628, 0x0646, 0x0628, 0x0649, 0x0628, 0x0649, 0x0628, 0x064A, 0x0628, 0x064A };
unsigned short unac_data265[] = { 0x062A, 0x0631, 0x062A, 0x0631, 0x062A, 0x0632, 0x062A, 0x0632, 0x062A, 0x0645, 0x062A, 0x0645, 0x062A, 0x0646, 0x062A, 0x0646, 0x062A, 0x0649, 0x062A, 0x0649, 0x062A, 0x064A, 0x062A, 0x064A, 0x062B, 0x0631, 0x062B, 0x0631, 0x062B, 0x0632, 0x062B, 0x0632, 0x062B, 0x0645, 0x062B, 0x0645, 0x062B, 0x0646, 0x062B, 0x0646, 0x062B, 0x0649, 0x062B, 0x0649, 0x062B, 0x064A, 0x062B, 0x064A, 0x0641, 0x0649, 0x0641, 0x0649, 0x0641, 0x064A, 0x0641, 0x064A, 0x0642, 0x0649, 0x0642, 0x0649, 0x0642, 0x064A, 0x0642, 0x064A };
unsigned short unac_data266[] = { 0x0643, 0x0627, 0x0643, 0x0627, 0x0643, 0x0644, 0x0643, 0x0644, 0x0643, 0x0645, 0x0643, 0x0645, 0x0643, 0x0649, 0x0643, 0x0649, 0x0643, 0x064A, 0x0643, 0x064A, 0x0644, 0x0645, 0x0644, 0x0645, 0x0644, 0x0649, 0x0644, 0x0649, 0x0644, 0x064A, 0x0644, 0x064A, 0x0645, 0x0627, 0x0645, 0x0627, 0x0645, 0x0645, 0x0645, 0x0645, 0x0646, 0x0631, 0x0646, 0x0631, 0x0646, 0x0632, 0x0646, 0x0632, 0x0646, 0x0645, 0x0646, 0x0645, 0x0646, 0x0646, 0x0646, 0x0646, 0x0646, 0x0649, 0x0646, 0x0649, 0x0646, 0x064A, 0x0646, 0x064A };
unsigned short unac_data267[] = { 0x0649, 0x0649, 0x064A, 0x0631, 0x064A, 0x0631, 0x064A, 0x0632, 0x064A, 0x0632, 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0646, 0x064A, 0x0646, 0x064A, 0x0649, 0x064A, 0x0649, 0x064A, 0x064A, 0x064A, 0x064A, 0x062C, 0x064A, 0x062C, 0x064A, 0x062D, 0x064A, 0x062D, 0x064A, 0x062E, 0x064A, 0x062E, 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0647, 0x064A, 0x0647, 0x064A, 0x0628, 0x062C, 0x0628, 0x062C, 0x0628, 0x062D, 0x0628, 0x062D, 0x0628, 0x062E, 0x0628, 0x062E, 0x0628, 0x0645, 0x0628, 0x0645 };
unsigned short unac_data268[] = { 0x0628, 0x0647, 0x0628, 0x0647, 0x062A, 0x062C, 0x062A, 0x062C, 0x062A, 0x062D, 0x062A, 0x062D, 0x062A, 0x062E, 0x062A, 0x062E, 0x062A, 0x0645, 0x062A, 0x0645, 0x062A, 0x0647, 0x062A, 0x0647, 0x062B, 0x0645, 0x062B, 0x0645, 0x062C, 0x062D, 0x062C, 0x062D, 0x062C, 0x0645, 0x062C, 0x0645, 0x062D, 0x062C, 0x062D, 0x062C, 0x062D, 0x0645, 0x062D, 0x0645, 0x062E, 0x062C, 0x062E, 0x062C, 0x062E, 0x0645, 0x062E, 0x0645, 0x0633, 0x062C, 0x0633, 0x062C, 0x0633, 0x062D, 0x0633, 0x062D, 0x0633, 0x062E, 0x0633, 0x062E };
unsigned short unac_data269[] = { 0x0633, 0x0645, 0x0633, 0x0645, 0x0635, 0x062D, 0x0635, 0x062D, 0x0635, 0x062E, 0x0635, 0x062E, 0x0635, 0x0645, 0x0635, 0x0645, 0x0636, 0x062C, 0x0636, 0x062C, 0x0636, 0x062D, 0x0636, 0x062D, 0x0636, 0x062E, 0x0636, 0x062E, 0x0636, 0x0645, 0x0636, 0x0645, 0x0637, 0x062D, 0x0637, 0x062D, 0x0638, 0x0645, 0x0638, 0x0645, 0x0639, 0x062C, 0x0639, 0x062C, 0x0639, 0x0645, 0x0639, 0x0645, 0x063A, 0x062C, 0x063A, 0x062C, 0x063A, 0x0645, 0x063A, 0x0645, 0x0641, 0x062C, 0x0641, 0x062C, 0x0641, 0x062D, 0x0641, 0x062D };
unsigned short unac_data270[] = { 0x0641, 0x062E, 0x0641, 0x062E, 0x0641, 0x0645, 0x0641, 0x0645, 0x0642, 0x062D, 0x0642, 0x062D, 0x0642, 0x0645, 0x0642, 0x0645, 0x0643, 0x062C, 0x0643, 0x062C, 0x0643, 0x062D, 0x0643, 0x062D, 0x0643, 0x062E, 0x0643, 0x062E, 0x0643, 0x0644, 0x0643, 0x0644, 0x0643, 0x0645, 0x0643, 0x0645, 0x0644, 0x062C, 0x0644, 0x062C, 0x0644, 0x062D, 0x0644, 0x062D, 0x0644, 0x062E, 0x0644, 0x062E, 0x0644, 0x0645, 0x0644, 0x0645, 0x0644, 0x0647, 0x0644, 0x0647, 0x0645, 0x062C, 0x0645, 0x062C, 0x0645, 0x062D, 0x0645, 0x062D };
unsigned short unac_data271[] = { 0x0645, 0x062E, 0x0645, 0x062E, 0x0645, 0x0645, 0x0645, 0x0645, 0x0646, 0x062C, 0x0646, 0x062C, 0x0646, 0x062D, 0x0646, 0x062D, 0x0646, 0x062E, 0x0646, 0x062E, 0x0646, 0x0645, 0x0646, 0x0645, 0x0646, 0x0647, 0x0646, 0x0647, 0x0647, 0x062C, 0x0647, 0x062C, 0x0647, 0x0645, 0x0647, 0x0645, 0x0647, 0x0647, 0x064A, 0x062C, 0x064A, 0x062C, 0x064A, 0x062D, 0x064A, 0x062D, 0x064A, 0x062E, 0x064A, 0x062E, 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0647, 0x064A, 0x0647, 0x0645, 0x064A, 0x0645, 0x064A };
unsigned short unac_data272[] = { 0x0647, 0x064A, 0x0647, 0x064A, 0x0628, 0x0645, 0x0628, 0x0645, 0x0628, 0x0647, 0x0628, 0x0647, 0x062A, 0x0645, 0x062A, 0x0645, 0x062A, 0x0647, 0x062A, 0x0647, 0x062B, 0x0645, 0x062B, 0x0645, 0x062B, 0x0647, 0x062B, 0x0647, 0x0633, 0x0645, 0x0633, 0x0645, 0x0633, 0x0647, 0x0633, 0x0647, 0x0634, 0x0645, 0x0634, 0x0645, 0x0634, 0x0647, 0x0634, 0x0647, 0x0643, 0x0644, 0x0643, 0x0644, 0x0643, 0x0645, 0x0643, 0x0645, 0x0644, 0x0645, 0x0644, 0x0645, 0x0646, 0x0645, 0x0646, 0x0645, 0x0646, 0x0647, 0x0646, 0x0647 };
unsigned short unac_data273[] = { 0x064A, 0x0645, 0x064A, 0x0645, 0x064A, 0x0647, 0x064A, 0x0647, 0x0640, 0x0640, 0x0640, 0x0640, 0x0640, 0x0640, 0x0637, 0x0649, 0x0637, 0x0649, 0x0637, 0x064A, 0x0637, 0x064A, 0x0639, 0x0649, 0x0639, 0x0649, 0x0639, 0x064A, 0x0639, 0x064A, 0x063A, 0x0649, 0x063A, 0x0649, 0x063A, 0x064A, 0x063A, 0x064A, 0x0633, 0x0649, 0x0633, 0x0649, 0x0633, 0x064A, 0x0633, 0x064A, 0x0634, 0x0649, 0x0634, 0x0649, 0x0634, 0x064A, 0x0634, 0x064A, 0x062D, 0x0649, 0x062D, 0x0649 };
unsigned short unac_data274[] = { 0x062D, 0x064A, 0x062D, 0x064A, 0x062C, 0x0649, 0x062C, 0x0649, 0x062C, 0x064A, 0x062C, 0x064A, 0x062E, 0x0649, 0x062E, 0x0649, 0x062E, 0x064A, 0x062E, 0x064A, 0x0635, 0x0649, 0x0635, 0x0649, 0x0635, 0x064A, 0x0635, 0x064A, 0x0636, 0x0649, 0x0636, 0x0649, 0x0636, 0x064A, 0x0636, 0x064A, 0x0634, 0x062C, 0x0634, 0x062C, 0x0634, 0x062D, 0x0634, 0x062D, 0x0634, 0x062E, 0x0634, 0x062E, 0x0634, 0x0645, 0x0634, 0x0645, 0x0634, 0x0631, 0x0634, 0x0631, 0x0633, 0x0631, 0x0633, 0x0631, 0x0635, 0x0631, 0x0635, 0x0631 };
unsigned short unac_data275[] = { 0x0636, 0x0631, 0x0636, 0x0631, 0x0637, 0x0649, 0x0637, 0x0649, 0x0637, 0x064A, 0x0637, 0x064A, 0x0639, 0x0649, 0x0639, 0x0649, 0x0639, 0x064A, 0x0639, 0x064A, 0x063A, 0x0649, 0x063A, 0x0649, 0x063A, 0x064A, 0x063A, 0x064A, 0x0633, 0x0649, 0x0633, 0x0649, 0x0633, 0x064A, 0x0633, 0x064A, 0x0634, 0x0649, 0x0634, 0x0649, 0x0634, 0x064A, 0x0634, 0x064A, 0x062D, 0x0649, 0x062D, 0x0649, 0x062D, 0x064A, 0x062D, 0x064A, 0x062C, 0x0649, 0x062C, 0x0649, 0x062C, 0x064A, 0x062C, 0x064A, 0x062E, 0x0649, 0x062E, 0x0649 };
unsigned short unac_data276[] = { 0x062E, 0x064A, 0x062E, 0x064A, 0x0635, 0x0649, 0x0635, 0x0649, 0x0635, 0x064A, 0x0635, 0x064A, 0x0636, 0x0649, 0x0636, 0x0649, 0x0636, 0x064A, 0x0636, 0x064A, 0x0634, 0x062C, 0x0634, 0x062C, 0x0634, 0x062D, 0x0634, 0x062D, 0x0634, 0x062E, 0x0634, 0x062E, 0x0634, 0x0645, 0x0634, 0x0645, 0x0634, 0x0631, 0x0634, 0x0631, 0x0633, 0x0631, 0x0633, 0x0631, 0x0635, 0x0631, 0x0635, 0x0631, 0x0636, 0x0631, 0x0636, 0x0631, 0x0634, 0x062C, 0x0634, 0x062C, 0x0634, 0x062D, 0x0634, 0x062D, 0x0634, 0x062E, 0x0634, 0x062E };
unsigned short unac_data277[] = { 0x0634, 0x0645, 0x0634, 0x0645, 0x0633, 0x0647, 0x0633, 0x0647, 0x0634, 0x0647, 0x0634, 0x0647, 0x0637, 0x0645, 0x0637, 0x0645, 0x0633, 0x062C, 0x0633, 0x062C, 0x0633, 0x062D, 0x0633, 0x062D, 0x0633, 0x062E, 0x0633, 0x062E, 0x0634, 0x062C, 0x0634, 0x062C, 0x0634, 0x062D, 0x0634, 0x062D, 0x0634, 0x062E, 0x0634, 0x062E, 0x0637, 0x0645, 0x0637, 0x0645, 0x0638, 0x0645, 0x0638, 0x0645, 0x0627, 0x0627, 0x0627, 0x0627, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data278[] = { 0x062A, 0x062C, 0x0645, 0x062A, 0x062C, 0x0645, 0x062A, 0x062D, 0x062C, 0x062A, 0x062D, 0x062C, 0x062A, 0x062D, 0x062C, 0x062A, 0x062D, 0x062C, 0x062A, 0x062D, 0x0645, 0x062A, 0x062D, 0x0645, 0x062A, 0x062E, 0x0645, 0x062A, 0x062E, 0x0645, 0x062A, 0x0645, 0x062C, 0x062A, 0x0645, 0x062C, 0x062A, 0x0645, 0x062D, 0x062A, 0x0645, 0x062D, 0x062A, 0x0645, 0x062E, 0x062A, 0x0645, 0x062E, 0x062C, 0x0645, 0x062D, 0x062C, 0x0645, 0x062D, 0x062C, 0x0645, 0x062D, 0x062C, 0x0645, 0x062D, 0x062D, 0x0645, 0x064A, 0x062D, 0x0645, 0x064A, 0x062D, 0x0645, 0x0649, 0x062D, 0x0645, 0x0649, 0x0633, 0x062D, 0x062C, 0x0633, 0x062D, 0x062C, 0x0633, 0x062C, 0x062D, 0x0633, 0x062C, 0x062D, 0x0633, 0x062C, 0x0649, 0x0633, 0x062C, 0x0649, 0x0633, 0x0645, 0x062D, 0x0633, 0x0645, 0x062D };
unsigned short unac_data279[] = { 0x0633, 0x0645, 0x062D, 0x0633, 0x0645, 0x062D, 0x0633, 0x0645, 0x062C, 0x0633, 0x0645, 0x062C, 0x0633, 0x0645, 0x0645, 0x0633, 0x0645, 0x0645, 0x0633, 0x0645, 0x0645, 0x0633, 0x0645, 0x0645, 0x0635, 0x062D, 0x062D, 0x0635, 0x062D, 0x062D, 0x0635, 0x062D, 0x062D, 0x0635, 0x062D, 0x062D, 0x0635, 0x0645, 0x0645, 0x0635, 0x0645, 0x0645, 0x0634, 0x062D, 0x0645, 0x0634, 0x062D, 0x0645, 0x0634, 0x062D, 0x0645, 0x0634, 0x062D, 0x0645, 0x0634, 0x062C, 0x064A, 0x0634, 0x062C, 0x064A, 0x0634, 0x0645, 0x062E, 0x0634, 0x0645, 0x062E, 0x0634, 0x0645, 0x062E, 0x0634, 0x0645, 0x062E, 0x0634, 0x0645, 0x0645, 0x0634, 0x0645, 0x0645, 0x0634, 0x0645, 0x0645, 0x0634, 0x0645, 0x0645, 0x0636, 0x062D, 0x0649, 0x0636, 0x062D, 0x0649, 0x0636, 0x062E, 0x0645, 0x0636, 0x062E, 0x0645 };
unsigned short unac_data280[] = { 0x0636, 0x062E, 0x0645, 0x0636, 0x062E, 0x0645, 0x0637, 0x0645, 0x062D, 0x0637, 0x0645, 0x062D, 0x0637, 0x0645, 0x062D, 0x0637, 0x0645, 0x062D, 0x0637, 0x0645, 0x0645, 0x0637, 0x0645, 0x0645, 0x0637, 0x0645, 0x064A, 0x0637, 0x0645, 0x064A, 0x0639, 0x062C, 0x0645, 0x0639, 0x062C, 0x0645, 0x0639, 0x0645, 0x0645, 0x0639, 0x0645, 0x0645, 0x0639, 0x0645, 0x0645, 0x0639, 0x0645, 0x0645, 0x0639, 0x0645, 0x0649, 0x0639, 0x0645, 0x0649, 0x063A, 0x0645, 0x0645, 0x063A, 0x0645, 0x0645, 0x063A, 0x0645, 0x064A, 0x063A, 0x0645, 0x064A, 0x063A, 0x0645, 0x0649, 0x063A, 0x0645, 0x0649, 0x0641, 0x062E, 0x0645, 0x0641, 0x062E, 0x0645, 0x0641, 0x062E, 0x0645, 0x0641, 0x062E, 0x0645, 0x0642, 0x0645, 0x062D, 0x0642, 0x0645, 0x062D, 0x0642, 0x0645, 0x0645, 0x0642, 0x0645, 0x0645 };
unsigned short unac_data281[] = { 0x0644, 0x062D, 0x0645, 0x0644, 0x062D, 0x0645, 0x0644, 0x062D, 0x064A, 0x0644, 0x062D, 0x064A, 0x0644, 0x062D, 0x0649, 0x0644, 0x062D, 0x0649, 0x0644, 0x062C, 0x062C, 0x0644, 0x062C, 0x062C, 0x0644, 0x062C, 0x062C, 0x0644, 0x062C, 0x062C, 0x0644, 0x062E, 0x0645, 0x0644, 0x062E, 0x0645, 0x0644, 0x062E, 0x0645, 0x0644, 0x062E, 0x0645, 0x0644, 0x0645, 0x062D, 0x0644, 0x0645, 0x062D, 0x0644, 0x0645, 0x062D, 0x0644, 0x0645, 0x062D, 0x0645, 0x062D, 0x062C, 0x0645, 0x062D, 0x062C, 0x0645, 0x062D, 0x0645, 0x0645, 0x062D, 0x0645, 0x0645, 0x062D, 0x064A, 0x0645, 0x062D, 0x064A, 0x0645, 0x062C, 0x062D, 0x0645, 0x062C, 0x062D, 0x0645, 0x062C, 0x0645, 0x0645, 0x062C, 0x0645, 0x0645, 0x062E, 0x062C, 0x0645, 0x062E, 0x062C, 0x0645, 0x062E, 0x0645, 0x0645, 0x062E, 0x0645 };
unsigned short unac_data282[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0645, 0x062C, 0x062E, 0x0645, 0x062C, 0x062E, 0x0647, 0x0645, 0x062C, 0x0647, 0x0645, 0x062C, 0x0647, 0x0645, 0x0645, 0x0647, 0x0645, 0x0645, 0x0646, 0x062D, 0x0645, 0x0646, 0x062D, 0x0645, 0x0646, 0x062D, 0x0649, 0x0646, 0x062D, 0x0649, 0x0646, 0x062C, 0x0645, 0x0646, 0x062C, 0x0645, 0x0646, 0x062C, 0x0645, 0x0646, 0x062C, 0x0645, 0x0646, 0x062C, 0x0649, 0x0646, 0x062C, 0x0649, 0x0646, 0x0645, 0x064A, 0x0646, 0x0645, 0x064A, 0x0646, 0x0645, 0x0649, 0x0646, 0x0645, 0x0649, 0x064A, 0x0645, 0x0645, 0x064A, 0x0645, 0x0645, 0x064A, 0x0645, 0x0645, 0x064A, 0x0645, 0x0645, 0x0628, 0x062E, 0x064A, 0x0628, 0x062E, 0x064A, 0x062A, 0x062C, 0x064A, 0x062A, 0x062C, 0x064A };
unsigned short unac_data283[] = { 0x062A, 0x062C, 0x0649, 0x062A, 0x062C, 0x0649, 0x062A, 0x062E, 0x064A, 0x062A, 0x062E, 0x064A, 0x062A, 0x062E, 0x0649, 0x062A, 0x062E, 0x0649, 0x062A, 0x0645, 0x064A, 0x062A, 0x0645, 0x064A, 0x062A, 0x0645, 0x0649, 0x062A, 0x0645, 0x0649, 0x062C, 0x0645, 0x064A, 0x062C, 0x0645, 0x064A, 0x062C, 0x062D, 0x0649, 0x062C, 0x062D, 0x0649, 0x062C, 0x0645, 0x0649, 0x062C, 0x0645, 0x0649, 0x0633, 0x062E, 0x0649, 0x0633, 0x062E, 0x0649, 0x0635, 0x062D, 0x064A, 0x0635, 0x062D, 0x064A, 0x0634, 0x062D, 0x064A, 0x0634, 0x062D, 0x064A, 0x0636, 0x062D, 0x064A, 0x0636, 0x062D, 0x064A, 0x0644, 0x062C, 0x064A, 0x0644, 0x062C, 0x064A, 0x0644, 0x0645, 0x064A, 0x0644, 0x0645, 0x064A, 0x064A, 0x062D, 0x064A, 0x064A, 0x062D, 0x064A, 0x064A, 0x062C, 0x064A, 0x064A, 0x062C, 0x064A };
unsigned short unac_data284[] = { 0x064A, 0x0645, 0x064A, 0x064A, 0x0645, 0x064A, 0x0645, 0x0645, 0x064A, 0x0645, 0x0645, 0x064A, 0x0642, 0x0645, 0x064A, 0x0642, 0x0645, 0x064A, 0x0646, 0x062D, 0x064A, 0x0646, 0x062D, 0x064A, 0x0642, 0x0645, 0x062D, 0x0642, 0x0645, 0x062D, 0x0644, 0x062D, 0x0645, 0x0644, 0x062D, 0x0645, 0x0639, 0x0645, 0x064A, 0x0639, 0x0645, 0x064A, 0x0643, 0x0645, 0x064A, 0x0643, 0x0645, 0x064A, 0x0646, 0x062C, 0x062D, 0x0646, 0x062C, 0x062D, 0x0645, 0x062E, 0x064A, 0x0645, 0x062E, 0x064A, 0x0644, 0x062C, 0x0645, 0x0644, 0x062C, 0x0645, 0x0643, 0x0645, 0x0645, 0x0643, 0x0645, 0x0645, 0x0644, 0x062C, 0x0645, 0x0644, 0x062C, 0x0645, 0x0646, 0x062C, 0x062D, 0x0646, 0x062C, 0x062D, 0x062C, 0x062D, 0x064A, 0x062C, 0x062D, 0x064A, 0x062D, 0x062C, 0x064A, 0x062D, 0x062C, 0x064A };
unsigned short unac_data285[] = { 0x0645, 0x062C, 0x064A, 0x0645, 0x062C, 0x064A, 0x0641, 0x0645, 0x064A, 0x0641, 0x0645, 0x064A, 0x0628, 0x062D, 0x064A, 0x0628, 0x062D, 0x064A, 0x0643, 0x0645, 0x0645, 0x0643, 0x0645, 0x0645, 0x0639, 0x062C, 0x0645, 0x0639, 0x062C, 0x0645, 0x0635, 0x0645, 0x0645, 0x0635, 0x0645, 0x0645, 0x0633, 0x062E, 0x064A, 0x0633, 0x062E, 0x064A, 0x0646, 0x062C, 0x064A, 0x0646, 0x062C, 0x064A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data286[] = { 0x0635, 0x0644, 0x06D2, 0x0635, 0x0644, 0x06D2, 0x0642, 0x0644, 0x06D2, 0x0642, 0x0644, 0x06D2, 0x0627, 0x0644, 0x0644, 0x0647, 0x0627, 0x0644, 0x0644, 0x0647, 0x0627, 0x0643, 0x0628, 0x0631, 0x0627, 0x0643, 0x0628, 0x0631, 0x0645, 0x062D, 0x0645, 0x062F, 0x0645, 0x062D, 0x0645, 0x062F, 0x0635, 0x0644, 0x0639, 0x0645, 0x0635, 0x0644, 0x0639, 0x0645, 0x0631, 0x0633, 0x0648, 0x0644, 0x0631, 0x0633, 0x0648, 0x0644, 0x0639, 0x0644, 0x064A, 0x0647, 0x0639, 0x0644, 0x064A, 0x0647, 0x0648, 0x0633, 0x0644, 0x0645, 0x0648, 0x0633, 0x0644, 0x0645, 0x0635, 0x0644, 0x0649, 0x0635, 0x0644, 0x0649, 0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645, 0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645, 0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647, 0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647, 0x0631, 0x06CC, 0x0627, 0x0644, 0x0631, 0x06CC, 0x0627, 0x0644, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data287[] = { 0x002E, 0x002E, 0x002E, 0x002E, 0x2014, 0x2014, 0x2013, 0x2013, 0x005F, 0x005F, 0x005F, 0x005F, 0x0028, 0x0028, 0x0029, 0x0029, 0x007B, 0x007B, 0x007D, 0x007D, 0x3014, 0x3014, 0x3015, 0x3015, 0x3010, 0x3010, 0x3011, 0x3011, 0x300A, 0x300A, 0x300B, 0x300B, 0x3008, 0x3008 };
unsigned short unac_data288[] = { 0x3009, 0x3009, 0x300C, 0x300C, 0x300D, 0x300D, 0x300E, 0x300E, 0x300F, 0x300F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x005F, 0x005F, 0x005F, 0x005F, 0x005F, 0x005F };
unsigned short unac_data289[] = { 0x002C, 0x002C, 0x3001, 0x3001, 0x002E, 0x002E, 0xFFFF, 0xFFFF, 0x003B, 0x003B, 0x003A, 0x003A, 0x003F, 0x003F, 0x0021, 0x0021, 0x2014, 0x2014, 0x0028, 0x0028, 0x0029, 0x0029, 0x007B, 0x007B, 0x007D, 0x007D, 0x3014, 0x3014, 0x3015, 0x3015, 0x0023, 0x0023 };
unsigned short unac_data290[] = { 0x0026, 0x0026, 0x002A, 0x002A, 0x002B, 0x002B, 0x002D, 0x002D, 0x003C, 0x003C, 0x003E, 0x003E, 0x003D, 0x003D, 0xFFFF, 0xFFFF, 0x005C, 0x005C, 0x0024, 0x0024, 0x0025, 0x0025, 0x0040, 0x0040, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data291[] = { 0x0020, 0x0020, 0x0640, 0x0640, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0xFFFF, 0xFFFF, 0x0020, 0x0020, 0x0640, 0x0640, 0x0020, 0x0020, 0x0640, 0x0640, 0x0020, 0x0020, 0x0640, 0x0640, 0x0020, 0x0020, 0x0640, 0x0640, 0x0020, 0x0020, 0x0640, 0x0640 };
unsigned short unac_data292[] = { 0x0621, 0x0621, 0x0627, 0x0627, 0x0627, 0x0627, 0x0627, 0x0627, 0x0627, 0x0627, 0x0648, 0x0648, 0x0648, 0x0648, 0x0627, 0x0627, 0x0627, 0x0627, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x0627, 0x0627, 0x0627, 0x0627, 0x0628, 0x0628 };
unsigned short unac_data293[] = { 0x0628, 0x0628, 0x0628, 0x0628, 0x0628, 0x0628, 0x0629, 0x0629, 0x0629, 0x0629, 0x062A, 0x062A, 0x062A, 0x062A, 0x062A, 0x062A, 0x062A, 0x062A, 0x062B, 0x062B, 0x062B, 0x062B, 0x062B, 0x062B, 0x062B, 0x062B, 0x062C, 0x062C, 0x062C, 0x062C, 0x062C, 0x062C };
unsigned short unac_data294[] = { 0x062C, 0x062C, 0x062D, 0x062D, 0x062D, 0x062D, 0x062D, 0x062D, 0x062D, 0x062D, 0x062E, 0x062E, 0x062E, 0x062E, 0x062E, 0x062E, 0x062E, 0x062E, 0x062F, 0x062F, 0x062F, 0x062F, 0x0630, 0x0630, 0x0630, 0x0630, 0x0631, 0x0631, 0x0631, 0x0631, 0x0632, 0x0632 };
unsigned short unac_data295[] = { 0x0632, 0x0632, 0x0633, 0x0633, 0x0633, 0x0633, 0x0633, 0x0633, 0x0633, 0x0633, 0x0634, 0x0634, 0x0634, 0x0634, 0x0634, 0x0634, 0x0634, 0x0634, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0635, 0x0636, 0x0636, 0x0636, 0x0636, 0x0636, 0x0636 };
unsigned short unac_data296[] = { 0x0636, 0x0636, 0x0637, 0x0637, 0x0637, 0x0637, 0x0637, 0x0637, 0x0637, 0x0637, 0x0638, 0x0638, 0x0638, 0x0638, 0x0638, 0x0638, 0x0638, 0x0638, 0x0639, 0x0639, 0x0639, 0x0639, 0x0639, 0x0639, 0x0639, 0x0639, 0x063A, 0x063A, 0x063A, 0x063A, 0x063A, 0x063A };
unsigned short unac_data297[] = { 0x063A, 0x063A, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0641, 0x0642, 0x0642, 0x0642, 0x0642, 0x0642, 0x0642, 0x0642, 0x0642, 0x0643, 0x0643, 0x0643, 0x0643, 0x0643, 0x0643, 0x0643, 0x0643, 0x0644, 0x0644, 0x0644, 0x0644, 0x0644, 0x0644 };
unsigned short unac_data298[] = { 0x0644, 0x0644, 0x0645, 0x0645, 0x0645, 0x0645, 0x0645, 0x0645, 0x0645, 0x0645, 0x0646, 0x0646, 0x0646, 0x0646, 0x0646, 0x0646, 0x0646, 0x0646, 0x0647, 0x0647, 0x0647, 0x0647, 0x0647, 0x0647, 0x0647, 0x0647, 0x0648, 0x0648, 0x0648, 0x0648, 0x0649, 0x0649 };
unsigned short unac_data299[] = { 0x0649, 0x0649, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x064A, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0x0644, 0x0627, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data300[] = { 0xFFFF, 0xFFFF, 0x0021, 0x0021, 0x0022, 0x0022, 0x0023, 0x0023, 0x0024, 0x0024, 0x0025, 0x0025, 0x0026, 0x0026, 0x0027, 0x0027, 0x0028, 0x0028, 0x0029, 0x0029, 0x002A, 0x002A, 0x002B, 0x002B, 0x002C, 0x002C, 0x002D, 0x002D, 0x002E, 0x002E, 0x002F, 0x002F };
unsigned short unac_data301[] = { 0x0030, 0x0030, 0x0031, 0x0031, 0x0032, 0x0032, 0x0033, 0x0033, 0x0034, 0x0034, 0x0035, 0x0035, 0x0036, 0x0036, 0x0037, 0x0037, 0x0038, 0x0038, 0x0039, 0x0039, 0x003A, 0x003A, 0x003B, 0x003B, 0x003C, 0x003C, 0x003D, 0x003D, 0x003E, 0x003E, 0x003F, 0x003F };
unsigned short unac_data302[] = { 0x0040, 0x0040, 0x0041, 0x0061, 0x0042, 0x0062, 0x0043, 0x0063, 0x0044, 0x0064, 0x0045, 0x0065, 0x0046, 0x0066, 0x0047, 0x0067, 0x0048, 0x0068, 0x0049, 0x0069, 0x004A, 0x006A, 0x004B, 0x006B, 0x004C, 0x006C, 0x004D, 0x006D, 0x004E, 0x006E, 0x004F, 0x006F };
unsigned short unac_data303[] = { 0x0050, 0x0070, 0x0051, 0x0071, 0x0052, 0x0072, 0x0053, 0x0073, 0x0054, 0x0074, 0x0055, 0x0075, 0x0056, 0x0076, 0x0057, 0x0077, 0x0058, 0x0078, 0x0059, 0x0079, 0x005A, 0x007A, 0x005B, 0x005B, 0x005C, 0x005C, 0x005D, 0x005D, 0x005E, 0x005E, 0x005F, 0x005F };
unsigned short unac_data304[] = { 0x0060, 0x0060, 0x0061, 0x0061, 0x0062, 0x0062, 0x0063, 0x0063, 0x0064, 0x0064, 0x0065, 0x0065, 0x0066, 0x0066, 0x0067, 0x0067, 0x0068, 0x0068, 0x0069, 0x0069, 0x006A, 0x006A, 0x006B, 0x006B, 0x006C, 0x006C, 0x006D, 0x006D, 0x006E, 0x006E, 0x006F, 0x006F };
unsigned short unac_data305[] = { 0x0070, 0x0070, 0x0071, 0x0071, 0x0072, 0x0072, 0x0073, 0x0073, 0x0074, 0x0074, 0x0075, 0x0075, 0x0076, 0x0076, 0x0077, 0x0077, 0x0078, 0x0078, 0x0079, 0x0079, 0x007A, 0x007A, 0x007B, 0x007B, 0x007C, 0x007C, 0x007D, 0x007D, 0x007E, 0x007E, 0x2985, 0x2985 };
unsigned short unac_data306[] = { 0x2986, 0x2986, 0x3002, 0x3002, 0x300C, 0x300C, 0x300D, 0x300D, 0x3001, 0x3001, 0x30FB, 0x30FB, 0x30F2, 0x30F2, 0x30A1, 0x30A1, 0x30A3, 0x30A3, 0x30A5, 0x30A5, 0x30A7, 0x30A7, 0x30A9, 0x30A9, 0x30E3, 0x30E3, 0x30E5, 0x30E5, 0x30E7, 0x30E7, 0x30C3, 0x30C3 };
unsigned short unac_data307[] = { 0x30FC, 0x30FC, 0x30A2, 0x30A2, 0x30A4, 0x30A4, 0x30A6, 0x30A6, 0x30A8, 0x30A8, 0x30AA, 0x30AA, 0x30AB, 0x30AB, 0x30AD, 0x30AD, 0x30AF, 0x30AF, 0x30B1, 0x30B1, 0x30B3, 0x30B3, 0x30B5, 0x30B5, 0x30B7, 0x30B7, 0x30B9, 0x30B9, 0x30BB, 0x30BB, 0x30BD, 0x30BD };
unsigned short unac_data308[] = { 0x30BF, 0x30BF, 0x30C1, 0x30C1, 0x30C4, 0x30C4, 0x30C6, 0x30C6, 0x30C8, 0x30C8, 0x30CA, 0x30CA, 0x30CB, 0x30CB, 0x30CC, 0x30CC, 0x30CD, 0x30CD, 0x30CE, 0x30CE, 0x30CF, 0x30CF, 0x30D2, 0x30D2, 0x30D5, 0x30D5, 0x30D8, 0x30D8, 0x30DB, 0x30DB, 0x30DE, 0x30DE };
unsigned short unac_data309[] = { 0x30DF, 0x30DF, 0x30E0, 0x30E0, 0x30E1, 0x30E1, 0x30E2, 0x30E2, 0x30E4, 0x30E4, 0x30E6, 0x30E6, 0x30E8, 0x30E8, 0x30E9, 0x30E9, 0x30EA, 0x30EA, 0x30EB, 0x30EB, 0x30EC, 0x30EC, 0x30ED, 0x30ED, 0x30EF, 0x30EF, 0x30F3, 0x30F3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data310[] = { 0x1160, 0x1160, 0x1100, 0x1100, 0x1101, 0x1101, 0x11AA, 0x11AA, 0x1102, 0x1102, 0x11AC, 0x11AC, 0x11AD, 0x11AD, 0x1103, 0x1103, 0x1104, 0x1104, 0x1105, 0x1105, 0x11B0, 0x11B0, 0x11B1, 0x11B1, 0x11B2, 0x11B2, 0x11B3, 0x11B3, 0x11B4, 0x11B4, 0x11B5, 0x11B5 };
unsigned short unac_data311[] = { 0x111A, 0x111A, 0x1106, 0x1106, 0x1107, 0x1107, 0x1108, 0x1108, 0x1121, 0x1121, 0x1109, 0x1109, 0x110A, 0x110A, 0x110B, 0x110B, 0x110C, 0x110C, 0x110D, 0x110D, 0x110E, 0x110E, 0x110F, 0x110F, 0x1110, 0x1110, 0x1111, 0x1111, 0x1112, 0x1112, 0xFFFF, 0xFFFF };
unsigned short unac_data312[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1161, 0x1161, 0x1162, 0x1162, 0x1163, 0x1163, 0x1164, 0x1164, 0x1165, 0x1165, 0x1166, 0x1166, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1167, 0x1167, 0x1168, 0x1168, 0x1169, 0x1169, 0x116A, 0x116A, 0x116B, 0x116B, 0x116C, 0x116C };
unsigned short unac_data313[] = { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x116D, 0x116D, 0x116E, 0x116E, 0x116F, 0x116F, 0x1170, 0x1170, 0x1171, 0x1171, 0x1172, 0x1172, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x1173, 0x1173, 0x1174, 0x1174, 0x1175, 0x1175, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF };
unsigned short unac_data314[] = { 0x00A2, 0x00A2, 0x00A3, 0x00A3, 0x00AC, 0x00AC, 0x0020, 0x0020, 0x00A6, 0x00A6, 0x00A5, 0x00A5, 0x20A9, 0x20A9, 0xFFFF, 0xFFFF, 0x2502, 0x2502, 0x2190, 0x2190, 0x2191, 0x2191, 0x2192, 0x2192, 0x2193, 0x2193, 0x25A0, 0x25A0, 0x25CB, 0x25CB, 0xFFFF, 0xFFFF };

unsigned short* unac_data_table[UNAC_BLOCK_COUNT] = {
unac_data0,
unac_data1,
unac_data2,
unac_data3,
unac_data4,
unac_data5,
unac_data6,
unac_data7,
unac_data8,
unac_data9,
unac_data10,
unac_data11,
unac_data12,
unac_data13,
unac_data14,
unac_data15,
unac_data16,
unac_data17,
unac_data18,
unac_data19,
unac_data20,
unac_data21,
unac_data22,
unac_data23,
unac_data24,
unac_data25,
unac_data26,
unac_data27,
unac_data28,
unac_data29,
unac_data30,
unac_data31,
unac_data32,
unac_data33,
unac_data34,
unac_data35,
unac_data36,
unac_data37,
unac_data38,
unac_data39,
unac_data40,
unac_data41,
unac_data42,
unac_data43,
unac_data44,
unac_data45,
unac_data46,
unac_data47,
unac_data48,
unac_data49,
unac_data50,
unac_data51,
unac_data52,
unac_data53,
unac_data54,
unac_data55,
unac_data56,
unac_data57,
unac_data58,
unac_data59,
unac_data60,
unac_data61,
unac_data62,
unac_data63,
unac_data64,
unac_data65,
unac_data66,
unac_data67,
unac_data68,
unac_data69,
unac_data70,
unac_data71,
unac_data72,
unac_data73,
unac_data74,
unac_data75,
unac_data76,
unac_data77,
unac_data78,
unac_data79,
unac_data80,
unac_data81,
unac_data82,
unac_data83,
unac_data84,
unac_data85,
unac_data86,
unac_data87,
unac_data88,
unac_data89,
unac_data90,
unac_data91,
unac_data92,
unac_data93,
unac_data94,
unac_data95,
unac_data96,
unac_data97,
unac_data98,
unac_data99,
unac_data100,
unac_data101,
unac_data102,
unac_data103,
unac_data104,
unac_data105,
unac_data106,
unac_data107,
unac_data108,
unac_data109,
unac_data110,
unac_data111,
unac_data112,
unac_data113,
unac_data114,
unac_data115,
unac_data116,
unac_data117,
unac_data118,
unac_data119,
unac_data120,
unac_data121,
unac_data122,
unac_data123,
unac_data124,
unac_data125,
unac_data126,
unac_data127,
unac_data128,
unac_data129,
unac_data130,
unac_data131,
unac_data132,
unac_data133,
unac_data134,
unac_data135,
unac_data136,
unac_data137,
unac_data138,
unac_data139,
unac_data140,
unac_data141,
unac_data142,
unac_data143,
unac_data144,
unac_data145,
unac_data146,
unac_data147,
unac_data148,
unac_data149,
unac_data150,
unac_data151,
unac_data152,
unac_data153,
unac_data154,
unac_data155,
unac_data156,
unac_data157,
unac_data158,
unac_data159,
unac_data160,
unac_data161,
unac_data162,
unac_data163,
unac_data164,
unac_data165,
unac_data166,
unac_data167,
unac_data168,
unac_data169,
unac_data170,
unac_data171,
unac_data172,
unac_data173,
unac_data174,
unac_data175,
unac_data176,
unac_data177,
unac_data178,
unac_data179,
unac_data180,
unac_data181,
unac_data182,
unac_data183,
unac_data184,
unac_data185,
unac_data186,
unac_data187,
unac_data188,
unac_data189,
unac_data190,
unac_data191,
unac_data192,
unac_data193,
unac_data194,
unac_data195,
unac_data196,
unac_data197,
unac_data198,
unac_data199,
unac_data200,
unac_data201,
unac_data202,
unac_data203,
unac_data204,
unac_data205,
unac_data206,
unac_data207,
unac_data208,
unac_data209,
unac_data210,
unac_data211,
unac_data212,
unac_data213,
unac_data214,
unac_data215,
unac_data216,
unac_data217,
unac_data218,
unac_data219,
unac_data220,
unac_data221,
unac_data222,
unac_data223,
unac_data224,
unac_data225,
unac_data226,
unac_data227,
unac_data228,
unac_data229,
unac_data230,
unac_data231,
unac_data232,
unac_data233,
unac_data234,
unac_data235,
unac_data236,
unac_data237,
unac_data238,
unac_data239,
unac_data240,
unac_data241,
unac_data242,
unac_data243,
unac_data244,
unac_data245,
unac_data246,
unac_data247,
unac_data248,
unac_data249,
unac_data250,
unac_data251,
unac_data252,
unac_data253,
unac_data254,
unac_data255,
unac_data256,
unac_data257,
unac_data258,
unac_data259,
unac_data260,
unac_data261,
unac_data262,
unac_data263,
unac_data264,
unac_data265,
unac_data266,
unac_data267,
unac_data268,
unac_data269,
unac_data270,
unac_data271,
unac_data272,
unac_data273,
unac_data274,
unac_data275,
unac_data276,
unac_data277,
unac_data278,
unac_data279,
unac_data280,
unac_data281,
unac_data282,
unac_data283,
unac_data284,
unac_data285,
unac_data286,
unac_data287,
unac_data288,
unac_data289,
unac_data290,
unac_data291,
unac_data292,
unac_data293,
unac_data294,
unac_data295,
unac_data296,
unac_data297,
unac_data298,
unac_data299,
unac_data300,
unac_data301,
unac_data302,
unac_data303,
unac_data304,
unac_data305,
unac_data306,
unac_data307,
unac_data308,
unac_data309,
unac_data310,
unac_data311,
unac_data312,
unac_data313,
unac_data314
};
/* Generated by builder. Do not modify. End tables */

/*
 * Debug level. See unac.h for a detailed discussion of the
 * values.
 */
static int debug_level = UNAC_DEBUG_LOW;

#ifdef UNAC_DEBUG_AVAILABLE

/*
 * Default debug function, printing on stderr.
 */
static void debug_doprint_default(const char* message, void* data)
{
  fprintf(stderr, "%s", message);
}

/*
 * Default doprint handler is debug_doprint.
 */
static unac_debug_print_t debug_doprint = debug_doprint_default;
/*
 * Default app data is null.
 */
static void* debug_appdata = (void*)0;

/*
 * Generate a debug message (arguments ala printf) and
 * send it to the doprint handler.
 */
#define DEBUG debug_print("%s:%d: ", __FILE__, __LINE__), debug_print
#define DEBUG_APPEND debug_print
static void debug_print(const char* message, ...)
{
#define UNAC_MAXIMUM_MESSAGE_SIZE 512
  /*
   * UNAC_MAXIMUM_MESSAGE_SIZE is supposedly enough but I
   * do trust some vsnprintf implementations to be bugous.
   */
  char unac_message_buffer[UNAC_MAXIMUM_MESSAGE_SIZE+1] = { '\0' };
  va_list args;
  va_start(args, message);
  if(vsnprintf(unac_message_buffer, UNAC_MAXIMUM_MESSAGE_SIZE, message, args) < 0) {
    char tmp[UNAC_MAXIMUM_MESSAGE_SIZE];
    sprintf(tmp, "[message larger than %d, truncated]", UNAC_MAXIMUM_MESSAGE_SIZE);
    debug_doprint(tmp, debug_appdata);
  }
  va_end(args);
  unac_message_buffer[UNAC_MAXIMUM_MESSAGE_SIZE] = '\0';

  debug_doprint(unac_message_buffer, debug_appdata);
}

void unac_debug_callback(int level, unac_debug_print_t function, void* data)
{
  debug_level = level;
  if(function)
    debug_doprint = function;
  debug_appdata = data;
}

#else /* UNAC_DEBUG_AVAILABLE */
#define DEBUG 
#define DEBUG_APPEND
#endif /* UNAC_DEBUG_AVAILABLE */


/*
 * If UTF-16BE exists, use it. If not, use UTF-16 and hope it is
 * encoded in big endian. This fallback is a iconv related
 * compatibility hack introduced in some GNU/Linux distributions that
 * did not know UTF-16BE.
 */
static const char* utf16be(void)
{
  iconv_t cd;
  static char* name = 0;

  if(name == 0) {
    if((cd = iconv_open("UTF-16BE", "UTF-16BE")) == (iconv_t)-1) {
      if(debug_level >= UNAC_DEBUG_LOW) DEBUG("could not find UTF-16BE (see iconv -l), using UTF-16. If UTF-16 happens to be encoded in little endian, be prepared for an horrible mess.");
      name = "UTF-16";
    } else {
      iconv_close(cd);
      name = "UTF-16BE";
    }
  }

  return name;
}

int unacmaybefold_string_utf16(const char* in, size_t in_length,
		      char** outp, size_t* out_lengthp, int dofold)
{
  char* out;
  int out_size;
  int out_length;
  int i;

  out_size = in_length > 0 ? in_length : 1024;
  if (*outp) {
    out = *outp;
    /* +1 for null */
    out = realloc(out, out_size + 1);
    if(out == 0) {
	if(debug_level >= UNAC_DEBUG_LOW)
	  DEBUG("realloc %d bytes failed\n", out_size+1);
	// *outp is still valid. Let the caller free it
	return -1;
    }
  } else {
    /* +1 for null */
    out = malloc(out_size + 1);
    if (out == 0) {
	if(debug_level >= UNAC_DEBUG_LOW)
	  DEBUG("malloc %d bytes failed\n", out_size+1);
	return -1;
    }
  }
  out_length = 0;

  for(i = 0; i < in_length; i += 2) {
    unsigned short c;
    unsigned short* p;
    int l;
    int k;
    c = (in[i] << 8) | (in[i + 1] & 0xff);
    /*
     * Lookup the tables for decomposition information
     */
    if (dofold) {
	unacfold_char_utf16(c, p, l);
    } else {
	unac_char_utf16(c, p, l);
    }
    /*
     * Explain what's done in great detail
     */
    if(debug_level == UNAC_DEBUG_HIGH) {
      unsigned short index = unac_indexes[(c) >> UNAC_BLOCK_SHIFT];
      unsigned char position = (c) & UNAC_BLOCK_MASK;
      DEBUG("unac_data%d[%d] & unac_positions[%d][%d]: ", index, unac_positions[index][position], index, position+1);
      DEBUG_APPEND("0x%04x => ", (c));
      if(l == 0) {
	DEBUG_APPEND("untouched\n");
      } else {
	int i;
	for(i = 0; i < l; i++)
	  DEBUG_APPEND("0x%04x ", p[i]);
	DEBUG_APPEND("\n");
      }
    }

    /*
     * Make sure there is enough space to hold the decomposition
     * Note: a previous realloc may have succeeded, which means that *outp 
     * is not valid any more. We have to do the freeing and zero out *outp
     */
    if(out_length + ((l + 1) * 2) > out_size) {
      char *saved;
      out_size += ((l + 1) * 2) + 1024;
      saved = out;
      out = realloc(out, out_size);
      if(out == 0) {
	if(debug_level >= UNAC_DEBUG_LOW)
	  DEBUG("realloc %d bytes failed\n", out_size);
        free(saved);
	*outp = 0;
	return -1;
      }
    }
    if(l > 0) {
      /*
       * If there is a decomposition, insert it in the output 
       * string.
       */
      for(k = 0; k < l; k++) {
	out[out_length++] = (p[k] >> 8) & 0xff;
	out[out_length++] = (p[k] & 0xff);
      }
    } else {
      /*
       * If there is no decomposition leave it unchanged
       */
      out[out_length++] = in[i];
      out[out_length++] = in[i + 1];
    }
  }

  *outp = out;
  *out_lengthp = out_length;
  (*outp)[*out_lengthp] = '\0';

  return 0;
}
int unac_string_utf16(const char* in, size_t in_length,
		      char** outp, size_t* out_lengthp)
{
    return unacmaybefold_string_utf16(in, in_length,
				      outp, out_lengthp, 0);
}
int unacfold_string_utf16(const char* in, size_t in_length,
		      char** outp, size_t* out_lengthp)
{
    return unacmaybefold_string_utf16(in, in_length,
				      outp, out_lengthp, 1);
}

#define MAXOUT 1024

static int convert(const char* from, const char* to,
		   const char* in, size_t in_length,
		   char** outp, size_t* out_lengthp);

/*
 * Convert buffer <in> containing string encoded in charset <from> into
 * a string in charset <to> and return it in buffer <outp>. The <outp>
 * points to a malloced string large enough to hold the conversion result.
 * It is the responsibility of the caller to free this array.
 * The out string is always null terminated.
 */
static int convert(const char* from, const char* to,
		   const char* in, size_t in_length,
		   char** outp, size_t* out_lengthp)
{
  iconv_t cd;
  char* out;
  size_t out_remain;
  size_t out_size;
  char* out_base;
  int from_utf16 = !strcmp(utf16be(), from);
  const char space[] = { 0x00, 0x20 };

  out_size = in_length > 0 ? in_length : 1024;
  if(*outp) {
    out = *outp;
    /* +1 for null */
    out = realloc(out, out_size + 1);
    if(out == 0) {
	// *outp still valid, no freeing
	if(debug_level >= UNAC_DEBUG_LOW)
	  DEBUG("realloc %d bytes failed\n", out_size+1);
	return -1;
    }
  } else {
    /* +1 for null */
    out = malloc(out_size + 1);
    if(out == 0) {
	if(debug_level >= UNAC_DEBUG_LOW)
	  DEBUG("malloc %d bytes failed\n", out_size+1);
	return -1;
    }
  }
  out_remain = out_size;
  out_base = out;

  if((cd = iconv_open(to, from)) == (iconv_t)-1) {
    return -1;
  }
  do {
    if(iconv(cd, (ICONV_CONST char **) &in, &in_length, &out, &out_remain) == (size_t)-1) {
      switch(errno) {
      case EILSEQ:
	/*
	 * If an illegal sequence is found in the context of unac_string
	 * it means the unaccented version of a character contains
	 * a sequence that cannot be mapped back to the original charset.
	 * For instance, the 1/4 character in ISO-8859-1 is decomposed
	 * in three characters including the FRACTION SLASH (2044) which
	 * have no equivalent in the ISO-8859-1 map. One can argue that
	 * the conversions tables should map it to the regular / character
	 * or that a <compat> entry should be associated with it. 
	 *
	 * To cope with this situation, convert silently transform all
	 * illegal sequences (EILSEQ) into a SPACE character 0x0020.
	 *
	 * In the general conversion case this behaviour is not desirable.
	 * However, it is not the responsibility of this program to cope
	 * with inconsistencies of the Unicode description and a bug report
	 * should be submited to Unicode so that they can fix the problem.
	 * 
	 */
	if(from_utf16) {
	  const char* tmp = space;
	  size_t tmp_length = 2;
	  if(iconv(cd, (ICONV_CONST char **) &tmp, &tmp_length, &out, &out_remain) == (size_t)-1) {
	    if(errno == E2BIG)
	      /* fall thru to the E2BIG case below */;
	    else
	      return -1;
	  } else {
	    /* The offending character was replaced by a SPACE, skip it. */
	    in += 2;
	    in_length -= 2;
	    /* And continue conversion. */
	    break;
	  }
	} else {
	  return -1;
	}
      case E2BIG:
	{
	  /*
	   * The output does not fit in the current out buffer, enlarge it.
	   */
	  int length = out - out_base;
	  out_size *= 2;
	  {
	      char *saved = out_base;
	      /* +1 for null */
	      out_base = realloc(out_base, out_size + 1);
	      if (out_base == 0) {
		  // *outp potentially not valid any more. Free here,
		  // and zero out
		  if(debug_level >= UNAC_DEBUG_LOW)
		      DEBUG("realloc %d bytes failed\n", out_size+1);
		  free(saved);
		  *outp = 0;
		  return -1;
	      }
	  }
	  out = out_base + length;
	  out_remain = out_size - length;
	}
	break;
      default:
	return -1;
	break;
      }
    }
  } while(in_length > 0);
  iconv_close(cd);

  *outp = out_base;
  *out_lengthp = out - out_base;
  (*outp)[*out_lengthp] = '\0';

  return 0;
}

int unacmaybefold_string(const char* charset,
		const char* in, size_t in_length,
			 char** outp, size_t* out_lengthp, int dofold)
{
  /*
   * When converting an empty string, skip everything but alloc the
   * buffer if NULL pointer.
   */
  if (in_length <= 0) {
      if(!*outp) {
	  if ((*outp = malloc(32)) == 0)
	      return -1;
      }
      (*outp)[0] = '\0';
      *out_lengthp = 0;
  } else {
    char* utf16 = 0;
    size_t utf16_length = 0;
    char* utf16_unaccented = 0;
    size_t utf16_unaccented_length = 0;
  
    if(convert(charset, utf16be(), in, in_length, &utf16, &utf16_length) < 0) {
      return -1;
    }

    unacmaybefold_string_utf16(utf16, utf16_length, &utf16_unaccented, &utf16_unaccented_length, dofold);
    free(utf16);

    if(convert(utf16be(), charset, utf16_unaccented, utf16_unaccented_length, outp, out_lengthp) < 0) {
      return -1;
    }
    free(utf16_unaccented);
  }

  return 0;
}

int unac_string(const char* charset,
		const char* in, size_t in_length,
		char** outp, size_t* out_lengthp)
{
    return unacmaybefold_string(charset, in, in_length,
				outp, out_lengthp, 0);
}
int unacfold_string(const char* charset,
		const char* in, size_t in_length,
		char** outp, size_t* out_lengthp)
{
    return unacmaybefold_string(charset, in, in_length,
				outp, out_lengthp, 1);
}
const char* unac_version(void)
{
  return UNAC_VERSION;
}

