require 'runit/testcase'
require 'runit/cui/mytestrunner'
require 'runit/topublic'

require 'rd/rdblockparser.tab'
require 'rd/rd-struct'

include RD

class TestBlockParser < RUNIT::TestCase
  include RUNIT::ToPublic
  def setup
    @p = to_public(RDParser).new
    @p.instance_eval do
      @tree = Tree.new_with_document_struct(DocumentStructure::RD)
    end
  end
  
  def test_cut_off
    assert_equal(["aaaa"], @p.cut_off(["aaaa"]))
    assert_equal(["aaaa\n"], @p.cut_off(["aaaa\n"]))
    assert_equal(["aaaa\n"], @p.cut_off(["  aaaa\n"]))
    assert_equal(["aaaa\n", "bbbb\n"], @p.cut_off(["  aaaa\n", "  bbbb\n"]))
    assert_equal(["aaaa\n", "  bbbb\n"], @p.cut_off(["aaaa\n", "  bbbb\n"]))
    assert_equal(["aaaa\n", "  bbbb\n"], @p.cut_off([" aaaa\n", "   bbbb\n"]))
    assert_equal(["aaaa\n", "  bbbb\n", "    cccc\n"],
		 @p.cut_off([" aaaa\n", "   bbbb\n", "     cccc\n"]))
    assert_equal(["aaaa\n", "    bbbb\n", "  cccc\n"],
		 @p.cut_off([" aaaa\n", "     bbbb\n", "   cccc\n"]))
    assert_exception(RuntimeError) do
      @p.cut_off(["  aaaa\n", "bbbb\n"])
    end
  end

  def test_set_term_to_element
    desclist = to_public(DescListItem).new
    term = DescListItem::Term.new
    @p.set_term_to_element(desclist, term)
    assert_equal(term, desclist.term)

    methodlist = to_public(MethodListItem).new
    term = MethodListItem::Term.new "string"
    @p.set_term_to_element(methodlist, term)
    assert_equal(term, methodlist.term)
  end
end

if $0 == __FILE__
  RUNIT::CUI::MyTestRunner.run(TestBlockParser.suite)
end

