/*
 * @LANG: c++
 */

/*
 * Demonstrate the use of goto, call and return. This machine expects either a
 * lower case char or a digit as a command then a space followed by the command
 * arg. If the command is a char, then the arg must be an a string of chars.
 * If the command is a digit, then the arg must be a string of digits. This
 * choice is determined by action code, rather than though transition
 * desitinations.
 */

#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

using namespace std;

struct GotoCallRet
{
	char comm;
	int cs, top, stack[32];

	// Initialize the machine. Invokes any init statement blocks. Returns 0
	// if the machine begins in a non-accepting state and 1 if the machine
	// begins in an accepting state.
	int init( );

	// Execute the machine on a block of data. Returns -1 if after processing
	// the data, the machine is in the error state and can never accept, 0 if
	// the machine is in a non-accepting state and 1 if the machine is in an
	// accepting state.
	int execute( const char *data, int len );

	// Indicate that there is no more data. Returns -1 if the machine finishes
	// in the error state and does not accept, 0 if the machine finishes
	// in any other non-accepting state and 1 if the machine finishes in an
	// accepting state.
	int finish( );

};

%%{
	machine GotoCallRet;

	# A reference to a state in an unused action caused a segfault in 5.8. */
	action unusedAction { fentry(garble_line); }

	# Error machine, consumes to end of 
	# line, then starts the main line over.
	garble_line := ( (any-'\n')*'\n') 
		>{cout << "error: garbling line" << endl;} 
		@{fgoto main;}
		$!{cout << "error: failed to recover" << endl;}
		$/{cout << "error: failed to recover" << endl;};


	# Look for a string of alphas or of digits, 
	# on anything else, hold the character and return.
	alp_comm := alpha+ $!{fhold;fret;};
	dig_comm := digit+ $!{fhold;fret;};

	# Choose which to machine to call into based on the command.
	action comm_arg {
		if ( comm >= 'a' )
			fcall alp_comm;
		else 
			fcall dig_comm;
	}

	# Specifies command string. Note that the arg is left out.
	command = (
		[a-z0-9] @{comm = fc;} ' ' @comm_arg '\n'
	) @{cout << "correct command" << endl;};

	# Any number of commands. If there is an 
	# error anywhere, garble the line.
	main := command* $!{fhold;fgoto garble_line;}; 
}%%

%% write data;

int GotoCallRet::init( )
{
	%% write init;
	return 1;
}

int GotoCallRet::execute( const char *_data, int _len )
{
	const char *p = _data;
	const char *pe = _data+_len;
	%% write exec;
	if ( cs == GotoCallRet_error )
		return -1;
	if ( cs >= GotoCallRet_first_final )
		return 1;
	return 0;
}

int GotoCallRet::finish()
{
	%% write eof;
	if ( cs == GotoCallRet_error )
		return -1;
	if ( cs >= GotoCallRet_first_final )
		return 1;
	return 0;
}


void test( char *buf )
{
	GotoCallRet gcr;
	gcr.init();
	gcr.execute( buf, strlen(buf) );
	if ( gcr.finish() <= 0 )
		cout << "gotocallret: error: parsing input" << endl;
}

int main()
{
	test(
		"lkajsdf\n"
		"2134\n"
		"(\n"
		"\n"
		"*234234()0909 092 -234aslkf09`1 11\n"
		"1\n"
		"909\n"
		"1 a\n"
		"11 1\n"
		"a 1\n"
		"aa a\n"
		"1 1\n"
		"1 123456\n"
		"a a\n"
		"a abcdef\n"
	);

	test( "h" );
	test( "a aa1" );

	return 0;
}

#ifdef _____OUTPUT_____
error: garbling line
error: garbling line
error: garbling line
error: garbling line
error: garbling line
error: garbling line
error: garbling line
error: garbling line
error: garbling line
error: garbling line
error: garbling line
correct command
correct command
correct command
correct command
gotocallret: error: parsing input
error: garbling line
error: failed to recover
gotocallret: error: parsing input
#endif
