#include "allegro.h"
#include "hull_weapon.h"
#include "hull_weapon_twirl.h"
#include "ebox.h"

Twirl_WHull::Twirl_WHull( BITMAP * who, ECollide * ec ):
HullWeapon( 0, 1, 3 ) {
	collide = ec;
	ang = 0;
	Bitmap = who;
}


Twirl_WHull::~Twirl_WHull() {
	delete collide;
}


void Twirl_WHull::Draw( BITMAP * who, int x, int y ) {

	if ( Bitmap == NULL ) return;

	int mx = Bitmap->w/2;
	int my = Bitmap->h/2;
	rotate_sprite( who, Bitmap, x-mx, y-my, itofix(ang) );
	ang = ( ang + 8 ) % 256;

}
