/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE 
 * version 2. See COPYING for details.                           
 *                                                               
 * Copyright (C) 1999-2002 Harry Storbacka <harrysto@nic.fi>    
 *                                                               
*/

#include <ClanLib/core.h>
#include <ClanLib/application.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <iostream>

#include "game_config.h"
#include "config.h"
#include "graphics.h"
#include "race_text.h"
#include "debug.h"
#include "track_sfx.h"
#include "texture.h"
#include "track.h"

#include "map_objects/all.h"

#include "theme_loader.h"

// TODO: this is most likely still an ugly mess

CL_ResourceManager *ThemeLoader::res;
CL_ResourceManager ThemeLoader::main_res;
bool ThemeLoader::inited = false;
std::vector<std::string> ThemeLoader::theme_list;

void ThemeLoader::init() 
{
	if( inited == false )
	{
		RaceDebug::print("Resources: resources/race.res", 7);
		
		CL_String path = DATADIR;
		path += "resources/race.res";

		main_res = CL_ResourceManager( path, false );
		inited = true;
	}
}

std::vector<std::string> ThemeLoader::get_theme_list()
{
	if( !theme_list.empty() ) return theme_list;
	
	CL_String list_path = "data/theme_list.lst";
	
	CL_InputSourceProvider *input = CL_InputSourceProvider::create_file_provider("");
	CL_InputSource *file = input->open_source( list_path );
	
	std::vector<std::string> theme_list;
	
	bool a = true;
	while( a )
	{
		std::string fname = RaceText::read_line_get_base_name(file).get_string();
		if( fname == "#end" )
			a = false;
		else
			theme_list.push_back(fname);
	}

	delete input;
	
	return theme_list;
}

void ThemeLoader::unload_theme()
{	
	// todo: remove
	// done in load theme
}

void ThemeLoader::load_random_theme()
{
	int num = rand() % theme_list.size();
	load_theme(num);
}

void ThemeLoader::load_theme(int num)
{
	if( !inited ) init();
	
	if( get_theme_list().empty() )
	{
		std::cout << "ThemeLoader: can't load theme" << endl;
		return;
	}
	
	std::vector<std::string> theme_list = get_theme_list();
	
	CL_String path = "themes/";
	path += theme_list[num].c_str();
	path += "/";
	
	// store path in config for later use.	
	Config::theme_path = path;
	
	// path to the theme.res file
	CL_String theme_res_path = DATADIR;
	theme_res_path += path;
	theme_res_path += theme_list[num].c_str();
	theme_res_path += ".res";
	
	Config::theme_name = theme_list[num].c_str();
	
	static bool first_time = true;
	
	first_time = false;

	RaceDebug::print( CL_String("Resources: ") + theme_res_path, 7 );

	if( res != NULL )
	{
		delete res;
		res = NULL;
	}

	res = new CL_ResourceManager( theme_res_path, false );

	load_config();
	load_tiles();
	load_menu_gfx(); // results screen bg etc.

	// map_objects...

	load_fences();
	load_trees();
	load_houses();
	load_dust();
};





void ThemeLoader::load_config()
{
	try { Config::mirror_fill = CL_Boolean(  "mirror_fill", res ); }
  	catch( CL_Error err ) { Config::mirror_fill = true; }
	
	// top speed on road, ramp & bridge
	Config::road_speed = CL_Integer( "road_speed", res ) / (float)10;

	// top speed not on road, ramp or bridge
	Config::terrain_speed = CL_Integer( "terrain_speed", res ) / (float)10;

	// if skiddinig decrease speed by this value
	Config::skid_speed_decrease = CL_Integer(  "skid_speed_decrease", res ) / (float)10;

	// max angle difference between wanted angle and movement angle so that
	// car doesnt slide
	Config::tyre_grip = CL_Integer( "tyre_grip", res );

	// if no gas decrease speed by this value
	Config::no_gas_speed_decrease = (float)(CL_Integer( "no_gas_speed_decrease", res ) / (float)10);

	// if brakes on decrease speed by this value
	Config::brakes_speed_decrease = (float)(CL_Integer(  "brakes_speed_decrease", res ) / (float)10);

	Config::update_dir_timer = CL_Integer(  "update_dir_timer", res );
}







void ThemeLoader::load_tiles()
{
	if( Gfx::TrackGfx->road != NULL )
	{
		delete Gfx::TrackGfx->road;
	}

	if( Track::terrain_texture != NULL )
		delete Track::terrain_texture;
	if( Track::water != NULL )
		delete Track::water;

	Gfx::TrackGfx->bg = CL_Surface::load( "ground/ground_texture", res );
	Gfx::TrackGfx->water = CL_Surface::load( "ground/water_texture", res );
	Gfx::TrackGfx->road = CL_Surface::load( "ground/road_texture", res );

	// crash if this isn't done. (?)
	Gfx::TrackGfx->bg->put_screen(0,0);
	Gfx::TrackGfx->water->put_screen(0,0);
	Gfx::TrackGfx->road->put_screen(0,0);
	
	Track::terrain_texture = new Texture( Gfx::TrackGfx->bg );
	Track::water = new Texture( Gfx::TrackGfx->water );

	// road tiles 
	if( Gfx::TrackGfx->r_n != NULL )
	{
		delete Gfx::TrackGfx->r_n;
		delete Gfx::TrackGfx->r_e;
		delete Gfx::TrackGfx->r_w;
		delete Gfx::TrackGfx->r_s;
		delete Gfx::TrackGfx->r_ne;
		delete Gfx::TrackGfx->r_nw;
		delete Gfx::TrackGfx->r_se;
		delete Gfx::TrackGfx->r_sw;
		delete Gfx::TrackGfx->r_full;
	}   

	Gfx::TrackGfx->r_n = CL_Surface::load( "tiles/road/n", res );
	Gfx::TrackGfx->r_e = CL_Surface::load( "tiles/road/e", res );
	Gfx::TrackGfx->r_w = CL_Surface::load( "tiles/road/w", res );
	Gfx::TrackGfx->r_s = CL_Surface::load( "tiles/road/s", res );
	Gfx::TrackGfx->r_ne = CL_Surface::load( "tiles/road/ne", res );
	Gfx::TrackGfx->r_nw = CL_Surface::load( "tiles/road/nw", res );
	Gfx::TrackGfx->r_se = CL_Surface::load( "tiles/road/se", res );
	Gfx::TrackGfx->r_sw = CL_Surface::load( "tiles/road/sw", res );
	Gfx::TrackGfx->r_full = CL_Surface::load( "tiles/road/full", res );

	// start/finish line
	try { Gfx::TrackGfx->finish = CL_Surface::load( "start", res ); }
	catch( CL_Error err )
	{
		std::cout << "theme has no finish/start line gfx. Using default." << std::endl;
		Gfx::TrackGfx->finish = CL_Surface::load( "Default/start", &main_res );
	}
}


void ThemeLoader::load_fences() { Fence::load(*res); }
void ThemeLoader::load_trees() { Tree::load(*res); }
void ThemeLoader::load_houses() { House::load(*res ); }
void ThemeLoader::load_menu_gfx(){}


void ThemeLoader::load_dust()
{
	try{ Gfx::TrackGfx->dust_road_texture  = new Texture(CL_Surface::load("dust/dust", res) ); }
	catch( CL_Error err )
	{
		std::cout << "theme has no dust - using default" << std::endl;
		Gfx::TrackGfx->dust_road_texture = new Texture(CL_Surface::load("Default/dust", &main_res));
	}

	try{ Gfx::TrackGfx->dust_water_texture = new Texture( CL_Surface::load( "dust/w_dust", res)); }
	catch( CL_Error err )
	{
		std::cout << "theme has no dust_water_texture - using default" << std::endl;
		Gfx::TrackGfx->dust_water_texture = new Texture(CL_Surface::load( "Default/w_dust", &main_res));
	}
}


