#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <ClanLib/png.h>
#include <ClanLib/gui.h>

#ifdef WIN32
	#pragma warning (disable:4355)
#endif

#include "../menu_gfx.h"
#include "../../game_config.h"
#include "../../fonts.h"
#include "../../debug.h"
#include "../../keyboard.h"
#include "options_keys.h"

#define PRESS_KEY_STRING "Press a key"

OptionsKeys::OptionsKeys(CL_Component *parent, CL_StyleManager *style)
:
	CL_Component(
			CL_Rect(145, 150, CL_Display::get_width(), CL_Display::get_height()),
			parent,
			style),
	button_left(  CL_Rect( 210,  10, 210+80,  10+30), "Change", this, style ),
	button_right( CL_Rect( 210,  40, 210+80,  40+30), "Change", this, style ),
	button_gas(   CL_Rect( 210,  70, 210+80,  70+30), "Change", this, style ),
	button_brake( CL_Rect( 210, 100, 210+80, 100+30), "Change", this, style ),

	label_left(  CL_Rect(   10,  10,  10+80,  10+30), "Key Left:",  this, style ),
	label_right( CL_Rect(   10,  40,  10+80,  40+30), "Key Right:", this, style ),
	label_gas(   CL_Rect(   10,  70,  10+80,  70+30), "Key Gas:",   this, style ),
	label_brake( CL_Rect(   10, 100,  10+80, 100+30), "Key Brake:", this, style )
{
	RaceDebug::print( "OptionsKeys: constructor", 9 );

	slots.connect( sig_paint(), this, &OptionsKeys::on_paint );
	slots.connect( button_left.sig_clicked(), this, &OptionsKeys::on_select_left );
	slots.connect( button_right.sig_clicked(), this, &OptionsKeys::on_select_right );
	slots.connect( button_gas.sig_clicked(), this, &OptionsKeys::on_select_gas );
	slots.connect( button_brake.sig_clicked(), this, &OptionsKeys::on_select_brake );
}

OptionsKeys::~OptionsKeys()
{
	//
}

void OptionsKeys::on_paint()
{
	MenuGfx::submenu_frame_bg->put_screen(0,0);
}


void OptionsKeys::on_select_left()
{
	Fonts::menu_big->print_left(170,320, PRESS_KEY_STRING );
	key_left = get_key();
	CL_String str_key = "Turn Left: ";
	str_key += get_key_name(key_left);
	label_left.set_text( str_key.get_string() );
	
	Config::one_player_key_left.id = key_left;

	Keyboard::init_keys();
}

void OptionsKeys::on_select_right()
{
	Fonts::menu_big->print_left(170,320, PRESS_KEY_STRING );
	key_right = get_key();
	CL_String str_key = "Turn Right: ";
	str_key += get_key_name(key_right);
	label_right.set_text( str_key.get_string() );

	Config::one_player_key_right.id = key_right;

	Keyboard::init_keys();
}

void OptionsKeys::on_select_gas()
{
	Fonts::menu_big->print_left(170,320, PRESS_KEY_STRING );
	key_gas = get_key();
	CL_String str_key = "Gas: ";
	str_key += get_key_name(key_gas);
	label_gas.set_text( str_key.get_string() );

	Config::one_player_key_gas.id = key_gas;

	Keyboard::init_keys();
}

void OptionsKeys::on_select_brake()
{
	Fonts::menu_big->print_left(170,320, PRESS_KEY_STRING );
	key_brake = get_key();
	CL_String str_key = "Brakes: ";
	str_key += get_key_name(key_brake);
	label_brake.set_text( str_key.get_string() );
	
	Config::one_player_key_brakes.id = key_brake;

	Keyboard::init_keys();
}



int OptionsKeys::get_key()
{
	CL_InputBuffer *buf = new CL_InputBuffer( CL_Input::keyboards[0] );
	bool stop = false;
	
	CL_Key key;
	
	while(!CL_Keyboard::get_keycode( CL_KEY_ESCAPE ) && stop == false )
	{
		key = buf->peek_key();
		
		if( buf->keys_left() > 0 )
			stop = true;
		
		CL_System::keep_alive();
		CL_Display::flip_display();
	}
	
	return key.id;
}


std::string OptionsKeys::get_key_name(int key)
{
	CL_String str("");
	
	switch( key )
	{
	 case CL_KEY_A: str = "A"; break;
	 case CL_KEY_B: str = "B"; break;
	 case CL_KEY_C: str = "C"; break;
	 case CL_KEY_D: str = "D"; break;
	 case CL_KEY_E: str = "E"; break;
	 case CL_KEY_F: str = "F"; break;
	 case CL_KEY_G: str = "G"; break;
	 case CL_KEY_H: str = "H"; break;
	 case CL_KEY_I: str = "I"; break;
	 case CL_KEY_J: str = "J"; break;
	 case CL_KEY_K: str = "K"; break;
	 case CL_KEY_L: str = "L"; break;
	 case CL_KEY_M: str = "M"; break;
	 case CL_KEY_N: str = "N"; break;
	 case CL_KEY_O: str = "O"; break;
	 case CL_KEY_P: str = "P"; break;
	 case CL_KEY_Q: str = "Q"; break;
	 case CL_KEY_R: str = "R"; break;
	 case CL_KEY_S: str = "S"; break;
	 case CL_KEY_T: str = "T"; break;
	 case CL_KEY_U: str = "U"; break;
	 case CL_KEY_V: str = "V"; break;
	 case CL_KEY_W: str = "W"; break;
	 case CL_KEY_X: str = "X"; break;
	 case CL_KEY_Y: str = "Y"; break;
	 case CL_KEY_Z: str = "Z"; break;
	 case CL_KEY_0: str = "0"; break;
	 case CL_KEY_1: str = "1"; break;
	 case CL_KEY_2: str = "2"; break;
	 case CL_KEY_3: str = "3"; break;
	 case CL_KEY_4: str = "4"; break;
	 case CL_KEY_5: str = "5"; break;
	 case CL_KEY_6: str = "6"; break;
	 case CL_KEY_7: str = "7"; break;
	 case CL_KEY_8: str = "8"; break;
	 case CL_KEY_9: str = "9"; break;
	 case CL_KEY_F1:  str = "F1"; break;
	 case CL_KEY_F2:  str = "F2"; break;
	 case CL_KEY_F3:  str = "F3"; break;
	 case CL_KEY_F4:  str = "F4"; break;
	 case CL_KEY_F5:  str = "F5"; break;
	 case CL_KEY_F6:  str = "F6"; break;
	 case CL_KEY_F7:  str = "F7"; break;
	 case CL_KEY_F8:  str = "F8"; break;
	 case CL_KEY_F9:  str = "F9"; break;
	 case CL_KEY_F10:  str = "F10"; break;
	 case CL_KEY_F11:  str = "F11"; break;
	 case CL_KEY_F12:  str = "F12"; break;
	 case CL_KEY_ESCAPE: str = "Escape"; break;
	 case CL_KEY_LEFT: str = "Left"; break;
	 case CL_KEY_UP: str = "Up"; break;
	 case CL_KEY_DOWN: str = "Down"; break;
	 case CL_KEY_RIGHT: str = "Right"; break;
	 case CL_KEY_LCTRL: str = "L_Ctrl"; break;
	 case CL_KEY_RCTRL: str = "R_Ctrl"; break;
	 case CL_KEY_LSHIFT: str = "L_Shift"; break;
	 case CL_KEY_RSHIFT: str = "R_Shift"; break;
	 case CL_KEY_ALT: str = "Alt"; break;
	 case CL_KEY_ALTGR: str = "Alt Gr"; break;
	 case CL_KEY_TAB: str = "Tab"; break;
	 case CL_KEY_ENTER: str = "Enter"; break;
	 case CL_KEY_SPACE: str = "Space"; break;
	 case CL_KEY_INSERT: str = "Insert"; break;
	 case CL_KEY_DELETE: str = "Delete"; break;
	 case CL_KEY_HOME: str = "Home"; break;
	 case CL_KEY_END: str = "End"; break;
	 case CL_KEY_PAGEUP: str = "Page Up"; break;
	 case CL_KEY_PAGEDOWN: str = "Page Down"; break;
	 case CL_KEY_CAPSLOCK: str = "Caps Lock"; break;
	 case CL_KEY_NUMLOCK: str = "Num Lock"; break;
	 case CL_KEY_SCRLOCK: str = "Scroll Lock"; break;
	 case CL_KEY_PRINT: str = "Print Screen"; break;
	 case CL_KEY_PAUSE: str = "Pause"; break;
	 case CL_KEY_KP_0: str = "KP 0"; break;
	 case CL_KEY_KP_1: str = "KP 1"; break;
	 case CL_KEY_KP_2: str = "KP 2"; break;
	 case CL_KEY_KP_3: str = "KP 3"; break;
	 case CL_KEY_KP_4: str = "KP 4"; break;
	 case CL_KEY_KP_5: str = "KP 5"; break;
	 case CL_KEY_KP_6: str = "KP 6"; break;
	 case CL_KEY_KP_7: str = "KP 7"; break;
	 case CL_KEY_KP_8: str = "KP 8"; break;
	 case CL_KEY_KP_9: str = "KP 9"; break;
	 case CL_KEY_KP_DIV: str = "KP Div"; break;
	 case CL_KEY_KP_MULT: str = "KP Mult"; break;
	 case CL_KEY_KP_MINUS: str = "KP Minus"; break;
	 case CL_KEY_KP_PLUS: str = "KP Plus"; break;
	 case CL_KEY_KP_ENTER: str = "KP Enter"; break;
	 case CL_KEY_NONE_OF_THE_ABOVE: str = "CL_KEY_NONE_OF_THE_ABOVE"; break;
	 case CL_NUM_KEYS: str = "CL_NUM_KEYS"; break;
	}
	
	return str;
}
