#
# rubyloader.rb
#
#   Copyright (c) 1999-2001 Minero Aoki <aamine@loveruby.net>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'rbconfig'


module RubyLoader

  module_function

  def find_feature( feature )
    with_ext( feature ) do |fname|
      $LOAD_PATH.each do |dir|
        path = dir + '/' + fname
        if File.file? path then
          return path
        end
      end
    end

    nil
  end

  def provided?( feature )
    with_ext( feature ) do |fn|
      $".index fn and return true
    end

    false
  end

  alias required? provided?

  def provide( feature )
    $".push feature
  end

  def with_ext( feature )
    if /\.(?:rb|#{Config::CONFIG['DLEXT']})\z/o === feature then
      yield feature
    else
      [ 'rb', Config::CONFIG['DLEXT'] ].each do |ext|
        yield feature + '.' + ext
      end
    end
  end

end
