#
# protect.rb
#
#   Copyright (c) 1999-2001 Minero Aoki <aamine@loveruby.net>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

def protect( place = nil )
  begin
    yield
  rescue StandardError, ScriptError
    $stderr.puts 'Error in ' + place if place
    print_backtrace $!
    nil
  end
end

def print_backtrace( err )
  $stderr.print err.to_s, " (#{err.type})\n"
  err.backtrace.each {|i| $stderr.puts i }
end
