#
# daemon.rb
#

require 'socket'


class Daemon

  def self.exec( port, dir, debug = $DEBUG )
    new(debug).exec port, dir
  end

  def initialize( debug = $DEBUG )
    @debug = $DEBUG
  end

  def exec( port, dir )
    if @debug then
      Dir.chdir dir
      wait 
      return
    end

    fork do
      Process.setsid
      fork do
        Dir.chdir dir
        $stdin.close
        $stdout.close
        $stderr.close

        wait
      end

      exit!
    end
    exit!
  end

  def wait
    s = TCPServer.open( 10070 )

    unless @debug then
      trap( 'SIGINT' ) { exit! }
      trap( 'SIGHUP' ) { exit! }
      trap( 'SIGTERM' ) { exit! }
    end

    while true do
      @sock = s.accept
      begin
        session
      ensure
        @sock.close
      end
    end
  end

  # def session

end
