% Generated by roxygen2 (4.0.2): do not edit by hand
\name{evaluate_promise}
\alias{evaluate_promise}
\title{Evaluate a promise, capturing all types of output.}
\usage{
evaluate_promise(code, print = FALSE)
}
\arguments{
\item{code}{Code to evaluate. This should be an unevaluated expression.}

\item{print}{If \code{TRUE} and the result of evaluating \code{code} is
visible this will print the result, ensuring that the output of printing
the object is included in the overall output}
}
\value{
A list containing
 \item{result}{The result of the function}
 \item{output}{A string containing all the output from the function}
 \item{warnings}{A character vector containing the text from each warning}
 \item{messages}{A character vector containing the text from each message}
}
\description{
This uses \code{\link[evaluate]{evaluate}} a promise, returning the
result, test, messages and warnings that the code creates in a list.
It is used to evaluate code for all test that tests, ensuring that
(as much as possible) any spurious output is suppressed during the
testing process.
}
\examples{
evaluate_promise({
  print("1")
  message("2")
  warning("3")
  4
})
}

