% Generated by roxygen2 (4.0.2): do not edit by hand
\name{describe}
\alias{describe}
\title{describe: a BDD testing language}
\usage{
describe(description, code)
}
\arguments{
\item{description}{description of the feature}

\item{code}{test code containing the specs}
}
\description{
A simple BDD DSL for writing tests. The language is similiar to RSpec for
Ruby or Mocha for JavaScript. BDD tests read like sentences and it should
thus be easier to understand what the specification of a function/component
is.
}
\details{
Tests using the \code{describe} syntax not only verify the tested code, but
also document its intended behaviour. Each \code{describe} block specifies a
larger component or function and contains a set of specifications. A
specification is definied by an \code{it} block. Each \code{it} block
functions as a test and is evaluated in its own environment. You
can also have nested \code{describe} blocks.

This test syntax helps to test the intented behaviour of your code. For
example: you want to write a new function for your package. Try to describe
the specification first using \code{describe}, before your write any code.
After that, you start to implement the tests for each specification (i.e.
the \code{it} block).

Use \code{describe} to verify that you implement the right things and use
\code{\link{test_that}} to ensure you do the things right.
}
\examples{
describe("matrix()", {
  it("can be multiplied by a scalar", {
    m1 <- matrix(1:4, 2, 2)
    m2 <- m1 * 2
    expect_equivalent(matrix(1:4 * 2, 2, 2), m2)
  })
  it("can have not yet tested specs")
})

# Nested specs:
## code
addition <- function(a, b) a + b
division <- function(a, b) a / b

## specs
describe("math library", {
  describe("addition()", {
    it("can add two numbers", {
      expect_equivalent(1 + 1, addition(1, 1))
    })
  })
  describe("division()", {
    it("can divide two numbers", {
      expect_equivalent(10 / 2, division(10, 2))
    })
    it("can handle division by 0") #not yet implemented
  })
})
}

