% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{geos_combine}
\alias{geos_combine}
\alias{st_combine}
\alias{geos_combine}
\alias{st_union}
\title{Combine or union feature geometries}
\usage{
st_combine(x)

st_union(x, y, ..., by_feature = FALSE)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{y}{object of class \code{sf}, \code{sfc} or \code{sfg} (optional)}

\item{...}{ignored}

\item{by_feature}{logical; if TRUE, union each feature, if FALSE return a single feature that is the geometric union of the set of features}
}
\value{
\code{st_combine} returns a single, combined geometry, with no resolved boundaries; returned geometries may well be invalid.

If \code{y} is missing, \code{st_union(x)} returns a single geometry with resolved boundaries, else the geometries for all unioned pairs of x[i] and y[j].
}
\description{
Combine several feature geometries into one, without unioning or resolving internal boundaries
}
\details{
\code{st_combine} combines geometries without resolving borders, using \link{c.sfg} (analogous to \link[base]{c} for ordinary vectors).

If \code{st_union} is called with a single argument, \code{x}, (with \code{y} missing) and \code{by_feature} is \code{FALSE} all geometries are unioned together and an \code{sfg} or single-geometry \code{sfc} object is returned. If \code{by_feature} is \code{TRUE} each feature geometry is unioned. This can for instance be used to resolve internal boundaries after polygons were combined using \code{st_combine}. If \code{y} is provided, all elements of \code{x} and \code{y} are unioned, pairwise (and \code{by_feature} is ignored). The former corresponds to \link[rgeos]{gUnaryUnion}, the latter to \link[rgeos]{gUnion}.

Unioning a set of overlapping polygons has the effect of merging the areas (i.e. the same effect as iteratively unioning all individual polygons together). Unioning a set of LineStrings has the effect of fully noding and dissolving the input linework. In this context "fully noded" means that there will be a node or endpoint in the output for every endpoint or line segment crossing in the input. "Dissolved" means that any duplicate (e.g. coincident) line segments or portions of line segments will be reduced to a single line segment in the output.	Unioning a set of Points has the effect of merging all identical points (producing a set with no duplicates).
}
\examples{
nc = st_read(system.file("shape/nc.shp", package="sf"))
st_combine(nc)
plot(st_union(nc))
}
\seealso{
\link{st_intersection}, \link{st_difference}, \link{st_sym_difference}
}
