% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-dev.R
\name{install_dev}
\alias{install_dev}
\title{Install the development version of a package}
\usage{
install_dev(package, cran_url = getOption("repos")[["CRAN"]], ...)
}
\arguments{
\item{package}{The package name to install.}

\item{cran_url}{The URL of the CRAN mirror to use, by default based on the
'repos' option. If unset uses 'https://cloud.r-project.org'.}

\item{...}{Additional arguments passed to \code{\link[=install_github]{install_github()}},
\code{\link[=install_gitlab]{install_gitlab()}}, or \code{\link[=install_bitbucket]{install_bitbucket()}} functions.}
}
\description{
\code{install_dev()} retrieves the package DESCRIPTION from the CRAN mirror and
looks in the 'URL' and 'BugReports' fields for GitHub, GitLab or Bitbucket
URLs. It then calls the appropriate \code{install_()} function to install the
development package.
}
\examples{
\dontrun{
# From GitHub
install_dev("dplyr")

# From GitLab
install_dev("iemiscdata")

# From Bitbucket
install_dev("argparser")
}
}
\seealso{
Other package installation: 
\code{\link{install_bioc}()},
\code{\link{install_bitbucket}()},
\code{\link{install_cran}()},
\code{\link{install_github}()},
\code{\link{install_gitlab}()},
\code{\link{install_git}()},
\code{\link{install_local}()},
\code{\link{install_svn}()},
\code{\link{install_url}()},
\code{\link{install_version}()}
}
\concept{package installation}
