% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/iterators.R
\name{V}
\alias{V}
\title{Vertices of a graph}
\usage{
V(graph)
}
\arguments{
\item{graph}{The graph}
}
\value{
A vertex sequence containing all vertices, in the order
  of their numeric vertex ids.
}
\description{
Create a vertex sequence (vs) containing all vertices of a graph.
}
\details{
A vertex sequence is just what the name says it is: a sequence of
vertices. Vertex sequences are usually used as igraph function arguments
that refer to vertices of a graph.

A vertex sequence is tied to the graph it refers to: it really denoted
the specific vertices of that graph, and cannot be used together with
another graph.

At the implementation level, a vertex sequence is simply a vector
containing numeric vertex ids, but it has a special class attribute
which makes it possible to perform graph specific operations on it, like
selecting a subset of the vertices based on graph structure, or vertex
attributes.

A vertex sequence is most often created by the \code{V()} function. The
result of this includes all vertices in increasing vertex id order. A
vertex sequence can be indexed by a numeric vector, just like a regular
R vector. See \code{\link{[.igraph.vs}} and additional links to other
vertex sequence operations below.
}
\section{Indexing vertex sequences}{

Vertex sequences mostly behave like regular vectors, but there are some
additional indexing operations that are specific for them;
e.g. selecting vertices based on graph structure, or based on vertex
attributes. See \code{\link{[.igraph.vs}} for details.
}

\section{Querying or setting attributes}{

Vertex sequences can be used to query or set attributes for the
vertices in the sequence. See \code{\link{$.igraph.vs}} for details.
}
\examples{
# Vertex ids of an unnamed graph
g <- make_ring(10)
V(g)

# Vertex ids of a named graph
g2 <- make_ring(10) \%>\%
  set_vertex_attr("name", value = letters[1:10])
V(g2)
}
\seealso{
Other vertex and edge sequences: \code{\link{$.igraph.es}},
  \code{\link{$<-.igraph.es}}, \code{\link{E<-}},
  \code{\link{[<-.igraph.es}},
  \code{\link{[[<-.igraph.es}},
  \code{\link{igraph-es-attributes}},
  \code{\link{igraph-es-attributes}},
  \code{\link{igraph-es-attributes}},
  \code{\link{igraph-es-attributes}},
  \code{\link{igraph-es-attributes}};
  \code{\link{$.igraph.vs}}, \code{\link{$<-.igraph.vs}},
  \code{\link{V<-}}, \code{\link{[<-.igraph.vs}},
  \code{\link{[[<-.igraph.vs}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}}; \code{\link{E}};
  \code{\link{[.igraph.es}}, \code{\link{\%--\%}},
  \code{\link{\%->\%}}, \code{\link{\%<-\%}},
  \code{\link{igraph-es-indexing}};
  \code{\link{[.igraph.vs}},
  \code{\link{igraph-vs-indexing}};
  \code{\link{[[.igraph.es}},
  \code{\link{igraph-es-indexing2}};
  \code{\link{[[.igraph.vs}},
  \code{\link{igraph-vs-indexing2}};
  \code{\link{print.igraph.es}};
  \code{\link{print.igraph.vs}}
}

