% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/grouped-dt.r
\name{grouped_dt}
\alias{grouped_dt}
\alias{is.grouped_dt}
\title{A grouped data table.}
\usage{
grouped_dt(data, vars, copy = TRUE)

is.grouped_dt(x)
}
\arguments{
\item{data}{a tbl or data frame.}

\item{vars}{a list of quoted variables.}

\item{copy}{If \code{TRUE}, will make copy of input.}

\item{x}{an object to check}
}
\description{
The easiest way to create a grouped data table is to call the \code{group_by}
method on a data table or tbl: this will take care of capturing
the unevalated expressions for you.
}
\examples{
if (require("data.table") && require("nycflights13")) {
flights_dt <- tbl_dt(flights)
group_size(group_by(flights_dt, year, month, day))
group_size(group_by(flights_dt, dest))

monthly <- group_by(flights_dt, month)
summarise(monthly, n = n(), delay = mean(arr_delay))
}
}

