% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/almostAllAccessors.R
\name{sample_variables}
\alias{sample_variables}
\title{Get the sample variables present in sample_data}
\usage{
sample_variables(physeq, errorIfNULL=TRUE)
}
\arguments{
\item{physeq}{(Required). \code{\link{sample_data-class}}, or \code{\link{phyloseq-class}}.}

\item{errorIfNULL}{(Optional). Logical. Should the accessor stop with 
an error if the slot is empty (\code{NULL})? Default \code{TRUE}.}
}
\value{
Character vector. The names of the variables in the sample_data
 data.frame. Essentially the column names. Useful for selecting model 
 and graphics parameters that interact with sample_data.
}
\description{
This is a simple accessor function to make it more convenient to determine
the sample variable names of a particular \code{\link{phyloseq-class}} object.
}
\examples{
data(enterotype)
sample_variables(enterotype)
}
\seealso{
\code{\link{get_taxa}}
 \code{\link{taxa_names}}
 \code{\link{sample_names}}
}

