% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO-methods.R
\name{import_mothur_constaxonomy}
\alias{import_mothur_constaxonomy}
\title{Import mothur constaxonomy file and return a taxonomyTable}
\usage{
import_mothur_constaxonomy(mothur_constaxonomy_file,
  parseFunction = parse_taxonomy_default)
}
\arguments{
\item{mothur_constaxonomy_file}{(Required). A 
\href{http://www.mothur.org/wiki/Constaxonomy_file}{consensus taxonomy file} 
produced by \emph{mothur}.}

\item{parseFunction}{(Optional). A specific function used for parsing the taxonomy string.
See \code{\link{parse_taxonomy_default}} for an example. If the default is
used, this function expects a semi-colon delimited taxonomy string, with
no additional rank specifier. A common taxonomic database is GreenGenes,
and for recent versions its taxonomy includes a prefix, which is best cleaved
and used to precisely label the ranks (\code{\link{parse_taxonomy_greengenes}}).}
}
\value{
An \code{\link{taxonomyTable-class}} object.
}
\description{
Import mothur constaxonomy file and return a taxonomyTable
}
\seealso{
\code{\link{import_mothur}}

\code{\link{tax_table}}

\code{\link{phyloseq}}
}
\keyword{internal}

