% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance-methods.R
\docType{methods}
\name{distance}
\alias{distance}
\alias{distance,otu_table,character-method}
\alias{distance,phyloseq,ANY-method}
\alias{distance,phyloseq,character-method}
\title{Calculate distance, dissimilarity}
\usage{
distance(physeq, method, type = "samples", ...)

\S4method{distance}{phyloseq,ANY}(physeq, method)

\S4method{distance}{otu_table,character}(physeq, method, type = "samples",
  ...)

\S4method{distance}{phyloseq,character}(physeq, method, type = "samples", ...)
}
\arguments{
\item{physeq}{(Required).  A \code{\link{phyloseq-class}} or
an \code{\link{otu_table-class}} object. The latter is only appropriate
for methods that do not require any additional data (one-table). 
For example, the ``wunifrac'' option (\code{\link{UniFrac}}) requires
\code{\link{phyloseq-class}} that contains both an \code{otu_table}
and a phylogenetic tree (\code{phylo}).}

\item{method}{(Required). A character string. 
 Provide one of the currently supported options. 
 See \code{\link{distanceMethodList}} for a detailed list 
 of the supported options here,
 and links to accompanying documentation.
 
 Note that for the common definition of \code{Jaccard} distance
 using the \code{vegan-package} implementation,
 an additional argument is needed, with the full call having the form:
 \code{distance(physeq, method = "jaccard", binary = TRUE)}
 
 The following methods are implemented explicitly within
 the \code{\link{phyloseq-package}}, 
 and accessed by the following \code{method} options:
 
 \describe{
  \item{\code{"unifrac"}}{Original (unweighted) UniFrac distance,
        \code{\link[phyloseq]{UniFrac}}}
  \item{\code{"wunifrac"}}{weighted-UniFrac distance, \code{\link[phyloseq]{UniFrac}}}
  \item{\code{"dpcoa"}}{
    sample-wise distance used in 
    Double Principle Coordinate Analysis, \code{\link[phyloseq]{DPCoA}}}
  \item{\code{"jsd"}}{Jensen-Shannon Divergence, \code{\link{JSD}}}
 }

 Alternatively, you can provide
 a character string that defines a custom distance method, if it has the form
 described in \code{\link{designdist}}.}

\item{type}{(Optional). A character string. The type of pairwise comparisons
being calculated: sample-wise or taxa-wise. The default is 
\code{c("samples")}.}

\item{...}{Additional arguments passed on to the appropriate distance 
function, determined by the \code{method} argument.}
}
\value{
An object of class ``\code{\link{dist}}'' suitable for certain 
 ordination methods and other distance-based analyses.
}
\description{
Takes a \code{\link{phyloseq-class}} object and method option, and returns
 a \code{\link{dist}}ance object suitable for certain 
 ordination methods and other distance-based analyses. 
 Only
 sample-wise distances are currently supported (the \code{type} argument),
 but eventually species-wise (OTU-wise)
 distances may be supported as well.
}
\details{
Depending on the \code{method}
 argument, \code{distance()} wraps one of 
 \code{\link{UniFrac}},
 \code{\link{DPCoA}},
 \code{\link{JSD}},
 \code{\link[vegan]{vegdist}},
 \code{\link[vegan]{betadiver}},
 \code{\link[vegan]{designdist}}, or
 \code{\link{dist}}.
}
\examples{
data(esophagus)
distance(esophagus, "uunifrac") # Unweighted UniFrac
distance(esophagus, "wunifrac") # weighted UniFrac
distance(esophagus, "jaccard", binary = TRUE) # vegdist jaccard
distance(esophagus, "gower") # vegdist option "gower"
distance(esophagus, "g") # designdist method option "g"
distance(esophagus, "minkowski") # invokes a method from the base dist() function.
distance(esophagus, "(A+B-2*J)/(A+B)") # designdist custom distance
distanceMethodList
help("distance")
}
\seealso{
\code{\link{plot_ordination}}, 
 \code{\link{UniFrac}},
 \code{\link{DPCoA}},
 \code{\link{JSD}},
 \code{\link[vegan]{vegdist}},
 \code{\link[vegan]{betadiver}},
 \code{\link[vegan]{designdist}},
 \code{\link{dist}}.
}

