% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordination-methods.R
\name{DPCoA}
\alias{DPCoA}
\title{Calculate Double Principle Coordinate Analysis (DPCoA) 
using phylogenetic distance}
\usage{
DPCoA(physeq, correction = cailliez, scannf = FALSE, ...)
}
\arguments{
\item{physeq}{(Required). A \code{\link{phyloseq-class}} object
containing, at a minimum, abundance (\code{\link{otu_table-class}}) and 
phylogenetic (\code{\link[ape]{phylo}}) components.
As a test, the accessors \code{\link{otu_table}} and \code{\link{phy_tree}}
should return an object without error.}

\item{correction}{(Optional). A function. The function must be
 able to take a non-Euclidean \code{\link{dist}}ance object,
 and return a new \code{dist}ance object that is Euclidean.
 If testing a distance object, try \code{\link[ade4]{is.euclid}}.

 In most real-life, real-data applications, the phylogenetic tree 
 will not provide a Euclidean distance matrix, and so a correction
 will be needed. 
 Two recommended correction methods are
 \code{\link[ade4]{cailliez}} and \code{\link[ade4]{lingoes}}.
 The default is \code{cailliez},
 but not for any particularly special reason. If the patristic 
 distance matrix turns out to be Euclidian, no correction will be 
 performed, regardless of the value of the \code{correction} argument.}

\item{scannf}{(Optional). Logical. Default is \code{FALSE}. This
is passed directly to \code{\link[ade4]{dpcoa}}, and causes a
barplot of eigenvalues to be created if \code{TRUE}. This is not
included in \code{...} because the default for \code{\link[ade4]{dpcoa}}
is \code{TRUE}, although in many expected situations we would want
to suppress creating the barplot.}

\item{...}{Additional arguments passed to \code{\link[ade4]{dpcoa}}.}
}
\value{
A \code{dpcoa}-class object (see \code{\link[ade4]{dpcoa}}).
}
\description{
Function uses abundance (\code{\link{otu_table-class}}) and 
phylogenetic (\code{\link[ape]{phylo}}) components of a 
\code{\link{phyloseq-class}} experiment-level object
to perform a
Double Principle Coordinate Analysis (DPCoA), relying heavily on 
the underlying (and more general) function, \code{\link[ade4]{dpcoa}}.
The distance object ultimately provided as the cophenetic/patristic
(\code{\link[ape]{cophenetic.phylo}}) distance between the species.
}
\details{
In most real-life, real-data applications, the phylogenetic tree 
will not provide a Euclidean distance matrix, and so a correction
will be performed, if needed. See \code{correction} argument.
}
\examples{
# # # # # # Esophagus
data(esophagus)
eso.dpcoa <- DPCoA(esophagus)
eso.dpcoa
plot_ordination(esophagus, eso.dpcoa, "samples")
plot_ordination(esophagus, eso.dpcoa, "species")
plot_ordination(esophagus, eso.dpcoa, "biplot")
#
#
# # # # # # GlobalPatterns
data(GlobalPatterns)
# subset GP to top-150 taxa (to save computation time in example)
keepTaxa <- names(sort(taxa_sums(GlobalPatterns), TRUE)[1:150])
GP       <- prune_taxa(keepTaxa, GlobalPatterns)
# Perform DPCoA
GP.dpcoa <- DPCoA(GP)
plot_ordination(GP, GP.dpcoa, color="SampleType")
}
\author{
Julia Fukuyama \email{julia.fukuyama@gmail.com}.
 Adapted for phyloseq by Paul J. McMurdie.
}
\references{
Pavoine, S., Dufour, A.B. and Chessel, D. (2004) 
From dissimilarities among species to dissimilarities among communities: 
a double principal coordinate analysis.
Journal of Theoretical Biology, 228, 523-537.
}
\seealso{
\code{\link[ade4]{dpcoa}}
}

