% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitTimeSeries.R
\name{trapz}
\alias{trapz}
\title{Trapezoidal Integration}
\usage{
trapz(x, y)
}
\arguments{
\item{x}{x-coordinates of points on the x-axis}

\item{y}{y-coordinates of function values}
}
\value{
Approximated integral of the function from 'min(x)' to 'max(x)'. 
 Or a matrix of the same size as 'y'.
}
\description{
Compute the area of a function with values 'y' at the points 'x'.
Function comes from the pracma package.
}
\examples{

# Calculate the area under the sine curve from 0 to pi:
 n <- 101
 x <- seq(0, pi, len = n)
 y <- sin(x)
 trapz(x, y)          #=> 1.999835504

# Use a correction term at the boundary: -h^2/12*(f'(b)-f'(a))
 h  <- x[2] - x[1]
 ca <- (y[2]-y[1]) / h
 cb <- (y[n]-y[n-1]) / h
 trapz(x, y) - h^2/12 * (cb - ca)  #=> 1.999999969

}

