% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeMRexperiments.R
\name{mergeMRexperiments}
\alias{mergeMRexperiments}
\title{Merge two MRexperiment objects together}
\usage{
mergeMRexperiments(x, y)
}
\arguments{
\item{x}{MRexperiment-class object 1.}

\item{y}{MRexperiment-class object 2.}
}
\value{
Merged MRexperiment-class object.
}
\description{
This function will take two MRexperiment objects and merge them together finding common
OTUs. If there are OTUs not found in one of the two MRexperiments then a message will
announce this and values will be coerced to zero for the second table.
}
\examples{
data(mouseData)
newobj = mergeMRexperiments(mouseData,mouseData)
newobj

# let me know if people are interested in an option to merge by keys instead of row names.
data(lungData)
newobj = mergeMRexperiments(mouseData,lungData)
newobj
}

