% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitZeroLogNormal.R
\name{fitZeroLogNormal}
\alias{fitZeroLogNormal}
\title{Compute the log fold-change estimates for the zero-inflated log-normal model}
\usage{
fitZeroLogNormal(obj, mod, coef = 2, szero = TRUE, spos = TRUE)
}
\arguments{
\item{obj}{A MRexperiment object with count data.}

\item{mod}{The model for the count distribution.}

\item{coef}{Coefficient of interest to grab log fold-changes.}

\item{szero}{TRUE/FALSE, shrink zero component parameters.}

\item{spos}{TRUE/FALSE, shrink positive component parameters.}
}
\value{
A list of objects including:
\itemize{
 \item{logFC - the log fold-change estimates}
 \item{adjFactor  - the adjustment factor based on the zero component}
 \item{se - standard error estimates}
 \item{fitln - parameters from the log-normal fit}
 \item{fitzero - parameters from the logistic fit}
 \item{zeroRidge - output from the ridge regression}
 \item{posRidge - output from the ridge regression}
 \item{tauPos - estimated tau^2 for positive component}
 \item{tauZero - estimated tau^2 for zero component}
 \item{exclude - features to exclude for various reasons, e.g. all zeros}
 \item{zeroExclude - features to exclude for various reasons, e.g. all zeros}
}
}
\description{
Run the zero-inflated log-normal model given a MRexperiment object
and model matrix. Not for the average user, assumes structure of the model matrix.
}
\seealso{
\code{\link{cumNorm}} \code{\link{fitFeatureModel}}
}

