% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPA.R
\name{fitPA}
\alias{fitPA}
\title{Wrapper to run fisher's test on presence/absence of a feature.}
\usage{
fitPA(obj, cl, thres = 0, adjust.method = "fdr", cores = 1, ...)
}
\arguments{
\item{obj}{A MRexperiment object with a count matrix, or a simple count
matrix.}

\item{cl}{Group comparison}

\item{thres}{Threshold for defining presence/absence.}

\item{adjust.method}{Method to adjust p-values by. Default is "FDR". Options
include "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr",
"none". See \code{\link{p.adjust}} for more details.}

\item{cores}{Number of cores to use.}

\item{...}{Extra parameters for makeCluster}
}
\value{
Matrix of odds ratios, p-values, lower and upper confidence intervals
}
\description{
This function returns a data frame of p-values, odds ratios, lower and upper
confidence limits for every row of a matrix.
}
\examples{

data(lungData)
k = grep("Extraction.Control",pData(lungData)$SampleType)
lungTrim = lungData[,-k]
lungTrim = lungTrim[-which(rowSums(MRcounts(lungTrim)>0)<20),]
res = fitPA(lungTrim,pData(lungTrim)$SmokingStatus);
head(res)

}
\seealso{
\code{\link{cumNorm}} \code{\link{fitZig}} \code{\link{fitDO}} \code{\link{fitMeta}}
}

