% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumNormStat.R
\name{cumNormStat}
\alias{cumNormStat}
\title{Cumulative sum scaling percentile selection}
\usage{
cumNormStat(obj, qFlag = TRUE, pFlag = FALSE, rel = 0.1, ...)
}
\arguments{
\item{obj}{A matrix or MRexperiment object.}

\item{qFlag}{Flag to either calculate the proper percentile using
R's step-wise quantile function or approximate function.}

\item{pFlag}{Plot the relative difference of the median deviance from the reference.}

\item{rel}{Cutoff for the relative difference from one median difference
from the reference to the next}

\item{...}{Applicable if pFlag == TRUE. Additional plotting parameters.}
}
\value{
Percentile for which to scale data
}
\description{
Calculates the percentile for which to sum counts up to and scale by.
cumNormStat might be deprecated one day. Deviates from methods in Nature Methods paper
by making use row means for generating reference.
}
\examples{

data(mouseData)
p = round(cumNormStat(mouseData,pFlag=FALSE),digits=2)

}
\seealso{
\code{\link{fitZig}} \code{\link{cumNorm}} \code{\link{cumNormStatFast}}
}

