% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationTest.R
\name{correlationTest}
\alias{corTest}
\alias{correlationTest}
\title{Correlation of each row of a matrix or MRexperiment object}
\usage{
correlationTest(obj, y = NULL, method = "pearson",
  alternative = "two.sided", norm = TRUE, log = TRUE, cores = 1,
  override = FALSE, ...)
}
\arguments{
\item{obj}{A MRexperiment object or count matrix.}

\item{y}{Vector of length ncol(obj) to compare to.}

\item{method}{One of 'pearson','spearman', or 'kendall'.}

\item{alternative}{Indicates the alternative hypothesis and must be one of 'two.sided', 'greater' (positive) or 'less'(negative). You can specify just the initial letter.}

\item{norm}{Whether to aggregate normalized counts or not - if MRexperiment object.}

\item{log}{Whether or not to log2 transform the counts - if MRexperiment object.}

\item{cores}{Number of cores to use.}

\item{override}{If the number of rows to test is over a thousand the test will not commence (unless override==TRUE).}

\item{...}{Extra parameters for mclapply.}
}
\value{
A matrix of size choose(number of rows, 2) by 2. The first column corresponds to the correlation value. The second column the p-value.
}
\description{
Calculates the (pairwise) correlation statistics and associated p-values of a matrix
or the correlation of each row with a vector.
}
\examples{

# Pairwise correlation of raw counts
data(mouseData)
cors = correlationTest(mouseData[1:10,],norm=FALSE,log=FALSE)
head(cors)

mat = MRcounts(mouseData)[1:10,]
cormat = as.matrix(dist(mat)) # Creating a matrix
cormat[cormat>0] = 0 # Creating an empty matrix
ind = correctIndices(nrow(mat))
cormat[upper.tri(cormat)][ind] = cors[,1] 
table(cormat[1,-1] - cors[1:9,1])

# Correlation of raw counts with a vector (library size in this case)
data(mouseData)
cors = correlationTest(mouseData[1:10,],libSize(mouseData),norm=FALSE,log=FALSE)
head(cors)

}
\seealso{
\code{\link{correctIndices}}
}

