% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biom2MRexperiment.R
\name{biom2MRexperiment}
\alias{biom2MRexperiment}
\title{Biom to MRexperiment objects}
\usage{
biom2MRexperiment(obj)
}
\arguments{
\item{obj}{The biom object file.}
}
\value{
A MRexperiment object.
}
\description{
Wrapper to convert biom files to MRexperiment objects.
}
\examples{

library(biomformat)
rich_dense_file = system.file("extdata", "rich_dense_otu_table.biom", package = "biomformat")
x = biomformat::read_biom(rich_dense_file)
biom2MRexperiment(x)

}
\seealso{
\code{\link{loadMeta}} \code{\link{loadPhenoData}} \code{\link{newMRexperiment}} \code{\link{loadBiom}}
}

