% File src/library/tools/man/rtags.Rd
% Part of the R package, http://www.R-project.org
% Copyright 2008 R Core Development Team
% Distributed under GPL 2 or later

\name{rtags}
\alias{rtags}
\title{ An etags-like a tagging utility for R }
\description{
  \code{rtags} provides etags-like indexing capabilities for R code,
  using R's own parser.
}
\usage{
rtags(path = ".", pattern = "\\\\.[RrSs]$",
      recursive = FALSE,
      src = list.files(path = path, pattern = pattern,
                       full.names = TRUE,
                       recursive = recursive),
      keep.re = NULL,
      ofile = "", append = FALSE,
      verbose = getOption("verbose"))
}

\arguments{
  \item{path, pattern, recursive}{
    Arguments passed on to \code{\link{list.files}} to determine the
    files to be tagged.  By default, these are all files with extension
    \code{.R}, \code{.r}, \code{.S}, and \code{.s} in the current
    directory.  These arguments are ignored if \code{src} is specified.
  }
  \item{src}{
    A vector of file names to be indexed.
  }
  \item{keep.re}{ A regular expression further restricting \code{src}
    (the files to be indexed).  For example, specifying
    \code{keep.re="/R/[^/]*\\\\.R$"} will only retain files with
    extension \code{.R} inside a directory named \code{R}.
  } 
  \item{ofile}{ Passed on to \code{\link{cat}} as the \code{file}
    argument; typically the output file where the tags will be written
    (\code{"TAGS"} by convention).  By default, the output is written to
    the R console (unless redirected).
  }
  \item{append}{ Logical, indicating whether the output should overwrite
    an existing file, or append to it.
  }
  \item{verbose}{ Logical.  If \code{TRUE}, file names are echoed to the
    R console as they are processed.
  }
}

\details{

  Many text editors allow definitions of functions and other language
  objects to be quickly and easily located in source files through a
  tagging utility.  This functionality requires the relevant source
  files to be preprocessed, producing an index (or tag) file containing
  the names and their corresponding locations.  There are multiple tag
  file formats, the most popular being the vi-style ctags format and the
  and emacs-style etags format.  Tag files in these formats are usually
  generated by the \code{ctags} and \code{etags} utilities respectively.
  Unfortunately, these programs do not recognize R code syntax.  They do
  allow tagging of arbitrary language files through regular expressions,
  but this too is insufficient.

  The \code{rtags} function is intended to be a tagging utility for R
  code.  It parses R code files (using R's parser) and produces tags in
  Emacs' etags format.  Support for vi-style tags is currently absent,
  but should not be difficult to add.
}

\references{
  \url{http://en.wikipedia.org/wiki/Ctags},
  \url{http://www.gnu.org/software/emacs/emacs-lisp-intro/html_node/emacs.html#Tags}
}
\author{Deepayan Sarkar}
\seealso{ \code{\link{list.files}}, \code{\link{cat}} }
\examples{

\dontrun{
rtags("/path/to/src/repository",
      pattern = "[.]*\\\\.[RrSs]$",
      keep.re = "/R/",
      verbose = TRUE,
      ofile = "TAGS",
      append = FALSE,
      recursive = TRUE)
}

}
\keyword{programming}
\keyword{utilities}

