#!/usr/bin/python

"""
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
"""

__version__ = "$Revision: 1.17 $"
# $Source: /cvsroot/quantlib/QuantLib-Python/QuantLib/test/swap.py,v $


from QuantLib import *
import unittest

class SimpleSwapTest(unittest.TestCase):
    def runTest(self):
        "Testing simple swap"
        import time
        gmt = time.gmtime(time.time())
        euriborHandle = TermStructureHandle()
        fixedRate = 0.0
        fixingDays = 0
        spread = 0.0
        today = Date(gmt[2],gmt[1],gmt[0])
        settlementDays = 2
        payFixed = 1
        years = 10
        indexFixingDays = 0
        nominal = 100.0
        rollingConvention = 'modifiedFollowing'
        fixedFrequency = 1; floatingFrequency = 2
        fixedDayCount = DayCounter('30/360'); fixedAdj = 0
        index = Euribor(12/floatingFrequency,'Months',euriborHandle)
        calendar = index.calendar()
        termStructure = FlatForward('EUR',DayCounter('Act/365'),today,
            calendar,settlementDays,0.05)
        settlement = termStructure.settlementDate()
        swap = SimpleSwap(payFixed, settlement, years, 'years', calendar,
            rollingConvention, nominal, fixedFrequency, fixedRate,
            fixedAdj, fixedDayCount, floatingFrequency, index, indexFixingDays,
            spread, euriborHandle)
        euriborHandle.linkTo(termStructure)
        impliedRate = fixedRate-swap.NPV()/swap.fixedLegBPS()
        impliedSpread = spread-swap.NPV()/swap.floatingLegBPS()
        # check 1
        swap = SimpleSwap(payFixed, settlement, years, 'years', calendar,
            rollingConvention, nominal, fixedFrequency, impliedRate,
            fixedAdj, fixedDayCount,floatingFrequency, index, indexFixingDays,
            spread, euriborHandle)
        NPV = swap.NPV()
        if not (abs(NPV) <= 1e-10):
            self.fail("""
recalculating with implied rate:
    calculated value: %(NPV)g
    expected value:   0.0
    tolerance exceeded
                      """ % locals())
        # check 2
        swap = SimpleSwap(payFixed, settlement, years, 'years', calendar,
            rollingConvention, nominal, fixedFrequency, fixedRate,
            fixedAdj, fixedDayCount,floatingFrequency, index, indexFixingDays,
            impliedSpread, euriborHandle)
        NPV = swap.NPV()
        if not (abs(NPV) <= 1e-10):
            self.fail("""
recalculating with implied spread:
    calculated value: %(NPV)g
    expected value:   0.0
    tolerance exceeded
                      """ % locals())


if __name__ == '__main__':
    import QuantLib
    print 'testing QuantLib', QuantLib.__version__, QuantLib.QuantLibc.__file__, QuantLib.__file__
    import sys
    suite = unittest.TestSuite()
    suite.addTest(SimpleSwapTest())
    if sys.hexversion >= 0x020100f0:
        unittest.TextTestRunner(verbosity=2).run(suite)
    else:
        unittest.TextTestRunner().run(suite)
    raw_input('press any key to continue')
