#!/usr/bin/python

"""
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
"""

__version__ = "$Revision: 1.13 $"
# $Source: /cvsroot/quantlib/QuantLib-Python/QuantLib/test/cliquet_option.py,v $

import QuantLib
import unittest
from math import exp

class CliquetOptionTest(unittest.TestCase):
    def runTest(self):
        "Testing cliquet option pricer"
        spot = 100
        divYield = 0.01
        rRate = 0.06
        dates = [0.50, 1.00, 2.00]
        vol = 0.35
        euro1 = QuantLib.EuropeanOption("Call", spot, spot, divYield,
                    rRate, dates[1]-dates[0], vol)
        w1 = exp(divYield*dates[0])

        euro2 = QuantLib.EuropeanOption("Call", spot, spot, divYield,
                    rRate, dates[2]-dates[1], vol)
        w2 = exp(divYield*dates[1])

        cliquet = QuantLib.CliquetOption("Call", spot, divYield, rRate,
                      dates, vol)
        # to do: comment on this approach and add method dividendRho
        for method in ['value', 'delta', 'gamma', 'theta', 'rho', 'vega']:
            euro1Method = getattr(euro1, method)
            euro2Method = getattr(euro2, method)
            cliquetMethod = getattr(cliquet, method)
            expected = w1*apply(euro1Method,()) + w2 * apply(euro2Method,())
            calculated = apply(cliquetMethod,())
            error = abs(calculated-expected)
            if not (error <= 1e-10):
                self.fail("""
wrong %(method)s
    calculated: %(calculated)f
    expected  : %(expected)f
	            """ % locals())


if __name__ == '__main__':
    print 'testing QuantLib', QuantLib.__version__, QuantLib.QuantLibc.__file__, QuantLib.__file__
    import sys
    suite = unittest.TestSuite()
    suite.addTest(CliquetOptionTest())
    if sys.hexversion >= 0x020100f0:
        unittest.TextTestRunner(verbosity=2).run(suite)
    else:
        unittest.TextTestRunner().run(suite)
    raw_input('press any key to continue')

