/***************************************************************************
                          txwindow.cpp  -  QSSTV
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "txwindow.h"

#include <qtoolbutton.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qwhatsthis.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qpaintdevicemetrics.h>
#include "sstvparam.h"
#include "ctext.h"
#include "filefunc.h"
#include "qsstvglobal.h"
#include "cpixmap.h"
#include "dirdialog.h"
#include "thumbwindow.h"
#include "qtooltip.h"
#include "paint.h"
#include "imageframe.h"
#include "vumeter.h"

txWindow::txWindow(QWidget *p ,const char *n, WFlags f):QMainWindow( p,n,f)
{
  printer = new QPrinter;
  mainTools = new QToolBar( this, "file operations" );
  sstvTools = new QToolBar("",this,QMainWindow::Left,FALSE);
  faxTools = new QToolBar("",this,QMainWindow::Bottom,TRUE);
  setToolBarsMovable ( FALSE);
  faxTools->hide();
  canvasX=canvasY=0;
  canvas = new imageFrame( this, "canvas" );
  QToolButton * fileOpen = new QToolButton( *fileOpenIcon, "Open File", 0,
					    this, SLOT(slotLoad()),
					    mainTools, "open file" );
  
  QToolButton * fileSave = new QToolButton( *fileSaveIcon, "Save File", 0,
					    this, SLOT(slotSave()),
					    mainTools, "save file" );
  
  QToolButton * filePrint = new QToolButton( *filePrintIcon, "Print File", 0,
					     this, SLOT(slotPrint()),
					     mainTools, "print file" );
  
  mainTools->addSeparator(); 
  QToolButton * sendtx  = new QToolButton( *startIcon, "Start Tx", 0,
					   this, SLOT(slotStart()),
					   mainTools, "send" ); 
  
  QToolButton * stoptx = new QToolButton( *stopIcon, "Stop Tx", 0,
					  this, SLOT(slotStop()),
					  mainTools, "stop transmit" );
  
  QToolButton * tonetx = new QToolButton( *toneIcon, "Send 1750Hz", 0,
					 this, SLOT(slotSend1750()),
					 mainTools, "" );
  
  QToolButton * erasetx = new QToolButton( *eraserIcon, "Erase", 0,
					   this, SLOT(slotErase()),
					   mainTools, "erase window" );
  
  QToolButton * edittx = new QToolButton( *editIcon, "Edit", 0,
					  this, SLOT(slotEdit()),
					  mainTools, "Edit window" );

  QToolButton * postx = new QToolButton( *posIcon, "Default Position", 0,
					   this, SLOT(slotPosition()),
					   mainTools, "pos" ); 


  QToolButton * zoomtx = new QToolButton( *zoomIcon, "Zoom", 0,
					   this, SLOT(slotZoom()),
					   mainTools, "zoom signal" );
  QToolButton * browsertx = new QToolButton( *browserIcon, "Browse", 0,
					   this, SLOT(slotBrowsetx()),
					   mainTools, "browse signal" );

  QToolButton * replaytx = new QToolButton( *replayIcon, "Replay", 0,
					   this, SLOT(slotReplay()),
					  mainTools, "replay signal" );

  QToolButton * cwtx = new QToolButton( *cwIcon, "Send CW", 0,
					   this, SLOT(slotCWsend()),
					   mainTools, "cwsignal" );
  sstvfax=new QComboBox(FALSE,mainTools);
  sstvfax->insertItem("SSTV");
  sstvfax->insertItem("FAX");
  modeSSTVFAXTX=SSTV;
  connect( sstvfax, SIGNAL(activated(int)), SLOT(slotSSTVFAX(int)) );	
 
  QLabel *f=new QLabel("",mainTools);
  mainTools->setStretchableWidget (f ) ; 
   
  progress= new VUMeter(statusBar());
  progress->setBackgroundColor(green);
  progress->setMaximumSize(QSize(80,32767));
  progress->setMinimumSize(QSize(80,10));
  progress-> UseNeedle(FALSE);
 
  progress->setProgress(0);
  QColorGroup normal(
	     qRgb(0,0x0,0xff),    // foreground
	     qRgb(0x0,0x80,0), // background
	     qRgb(0xa0,0xa0,0xa0), // light
	     qRgb(0x40,0x40,0x20), // dark
	     qRgb(0xa0,0xa0,0x40),  // mid
	     qRgb(0x0,0x0,0x0),    //text
	     qRgb(0x0,0xff,0x0)   //base
	     );
   progress->setPalette( QPalette(normal,normal,normal) );

   QLabel *faxLabel=new QLabel("Fax  ",faxTools);
   faxLabel->setFixedWidth(60);
   faxLabel->setAlignment(AlignRight);
   faxTypeComboBox= new QComboBox(FALSE,faxTools);
   faxTypeComboBox->insertItem(configFile.readOption("faxName1"));
   faxTypeComboBox->insertItem(configFile.readOption("faxName2"));
   faxTypeComboBox->insertItem(configFile.readOption("faxName3"));
   faxTypeComboBox->insertItem(configFile.readOption("faxName4"));
   QLabel *lpmLabel=new QLabel("lpm  ",faxTools);
   lpmLabel->setFixedWidth(40);
   lpmLabel->setAlignment(AlignRight);
   lpmSpinBox= new QSpinBox(10,600,10,faxTools);
   QLabel *iocLabel=new QLabel("ioc  ",faxTools);
   iocLabel->setFixedWidth(40);
   iocLabel->setAlignment(AlignRight);
   iocSpinBox= new QSpinBox(100,1000,2,faxTools);
   QLabel *colorLabel=new QLabel("Colors ",faxTools);
   colorLabel->setFixedWidth(50);
   colorLabel->setAlignment(AlignRight);
   colorComboBox= new QComboBox(FALSE,faxTools);
   colorComboBox->insertItem("2");
   colorComboBox->insertItem("4");
   colorComboBox->insertItem("8");
   colorComboBox->insertItem("16");
   colorComboBox->insertItem("32");
   colorComboBox->insertItem("64");
   colorComboBox->insertItem("128");
   colorComboBox->insertItem("256");
   
   QLabel *linesLabel=new QLabel("Lines ",faxTools);
   linesLabel->setFixedWidth(50);
   linesLabel->setAlignment(AlignRight);
   linesSpinBox= new QSpinBox(100,1600,10,faxTools);
   QLabel *faxs=new QLabel("",faxTools);	
  
   faxTools->setStretchableWidget (faxs ) ;
   connect(faxTypeComboBox,SIGNAL(highlighted(int)),this,SLOT(slotFaxTypeChanged(int)));
   slotFaxTypeChanged(0); // call to setup lpm and ioc

   QLabel *t=new QLabel(statusBar());
   t->setGeometry(0,0,100,25);
   statusBar()->addWidget(t,1,FALSE);
   statusBar()->addWidget(progress,1,TRUE);
   
   txMode=new QComboBox(sstvTools);
   for (int i=0;i<NUMBEROFTXMODES;i++)
     {
       txMode->insertItem(TXModesText[i]);
     }
   txBanners=new QComboBox(sstvTools);
   setupBanners();

   int itemp=lookupModeString(configFile.readOption("DefaultTxMode"));
   txMode->setCurrentItem(itemp); 
   connect( txMode, SIGNAL(activated(int)), SLOT(slotModeChange(int)) );
   connect( txBanners, SIGNAL(activated(int)), SLOT(slotBannerChange(int)) );
   sstvTools->addSeparator();
   QCheckBox *bannerButton=new QCheckBox("Banner",sstvTools);
   QCheckBox *timestampButton=new QCheckBox("Timestamp",sstvTools);
   QCheckBox *cwButton=new QCheckBox("CW",sstvTools);
   QCheckBox *voxButton=new QCheckBox("VOX",sstvTools);
   QLabel *fs=new QLabel("",sstvTools);
   sstvTools->setStretchableWidget (fs ) ;
   connect(bannerButton,SIGNAL(toggled(bool)),this,SLOT(slotBanner(bool)));
   connect(timestampButton,SIGNAL(toggled(bool)),this,SLOT(slotTimestamp(bool)));
   connect(cwButton,SIGNAL(toggled(bool)),this,SLOT(slotCW(bool)));
   connect(voxButton,SIGNAL(toggled(bool)),this,SLOT(slotVox(bool)));
   bannerButton->setChecked(buseBanner);
   timestampButton->setChecked(btimestamp);
   cwButton->setChecked(bCW);
   voxButton->setChecked(bVOX);


  (void)QWhatsThis::whatsThisButton( mainTools );
  
  addWT(fileOpen, fileOpenText);
  addWT(fileSave, fileSaveText);
  addWT(filePrint, filePrintText);
  addWT(sendtx, sendText);
  addWT(stoptx, stopTxText);
  addWT(tonetx, toneText);
  addWT(erasetx, eraseText);
  addWT(edittx, editText);
  addWT(zoomtx, zoomText);
  addWT(bannerButton, bannerText);
  addWT(timestampButton, timestampText);
  addWT(txMode,txmodeText);
  addWT(browsertx,browserTxText);
  addWT(cwtx,cwText);
  addWT(progress,progressText);
  addWT(replaytx,replayText);
  addWT(voxButton,voxText);
  addWT(cwButton,addCWText);
  addWT(txBanners,selectBannerText);
  addWT(postx,posText);
  addWT( sstvfax,sstvfaxText);

  QPopupMenu * file = new QPopupMenu();
  menuBar()->insertItem( "&File", file );
  
  file->insertItem( *fileOpenIcon, "Open", this, SLOT(slotLoad()), CTRL+Key_O );
  file->insertItem( *fileSaveIcon, "Save", this, SLOT(slotSave()), CTRL+Key_S );
  file->insertSeparator();
  file->insertItem( *filePrintIcon, "Print", this, SLOT(slotPrint()), CTRL+Key_P );
  file->insertSeparator();
  file->insertItem( "Quit", qApp, SLOT(quit()), CTRL+Key_Q );
  QPopupMenu * options = new QPopupMenu();
  menuBar()->insertItem( "&Options", options );
  options->insertItem( "Test frequency", this, SLOT(slotTestFrequency()), CTRL+Key_F );
  QToolTip::add( sstvfax, "SSTV or FAX selection" );
  QToolTip::add( txMode, "Transmission mode selection" );
  QToolTip::add( txBanners, "Banner selection" );
  QToolTip::add(bannerButton, "Enable banner" );
  QToolTip::add(timestampButton, "Enable timestamp" );
  QToolTip::add(cwButton, "Enable CW at end of transmission" );
  QToolTip::add(voxButton, "VOX delay before transmission" );

#ifdef  DEBUGQSSTV
  QPopupMenu *debug = new QPopupMenu();
  menuBar()->insertItem( "&Debug", debug );
  debug->insertItem( "Dump", this, SLOT(slotDump()), CTRL+Key_D );
  debug->insertItem( "Playback", this, SLOT(slotPlayback()), CTRL+Key_B );
#endif
  statusBar()->message( "Ready");
  int mc;
  configFile.readOption("DefaultTxMode",mc);
	bColor=QColor(borderColor/65536,(borderColor/256)&0xFF,borderColor&0xFF);
}

txWindow::~txWindow()
{
    delete printer;
}

void txWindow::setupBanners()
{
  QFileInfo t1 (configFile.readOption("Bannerimage1"));
  QFileInfo t2 (configFile.readOption("Bannerimage2"));
  QFileInfo t3 (configFile.readOption("Bannerimage3"));
  QFileInfo t4 (configFile.readOption("Bannerimage4"));
  txBanners->clear();
  txBanners->insertItem(t1.fileName());
  txBanners->insertItem(t2.fileName());
  txBanners->insertItem(t3.fileName());
  txBanners->insertItem(t4.fileName());
}

void txWindow::buildLayoutSSTV()
{
  faxTools->setEnabled(FALSE);
  faxTools->hide();
  initMode();
 // delete canvas; //regenerate layout
 // canvas = new imageFrame( this, "canvas");
  canvas->createImage(sstvparam.numberOfPixels,sstvparam.numberOfLines,32,sstvparam.numberOfPixels,sstvparam.numberOfLines);
  tw->setCanvas(canvas);
  setCanvasSize(460,sstvparam.numberOfLines+10);
  setCentralWidget(canvas);
}

void txWindow::buildLayoutFAX(int width,int height)
{
  faxTools->setEnabled(TRUE);
 // delete canvas; //regenerate layout
  faxTools->show();
 // canvas = new imageFrame( this, "canvas");
  canvas->createImage(width,height,32,600,480);
	tw->setCanvas(canvas);
  setCanvasSize(600,630);
  setCentralWidget(canvas);
}
  
 

bool  txWindow::load(const char *s,bool showError)
{
  return(canvas->load(s,showError));
}


void txWindow::setCanvasSize(int x,int y)
{
      setFixedSize(x,y);
      canvasX=x;
      canvasY=y;
}

void txWindow::slotFaxTypeChanged(int i)
{
	if(i==0)
		{
			lpmSpinBox->setValue(faxlpm1);
			iocSpinBox->setValue(faxioc1);
			colorComboBox->setCurrentItem(faxColors1-1);
			linesSpinBox->setValue(faxLines1);
		}
	else if(i==1)
		{
			lpmSpinBox->setValue(faxlpm2);
			iocSpinBox->setValue(faxioc2);
			colorComboBox->setCurrentItem(faxColors2-1);
			linesSpinBox->setValue(faxLines2);
		}
	else if(i==2)		
		{
			lpmSpinBox->setValue(faxlpm3);
			iocSpinBox->setValue(faxioc3);
			colorComboBox->setCurrentItem(faxColors3-1);
			linesSpinBox->setValue(faxLines3);
		}
	else
		{
			lpmSpinBox->setValue(faxlpm4);
			iocSpinBox->setValue(faxioc4);
			colorComboBox->setCurrentItem(faxColors4-1);
			linesSpinBox->setValue(faxLines4);
		}
		
}

void txWindow::slotSSTVFAX(int i)
{
	modeSSTVFAXTX=i;
}

void txWindow::slotSave()
{
  QDir stemp;
  QFileInfo t;
  QFile tempout;
  stemp.setPath(configFile.readOption("ImageTxDir"));
  if(openForWrite(tempout,stemp,"*"))
    { 
      tempout.remove();
      t.setFile(tempout.name());
      changeExtension(t,configFile.readOption("ImageFormat"),FALSE);
      canvas->save(t.filePath());
    } 
}

void txWindow::slotPrint()
{
  if ( printer->setup(this) )
    {
      canvas->pixmapToImage();
      QPixmap t;
      t=*(canvas->getImagePtr());
      QPainter paint( printer );
      paint.drawPixmap(30,30,t);
    }
}


void txWindow::slotLoad()
{
  QString fn;
  dirDialog dd(0,0,TRUE);
  fn=dd.openFileName(configFile.readOption("ImageTxDir"));
  if(!fn.isNull())
    {
  //    erase();
      canvas->load(QFileInfo(fn));
    }
}


void txWindow::slotErase()
{
  canvas->imageFill(ERASECOLOR);
}

void txWindow::slotEdit()
{
   paint *txPaint=new paint(0,canvasX,canvasY);
   txPaint->editImage(canvas);
   txPaint->show();
}

void txWindow::slotZoom()
{
  canvas->zoom();
}

void txWindow::slotCW(bool c)
{
  bCW=c;
}

void txWindow::slotPosition()
{
  canvas->setupPosition();
}


void txWindow::slotVox(bool c)
{
  bVOX=c;
}

void txWindow::slotBanner(bool c)
{
  buseBanner=c;
}

void txWindow::slotTimestamp(bool c)
{
  btimestamp=c;
}

void txWindow::slotBrowsetx()
{ 
 dirDialog dd(0,0,TRUE);
 dd.openFileName(configFile.readOption("ImageTxDir"));
}



void txWindow::slotReplay()
{
  QString t;
  QFileInfo *f;
  f=tw->getLatest();
  t=f->filePath(); 
  if (!t.isEmpty())
    {
      canvas->addImage(5,25,t,155,120);
    }
}


void txWindow::slotModeChange(int mc)
{
  configFile.setOption("DefaultTxMode",getMode(mc));
  buildLayoutSSTV();
  canvas->reload();
}

void txWindow::slotBannerChange(int mc)
{
  configFile.setOption("bannerNumber",mc);
}


void txWindow::initMode()
{
  initializeParamString(configFile.readOption("DefaultTxMode"));
}

void txWindow::modeChange(int mc)
{
  txMode->setCurrentItem(mc);
  slotModeChange(mc);
}



void txWindow::closeEvent(QCloseEvent *)
{
  
}













