#include "sstvtx.h"
#include "qsstvglobal.h"
#include <sys/ioctl.h>  
#include <unistd.h>
#include <fcntl.h>
#include <time.h> 
#include <qmessagebox.h>
#include "filefunc.h"
#include "synthes.h"
#include "sstvrx.h"
#include "freqdiag.h"
#include "imageframe.h"
#include "dirdialog.h"

#define MAGICNUMBER 0xA54917B9
// #define DEBUGSSTVTX

sstvTX::sstvTX(QWidget *p,const char *n, WFlags f) :txWindow(p,n,f),rxtxCommon()
{
	serial=MAGICNUMBER;
	isRunning=FALSE;
	timer=new QTimer(this);
	cwTX=new morse;
#ifdef  DEBUGQSSTV
	deb= new debugger();
#endif
	connect(dsp, SIGNAL(signalTXStopped()),this,SLOT(slotStopRequest()));
  initTransmit(TRUE);

}

sstvTX::~sstvTX()
{
  slotStop();
}

void sstvTX::initTransmit(bool buildLayout)
{
	initAllCounters();
	initSynthes();
	if (timer) delete timer;
	timer= new QTimer(this);
	if (modeSSTVFAXTX==SSTV)
		{
			if(buildLayout)
				{
					buildLayoutSSTV();
					// we delete imageframe in the buildlayout-> use connect again
//					connect(canvas,SIGNAL(mouseLeftButtonPressed(QMouseEvent *)),SLOT(slotLeftMouseBtn(QMouseEvent *)));
				}
			connect( timer, SIGNAL(timeout()),this,SLOT(slotSSTVEncode()));
		}
	else
		{
			sampleSum=0; pcounter=0;
			connect( timer, SIGNAL(timeout()),this,SLOT(slotFAXDecode()));
			//calculate the lineTime
			lineTime=60./lpmSpinBox->value();
			//calculate aspectratio
			// The aspectratio is given by the ioc
			// ioc is defined as total line length multiplied by
			// the number of lines per unitlength divided by PI
			// from there we calculate the number of pixels per line
			// lpu*ll/PI=ioc
			// lpu=ioc*PI/ll
			// we take lpu=1 (this is the case for square pixels
			// then ll= 288*3.1419 = 905
			// lpu=204
			pixelsPerLine=(unsigned int)(iocSpinBox->value()*M_PI+.5);
			if(buildLayout)
				{
					buildLayoutFAX(pixelsPerLine,linesSpinBox->value());
					// we delete imageframe in the buildlayout-> use connect again
					connect(canvas,SIGNAL(mouseLeftButtonPressed(QMouseEvent *)),SLOT(slotLeftMouseBtn(QMouseEvent *)));
				}
			time1PerPixel=lineTime/pixelsPerLine;
			videoBuffer0=canvas->getLineAddress(lineCounter);
		}
}

// this function is called when the transmit button is pressed
void sstvTX::slotStart()
{
	if (!isRunning)
    {	
			rx->slotStop();
	//		slotStop();
			dsp->initDSP(isamplingrate); //must be done before dsp starts filtering
			initTransmit(FALSE);
			if(!setupImage())
				{
					return;
				}
			gotoState(STARTPIC);
			isRunning=TRUE;
			dsp->startTransmit();
			activatePTT(TRUE);
			timer->start(100,TRUE);
		}
}

void sstvTX::slotStop()
{
   dsp->stop();  // will call slotStopRequest by signal from dsp
}

void sstvTX::slotStopRequest()
{
	if (isRunning)
		{
  		isRunning=FALSE;
  		activatePTT(FALSE);
  		progress->reset();
			if (dumpActive)
				{
					dumpActive=FALSE;
#ifdef  DEBUGQSSTV
  				deb->stop();
#endif
  				dsp->disableDump();
  			}
  		// callback to repeater or receiver
			emit signalTXEnd();
		}
}


void sstvTX::sendSingleTone()
{
	rx->slotStop();
//	slotStop();
	initTransmit(FALSE);
	dsp->initDSP(isamplingrate); //must be done before dsp starts filtering
	activatePTT(TRUE);
	if(timer) delete timer;
	timer=new QTimer(this);
	connect( timer, SIGNAL(timeout()),this,SLOT(slotToneEncode()));
	stateSampleCounter=0;
	isRunning=TRUE;
	dsp->startTransmit();
	timer->start(100,TRUE);
}


bool sstvTX::setupImage()
{
	const char *temp=0;
	const char *ltzone;
	QFileInfo t;
  char tempstr1[100];
  char tempstr2[50];
  tempstr1[0]=0; tempstr2[0]=0;
	if(modeSSTVFAXTX==SSTV)
		{
      initializeParamString(configFile.readOption("DefaultTxMode"));
      canvas->backup();
		  progress->setTotalSteps(sstvparam.numberOfLines);
			if(buseBanner)
   			{
     			switch(txBanners->currentItem())
						{
							case 0: temp="Bannerimage1"; break;
							case 1: temp="Bannerimage2"; break;
							case 2: temp="Bannerimage3"; break;
							case 3: temp="Bannerimage4"; break;
						}
					QString tst(configFile.readOption(temp));
					if (!tst.isEmpty())
						{
							fullFilename(t,QDir(QString(configFile.readOption("ImageTxDir"))),QString(configFile.readOption(temp)));
			    		canvas->addImage(0,0,t.filePath());
			    	}
			    else
			    		{
								QMessageBox::critical( 0, "QSSTV Transmit",
                           QString("No valid bannername specified in configuration file") +
                           "\n Correct this error first, or do not enable Send Banner\n"
                           "Transmit aborted" );
                 return FALSE;
			    		}
	 			}
			if(btimestamp)
	 			{
	   			QDateTime dt = QDateTime::currentDateTime();
	     		time_t t=time(0);
				  if (bUTC)
						{
		  				struct tm *ltm=localtime(&t); //  to calculate timezone
		  				ltzone="UTC";
		  				if(daylight && ltm->tm_isdst)
		    				{
							    dt=dt.addSecs((int)timezone-3600);
		    				}
		  				else
		    				{
		      				dt=dt.addSecs((int)timezone);
		    				}
						}
	      	else
						{
		  				struct tm *ltm=gmtime(&t); // to set tzname correctly
		  				if(daylight && ltm->tm_isdst)
		    				{
		      				ltzone=tzname[2];
		    				}
		  				else
		    				{
		      				ltzone=tzname[1];
		    				}
						}	
					sprintf(tempstr2,"%s %d, %d %02d:%02d %s",
		      		(const char *)dt.date().monthName(dt.date().month()),
		      			dt.date().day(),
		      			dt.date().year(),
		      			dt.time().hour(),
		      			dt.time().minute(),ltzone);
	    	}
	  	if (brepeater)
	    	{
	     		strcpy(tempstr1,configFile.readOption("RepeaterIDText"));
	    	}
	  	strcat(tempstr1,tempstr2);
	  	if(strlen(tempstr1)>0)
	    	{
	     		canvas->addString(4,sstvparam.numberOfLines-4,tempstr1,
					white,QFont("Helvetica",12,QFont::Bold));
	    	}
		}
	else  // FAX
		{
		}
	canvas->pixmapToImage();
	return TRUE;		
}


void sstvTX::slotToneEncode()
{
	if(sendTone(sendFrequency,sendDuration)!=RELEASESLOT)
		{
#ifdef DEBUGSSTVTX
			debug("sendsingletone end");
#endif
			if(!dumpActive)
	  		{
	    		dsp->delayedStop();
	    	}
	    else
	    	{
	    		slotStop();
	    	}
	    return ;
		}
#ifdef DEBUGSSTVTX
	debug("sendsingletone wait");
#endif
	timer->start(10,TRUE);
}

void sstvTX::slotSSTVEncode()
{
	int result=OK;
	int tone;
 	while(result!=RELEASESLOT)
		{
    	switch(state)
				{
					case STARTPIC:
	  				{
	    				visBits=0;
	    				visCode=sstvparam.VISCode;
	    				if (bVOX)
	      				{
									if((result=sendTone(1200,1))!=RELEASESLOT)
		  							{
		  								gotoState(F1900A);
		  							}
	      				}
	    				else
	      				{
		 							gotoState(F1900A);
	      				}
	  				}
	  			break;
					case F1900A:
	  				{
	    				if((result=sendTone(1900,0.3))!=RELEASESLOT)
	      				{
									gotoState(F1200A);
	      				}
	  				}
	  			break;
					case F1200A:
	  						{
	    						if((result=sendTone(1200,0.03))!=RELEASESLOT)
	      						{
											gotoState(F1900B);
	      						}
	  						}
	  			break;
					case F1900B:
	  						{
	    						if((result=sendTone(1900,0.3))!=RELEASESLOT)
	      						{
											gotoState(F1200B);
	      						}
	  						}
	  			break;
					case F1200B:
	  				{
	    				if((result=sendTone(1200,0.03))!=RELEASESLOT)
	      				{
									gotoState(VISDATA);
	      				}
	  				}
	  			break;
					case VISDATA:
	  				{
	    				if (visBits<8)
	      				{
#ifdef DEBUGSSTVTX
					debug("tx: visbits: %d",visBits);
#endif
									if (visCode&1==1) tone=1100; else tone=1300;
									if((result=sendTone(tone,0.03))!=RELEASESLOT)
      							{
											visBits++;
											visCode=visCode>>1;
											gotoState(VISDATA); // force reset tone generation
      							}
	      				}
	    				else
						    {
#ifdef DEBUGSSTVTX
					debug("tx: goto VISSTOP");
#endif						
									gotoState(VISSTOP);
	      				}
	  				}
	  			break;
					case VISSTOP:
	  				{
	    				if((result=sendTone(1200,0.03))!=RELEASESLOT)
	      				{
									imageSampleCounter=0;
									gotoState(PHASET0);
	      				}
	  				}
	  			break;
					case PHASET0:
	  				{
	  					calculateTiming();
							gotoState(getNextState(state));
						}
					case PHASET1:
						{	
				   		if((result=sendToneEndTime(sstvparam.hs.f,hsTime))!=RELEASESLOT)
	      				{
	      					progress->setProgress(lineCounter+1);
									gotoState(getNextState(state));
	      				}	
	  				}
	  			break;
					case PHASET2:
	  				{
	    				if((result=sendToneEndTime(sstvparam.bp.f,bpTime))!=RELEASESLOT)
	      				{
										gotoState(getNextState(state));
	      				}
	  				}
	  			break;
					case PHASET3:
	  				{
	  					if ((lineCounter==40)&&(dumpActive))
	  						{
	  							gotoState(ABORTTX);
	  						}
	  					else
	  						{
					    		extractPixels(REDLINE);
	    						gotoState(getNextState(state));
	    					}
	  				}
	  			break;
					case PHASET4:
	  				{
	    				extractPixels(GREENLINE);
	    				gotoState(getNextState(state));
	  				}
	  			break;
					case PHASET5:
	  				{
	    		    extractPixels(BLUELINE);
	    				gotoState(getNextState(state));
	  				}
	  			break;
					case PHASET6:
					case PHASET7:
						{
	    				if ((result=sendPixels(time1PerPixel))!=RELEASESLOT)
	      				{
									gotoState(getNextState(state));
	      				}			
	  				}
					break;
					case PHASET8:
	  				{
	    				if ((result=sendPixels(time2PerPixel))!=RELEASESLOT)
	      				{
									gotoState(getNextState(state));
	      				}			
	  				}
	  			break;
					case PHASET9:
	  				{
	    				if((sstvparam.colorScheme==XYZOE)&&((lineCounter&1)==1))
	      				{
									if((result=sendToneEndTime(sstvparam.f2.f,f1Time))!=RELEASESLOT)
		  							{
		    							gotoState(getNextState(state));
		  							}
	      				}
	    				else
	      				{
									if((result=sendToneEndTime(sstvparam.f1.f,f1Time))!=RELEASESLOT)
		  							{
		    							gotoState(getNextState(state));
		  							}
	      				}
	  				}
	  			break;
					case PHASETA:
	  				{
	    				if((result=sendToneEndTime(sstvparam.f2.f,f2Time))!=RELEASESLOT)
	      				{
									gotoState(getNextState(state));
	      				}
	  				}
	  			break;
					case PHASETB:
	  				{
	    				if((result=sendToneEndTime(sstvparam.f3.f,f3Time))!=RELEASESLOT)
	      				{
									gotoState(getNextState(state));
	      				}
	  				}
	  			break;

					case PHASETC:
	  				{
	    				if((result=sendToneEndTime(sstvparam.f4.f,f4Time))!=RELEASESLOT)
	      				{
									gotoState(getNextState(state));
	      				}
	  				}
	  			break;
					case PHASETD:
	  				{
	    				if((result=sendToneEndTime(sstvparam.f5.f,f5Time))!=RELEASESLOT)
	      				{
									gotoState(getNextState(state));
	      				}
	  				}
	  			break;
					case PHASETE:
	  				{
	    				if((result=sendToneEndTime(sstvparam.fp.f,fpTime))!=RELEASESLOT)
	      				{
										gotoState(getNextState(state));
	      				}
	  				}
	  			break;
					case NEXTXYZOE2:
					case NEXTRGB:
	  				{
	    				if (++lineCounter>=sstvparam.numberOfLines)
	      				{
									gotoState(ENDTX);
	      				}
	    				else
	      				{
									progress->setProgress(lineCounter);
									videoBuffer1=canvas->getLineAddress(lineCounter);
									gotoState(getNextState(state));
	      				}	
	  				}
	  			break;
					case NEXTXYZOE:
	  				{
	    				if (++lineCounter>=sstvparam.numberOfLines)
	      				{
									progress->reset();
									gotoState(ENDTX);
	      				}
	    				else
	      				{
									progress->setProgress(lineCounter);
									videoBuffer1=canvas->getLineAddress(lineCounter);
									gotoState(getNextState(state));
	      				}	
	  				}
	  			break;
					case ENDTX:
	  				{
	    				if((result=sendTone(1200,0.3))!=RELEASESLOT)
	      				{
									if (bCW)
		  							{
		    							cwTX->initCW();
		    							gotoState(SENDCWSPACE);
		  							}
									else
		  							{
		    							gotoState(ABORTTX);
		  							}
	      				}
	  				}
	  			break;
					case SENDCWSPACE:
	  				{
	    				if((result=sendCWTone(0,2))!=RELEASESLOT)
	      				{
									gotoState(SENDCW);
	      				}
	  				}
	  			break;
					case SENDCW:
	  				{
	    				if (cwTX->sendText(cwTone,cwDuration))
	      				{
									gotoState(SENDCWNEXT);
	      				}
	    				else
	      				{
									gotoState(ABORTTX);
	      				}
	  				}
	  			break;
					case SENDCWNEXT:
	  				{
	    				if((result=sendCWTone(cwTone,cwDuration))!=RELEASESLOT)
	      				{
									gotoState(SENDCW);
	      				}
	  				}
	  			break;
					case ABORTTX:
	  				{
	  					if(!dumpActive)
	  						{
	    						dsp->delayedStop();
	    					}
	    				else
	    					{
	    						slotStop();
	    					}
	    				return ;
	  				}
	 				break;
					default:
	  				{
	    				debug ("faulty tx state");
	    				gotoState(ABORTTX);
	  				}
				} // end switch
   } // end while
 timer->start(100,TRUE);
}

void sstvTX::slotFAXEncode()
{
}

void sstvTX::slotSSTVFAX(int i)
{
	modeSSTVFAXTX= i;
	slotStop();
	initTransmit(TRUE); // to update the layout
}

enum eRetVal sstvTX::sendTone(uint freq,double time)
{
	 while((time-((double)stateSampleCounter)/fTXsamplingrate)>(1/(2*fTXsamplingrate)))
    {
      if(put(angleValue)!=RELEASESLOT)
				{
	  			angleValue=getNextSample(freq);
				}
      else
				{
#ifdef DEBUGSSTVTX
					debug("sendtone: releasing slot");
#endif
	  			return(RELEASESLOT);
				}
    }
  return OK;
}

enum eRetVal sstvTX::sendToneEndTime(uint freq,double time)
{
  while((time-((double)imageSampleCounter)/fTXsamplingrate)>(1/(2*fTXsamplingrate)))
    {
      if(put(angleValue)!=RELEASESLOT)
				{
	  			angleValue=getNextSample(freq);
				}
      else
				{
	  			return(RELEASESLOT);
				}
    }
  return OK;
}

void sstvTX::activatePTT(bool b)
{
	const char *s;
	int modemlines;
	
	if ((dumpActive) || (bVOX)) return;
	if(serial==(int)MAGICNUMBER)
		{
			s=configFile.readOption("Comdev");
		  serial=open(s,O_RDONLY);
  		if (serial<=0)
    		{
      		QMessageBox::warning(this,"Serial Port Error",
			   	"Unable to open serial port \ncheck Options->Configuration\n"
			   	"make sure that you have read/write permission",
			   	QMessageBox::Ok,0 );
			   	return;
    		}
		}
	if(serial>0)
		{
			if(b)
				{
				ioctl(serial,TIOCMGET,&modemlines);
  			modemlines |= TIOCM_DTR;
  			modemlines |= TIOCM_RTS;
  			ioctl(serial,TIOCMSET,&modemlines);
	  		//	ioctl(serial,TIOCMBIS,&t);
				}
	 		else
	 			{
	 			
	 			ioctl(serial,TIOCMGET,&modemlines);
  			modemlines &= ~TIOCM_DTR;
  			modemlines &= ~TIOCM_RTS;
  			ioctl(serial,TIOCMSET,&modemlines);
	 			//	ioctl(serial,TIOCMBIC,&t);
	 			}
	 	}
}

void sstvTX::slotSend1750()
{
  if (!isRunning)
    {
      sendFrequency=1750;
      sendDuration=2.5;
      sendSingleTone();
    }
}

void sstvTX::slotTestFrequency()
{
  if (!isRunning)
    {
      freqdiag fd;
      if (fd.exec())
				{
	  			sendFrequency=fd.getFrequency();
	  			sendDuration=(double)fd.getDuration();
	  			sendSingleTone();
				}
    }
}


void sstvTX::closeEvent(QCloseEvent *)
{
  rx->close();
}

void sstvTX::gotoState(eTxRxState s)
{
#ifdef DEBUGSSTVTX
		debug("tx: gotoState: %s",stateString[s]);
#endif
	stateSampleCounter=0;
	pixelCounter=0;
	state=s;

}


// CW functions
void sstvTX::sendCWstr(const char *s)
{
  if (!isRunning)
    {
			rx->slotStop();
			slotStop();
			cwTX->initCW(s);
			dsp->initDSP(isamplingrate); //must be done before dsp starts filtering
			if(timer) delete timer;
			timer=new QTimer();
			connect( timer, SIGNAL(timeout()),this,SLOT(slotSSTVEncode()));
			dsp->startTransmit();
			activatePTT(TRUE);
			gotoState(SENDCWSPACE);
			isRunning=TRUE;
			timer->start(0,TRUE);
    }
}

void sstvTX::slotCWsend()
{
  sendCWstr(0);
}



enum eRetVal sstvTX::sendCWTone(uint freq,double time)
{

  while((stateSampleCounter/fTXsamplingrate)<time)
    {
    	// attack and decay calculation
      angleValue=((stateSampleCounter/fTXsamplingrate)<0.005?
		  (int)((double)angleValue*(((double)stateSampleCounter/fTXsamplingrate)/0.005)):
		  angleValue);

      angleValue=((time-stateSampleCounter/fTXsamplingrate)<0.005?
		  (int)((double)angleValue*((time-(double)stateSampleCounter/fTXsamplingrate)/0.005)):
		  angleValue);
      if(freq==0)
				{
					angleValue=0;
				}
      if(put(angleValue)!=RELEASESLOT)
				{
	  			angleValue=getNextSample(freq);
				}
      else
				{
	  			return(RELEASESLOT);
				}
    }
  return OK;
}

enum eRetVal sstvTX::put(short int s )
{
	if(dsp->put(s))
		{
			imageSampleCounter++;
			stateSampleCounter++;
#ifdef DEBUGQSSTV
			sampleCounter++;
#endif
			return OK;
		}
  return RELEASESLOT;
}


void sstvTX::extractPixels(uint lineColor)
{
  int i;
  int y,x;
  videoBuffer1=canvas->getLineAddress(lineCounter);
  if (lineColor==REDLINE)
    {
      if ((sstvparam.colorScheme==XYZOE)||(sstvparam.colorScheme==XYZOE2))
				{
	  			for (i=0;i<sstvparam.numberOfPixels;i++)
	    			{
	      			y=(59*qGreen(videoBuffer1[i])+30*qRed(videoBuffer1[i])+11*qBlue(videoBuffer1[i]))/100;
	      			pixelbuf[i]=(1500+(y*VIDEOBW)/255);
	    			}
				}
      else
				{
	  			for (i=0;i<sstvparam.numberOfPixels;i++)
	    			{
	      			pixelbuf[i]=(1500+(qRed(videoBuffer1[i])*VIDEOBW)/255);
	    			}
				}
    }
  else if (lineColor==GREENLINE)
    {
      if (sstvparam.colorScheme==XYZOE)
				{
	  			for (i=0;i<sstvparam.numberOfPixels;i++)
	    			{
	     				y=(59*qGreen(videoBuffer1[i])+30*qRed(videoBuffer1[i])+11*qBlue(videoBuffer1[i]));
	      			if ((lineCounter&1)==0)
								{
		  						videoBuffer0=canvas->getLineAddress(lineCounter+1);
		  						x=(100*( qRed(videoBuffer1[i]))-y+17850)/140;
								}
	      			else
								{
		  						videoBuffer0=canvas->getLineAddress((lineCounter-1));
		  						x=(100*(qBlue(videoBuffer1[i]))-y+22695)/178;
								}
	      			pixelbuf[i]=(1500+(x*VIDEOBW)/255);
	    			}
				}

      else if (sstvparam.colorScheme==XYZOE2)
				{
	  			for (i=0;i<sstvparam.numberOfPixels;i++)
	    			{
	      			y=(59*qGreen(videoBuffer1[i])+30*qRed(videoBuffer1[i])+11*qBlue(videoBuffer1[i]));
	      			x=(100*qRed(videoBuffer1[i])-y+17850)/140;
	      			pixelbuf[i]=(1500+(x*VIDEOBW)/255);
	    			}
				}
			else
				{
	  			for (i=0;i<sstvparam.numberOfPixels;i++)
	    			{
	      			pixelbuf[i]=(1500+(qGreen(videoBuffer1[i])*VIDEOBW)/255);
	    			}
				}
  	}

	else if (lineColor==BLUELINE)
    {
      if (sstvparam.colorScheme==XYZOE2)
				{
	  			for (i=0;i<sstvparam.numberOfPixels;i++)
	   				{
	     				y=(59*qGreen(videoBuffer1[i])+30*qRed(videoBuffer1[i])+11*qBlue(videoBuffer1[i]));
	     				x=(50*(qBlue(videoBuffer1[i])+qBlue(videoBuffer1[i]))-y+22695)/178;
	     				pixelbuf[i]=(1500+(x*VIDEOBW)/255);
	   				}
				}
      else
				{
	  			for (i=0;i<sstvparam.numberOfPixels;i++)
	    			{
	      			pixelbuf[i]=(1500+(qBlue(videoBuffer1[i])*VIDEOBW)/255);
	    			}
				}
    }
}

enum eRetVal sstvTX::sendPixels(double pixTime)
{
  uint freq;

  while(pixelCounter<sstvparam.numberOfPixels)
    {
  		  	
      if(put(angleValue)!=RELEASESLOT)
				{
					freq=pixelbuf[pixelCounter];
	  			angleValue=getNextSample(freq);
	  			pixelCounter=(uint)(((double)stateSampleCounter/fTXsamplingrate)/pixTime);
				}
      else
				{
	  			return(RELEASESLOT);
				}
    }
  return OK;
}

short int sstvTX::getNextSample(uint freq)
{
	int i;
	i=nextSample(freq);
#ifdef DEBUGQSSTV
	if(dumpActive)
		{
			if(freq>2300)
				{
					debug("illegal value");
				}
			sample=(float)freq;
			sendToDebugger();
		}
#endif
	return i;
}


void sstvTX::slotDump()
{
#ifdef  DEBUGQSSTV
	QString fn;
  dirDialog dd(0,0,TRUE);
  slotStop();
  fn=dd.openFileName(configFile.readOption("SoundDir"),"*.raw");
  if(!fn.isNull())
    {
    	dsp->enableDump(NULL,fn);
			if(deb->openForWrite(fn,"tx.dmp"))
				{
					dsp->initDSP(isamplingrate);
					initTransmit(FALSE);
					setupImage();
					sendFrequency=1200;
					sendDuration=9;
					
//					sendSingleTone();
//					dsp->startTransmit();
//					timer->start(0,TRUE);
					if(timer) delete timer;
					timer=new QTimer(this);
					connect( timer, SIGNAL(timeout()),this,SLOT(slotSSTVEncode()));
					stateSampleCounter=0;
					isRunning=TRUE;
					dsp->startTransmit();
					dumpActive=TRUE;
					timer->start(0,TRUE);
					
				}
			else
				{
					dsp->disableDump();
					slotStop();
				}
    }
#endif
}


void sstvTX::slotPlayback()
{
#ifdef  DEBUGQSSTV
 QDir stemp;
 QFileInfo t;
 if (!isRunning)
    {
      stemp.setPath(configFile.readOption("SoundDir"));
      if(!openForRead(frawout,stemp,"*.raw"))
				{
	  			return;
				}
      timer = new QTimer(this);
      connect( timer, SIGNAL(timeout()),this,SLOT(slotNextBuf()) );
      dsp->initDSP(isamplingrate);
			if(dsp->startTransmit())
				{
      		timer->start(2,TRUE);
      	}
      else
      	{
      		frawout.close();
      	}
    }
#endif
}

void sstvTX::slotNextBuf()
{
#ifdef  DEBUGQSSTV
	while (dsp->put(isample))
		{
			if (frawout.readBlock((char *)&isample,sizeof(short int))<=0)
				{
					frawout.close();
	 				dsp->delayedStop();
	  			return;
				}
		}
	timer->start(20,TRUE);
#endif
}	









