/***************************************************************************
                          pixmapview.cpp  -  QSSTV
                             -------------------
    begin                : Wed Jun 13 2001
    copyright            : (C) 2001 by Johan Maes
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pixmapview.h"
#include <qimage.h>

//#define DEBUGPIXMAPVIEW

pixmapView::pixmapView(QWidget *parent, const char *name ) : QScrollView(parent,name)
{
//		setResizePolicy(AutoOneFit);
		pixmap.resize(320,256);
		viewport()->setBackgroundMode( PaletteBase );
}

pixmapView::~pixmapView()
{
	
}

void pixmapView::setPixmap( const QPixmap &pix )
{
    pixmap = pix;
    setNewSize( pixmap.size().width(), pixmap.size().height() );
}

void pixmapView::setNewSize(int w, int h)
{
#ifdef DEBUGPIXMAPVIEW
		debug(" pxmA %d, %d",pixmap.width(),pixmap.height());
#endif
		pixmap.resize(w,h);
	  resizeContents( w,h) ;
//	  QScrollView::resize(w,h);
#ifdef DEBUGPIXMAPVIEW
	  debug(" pxmB %d, %d  -- %d, %d",pixmap.width(),pixmap.height(),w,h);
#endif
    viewport()->repaint( FALSE );
}

void pixmapView::drawContents( QPainter *p, int , int , int , int )
{
	p->drawPixmap(0,0, pixmap);
}

void pixmapView::fullDrawContents()
{
	viewport()->repaint( FALSE );
}

void pixmapView::showLine(QImage *image,int width,int line)
{
  if ((line<image->height())&&(width<=image->width()))
    {
      QPainter p(&pixmap);
      p.drawImage(0,line,*image,0,line,width,1);
			viewport()->repaint( FALSE );
    }
}


void pixmapView::showLine(QImage *image,int width,int line,int nbrlines)
{
  if (((line+nbrlines)<image->height())&&(width<=image->width()))
    {
      QPainter p(&pixmap);
      p.drawImage(0,line,*image,0,line,width,nbrlines);
			viewport()->repaint( FALSE );
    }
}

void pixmapView::clearToBottom(int startLine,QColor color)
{
  QPainter paint;
  if(!pixmap.isNull())
  	{
  		paint.begin(&pixmap);
  			{
    			QRect r(0,startLine,pixmap.width(),pixmap.height());
#ifdef DEBUGPIXMAPVIEW
    			debug(" pxm %d, %d",pixmap.width(),pixmap.height());
#endif
    			paint.fillRect(r,color);
  			}
  		paint.end();
  		viewport()->repaint(FALSE);
  	}
}


